(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {
    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//--------------------- SOLICITAR EXISTENCIA  -------------------
//***************************************************************
    $('.out-of-stock').each(function () {
      var a = $(this).find('button').clone().addClass('not-delete solicitar-existencia').attr('type', 'button').removeAttr('disabled');
      $(this).find('div:not(.form-group)').append(a);
      $(this).find('button:not(.not-delete)').remove();
    });

    $(document).on('click', '.solicitar-existencia', function () {
      var main_container;

      // El grid-20 aparece en la tienda de inicio (la vista clonada de la tienda), si no está, entonces buscar ahora en col-md-3 que es de la vista de la tienda
      if ($(this).closest('form').closest('.grid-20').length == 0) {
        main_container = $(this).closest('form').closest('.col-md-3');
      } else {
        main_container = $(this).closest('form').closest('.grid-20');
      }
      var product_name = main_container.find('.hidden_product_name span a').html();
      var product_url = 'https://www.pcpartners.com.mx' + main_container.find('.hidden_product_name span a').attr('href');
      var product_img = main_container.find('.views-field-field-product-image').find('img').attr('src');

      var envio = {};
      envio.product_img = product_img;
      envio.product_name = product_name;
      envio.product_url = product_url;

      var html = '<div class="row">' +
        '<div class="col-md-3">' +
        '<img src="' + product_img + '" alt="Imagen del producto" class="img-responsive">' +
        '</div>' +
        '<div class="col-md-9 text-left">' +
        '<b>' + product_name + '</b>' +
        '</div>' +
        '</div>' +
        '<div class="row">' +
        '<div class="col-md-12 text-left">' +
        '<br><small>Ingresa tus datos y nos pondremos en contacto.</small>' +
        '</div>' +
        '</div>' +
        '<div class="row"><div class="col-md-12"><input type="email" class="swal2-input cliente_correo" placeholder="Correo"></div></div>' +
        '<div class="row"><div class="col-md-12"><input type="text" class="swal2-input cliente_nombre" placeholder="Nombre"></div></div>' +
        '<div class="row"><div class="col-md-12"><input type="text" class="swal2-input cliente_telefono" placeholder="Teléfono"></div></div>' +
        '';
      swal({
        title: 'Solicitar Existencia',
        html: html,

        showCancelButton: true,
        confirmButtonText: 'Enviar',
        showLoaderOnConfirm: true,
        cancelButtonText: 'Cancelar',
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve, reject) {
            if (validateEmail($('.cliente_correo').val())) {
              envio.cliente_email = $('.cliente_correo').val();
              envio.cliente_nombre = $('.cliente_nombre').val();
              envio.cliente_telefono = $('.cliente_telefono').val();

              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.website.ruta_consultas + 'solicitar_existencia',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            } else {
              reject("Ingresa un correo válido");
            }


          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal("Bien!", "Nos pondremos en contacto contigo en cualquier momento.", "success");
        }
      });
    });


//***************************************************************
//--------------------- SOLICITAR EXISTENCIA  -------------------
//***************************************************************

  });
})
(jQuery);