(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

//***************************************************************
//----------------------- BUSCADOR DOMINIO  ---------------------
//***************************************************************

        // Filtrado - Texto
        $(document).on('keyup', '.search_domain', function (e) {
            $('.domain_search_container .sk-folding-cube').removeClass('hidden');
            clearTimeout($.data(this, 'timer'));
            if (e.keyCode == 13)
                search_domain(true);
            else
                $(this).data('timer', setTimeout(search_domain, 400));
        });

        function search_domain() {
            // Validaciones y formato de string del dominio
            var StringtoSearch = $(".search_domain").val();
            $('.result_domain_container').html('');
            if (StringtoSearch.length > 60) {
                iziToast.error({
                    position: "topRight",
                    title: "Error",
                    message: "El nombre de dominio debe ser menor a 63 caracteres!"
                });
                $('.domain_search_container .sk-folding-cube').addClass('hidden');
                return false;
            }

            if (/^-|-$/m.test(StringtoSearch)) {
                iziToast.error({
                    position: "topRight",
                    title: "Error",
                    message: "El dominio no puede iniciar o terminar con un guion!"
                });
                $('.domain_search_container .sk-folding-cube').addClass('hidden');
                return false;
            }

            // Quitar todos despues del . para eliminar los tld
            StringtoSearch = StringtoSearch.split('.')[0];

            if (/[^a-zA-Z\d:-]/m.test(StringtoSearch)) {
                iziToast.error({
                    position: "topRight",
                    title: "Error",
                    message: "El nombre del dominio puede contener solo caracteres alfanuméricos y guiones medios!"
                });
                $('.domain_search_container .sk-folding-cube').addClass('hidden');
                return false;
            }


            if (StringtoSearch) {
                $.ajax({
                    type: 'POST',
                    url: settings.website.ruta_consultas + 'domain_search',
                    data: JSON.stringify(StringtoSearch),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.status == 'success') {
                            $('.domain_search_container .sk-folding-cube').addClass('hidden');
                            var table = '<table class="table-sm table table-bordered table-condensed table-hover table-striped ">';
                            table += '<thead>' +
                                '<tr class="bg-primary">' +
                                '<td>Dominio</td>' +
                                '<td>Disponibilidad</td>' +
                                '<td>Detalles</td>' +
                                '</tr>' +
                                '</thead>' +
                                '<tbody>';
                            table += response.message;
                            table += '</tbody></table>';
                            $('.result_domain_container').html(table);
                        } else if (response.status == 'error') {
                            iziToast.error({
                                title: "Error",
                                message: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        iziToast.error({
                            title: "Ocurrio un error: ",
                            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                    }
                });
            } else {
                // Limpiar la tabla que aparece con los resultados del dominio
                $('.domain_search_container .sk-folding-cube').addClass('hidden');
            }

        }


//***************************************************************
//----------------------- BUSCADOR DOMINIO  ---------------------
//***************************************************************


    });
})
(jQuery);