(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

    var ruta_url = settings.web.ruta_sys_tools + 'inline_edit';
    partnersEditableContent(ruta_url, function () {
      autoUpdate.forceUpdate();
    });

    // Sentry Error reporting test
    /*
     var x = 1;
     try {
     if (x == 1) {
     console.log(2);
     throw "es menor a 1";
     }
     }
     catch (err) {
     Raven.captureException(err);
     Raven.showReportDialog();
     }
     */
    //***************************************************************
    //----------------- REPORTE BASE PROYECTOS WEB ------------------
    //***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'id_proyecto'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        usuario: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_web').stickyTableHeaders();
          $('#table_reporteador_web').partnersfilter({
            table: '#table_reporteador_web',
            sumatory: true,
            sumatory_cols: ["col-precio", "col-costo"],

          });

          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      r_options.filter.usuario = null;
      $('.input_buscador_web').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_web', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_web").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }


    // Filtrado - Usuario
    $(document).on('change', '#filtrado_usuario', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.usuario = $(this).find('option:selected').val();
      autoUpdate.forceUpdate();
    });
    //***************************************************************
    //----------------- REPORTE BASE PROYECTOS WEB ------------------
    //***************************************************************


    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************


    //***************************************************************
    //---------------------- NUEVO PROYECTO WEB  --------------------
    //***************************************************************
    $(document).on('click', '.nuevo_proyecto_web', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Nuevo Proyecto Web',
        ajaxUrl: settings.web.render_template + 'web.nuevo_proyecto',
        forceWidth: 60,
        modalId: 'vista-nuevo-proyecto-modal',
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $('#buscar_cliente').typeahead({
              order: "asc",
              minlength: 1,
              maxItem: 15,
              hint: true,
              accent: true,
              group: {
                template: "{{group}}"
              },
              maxItemPerGroup: 5,
              backdrop: {
                "background-color": "#fff"
              },
              template: function (query, item) {
                var color_t_clasificacion;
                var tipo_clasificacion = item.tipo_clasificacion;
                var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                switch (tipo_clasificacion) {
                  case 'a':
                    color_t_clasificacion = "success";
                    break;
                  case 'b':
                    color_t_clasificacion = "success";
                    break;
                  case 'c':
                    color_t_clasificacion = "warning";
                    break;
                  case 'd':
                    color_t_clasificacion = "danger";
                    break;
                  case 'e':
                    color_t_clasificacion = "danger";
                    break;
                  case "p":
                    color_t_clasificacion = "success";
                    credito_contado =
                      "Saldo: " +
                      (item.saldo_horas != 1
                        ? item.saldo_horas + " horas"
                        : item.saldo_horas + " hora");

                    break;
                }
                tipo_clasificacion = tipo_clasificacion.toUpperCase();

                if (item.tipo_cliente != 3) {
                  return '<p>' +
                    '<span>{{nombre_cliente}}</span> ' +
                    '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
                    '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                    ' | ' + credito_contado + '</span> </p> ';
                } else {
                  return '<p><span>{{nombre_cliente}}</span> </p> ';
                }
              },
              dynamic: true,
              dropdownFilter: "Todos",
              emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
              source: {
                "Clientes": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.web.ruta_lista_clientes + 'complete',
                    path: "data.datos.clientes"
                  }
                },
                "Contactos": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.web.ruta_lista_clientes + 'complete',
                    path: "data.datos.contactos"
                  }
                },
                "Proveedores": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.web.ruta_lista_clientes + 'complete',
                    path: "data.datos.proveedores"
                  }
                }
              },
              callback: {
                onClickAfter: function (node, a, item) {
                  var color_t_clasificacion;
                  var tipo_clasificacion = item.tipo_clasificacion;
                  var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                  switch (tipo_clasificacion) {
                    case 'a':
                      color_t_clasificacion = "success";
                      break;
                    case 'b':
                      color_t_clasificacion = "success";
                      break;
                    case 'c':
                      color_t_clasificacion = "warning";
                      break;
                    case 'd':
                      color_t_clasificacion = "danger";
                      break;
                    case 'e':
                      color_t_clasificacion = "danger";
                      break;
                    case "p":
                      color_t_clasificacion = "success";
                      credito_contado =
                        "Saldo: " +
                        (item.saldo_horas != 1
                          ? item.saldo_horas + " horas"
                          : item.saldo_horas + " hora");

                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();
                  if (item.tipo_cliente != 3) {
                    $('.quick_info_client').html('<span class="badge badge-' + color_t_clasificacion + '">' +
                      '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                      ' | ' + credito_contado + '</span> </p> ');
                    const id_cliente = item.id_cliente;
                    prepareEvs(1, {
                      color_t_clasificacion,
                      tipo_clasificacion,
                      credito_contado,
                      id_cliente,
                      settings,
                    });
                  }

                  //Bindear el id del cliente al input
                  node.attr('data-id-cliente', item.id_cliente);
                  node.attr('data-email-cliente', item.email);

                  // Generar lista contactos solo para clientes Negocio/Distribuidor
                  if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                    generar_contactos(settings.web.ruta_lista_contactos, item.id_cliente);

                    //Solamente agrega este attr cuando debe de tener contactos
                    node.attr('data-tipo-negocio', item.tipo_negocio);
                  } else {
                    $('.contacto_container').hide();
                    $('.select_lista_contactos').empty();
                  }
                },
                onSearch: function (node, a) {
                  if (a !== '') {
                  } else {
                    // Para prevenir errores de sobrescribir o duplicar
                    $('.contacto_container').hide();
                    $('.select_lista_contactos').empty();
                    $('.quick_info_client').html('');
                    node.removeAttr('data-id-cliente');
                    node.removeAttr('data-tipo-negocio');
                    node.removeAttr('data-email-cliente');
                  }


                }

              }
            });
            $.validate({
              form: '#nuevo_proyecto_web_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });
          }, 400);


        }
      });
    });
    //***************************************************************
    //---------------------- NUEVO PROYECTO WEB  --------------------
    //***************************************************************


    //***************************************************************
    //---------------------- CAPTURAR PROYECTO WEB  -----------------
    //***************************************************************
    $(document).on('submit', '#nuevo_proyecto_web_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var datos = $('#nuevo_proyecto_web_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      if (!$('#buscar_cliente').attr('data-id-cliente')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un Cliente'
        });
        return false;
      }

      if ($('#buscar_cliente').attr('data-tipo-negocio')) {
        if ($('.select_lista_contactos').find('option:selected').val() == 0) {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona un Contacto'
          });
          return false;
        }
      }

      datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
      datosEnvio.id_contacto = $('.select_lista_contactos').find('option:selected').val();

      btn.partnersBtnControl('start');

      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'capturar_proyecto',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#vista-nuevo-proyecto-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //---------------------- CAPTURAR PROYECTO WEB  -----------------
    //***************************************************************


    //***************************************************************
    //------------------------- VISTA PROYECTO WEB  -----------------
    //***************************************************************
    $(document).on('click', '.vista_proyecto', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      $(this).partnersModal({
        title: 'Proyecto Web ' + id_proyecto,
        modalId: 'vista-proyecto-modal',
        forceWidth: 60,
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'vista_proyecto',
        data: id_proyecto,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-proyecto-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //------------------------- VISTA PROYECTO WEB  -----------------
    //***************************************************************


    //***************************************************************
    //---------------------- STATUS REVISIÓN CLIENTE  ---------------
    //***************************************************************
    $(document).on('click', '.status_revision_cliente', function () {
      var $this = $(this);
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var new_val = ($(this).parents('tr').attr('data-revision-cliente') == 1) ? 0 : 1;
      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.new_val = new_val;
      envio.col = 'revision_cliente';
      swal({
        title: 'Observaciones',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar una observación!');
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.web.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          if ($this.hasClass('status-red')) {
            $this.removeClass('status-red');
            $this.addClass('status-green');
            $this.html('Si');
          } else if ($this.hasClass('status-green')) {
            $this.removeClass('status-green');
            $this.addClass('status-red');
            $this.html('No');
          }
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      })
    });
    //***************************************************************
    //---------------------- STATUS REVISIÓN CLIENTE  ---------------
    //***************************************************************


    //***************************************************************
    //------------------------ STATUS TERMINADO ---------------------
    //***************************************************************
    $(document).on('click', '.status_terminado', function () {
      var $this = $(this);
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var new_val = ($(this).parents('tr').attr('data-terminado') == 1) ? 0 : 1;
      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.new_val = new_val;
      envio.col = 'terminado';
      swal({
        title: 'Observaciones',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar una observación!');
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.web.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          if ($this.hasClass('status-red')) {
            $this.removeClass('status-red');
            $this.addClass('status-green');
            $this.html('Si');
          } else if ($this.hasClass('status-green')) {
            $this.removeClass('status-green');
            $this.addClass('status-red');
            $this.html('No');
          }
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      })
    });
    //***************************************************************
    //------------------------ STATUS TERMINADO ---------------------
    //***************************************************************


    //***************************************************************
    //-------------------------- STATUS PROBLEMA --------------------
    //***************************************************************
    $(document).on('click', '.status_problema', function () {
      var $this = $(this);
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var new_val = ($(this).parents('tr').attr('data-problema') == 1) ? 0 : 1;
      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.new_val = new_val;
      envio.col = 'problema';
      swal({
        title: 'Cuál es el problema?',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes detallar el problema!');
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.web.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          if ($this.hasClass('status-red')) {
            $this.removeClass('status-red');
            $this.addClass('status-green');
            $this.html('No');
          } else if ($this.hasClass('status-green')) {
            $this.removeClass('status-green');
            $this.addClass('status-red');
            $this.html('Si');
          }
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });
    });
    //***************************************************************
    //-------------------------- STATUS PROBLEMA --------------------
    //***************************************************************


    //***************************************************************
    //-------------------------- STATUS PAGADO ----------------------
    //***************************************************************
    $(document).on('click', '.status_facturado', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var template = '<div class="row">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning proyecto_no_pagado w-100" data-id-proyecto="' + id_proyecto + '" role="button">No</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-success proyecto_pagado w-100" data-id-proyecto="' + id_proyecto + '" role="button">Pagado</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-info proyecto_facturado w-100" data-id-proyecto="' + id_proyecto + '" role="button">Facturado</button></div>' +
        '</div>';


      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 25,
        modalId: 'modal-pagado-web',
        noFooter: true
      });
    });

    $(document).on('click', '.proyecto_no_pagado', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var clicked_td = $('tr[data-id-proyecto="' + id_proyecto + '"] .status_facturado');
      $('#modal-pagado-web .modal-body').html(loader);
      var envio = {};
      envio.new_val = 0;
      envio.id_proyecto = id_proyecto;
      envio.col = 'facturado';
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            $('#modal-pagado-web').modal('hide');
            clicked_td.removeClass('status-green');
            clicked_td.addClass('status-red');
            clicked_td.html('No');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.proyecto_pagado', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var clicked_td = $('tr[data-id-proyecto="' + id_proyecto + '"] .status_facturado');
      $('#modal-pagado-web .modal-body').html(loader);
      var envio = {};
      envio.new_val = 1;
      envio.id_proyecto = id_proyecto;
      envio.col = 'facturado';
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            $('#modal-pagado-web').modal('hide');
            clicked_td.removeClass('status-red');
            clicked_td.addClass('status-green');
            clicked_td.html('Pagado');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.proyecto_facturado', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var clicked_td = $('tr[data-id-proyecto="' + id_proyecto + '"] .status_facturado');
      $('#modal-pagado-web').modal('hide');

      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.new_val = 2;
      envio.col = 'facturado';
      swal({
        title: 'Número de factura',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un número de factura!');
            } else {
              envio.obs = 'Se marcó como como facturado con el número de factura: ' + reason;
              envio.facturado = 1;
              envio.numero_factura = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.web.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Factura');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });

    });
    //***************************************************************
    //-------------------------- STATUS PAGADO ----------------------
    //***************************************************************


    //***************************************************************
    //------------------------ WEB OBSERVACIONES --------------------
    //***************************************************************
    $(document).on('click', '.status_obs', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      $(this).partnersObs(
        {
          modalId: 'modal-web-observaciones',
          ajaxUrl: settings.web.ruta_sys_tools + 'load_obs',
          index: 'id_proyecto',
          id_index: id_proyecto,
          tabla: 'partners_web',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });
    //***************************************************************
    //------------------------ WEB OBSERVACIONES --------------------
    //***************************************************************


    //***************************************************************
    //-------------------------- STATUS COSTO  ----------------------
    //***************************************************************
    $(document).on('click', '.status_costo', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.col = 'costo';
      swal({
        title: 'Costo',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        showLoaderOnConfirm: true,
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un costo!');
            } else {
              if (isNaN(reason)) {
                reject('Debes ingresar un costo válido.')
              } else {
                envio.new_val = reason;
                envio = JSON.stringify(envio);
                $.ajax({
                  type: 'POST',
                  url: settings.web.ruta_consultas + 'update_status',
                  data: envio,
                  contentType: "application/json; charset=utf-8",
                  dataType: "json",
                  success: function (response) {
                    if (response.status == 'success') {
                      resolve();
                    } else if (response.status == 'error') {
                      iziToast.error({
                        title: "Error",
                        message: response.message
                      });
                    }
                  },
                  error: function (xhr) {
                    iziToast.error({
                      title: "Ocurrio un error: ",
                      message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                  }
                });
              }

            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      })
    });
    //***************************************************************
    //-------------------------- STATUS COSTO  ----------------------
    //***************************************************************


    //***************************************************************
    //------------------------- ELIMINAR PROYECTO  ------------------
    //***************************************************************
    $(document).on('click', '.eliminar_proyecto', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var dominio = $(this).parents('tr').attr('data-dominio');
      swal({
        title: "Estás Seguro?",
        html: "Deseas eliminar el proyecto web: " + dominio + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: 'POST',
              url: settings.web.ruta_consultas + 'eliminar_proyecto',
              data: id_proyecto,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  autoUpdate.forceUpdate();
                  setTimeout(function () {
                    undo_proyecto_deleted(dominio, id_proyecto);
                    swal.close();
                  }, 2000);
                  resolve()
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal("Eliminado!", "El proyecto Web se ha eliminado correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_proyecto_deleted(dominio, id_proyecto) {
      iziToast.show({
        title: 'Proyecto: ' + dominio,
        message: ' ha sido eliminado.',
        position: 'bottomLeft',
        timeout: 10000,
        color: 'dark',
        progressBarColor: 'rgb(0, 255, 184)',
        icon: 'fa fa-ban',
        buttons: [
          ['<button data-id-proyecto="' + id_proyecto + '" data-dominio="' + dominio + '" class="proyecto_undo_delete">Deshacer</button>', function (instance, toast) {
            instance.hide({
              transitionOut: 'fadeOutUp',
            }, toast, 'close');
          }]
        ],
      });
    }

    $(document).on('click', '.proyecto_undo_delete', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var dominio = $(this).attr('data-dominio');
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'reactivate_proyecto',
        data: id_proyecto,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Proyecto ' + dominio,
              message: ' ha sido traido de vuelta a la vida!',
              icon: 'fa fa-code'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
    //***************************************************************
    //------------------------- ELIMINAR PROYECTO  ------------------
    //***************************************************************


    //***************************************************************
    //------------------- PROYECTOS WEB INFORM ERRORS ---------------
    //***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.web.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
    //***************************************************************
    //------------------- PROYECTOS WEB INFORM ERRORS ---------------
    //***************************************************************

    //***************************************************************
    //------------------------ WEB VER FACTURA  ---------------------
    //***************************************************************
    $(document).on('click', '.ver_factura', function () {
      var id_factura = $(this).text();
      $(this).partnersModal({
        title: 'Factura ' + id_factura,
        modalId: 'vista-factura',
        forceWidth: 90,
        content: loader
      });
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_sys_tools + 'get_full_factura',
        data: JSON.stringify(id_factura),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            if (response.message == "not_on_server") {
              var content = "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content = '<div>' +
                '<iframe src="/system/tools/vista_factura?factura=' + response.message + '" width="100%;" height="600px;"></iframe>' +
                '</div>';
            }
            $('#vista-factura .modal-body').html(content);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //------------------------ WEB VER FACTURA  ---------------------
    //***************************************************************

  });
})
  (jQuery);
