(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var ruta_url = settings.web.ruta_sys_tools + 'inline_edit';

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//----------------- REPORTE BASE DOMINIOS WEB -------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'dominio'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        usuario: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'reporte_base_dominios_web',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_dominio_web').partnersfilter({
            table: '#table_reporteador_dominio_web'
          });

          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_dominios_web', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_dominios_web").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

//***************************************************************
//----------------- REPORTE BASE DOMINIOS WEB -------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();

    // Filtrado - Mostrtar todos
    $(document).on('change', '.filtro_mostrar_todos', function () {
      if ($(this).is(':checked')) {
        r_options.filter.show_all = 1;
      } else {
        r_options.filter.show_all = 0;
      }
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      autoUpdate.forceUpdate();
    });
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//--------------------- GENERAR SESIÓN CPANEL -------------------
//***************************************************************
    $(document).on('click', '.cpanel_create_user_session', function () {
      var tipoHosting = $(this).parents('tr').attr('data-hosting');
      var user = $(this).parents('tr').attr('data-user');
      var datos = {};
      datos.tipoHosting = tipoHosting;
      datos.user = user;
      datos = JSON.stringify(datos);
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'cpanel_create_user_session',
        data: datos,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            window.open(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//--------------------- GENERAR SESIÓN CPANEL -------------------
//***************************************************************

//***************************************************************
//------------------------ COPY TO CLIPBOARD --------------------
//***************************************************************
    $(document).on('click', '.copy_to_clipboard', function () {
      var $temp = $("<input>");
      var $this = $(this);
      $("body").append($temp);
      $temp.val($(this).text()).select();
      document.execCommand("copy");
      $temp.remove();
      $this.tooltip({
        trigger: 'click',
        placement: 'top'
      });

      $this.tooltip('hide')
        .attr('data-original-title', "Copiado!")
        .tooltip('show');
      setTimeout(function () {
        $this.tooltip('dispose');
      }, 1000);
    });
//***************************************************************
//------------------------ COPY TO CLIPBOARD --------------------
//***************************************************************


//***************************************************************
//-------------------------- EDITAR DOMINIO ---------------------
//***************************************************************
    $(document).on('click', '.editar_dominio', function () {
      var id_dominio = $(this).parents('tr').attr('data-id');
      var dominio = $(this).parents('tr').attr('data-dominio');
      $(this).partnersModal({
        title: 'Dominio:' + dominio,
        modalId: 'vista-dominio-modal',
        forceWidth: 60,
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'vista_dominio',
        data: id_dominio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-dominio-modal .modal-body').html(response.message);
            init_edit();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });

    function init_edit() {
      // Set Defaults
      $.fn.editable.defaults.mode = 'inline';
      $.fn.editable.defaults.emptytext = "Vacío";
      $.fn.editable.defaults.url = ruta_url;
      $.fn.editable.defaults.send = "always";
      $.fn.editable.defaults.ajaxOptions = {
        type: 'POST',
        contentType: "application/json; charset=utf-8",
        dataType: "json"
      };
      $.fn.editable.defaults.success = function (response) {
        if (response.status == 'success') {
          iziToast.success({
            title: "Bien! ",
            message: response.message
          });
          autoUpdate.forceUpdate();
        } else if (response.status == 'error') {
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      };
      $.fn.editable.defaults.params = function params(params, el) {
        var element = $(el);
        console.log(element);
        console.log(params);
        var p = {};
        p.edit_table = element.data('edit-table');
        p.edit_col = element.data('edit-column');
        p.edit_table_key = element.data('edit-table-key');
        p.edit_id = element.data('edit-id');
        p.new_val = params.value;
        if (element.data('date-to-timestamp')) {
          p.new_val = moment(params.value, 'DD/MM/YYYY').unix();
        } else {
          p.new_val = params.value;
        }
        console.log(p);
        return p;
      };

      // Destroy All
      $('.editable-text-field').editable('destroy');
      $('.editable-textarea-field').editable('destroy');


      // Text Field
      $('.editable-text-field').editable({
        type: 'text'
      });

      // Custom Tipo Hosting Select Field
      $('.editable-custom-hosting').editable({
        values: $('.editable-custom-hosting').html(),
        source: [
          {value: 1, text: 'Reseller'},
          {value: 2, text: 'VPS'},
          {value: 3, text: 'A2Hosting'},
          {value: 4, text: 'Otro'},
          {value: 5, text: 'Parqueado'}
        ],
        type: 'select'
      });

      // Custom Dominio Partners Select Field
      $('.editable-custom-dominio-partners').editable({
        values: $('.editable-custom-dominio-partners').html(),
        source: [
          {value: 0, text: 'No'},
          {value: 1, text: 'Si'},
        ],
        type: 'select'
      });

      // Custom Hosting Partners Select Field
      $('.editable-custom-hosting-partners').editable({
        values: $('.editable-custom-hosting-partners').html(),
        source: [
          {value: 0, text: 'No'},
          {value: 1, text: 'Si'},
        ],
        type: 'select'
      });


      // Custom Fecha expira dominio Field
      $('.editable-custom-fecha-expira-dominio').editable({
        type: 'date',
        format: "dd/mm/yyyy",
        tpl: '<div class="input-append date"><input type="text" class="w-75 form-control float-left"><span class="float-left add-on" style="padding:10px; border: 1px solid #ced4da; border-radius: .25rem; background-color: #e9ecef;"><i class="fas fa-calendar-alt"></i></span></div></div>',
        datepicker: {
          format: "dd/mm/yyyy",
          todayBtn: "linked",
          autoclose: true,
          todayHighlight: true,
          orientation: "auto",
        }
      });

      // Custom Fecha expira hosting Field
      $('.editable-custom-fecha-expira-hosting').editable({
        type: 'date',
        format: "dd/mm/yyyy",
        tpl: '<div class="input-append date"><input type="text" class="w-75 form-control float-left"><span class="float-left add-on" style="padding:10px; border: 1px solid #ced4da; border-radius: .25rem; background-color: #e9ecef;"><i class="fas fa-calendar-alt"></i></span></div></div>',
        datepicker: {
          format: "dd/mm/yyyy",
          todayBtn: "linked",
          autoclose: true,
          todayHighlight: true,
          orientation: "auto",
        }
      });


    }

//***************************************************************
//-------------------------- EDITAR DOMINIO ---------------------
//***************************************************************

//***************************************************************
//-------------------------- NUEVO DOMINIO ----------------------
//***************************************************************
    $(document).on('click', '.nuevo_dominio_web', function () {
      $(this).partnersModal({
        title: 'Nuevo Dominio Web',
        ajaxUrl: settings.web.render_template + 'web.nuevo_dominio_web',
        forceWidth: 60,
        modalId: 'vista-nuevo-dominio-modal',
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nuevo_dominio_web_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });
          }, 400);
        }
      });
    });
//***************************************************************
//-------------------------- NUEVO DOMINIO ----------------------
//***************************************************************


//***************************************************************
//------------------------ CAPTURAR DOMINIO ---------------------
//***************************************************************
    $(document).on('submit', '#nuevo_dominio_web_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#nuevo_dominio_web_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'capturar_dominio_web',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var id_dominio = response.message;
            iziToast.success({
              title: "Bien! ",
              message: 'Se capturó correctamente el dominio'
            });
            $('#vista-nuevo-dominio-modal').modal('hide');
            autoUpdate.forceUpdate();
            // Siempre preguntar si quiere agregar una renovación
            Swal({
              title: 'Quieres crear una renovación?',
              type: 'question',
              showCancelButton: true,
              confirmButtonColor: '#5cb85c',
              cancelButtonColor: '#d9534f',
              confirmButtonText: 'Si!',
              cancelButtonText: 'No',
            }).then((result) => {
              if (result.value) {
                window.open(`/renovaciones?nueva_renovacion=true&id_dominio=${id_dominio}&dominio=${datosEnvio.dominio}`);
              }
            });

          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------ CAPTURAR DOMINIO ---------------------
//***************************************************************


//***************************************************************
//----------------------- STATUS OBSERVACIONES ------------------
//***************************************************************
    $(document).on('click', '.dominios-observaciones', function () {
      var id_dominio = $(this).parents('tr').attr('data-id');
      $(this).partnersObs(
        {
          modalId: 'modal-dominios-observaciones',
          ajaxUrl: settings.web.ruta_sys_tools + 'load_obs',
          index: 'id_dominio',
          id_index: id_dominio,
          tabla: 'partners_dominios_web',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );

    });
//***************************************************************
//----------------------- STATUS OBSERVACIONES ------------------
//***************************************************************


//***************************************************************
//-------------------- ENVIAR CPANEL SESSION CORREO -------------
//***************************************************************
    $(document).on('click', '.send-cpanel-session', function () {
      var user = $(this).parents('tr').attr('data-user');
      var hosting = $(this).parents('tr').attr('data-hosting');
      var dominio = $(this).parents('tr').attr('data-dominio');

      // Primero traer todos los correos de soporte para despues preguntar a que correo
      // se necesita enviar el url.
      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'get_emails_soporte',
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var datos = response.message;
            var inputOptions = {};
            datos.map(function (v) {
              inputOptions[v.mail] = `${v.name}, ${v.mail}`;
            });

            var envio = {};
            envio.tipoHosting = hosting;
            envio.user = user;
            envio.dominio = dominio;


            swal({
              title: 'Enviar sesión de cPanel',
              input: 'select',
              html: 'Selecciona un técnico:',
              inputOptions: inputOptions,
              showLoaderOnConfirm: true,
              onOpen: function () {
                fixBootstrapModal();
              },
              onClose: function () {
                $('body').removeAttr('style');
                restoreBootstrapModal();
              },
              preConfirm: function (val) {
                return new Promise(function (resolve) {
                  if (!val)
                    throw new Error("Selecciona un técnico!");

                  envio.correo = val;
                  console.log(envio);
                  $.ajax({
                    type: 'POST',
                    url: settings.web.ruta_consultas + 'send_cpanel_session',
                    data: JSON.stringify(envio),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                      if (response.status == 'success') {
                        iziToast.success({
                          title: "Bien! ",
                          message: response.message
                        });
                        resolve();
                      } else if (response.status == 'error') {
                        iziToast.error({
                          title: "Error",
                          message: response.message
                        });
                      }
                    },
                    error: function (xhr) {
                      iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                      });
                    }
                  });

                }).catch(function (error) {
                  swal.showValidationError(error);
                });
              },
            }).then(function (a) {
              if (!a.dismiss) {
                swal.close();
              }
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//-------------------- ENVIAR CPANEL SESSION CORREO -------------
//***************************************************************


//***************************************************************
//------------------------ ELIMINAR DOMINIO ---------------------
//***************************************************************
    $(document).on('click', '.eliminar_dominio', function () {
      var id_dominio = $(this).parents('tr').attr('data-id');
      var dominio = $(this).parents('tr').attr('data-dominio');
      swal({
        title: "Estás Seguro?",
        html: "Deseas eliminar el dominio: " + dominio + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
          restoreBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            var envio = {};
            envio.id_dominio = id_dominio;
            envio = JSON.stringify(envio);
            $.ajax({
              type: 'POST',
              url: settings.web.ruta_consultas + 'eliminar_dominio_web',
              data: envio,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  autoUpdate.forceUpdate();
                  resolve()
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal("Eliminado!", "El dominio se ha eliminado correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });

//***************************************************************
//------------------------ ELIMINAR DOMINIO ---------------------
//***************************************************************


//***************************************************************
//----------------------- VISTA DATOS CLIENTE -------------------
//***************************************************************
    $(document).on('click', '.vista_datos_cliente', function () {
      var id_dominio = $(this).parents('tr').attr('data-id');

      $(this).partnersModal({
        title: 'Datos Cliente',
        modalSize: 'modal-lg',
        modalId: 'vista-datos-cliente',
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.web.ruta_consultas + 'vista_datos_cliente',
        data: JSON.stringify(id_dominio),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-datos-cliente .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//----------------------- VISTA DATOS CLIENTE -------------------
//***************************************************************


  });
})
(jQuery);