(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {
    $(".rslides1").responsiveSlides({
      auto: false,
      nav: true,
      navContainer: ".pendientes_nav",
      prevText: "Pendiente anterior",
      nextText: "Pendiente siguiente",
    });
    $(".rslides2").responsiveSlides({
      auto: false,
      nav: true,
      navContainer: ".clientes_eliminar",
      prevText: "Cliente anterior",
      nextText: "Cliente siguiente",
    });
    $(".prev").addClass("btn btn-primary");
    $(".next").addClass("btn btn-primary");
    $('.inner .container-fluid:first').addClass('p-0');
    $('.inner .container-fluid:first .row:first').addClass('no-gutters');
    //***************************************************************
    //----------------------------- CHARTS --------------------------
    //***************************************************************

    /*
     var ctx = $("#myChart");
     var ctx2 = $("#myChart2");

     var myChart = new Chart(ctx, {
     type: 'line',
     data: {
     labels: ["Semana 1", "Semana 2", "Semana 3", "Semana 4"],
     datasets: [
     {
     label: "Servicios",
     fill: false,
     lineTension: 0.1,
     backgroundColor: "rgba(75,192,192,0.4)",
     borderColor: "rgba(75,192,192,1)",
     borderCapStyle: 'butt',
     borderDash: [],
     borderDashOffset: 0.0,
     borderJoinStyle: 'miter',
     pointBorderColor: "rgba(75,192,192,1)",
     pointBackgroundColor: "#fff",
     pointBorderWidth: 1,
     pointHoverRadius: 5,
     pointHoverBackgroundColor: "rgba(75,192,192,1)",
     pointHoverBorderColor: "rgba(220,220,220,1)",
     pointHoverBorderWidth: 2,
     pointRadius: 1,
     pointHitRadius: 10,
     data: [6, 17, 21, 15],
     spanGaps: true,
     }
     ]
     },
     options: {}
     });
     var myChart2 = new Chart(ctx2, {
     type: 'radar',
     data: {
     labels: ["Erick Inc", "Erick", "Microsoft", "Apple", "Bimbo", "Pc Partners", "Sony"],
     datasets: [
     {
     label: "Total Servicios",
     backgroundColor: "rgba(179,181,198,0.2)",
     borderColor: "rgba(179,181,198,1)",
     pointBackgroundColor: "rgba(179,181,198,1)",
     pointBorderColor: "#fff",
     pointHoverBackgroundColor: "#fff",
     pointHoverBorderColor: "rgba(179,181,198,1)",
     data: [65, 59, 90, 81, 56, 55, 40]
     },

     ]
     },
     options: {}
     });

     setInterval(function () {
     myChart.data.datasets[0].data[2] = Math.floor((Math.random() * 100) + 1) ;
     myChart.update();

     myChart2.data.datasets[0].data[2] = Math.floor((Math.random() * 100) + 1) ;
     myChart2.update();
     }, 1000);


     */


    //***************************************************************
    //----------------------------- CHARTS --------------------------
    //***************************************************************

    //***************************************************************
    //------------------------- CHANGE USER NIP  --------------------
    //***************************************************************
    var err_count = 0;
    $.validate({
      form: '#change_user_current_nip',
      errorMessageClass: 'invalid-feedback',
      inputParentClassOnError: 'text-danger',
      inputParentClassOnSuccess: 'text-success',
      errorElementClass: 'is-invalid'
    });
    $.validate({
      form: '#create_user_nip',
      errorMessageClass: 'invalid-feedback',
      inputParentClassOnError: 'text-danger',
      inputParentClassOnSuccess: 'text-success',
      errorElementClass: 'is-invalid'
    });
    $(document).on('submit', '#change_user_current_nip', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#change_user_current_nip').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.user.ruta_consultas + 'change_nip',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#change_user_current_nip').get(0).reset();
            err_count = 0;
            btn.partnersBtnControl('end');
            $('.wrong_pass_container').hide();
          } else if (response.status == 'error') {
            btn.partnersBtnControl('end');
            err_count += 1;
            iziToast.error({
              title: "Error",
              message: response.message
            });
            if (err_count > 2) {
              $('.wrong_pass_container').show();
            }

          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('submit', '#create_user_nip', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#create_user_nip').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.user.ruta_consultas + 'create_nip',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            swal(
              'Bien!',
              'Haz creado tu NIP correctamente!',
              'success'
            );
            setTimeout(function () {
              window.location.replace('/');
              swal.close();
            }, 2000);
          } else if (response.status == 'error') {
            btn.partnersBtnControl('end');
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //------------------------- CHANGE USER NIP  --------------------
    //***************************************************************

    //***************************************************************
    //---------- INICIALIZAR GENERADOR DE ORDENES DE PAGO  ----------
    //***************************************************************
    (function () {
      $.validate({
        form: '#nueva_orden_form',
        errorMessageClass: 'invalid-feedback',
        inputParentClassOnError: 'text-danger',
        inputParentClassOnSuccess: 'text-success',
        errorElementClass: 'is-invalid'
      });

      $('#buscar_cliente').typeahead({
        order: "asc",
        minlength: 1,
        maxItem: 15,
        hint: true,
        accent: true,
        group: {
          template: "{{group}}"
        },
        maxItemPerGroup: 5,
        backdrop: {
          "background-color": "#fff"
        },
        template: function (query, item) {
          var color_t_clasificacion;
          var tipo_clasificacion = item.tipo_clasificacion;
          var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
          switch (tipo_clasificacion) {
            case 'a':
              color_t_clasificacion = "success";
              break;
            case 'b':
              color_t_clasificacion = "success";
              break;
            case 'c':
              color_t_clasificacion = "warning";
              break;
            case 'd':
              color_t_clasificacion = "danger";
              break;
            case 'e':
              color_t_clasificacion = "danger";
              break;
            case "p":
              color_t_clasificacion = "success";
              credito_contado =
                "Saldo: " +
                (item.saldo_horas != 1
                  ? item.saldo_horas + " horas"
                  : item.saldo_horas + " hora");

              break;
          }
          tipo_clasificacion = tipo_clasificacion.toUpperCase();

          if (item.tipo_cliente != 3) {
            return '<p>' +
              '<span>{{nombre_cliente}}</span> ' +
              '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
              '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
              ' | ' + credito_contado + '</span> </p> ';
          } else {
            return '<p><span>{{nombre_cliente}}</span> </p> ';
          }

        },
        dynamic: true,
        dropdownFilter: "Todos",
        emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
        source: {
          "Clientes": {
            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
            ajax: {
              url: settings.user.ruta_lista_clientes + 'complete',
              path: "data.datos.clientes",
            }
          },
          "Contactos": {
            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
            ajax: {
              url: settings.user.ruta_lista_clientes + 'complete',
              path: "data.datos.contactos",
            }
          },
          "Proveedores": {
            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
            ajax: {
              url: settings.user.ruta_lista_clientes + 'complete',
              path: "data.datos.proveedores",
            }
          }
        },
        callback: {
          onClickAfter: function (node, a, item, event) {
            var color_t_clasificacion;
            var tipo_clasificacion = item.tipo_clasificacion;
            var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
            switch (tipo_clasificacion) {
              case 'a':
                color_t_clasificacion = "success";
                break;
              case 'b':
                color_t_clasificacion = "success";
                break;
              case 'c':
                color_t_clasificacion = "warning";
                break;
              case 'd':
                color_t_clasificacion = "danger";
                break;
              case 'e':
                color_t_clasificacion = "danger";
                break;
              case "p":
                color_t_clasificacion = "success";
                credito_contado =
                  "Saldo: " +
                  (item.saldo_horas != 1
                    ? item.saldo_horas + " horas"
                    : item.saldo_horas + " hora");

                break;
            }
            tipo_clasificacion = tipo_clasificacion.toUpperCase();
            if (item.tipo_cliente != 3) {
              $('.quick_info_client').html('<span class="badge badge-' + color_t_clasificacion + '">' +
                '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                ' | ' + credito_contado + '</span> </p> ');
            }


            //Bindear el id del cliente al input
            node.attr('data-id-cliente', item.id_cliente);
            node.attr('data-tipo-cliente', item.tipo_cliente);
            node.attr('data-email-cliente', item.email);

            // Generar lista contactos solo para clientes Negocio/Distribuidor
            if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
              generar_contactos(settings.user.ruta_lista_contactos, item.id_cliente);

              //Solamente agrega este attr cuando debe de tener contactos
              node.attr('data-tipo-negocio', item.tipo_negocio);
            } else {
              $('.contacto_container').hide();
              $('.select_lista_contactos').empty();
            }

          },
          onSearch: function (node, a, item, event) {
            if (a == '') {
              // Para prevenir errores de sobrescribir o duplicar
              $('.contacto_container').hide();
              $('.select_lista_contactos').empty();
              $('.quick_info_client').html('');
              node.removeAttr('data-id-cliente');
              node.removeAttr('data-tipo-negocio');
              node.removeAttr('data-email-cliente');
            }


          }
        }
      });

    })();
    //***************************************************************
    //---------- INICIALIZAR GENERADOR DE ORDENES DE PAGO  ----------
    //***************************************************************


    //***************************************************************
    //--------------------- GENERAR ORDEN DE PAGO  ------------------
    //***************************************************************
    $(document).on('submit', '#nueva_orden_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var datos = $('#nueva_orden_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      if (!$('#buscar_cliente').attr('data-id-cliente')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un Cliente'
        });
        return false;
      }

      if ($('#buscar_cliente').attr('data-tipo-negocio')) {
        if ($('.select_lista_contactos').find('option:selected').val() == 0) {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona un Contacto'
          });
          return false;
        }
      }

      btn.partnersBtnControl('start');

      datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
      datosEnvio.id_contacto = $('.select_lista_contactos').find('option:selected').val();

      var email_contacto = ($('.select_lista_contactos').find('option:selected').attr('data-email-contacto')) ? $('.select_lista_contactos').find('option:selected').attr('data-email-contacto') : '';
      var email_cliente = $('#buscar_cliente').attr('data-email-cliente');
      var email_user = $(this).attr('data-email-user');
      datosEnvio.email_cliente = email_cliente;
      datosEnvio.email_contacto = email_contacto;
      datosEnvio.tipo_cliente = $('#buscar_cliente').attr('data-tipo-cliente');
      datosEnvio.tipo_negocio = $('#buscar_cliente').attr('data-tipo-negocio');
      datosEnvio.cantidad_orden = numeral($('input[name="cantidad_orden"]').val()).value();


      var use_mail = (email_contacto == '') ? email_cliente : email_contacto;

      swal({
        title: "Orden de Pago",
        html: "Se enviará una orden de pago a los siguientes correos por una cantidad de: <b>" + datosEnvio.cantidad_orden + "</b>",
        input: 'text',
        confirmButtonText: 'Enviar!',
        cancelButtonText: 'Cancelar',
        showLoaderOnConfirm: true,
        showCancelButton: true,
        inputClass: 'emails_to_send',
        allowOutsideClick: true,
        allowEscapeKey: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        onOpen: function () {
          fixBootstrapModal();
          $('input[type="text"].emails_to_send').val(use_mail + ',' + email_user);
          $('input[type="text"].emails_to_send').focus();
          $('input[type="text"].emails_to_send').tagsinput();
          $('input[type="text"].emails_to_send').on('beforeItemAdd', function (event) {
            if (!validateEmail(event.item)) {
              event.cancel = true;
            }
          });
        },
        preConfirm: function (inputValue) {
          return new Promise(function (resolve, reject) {
            if (inputValue === false || !inputValue || inputValue == '' || inputValue == undefined) {
              reject('Ingresa al menos un correo!')
            } else {
              var emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
              datosEnvio.emails = emails_arr;
              var envio = JSON.stringify(datosEnvio);

              $.ajax({
                type: 'POST',
                url: settings.user.ruta_consultas + 'generar_orden',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        }
      }).then(function (a) {
        if (!a.dismiss) {
          var emails = $('input[type="text"].emails_to_send').val();
          var emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
          var timeout = emails_arr.length * 800;
          swal.close();

          var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';

          iziToast.show({
            message: x,
            position: 'center',
            timeout: timeout,
            progressBar: false,
            color: 'dark',
            icon: 'fa fa-envelope-open-o',
            iconColor: '#fff'
          });
          var morphext = $("#js-rotating").Morphext({
            animation: "fadeInDownCustom",
            separator: ",",
            speed: 800
          });
          var data;

          data = morphext.data("plugin_Morphext");
          setTimeout(function () {
            data.stop();
          }, timeout - 800);

          setTimeout(function () {
            swal({
              title: "Bien!",
              text: 'Orden de Pago enviada a los correos correctamente.',
              type: 'success',
              timer: 3000,
              showConfirmButton: false
            });
            setTimeout(function () {
              location.reload();
            }, 3000);
          }, timeout);
        } else if (a.dismiss == 'cancel') {
          swal.close();
          btn.partnersBtnControl('end');
        }
      });
    });
    //***************************************************************
    //--------------------- GENERAR ORDEN DE PAGO  ------------------
    //***************************************************************


  });
})
  (jQuery);
