(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

        var loader = '<div class="sk-cube-grid"> ' +
            '<div class="sk-cube sk-cube1"></div> ' +
            '<div class="sk-cube sk-cube2"></div> ' +
            '<div class="sk-cube sk-cube3"></div> ' +
            '<div class="sk-cube sk-cube4"></div> ' +
            '<div class="sk-cube sk-cube5"></div> ' +
            '<div class="sk-cube sk-cube6"></div> ' +
            '<div class="sk-cube sk-cube7"></div> ' +
            '<div class="sk-cube sk-cube8"></div> ' +
            '<div class="sk-cube sk-cube9"></div> </div>';
//***************************************************************
//------------------------- REPORTE BASE  -----------------------
//***************************************************************

        // Auto Update
        var autoUpdate = new AutoUpdate({
            toUpdate: function () {
                reporte_base();
            },
            interval: 60,
            iddle_after: 120
        });

        // Reporte base Options
        var r_options = {
            sort: {
                order: 'ASC',
                sort_by: 'id_registro'
            },
            automatic_update: 1,
            updating: 0,
            filter: {
                search_bar: null,
            }
        };


        function reporte_base() {
            if (r_options.automatic_update !== 1) {
                $('#reporteador').find('.table').css('opacity', 0.5);
            }
            $.ajax({
                type: 'POST',
                url: settings.taller.ruta_consultas + 'reporte_base_buscador',
                data: JSON.stringify(r_options),
                contentType: "application/json; charset=utf-8",
                success: function (data) {
                    $('#reporteador').html(data);
                    $('#table_reporteador_taller_buscador').stickyTableHeaders();

                    //Reset Defaults
                    r_options.automatic_update = 1;
                    r_options.updating = 0;
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        }


        // Filtrado - Texto
        $(document).on('keyup', ".input_buscador_taller", function (e) {
            clearTimeout($.data(this, 'timer'));
            if (e.keyCode == 13)
                search(true);
            else
                $(this).data('timer', setTimeout(search, 200));
        });
        function search() {
            var StringtoSearch = $(".input_buscador_taller").val();
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.search_bar = StringtoSearch;
            autoUpdate.forceUpdate();
        }

//***************************************************************
//------------------------- REPORTE BASE  -----------------------
//***************************************************************

//***************************************************************
//-------------------------- OBSERVACIONES   --------------------
//***************************************************************
        $(document).on('click', '.taller-observaciones', function () {
            var id_registro = $(this).parents('tr').attr('data-id-registro');
            var datosEnvio = {};
            datosEnvio.id_registro = id_registro;
            $(this).partnersObs(
                {
                    modalId: 'observaciones-taller',
                    ajaxUrl: settings.taller.ruta_sys_tools + 'load_obs',
                    index: 'id_registro',
                    id_index: id_registro,
                    only_view: true,
                    tabla: 'partners_taller',
                    closeAfterSuccess: false,
                    col: 'observaciones',
                    ajaxSuccessCallback: function () {
                        autoUpdate.forceUpdate();
                    }
                }
            );
        });
//***************************************************************
//-------------------------- OBSERVACIONES   --------------------
//***************************************************************


//***************************************************************
//------------------------ IMPRIMIR REGISTRO --------------------
//***************************************************************
        $(document).on('click', '.imprimir_registro', function () {
            var id_registro = $(this).parents('tr').attr('data-id-registro');
            var status_presupuesto = $(this).parents('tr').attr('data-status-presupuesto');

            if (status_presupuesto == 0 || status_presupuesto == 1) {
                iziToast.show({
                    color: 'dark',
                    icon: 'fa fa-folder-open-o',
                    title: 'Reporte',
                    message: 'Cuál deseas ver?',
                    position: 'center',
                    progressBarColor: 'rgb(0, 255, 184)',
                    buttons: [
                        ['<button>Recepción</button>', function (instance, toast) {
                            window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 1);
                            instance.hide({
                                transitionOut: 'fadeOutUp'
                            }, toast, 'close', 'btn1');
                        }]
                    ]
                });
            } else if (status_presupuesto == 2) {
                iziToast.show({
                    color: 'dark',
                    icon: 'fa fa-folder-open-o',
                    title: 'Reporte',
                    message: 'Cuál deseas ver?',
                    position: 'center',
                    progressBarColor: 'rgb(0, 255, 184)',
                    buttons: [
                        ['<button>Recepción</button>', function (instance, toast) {
                            window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 1);
                            instance.hide({
                                transitionOut: 'fadeOutUp'
                            }, toast, 'close', 'btn1');
                        }],
                        ['<button>Reporte</button>', function (instance, toast) {
                            window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 2);
                            instance.hide({
                                transitionOut: 'fadeOutUp'
                            }, toast, 'close', 'btn2');
                        }]
                    ]
                });
            } else if (status_presupuesto == 3) {
                iziToast.show({
                    color: 'dark',
                    icon: 'fa fa-folder-open-o',
                    title: 'Reporte',
                    message: 'Cuál deseas ver?',
                    position: 'center',
                    progressBarColor: 'rgb(0, 255, 184)',
                    buttons: [
                        ['<button>Recepción</button>', function (instance, toast) {
                            window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 1);
                            instance.hide({
                                transitionOut: 'fadeOutUp'
                            }, toast, 'close', 'btn1');
                        }],
                        ['<button>No Autorizado</button>', function (instance, toast) {
                            window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 5);
                            instance.hide({
                                transitionOut: 'fadeOutUp'
                            }, toast, 'close', 'btn2');
                        }]
                    ]
                });
            }

        });
//***************************************************************
//------------------------ IMPRIMIR REGISTRO --------------------
//***************************************************************


//***************************************************************
//----------------------- VISTA DATOS GENERALES  ----------------
//***************************************************************
        $(document).on('click', '.vista_general_completa', function () {
            var id_registro = $(this).parents('tr').attr('data-id-registro');
            $(this).partnersModal({
                title: 'Vista Datos Generales',
                modalId: 'vista-general-completa-modal',
                forceWidth: 90,
                content: loader
            });

            $.ajax({
                type: 'POST',
                url: settings.taller.ruta_consultas + 'vista_general_completa',
                data: JSON.stringify(id_registro),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        $('#vista-general-completa-modal .modal-body').html(response.message);
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });

        });
//***************************************************************
//----------------------- VISTA DATOS GENERALES  ----------------
//***************************************************************


//***************************************************************
//--------------------- SERVICIOS INFORM ERRORS -----------------
//***************************************************************
        $(document).on('click', '.inform_errors', function (e) {
            e.preventDefault();
            var error = {};
            error.err_msg = $(this).attr('data-error-msg');
            error.err_time = $(this).attr('data-error-time');
            error.err_loc = $(this).attr('data-error-location');
            error.err_user = $(this).attr('data-error-user');
            error.err_user_id = $(this).attr('data-error-user-id');

            $.ajax({
                type: 'POST',
                url: settings.taller.ruta_sys_tools + 'report_error',
                data: JSON.stringify(error),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        $('.modal').each(function () {
                            $(this).modal('hide');
                        });
                        iziToast.destroy();
                        swal({
                            title: "Se ha enviado el error!",
                            type: "success",
                            text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
                            timer: 4000,
                            showConfirmButton: false
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });


        });
//***************************************************************
//--------------------- SERVICIOS INFORM ERRORS -----------------
//***************************************************************
        

    });
})
(jQuery);