(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';
//***************************************************************
//-------------------- REPORTE BASE SERVICIO  -------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 60,
      iddle_after: 120
    });

    // Reporte base Options
    var r_options = {
      sort: {
        order: 'ASC',
        sort_by: 'id_registro'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        no_facturado: null,
        falta_costo: null,
        start_date: null,
        end_date: null,
        tipo_fecha: 1,
        tecnico: 0,
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_taller_admin').stickyTableHeaders();
          $('#table_reporteador_taller_admin').partnersfilter({
            table: '#table_reporteador_taller_admin',
            sumatory: true,
            sumatory_cols: ["col-precio", "col-costo", "col-util"]
          });
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      r_options.filter.no_facturado = null;
      r_options.filter.falta_costo = null;
      r_options.filter.tecnico = 0;
      $('#tecnicoFilter').val(0);
      $('.input_buscador_taller_admin').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    $(document).on('change', '#tecnicoFilter', () => {
      r_options.filter.tecnico = $('#tecnicoFilter').val();
      r_options.automatic_update = 0;
      autoUpdate.forceUpdate();
    });

    // Filtrado - Texto
    $(document).on('keyup', ".input_buscador_taller_admin", function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_taller_admin").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }


    // Filtrado - No Facturado
    $(document).on('change', '.filtro_no_facturado', function () {
      if ($(this).is(':checked')) {
        r_options.filter.no_facturado = 1;
      } else {
        r_options.filter.no_facturado = 0;
      }
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      autoUpdate.forceUpdate();
    });


    // Filtrado - Falta Costo
    $(document).on('change', '.filtro_falta_costo', function () {
      if ($(this).is(':checked')) {
        r_options.filter.falta_costo = 1;
      } else {
        r_options.filter.falta_costo = 0;
      }
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      autoUpdate.forceUpdate();
    });

    // Filtrado - Tipo Fecha
    $(document).on('change', '.tipo_fecha', function () {
      if ($(this).is(':checked')) {
        r_options.filter.tipo_fecha = 1;
      } else {
        r_options.filter.tipo_fecha = 0;
      }
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      autoUpdate.forceUpdate();
    });

//***************************************************************
//-------------------- REPORTE BASE SERVICIO  -------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************

    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Hoy': [moment(), moment()],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Esta Semana': [moment().startOf('week'), moment().endOf('week')],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Este Mes': [moment().startOf('month'), moment().endOf('month')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Este Bimestre': [moment().startOf('month'), moment().add(1, 'month').endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Este Año': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//-------------------------- OBSERVACIONES   --------------------
//***************************************************************
    $(document).on('click', '.taller-observaciones', function () {
      var id_registro = $(this).parents('tr').attr('data-id-registro');
      var datosEnvio = {};
      datosEnvio.id_registro = id_registro;
      $(this).partnersObs(
        {
          modalId: 'observaciones-taller',
          ajaxUrl: settings.taller.ruta_sys_tools + 'load_obs',
          index: 'id_registro',
          id_index: id_registro,
          tabla: 'partners_taller',
          closeAfterSuccess: false,
          col: 'observaciones',
          allowReminder: true,
          nombreCliente: $(this).parents('tr').attr('data-nombre-cliente'),
          idCliente: $(this).parents('tr').attr('data-id-cliente'),
          subjectReminder: 'Centro de Servicio, folio ' + id_registro,
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });
//***************************************************************
//-------------------------- OBSERVACIONES   --------------------
//***************************************************************


//***************************************************************
//------------------------ IMPRIMIR REGISTRO --------------------
//***************************************************************
    $(document).on('click', '.imprimir_registro', function () {
      var id_registro = $(this).parents('tr').attr('data-id-registro');
      var status_presupuesto = $(this).parents('tr').attr('data-status-presupuesto');

      if (status_presupuesto == 0 || status_presupuesto == 1) {
        iziToast.show({
          color: 'dark',
          icon: 'fa fa-folder-open-o',
          title: 'Reporte',
          message: 'Cuál deseas ver?',
          position: 'center',
          progressBarColor: 'rgb(0, 255, 184)',
          buttons: [
            ['<button>Recepción</button>', function (instance, toast) {
              window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 1);
              instance.hide({
                transitionOut: 'fadeOutUp'
              }, toast, 'close', 'btn1');
            }]
          ]
        });
      } else if (status_presupuesto == 2) {
        iziToast.show({
          color: 'dark',
          icon: 'fa fa-folder-open-o',
          title: 'Reporte',
          message: 'Cuál deseas ver?',
          position: 'center',
          progressBarColor: 'rgb(0, 255, 184)',
          buttons: [
            ['<button>Recepción</button>', function (instance, toast) {
              window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 1);
              instance.hide({
                transitionOut: 'fadeOutUp'
              }, toast, 'close', 'btn1');
            }],
            ['<button>Reporte</button>', function (instance, toast) {
              window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 2);
              instance.hide({
                transitionOut: 'fadeOutUp'
              }, toast, 'close', 'btn2');
            }]
          ]
        });
      } else if (status_presupuesto == 3) {
        iziToast.show({
          color: 'dark',
          icon: 'fa fa-folder-open-o',
          title: 'Reporte',
          message: 'Cuál deseas ver?',
          position: 'center',
          progressBarColor: 'rgb(0, 255, 184)',
          buttons: [
            ['<button>Recepción</button>', function (instance, toast) {
              window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 1);
              instance.hide({
                transitionOut: 'fadeOutUp'
              }, toast, 'close', 'btn1');
            }],
            ['<button>No Autorizado</button>', function (instance, toast) {
              window.open(settings.taller.ruta_vista_reporte + id_registro + '/' + 5);
              instance.hide({
                transitionOut: 'fadeOutUp'
              }, toast, 'close', 'btn2');
            }]
          ]
        });
      }

    });
//***************************************************************
//------------------------ IMPRIMIR REGISTRO --------------------
//***************************************************************


//***************************************************************
//----------------------- VISTA DATOS GENERALES  ----------------
//***************************************************************
    $(document).on('click', '.vista_general_completa', function () {
      var id_registro = $(this).parents('tr').attr('data-id-registro');
      $(this).partnersModal({
        title: 'Vista Datos Generales',
        modalId: 'vista-general-completa-modal',
        forceWidth: 90,
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'vista_general_completa',
        data: JSON.stringify(id_registro),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-general-completa-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//----------------------- VISTA DATOS GENERALES  ----------------
//***************************************************************


//***************************************************************
//--------------------------- STATUS FACTURADO   ----------------
//***************************************************************
    $(document).on('click', '.status_pagado', function () {
      var id_registro = $(this).parents('tr').attr('data-id-registro');
      var nombre_cliente = $(this).parents('tr').attr('data-nombre-cliente');
      var total_registro = $(this).parents('tr').attr('data-total-registro-a-pagar');
      var template = '<div class="row">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning servicio_no_pagado w-100" data-id-registro="' + id_registro + '" role="button">No</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-success servicio_pagado w-100" data-total-registro-a-pagar="' + total_registro + '" data-nombre-cliente="' + nombre_cliente + '" data-id-registro="' + id_registro + '" role="button">Pagado</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-info servicio_facturado w-100" data-nombre-cliente="' + nombre_cliente + '" data-id-registro="' + id_registro + '" role="button">Facturado</button></div>' +
        '</div>';

      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 25,
        modalId: 'modal-pagado-registros',
        noFooter: true
      });
    });

    $(document).on('click', '.servicio_no_pagado', function () {
      var id_registro = $(this).attr('data-id-registro');
      var clicked_td = $('tr[data-id-registro="' + id_registro + '"] .status_pagado');
      $('#modal-pagado-registros .modal-body').html(loader);
      var envio = {};
      envio.new_val = 0;
      envio.id_registro = id_registro;
      envio.col = 'facturado';
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            $('#modal-pagado-registros').modal('hide');
            clicked_td.removeClass('status-green');
            clicked_td.addClass('status-red');
            clicked_td.html('No');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.servicio_pagado', function () {
      var id_registro = $(this).attr('data-id-registro');
      var nombre_cliente = $(this).attr('data-nombre-cliente');
      var total_registro = $(this).attr('data-total-registro-a-pagar');
      total_registro;
      $('#modal-pagado-registros').modal('hide');
      var template = '<form autocomplete="off" id="form_pagado_caja" data-id-registro="' + id_registro + '"><div class="row">' +
        '<div class="col-md-5"><div class="form-group required"><label class="col-form-label">Concepto</label> <div> <input type="text" class="form-control valid_me" value="Registro Pago de Centro de Servicio: ' + id_registro + ' | ' + nombre_cliente + '" name="concepto_capturar_caja" data-validation="required" data-validation-error-msg="Ingresa un concepto"> </div> </div></div>' +
        '<div class="col-md-5"><div class="form-group required"> <label class="col-form-label">Cantidad</label> <div> ' +
        '<input type="text" class="form-control valid_me text-right" ' +
        'data-validation-min-number="' + total_registro + '" ' +
        'value="' + numeral(total_registro).format("0,0.00") + '" ' +
        'name="cantidad_capturar_caja" ' +
        'data-validation="number min_number" ' +
        'data-validation-allowing="float" ' +
        'data-sanitize="numberFormat" ' +
        'data-sanitize-number-format="0,0.00" ' +
        'data-validation-error-msg="Ingresa una cantidad correcta y mayor a: ' + numeral(total_registro).format("0,0.00") + '"> ' +
        '</div> </div></div>' +
        '<div class="col-md-2"><label>Guardar en caja</label><button type="submit" class="btn btn-success" role="button">Guardar</button></div>' +
        '</div></form>';

      $(this).partnersModal({
        content: template,
        title: 'Capturar en caja',
        forceWidth: 65,
        modalId: 'modal-pagado-caja',
        noFooter: true
      });
      setTimeout(function () {
        $.validate({
          form: '#form_pagado_caja',
          errorMessageClass: 'invalid-feedback',
          inputParentClassOnError: 'text-danger',
          inputParentClassOnSuccess: 'text-success',
          errorElementClass: 'is-invalid'
        });
        $.formUtils.addValidator({
          name: 'min_number',
          validatorFunction: function (value, $el) {
            return numeral(value).value() >= numeral($($el).attr('data-validation-min-number')).value();
          },
          errorMessage: '',
          errorMessageKey: ''
        });
      }, 400);
    });

    $(document).on('submit', '#form_pagado_caja', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var id_registro = $(this).attr('data-id-registro');
      btn.partnersBtnControl('start');
      var datos = $('#form_pagado_caja').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      $('#modal-pagado-caja .modal-body').html(loader);
      var clicked_td = $('tr[data-id-registro="' + id_registro + '"] .status_pagado');
      datosEnvio.id_registro = id_registro;
      datosEnvio.new_val = 1;
      datosEnvio.col = 'facturado';
      datosEnvio.obs = 'Se capturó en caja bajo el concepto de: ' + datosEnvio.concepto_capturar_caja;
      datosEnvio.capturar_caja = 1;
      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
            $('#modal-pagado-caja').modal('hide');
            clicked_td.addClass('status-green');
            clicked_td.html('Pagado');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.servicio_facturado', function () {
      var id_registro = $(this).attr('data-id-registro');
      var nombre_cliente = $(this).attr('data-nombre-cliente');
      $('#modal-pagado-registros').modal('hide');
      var content = '';
      content += '<div class="row">' +
        '<div class="col-md-2"><p class="font-weight-bold">Folio Servicio:</p></div>' +
        '<div class="col-md-2">' + id_registro + '</div>' +
        '<div class="col-md-1"><p class="font-weight-bold">Cliente:</p></div>' +
        '<div class="col-md-3">' + nombre_cliente + '</div>' +
        '</div><hr>' +
        '<div class="row">' +
        '<div class="col-md-2">' +
        '<p class="font-weight-bold">Factura:</p>' +
        '</div>' +
        '<div class="col-md-2">' +
        '<input type="text" class="form-control numero_factura">' +
        '</div>' +
        '</div><hr>' +
        '<div class="row">' +
        '<div class="col-md-4"><p class="font-weight-bold">La factura está a nombre de:</p></div>' +
        '<div class="col-md-8"><input type="text" class="nombre_cliente_factura form-control" readonly value="..."></div>' +
        '</div>' +
        '<div class="row">' +
        '<div class="col-md-12 my-3">' +
        '<button type="button" class="float-right capturar_servicio_facturado btn btn-success" data-id-registro="' + id_registro + '" role="button" style="display: none;">Guardar</button>' +
        '</div>' +
        '</div>';

      setTimeout(function () {
        $(this).partnersModal({
          title: 'Facturar',
          modalSize: 'modal-lg',
          modalId: 'facturar-servicio-modal',
          content: content,
          noFooter: true
        });
      }, 400);
    });

    $(document).on('blur', '.numero_factura', function () {
      var numero_factura = $('.numero_factura').val();
      if ($.trim(numero_factura) == '' || !$.trim(numero_factura) || isNaN(numero_factura)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un folio de factura correcto.'
        });
        return false;
      }
      var envio = {};
      envio.numero_factura = numero_factura;
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_sys_tools + 'get_datos_cliente_contpaq',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var datos_c = JSON.parse(response.message);
            $('.nombre_cliente_factura').val(datos_c.nombre);
            $('.nombre_cliente_factura').attr('data-codigo-cliente', datos_c.codigo_cliente);
            $('.nombre_cliente_factura').attr('data-rfc-cliente', datos_c.rfc);
            $('.capturar_servicio_facturado').show();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            $('.nombre_cliente_factura').val('');
            $('.capturar_servicio_facturado').hide();
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.capturar_servicio_facturado', function () {
      var envio = {};
      var btn = $(this);
      btn.partnersBtnControl('start');
      envio.codigo_cliente = $('.nombre_cliente_factura').attr('data-codigo-cliente');
      envio.rfc_cliente = $('.nombre_cliente_factura').attr('data-rfc-cliente');
      envio.folio_factura = $('.numero_factura').val();
      envio.folio_registro = $(this).attr('data-id-registro');
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'marcar_facturado',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#facturar-servicio-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//--------------------------- STATUS FACTURADO   ----------------
//***************************************************************


//***************************************************************
//---------------------- COSTO PIEZAS REPORTE  ------------------
//***************************************************************
    $(document).on('click', '.status_costo', function () {
      $(this).partnersModal({
        title: 'Modificar Costos',
        modalSize: 'modal-lg',
        modalId: 'modificacion-costos-modal',
        content: loader
      });

      var envio = {};
      envio.id_registro = $(this).parents('tr').attr('data-id-registro');
      envio.type = 1;
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'modificacion_costos',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#modificacion-costos-modal .modal-body').html(response.message);
            setTimeout(function () {
              $.validate({
                form: '#form_modificacion_piezas',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid'
              })
            }, 100);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });


    $(document).on('submit', '#form_modificacion_piezas', function (e) {
      var datos = [];
      var envio = {};
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');

      $('.entity_pieza_modificacion').each(function () {
        datos.push({
          id_pieza: $(this).attr('data-id-pieza'),
          new_costo: $(this).find('.modificacion_costo_value').val()
        });
      });

      envio.type = 2;
      envio.datos = datos;
      envio.id_registro = $(this).attr('data-id-registro');
      envio = JSON.stringify(envio);

      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_consultas + 'modificacion_costos',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            autoUpdate.forceUpdate();
            $('#modificacion-costos-modal').modal('hide');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//---------------------- COSTO PIEZAS REPORTE  ------------------
//***************************************************************


//***************************************************************
//--------------------- SERVICIOS INFORM ERRORS -----------------
//***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
//***************************************************************
//--------------------- SERVICIOS INFORM ERRORS -----------------
//***************************************************************


//***************************************************************
//------------------------ TALLER VER FACTURA  ------------------
//***************************************************************
    $(document).on('click', '.ver_factura', function () {
      var id_factura = $(this).text();
      $(this).partnersModal({
        title: 'Factura ' + id_factura,
        modalId: 'vista-factura',
        forceWidth: 90,
        content: loader
      });
      $.ajax({
        type: 'POST',
        url: settings.taller.ruta_sys_tools + 'get_full_factura',
        data: JSON.stringify(id_factura),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            if (response.message == "not_on_server") {
              var content = "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content = '<div>' +
                '<iframe src="/system/tools/vista_factura?factura=' + response.message + '" width="100%;" height="600px;"></iframe>' +
                '</div>';
            }
            $('#vista-factura .modal-body').html(content);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------ TALLER VER FACTURA  ------------------
//***************************************************************


//***************************************************************
//--------------------- TALLER ESTATUS ESPECIAL -----------------
//***************************************************************
    $(document).on('click', '.status_especial', function () {
      var especial = ($(this).parents('tr').attr('data-especial') == 1) ? 0 : 1;
      var folio = $(this).parents('tr').attr('data-id-registro');
      var envio = {};
      envio.especial = especial;
      envio.folio = folio;

      swal({
        title: 'Motivo',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              envio.motivo = reason;
              $.ajax({
                type: 'POST',
                url: settings.taller.ruta_consultas + 'status_especial',
                data: JSON.stringify(envio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    iziToast.success({
                      title: "Bien! ",
                      message: response.message
                    });
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          }).catch(function (error) {
            swal.showValidationError(error);
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (a.dismiss !== 'cancel') {
          swal("Bien!", "Se ha actualizado el estatus correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });
//***************************************************************
//--------------------- TALLER ESTATUS ESPECIAL -----------------
//***************************************************************

  });
})
(jQuery);
