(function ($) {
  const settings = Drupal.settings;
  $(document).ready(() => {
    const loader = '<div class="sk-cube-grid"> '
      + '<div class="sk-cube sk-cube1"></div> '
      + '<div class="sk-cube sk-cube2"></div> '
      + '<div class="sk-cube sk-cube3"></div> '
      + '<div class="sk-cube sk-cube4"></div> '
      + '<div class="sk-cube sk-cube5"></div> '
      + '<div class="sk-cube sk-cube6"></div> '
      + '<div class="sk-cube sk-cube7"></div> '
      + '<div class="sk-cube sk-cube8"></div> '
      + '<div class="sk-cube sk-cube9"></div> </div>';
    //* **************************************************************
    // --------------------- REPORTE BASE TALLER ---------------------
    //* **************************************************************
    // Auto Update
    const autoUpdate = new AutoUpdate({
      toUpdate() {
        reporte_base();
      },
      interval: 60,
      iddle_after: 120,
    });

    const r_options = {
      sort: {
        order: 'ASC',
        sort_by: 'id_registro',
      },
      filter: {
        tecnico: null
      },
      automatic_update: 1,
      updating: 0,
      ocultarTerminados: false,
      ocultarNoAut: true,
      soloPropios: true,
    };

    $('#soloPropioCheck').on('input', () => {
      r_options.soloPropios = $('#soloPropioCheck').is(':checked');
      r_options.automatic_update = 0;
      reporte_base();
    });

    // Filtrado - Técnico
    $(document).on("change", "#filtrado_tecnico", function () {
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      // quitar el filtro de registros propios
      r_options.soloPropios = false;
      $('#soloPropioCheck').prop("checked", false);
      r_options.filter.tecnico = $(this).find("option:selected").val();
      autoUpdate.forceUpdate();
    });

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_consultas}reporte_base_trabajo`,
        data: JSON.stringify(r_options),
        contentType: 'application/json; charset=utf-8',
        success(data) {
          $('#reporteador').html(data);

          // Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    autoUpdate.forceUpdate();

    //* **************************************************************
    // --------------------- REPORTE BASE TALLER ---------------------
    //* **************************************************************

    //* **************************************************************
    // --------------------- OCULTAR TERMINADOS ---------------------
    //* **************************************************************

    $('#terminadosCheck').on('input', () => {
      r_options.ocultarTerminados = $('#terminadosCheck').is(':checked');
      r_options.automatic_update = 0;
      reporte_base();
    });

    $('#autorizadosCheck').on('input', () => {
      r_options.ocultarNoAut = $('#autorizadosCheck').is(':checked');
      r_options.automatic_update = 0;
      reporte_base();
    });

    //* **************************************************************
    // --------------------- OCULTAR TERMINADOS ---------------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- INGRESAR NUEVO EQUIPO  ----------------
    //* **************************************************************
    $('#vista-ingresar-nuevo-equipo-modal').on('hidden.bs.modal', e => false);
    $(document).on('click', '.ingresar_nuevo_equipo', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Ingresar Nuevo Equipo',
        ajaxUrl: `${settings.taller.render_template}taller.ingresar_equipo_form`,
        forceWidth: 95,
        modalId: 'vista-ingresar-nuevo-equipo-modal',
        preventHideOnBackdrop: true,
        ajaxSuccessCallback() {
          setTimeout(() => {
            $('#smartwizard').smartWizard({
              useURLhash: false,
              showStepURLhash: false,
              lang: { // Language variables
                next: 'Siguiente',
                previous: 'Anterior',
              },
              theme: 'arrows',
              autoAdjustHeight: false,
              keyNavigation: false,
              toolbarSettings: {
                toolbarPosition: 'bottom',
                toolbarButtonPosition: 'left',
                showNextButton: true,
                showPreviousButton: true,
                toolbarExtraButtons: [
                  $('<button></button>').text('Guardar')
                    .addClass('btn btn-success btn_capturar').attr('role', 'button')
                    .attr('type', 'submit')
                    .css('display', 'none')
                    .css('margin-left', '5px'),
                ],
              },

            });

            $.validate({
              form: '#ingresar_nuevo_equipo_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid',
            });

            $('#buscar_cliente').typeahead({
              order: 'asc',
              minlength: 1,
              maxItem: 15,
              hint: true,
              accent: true,
              group: {
                template: '{{group}}',
              },
              maxItemPerGroup: 5,
              backdrop: {
                'background-color': '#fff',
              },
              template(query, item) {
                let color_t_clasificacion;
                let tipo_clasificacion = item.tipo_clasificacion;
                var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                switch (tipo_clasificacion) {
                  case 'a':
                    color_t_clasificacion = 'success';
                    break;
                  case 'b':
                    color_t_clasificacion = 'success';
                    break;
                  case 'c':
                    color_t_clasificacion = 'warning';
                    break;
                  case 'd':
                    color_t_clasificacion = 'danger';
                    break;
                  case 'e':
                    color_t_clasificacion = 'danger';
                    break;
                  case "p":
                    color_t_clasificacion = "success";
                    credito_contado =
                      "Saldo: " +
                      (item.saldo_horas != 1
                        ? item.saldo_horas + " horas"
                        : item.saldo_horas + " hora");

                    break;
                }
                tipo_clasificacion = tipo_clasificacion.toUpperCase();

                if (item.tipo_cliente != 3) {
                  return `${'<p>'
                    + '<span>{{nombre_cliente}}</span> '
                    + '<span class="float-right badge badge-'}${color_t_clasificacion}">`
                    + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                    } | ${credito_contado}</span> </p> `;
                }
                return '<p><span>{{nombre_cliente}}</span> </p> ';
              },
              dynamic: true,
              dropdownFilter: 'Todos',
              emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
              source: {
                Clientes: {
                  display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                  ajax: {
                    url: `${settings.taller.ruta_lista_clientes}complete`,
                    path: 'data.datos.clientes',
                  },
                },
                Contactos: {
                  display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                  ajax: {
                    url: `${settings.taller.ruta_lista_clientes}complete`,
                    path: 'data.datos.contactos',
                  },
                },
                Proveedores: {
                  display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                  ajax: {
                    url: `${settings.taller.ruta_lista_clientes}complete`,
                    path: 'data.datos.proveedores',
                  },
                },
              },
              callback: {
                onClickAfter(node, a, item) {
                  let color_t_clasificacion;
                  let tipo_clasificacion = item.tipo_clasificacion;
                  var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                  switch (tipo_clasificacion) {
                    case 'a':
                      color_t_clasificacion = 'success';
                      break;
                    case 'b':
                      color_t_clasificacion = 'success';
                      break;
                    case 'c':
                      color_t_clasificacion = 'warning';
                      break;
                    case 'd':
                      color_t_clasificacion = 'danger';
                      break;
                    case 'e':
                      color_t_clasificacion = 'danger';
                      break;
                    case "p":
                      color_t_clasificacion = "success";
                      credito_contado =
                        "Saldo: " +
                        (item.saldo_horas != 1
                          ? item.saldo_horas + " horas"
                          : item.saldo_horas + " hora");

                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();
                  if (item.tipo_cliente != 3) {
                    $('.quick_info_client').html(`<span class="badge badge-${color_t_clasificacion}">`
                      + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                      } | ${credito_contado}</span> </p> `);
                    const id_cliente = item.id_cliente;
                    prepareEvs(1, {
                      color_t_clasificacion,
                      tipo_clasificacion,
                      credito_contado,
                      id_cliente,
                      settings,
                    });
                  }

                  // Bindear el id del cliente al input
                  node.attr('data-id-cliente', item.id_cliente);


                  // Generar lista contactos solo para clientes Negocio/Distribuidor
                  if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                    generar_contactos(settings.taller.ruta_lista_contactos, item.id_cliente);

                    // Solamente agrega este attr cuando debe de tener contactos
                    node.attr('data-tipo-negocio', item.tipo_negocio);
                  } else {
                    $('.contacto_container').hide();
                    $('.select_lista_contactos').empty();
                  }
                },
                onSearch(node, a) {
                  if (a !== '') {
                  } else {
                    // Para prevenir errores de sobrescribir o duplicar
                    $('.contacto_container').hide();
                    $('.select_lista_contactos').empty();
                    $('.quick_info_client').html('');
                    node.removeAttr('data-id-cliente');
                    node.removeAttr('data-tipo-negocio');
                  }
                },

              },
            });
          }, 300);
        },

      });
    });

    $(document).on('leaveStep', '#smartwizard', (e, anchorObject, stepNumber, stepDirection) => {
      const elmForm = $(`#form-step-${stepNumber}`);
      let error_form = false;
      // Validar etapas
      if (stepDirection === 'forward' && elmForm) {
        $('.valid_me').validate((valid) => {
          if (!valid) {
            error_form = true;
          }
        });

        if (stepNumber == 0) {
          if (error_form == false && !$('#buscar_cliente').attr('data-id-cliente')) {
            iziToast.error({
              title: 'Error',
              message: 'Selecciona un Cliente',
            });
            error_form = true;
          }
          if (error_form == false && $('#buscar_cliente').attr('data-tipo-negocio')) {
            if ($('.select_lista_contactos').find('option:selected').val() == 0) {
              iziToast.error({
                title: 'Error',
                message: 'Selecciona un Contacto',
              });
              error_form = true;
            }
          }
          $('.sw-btn-next').show();
          $('.btn_capturar').hide();
        } else if (stepNumber == 1) {
          // Ocultar estos dos datos cuando el equipo sea tipo impresora
          if ($('.select_tipo_equipo').find('option:selected').attr('data-type') == 2) {
            $('.info_respaldar_parent_container').hide();
            $('.user_pass_container').hide();
          }
          // Monitor otro
          if (!$('.select_tipo_equipo').find('option:selected').attr('data-type')) {
            $('.software_user_row').hide();
            $('.info_respaldar_parent_container').hide();
          } else {
            $('.info_respaldar_parent_container').show();
            $('.user_pass_container').show();
            $('.software_user_row').show();
          }
          $('.sw-btn-next').show();
          $('.btn_capturar').hide();
        } else if (stepNumber == 2) {
          $('.sw-btn-next').hide();
          $('.btn_capturar').show();
        }
      } else if (stepDirection === 'backward' && elmForm) {
        $('.sw-btn-next').show();
        $('.btn_capturar').hide();
      }

      return error_form != true;
    });

    $(document).on('change', '.select_tipo_equipo', function () {
      const tipo_equipo = $(this).find('option:selected').attr('data-type');

      $('.show_on_select_tipo_equipo').show();
      if (tipo_equipo == 1) {
        $('.hide_me').show();
        $('.hide_me:not(.equipo_type_1)').hide();
      } else if (tipo_equipo == 2) {
        $('.hide_me').show();
        $('.hide_me:not(.equipo_type_2)').hide();
      } else if (tipo_equipo == 3) {
        $('.hide_me').show();
        $('.hide_me:not(.equipo_type_3)').hide();
      } else {
        $('.hide_me').hide();
      }

      // Si es de tipo otro, entonces mostrar el campo para indicar que tipo de dispositivo es
      if ($(this).find('option:selected').val() == 9) {
        $('.tipo_otro_container').show();
        $('.act_on_otro').removeClass('col-md-4');
        $('.act_on_otro').addClass('col-md-3');
      } else {
        $('.tipo_otro_container').hide();
        $('.act_on_otro').removeClass('col-md-3');
        $('.act_on_otro').addClass('col-md-4');
      }
    });

    $(document).on('change', 'input[name="ninguno_accesorios"]', function () {
      if ($(this).is(':checked')) {
        $('input[name="accesorios_equipo"]').val('Ninguno');
        $('input[name="accesorios_equipo"]').attr('disabled', 1);
        $('.accesorios_container').removeClass('has-danger');
        $('.accesorios_container input').removeAttr('style');
        $('.accesorios_container .help-block').remove();
      } else {
        $('input[name="accesorios_equipo"]').val('');
        $('input[name="accesorios_equipo"]').removeAttr('disabled');
      }
    });

    $(document).on('change keyup', 'textarea[name="info_respaldar"]', () => {
      if ($('input[name="radio_info_respaldar"]').is(':checked')) {
        $('input[name="radio_info_respaldar"]').removeAttr('checked');
      }
    });
    $(document).on('change', 'input[name="radio_info_respaldar"]', function () {
      $('.info_respaldar_container').removeClass('has-danger');
      $('.info_respaldar_container textarea').removeAttr('style');
      $('.info_respaldar_container .help-block').remove();
      if ($(this).val() == 1) {
        $('textarea[name="info_respaldar"]').val('Todo');
      } else {
        $('textarea[name="info_respaldar"]').val('Nada');
      }
    });
    //* **************************************************************
    // ----------------------- INGRESAR NUEVO EQUIPO  ----------------
    //* **************************************************************


    //* **************************************************************
    // ----------------------- CAPTURAR NUEVO EQUIPO  ----------------
    //* **************************************************************
    $(document).on('keypress', ':input:not(textarea)', e => e.keyCode != 13);
    $(document).on('submit', '#ingresar_nuevo_equipo_form', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      const datos = $('#ingresar_nuevo_equipo_form').serializeArray();
      const datosEnvio = {};
      for (let i = 0; i < datos.length; i++) {
        datosEnvio[datos[i].name] = datos[i].value;
      }

      if ($('.select_tipo_equipo').find('option:selected').attr('data-type') == 3) {
        datosEnvio.extras_equipo = $('input[name="extras_cel"]').val();
      } else {
        datosEnvio.extras_equipo = $('input[name="extras_equipo"]').val();
      }

      if ($('input[name="accesorios_equipo"]').attr('disabled') == true) {
        datosEnvio.accesorios_equipo = 'Ninguno';
      } else {
        datosEnvio.accesorios_equipo = $('input[name="accesorios_equipo"]').val();
      }
      datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
      datosEnvio.id_contacto = $('.select_lista_contactos').find('option:selected').val();
      datosEnvio.equipo_type = ($('.select_tipo_equipo').find('option:selected').attr('data-type')) ? $('.select_tipo_equipo').find('option:selected').attr('data-type') : 0;


      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}capturar_registro`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              swal({
                title: 'Bien!',
                text: 'Deseas imprimir la hoja de recepción?',
                type: 'success',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#DD6B55',
                confirmButtonText: 'Si',
                cancelButtonText: 'No',
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger',
                allowOutsideClick: false,
                allowEscapeKey: false,
              }).then((a) => {
                if (!a.dismiss) {
                  window.open(`/centrodeservicio/vista/${response.message}/1`);
                  $('#vista-ingresar-nuevo-equipo-modal').modal('hide');
                  autoUpdate.forceUpdate();
                } else if (a.dismiss == 'cancel') {
                  swal.close();
                  iziToast.success({
                    title: 'Bien!',
                    message: 'Se capturó el equipo correctamente',
                  });
                  $('#vista-ingresar-nuevo-equipo-modal').modal('hide');
                  autoUpdate.forceUpdate();
                }
              });
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      }, () => {
        btn.partnersBtnControl('end');
      });
    });
    //* **************************************************************
    // ----------------------- CAPTURAR NUEVO EQUIPO  ----------------
    //* **************************************************************


    //* **************************************************************
    // ----------------------- VISTA DATOS GENERALES  ----------------
    //* **************************************************************
    $(document).on('click', '.vista_datos_generales', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      $(this).partnersModal({
        title: 'Vista Datos Generales',
        modalId: 'vista-datos-generales-modal',
        forceWidth: 90,
        content: loader,
      });

      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_consultas}vista_datos_generales`,
        data: JSON.stringify(id_registro),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#vista-datos-generales-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ----------------------- VISTA DATOS GENERALES  ----------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------ REVISION INICIAL  --------------------
    //* **************************************************************
    $(document).on('click', '.revision_inicial', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      $(this).partnersModal({
        title: 'Revisión Inicial',
        modalId: 'revision-inicial-modal',
        forceWidth: 90,
        content: loader,
      });

      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_consultas}vista_revision_inicial`,
        data: JSON.stringify(id_registro),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#revision-inicial-modal .modal-body').html(response.message);
            setTimeout(() => {
              $.validate({
                form: '#form-revision-inicial',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid',
              });
            }, 500);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('submit', '#form-revision-inicial', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      const datosEnvio = {};
      datosEnvio.datos = get_revision_data('#form-revision-inicial');

      const id_registro = $(this).attr('data-id-registro');

      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes de seleccionar al menos un proceso de la revisión inicial.',
        });
        btn.partnersBtnControl('end');
        return false;
      }
      datosEnvio.id_registro = id_registro;

      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}capturar_revision_inicial`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_revision_inicial`, id_registro, 'revision-inicial-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });
    //* **************************************************************
    // ------------------------ REVISION INICIAL  --------------------
    //* **************************************************************


    //* **************************************************************
    // -------------------------- PRESUPUESTO  -----------------------
    //* **************************************************************
    $(document).on('click', '.status_presupuesto', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      $(this).partnersModal({
        title: 'Presupuesto',
        modalId: 'presupuesto-modal',
        forceWidth: 90,
        content: loader,
      });

      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_consultas}vista_presupuesto`,
        data: JSON.stringify(id_registro),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#presupuesto-modal .modal-body').html(response.message);
            setTimeout(() => {
              $.validate({
                form: '#form-presupuesto-inicial',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid',
              });
            }, 500);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('click', '.agregar_entity_presupuesto', () => {
      const cantidad = $('.cantidad_presupuesto').val();
      const tipo = $('.tipo_presupuesto option:selected').val();
      const descripcion = $('.descripcion_presupuesto').val();
      const precio = $('.precio_presupuesto').val();

      if ($.trim(cantidad).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una cantidad',
        });
        return false;
      }

      if (isNaN(cantidad)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa una cantidad correcta',
        });
        return false;
      }

      if (!tipo) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un tipo',
        });
        return false;
      }
      if ($.trim(descripcion).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una descripción',
        });
        return false;
      }

      if ($.trim(precio).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega un precio',
        });
        return false;
      }

      if (isNaN(precio)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un precio correcto',
        });
        return false;
      }
      const tipo_name = (tipo == 1) ? 'Pieza' : 'Servicio';
      const checkbox_iva = (tipo == 1) ? '<div class="form-check form-check-inline"> <div class="custom-control custom-checkbox custom-control-inline"> <input class="custom-control-input entity_presupuesto_iva" type="checkbox" checked value="1" id="tmp_chk"> <label class="custom-control-label" for="tmp_chk"></label> </div> </div>' : '';
      const tr = $(`${'<tr class="entity_presupuesto" data-nuevo="1">'
        + '<td class="entity_presupuesto_tipo" data-tipo-presupuesto="'}${tipo}">${tipo_name}</td>`
        + `<td class="entity_presupuesto_cantidad">${cantidad}</td>`
        + `<td class="entity_presupuesto_descripcion" style="word-break: break-all;">${descripcion}</td>`
        + `<td class="text-right entity_presupuesto_precio" data-precio="${precio}">${parseFloat(precio).format(2)}</td>`
        + `<td class="text-right entity_presupuesto_subtotal" data-subtotal="${precio * cantidad}">${(precio * cantidad).format(2)}</td>`
        + `<td class="text-center">${checkbox_iva}</td>`
        + '<td class="eliminar_entity_presupuesto text-center text-danger cursor-pointer">Eliminar</td>'
        + '</tr>');
      $('.table-entities-presupuesto tbody').append(tr);
      sumar_total_entities_presupuesto();
      $('.cantidad_presupuesto').val('');
      $('.tipo_presupuesto option:selected').removeAttr('selected');
      $('.descripcion_presupuesto').val('');
      $('.precio_presupuesto').val('');

      $('.cantidad_presupuesto').focus();
    });

    function sumar_total_entities_presupuesto() {
      let total = 0;
      $('.entity_presupuesto_subtotal').each(function () {
        total += parseFloat($(this).attr('data-subtotal'));
      });
      $('.table-entities-presupuesto .total_presupuesto').html(parseFloat(total).format(2));
    }


    $(document).on('change', '.sin_servicio_checkbox', function () {
      if ($(this).is(':checked')) {
        let validate = false;

        $('.entity_presupuesto').each(function () {
          if ($(this).find('.entity_presupuesto_tipo').attr('data-tipo-presupuesto') == 2) {
            validate = true;
          }
          if (validate) {
            iziToast.error({
              title: 'Error',
              message: 'No puedes marcar sin servicio porque actualmente el presupuesto tiene un servicio, eliminalo para poder marcar el presupuesto sin servicio.',
              timeout: 5000,
            });
            $('.sin_servicio_checkbox').removeAttr('checked');
            return false;
          }
        });
        if (!validate) {
          $('.tipo_presupuesto option').removeAttr('selected');
          $('.tipo_servicio_presupuesto').attr('disabled', 1);
        }
      } else {
        $('.tipo_servicio_presupuesto').removeAttr('disabled');
      }
    });

    $(document).on('click', '.eliminar_entity_presupuesto', function () {
      $(this).parents('tr').remove();
      if (!$(this).parents('tr').attr('data-nuevo')) {
        const div = $(`<div class="eliminated_tr" data-id-dato="${$(this).parents('tr').attr('data-id-dato')}"></div>`);
        $('.deleted_entities_presupuesto').append(div);
      }
      sumar_total_entities_presupuesto();
    });

    $(document).on('submit', '#form-presupuesto-inicial', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      const id_registro = $(this).attr('data-id-registro');
      const datosEnvio = {};
      datosEnvio.datos = get_presupuesto_entities_data();
      datosEnvio.id_registro = id_registro;

      const email_cliente = $(this).attr('data-correo-cliente');
      const email_contacto = $(this).attr('data-correo-contacto');
      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes ingresar al menos una pieza o servicio al presupuesto para poder continuar.',
        });
        btn.partnersBtnControl('end');
        return false;
      }
      let validate_sin_servicio = false;
      $.each(datosEnvio.datos, (key, val) => {
        if (val.tipo == 2) validate_sin_servicio = true;
      });

      if ($('.sin_servicio_checkbox').is(':checked')) {
        validate_sin_servicio = true;
      }
      if (!validate_sin_servicio) {
        iziToast.error({
          title: 'Error',
          message: 'Si no vas a agregar servicio, seleccciona la opción de "Sin servicio".',
        });
        btn.partnersBtnControl('end');
        return false;
      }

      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}capturar_presupuesto_inicial`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              swal({
                title: 'Reenviar',
                text: 'Deseas enviar el presupuesto por correo?',
                type: 'info',
                showCancelButton: true,
                cancelButtonColor: '#DD6B55',
                confirmButtonText: 'Si, enviar!',
                cancelButtonText: 'No!',
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger',
                allowOutsideClick: false,
                allowEscapeKey: false,
                onClose() {
                  $('body').removeAttr('style');
                },
              }).then((a) => {
                if (!a.dismiss) {
                  swal({
                    title: 'Ingresa los correos',
                    text: 'Separados por una coma.',
                    input: 'text',
                    confirmButtonText: 'Enviar!',
                    showLoaderOnConfirm: true,
                    inputClass: 'emails_to_send',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    onClose() {
                      $('body').removeAttr('style');
                    },
                    onOpen() {
                      fixBootstrapModal();
                      $('input[type="text"].emails_to_send').val(`${email_cliente},${email_contacto}`);
                      $('input[type="text"].emails_to_send').focus();
                      $('input[type="text"].emails_to_send').tagsinput();
                      $('input[type="text"].emails_to_send').on('beforeItemAdd', (event) => {
                        if (!validateEmail(event.item)) {
                          event.cancel = true;
                        }
                      });
                    },
                    preConfirm(inputValue) {
                      return new Promise(((resolve, reject) => {
                        if (inputValue === false) {
                          reject('Ingresa al menos un correo!');
                        } else {
                          const emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
                          let send_to = {};
                          send_to.to = emails_arr;
                          send_to.id_registro = id_registro;
                          send_to = JSON.stringify(send_to);
                          $.ajax({
                            type: 'POST',
                            url: `${settings.taller.ruta_consultas}enviar_presupuesto_correo`,
                            data: send_to,
                            contentType: 'application/json; charset=utf-8',
                            dataType: 'json',
                            success(response) {
                              if (response.status == 'success') {
                                resolve();
                              } else if (response.status == 'error') {
                                iziToast.error({
                                  title: 'Error',
                                  message: response.message,
                                });
                              }
                            },
                            error(xhr) {
                              iziToast.error({
                                title: 'Ocurrio un error: ',
                                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                              });
                            },
                          });
                        }
                      }));
                    },
                  }).then(() => {
                    const emails = $('input[type="text"].emails_to_send').val();
                    const emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
                    const timeout = emails_arr.length * 800;
                    swal.close();

                    const x = `Enviando correo a <span class="font-weight-bold" id="js-rotating">${emails}</span>`;

                    iziToast.show({
                      message: x,
                      position: 'center',
                      timeout,
                      progressBar: false,
                      color: 'dark',
                      icon: 'fa fa-envelope-open-o',
                      iconColor: '#fff',
                    });
                    const morphext = $('#js-rotating').Morphext({
                      animation: 'fadeInDownCustom',
                      separator: ',',
                      speed: 800,
                    });
                    let data;

                    data = morphext.data('plugin_Morphext');
                    setTimeout(() => {
                      data.stop();
                    }, timeout - 800);

                    setTimeout(() => {
                      swal({
                        title: 'Bien!',
                        text: 'Correos enviados correctamente',
                        type: 'success',
                        timer: 1000,
                        showConfirmButton: false,
                      });

                      update_info(`${settings.taller.ruta_consultas}vista_presupuesto`, id_registro, 'presupuesto-modal');
                    }, timeout);
                  });
                } else if (a.dismiss == 'cancel') {
                  swal({
                    title: 'Bien!',
                    text: 'Se guardo normalmente el presupuesto inicial.',
                    timer: 2000,
                    type: 'success',
                    showConfirmButton: false,
                  });
                  update_info(`${settings.taller.ruta_consultas}vista_presupuesto`, id_registro, 'presupuesto-modal');
                }
              });
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });

    function get_presupuesto_entities_data() {
      const datos = [];

      $('.entity_presupuesto').each(function () {
        // Solamente va a recolectar los que sean nuevos, los ya existentes no son necesarios (en caso de que se edite)
        if ($(this).attr('data-nuevo')) {
          datos.push({
            tipo: $(this).find('.entity_presupuesto_tipo').attr('data-tipo-presupuesto'),
            cantidad: $(this).find('.entity_presupuesto_cantidad').text(),
            descripcion: $(this).find('.entity_presupuesto_descripcion').text(),
            precio: $(this).find('.entity_presupuesto_precio').attr('data-precio'),
            iva: ($(this).find('.entity_presupuesto_iva:checked').val()) ? $(this).find('.entity_presupuesto_iva:checked').val() : 0,
          });
        }
      });
      return datos;
    }


    $(document).on('click', '.editar_presupuesto', () => {
      $('.show_on_editing').show();
      $('.seleccion_presupuesto_container').hide();
      $('.editable_table_presupuesto').addClass('table-entities-presupuesto');
      $('.enviar_presupuesto_inicial').hide();
      $('.editar_presupuesto').hide();

      $('.sin_servicio_checkbox_editando').addClass('sin_servicio_checkbox');
      $('.cantidad_presupuesto_editando').addClass('cantidad_presupuesto');
      $('.tipo_presupuesto_editando').addClass('tipo_presupuesto');
      $('.tipo_servicio_presupuesto_editando').addClass('tipo_servicio_presupuesto');
      $('.descripcion_presupuesto_editando').addClass('descripcion_presupuesto');
      $('.precio_presupuesto_editando').addClass('precio_presupuesto');
      $('.agregar_entity_presupuesto_editando').addClass('agregar_entity_presupuesto');
      $('.entity_presupuesto_editando').addClass('entity_presupuesto');
      $('.entity_presupuesto_tipo_editando').addClass('entity_presupuesto_tipo');
      $('.entity_presupuesto_cantidad_editando').addClass('entity_presupuesto_cantidad');
      $('.entity_presupuesto_descripcion_editando').addClass('entity_presupuesto_descripcion');
      $('.entity_presupuesto_precio_editando').addClass('entity_presupuesto_precio');
      $('.entity_presupuesto_subtotal_editando').addClass('entity_presupuesto_subtotal');
      $('.entity_presupuesto_iva_editando').addClass('entity_presupuesto_iva');
      $('.eliminar_entity_presupuesto_editando').addClass('eliminar_entity_presupuesto');
      $('.total_presupuesto_editando').addClass('total_presupuesto');
      $('.entity_presupuesto_iva_editando').removeAttr('onclick');
    });

    $(document).on('click', '.guardar_edicion_presupuesto', function () {
      const btn = $(this);
      btn.partnersBtnControl('start');
      const datosEnvio = {};
      const id_registro = $(this).attr('data-id-registro');
      datosEnvio.datos = get_presupuesto_entities_data();
      datosEnvio.eliminados = [];
      datosEnvio.id_presupuesto = $(this).attr('data-id-presupuesto');
      datosEnvio.id_registro = id_registro;
      $('.deleted_entities_presupuesto .eliminated_tr').each(function () {
        datosEnvio.eliminados.push($(this).attr('data-id-dato'));
      });

      let validate_sin_servicio = false;
      $('.entity_presupuesto').each(function () {
        if ($(this).find('.entity_presupuesto_tipo').attr('data-tipo-presupuesto') == 2) {
          validate_sin_servicio = true;
        }
      });

      if ($('.sin_servicio_checkbox').is(':checked')) {
        validate_sin_servicio = true;
      }
      if (!validate_sin_servicio) {
        iziToast.error({
          title: 'Error',
          message: 'Si no vas a agregar servicio, seleccciona la opción de "Sin servicio".',
        });
        btn.partnersBtnControl('end');
        return false;
      }


      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}editar_presupuesto_inicial`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_presupuesto`, id_registro, 'presupuesto-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });

    $(document).on('click', '.cancelar_edicion_presupuesto', () => {
      $('.show_on_editing').hide();
      $('.enviar_presupuesto_inicial').show();
      $('.seleccion_presupuesto_container').show();
      $('.editable_table_presupuesto').removeClass('table-entities-presupuesto');
      $('.editar_presupuesto').show();


      $('.sin_servicio_checkbox_editando').removeClass('sin_servicio_checkbox');
      $('.cantidad_presupuesto_editando').removeClass('cantidad_presupuesto');
      $('.tipo_presupuesto_editando').removeClass('tipo_presupuesto');
      $('.tipo_servicio_presupuesto_editando').removeClass('tipo_servicio_presupuesto');
      $('.descripcion_presupuesto_editando').removeClass('descripcion_presupuesto');
      $('.precio_presupuesto_editando').removeClass('precio_presupuesto');
      $('.agregar_entity_presupuesto_editando').removeClass('agregar_entity_presupuesto');
      $('.entity_presupuesto_editando').removeClass('entity_presupuesto');
      $('.entity_presupuesto_tipo_editando').removeClass('entity_presupuesto_tipo');
      $('.entity_presupuesto_cantidad_editando').removeClass('entity_presupuesto_cantidad');
      $('.entity_presupuesto_descripcion_editando').removeClass('entity_presupuesto_descripcion');
      $('.entity_presupuesto_precio_editando').removeClass('entity_presupuesto_precio');
      $('.entity_presupuesto_subtotal_editando').removeClass('entity_presupuesto_subtotal');
      $('.entity_presupuesto_iva_editando').removeClass('entity_presupuesto_iva');
      $('.eliminar_entity_presupuesto_editando').removeClass('eliminar_entity_presupuesto');
      $('.total_presupuesto_editando').removeClass('total_presupuesto');
      $('.entity_presupuesto_iva_editando').attr('onclick', 'this.checked=!this.checked;');
    });

    /**
     * Enviar correo con presupuesto inicial
     */
    $(document).on('click', '.enviar_presupuesto_inicial', (e) => {
      const idCliente = +(e.currentTarget.getAttribute('data-id-cliente'));
      const idRegistro = +(e.currentTarget.getAttribute('data-id-registro'));
      // eslint-disable-next-line no-undef
      modalCorreo(
        idCliente,
        settings,
        idRegistro,
        (emailsToSend, datos, body, hideModal) => {
          const data = {
            to: emailsToSend,
            id_registro: datos,
            body,
          };
          $.ajax({
            type: 'POST',
            url: `${settings.taller.ruta_consultas}enviar_presupuesto_correo`,
            data: JSON.stringify(data),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success(response) {
              if (response.status === 'success') {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: 'Listo',
                  message: 'Correos enviados',
                });
                hideModal(true);
              } else if (response.status === 'error') {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: 'Error',
                  message: response.message,
                });
                hideModal(false);
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: 'Ocurrio un error: ',
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
              hideModal(false);
            },
          });
        },
      );
    });

    $(document).on('change', 'input[name="radio_seleccion_presupuesto"]', function () {
      $('.enviar_presupuesto_inicial').hide();
      $('.editar_presupuesto').hide();

      if ($(this).val() == 1) {
        // Cuando es que si, se deben de agregar todas las clases necesarias para que funcione bien y no
        // interfiera con el de editar
        $('.show_on_autorizando').show();
        $('.show_on_no_autorizado').hide();
        $('.autorizando_table_presupuesto').addClass('table-entities-presupuesto');

        $('.sin_servicio_checkbox_autorizando').addClass('sin_servicio_checkbox');
        $('.cantidad_presupuesto_autorizando').addClass('cantidad_presupuesto');
        $('.tipo_presupuesto_autorizando').addClass('tipo_presupuesto');
        $('.tipo_servicio_presupuesto_autorizando').addClass('tipo_servicio_presupuesto');
        $('.descripcion_presupuesto_autorizando').addClass('descripcion_presupuesto');
        $('.precio_presupuesto_autorizando').addClass('precio_presupuesto');
        $('.agregar_entity_presupuesto_autorizando').addClass('agregar_entity_presupuesto');
        $('.entity_presupuesto_autorizando').addClass('entity_presupuesto');
        $('.entity_presupuesto_tipo_autorizando').addClass('entity_presupuesto_tipo');
        $('.entity_presupuesto_cantidad_autorizando').addClass('entity_presupuesto_cantidad');
        $('.entity_presupuesto_descripcion_autorizando').addClass('entity_presupuesto_descripcion');
        $('.entity_presupuesto_precio_autorizando').addClass('entity_presupuesto_precio');
        $('.entity_presupuesto_subtotal_autorizando').addClass('entity_presupuesto_subtotal');
        $('.entity_presupuesto_iva_autorizando').addClass('entity_presupuesto_iva');
        $('.eliminar_entity_presupuesto_autorizando').addClass('eliminar_entity_presupuesto');
        $('.total_presupuesto_autorizando').addClass('total_presupuesto');
        $('.entity_presupuesto_iva_autorizando').removeAttr('onclick');

        $('#fecha_compromiso_container .input-group.date').datepicker({
          format: 'dd/mm/yyyy',
          todayBtn: 'linked',
          language: 'es',
          daysOfWeekDisabled: '0',
          autoclose: true,
          todayHighlight: true,
          startDate: 'today',
          orientation: 'auto',
          container: '.input-group.date',
        });
      } else {
        // Eliminar todas las clases para volver a su funcionamiento normal
        $('.sin_servicio_checkbox_autorizando').removeClass('sin_servicio_checkbox');
        $('.cantidad_presupuesto_autorizando').removeClass('cantidad_presupuesto');
        $('.tipo_presupuesto_autorizando').removeClass('tipo_presupuesto');
        $('.tipo_servicio_presupuesto_autorizando').removeClass('tipo_servicio_presupuesto');
        $('.descripcion_presupuesto_autorizando').removeClass('descripcion_presupuesto');
        $('.precio_presupuesto_autorizando').removeClass('precio_presupuesto');
        $('.agregar_entity_presupuesto_autorizando').removeClass('agregar_entity_presupuesto');
        $('.entity_presupuesto_autorizando').removeClass('entity_presupuesto');
        $('.entity_presupuesto_tipo_autorizando').removeClass('entity_presupuesto_tipo');
        $('.entity_presupuesto_cantidad_autorizando').removeClass('entity_presupuesto_cantidad');
        $('.entity_presupuesto_descripcion_autorizando').removeClass('entity_presupuesto_descripcion');
        $('.entity_presupuesto_precio_autorizando').removeClass('entity_presupuesto_precio');
        $('.entity_presupuesto_subtotal_autorizando').removeClass('entity_presupuesto_subtotal');
        $('.entity_presupuesto_iva_autorizando').removeClass('entity_presupuesto_iva');
        $('.eliminar_entity_presupuesto_autorizando').removeClass('eliminar_entity_presupuesto');
        $('.total_presupuesto_autorizando').removeClass('total_presupuesto');
        $('.entity_presupuesto_iva_autorizando').attr('onclick', 'this.checked=!this.checked;');

        $('.autorizando_table_presupuesto').removeClass('table-entities-presupuesto');
        $('.show_on_autorizando').hide();

        $('.show_on_no_autorizado').show();
      }
    });

    $(document).on('click', '.guardar_presupuesto_no_utorizado', function () {
      const btn = $(this);
      btn.partnersBtnControl('start');
      const id_presupuesto = $(this).attr('data-id-presupuesto');
      const id_registro = $(this).attr('data-id-registro');
      const datosEnvio = {};
      datosEnvio.id_registro = id_registro;
      datosEnvio.id_presupuesto = id_presupuesto;

      if ($.trim($('input[name="no_autorizado_por"]').val()) < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa quién decidió no autorizar el presupuesto.',
        });
        btn.partnersBtnControl('end');
        return false;
      }

      if (!$('input[name="radio_seleccion_que_hacer"]').is(':checked')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona que se desea hacer con el equipo.',
        });
        btn.partnersBtnControl('end');
        return false;
      }
      datosEnvio.no_autorizado_por = $('input[name="no_autorizado_por"]').val();
      datosEnvio.que_hacer = $('input[name="radio_seleccion_que_hacer"]:checked').val();

      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}no_autorizar_presupuesto`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_presupuesto`, id_registro, 'presupuesto-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });

    $(document).on('click', '.guardar_presupuesto_autorizado', function () {
      const btn = $(this);
      btn.partnersBtnControl('start');
      const id_presupuesto = $(this).attr('data-id-presupuesto');
      const id_registro = $(this).attr('data-id-registro');
      const datosEnvio = {};
      datosEnvio.id_registro = id_registro;
      datosEnvio.id_presupuesto = id_presupuesto;
      datosEnvio.datos = get_presupuesto_entities_data();
      let validate_sin_servicio = false;
      $('.entity_presupuesto').each(function () {
        if ($(this).find('.entity_presupuesto_tipo').attr('data-tipo-presupuesto') == 2) {
          validate_sin_servicio = true;
        }
      });

      if ($('.sin_servicio_checkbox').is(':checked')) {
        validate_sin_servicio = true;
      }
      if (!validate_sin_servicio) {
        iziToast.error({
          title: 'Error',
          message: 'Si no vas a agregar servicio, seleccciona la opción de "Sin servicio".',
        });
        btn.partnersBtnControl('end');
        return false;
      }

      if ($.trim($('input[name="autorizado_por"]').val()) < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa quién autorizó el presupuesto',
        });
        btn.partnersBtnControl('end');
        return false;
      }
      if (!$('#fecha_compromiso_container .input-group.date').datepicker('getDate')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona la fecha de compromiso.',
        });
        btn.partnersBtnControl('end');
        return false;
      }

      datosEnvio.fecha_compromiso = $('#fecha_compromiso_container .input-group.date').datepicker('getDate');
      datosEnvio.autorizado_por = $('input[name="autorizado_por"]').val();

      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}autorizar_presupuesto`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_presupuesto`, id_registro, 'presupuesto-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });

    $(document).on('click', '.editar_presupuesto_autorizado', () => {
      $('.show_on_editar_autorizado').show();
      $('.enviar_presupuesto_autorizado').hide();
      $('.editar_presupuesto_autorizado').hide();
    });

    $(document).on('click', '.cancelar_edicion_presupuesto_autorizado', () => {
      $('.show_on_editar_autorizado').hide();
      $('.enviar_presupuesto_autorizado').show();
      $('.editar_presupuesto_autorizado').show();
    });

    $(document).on('click', '.guardar_edicion_presupuesto_autorizado', function () {
      const btn = $(this);
      btn.partnersBtnControl('start');
      const datosEnvio = {};
      const id_registro = $(this).attr('data-id-registro');
      datosEnvio.datos = get_presupuesto_entities_data();
      datosEnvio.eliminados = [];
      datosEnvio.id_presupuesto = $(this).attr('data-id-presupuesto');
      datosEnvio.id_registro = id_registro;
      $('.deleted_entities_presupuesto .eliminated_tr').each(function () {
        datosEnvio.eliminados.push($(this).attr('data-id-dato'));
      });

      let validate_sin_servicio = false;
      $('.entity_presupuesto').each(function () {
        if ($(this).find('.entity_presupuesto_tipo').attr('data-tipo-presupuesto') == 2) {
          validate_sin_servicio = true;
        }
      });

      if ($('.sin_servicio_checkbox').is(':checked')) {
        validate_sin_servicio = true;
      }
      if (!validate_sin_servicio) {
        iziToast.error({
          title: 'Error',
          message: 'Si no vas a agregar servicio, seleccciona la opción de "Sin servicio".',
        });
        btn.partnersBtnControl('end');
        return false;
      }


      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}editar_presupuesto_autorizado`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_presupuesto`, id_registro, 'presupuesto-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });

    /**
     * Enviar correo con presupuesto inicial
     */
    $(document).on('click', '.enviar_presupuesto_autorizado', (e) => {
      const idCliente = +(e.currentTarget.getAttribute('data-id-cliente'));
      const idRegistro = +(e.currentTarget.getAttribute('data-id-registro'));
      // eslint-disable-next-line no-undef
      modalCorreo(
        idCliente,
        settings,
        idRegistro,
        (emailsToSend, datos, body, hideModal) => {
          const data = {
            to: emailsToSend,
            id_registro: datos,
            body,
          };
          $.ajax({
            type: 'POST',
            url: `${settings.taller.ruta_consultas}enviar_presupuesto_correo_autorizado`,
            data: JSON.stringify(data),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success(response) {
              if (response.status === 'success') {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: 'Listo',
                  message: 'Correos enviados',
                });
                hideModal(true);
              } else if (response.status === 'error') {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: 'Error',
                  message: response.message,
                });
                hideModal(false);
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: 'Ocurrio un error: ',
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
              hideModal(false);
            },
          });
        },
      );
    });
    //* **************************************************************
    // -------------------------- PRESUPUESTO  -----------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------- STATUS PROCESO   --------------------
    //* **************************************************************
    $(document).on('click', '.status_proceso', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      $(this).partnersModal({
        title: 'Proceso',
        modalId: 'proceso-modal',
        forceWidth: 90,
        content: loader,
      });

      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_consultas}vista_proceso`,
        data: JSON.stringify(id_registro),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#proceso-modal .modal-body').html(response.message);
            setTimeout(() => {
              $.validate({
                form: '#form-proceso',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid',
              });
            }, 500);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    $(document).on('submit', '#form-proceso', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      const datosEnvio = {};
      datosEnvio.datos = get_revision_data('#form-proceso');

      const id_registro = $(this).attr('data-id-registro');

      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes de seleccionar al menos un proceso.',
        });
        btn.partnersBtnControl('end');
        return false;
      }
      datosEnvio.id_registro = id_registro;

      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}capturar_proceso`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_proceso`, id_registro, 'proceso-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });
    //* **************************************************************
    // ------------------------- STATUS PROCESO   --------------------
    //* **************************************************************


    //* **************************************************************
    // ---------------------- STATUS REVISIÓN FINAL ------------------
    //* **************************************************************
    $(document).on('click', '.revision_final', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      $(this).partnersModal({
        title: 'Revisión Final',
        modalId: 'revision-final-modal',
        forceWidth: 90,
        content: loader,
      });

      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_consultas}vista_revision_final`,
        data: JSON.stringify(id_registro),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#revision-final-modal .modal-body').html(response.message);
            setTimeout(() => {
              $.validate({
                form: '#form-revision-final',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid',
              });
            }, 500);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    $(document).on('submit', '#form-revision-final', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      const datosEnvio = {};
      datosEnvio.datos = get_revision_data('#form-revision-final');

      const id_registro = $(this).attr('data-id-registro');

      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes de seleccionar al menos un proceso de la revisión final.',
        });
        btn.partnersBtnControl('end');
        return false;
      }
      datosEnvio.id_registro = id_registro;

      auth_user((user_authenticated) => {
        datosEnvio.uid = JSON.parse(user_authenticated)[0];
        const envio = JSON.stringify(datosEnvio);
        $.ajax({
          type: 'POST',
          url: `${settings.taller.ruta_consultas}capturar_revision_final`,
          data: envio,
          contentType: 'application/json; charset=utf-8',
          dataType: 'json',
          success(response) {
            if (response.status == 'success') {
              iziToast.success({
                title: 'Bien! ',
                message: response.message,
              });
              update_info(`${settings.taller.ruta_consultas}vista_revision_final`, id_registro, 'revision-final-modal');
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      });
    });
    //* **************************************************************
    // ---------------------- STATUS REVISIÓN FINAL ------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------ STATUS ENTREGADO  --------------------
    //* **************************************************************
    $(document).on('click', '.status_entregado', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      const datosEnvio = {};
      datosEnvio.id_registro = id_registro;
      $(this).partnersObs(
        {
          modalId: 'observaciones-taller',
          ajaxUrl: `${settings.taller.ruta_sys_tools}load_obs`,
          index: 'id_registro',
          id_index: id_registro,
          tabla: 'partners_taller',
          auth_user: true,
          closeAfterSuccess: true,
          col: 'observaciones',
          ajaxSuccessCallback(user_authenticated) {
            datosEnvio.uid = JSON.parse(user_authenticated)[0];
            const envio = JSON.stringify(datosEnvio);
            $.ajax({
              type: 'POST',
              url: `${settings.taller.ruta_consultas}capturar_entregado`,
              data: envio,
              contentType: 'application/json; charset=utf-8',
              dataType: 'json',
              success(response) {
                if (response.status == 'success') {
                  iziToast.success({
                    title: 'Bien! ',
                    message: response.message,
                  });
                  autoUpdate.forceUpdate();
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: 'Error',
                    message: response.message,
                  });
                }
              },
              error(xhr) {
                iziToast.error({
                  title: 'Ocurrio un error: ',
                  message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                });
              },
            });
          },
        },
      );
    });
    //* **************************************************************
    // ------------------------ STATUS ENTREGADO  --------------------
    //* **************************************************************


    //* **************************************************************
    // -------------------------- OBSERVACIONES   --------------------
    //* **************************************************************
    $(document).on('click', '.taller-observaciones', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      const datosEnvio = {};
      datosEnvio.id_registro = id_registro;
      $(this).partnersObs(
        {
          modalId: 'observaciones-taller',
          ajaxUrl: `${settings.taller.ruta_sys_tools}load_obs`,
          index: 'id_registro',
          id_index: id_registro,
          tabla: 'partners_taller',
          auth_user: true,
          closeAfterSuccess: false,
          col: 'observaciones',
          ajaxSuccessCallback() {
            autoUpdate.forceUpdate();
          },
        },
      );
    });
    //* **************************************************************
    // -------------------------- OBSERVACIONES   --------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------ IMPRIMIR REGISTRO --------------------
    //* **************************************************************
    $(document).on('click', '.imprimir_registro', function () {
      const id_registro = $(this).parents('tr').attr('data-id-registro');
      const status_presupuesto = $(this).parents('tr').attr('data-status-presupuesto');

      if (status_presupuesto == 0 || status_presupuesto == 1) {
        iziToast.show({
          color: 'dark',
          icon: 'fa fa-folder-open-o',
          title: 'Reporte',
          message: 'Cuál deseas ver?',
          position: 'center',
          progressBarColor: 'rgb(0, 255, 184)',
          buttons: [
            ['<button>Recepción</button>', function (instance, toast) {
              window.open(`${settings.taller.ruta_vista_reporte + id_registro}/${1}`);
              instance.hide({
                transitionOut: 'fadeOutUp',
              }, toast, 'close', 'btn1');
            }],
          ],
        });
      } else if (status_presupuesto == 2) {
        iziToast.show({
          color: 'dark',
          icon: 'fa fa-folder-open-o',
          title: 'Reporte',
          message: 'Cuál deseas ver?',
          position: 'center',
          progressBarColor: 'rgb(0, 255, 184)',
          buttons: [
            ['<button>Recepción</button>', function (instance, toast) {
              window.open(`${settings.taller.ruta_vista_reporte + id_registro}/${1}`);
              instance.hide({
                transitionOut: 'fadeOutUp',
              }, toast, 'close', 'btn1');
            }],
            ['<button>Reporte</button>', function (instance, toast) {
              window.open(`${settings.taller.ruta_vista_reporte + id_registro}/${2}`);
              instance.hide({
                transitionOut: 'fadeOutUp',
              }, toast, 'close', 'btn2');
            }],
          ],
        });
      } else if (status_presupuesto == 3) {
        iziToast.show({
          color: 'dark',
          icon: 'fa fa-folder-open-o',
          title: 'Reporte',
          message: 'Cuál deseas ver?',
          position: 'center',
          progressBarColor: 'rgb(0, 255, 184)',
          buttons: [
            ['<button>Recepción</button>', function (instance, toast) {
              window.open(`${settings.taller.ruta_vista_reporte + id_registro}/${1}`);
              instance.hide({
                transitionOut: 'fadeOutUp',
              }, toast, 'close', 'btn1');
            }],
            ['<button>No Autorizado</button>', function (instance, toast) {
              window.open(`${settings.taller.ruta_vista_reporte + id_registro}/${5}`);
              instance.hide({
                transitionOut: 'fadeOutUp',
              }, toast, 'close', 'btn2');
            }],
          ],
        });
      }
    });
    //* **************************************************************
    // ------------------------ IMPRIMIR REGISTRO --------------------
    //* **************************************************************


    //* **************************************************************
    // ----------------------- GET REVISION DATA  --------------------
    //* **************************************************************
    /**
     * Función para obtener todos los datos llenados en cada revisión y almacenarlos en un array.
     * @param form {String} Se basa en este formulario para buscar los datos de dicha revisión.
     * @returns {Array} con los datos llenados de la revisión
     */
    function get_revision_data(form) {
      const data = [];
      $(form).find('.entity_revision_dato').each(function () {
        if ($(this).attr('type') == 'checkbox') {
          if ($(this).is(':checked')) {
            data.push({
              id_tipo_dato: $(this).attr('data-id-tipo-dato'),
              type: 'checkbox',
              value: 1,
            });
          }
        } else if ($(this).attr('type') == 'text') {
          if ($.trim($(this).val()).length > 0) {
            data.push({
              id_tipo_dato: $(this).attr('data-id-tipo-dato'),
              type: 'text',
              value: $(this).val(),
            });
          }
        }
      });
      return data;
    }

    //* **************************************************************
    // ----------------------- GET REVISION DATA  --------------------
    //* **************************************************************

    //* **************************************************************
    // --------------------------- UPDATE INFO -----------------------
    //* **************************************************************
    /**
     * Esta función se ejecutará para actualizar las vistas una vez se realice algún cambio en
     * alguna vista.
     * @param ruta {string} a la cual hacer la consulta de la vista
     * @param id_registro {int}
     * @param id_modal {string} id del modal al cual mostrar la vista
     */
    function update_info(ruta, id_registro, id_modal) {
      $(`#${id_modal} .modal-body`).html(loader);
      $.ajax({
        type: 'POST',
        url: ruta,
        data: JSON.stringify(id_registro),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $(`#${id_modal} .modal-body`).html(response.message);
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    //* **************************************************************
    // --------------------------- UPDATE INFO -----------------------
    //* **************************************************************

    //* **************************************************************
    // --------------------- SERVICIOS INFORM ERRORS -----------------
    //* **************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      const error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: `${settings.taller.ruta_sys_tools}report_error`,
        data: JSON.stringify(error),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: 'Se ha enviado el error!',
              type: 'success',
              text: 'Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.',
              timer: 4000,
              showConfirmButton: false,
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // --------------------- SERVICIOS INFORM ERRORS -----------------
    //* **************************************************************


    //* **************************************************************
    // --------------------- TALLER ESTATUS PROBLEMA -----------------
    //* **************************************************************
    $(document).on('click', '.status_problema', function () {
      const problema = +!(+$(this).parents('tr').attr('data-status-problema'));
      const folio = $(this).parents('tr').attr('data-id-registro');
      const envio = {};
      envio.problema = problema;
      envio.folio = folio;
      // eslint-disable-next-line no-undef
      swal({
        title: 'Motivo',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose() {
          $('body').removeAttr('style');
        },
        preConfirm(reason) {
          return new Promise(((resolve, reject) => {
            if (!reason) {
              reject(new Error('Debes ingresar un motivo!'));
            } else {
              envio.motivo = reason;
              // eslint-disable-next-line no-undef
              auth_user((user_authenticated) => {
                envio.user = JSON.parse(user_authenticated)[1];
                $.ajax({
                  type: 'POST',
                  url: `${settings.taller.ruta_consultas}status_problema`,
                  data: JSON.stringify(envio),
                  contentType: 'application/json; charset=utf-8',
                  dataType: 'json',
                  success(response) {
                    if (response.status === 'success') {
                      // eslint-disable-next-line no-undef
                      iziToast.success({
                        title: 'Bien! ',
                        message: response.message,
                      });
                      resolve();
                    } else if (response.status === 'error') {
                      // eslint-disable-next-line no-undef
                      iziToast.error({
                        title: 'Error',
                        message: response.message,
                      });
                    }
                  },
                  error(xhr) {
                    // eslint-disable-next-line no-undef
                    iziToast.error({
                      title: 'Ocurrio un error: ',
                      message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                    });
                  },
                });
              }, () => {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: 'Ocurrio un error: ',
                  message: `No se pudo identificar al usuario`,
                });
                // eslint-disable-next-line no-undef
                swal.close();
              });
            }
          })).catch((error) => {
            // eslint-disable-next-line no-undef
            swal.showValidationError(error);
          });
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (a.dismiss !== 'cancel') {
          // eslint-disable-next-line no-undef
          swal('Bien!', 'Se ha actualizado el estatus correctamente.', 'success');
          autoUpdate.forceUpdate();
        }
      });
    });
    //* **************************************************************
    // --------------------- TALLER ESTATUS PROBLEMA -----------------
    //* **************************************************************
  });
}(jQuery));
