(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    //***************************************************************
    //----------------------- SOLICITAR FACTURA ---------------------
    //***************************************************************
    setTimeout(function () {
      $.validate({
        form: '#cliente_nuevo_form',
        errorMessageClass: 'invalid-feedback',
        inputParentClassOnError: 'text-danger',
        inputParentClassOnSuccess: 'text-success',
        errorElementClass: 'is-invalid'
      });
      $.validate({
        form: '#cliente_existente_form',
        errorMessageClass: 'invalid-feedback',
        inputParentClassOnError: 'text-danger',
        inputParentClassOnSuccess: 'text-success',
        errorElementClass: 'is-invalid'
      });

      $('#buscar_cliente').typeahead({
        order: "asc",
        minlength: 1,
        maxItem: 15,
        hint: true,
        accent: true,
        group: {
          template: "{{group}}"
        },
        maxItemPerGroup: 5,
        backdrop: {
          "background-color": "#fff"
        },
        template: function (query, item) {
          var color_t_clasificacion;
          var tipo_clasificacion = item.tipo_clasificacion;
          var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
          switch (tipo_clasificacion) {
            case 'a':
              color_t_clasificacion = "success";
              break;
            case 'b':
              color_t_clasificacion = "success";
              break;
            case 'c':
              color_t_clasificacion = "warning";
              break;
            case 'd':
              color_t_clasificacion = "danger";
              break;
            case 'e':
              color_t_clasificacion = "danger";
              break;
            case "p":
              color_t_clasificacion = "success";
              credito_contado =
                "Saldo: " +
                (item.saldo_horas != 1
                  ? item.saldo_horas + " horas"
                  : item.saldo_horas + " hora");

              break;
          }
          tipo_clasificacion = tipo_clasificacion.toUpperCase();

          return '<p>' +
            '<span>{{nombre_cliente}}</span> ' +
            '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
            '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
            ' | ' + credito_contado + '</span> </p> ';
        },
        dynamic: true,
        dropdownFilter: "Todos",
        emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
        source: {
          "Clientes": {
            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
            ajax: {
              url: settings.solicitud_factura.ruta_lista_clientes + 'complete',
              path: "data.datos.clientes",
            }
          },
          "Contactos": {
            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
            ajax: {
              url: settings.solicitud_factura.ruta_lista_clientes + 'complete',
              path: "data.datos.contactos",
            }
          },
          "Proveedores": {
            display: ["nombre_cliente"],
            ajax: {
              url: settings.solicitud_factura.ruta_lista_clientes + 'complete',
              path: "data.datos.proveedores",
            }
          }
        },
        callback: {
          onClickAfter: function (node, a, item) {
            var color_t_clasificacion;
            var tipo_clasificacion = item.tipo_clasificacion;
            var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
            switch (tipo_clasificacion) {
              case 'a':
                color_t_clasificacion = "success";
                break;
              case 'b':
                color_t_clasificacion = "success";
                break;
              case 'c':
                color_t_clasificacion = "warning";
                break;
              case 'd':
                color_t_clasificacion = "danger";
                break;
              case 'e':
                color_t_clasificacion = "danger";
                break;
              case "p":
                color_t_clasificacion = "success";
                credito_contado =
                  "Saldo: " +
                  (item.saldo_horas != 1
                    ? item.saldo_horas + " horas"
                    : item.saldo_horas + " hora");
                break;
            }
            tipo_clasificacion = tipo_clasificacion.toUpperCase();
            $('.quick_info_client').html('<span class="float-left badge badge-' + color_t_clasificacion + '">' +
              '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
              ' | ' + credito_contado + '</span> </p> ');


            //Bindear el id del cliente al input
            node.attr('data-id-cliente', item.id_cliente);

            node.attr('data-email-cliente', item.email);

          },
          onSearch: function (node, a) {
            if (a !== '') {
            } else {
              // Para prevenir errores de sobrescribir o duplicar
              $('.quick_info_client').html('');
              node.removeAttr('data-id-cliente');
              node.removeAttr('data-email-cliente');
            }


          }

        }
      });
    }, 500);
    $(document).on('change', '.radio_solicitar_factura', function () {
      if ($(this).val() == 1) {
        $('.container_cliente_existente').show();
        $('.container_cliente_nuevo').hide();
      } else {
        $('.container_cliente_nuevo').show();
        $('.container_cliente_existente').hide();
      }
    });

    //***************************************************************
    //----------------------- SOLICITAR FACTURA ---------------------
    //***************************************************************


    //***************************************************************
    //----------------- CAPTURAR FACTURA CLIENTE EXISTENTE  ---------
    //***************************************************************
    $(document).on('submit', '#cliente_existente_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var datos = $('#cliente_existente_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      if (!$('#buscar_cliente').attr('data-id-cliente')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un cliente.'
        });
        return false;
      }
      datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
      btn.partnersBtnControl('start');
      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.solicitud_factura.ruta_consultas + 'capturar_solicitud_cliente_existente',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            swal(
              'Bien!',
              'Se ha enviado tu solicitud de factura!',
              'success'
            );
            setTimeout(function () {
              window.location.replace('/');
            }, 2000);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //----------------- CAPTURAR FACTURA CLIENTE EXISTENTE  ---------
    //***************************************************************


    //***************************************************************
    //--------------- CAPTURAR FACTURA CLIENTE NUEVO ----------------
    //***************************************************************
    $(document).on('submit', '#cliente_nuevo_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#cliente_nuevo_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.solicitud_factura.ruta_consultas + 'capturar_solicitud_cliente_nuevo',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            swal(
              'Bien!',
              'Se ha enviado tu solicitud de factura!',
              'success'
            );
            setTimeout(function () {
              window.location.replace('/');
            }, 2000);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //--------------- CAPTURAR FACTURA CLIENTE NUEVO ----------------
    //***************************************************************


  });
})
  (jQuery);
