(function ($) {
  const settings = Drupal.settings;
  $(document).ready(() => {
    var id_pendiente = false;
    if (getUrlVars().id_pendiente) {
      id_pendiente = getUrlVars().id_pendiente;
      window.history.pushState("servicios", "Servicios", "/servicios");
      setTimeout(() => {
        $(".nuevo_reporte").click();
      }, 500);
    }
    const loader =
      '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';
    //* **************************************************************
    // -------------------- REPORTE BASE SERVICIO  -------------------
    //* **************************************************************
    // Auto Update
    const autoUpdate = new AutoUpdate({
      toUpdate() {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    /**
     *
     * @type {{
     * pagination: {
     *      page: number
     * },
     * sort: {
     *      order: string,
     *      sort_by: string //Tiene que ser el nombre de la columna de la tabla
     * },
     * automatic_update: number,
     * updating: number
     * }}
     */
    const r_options = {
      pagination: {
        page: 1,
      },
      sort: {
        order: "DESC",
        sort_by: "id_servicio",
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        tipo_servicio: null,
        tecnico: null,
        usuario_recibe: null,
        sin_pagar: null,
        compartidos: null,
        falta_costo: null,
        start_date: null,
        end_date: null,
        compartido_con: null,
      },
      reporte_admin: $("#reporteador_admin").val(),
    };

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $("#reporteador").find(".table").css("opacity", 0.5);
      }
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}reporte_base`,
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success(data) {
          $("#reporteador").html(data);
          $("#table_reporteador_servicios").stickyTableHeaders();
          $("#table_reporteador_servicios").partnersfilter({
            table: "#table_reporteador_servicios",
            sumatory: true,
            sumatory_cols: [
              "col-servicio",
              "col-venta",
              "col-costo",
              "col-total",
              "col-comision",
            ],
          });
          // Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    $(document).on("click", "#reset_filters", () => {
      r_options.filter.search_bar = null;
      r_options.filter.tipo_servicio = null;
      r_options.filter.tecnico = null;
      r_options.filter.usuario_recibe = null;
      r_options.filter.sin_pagar = null;
      r_options.filter.compartidos = null;
      r_options.filter.falta_costo = null;
      r_options.filter.compartido_con = null;
      $(".input_buscador_servicio").val("");
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
    });

    // Filtrado - Texto
    $(document).on("keyup", ".input_buscador_servicio", function (e) {
      clearTimeout($.data(this, "timer"));
      if (e.keyCode == 13) search(true);
      else $(this).data("timer", setTimeout(search, 200));
    });

    function search() {
      const StringtoSearch = $(".input_buscador_servicio").val();
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

    // Filtrado - Técnico
    $(document).on("change", "#filtrado_tecnico", function () {
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.tecnico = $(this).find("option:selected").val();
      autoUpdate.forceUpdate();
    });

    // Filtrado - Usuario Recibe
    $(document).on("change", "#filtrado_usuario_recibe", function () {
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.usuario_recibe = $(this).find("option:selected").val();
      autoUpdate.forceUpdate();
    });

    // Filtrado - Compartido Con
    $(document).on("change", "#filtrado_compartido_con", function () {
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.compartido_con = $(this).find("option:selected").val();
      autoUpdate.forceUpdate();
    });

    // Filtrado - Sin Pagar
    $(document).on("change", ".filtro_sin_pagar", function () {
      if ($(this).is(":checked")) {
        r_options.filter.sin_pagar = 1;
      } else {
        r_options.filter.sin_pagar = 0;
      }
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      autoUpdate.forceUpdate();
    });

    // Filtrado - Compartidos
    $(document).on("change", ".filtro_compartidos", function () {
      if ($(this).is(":checked")) {
        r_options.filter.compartidos = 1;
      } else {
        r_options.filter.compartidos = 0;
      }
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      autoUpdate.forceUpdate();
    });

    // Filtrado - Falta Costo
    $(document).on("change", ".filtro_falta_costo", function () {
      if ($(this).is(":checked")) {
        r_options.filter.falta_costo = 1;
      } else {
        r_options.filter.falta_costo = 0;
      }
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      autoUpdate.forceUpdate();
    });

    // Filtrado - Tipo Servicio
    $(document).on("click", ".filtro_tipo_servicio", function () {
      let chk_arr = [];
      if (r_options.filter.tipo_servicio != null) {
        chk_arr = r_options.filter.tipo_servicio.split(",");
      }
      // Si lo marcan, lo agrega al array
      if ($(this).is(":checked")) {
        chk_arr.push($(this).val());
      } else {
        const indx_to_remove = chk_arr.indexOf($(this).val());
        chk_arr.splice(indx_to_remove, 1);
      }
      let chk_arr_str = chk_arr.toString();
      if (chk_arr_str[0] == ",") {
        chk_arr_str = chk_arr_str.substring(1);
      }
      r_options.filter.tipo_servicio = chk_arr_str;
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
    });

    //* **************************************************************
    // -------------------- REPORTE BASE SERVICIO  -------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------------ DATE PICKER --------------------------
    //* **************************************************************

    const start = moment().startOf("month");
    const end = moment().endOf("month");

    function cb(start, end) {
      $("#reportrange span").html(
        `${start.format("DD/MM/YYYY")} - ${end.format("DD/MM/YYYY")}`
      );
    }

    cb(start, end);
    $("#reportrange").daterangepicker(
      {
        autoApply: true,
        linkedCalendars: false,
        parentEl: ".parent-calendar",
        locale: {
          format: "DD/MM/YYYY",
          separator: " - ",
          applyLabel: "Aplicar",
          cancelLabel: "Cancelar",
          fromLabel: "Desde",
          toLabel: "Hasta",
          customRangeLabel: "Personalizado",
          weekLabel: "S",
          daysOfWeek: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
          monthNames: [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre",
          ],
          firstDay: 1,
        },
        startDate: start,
        endDate: end,
        showDropdowns: true,
        ranges: {
          Enero: [
            moment().month("January").startOf("month"),
            moment().month("January").endOf("month"),
          ],
          Julio: [
            moment().month("July").startOf("month"),
            moment().month("July").endOf("month"),
          ],
          "Mes Anterior": [
            moment().subtract(1, "month").startOf("month"),
            moment().subtract(1, "month").endOf("month"),
          ],
          Febrero: [
            moment().month("February").startOf("month"),
            moment().month("February").endOf("month"),
          ],
          Agosto: [
            moment().month("August").startOf("month"),
            moment().month("August").endOf("month"),
          ],
          Hoy: [moment(), moment()],
          Marzo: [
            moment().month("March").startOf("month"),
            moment().month("March").endOf("month"),
          ],
          Septiembre: [
            moment().month("September").startOf("month"),
            moment().month("September").endOf("month"),
          ],
          "Semana Actual": [moment().startOf("week"), moment().endOf("week")],
          Abril: [
            moment().month("April").startOf("month"),
            moment().month("April").endOf("month"),
          ],
          Octubre: [
            moment().month("October").startOf("month"),
            moment().month("October").endOf("month"),
          ],
          "Mes Actual": [moment().startOf("month"), moment().endOf("month")],
          Mayo: [
            moment().month("May").startOf("month"),
            moment().month("May").endOf("month"),
          ],
          Noviembre: [
            moment().month("November").startOf("month"),
            moment().month("November").endOf("month"),
          ],
          "Año Actual": [moment().startOf("year"), moment().endOf("year")],
          Junio: [
            moment().month("June").startOf("month"),
            moment().month("June").endOf("month"),
          ],
          Diciembre: [
            moment().month("December").startOf("month"),
            moment().month("December").endOf("month"),
          ],
        },
      },
      cb
    );

    $("#reportrange").on("apply.daterangepicker", () => {
      const fecha = $("#reportrange").find("span").text();
      const fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table").css("opacity", 0.5);
    });

    (function () {
      const fecha = $("#reportrange").find("span").text();
      const fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table").css("opacity", 0.5);
    })();
    //* **************************************************************
    // ------------------------ DATE PICKER --------------------------
    //* **************************************************************

    //* **************************************************************
    // --------------------------- LOAD USERS  -----------------------
    //* **************************************************************
    function load_users(select) {
      select = $(select);
      if (select.attr("data-users-laoded")) return false;
      select.find("option").each(function () {
        if ($(this).attr("data-remove")) {
          $(this).remove();
        }
      });
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_sys_tools}user_list`,
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            $.each(JSON.parse(response.message), (key, val) => {
              select.append(
                `<option value="${val.uid}" data-remove="1">${val.name}</option>`
              );
            });
            select.attr("data-users-laoded", 1);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    //* **************************************************************
    // --------------------------- LOAD USERS  -----------------------
    //* **************************************************************

    //* **************************************************************
    // ---------------------- GENERATE FROM PENDIENTE ----------------
    //* **************************************************************
    function generate_from_pendiente(id_pendiente) {
      let template = "";
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}get_datos_from_pendiente`,
        data: JSON.stringify(id_pendiente),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            const datos = JSON.parse(response.message);
            template += `<div class="row"><div class="col-md-12"><label class="font-weight-bold">Cliente: </label> ${datos.nombre_cliente
              } <span class="float-right badge badge-secondary"> <i class="fa fa-star" aria-hidden="true"></i>: ${datos.tipo_clasificacion.toUpperCase()} | ${datos.tipo_clasificacion.toUpperCase() == "P"
                ? "Prepago"
                : datos.credito_contado
              }</div></div>`;
            template += `<div class="row"><div class="col-md-12"><label class="font-weight-bold">Fecha y hora del reporte: </label> ${moment
              .unix(datos.created_at)
              .format("DD/MM/YYYY HH:mm")}</div></div>`;
            template += `<div class="row"><div class="col-md-12"><label class="font-weight-bold">Reporte de servicio: </label> ${datos.descripcion_pendiente}</div></div>`;
            template += `<div class="row"><div class="col-md-12"><label class="font-weight-bold">Quién reportó: </label> ${datos.quien_reporta_pendiente}</div></div>`;

            $(".datos_from_pendiente_container .card-body").html(template);

            $('.display_from_pendiente input.select_tipo_servicio[value="4"]').click();
            if (datos.tipo_clasificacion.toUpperCase() == "P") {
              $(".no_tipo_p").hide();
              $(".tipo_p").show();
            } else {
              $(".tipo_p").hide();
              $(".no_tipo_p").show();
            }

            $(".datos_from_pendiente_container").attr("data-id-cliente", datos.id_cliente);
            $(".datos_from_pendiente_container").attr("data-id-pendiente", id_pendiente);
            $(".datos_from_pendiente_container").attr("data-email-cliente", datos.email);
            $(".datos_from_pendiente_container").attr("data-tipo-negocio", datos.tipo_negocio);
            $(".datos_from_pendiente_container").attr("data-tipo-clasificacion", datos.tipo_clasificacion.toUpperCase());

            $(".datos_from_pendiente_container").attr("data-saldo-horas", parseInt(datos.saldo_horas));

            var poliza_activa = buscar_poliza(datos.id_cliente);
            //console.log(poliza_activa);
            //console.log(poliza_activa);
            $(".datos_from_pendiente_container").attr("data-folio-poliza", poliza_activa.id_poliza);

            // Ya viene de pendiente y no necesito cliente
            $(".container_buscador_cliente").remove();

            $(".seleccion_piezas_domicilio_container").show();
            $(".recibido_por_container").show();
            // Si el cliente es de tipo negocio, generar la lista de contactos, sino, mostrar el campo
            // para ingresar quien reporta servicio.
            if (datos.tipo_negocio == 1) {
              // Generar la lista de contactos del cliente
              generar_contactos(
                settings.servicios.ruta_lista_contactos,
                datos.id_cliente
              );
              $(".recibido_por_container").hide();
            } else {
              $(".recibido_por_container").show();
            }

            $(".poliza_container").html("");
            if (datos.tipo_clasificacion.toUpperCase() == "P") {
              // buscar Saldo del cliente, si no tiene o no tiene poliza o no es tipo P, que solo muestre el boton de nueva poliza
              var poliza_activa = buscar_poliza(
                $(".datos_from_pendiente_container").attr("data-id-cliente")
              );
              var fecha = new Date(poliza_activa.fecha * 1000);
              var vencimiento = new Date(poliza_activa.vencimiento * 1000);
              $(".poliza_container").show();
              $(".poliza_container").attr("style", "display: inline");
              $(".poliza_container").html(
                `<div class="row"><label class="col-md-2 col-sm-12 col-form-label">Paquete</label><div class="col-md-12" ="display:inline"><table class="table table-sm">
                      <thead>
                        <tr>
                          <th scope="col">Fecha</th>
                          <th scope="col">Horas incluidas</th>
                          <th scope="col">Horas utilizadas</th>
                          <th scope="col">Saldo</th>
                          <th scope="col">Vencimiento</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                          <td>${fecha.toLocaleDateString()}</td>
                          <td>${poliza_activa.horas_incluidas}</td>
                          <td>${poliza_activa.horas_usadas}</td>
                          <td>${poliza_activa.saldo_cliente}</td>
                          <td>${vencimiento.toLocaleDateString()}</td>
                        </tr></tbody></table></div></div>`
              );
              $(".no_tipo_p").hide();
              $(".tipo_p").show();
            } else {
              $(".tipo_p").hide();
              $(".no_tipo_p").show();
            }
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    //* **************************************************************
    // ---------------------- GENERATE FROM PENDIENTE ----------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- NUEVO SERVICIO  -----------------------
    //* **************************************************************
    $(document).on("click", ".nuevo_reporte", function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: "Selecciona el tipo de servicio",
        ajaxUrl: `${settings.servicios.render_template}servicios.nuevo_servicio_form`,
        forceWidth: 70,
        modalId: "vista-nuevo-servicio-modal",
        preventHideOnBackdrop: true,
        ajaxSuccessCallback() {
          setTimeout(() => {
            if (id_pendiente != false) {
              $(".datos_from_pendiente_container").show();
              $(".display_from_pendiente").show();
              generate_from_pendiente(id_pendiente);
            }
            $.validate({
              form: "#new_servicio_form",
              errorMessageClass: "invalid-feedback",
              inputParentClassOnError: "text-danger",
              inputParentClassOnSuccess: "text-success",
              errorElementClass: "is-invalid",
            });
            $("#new_servicio_form").attr(
              "data-user-email",
              $(".user_email").val()
            );
            $("#calculo_hora_inicio").datetimepicker({
              format: "LT",

              icons: {
                time: "fa fa-clock-o",
                date: "fa fa-calendar",
                up: "fa fa-arrow-up",
                down: "fa fa-arrow-down",
              },
              tooltips: {
                pickHour: "Selecciona la hora",
                incrementHour: "Aumentar hora",
                decrementHour: "Disminuir hora",
                pickMinute: "Selecciona un minuto",
                incrementMinute: "Aumentar minuto",
                decrementMinute: "Disminuir minuto",
                togglePeriod: "Cambiar periodo",
              },
            });

            $("#calculo_hora_final").datetimepicker({
              format: "LT",
              icons: {
                time: "fa fa-clock-o",
                date: "fa fa-calendar",
                up: "fa fa-arrow-up",
                down: "fa fa-arrow-down",
              },
              tooltips: {
                pickHour: "Selecciona la hora",
                incrementHour: "Aumentar hora",
                decrementHour: "Disminuir hora",
                pickMinute: "Selecciona un minuto",
                incrementMinute: "Aumentar minuto",
                decrementMinute: "Disminuir minuto",
                togglePeriod: "Cambiar periodo",
              },
            });
          }, 500);
        },
      });
      autoUpdate.control.pause();
      $("#vista-nuevo-servicio-modal").on("hidden.bs.modal", () => {
        autoUpdate.control.resume();
      });
    });

    $(document).on("dp.change", "#calculo_hora_final", () => {
      calculate_hours_service();
    });

    $(document).on("dp.change", "#calculo_hora_inicio", (e) => {
      $("#calculo_hora_final").removeAttr("disabled");
      $("#calculo_hora_final").data("DateTimePicker").minDate(e.date);
      calculate_hours_service();
    });

    $(document).on("change", ".calculo_sin_tiempo", function () {
      if ($(this).is(":checked")) {
        $("#calculo_hora_inicio").attr("disabled", true);
        $("#calculo_hora_inicio").val("");
        $("#calculo_hora_final").attr("disabled", true);
        $("#calculo_hora_final").val("");
        $(".total_calculation_hours_text").html("Sin cálculo de tiempo");
      } else {
        $("#calculo_hora_inicio").removeAttr("disabled");
        $("#calculo_hora_final").removeAttr("disabled");
        $(".total_calculation_hours_text").html("");
      }
    });

    $(document).on("change", ".select_tipo_servicio", function () {
      // Init
      var tipo_clasificacion = $(".datos_from_pendiente_container").attr(
        "data-tipo-clasificacion"
      );
      $("#vista-nuevo-servicio-modal")
        .find(".modal-title")
        .html("Nuevo Servicio");
      $(".new_servicio_form_container").show();
      $("#fecha-servicio-container .input-group.date").datepicker({
        format: "dd/mm/yyyy",
        todayBtn: "linked",
        language: "es",
        daysOfWeekDisabled: "0",
        autoclose: true,
        todayHighlight: true,
        container: ".input-group.date",
      });
      var tipo = $(this).val();
      load_users(".lista_users");
      load_users(".lista_users_compartido");
      // Reset
      $(".init_pieza_container").each(function () {
        $(this).remove();
      });
      $(".entity_pieza_container").each(function () {
        $(this).remove();
      });
      $("#new_servicio_form")[0].reset();
      $(".hide_me").hide();
      $(".total_calculation_hours_text").html("");
      $(".horas_texto").html("");
      $(".total_calculation_hours_text").attr("style", "");
      $(".total_calculation_hours_text").removeAttr("data-horas-total");
      $(".total_calculation_hours_text").removeAttr("data-servicio-total");
      $(".horas_texto2").html("");

      if ($(this).attr("data-buscador-opened") != 1) {
        $("#buscar_cliente").typeahead({
          order: "asc",
          minlength: 1,
          maxItem: 15,
          hint: true,
          accent: true,
          group: {
            template: "{{group}}",
          },
          maxItemPerGroup: 5,
          backdrop: {
            "background-color": "#fff",
          },
          template(query, item) {
            let color_t_clasificacion;
            let tipo_clasificacion = item.tipo_clasificacion;
            var credito_contado = item.credito == 1 ? "Crédito" : "Contado";
            switch (tipo_clasificacion) {
              case "a":
                color_t_clasificacion = "success";
                break;
              case "b":
                color_t_clasificacion = "success";
                break;
              case "c":
                color_t_clasificacion = "warning";
                break;
              case "d":
                color_t_clasificacion = "danger";
                break;
              case "e":
                color_t_clasificacion = "danger";
                break;
              case "p":
                color_t_clasificacion = "success";
                credito_contado =
                  "Saldo: " +
                  (item.saldo_horas != 1
                    ? item.saldo_horas + " horas"
                    : item.saldo_horas + " hora");

                break;
            }
            tipo_clasificacion = tipo_clasificacion.toUpperCase();

            if (item.tipo_cliente != 3) {
              return (
                `${"<p>" +
                "<span>{{nombre_cliente}}</span> " +
                '<span class="float-right badge badge-'
                }${color_t_clasificacion}">` +
                `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion} | ${credito_contado}</span> </p> `
              );
            }
            return "<p><span>{{nombre_cliente}}</span> </p> ";
          },
          dynamic: true,
          dropdownFilter: "Todos",
          emptyTemplate:
            '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
          source: {
            Clientes: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: `${settings.servicios.ruta_lista_clientes}complete`,
                path: "data.datos.clientes",
              },
            },
          },
          callback: {
            onClickAfter(node, a, item, event) {
              let color_t_clasificacion;
              let tipo_clasificacion = item.tipo_clasificacion;
              let credito_contado = item.credito == 1 ? "Crédito" : "Contado";
              // Si el tipo de cobro es poliza, se hace click de nuevo en poliza para que se refresquen los datos de cobro
              if ($("#ScustomRadioInline15").is(":checked")) {
                $("#ScustomRadioInline15").prop("checked", false);
                setTimeout(function () {
                  $("#ScustomRadioInline15").click();
                  $("#ScustomRadioInline15").click();
                  $("#ScustomRadioInline15").prop("checked", true);
                }, 100);
              }

              switch (tipo_clasificacion) {
                case "a":
                  color_t_clasificacion = "success";
                  break;
                case "b":
                  color_t_clasificacion = "success";
                  break;
                case "c":
                  color_t_clasificacion = "warning";
                  break;
                case "d":
                  color_t_clasificacion = "danger";
                  break;
                case "e":
                  color_t_clasificacion = "danger";
                  break;
                case "p":
                  color_t_clasificacion = "success";
                  credito_contado =
                    "Saldo: " +
                    (item.saldo_horas != 1
                      ? item.saldo_horas + " horas"
                      : item.saldo_horas + " hora");

                  $(".tipo_p").show();
                  $(".no_tipo_p").hide();
                  break;
              }
              if ($('input[name="radio_tipo_servicio"]:checked').val() == "2") {
                $('.radio_precio_np').hide();
              }
              tipo_clasificacion = tipo_clasificacion.toUpperCase();
              if (item.tipo_cliente != 3) {
                $(".quick_info_client").html(
                  `<span class="badge badge-${color_t_clasificacion}">` +
                  `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion} | ${credito_contado}</span> </p> `
                );
                const id_cliente = item.id_cliente;
                if (tipo_clasificacion != "P") {
                  prepareEvs(1, {
                    color_t_clasificacion,
                    tipo_clasificacion,
                    credito_contado,
                    id_cliente,
                    settings,
                  });
                }
              }

              // Bindear el id del cliente al input
              node.attr("data-id-cliente", item.id_cliente);
              // por esto no se puede tener mas de una hora negativa en el saldo:
              node.attr(
                "data-saldo-horas",
                parseInt(item.saldo_horas) >= -1 ? item.saldo_horas : "0"
              );
              // ^^^ Se podria sustituir por >  node.attr("data-saldo-horas", item.saldo_horas); , falta verificar las mecanicas de posesion de polizas
              node.attr("data-email-cliente", item.email);
              node.attr("data-tipo-negocio", item.tipo_negocio);
              node.attr("data-tipo-clasificacion", tipo_clasificacion);
              // Generar lista contactos solo para clientes Negocio/Distribuidor
              if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                generar_contactos(
                  settings.servicios.ruta_lista_contactos,
                  item.id_cliente
                );
                $(".recibido_por_container").hide();
              } else {
                // Campo libre
                $(".recibido_por_container").show();
                $(".contacto_container").hide();
              }
              $(".poliza_container").html("");
              if (tipo_clasificacion == "P") {
                // buscar Saldo del cliente, si no tiene o no tiene poliza o no es tipo P, que solo muestre el boton de nueva poliza
                var poliza_activa = buscar_poliza(item.id_cliente);
                //console.log(poliza_activa + " " + poliza_activa.id_poliza);
                $("#buscar_cliente").attr(
                  "data-folio-poliza",
                  poliza_activa.id_poliza
                );
                $(".datos_from_pendiente_container").attr(
                  "data-folio-poliza",
                  poliza_activa.id_poliza
                );
                node.attr("data-folio-poliza", poliza_activa);
                var fecha = new Date(poliza_activa.fecha * 1000);
                var vencimiento = new Date(poliza_activa.vencimiento * 1000);
                $(".poliza_container").show();
                $(".poliza_container").attr("style", "display: inline");
                $(".poliza_container").html(
                  `<div class="row"><label class="col-md-2 col-sm-12 col-form-label">Paquete</label><div class="col-md-12" ="display:inline"><table class="table table-sm">
                      <thead>
                        <tr>
                          <th scope="col">Fecha</th>
                          <th scope="col">Horas incluidas</th>
                          <th scope="col">Horas utilizadas</th>
                          <th scope="col">Saldo</th>
                          <th scope="col">Vencimiento</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                          <td>${!isNaN(fecha.toLocaleDateString()) ? fecha.toLocaleDateString() : ''}</td>
                          <td>${poliza_activa.horas_incluidas ?? 'Este cliente no cuenta con un paquete activo, favor de verificar los datos ingresados.'}</td>
                          <td>${poliza_activa.horas_usadas ?? ''}</td>
                          <td>${poliza_activa.saldo_cliente ?? ''}</td>
                          <td>${!isNaN(vencimiento.toLocaleDateString()) ? vencimiento.toLocaleDateString() : ''}</td>
                        </tr></tbody></table></div></div>`
                );
              }
              // Verificar la seleccion del tipo de servicio
              if ($("input[name='radio_tipo_servicio']:checked").val() == "2") {
                $(".no_2").hide();
              }
            },
            onSearch(node, a, item, event) {
              if (a !== "") {
              } else {
                // Para prevenir errores de sobrescribir o duplicar
                $(".quick_info_client").html("");
                node.removeAttr("data-id-cliente");
                node.removeAttr("data-email-cliente");
                node.removeAttr("data-tipo-negocio");
                node.removeAttr("data-tipo-clasificacion");
                node.removeAttr("data-saldo-horas");
                node.removeAttr("data-folio-poliza");
                $(".contacto_container").hide();
                $(".select_tipo_precio").prop("checked", false);
                $(".precios_seleccion_container").hide();
                $(".poliza_container").html("");
                $(".typeahead__cancel-button").click();
                $(".no_tipo_p").show();
                $(".tipo_p").hide();
              }
            },
          },
        });
        if ($('input[name="radio_tipo_servicio"]:checked').val() == "2") {
          $('.radio_precio_np').hide();
        }
      }

      $(".select_tipo_servicio").each(function () {
        $(this).attr("data-buscador-opened", 1);
      });
      tipo = $('input[name="radio_tipo_servicio"]:checked').val();
      $(".radio_precio_np").show();
      $(".radio_precio_p").show();
      switch (tipo) {
        case "1":
          $(".hide_me").show();
          $(".hide_me:not(.servicio_type_all,.servicio_type_1)").hide();
          if (tipo_clasificacion == "P") {
            $(".no_tipo_p").hide();
            $(".tipo_p").show();
          } else {
            $(".tipo_p").hide();
            $(".no_tipo_p").show();
          }
          $(".radio_precio_np").show();
          break;
        case "2":
          $(".hide_me").show();
          $(".hide_me:not(.servicio_type_all,.servicio_type_2)").hide();
          $(".precio_calculo_container").hide();
          $(".radio_precio_np").hide();
          break;
        case "3":
          $(".hide_me").show();
          $(".hide_me:not(.servicio_type_all,.servicio_type_3)").hide();
          $(".radio_precio_np").show();
          break;
        case "4":
          $(".hide_me").show();
          $(".hide_me:not(.servicio_type_all,.servicio_type_4)").hide();
          if (tipo_clasificacion == "P") {
            $(".no_tipo_p").hide();
            $(".tipo_p").show();
          } else {
            $(".tipo_p").hide();
            $(".no_tipo_p").show();
          }
          $(".radio_precio_np").show();
          break;
        case "5":
          window.open(`/cotizaciones?id_pendiente=${id_pendiente}`);
          location.reload();
          break;
      }
      // Verificar la seleccion del tipo de servicio
      if ($("input[name='radio_tipo_servicio']:checked").val() == "2") {
        $(".no_2").hide();
        $(".radio_precio_np").hide();
        $(".radio_precio_p").hide();
      }
    });

    $(document).on("change", ".select_tipo_precio", function () {
      const tipo_precio = $(this).val();
      var tipo_clasificacion;
      if ($("#buscar_cliente").attr("data-tipo-clasificacion")) {
        var tipo_clasificacion = $("#buscar_cliente").attr(
          "data-tipo-clasificacion"
        );
      } else if (
        $(".datos_from_pendiente_container").attr("data-tipo-clasificacion")
      ) {
        var tipo_clasificacion = $(".datos_from_pendiente_container").attr(
          "data-tipo-clasificacion"
        );
      }
      let id_cliente = 0;
      if ($("#buscar_cliente").attr("data-id-cliente")) {
        id_cliente = $("#buscar_cliente").attr("data-id-cliente");
      } else if ($(".datos_from_pendiente_container").attr("data-id-cliente")) {
        id_cliente = $(".datos_from_pendiente_container").attr(
          "data-id-cliente"
        );
      }
      $(".poliza_container").hide();
      $(".select_pagado").prop("checked", false);
      $(".select_pagado").removeAttr("disabled");
      $("[name='forma_pago_servicio']").removeAttr("readonly");
      $("[name='forma_pago_servicio']").val("");
      $(".pagado_si_container").hide();
      $(".saldo_texto").html("");

      var saldo_texto = "Saldo actual: ";
      var saldo = "";
      if ($("#buscar_cliente").attr("data-saldo-horas")) {
        saldo = $("#buscar_cliente").attr("data-saldo-horas");
      } else if (
        $(".datos_from_pendiente_container").attr("data-saldo-horas")
      ) {
        saldo = $(".datos_from_pendiente_container").attr("data-saldo-horas");
      } else {
        saldo_texto = "Seleccione un cliente";
      }

      // Aqui iba el proceso de la linea #890

      switch (tipo_precio) {
        case "1":
          $(".poliza_container").hide();
          $(".total_calculation_hours_text").attr("style", "");
          $(".precio_calculo_container").show();
          $(".precios_seleccion_container").show();
          $(".precio_fijo_container").hide();
          $(".horas_fijas_container").hide();
          $(".precio_solo_piezas_container").hide();
          if ($(".select_tipo_servicio:checked").val() == 4) {
            $(".seleccion_piezas_domicilio_container").show();
          }
          $(".horas_texto2").html("");
          $(".saldo_texto").html("");

          break;
        case "2":
          $(".poliza_container").hide();
          $(".horas_fijas_container").hide();
          $(".precio_fijo_container").show();
          $(".precios_seleccion_container").show();
          $(".precio_calculo_container").hide();
          $(".precio_solo_piezas_container").hide();
          if ($(".select_tipo_servicio:checked").val() == 4) {
            $(".seleccion_piezas_domicilio_container").show();
          }
          break;
        case "3":
          $(".poliza_container").hide();
          $(".precios_seleccion_container").show();
          $(".precio_calculo_container").hide();
          $(".precio_fijo_container").hide();
          $(".horas_fijas_container").hide();
          $(".seleccion_piezas_domicilio_container").hide();
          generate_piezas(".precio_solo_piezas_container", id_cliente);

          break;
        case "4":
          $(".precio_calculo_container").show();
          $(".precios_seleccion_container").show();
          $(".poliza_container").show();
          $(".precio_fijo_container").hide();
          $(".horas_fijas_container").hide();
          $(".precio_solo_piezas_container").hide();
          if ($(".select_tipo_servicio:checked").val() == 4) {
            $(".seleccion_piezas_domicilio_container").show();
          }
          /**
           * Marcar el radiobutton de "Pagado" con click.
           * Rellenar el input con "Poliza" y hacer los campos readonly
           * **/
          $(".select_pagado_1").click();
          $(".select_pagado_1").click();
          $("[name='forma_pago_servicio']").val("Paquete");
          $(".select_pagado:not(.select_pagado_1)").prop("disabled", true);
          $("[name='forma_pago_servicio']").prop("readonly", true);
          // Marcar el precio con tache
          $(".total_calculation_hours_text").attr(
            "style",
            "text-decoration-line: line-through"
          );
          // Mensaje aclaratorio del saldo
          $(".horas_texto2").html(
            "Se descontarán las horas del saldo del paquete activo."
          );
          // Mostrar el saldo
          $(".saldo_texto").html(saldo_texto + saldo);
          // Verificar si tiene poliza vigente

          break;
        case "6":
          //$(".poliza_container").hide();
          $(".horas_fijas_container").show();
          $(".precio_fijo_container").hide();
          $(".precios_seleccion_container").show();
          $(".precio_calculo_container").hide();
          $(".precio_solo_piezas_container").hide();
          if ($(".select_tipo_servicio:checked").val() == 4) {
            $(".seleccion_piezas_domicilio_container").show();
          }
          /**
           * Marcar el radiobutton de "Pagado" con click.
           * Rellenar el input con "Poliza" y hacer los campos readonly
           * **/
          $(".select_pagado_1").click();
          $(".select_pagado_1").click();
          $("[name='forma_pago_servicio']").val("Paquete");
          $(".select_pagado:not(.select_pagado_1)").prop("disabled", true);
          $("[name='forma_pago_servicio']").prop("readonly", true);
          $(".poliza_container").show();

          break;
      }
    });

    $(document).on(
      "change",
      'input[name="seleccion_piezas_domicilio"]',
      function () {
        if ($(this).val() == 1) {
          let id_cliente = 0;
          if ($("#buscar_cliente").attr("data-id-cliente")) {
            id_cliente = $("#buscar_cliente").attr("data-id-cliente");
          } else if (
            $(".datos_from_pendiente_container").attr("data-id-cliente")
          ) {
            id_cliente = $(".datos_from_pendiente_container").attr(
              "data-id-cliente"
            );
          }
          generate_piezas(".piezas_container_domicilio", id_cliente);
        } else {
          $(".piezas_container_domicilio").html("");
        }
      }
    );
    $(document).on("change", ".select_servicio_compartido", function () {
      if ($(this).val() == 1) {
        $(".servicio_compartido_container").show();
      } else {
        $(".servicio_compartido_container").hide();
      }
    });

    $(document).on(
      "click change",
      ".select_pagado, .select_pagado_1",
      function () {
        if ($(this).val() == 1) {
          $(".pagado_si_container").show();
        } else {
          $(".pagado_si_container").hide();
        }
      }
    );

    $(document).on("change", ".select_movito_actividad", () => {
      const option_select = $(".select_movito_actividad option:selected");

      if (option_select.val() == "otro") {
        $(".otro_motivo_actividad_container").show();
      } else {
        $(".otro_motivo_actividad_container").hide();
      }
    });

    //* **************************************************************
    // ----------------------- NUEVO SERVICIO  -----------------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- PIEZAS SERVICIO  ----------------------
    //* **************************************************************
    function generate_piezas(el, id_cliente) {
      const container = $(el);

      // Fixes #138
      $(".piezas_container_domicilio").html("");

      if (id_cliente == 0) {
        iziToast.error({
          title: "Error",
          message:
            "Selecciona un cliente para generar sus salidas de mercancía.",
        });

        // language=HTML
        const init_template =
          '<div class="form-group row required init_pieza_container entity_pieza_servicio">' +
          '<div class="col-md-4 col-sm-12">' +
          '<input type="text" class="form-control descripcion_pieza_servicio"' +
          'data-validation="required" data-validation-error-msg="Ingresa el nombre de la pieza." placeholder="Descripción Pieza" >' +
          "</div>" +
          '<div class="col-md-3 col-sm-12">' +
          '<input type="text" class="form-control precio_pieza_servicio"' +
          'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el precio correctamente." placeholder="Precio Pieza" >' +
          "</div>" +
          '<div class="col-md-3 col-sm-12">' +
          '<input type="text" class="form-control costo_pieza_servicio"' +
          'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el costo correctamente." data-validation-optional="true" placeholder="Costo Pieza" >' +
          "</div>" +
          '<div class="col-md-2 col-sm-12">' +
          '<button class="btn btn-outline-primary add_pieza_servicio" type="button" role="button"><i' +
          ' class="fa fa-plus" aria-hidden="true"></i></button>' +
          "</div>" +
          "</div>";

        container.html(init_template);
        container.show();
        $(`${el} .add_pieza_servicio`).on("click", function () {
          // language=HTML
          const template =
            '<div class="form-group row required entity_pieza_container entity_pieza_servicio">' +
            '<div class="col-md-4 col-sm-12">' +
            '<input type="text" class="form-control descripcion_pieza_servicio"' +
            'data-validation="required" data-validation-error-msg="Ingresa el nombre de la pieza." placeholder="Descripción Pieza" >' +
            "</div>" +
            '<div class="col-md-3 col-sm-12">' +
            '<input type="text" class="form-control precio_pieza_servicio"' +
            'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el precio correctamente." placeholder="Precio Pieza" >' +
            "</div>" +
            '<div class="col-md-3 col-sm-12">' +
            '<input type="text" class="form-control costo_pieza_servicio"' +
            'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el costo correctamente." data-validation-optional="true" placeholder="Costo Pieza" >' +
            "</div>" +
            '<div class="col-md-2 col-sm-12">' +
            '<button class="btn btn-outline-danger remove_pieza_servicio" type="button" role="button"><i' +
            ' class="fa fa-minus" aria-hidden="true"></i></button>' +
            "</div>" +
            "</div>";
          if ($(".entity_pieza_container").length == 0) {
            $(this).parents(el).append(template);
          } else {
            $(".entity_pieza_container:last").after(template);
          }
        });
      } else {
        container.html("");
        let envio = {};
        envio.type = 1;
        envio.id_cliente = id_cliente;
        envio = JSON.stringify(envio);
        $.ajax({
          type: "POST",
          url: `${settings.servicios.ruta_consultas}get_list_piezas`,
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success(response) {
            if (response.status == "success") {
              const cont = $(
                '<div class="container_select_folio_mercancia" style="margin-bottom:20px;">'
              );
              const options = $(
                '<select class="custom-select select_salida_mercancia_folio">'
              );
              options.append(
                $("<option>").text("Vincula una salida de mercancia:").attr({
                  selected: true,
                  hidden: true,
                })
              );
              $.each(response.message, (key, val) => {
                options.append(
                  $("<option>")
                    .text(`Folio: ${val.id_salida} | ${val.detalle}`)
                    .val(val.id_salida)
                    .attr("data-element", el)
                );
              });
              cont.append("<p>Salidas de mercancia:</p>");
              cont.append(options);
              container.prepend(cont);
              container.show();
            } else if (response.status == "error") {
              iziToast.error({
                title: "Error",
                message: response.message,
              });
              const init_template =
                '<div class="form-group row required init_pieza_container entity_pieza_servicio">' +
                '<div class="col-md-4 col-sm-12">' +
                '<input type="text" class="form-control descripcion_pieza_servicio"' +
                'data-validation="required" data-validation-error-msg="Ingresa el nombre de la pieza." placeholder="Descripción Pieza" >' +
                "</div>" +
                '<div class="col-md-3 col-sm-12">' +
                '<input type="text" class="form-control precio_pieza_servicio"' +
                'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el precio correctamente." placeholder="Precio Pieza" >' +
                "</div>" +
                '<div class="col-md-3 col-sm-12">' +
                '<input type="text" class="form-control costo_pieza_servicio"' +
                'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el costo correctamente." data-validation-optional="true" placeholder="Costo Pieza" >' +
                "</div>" +
                '<div class="col-md-2 col-sm-12">' +
                '<button class="btn btn-outline-primary add_pieza_servicio" type="button" role="button"><i' +
                ' class="fa fa-plus" aria-hidden="true"></i></button>' +
                "</div>" +
                "</div>";

              container.html(init_template);
              container.show();
              $(`${el} .add_pieza_servicio`).on("click", function () {
                // language=HTML
                const template =
                  '<div class="form-group row required entity_pieza_container entity_pieza_servicio">' +
                  '<div class="col-md-4 col-sm-12">' +
                  '<input type="text" class="form-control descripcion_pieza_servicio"' +
                  'data-validation="required" data-validation-error-msg="Ingresa el nombre de la pieza." placeholder="Descripción Pieza" >' +
                  "</div>" +
                  '<div class="col-md-3 col-sm-12">' +
                  '<input type="text" class="form-control precio_pieza_servicio"' +
                  'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el precio correctamente." placeholder="Precio Pieza" >' +
                  "</div>" +
                  '<div class="col-md-3 col-sm-12">' +
                  '<input type="text" class="form-control costo_pieza_servicio"' +
                  'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el costo correctamente." data-validation-optional="true" placeholder="Costo Pieza" >' +
                  "</div>" +
                  '<div class="col-md-2 col-sm-12">' +
                  '<button class="btn btn-outline-danger remove_pieza_servicio" type="button" role="button"><i' +
                  ' class="fa fa-minus" aria-hidden="true"></i></button>' +
                  "</div>" +
                  "</div>";
                if ($(".entity_pieza_container").length == 0) {
                  $(this).parents(el).append(template);
                } else {
                  $(".entity_pieza_container:last").after(template);
                }
              });
            }
          },
          error(xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
          },
        });
      }
    }

    $(document).on("change", ".select_salida_mercancia_folio", function () {
      const vale = $(this).find("option:selected").val();
      const el = $(this).find("option:selected").attr("data-element");
      const container = $(el);
      let envio = {};
      envio.id_salida = vale;
      envio.type = 2;
      envio = JSON.stringify(envio);

      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}get_list_piezas`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            container.find(".entity_pieza_container").remove();
            container.find(".init_pieza_container").remove();
            const init_template =
              '<div class="form-group row container_add_pieza init_pieza_container">' +
              '<div class="col-md-12 col-sm-12">' +
              '<button class="btn btn-outline-primary add_pieza_servicio" type="button" role="button"><i' +
              ' class="fa fa-plus" aria-hidden="true"> Pieza Extra</i></button>' +
              "</div>";

            container.append(init_template);
            $.each(response.message, (key, val) => {
              container.append(
                `<div class="form-group row required entity_pieza_container entity_pieza_servicio"><div class="col-md-4 col-sm-12"><input type="text" class="form-control descripcion_pieza_servicio" value="${val.detalle}" readonly></div><div class="col-md-3 col-sm-12"><input type="text" class="form-control precio_pieza_servicio" data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el precio correctamente." value="${val.venta}"></div><div class="col-md-3 col-sm-12"><input type="text" class="form-control costo_pieza_servicio" readonly  value="${val.costo}" ></div><div class="col-md-2 col-sm-12"><button class="btn btn-outline-danger remove_pieza_servicio" type="button" role="button"><i class="fa fa-minus" aria-hidden="true"></i></button></div></div>`
              );
            });

            $(`${el} .add_pieza_servicio`).on("click", function () {
              // language=HTML
              const template =
                '<div class="form-group row required entity_pieza_container entity_pieza_servicio">' +
                '<div class="col-md-4 col-sm-12">' +
                '<input type="text" class="form-control descripcion_pieza_servicio"' +
                'data-validation="required" data-validation-error-msg="Ingresa el nombre de la pieza." placeholder="Descripción Pieza" >' +
                "</div>" +
                '<div class="col-md-3 col-sm-12">' +
                '<input type="text" class="form-control precio_pieza_servicio"' +
                'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el precio correctamente." placeholder="Precio Pieza" >' +
                "</div>" +
                '<div class="col-md-3 col-sm-12">' +
                '<input type="text" class="form-control costo_pieza_servicio"' +
                'data-validation="number" data-validation-allowing="float" data-validation-error-msg="Ingresa el costo correctamente." data-validation-optional="true" placeholder="Costo Pieza" >' +
                "</div>" +
                '<div class="col-md-2 col-sm-12">' +
                '<button class="btn btn-outline-danger remove_pieza_servicio" type="button" role="button"><i' +
                ' class="fa fa-minus" aria-hidden="true"></i></button>' +
                "</div>" +
                "</div>";
              if ($(".entity_pieza_container").length == 0) {
                $(this).parents(el).append(template);
              } else {
                $(".entity_pieza_container:last").after(template);
              }
            });
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on("click", ".remove_pieza_servicio", function () {
      $(this).parents(".entity_pieza_container").remove();
    });
    //* **************************************************************
    // ----------------------- PIEZAS SERVICIO  ----------------------
    //* **************************************************************

    //* **************************************************************
    // ----------------- CALCULAR POR HORAS DE SERVICIO  -------------
    //* **************************************************************
    function calculate_hours_service() {
      const hora_inicio = moment($("#calculo_hora_inicio").val(), "h:mm A");
      const hora_final = moment($("#calculo_hora_final").val(), "h:mm A");
      const minutos = hora_final.diff(hora_inicio, "minutes");
      const horas = minutos / 60;
      let horas_int = parseInt(horas);

      let total;
      const decimals = horas % 1;
      let plural = false;
      if (minutos == 0) {
        total = 0;
        plural = true;
      } else if (minutos > 0 && minutos <= 15) {
        horas_int = 1;
        total = 600;
      } else if (minutos > 0 && minutos <= 75) {
        total = 600;
        if (decimals > 0.25) {
          horas_int++;
        }
      } else if (minutos > 75) {
        plural = true;
        if (decimals > 0.25) {
          horas_int++;
          total = 600 * horas_int;
        } else {
          total = 600 * horas_int;
        }
      }
      const total_text = numeral(total).format("0,0.00");
      $(".horas_texto").html(`${horas_int + (plural ? " Horas" : " Hora")} |`);
      $(".horas_text").attr("data-horas-total", horas_int);
      $(".total_calculation_hours_text").html(` $${total_text} MXN`);
      $(".total_calculation_hours_text").attr("data-horas-total", horas_int);
      $(".total_calculation_hours_text").attr("data-servicio-total", total);
    }

    //* **************************************************************
    // ----------------------- CAPTURAR SERVICIO  --------------------
    //* **************************************************************
    $(document).on("keypress", ":input:not(textarea)", (e) => e.keyCode != 13);
    $(document).on("submit", "#new_servicio_form", function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl("start");
      const datos = $("#new_servicio_form").serializeArray();
      const datosEnvio = {};
      for (let i = 0; i < datos.length; i++) {
        datosEnvio[datos[i].name] = datos[i].value;
      }


      let email_cliente = $("#buscar_cliente").attr("data-email-cliente");
      const email_user = $(this).attr("data-user-email");

      if (email_cliente == undefined) {
        if ($(".datos_from_pendiente_container").attr("data-email-cliente")) {
          email_cliente = $(".datos_from_pendiente_container").attr(
            "data-email-cliente"
          );
        } else {
          email_cliente = "";
        }
      }

      tipo_clasificacion = $("#buscar_cliente").attr("data-tipo-clasificacion");

      if (tipo_clasificacion == undefined) {
        if ($(".datos_from_pendiente_container").attr("data-tipo-clasificacion")) {
          tipo_clasificacion = $(".datos_from_pendiente_container").attr(
            "data-tipo-clasificacion"
          );
        } else {
          tipo_clasificacion = "";
        }
      }
      datosEnvio.tipo_clasificacion = tipo_clasificacion;



      datosEnvio.tipo_servicio = $(".select_tipo_servicio:checked").val();
      datosEnvio.fecha_servicio = $(
        "#fecha-servicio-container .input-group.date"
      ).datepicker("getDate");
      if (id_pendiente) {
        datosEnvio.id_cliente = $(".datos_from_pendiente_container").attr(
          "data-id-cliente"
        );
        datosEnvio.id_pendiente = $(".datos_from_pendiente_container").attr(
          "data-id-pendiente"
        );
      } else {
        if (!$("#buscar_cliente").attr("data-id-cliente")) {
          iziToast.error({
            title: "Error",
            message: "Selecciona un cliente.",
          });
          btn.partnersBtnControl("end");
          return false;
        }
        datosEnvio.id_cliente = $("#buscar_cliente").attr("data-id-cliente");
      }
      datosEnvio.horas_totales = parseInt($(".total_calculation_hours_text").attr(
        "data-horas-total"
      ));
      // validar saldo
      if (tipo_clasificacion == "P") {
        var saldo = parseInt($("#buscar_cliente").attr("data-saldo-horas"));
        if (isNaN(saldo)) {
          saldo = $('.datos_from_pendiente_container').attr("data-saldo-horas");
        }
        datosEnvio.servicio_horas_fijas = parseInt(datosEnvio.servicio_horas_fijas);
        if (saldo < datosEnvio.horas_totales) {
          iziToast.error({
            title: "Error",
            message: "Verifica el saldo disponible.",
          });
          btn.partnersBtnControl("end");
          return false;
        } else if (saldo < datosEnvio.servicio_horas_fijas) {
          iziToast.error({
            title: "Error",
            message: "Verifica el saldo disponible.",
          });
          btn.partnersBtnControl("end");
          return false;
        }
        if (datosEnvio.horas_totales != undefined && datosEnvio.horas_totales != "" && datosEnvio.horas_totales != NaN && datosEnvio.horas_totales < 1) {
          iziToast.error({
            title: "Error",
            message: "Verifica las horas registradas.",
          });
          btn.partnersBtnControl("end");
          return false;
        } else if (datosEnvio.servicio_horas_fijas != undefined && datosEnvio.servicio_horas_fijas != "" && datosEnvio.servicio_horas_fijas != NaN && datosEnvio.servicio_horas_fijas < 1) {
          iziToast.error({
            title: "Error",
            message: "Verifica las horas registradas.",
          });
          btn.partnersBtnControl("end");
          return false;
        }

      }
      // var tipo_clasificacion;
      // if ($("#buscar_cliente").attr("data-tipo-clasificacion")) {
      //   tipo_clasificacion = $("#buscar_cliente").attr(
      //     "data-tipo-clasificacion"
      //   );
      // } else {
      //   tipo_clasificacion = $(".datos_from_pendiente_container").attr(
      //     "data-tipo-clasificacion"
      //   );
      // }
      let a;
      if (tipo_clasificacion.toUpperCase() == "P" && $('input[name="radio_tipo_servicio"]:checked').val() != "2" && $('input[name="radio_tipo_servicio"]:checked').val() != "3") {
        a = buscar_poliza(datosEnvio.id_cliente);
        datosEnvio.folio_poliza = a.id_poliza;
        if ($('input[name="radio_tipo_precio"]:checked').val() == undefined) {
          btn.partnersBtnControl("end");
          iziToast.error({
            title: "Error: ",
            message: `Por favor, ingresa un tipo de precio`,
          });
          return false;
        }
      }

      // Cuando es de Actividad marcar como 0 el de servicio total
      if ($(".select_tipo_servicio:checked").val() == 3) {
        datosEnvio.servicio_total = 0;
        // Actividad solamente se puede por calculo de tiempo y como no tiene el radio options
        // se tiene que poner aqui manualmente
        datosEnvio.radio_tipo_precio = 1;
      } else if ($(".select_tipo_servicio:checked").val() == 2) {
        datosEnvio.servicio_total = $(
          'input[name="servicio_cantidad_fija_interno"]'
        ).val();
        datosEnvio.radio_tipo_precio = 2;
      } else {
        let tipo_precio = $(".select_tipo_precio:checked").val();
        switch (parseInt(tipo_precio)) {
          case 1: // Por calculo de horas
            datosEnvio.servicio_total = $(".total_calculation_hours_text").attr(
              "data-servicio-total"
            );
            break;
          case 2: // Por precio fijo
            datosEnvio.radio_tipo_precio = 2;
            datosEnvio.servicio_total = $(
              'input[name="servicio_cantidad_fija"]'
            ).val();
            break;
          case 4:
            datosEnvio.servicio_total = $(".total_calculation_hours_text").attr(
              "data-servicio-total"
            );
            if (datosEnvio.servicio_total == undefined || datosEnvio.servicio_total == null || datosEnvio.servicio_total == NaN) {
              btn.partnersBtnControl("end");
              iziToast.error({
                title: "Error: ",
                message: `Por favor, ingresa una cantidad de horas`,
              });
              return false;
            }
            break;
          case 6:
            datosEnvio.radio_tipo_precio = 6;
            datosEnvio.tipo_poliza = a.tipo_poliza;

            datosEnvio.horas_totales = datosEnvio.servicio_horas_fijas;

            break;
        }
      }

      if ($(".select_movito_actividad option:selected").val() == "otro") {
        datosEnvio.motivo_actividad = $(
          'input[name="otro_motivo_no_se_cobra"]'
        ).val();
      } else {
        datosEnvio.motivo_actividad = $(
          ".select_movito_actividad option:selected"
        ).val();
      }
      datosEnvio.piezas = [];
      $(".entity_pieza_servicio").each(function () {
        datosEnvio.piezas.push({
          descripcion: $(this).find(".descripcion_pieza_servicio").val(),
          precio: $(this).find(".precio_pieza_servicio").val(),
          costo: $(this).find(".costo_pieza_servicio").val(),
        });
      });

      if (
        $('input[name="seleccion_piezas_domicilio"]:checked').val() == 1 ||
        $('input[name="radio_tipo_precio"]:checked').val() == 3
      ) {
        datosEnvio.piezas_domicilio = 1;
      }

      datosEnvio.id_salida_mercancia = $(
        ".select_salida_mercancia_folio option:selected"
      ).val();

      if (
        $('select[name="servicio_recibido_por"] option:selected').val() == 0
      ) {
        iziToast.error({
          title: "Error",
          message: "Selecciona un contacto.",
        });
        btn.partnersBtnControl("end");
        return false;
      }

      if (id_pendiente == false) {
        // Solo usar el nombre de los contactos cuando sea cliente negocio
        if (
          $("#buscar_cliente").attr("data-tipo-negocio") == 1 ||
          $("#buscar_cliente").attr("data-tipo-negocio") == 3
        ) {
          datosEnvio.servicio_recibido_por = $(
            'select[name="servicio_recibido_por"] option:selected'
          ).html();
        } else {
          datosEnvio.servicio_recibido_por = $(
            'input[name="recibido_por"]'
          ).val();
        }
      } else {
        // Viene de pendiente.
        // Solo usar el nombre de los contactos cuando sea cliente negocio
        if (
          $(".datos_from_pendiente_container").attr("data-tipo-negocio") == 1
        ) {
          datosEnvio.servicio_recibido_por = $(
            'select[name="servicio_recibido_por"] option:selected'
          ).html();
        } else {
          datosEnvio.servicio_recibido_por = $(
            'input[name="recibido_por"]'
          ).val();
        }
      }
      fixBootstrapModal();

      if (
        $('input[name="radio_tipo_precio"]:checked').val() != 3 &&
        $('input[name="seleccion_piezas_domicilio"]:checked').val() != 1
      ) {
        // Limpiar el array de piezas, porque no se van a usar piezas, y es posible que a veces se equivoquen y seleccionen
        // que si quieren pieza por error cuando en realidad no necesitan, y ese cambio de si querer a no querer ocacionaba
        // un error que incluso que se pusiera que no se querian piezas las ponia.
        datosEnvio.piezas = [];
      }
      const envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}capturar_servicio`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            autoUpdate.forceUpdate();
            let tipo = datosEnvio.tipo_clasificacion;

            // si es un servicio interno, solo enviar automaticamente el correo a quien haya solicitado el servicio
            if (Number(datosEnvio.tipo_servicio) == 2) {
              btn.partnersBtnControl("end");
              var datos_servicio = JSON.parse(response.message);
              $.ajax({
                type: "POST",
                url: `${settings.servicios.ruta_consultas}enviar_reporte_correo`,
                data: JSON.stringify(datos_servicio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success(res) {
                  if (res.status === "success") {
                    // eslint-disable-next-line no-undef
                    iziToast.success({
                      title: "Listo",
                      message: "Correo enviado",
                    });
                    window.open(`/servicios/vista/${datos_servicio.id_servicio}`);
                    $("#vista-nuevo-servicio-modal").modal("hide");
                  } else if (res.status === "error") {
                    // eslint-disable-next-line no-undef
                    iziToast.error({
                      title: "Error",
                      message: res.message,
                    });
                  }
                },
                error(xhr) {
                  // eslint-disable-next-line no-undef
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                },
              });

              return false;
            }

            // Si se capturó correctamente el servicio, preguntar si se va a facturar, de lo contrario, preguntar si va a enviar por correo
            if (Number(datosEnvio.tipo_servicio) != 2) {
              if (tipo.toUpperCase() != "P") {
                swal({
                  title: "Facturar",
                  text: "¿Deseas facturar el servicio?",
                  type: "info",
                  showCancelButton: true,
                  cancelButtonColor: "#DD6B55",
                  confirmButtonText: "¡Si, facturar!",
                  cancelButtonText: "¡No!",
                  confirmButtonClass: "btn btn-success",
                  cancelButtonClass: "btn btn-danger",
                  allowOutsideClick: false,
                  allowEscapeKey: false,
                  onClose() {
                    $("body").removeAttr("style");
                  },
                }).then((a) => {
                  if (!a.dismiss) {
                    // Generar la vista para los datos de facturar
                    $("#vista-nuevo-servicio-modal").modal("hide");

                    setTimeout(() => {
                      load_facturar_servicio(response.message);
                    }, 400);
                  } else if (a.dismiss == "cancel") {
                    btn.partnersBtnControl("end");
                    let tmp = +$("#buscar_cliente").attr("data-id-cliente");
                    // eslint-disable-next-line no-restricted-globals
                    if (isNaN(tmp)) {
                      tmp = document
                        .getElementsByClassName(
                          "datos_from_pendiente_container"
                        )[0]
                        .getAttribute("data-id-cliente");
                    }
                    const idCliente = tmp;
                    const idServicio = +response.message;
                    // eslint-disable-next-line no-undef
                    modalCorreo(
                      idCliente,
                      settings,
                      idServicio,
                      (emailsToSend, ddatos, body, hideModal) => {
                        const data = {
                          to: emailsToSend,
                          id_servicio: ddatos,
                          body,
                        };
                        $.ajax({
                          type: "POST",
                          url: `${settings.servicios.ruta_consultas}enviar_reporte_correo`,
                          data: JSON.stringify(data),
                          contentType: "application/json; charset=utf-8",
                          dataType: "json",
                          success(res) {
                            if (res.status === "success") {
                              // eslint-disable-next-line no-undef
                              iziToast.success({
                                title: "Listo",
                                message: "Correos enviados",
                              });
                              hideModal(true);
                              window.open(`/servicios/vista/${response.message}`);
                              $("#vista-nuevo-servicio-modal").modal("hide");
                            } else if (res.status === "error") {
                              // eslint-disable-next-line no-undef
                              iziToast.error({
                                title: "Error",
                                message: res.message,
                              });
                              hideModal(false);
                            }
                          },
                          error(xhr) {
                            // eslint-disable-next-line no-undef
                            iziToast.error({
                              title: "Ocurrio un error: ",
                              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                            });
                            hideModal(false);
                          },
                        });
                      },
                      {},
                      () => {
                        $("#vista-nuevo-servicio-modal").modal("hide");
                      },
                      false
                    );
                  }
                });
              } else {
                btn.partnersBtnControl("end");
                let tmp = +$("#buscar_cliente").attr("data-id-cliente");
                // eslint-disable-next-line no-restricted-globals
                if (isNaN(tmp)) {
                  tmp = document
                    .getElementsByClassName("datos_from_pendiente_container")[0]
                    .getAttribute("data-id-cliente");
                }
                const idCliente = tmp;
                const idServicio = +response.message;
                // eslint-disable-next-line no-undef
                modalCorreo(
                  idCliente,
                  settings,
                  idServicio,
                  (emailsToSend, ddatos, body, hideModal) => {
                    const data = {
                      to: emailsToSend,
                      id_servicio: ddatos,
                      body,
                    };
                    $.ajax({
                      type: "POST",
                      url: `${settings.servicios.ruta_consultas}enviar_reporte_correo`,
                      data: JSON.stringify(data),
                      contentType: "application/json; charset=utf-8",
                      dataType: "json",
                      success(res) {
                        if (res.status === "success") {
                          // eslint-disable-next-line no-undef
                          iziToast.success({
                            title: "Listo",
                            message: "Correos enviados",
                          });
                          hideModal(true);
                          window.open(`/servicios/vista/${response.message}`);
                          $("#vista-nuevo-servicio-modal").modal("hide");
                        } else if (res.status === "error") {
                          // eslint-disable-next-line no-undef
                          iziToast.error({
                            title: "Error",
                            message: res.message,
                          });
                          hideModal(false);
                        }
                      },
                      error(xhr) {
                        // eslint-disable-next-line no-undef
                        iziToast.error({
                          title: "Ocurrio un error: ",
                          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                        });
                        hideModal(false);
                      },
                    });
                  },
                  {},
                  () => {
                    $("#vista-nuevo-servicio-modal").modal("hide");
                  },
                  false
                );
              }
            }
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
          btn.partnersBtnControl("end");
        },
      });
      id_pendiente = false;
    });

    //* **************************************************************
    // ---------------------- CAPTURAR  SERVICIO  --------------------
    //* **************************************************************

    //* **************************************************************
    // --------------------------- VER SERVICIO  ---------------------
    //* **************************************************************
    $(document).on("click", ".ver_servicio", function () {
      const id_servicio = $(this).parents("tr").attr("data-id-servicio");
      window.open(`/servicios/vista/${id_servicio}`);
    });
    //* **************************************************************
    // --------------------------- VER SERVICIO  ---------------------
    //* **************************************************************

    //* **************************************************************
    // -------------------------- STATUS PROBLEMA --------------------
    //* **************************************************************
    $(document).on("click", ".status_problema", function () {
      const $this = $(this);
      const id_servicio = $(this).parents("tr").attr("data-id-servicio");
      const new_val = $(this).parents("tr").attr("data-problema") == 1 ? 0 : 1;
      let envio = {};
      envio.id_servicio = id_servicio;
      envio.new_val = new_val;
      envio.col = "problema_con_servicio";
      swal({
        title: "Cuál es el problema?",
        input: "textarea",
        showCancelButton: true,
        confirmButtonText: "Guardar",
        cancelButtonColor: "#DD6B55",
        cancelButtonText: "Cancelar",
        confirmButtonClass: "btn btn-success",
        cancelButtonClass: "btn btn-danger",
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose() {
          $("body").removeAttr("style");
        },
        preConfirm(reason) {
          return new Promise((resolve, reject) => {
            if (!reason) {
              reject("Debes detallar el problema!");
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: "POST",
                url: `${settings.servicios.ruta_consultas}update_status`,
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success(response) {
                  if (response.status == "success") {
                    resolve();
                  } else if (response.status == "error") {
                    iziToast.error({
                      title: "Error",
                      message: response.message,
                    });
                  }
                },
                error(xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                },
              });
            }
          });
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          if ($this.hasClass("status-red")) {
            $this.removeClass("status-red");
            $this.addClass("status-green");
            $this.html("No");
          } else if ($this.hasClass("status-green")) {
            $this.removeClass("status-green");
            $this.addClass("status-red");
            $this.html("Si");
          }
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: "bottomLeft",
          });
          autoUpdate.forceUpdate();
        }
      });
    });
    //* **************************************************************
    // -------------------------- STATUS PROBLEMA --------------------
    //* **************************************************************

    //* **************************************************************
    // -------------------------- STATUS PAGADO ----------------------
    //* **************************************************************
    $(document).on("click", ".status_pagado", function () {
      const id_servicio = $(this).parents("tr").attr("data-id-servicio");
      const folio_servicio = $(this).parents("tr").attr("data-folio-servicio");
      const nombre_cliente = $(this).parents("tr").attr("data-nombre-cliente");
      const total_servicio = $(this).parents("tr").attr("data-total-servicio");
      let template =
        `${'<div class="row">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning servicio_no_pagado w-100" data-id-servicio="'
        }${id_servicio}" role="button">No</button></div>` +
        `<div class="col-md"><button type="button" class="btn btn-outline-success servicio_pagado w-100" data-nombre-cliente="${nombre_cliente}" data-total-servicio="${total_servicio}" data-id-servicio="${id_servicio}" role="button">Pagado</button></div>`;
      if ($(this).parents("tr").attr("data-servicio-facturado") == 0) {
        template += `<div class="col-md"><button type="button" class="btn btn-outline-info servicio_facturado w-100" data-folio-servicio="${folio_servicio}" data-nombre-cliente="${nombre_cliente}" data-id-servicio="${id_servicio}" role="button">Facturado</button></div>`;
      } else {
        template += `<div class="col-md"><button type="button" class="btn btn-outline-info servicio_otro w-100" data-folio-servicio="${folio_servicio}" data-nombre-cliente="${nombre_cliente}" data-id-servicio="${id_servicio}" role="button">Otro</button></div>`;
      }
      template += "</div>";

      $(this).partnersModal({
        content: template,
        title: "Selecciona",
        forceWidth: 25,
        modalId: "modal-pagado-servicios",
        noFooter: true,
      });
    });

    $(document).on("click", ".servicio_otro", function () {
      $("#modal-pagado-servicios").modal("hide");
      const envio = {};
      envio.id_servicio = $(this).attr("data-id-servicio");
      swal({
        title: "Ingresa otro metodo de pago",
        input: "text",
        inputPlaceholder: "Ej. Depósito, tarjeta...",
        showCancelButton: true,
        confirmButtonText: "Guardar",
        cancelButtonText: "Cancelar",
        cancelButtonColor: "#DD6B55",
        showLoaderOnConfirm: true,
        preConfirm(text) {
          return new Promise((resolve, reject) => {
            if (text == null || text.length < 1) {
              reject("Se un poco más descriptivo");
            } else {
              envio.otro = text;
              $.ajax({
                type: "POST",
                url: `${settings.servicios.ruta_consultas}status_pagado_otro`,
                data: JSON.stringify(envio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success(response) {
                  if (response.status == "success") {
                    resolve();
                  } else if (response.status == "error") {
                    iziToast.error({
                      title: "Error",
                      message: response.message,
                    });
                    swal.close();
                  }
                },
                error(xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                },
              });
            }
          });
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          swal({
            type: "success",
            title: "Bien!",
            html: "Servicio marcado como pagado correctamente.",
            timer: 2000,
          });
          autoUpdate.forceUpdate();
        }
      });
    });

    $(document).on("click", ".servicio_no_pagado", function () {
      const id_servicio = $(this).attr("data-id-servicio");
      const clicked_td = $(
        `tr[data-id-servicio="${id_servicio}"] .status_pagado`
      );
      $("#modal-pagado-servicios .modal-body").html(loader);
      let envio = {};
      envio.new_val = 0;
      envio.id_servicio = id_servicio;
      envio.col = "pagado_admon";
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}update_status`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: "bottomLeft",
            });
            $("#modal-pagado-servicios").modal("hide");
            clicked_td.removeClass("status-green");
            clicked_td.addClass("status-red");
            clicked_td.html("No");
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on("click", ".servicio_pagado", function () {
      const id_servicio = $(this).attr("data-id-servicio");
      const nombre_cliente = $(this).attr("data-nombre-cliente");
      const total_servicio = $(this).attr("data-total-servicio");
      $("#modal-pagado-servicios").modal("hide");
      const template =
        `<form autocomplete="off" id="form_pagado_caja" data-id-servicio="${id_servicio}"><div class="row">` +
        `<div class="col-md-5"><div class="form-group required"><label class="col-form-label">Concepto</label> <div> <input type="text" class="form-control valid_me" value="Registro Pago de Servicio: ${id_servicio} | ${nombre_cliente}" name="concepto_capturar_caja" data-validation="required" data-validation-error-msg="Ingresa un concepto"> </div> </div></div>` +
        `<div class="col-md-5"><div class="form-group required"> <label class="col-form-label">Cantidad</label> <div> <input type="text" class="form-control valid_me text-right" value="${numeral(
          total_servicio
        ).format(
          "0,0.00"
        )}" data-validation-min-number="${total_servicio}" name="cantidad_capturar_caja" data-validation="number min_number" data-validation-allowing="float" data-validation-error-msg="Ingresa una cantidad correcta y mayor a: ${numeral(
          total_servicio
        ).format(
          "0,0.00"
        )}" data-sanitize="numberFormat" data-sanitize-number-format="0,0.00"> </div> </div></div>` +
        '<div class="col-md-2"><label>Guardar en caja</label><button type="submit" class="btn btn-success" role="button">Guardar</button></div>' +
        "</div></form>";

      $(this).partnersModal({
        content: template,
        title: "Capturar en caja",
        forceWidth: 65,
        modalId: "modal-pagado-caja",
        noFooter: true,
      });
      setTimeout(() => {
        $.validate({
          form: "#form_pagado_caja",
          errorMessageClass: "invalid-feedback",
          inputParentClassOnError: "text-danger",
          inputParentClassOnSuccess: "text-success",
          errorElementClass: "is-invalid",
        });
        $.formUtils.addValidator({
          name: "min_number",
          validatorFunction(value, $el) {
            return (
              numeral(value).value() >=
              numeral($($el).attr("data-validation-min-number")).value()
            );
          },
          errorMessage: "",
          errorMessageKey: "",
        });
      }, 400);
    });

    $(document).on("submit", "#form_pagado_caja", function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      const id_servicio = $(this).attr("data-id-servicio");
      btn.partnersBtnControl("start");
      const datos = $("#form_pagado_caja").serializeArray();
      const datosEnvio = {};
      for (let i = 0; i < datos.length; i++) {
        datosEnvio[datos[i].name] = datos[i].value;
      }
      $("#modal-pagado-caja .modal-body").html(loader);
      const clicked_td = $(
        `tr[data-id-servicio="${id_servicio}"] .status_pagado`
      );
      datosEnvio.id_servicio = id_servicio;
      datosEnvio.new_val = 1;
      datosEnvio.col = "pagado_admon";
      datosEnvio.obs = `Se capturó en caja bajo el concepto de: ${datosEnvio.concepto_capturar_caja}`;
      datosEnvio.capturar_caja = 1;
      const envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}update_status`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            autoUpdate.forceUpdate();
            $("#modal-pagado-caja").modal("hide");
            clicked_td.addClass("status-green");
            clicked_td.html("Pagado");
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on("click", ".servicio_facturado", function () {
      const id_servicio = $(this).attr("data-id-servicio");
      const folio_servicio = $(this).attr("data-folio-servicio");
      const nombre_cliente = $(this).attr("data-nombre-cliente");
      $("#modal-pagado-servicios").modal("hide");
      let content = "";
      content +=
        `${'<div class="row">' +
        '<div class="col-md-2"><p class="font-weight-bold">Folio Servicio:</p></div>' +
        '<div class="col-md-2">'
        }${folio_servicio}</div>` +
        '<div class="col-md-1"><p class="font-weight-bold">Cliente:</p></div>' +
        `<div class="col-md-3">${nombre_cliente}</div>` +
        "</div><hr>" +
        '<div class="row">' +
        '<div class="col-md-2">' +
        '<p class="font-weight-bold">Factura:</p>' +
        "</div>" +
        '<div class="col-md-2">' +
        '<input type="text" class="form-control numero_factura">' +
        "</div>" +
        "</div><hr>" +
        '<div class="row">' +
        '<div class="col-md-4"><p class="font-weight-bold">La factura está a nombre de:</p></div>' +
        '<div class="col-md-8"><input type="text" class="nombre_cliente_factura form-control" readonly value="..."></div>' +
        "</div>" +
        '<div class="row">' +
        '<div class="col-md-12 my-3">' +
        `<button type="button" class="float-right capturar_servicio_facturado btn btn-success" data-folio-servicio="${folio_servicio}" data-id-servicio="${id_servicio}" role="button" style="display: none;">Guardar</button>` +
        "</div>" +
        "</div>";

      setTimeout(function () {
        $(this).partnersModal({
          title: "Facturar",
          modalSize: "modal-lg",
          modalId: "facturar-servicio-modal",
          content,
          noFooter: true,
        });
      }, 400);
    });

    $(document).on("blur", ".numero_factura", () => {
      const numero_factura = $(".numero_factura").val();
      if (
        $.trim(numero_factura) == "" ||
        !$.trim(numero_factura) ||
        isNaN(numero_factura)
      ) {
        iziToast.error({
          title: "Error",
          message: "Ingresa un folio de factura correcto.",
        });
        return false;
      }
      let envio = {};
      envio.numero_factura = numero_factura;
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_sys_tools}get_datos_cliente_contpaq`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            const datos_c = JSON.parse(response.message);
            $(".nombre_cliente_factura").val(datos_c.nombre);
            $(".nombre_cliente_factura").attr(
              "data-codigo-cliente",
              datos_c.codigo_cliente
            );
            $(".nombre_cliente_factura").attr("data-rfc-cliente", datos_c.rfc);
            $(".capturar_servicio_facturado").show();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
            $(".nombre_cliente_factura").val("");
            $(".capturar_servicio_facturado").hide();
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on("click", ".capturar_servicio_facturado", function () {
      let envio = {};
      const btn = $(this);
      btn.partnersBtnControl("start");
      envio.codigo_cliente = $(".nombre_cliente_factura").attr(
        "data-codigo-cliente"
      );
      envio.rfc_cliente = $(".nombre_cliente_factura").attr("data-rfc-cliente");
      envio.folio_factura = $(".numero_factura").val();
      envio.folio_servicio = $(this).attr("data-id-servicio");
      envio.f_servicio = $(this).attr("data-folio-servicio");
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}marcar_facturado`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            $("#facturar-servicio-modal").modal("hide");
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
            btn.partnersBtnControl("end");
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // -------------------------- STATUS PAGADO ----------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------------ REPORTE OBSERVACIONES ----------------
    //* **************************************************************
    $(document).on("click", ".status_obs", function () {
      const id_servicio = $(this).parents("tr").attr("data-id-servicio");
      $(this).partnersObs({
        modalId: "modal-servicios-observaciones",
        ajaxUrl: `${settings.servicios.ruta_sys_tools}load_obs`,
        index: "id_servicio",
        id_index: id_servicio,
        tabla: "partners_servicios",
        col: "observaciones",
        allowReminder: true,
        nombreCliente: $(this).parents("tr").attr("data-nombre-cliente"),
        idCliente: $(this).parents("tr").attr("data-id-cliente"),
        subjectReminder: "Reporte de Servicios",
        ajaxSuccessCallback() {
          autoUpdate.forceUpdate();
        },
      });
    });
    //* **************************************************************
    // ------------------------ REPORTE OBSERVACIONES ----------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- STATUS COMPARTIDO CON -----------------
    //* **************************************************************
    $(document).on("mouseenter", ".show_compartido_con", function () {
      $(this).html($(this).attr("data-compartido-con"));
    });

    $(document).on("mouseleave", ".show_compartido_con", function () {
      $(this).html($(this).attr("data-current-text"));
    });
    //* **************************************************************
    // ----------------------- STATUS COMPARTIDO CON -----------------
    //* **************************************************************

    //* **************************************************************
    // -------------------------- ELIMINAR REPORTE  ------------------
    //* **************************************************************
    $(document).on("click", ".eliminar_reporte", function () {
      const id_reporte = $(this).parents("tr").attr("data-id-servicio");
      const folio_reporte = $(this).parents("tr").attr("data-folio-servicio");
      swal({
        title: "Estás Seguro?",
        html: `Deseas eliminar el reporte ${folio_reporte}?`,
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen() {
          fixBootstrapModal();
        },
        preConfirm() {
          return new Promise((resolve) => {
            $.ajax({
              type: "POST",
              url: `${settings.servicios.ruta_consultas}eliminar_servicio`,
              data: id_reporte,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success(response) {
                if (response.status == "success") {
                  autoUpdate.forceUpdate();
                  setTimeout(() => {
                    undo_servicio_deleted(folio_reporte, id_reporte);
                    swal.close();
                  }, 2000);
                  resolve();
                } else if (response.status == "error") {
                  iziToast.error({
                    title: "Error",
                    message: response.message,
                  });
                }
              },
              error(xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                });
              },
            });
          });
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          swal(
            "Eliminado!",
            "El reporte se ha eliminado correctamente.",
            "success"
          );
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_servicio_deleted(folio, id_servicio) {
      iziToast.show({
        title: `Servicio ${folio}`,
        message: " ha sido eliminado.",
        position: "bottomLeft",
        timeout: 10000,
        color: "dark",
        progressBarColor: "rgb(0, 255, 184)",
        icon: "fa fa-ban",
        buttons: [
          [
            `<button data-id-servicio="${id_servicio}" data-folio-servicio="${folio}" class="servicio_undo_delete">Deshacer</button>`,
            function (instance, toast) {
              instance.hide(
                {
                  transitionOut: "fadeOutUp",
                },
                toast,
                "close"
              );
            },
          ],
        ],
      });
    }

    $(document).on("click", ".servicio_undo_delete", function () {
      const id_servicio = $(this).attr("data-id-servicio");
      const folio_servicio = $(this).attr("data-folio-servicio");
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}reactivate_servicio`,
        data: id_servicio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            iziToast.success({
              title: `Servicio ${folio_servicio}`,
              message: " ha sido traido de vuelta a la vida!",
              icon: "fa fa-usd",
            });
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // -------------------------- ELIMINAR REPORTE  ------------------
    //* **************************************************************

    //* **************************************************************
    // ---------------------- COSTO PIEZAS REPORTE  ------------------
    //* **************************************************************
    $(document).on("click", ".status_costo", function () {
      $(this).partnersModal({
        title: "Modificar Costos",
        modalSize: "modal-lg",
        modalId: "modificacion-costos-modal",
        content: loader,
      });

      let envio = {};
      envio.id_servicio = $(this).parents("tr").attr("data-id-servicio");
      envio.type = 1;
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}modificacion_costos`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            $("#modificacion-costos-modal .modal-body").html(response.message);
            setTimeout(() => {
              $.validate({
                form: "#form_modificacion_piezas",
                errorMessageClass: "invalid-feedback",
                inputParentClassOnError: "text-danger",
                inputParentClassOnSuccess: "text-success",
                errorElementClass: "is-invalid",
              });
            }, 100);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on("submit", "#form_modificacion_piezas", function (e) {
      const datos = [];
      let envio = {};
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl("start");

      $(".entity_pieza_modificacion").each(function () {
        datos.push({
          id_pieza: $(this).attr("data-id-pieza"),
          new_costo: $(this).find(".modificacion_costo_value").val(),
        });
      });

      envio.type = 2;
      envio.datos = datos;
      envio.id_servicio = $(this).attr("data-id-servicio");
      envio = JSON.stringify(envio);

      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}modificacion_costos`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: "bottomLeft",
            });
            autoUpdate.forceUpdate();
            $("#modificacion-costos-modal").modal("hide");
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ---------------------- COSTO PIEZAS REPORTE  ------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------- COSTO PIEZAS REPORTE SIMPLE ---------------
    //* **************************************************************
    $(document).on("click", ".status_costo_simple", function () {
      $(this).partnersModal({
        title: "Ver Costos",
        modalSize: "modal-lg",
        modalId: "vista-costos-modal",
        content: loader,
      });

      let envio = {};
      envio.id_servicio = $(this).parents("tr").attr("data-id-servicio");
      envio.type = 1;
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}vista_costos_simple`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            $("#vista-costos-modal .modal-body").html(response.message);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------- COSTO PIEZAS REPORTE SIMPLE ---------------
    //* **************************************************************

    //* **************************************************************
    // ------------------------ REENVIAR REPORTE  --------------------
    //* **************************************************************
    $(document).on("click", ".reenviar_reporte", (e) => {
      const idServicio = e.currentTarget
        .closest("tr")
        .getAttribute("data-id-servicio");
      const idCliente = +e.currentTarget
        .closest("tr")
        .getAttribute("data-id-cliente");
      // eslint-disable-next-line no-undef
      modalCorreo(
        idCliente,
        settings,
        idServicio,
        (emailsToSend, datos, body, hideModal) => {
          const data = {
            to: emailsToSend,
            id_servicio: datos,
            body,
          };
          $.ajax({
            type: "POST",
            url: `${settings.servicios.ruta_consultas}enviar_reporte_correo`,
            data: JSON.stringify(data),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success(response) {
              if (response.status === "success") {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: "Listo",
                  message: "Correos enviados",
                });
                hideModal(true);
              } else if (response.status === "error") {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: "Error",
                  message: response.message,
                });
                hideModal(false);
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: "Ocurrio un error: ",
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
              hideModal(false);
            },
          });
        },
        {},
        () => { },
        false
      );
    });
    //* **************************************************************
    // ------------------------ REENVIAR REPORTE  --------------------
    //* **************************************************************

    //* **************************************************************
    // --------------------- SERVICIOS INFORM ERRORS -----------------
    //* **************************************************************
    $(document).on("click", ".inform_errors", function (e) {
      e.preventDefault();
      const error = {};
      error.err_msg = $(this).attr("data-error-msg");
      error.err_time = $(this).attr("data-error-time");
      error.err_loc = $(this).attr("data-error-location");
      error.err_user = $(this).attr("data-error-user");
      error.err_user_id = $(this).attr("data-error-user-id");

      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_sys_tools}report_error`,
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            $(".modal").each(function () {
              $(this).modal("hide");
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false,
            });
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // --------------------- SERVICIOS INFORM ERRORS -----------------
    //* **************************************************************

    //* **************************************************************
    // --------------------- SERVICIOS VER FACTURA  ------------------
    //* **************************************************************
    $(document).on("click", ".ver_factura", function () {
      const id_factura = $(this).text();
      $(this).partnersModal({
        title: `Factura ${id_factura}`,
        modalId: "vista-factura",
        forceWidth: 90,
        content: loader,
      });
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_sys_tools}get_full_factura`,
        data: JSON.stringify(id_factura),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            if (response.message == "not_on_server") {
              var content =
                "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content =
                `${"<div>" + '<iframe src="/system/tools/vista_factura?factura='
                }${response.message}" width="100%;" height="600px;"></iframe>` +
                "</div>";
            }
            $("#vista-factura .modal-body").html(content);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // --------------------- SERVICIOS VER FACTURA  ------------------
    //* **************************************************************

    //* **************************************************************
    // -------------------- SERVICIOS VER FACTURA W ------------------
    //* **************************************************************
    $(document).on("click", ".ver_factura_w", function () {
      const id_factura = $(this).text();
      const nombre_factura = $(this).attr("data-nombre-factura");
      $(this).partnersModal({
        title: `Factura W-${id_factura}`,
        modalId: "vista-factura",
        forceWidth: 90,
        content: loader,
      });
      const content =
        `${"<div>" + '<iframe src="/system/tools/vista_factura?factura='
        }${nombre_factura}" width="100%;" height="600px;"></iframe>` + "</div>";
      $("#vista-factura .modal-body").html(content);
    });
    //* **************************************************************
    // --------------------- SERVICIOS VER FACTURA  ------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------- SERVICIOS VER USUARIO RECIBE --------------
    //* **************************************************************
    $(document).on("mouseenter", ".show_usuario_recibe", function () {
      $(this).html($(this).attr("data-usuario-recibe"));
    });

    $(document).on("mouseleave", ".show_usuario_recibe", function () {
      $(this).html($(this).attr("data-current-text"));
    });
    //* **************************************************************
    // ------------------- SERVICIOS VER USUARIO RECIBE --------------
    //* **************************************************************

    //* **************************************************************
    // ------------------------ FACTURAR SERVICIO  -------------------
    //* **************************************************************
    /**
     * Genera la vista para facturar un servicio, puede ser utilizado inmediatamente despues del momento de terminar de capturar un servicio,
     * o puede ser utilizado para facturar servicios despues desde el reporteador.
     * @param id_servicio
     */
    function load_facturar_servicio(id_servicio) {
      $(this).partnersModal({
        title: `Facturar servicio ${id_servicio}`,
        modalId: "vista-facturar-servicio-modal",
        content: loader,
        forceWidth: 80,
      });

      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_consultas}vista_facturar_servicio`,
        data: JSON.stringify(id_servicio),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(r) {
          if (r.status == "success") {
            $("#vista-facturar-servicio-modal .modal-body").html(r.message);

            setTimeout(() => {
              $.validate({
                form: "#facturar_servicio_form",
                errorMessageClass: "invalid-feedback",
                inputParentClassOnError: "text-danger",
                inputParentClassOnSuccess: "text-success",
                errorElementClass: "is-invalid",
              });
              $("#example-basic").steps({
                headerTag: "h3",
                bodyTag: "section",
                transitionEffect: 3,
                autoFocus: true,
                labels: {
                  cancel: "Cancelar",
                  current: "Etapa actual",
                  pagination: "Paginación",
                  finish: "Finalizar",
                  next: "Siguiente",
                  previous: "Anterior",
                  loading: "Cargando...",
                },
                onStepChanging(event, currentIndex, newIndex) {
                  // Validar que estén correctos los datos del cliente
                  let error_form = false;
                  if (newIndex == 1) {
                    // Cargar la lista de contactos
                    generar_lista_contactos(
                      $('input[name="nombre_cliente"]').attr("data-id-cliente")
                    );
                  } else if (newIndex === 2) {
                    $(".valid_me").validate((valid) => {
                      if (!valid) {
                        error_form = true;
                      }
                    });

                    // Si aun hay errores, validar el rfc
                    if (error_form == false) {
                      error_form = !validar_rfc(
                        $('input[name="rfc_cliente"]').val()
                      );
                    }

                    // Si aun no hay error, validar que exista al menos un correo
                    if (error_form == false) {
                      // Si no existe ningun correo, detener
                      if (
                        $(
                          'input[type="text"][name="correos_cliente_to_send"]'
                        ).tagsinput("items").length == 0
                      ) {
                        iziToast.error({
                          title: "Error",
                          message: "Ingresa al menos un correo",
                        });
                        error_form = true;
                      }
                    }
                  } else if (newIndex === 3) {
                    // Es el resumen, entonces poner los datos seleccionados
                    $(".valid_me").validate((valid) => {
                      if (!valid) {
                        error_form = true;
                      }
                    });
                    $(".review_nombre_cliente").html(
                      $('input[name="nombre_cliente"]').val()
                    );
                    $(".review_rfc_cliente").html(
                      $('input[name="rfc_cliente"]').val()
                    );
                    $(".review_uso_cfdi_cliente").html(
                      $(
                        'select[name="uso_cfdi_pago_factura"] option:selected'
                      ).html()
                    );
                    $(".review_metodo_pago").html(
                      $(
                        'select[name="metodo_pago_factura"] option:selected'
                      ).html()
                    );
                    $(".review_forma_pago").html(
                      $(
                        'select[name="forma_pago_factura"] option:selected'
                      ).html()
                    );
                  }

                  return error_form != true;
                },
                onFinishing(event, currentIndex) {
                  $(".wizard").css("opacity", 0.4);
                  $(".wizard").find('li > a[href="#finish"]').hide();
                  $(".wizard .content")
                    .parents("form")
                    .append(
                      $(loader).css({
                        position: "absolute",
                        margin: "auto",
                        top: 0,
                        left: 0,
                        right: 0,
                        bottom: 0,
                      })
                    );
                  const datos = {};
                  datos.id_servicio = $("#facturar_servicio_form").attr(
                    "data-id-servicio"
                  );
                  datos.nombre_cliente = $(".review_nombre_cliente").html();
                  datos.rfc_cliente = $(".review_rfc_cliente").html();
                  datos.nuevo_dato_facturacion = $(
                    'input[name="nombre_cliente"]'
                  ).attr("data-nuevo");
                  datos.id_dato_facturacion = $(
                    'input[name="nombre_cliente"]'
                  ).attr("data-id-dato");
                  datos.id_cliente = $('input[name="nombre_cliente"]').attr(
                    "data-id-cliente"
                  );
                  datos.metodo_pago = $(
                    'select[name="metodo_pago_factura"] option:selected'
                  ).val();
                  datos.forma_pago = $(
                    'select[name="forma_pago_factura"] option:selected'
                  ).val();
                  datos.uso_cfdi = $(
                    'select[name="uso_cfdi_pago_factura"] option:selected'
                  ).val();
                  datos.importe = $(".review_importe").attr("data-number");
                  datos.iva = $(".review_iva").attr("data-number");
                  datos.total = $(".review_total").attr("data-number");
                  datos.correos = $(
                    'input[type="text"][name="correos_cliente_to_send"]'
                  ).tagsinput("items");

                  const envio = JSON.stringify(datos);

                  $.ajax({
                    type: "POST",
                    url: `${settings.servicios.ruta_consultas}facturar_servicio`,
                    data: envio,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success(response) {
                      if (response.status == "success") {
                        $("#vista-facturar-servicio-modal").modal("hide");
                        swal({
                          type: "success",
                          title: "Servicio Facturado",
                          text: response.message,
                          timer: 5000,
                          allowOutsideClick: false,
                        });
                        setTimeout(() => {
                          location.reload();
                        }, 5000);
                      } else if (response.status == "error") {
                        iziToast.error({
                          title: "Error",
                          message: response.message,
                        });
                        $(".wizard").css("opacity", 1);
                        $(
                          "#vista-facturar-servicio-modal .sk-cube-grid"
                        ).remove();
                        $(".wizard").find('li > a[href="#finish"]').show();
                      }
                    },
                    error(xhr) {
                      iziToast.error({
                        title: "Ocurrio un error: ",
                        message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                      });
                      $("#vista-facturar-servicio-modal").modal("hide");
                    },
                  });
                  return true;
                },
              });
              $(
                'input[type="text"][name="correos_cliente_to_send"]'
              ).tagsinput();
              $('input[type="text"][name="correos_cliente_to_send"]').on(
                "beforeItemAdd",
                (event) => {
                  if (!validateEmail(event.item)) {
                    event.cancel = true;
                  }
                }
              );
              $('input[type="text"][name="correos_cliente_to_send"]').on(
                "beforeItemRemove",
                (event) => {
                  let cancel = false;
                  $(".select_lista_contactos_facturar option").each((k, v) => {
                    if ($(v).attr("data-email-contacto") == event.item)
                      cancel = true;
                  });
                  if (cancel) {
                    iziToast.error({
                      title: "Error",
                      message: "No puedes eliminar los correos ya predefinidos",
                    });
                  }
                  event.cancel = cancel;
                }
              );
            }, 10);
          } else if (r.status == "error") {
            iziToast.error({
              title: "Error",
              message: r.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    $(document).on("click", ".facturar_servicio", function () {
      load_facturar_servicio($(this).parents("tr").attr("data-id-servicio"));
    });

    $(document).on("blur", 'input[name="rfc_cliente"]', function () {
      validar_rfc($(this).val());
    });

    $(document).on("change", 'select[name="metodo_pago_factura"]', function () {
      // Cuando sea "PPD" solo se puede poner forma de pago como "Por definir"
      if ($(this).find("option:selected").val() == "PPD") {
        $('select[name="forma_pago_factura"] option').each(function () {
          if ($(this).val() != 99) {
            $(this).attr("hidden", "hidden");
          }
        });
      } else {
        // Cuando sea "PUE" se puede seleccionar cualquiera
        $('select[name="forma_pago_factura"] option').each(function () {
          $(this).removeAttr("hidden");
        });
      }
    });

    /**
     * Validar que el rfc tenga la estructura correcta.
     * @param rfc
     * @return boolean
     */
    function validar_rfc(rfc) {
      const $this = $('input[name="rfc_cliente"]');
      if ($.trim(rfc)) {
        if (rfcValido(rfc)) {
          $this.closest(".row").removeClass("has-danger");
          $this.closest(".row").addClass("has-success");
          $this.addClass("form-control-success");
          $this
            .closest(".row .col-md-4")
            .find(".help-block.form-control-feedback")
            .remove();
          $this.val(rfcValido(rfc));
          return true;
        }
        $this.closest(".row").removeClass("has-success");
        $this.closest(".row").addClass("has-danger");
        $this.addClass("form-control-danger");
        $this
          .closest(".row .col-md-4")
          .find(".help-block.form-control-feedback")
          .remove();
        $this
          .closest(".row .col-md-4")
          .append(
            '<div class="help-block form-control-feedback">Ingresa un RFC válido</div>'
          );
        return false;
      }
      $this.closest(".row").removeClass("has-success");
      $this.closest(".row").addClass("has-danger");
      $this.addClass("form-control-danger");
      $this
        .closest(".row .col-md-4")
        .find(".help-block.form-control-feedback")
        .remove();
      $this
        .closest(".row .col-md-4")
        .append(
          '<div class="help-block form-control-feedback">Ingresa un RFC válido</div>'
        );
      return false;
    }

    // Función para validar un RFC
    // Devuelve el RFC sin espacios ni guiones si es correcto
    // Devuelve false si es inválido
    // (debe estar en mayúsculas, guiones y espacios intermedios opcionales)
    function rfcValido(rfc) {
      const aceptarGenerico = true;
      const re =
        /^([A-ZÑ&]{3,4}) ?(?:- ?)?(\d{2}(?:0[1-9]|1[0-2])(?:0[1-9]|[12]\d|3[01])) ?(?:- ?)?([A-Z\d]{2})([A\d])$/;
      const validado = rfc.match(re);

      if (!validado) {
        // Coincide con el formato general del regex?
        return false;
      }

      // Separar el dígito verificador del resto del RFC
      let digitoVerificador = validado.pop(),
        rfcSinDigito = validado.slice(1).join(""),
        len = rfcSinDigito.length,
        // Obtener el digito esperado
        diccionario = "0123456789ABCDEFGHIJKLMN&OPQRSTUVWXYZ Ñ",
        indice = len + 1;
      let suma, digitoEsperado;

      if (len == 12) suma = 0;
      else suma = 481; // Ajuste para persona moral

      for (let i = 0; i < len; i++)
        suma += diccionario.indexOf(rfcSinDigito.charAt(i)) * (indice - i);
      digitoEsperado = 11 - (suma % 11);
      if (digitoEsperado == 11) digitoEsperado = 0;
      else if (digitoEsperado == 10) digitoEsperado = "A";

      // El dígito verificador coincide con el esperado?
      // o es un RFC Genérico (ventas a público general)?
      if (
        digitoVerificador != digitoEsperado &&
        (!aceptarGenerico ||
          rfcSinDigito + digitoVerificador != "XAXX010101000")
      )
        return false;
      if (
        !aceptarGenerico &&
        rfcSinDigito + digitoVerificador == "XEXX010101000"
      )
        return false;
      return rfcSinDigito + digitoVerificador;
    }

    function generar_lista_contactos(id_cliente) {
      const url = `/clientes?id_cliente=${id_cliente}&type=1`;
      $.ajax({
        type: "POST",
        url: `${settings.servicios.ruta_lista_contactos + id_cliente}/${1}`, // El 1 es para traer solo a los
        // contactos marcados como contacto facturacion
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          iziToast.destroy();
          if (response.status == "success") {
            const contactos = JSON.parse(response.message);
            let options = "";
            const emailsArray = [];
            $.each(contactos, (key, val) => {
              $('input[type="text"][name="correos_cliente_to_send"]').tagsinput(
                "removeAll"
              );
              options += `<option value="${val.id_cliente}" data-email-contacto="${val.email}">${val.nombre_cliente}</option>`;
              emailsArray.push(val.email);
            });
            for (let i = 0; i < emailsArray.length; i++) {
              $('input[type="text"][name="correos_cliente_to_send"]').tagsinput(
                "add",
                emailsArray[i]
              );
            }
            $(".select_lista_contactos_facturar").empty();
            $(".select_lista_contactos_facturar").append(options);

            $(".select_lista_contactos_facturar option:last").attr(
              "selected",
              "selected"
            );
            $(".contacto_container_facturar").show();
            $(".agregar_nuevo_contacto_facturar")
              .attr("href", url)
              .attr("target", "_blank");
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
            $(".agregar_nuevo_contacto_facturar")
              .attr("href", url)
              .attr("target", "_blank");
            $(".contacto_container_facturar").show();
            $(".select_lista_contactos_facturar")
              .empty()
              .append(
                '<option value="0">Cliente sin contactos de facturación</option>'
              );
            $('input[type="text"][name="correos_cliente_to_send"]').tagsinput(
              "removeAll"
            );
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    $(document).on(
      "change",
      'select[name="facturar_servicio_contacto"]',
      function () {
        const email = $(this)
          .find("option:selected")
          .attr("data-email-contacto");
        $('input[type="text"][name="correos_cliente_to_send"]').tagsinput(
          "add",
          email
        );
      }
    );

    $(document).on("click", ".agregar_nuevo_contacto_facturar", function () {
      let auto_check;
      const id_cliente = $(this).attr("data-id-cliente");
      $(window).one("blur", () => {
        $(window).one("focus", () => {
          iziToast.info({
            title: "Espera",
            message: "Buscando nuevos contactos",
            progressBar: false,
            timeout: 60000,
          });
          generar_lista_contactos(id_cliente);
        });
      });
    });

    $(document).on(
      "change",
      'select[name="choose_datos_facturacion"]',
      function () {
        const selected_option = $(this).find("option:selected");
        $(".datos_facturacion_container").show();
        $('input[name="nombre_cliente"]').attr("data-nuevo", false);
        $('input[name="nombre_cliente"]').attr(
          "data-id-dato",
          selected_option.val()
        );
        $('input[name="nombre_cliente"]').val(
          selected_option.attr("data-nombre-facturacion")
        );
        $('input[name="rfc_cliente"]').attr("data-nuevo", false);
        $('input[name="rfc_cliente"]').val(selected_option.attr("data-rfc"));
      }
    );

    $(document).on("click", ".agregar_nuevo_dato_facturacion", () => {
      $(".datos_facturacion_container").show();

      $(
        'select[name="choose_datos_facturacion"] option[data-option-nuevo-dato="true"]'
      ).prop("selected", true);

      $('input[name="nombre_cliente"]').attr("data-nuevo", true);
      $('input[name="nombre_cliente"]').val("");
      $('input[name="rfc_cliente"]').attr("data-nuevo", true);
      $('input[name="rfc_cliente"]').val("");
    });

    //* **************************************************************
    // ------------------------ FACTURAR SERVICIO  -------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------- SERVICIOS ESTATUS ESPECIAL ----------------
    //* **************************************************************
    $(document).on("click", ".status_especial", function () {
      const especial = $(this).parents("tr").attr("data-especial") == 1 ? 0 : 1;
      const idServicio = $(this).parents("tr").attr("data-id-servicio");
      const envio = {};
      envio.especial = especial;
      envio.idServicio = idServicio;

      swal({
        title: "Motivo",
        input: "textarea",
        showCancelButton: true,
        confirmButtonText: "Guardar",
        cancelButtonColor: "#DD6B55",
        cancelButtonText: "Regresar",
        confirmButtonClass: "btn btn-success",
        cancelButtonClass: "btn btn-danger",
        animation: false,
        customClass: "animated fadeInDownCustom",
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose() {
          $("body").removeAttr("style");
        },
        preConfirm(reason) {
          return new Promise((resolve, reject) => {
            if (!reason) {
              reject("Debes ingresar un motivo!");
            } else {
              envio.motivo = reason;
              $.ajax({
                type: "POST",
                url: `${settings.servicios.ruta_consultas}status_especial`,
                data: JSON.stringify(envio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success(response) {
                  if (response.status == "success") {
                    iziToast.success({
                      title: "Bien! ",
                      message: response.message,
                    });
                    resolve();
                  } else if (response.status == "error") {
                    iziToast.error({
                      title: "Error",
                      message: response.message,
                    });
                  }
                },
                error(xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                },
              });
            }
          }).catch((error) => {
            swal.showValidationError(error);
          });
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (a.dismiss !== "cancel") {
          swal(
            "Bien!",
            "Se ha actualizado el estatus correctamente.",
            "success"
          );
          autoUpdate.forceUpdate();
        }
      });
    });
    //* **************************************************************
    // ------------------- SERVICIOS ESTATUS ESPECIAL ----------------
    //* **************************************************************

    //* **************************************************************
    // --------------------- SERVICIOS AGREGAR FIRMA -----------------
    //* **************************************************************

    $(document).on("click", ".add-esign", async (e) => {
      const ID = +e.currentTarget
        .closest("tr")
        .getAttribute("data-id-servicio");
      // eslint-disable-next-line no-undef
      initSignature(
        async () => {
          let result;
          await $.ajax({
            type: "POST",
            url: `${settings.servicios.ruta_consultas}get_servicio_data`,
            data: JSON.stringify({ id: ID }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            async: true,
            success(response) {
              if (response.status === "success") {
                result = response.message;
              } else if (response.status === "error") {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: "Error",
                  message: response.message,
                });
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: "Ocurrio un error: ",
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
            },
          });
          return result;
        },
        (dataUrl) => {
          $.ajax({
            type: "POST",
            url: `${settings.servicios.ruta_consultas}agregar_firma`,
            data: JSON.stringify({ firma: dataUrl, id: ID }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success(response) {
              if (response.status === "success") {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: "Bien",
                  message: response.message,
                });
                autoUpdate.forceUpdate();
              } else if (response.status === "error") {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: "Error",
                  message: response.message,
                });
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: "Ocurrio un error: ",
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
            },
          });
        }
      ).catch((err) => {
        console.error(err);
      });
    });

    //* **************************************************************
    // --------------------- SERVICIOS AGREGAR FIRMA -----------------
    //* **************************************************************
  });

  // Si no tienen polizas

  $(document).on("click", ".nueva_poliza", function (e) {
    var win = window.open(window.origin + "/polizas?crear=1", "_blank");
    $(win).on("load", function (e) {
      $(win).blur();
    });
    $("#ScustomRadioInline6").click();
    $(".typeahead__cancel-button").click();
    $("#buscar_cliente").html("");
    setTimeout(function (e) {
      $(".select_tipo_precio:checked").click();
    }, 10000);
  });
  $(document).on("click", ".typeahead__cancel-button", function () {
    $(".quick_info_client").html("");
    $("#buscar_cliente").removeAttr("data-id-cliente");
    $("#buscar_cliente").removeAttr("data-email-cliente");
    $("#buscar_cliente").removeAttr("data-tipo-negocio");
    $("#buscar_cliente").removeAttr("data-tipo-clasificacion");
    $("#buscar_cliente").removeAttr("data-saldo-horas");
    $(".select_tipo_precio").prop("checked", false);
    $(".precios_seleccion_container").hide();
    $(".select_pagado").prop("checked", false);
    $(".select_pagado").removeAttr("disabled");
    $("[name='forma_pago_servicio']").removeAttr("readonly");
    $("[name='forma_pago_servicio']").val("");
    $("#buscar_cliente").val("");
    $(".pagado_si_container").hide();
    $(".contacto_container").hide();
    $(".poliza_container").html("");
  });

  function buscar_poliza(id) {
    var envio = {};
    var poliza_activa;
    envio.id = id;
    envio = JSON.stringify(envio);
    $.ajax({
      type: "POST",
      url: `${settings.polizas.ruta_consultas}get_poliza_activa`,
      data: envio,
      async: false,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success(response) {
        //obtener datos de la poliza
        //console.log(response);
        poliza_activa = response.message[0];
        // if (response.status != "error") {
        //   poliza_activa = response.message[0]; //regresa el mas antiguo
        // }
      },
      error(error) {
        console.log(error);
      },
    });
    return poliza_activa;
  }
})(jQuery);
