(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

//***************************************************************
//------------- REPORTE BASE SEGUIMIENTO FACTURAS ---------------
//***************************************************************
        // Auto Update
        var autoUpdate = new AutoUpdate({
            toUpdate: function () {
                reporte_base();
            },
            interval: 60,
            iddle_after: 120,
        });

        // Reporte base Options
        var r_options = {
            pagination: {
                page: 1
            },
            sort: {
                order: 'ASC',
                sort_by: 'id_seguimiento'
            },
            automatic_update: 1,
            updating: 0,
            filter: {
                search_bar: null,
                start_date: null,
                end_date: null
            }
        };


        function reporte_base() {
            if (r_options.automatic_update !== 1) {
                $('#reporteador').find('.table').css('opacity', 0.5);
            }
            $.ajax({
                type: 'POST',
                url: settings.seguimiento_facturas.ruta_consultas + 'reporte_base',
                data: JSON.stringify(r_options),
                contentType: "application/json; charset=utf-8",
                success: function (data) {
                    $('#reporteador').html(data);

                    //Reset Defaults
                    r_options.automatic_update = 1;
                    r_options.updating = 0;
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        }

        $(document).on('click', '#reset_filters', function () {
            r_options.filter.search_bar = null;
            $('.input_buscador_seguimiento_facturas').val('');
            autoUpdate.forceUpdate();
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
        });

        // Filtrado - Texto
        $(document).on('keyup', '.input_buscador_seguimiento_facturas', function (e) {
            clearTimeout($.data(this, 'timer'));
            if (e.keyCode == 13)
                search(true);
            else
                $(this).data('timer', setTimeout(search, 200));
        });
        function search() {
            var StringtoSearch = $(".input_buscador_seguimiento_facturas").val();
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.search_bar = StringtoSearch;
            autoUpdate.forceUpdate();
        }

//***************************************************************
//------------- REPORTE BASE SEGUIMIENTO FACTURAS ---------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
        var start = moment().startOf('month');
        var end = moment().endOf('month');

        function cb(start, end) {
            $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        }

        cb(start, end);
        $('#reportrange').daterangepicker({
            autoApply: true,
            linkedCalendars: false,
            parentEl: ".parent-calendar",
            locale: {
                "format": "DD/MM/YYYY",
                "separator": " - ",
                "applyLabel": "Aplicar",
                "cancelLabel": "Cancelar",
                "fromLabel": "Desde",
                "toLabel": "Hasta",
                "customRangeLabel": "Personalizado",
                "weekLabel": "S",
                "daysOfWeek": [
                    "Do",
                    "Lu",
                    "Ma",
                    "Mi",
                    "Ju",
                    "Vi",
                    "Sa"
                ],
                "monthNames": [
                    "Enero",
                    "Febrero",
                    "Marzo",
                    "Abril",
                    "Mayo",
                    "Junio",
                    "Julio",
                    "Agosto",
                    "Septiembre",
                    "Octubre",
                    "Noviembre",
                    "Diciembre"
                ],
                "firstDay": 1
            },
            startDate: start,
            endDate: end,
            showDropdowns: true,
            ranges: {
                'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
                'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
                'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
                'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
                'Hoy': [moment(), moment()],
                'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
                'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
                'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
                'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
                'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
                'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
                'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
                'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
                'Año Actual': [moment().startOf('year'), moment().endOf('year')],
                'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
                'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
            }
        }, cb);


        $('#reportrange').on('apply.daterangepicker', function () {
            var fecha = $('#reportrange').find('span').text();
            var fecha_array = fecha.split("-");
            r_options.filter.start_date = fecha_array[0];
            r_options.filter.end_date = fecha_array[1];
            autoUpdate.forceUpdate();
            $('#reporteador').find('.table').css('opacity', 0.5);
        });

        (function () {
            var fecha = $('#reportrange').find('span').text();
            var fecha_array = fecha.split("-");
            r_options.filter.start_date = fecha_array[0];
            r_options.filter.end_date = fecha_array[1];
            autoUpdate.forceUpdate();
            $('#reporteador').find('.table').css('opacity', 0.5);
        })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//------------------------ EXPORTAR EXCEL -----------------------
//***************************************************************
        $(document).on('click', '.export_excel', function () {
            $("#table_reporteador_seguimiento_facturas").table2excel({
                name: "Seguimiento Facturas",
                filename: "seguimiento_facturas"
            });
        });
//***************************************************************
//------------------------ EXPORTAR EXCEL -----------------------
//***************************************************************

    });
})
(jQuery);