(function ($) {
  const settings = Drupal.settings;
  $(document).ready(function () {

    const loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//---------------------- REPORTE BASE TIENDA  -------------------
//***************************************************************
    // Auto Update
    const autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 60000,
      iddle_after: 120,
    });

    // Reporte base Options
    let r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: '',
        sort_by: ''
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        filtro_15: null,
        filtro_40: null,
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      $('#reporteador').html(loader);
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.reporte_ventas.ruta_consultas + 'reporte_base_tienda',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    autoUpdate.forceUpdate();
//***************************************************************
//---------------------- REPORTE BASE TIENDA  -------------------
//***************************************************************

// ***************************************************************
// ---------------------- CONTROL REPORTEADOR --------------------
// ***************************************************************
    $(document).on('click', '.toggle-collapse-detalle-categoria', function () {
      let ID = $(this).parents('tr').attr('data-id-related');
      let $id = $('#' + ID);
      let status = $(this).parents('tr').attr('data-is-open');
      if (+status === 0) {
        // Cambiar el chevron hacia abajo para indicar que está abierto
        $(this).html('<i class="fas fa-chevron-down"></i>');
        $(this).parents('tr').attr('data-is-open', 1);

        // Cuando está abierto, agregar paddings.
        $id.closest('.td-container').css('padding', '.3rem .3rem .3rem 9%');
      } else {
        // Cambiar el chevron hacia la derecha para indicar que está cerrado
        $(this).html('<i class="fas fa-chevron-right"></i>');
        $(this).parents('tr').attr('data-is-open', 0);

        // Cuando está cerrado, quitar paddings, después de terminada la animación del collapse.
        setTimeout(function () {
          $id.closest('.td-container').css('padding', '0');
        }, 210);
      }
      $id.collapse('toggle');
    });

    $(document).on('click', '.expand_all_detalle_tienda', function () {
      $('.toggle-collapse-detalle-categoria[open-all="1"]').each(function (k, v) {
        $(v).click();
      });
    });
// ***************************************************************
// ---------------------- CONTROL REPORTEADOR --------------------
// ***************************************************************


// ***************************************************************
// ---------------------------- BITACORA  ------------------------
// ***************************************************************    
    $(document).on('click', '.obs_reporte_tienda', function () {
      const $parentTr = $(this).parents('tr');
      const tid = $parentTr.attr('data-taxonomy-tid');
      const nombre = $parentTr.attr('data-taxonomy-name');

      $(this).partnersModal({
        title: `Bitacora de ${nombre}`,
        modalSize: 'modal-lg',
        modalId: 'modal_bitacora_reporte_tienda',
        content: loader
      });

      loadBitacoraVista(tid);
    });

    /**
     * Función para cargar la vista de las bitacoras.
     * @param tid
     */
    const loadBitacoraVista = (tid) => {
      $('#modal_bitacora_reporte_tienda .modal-body').html(loader);
      $.ajax({
        type: 'POST',
        url: settings.reporte_ventas.ruta_consultas + 'vista_bitacora_reporte_tienda',
        data: JSON.stringify(tid),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#modal_bitacora_reporte_tienda .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    };

    $(document).on('click', '.capturar_bitacora_reporte_tienda', function () {
      const bitacora = $('textarea[name="descripcion_bitacora_reporte"]').val();
      const tid = $(this).attr('data-tid');
      const btn = $(this);
      let envio = {};

      if (!bitacora || bitacora.length === 0) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un mensaje'
        });
        return false;
      }

      btn.partnersBtnControl('start');

      envio.bitacora = bitacora;
      envio.tid = tid;

      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.reporte_ventas.ruta_consultas + 'capturar_bitacora_reporte_tienda',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            btn.partnersBtnControl('end');

            iziToast.success({
              title: 'Bien!',
              message: response.message
            });


            // Poner el tr con la clase para indicar que ya se capturó una bitacora
            $('#table_reporteador_tienda tbody tr[data-taxonomy-tid="' + tid + '"]').addClass('bg-warning');

            // Volver a cargar la vista de la bitacora
            loadBitacoraVista(tid);

          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.finalizar_bitacora', function () {
      const id_bitacora = $(this).parents('tr').attr('data-id-bitacora');
      const tid = $(this).parents('tr').attr('data-tid');

      $.ajax({
        type: 'POST',
        url: settings.reporte_ventas.ruta_consultas + 'finalizar_bitacora_reporte_tienda',
        data: JSON.stringify(id_bitacora),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            const data = response.message;
            console.log(data);

            // Si ya no queda ninguna bitacora activa con este tid, entonces quitar el
            // color de warning del tr de la tabla principal.
            if (!data.has_active_obs) {
              $('#table_reporteador_tienda tbody tr[data-taxonomy-tid="' + tid + '"]').removeClass('bg-warning');
            }

            // Volver a cargar la vista de la bitacora
            loadBitacoraVista(tid);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
// ***************************************************************
// ---------------------------- BITACORA  ------------------------
// ***************************************************************


  });
})
(jQuery);