(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {
    var loader =
      '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

    var ruta_url = settings.renovaciones.ruta_sys_tools + "inline_edit";
    partnersEditableContent(ruta_url, function () {
      autoUpdate.forceUpdate();
    });

    var nueva_renovacion_from_dominio = {};
    getUrlVars()["nueva_renovacion"] == "true"
      ? setTimeout(function () {
          nueva_renovacion_from_dominio.id_dominio = getUrlVars()["id_dominio"];
          nueva_renovacion_from_dominio.dominio = getUrlVars()["dominio"];
          window.history.pushState(
            "renovaciones",
            "Renovaciones",
            "/renovaciones"
          );
          $(".nueva_renovacion").click();
        }, 500)
      : "";

    if (getUrlVars()["id_cliente"]) {
      var type = getUrlVars()["type"];
      var temp_div;
      if (type == 1) {
        temp_div = $(
          '<div data-id="' +
            getUrlVars()["id_cliente"] +
            '" class="vista_cliente"></div>'
        );
      } else if (type == 2) {
        temp_div = $(
          '<div data-id="' +
            getUrlVars()["id_cliente"] +
            '" class="vista_contacto"></div>'
        );
      } else if (type == 3) {
        temp_div = $(
          '<div data-id="' +
            getUrlVars()["id_cliente"] +
            '" class="vista_cliente"></div>'
        );
      }
      setTimeout(function () {
        temp_div.insertAfter("body");
        temp_div.click();
        temp_div.remove();
      }, 600);
    }
    //***************************************************************
    //------------------- REPORTE BASE RENOVACIONES  ----------------
    //***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1,
      },
      sort: {
        order: "DESC",
        sort_by: "fecha_renovacion",
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        usuario: null,
        tipo_renovacion: null,
        start_date: null,
        end_date: null,
      },
    };

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $("#reporteador").find(".table").css("opacity", 0.5);
      }
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "reporte_base",
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $("#reporteador").html(data);
          $("#table_reporteador_renovaciones").stickyTableHeaders();
          $("#table_reporteador_renovaciones").partnersfilter();

          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    }

    $(document).on("click", "#reset_filters", function () {
      r_options.filter.search_bar = null;
      r_options.filter.usuario = null;
      r_options.filter.tipo_renovacion = null;
      $(".input_buscador_renovacion").val("");
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
    });

    // Filtrado - Texto
    $(document).on("keyup", ".input_buscador_renovacion", function (e) {
      clearTimeout($.data(this, "timer"));
      if (e.keyCode == 13) search(true);
      else $(this).data("timer", setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_renovacion").val();
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

    // Filtrado - Usuario
    $(document).on("change", "#filtrado_usuario", function () {
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.usuario = $(this).find("option:selected").val();
      autoUpdate.forceUpdate();
    });

    // Filtrado - Tipo Renovación
    $(document).on("change", "#filtrado_tipo_renovacion", function () {
      $("#reporteador").find(".table tbody").css("opacity", 0.5);
      r_options.filter.tipo_renovacion = $(this).find("option:selected").val();
      autoUpdate.forceUpdate();
    });

    //***************************************************************
    //------------------- REPORTE BASE RENOVACIONES  ----------------
    //***************************************************************

    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************

    var start = moment().startOf("month");
    var end = moment().add(1, "month").endOf("month");

    function cb(start, end) {
      $("#reportrange span").html(
        start.format("DD/MM/YYYY") + " - " + end.format("DD/MM/YYYY")
      );
    }

    cb(start, end);
    $("#reportrange").daterangepicker(
      {
        autoApply: true,
        linkedCalendars: false,
        parentEl: ".parent-calendar",
        locale: {
          format: "DD/MM/YYYY",
          separator: " - ",
          applyLabel: "Aplicar",
          cancelLabel: "Cancelar",
          fromLabel: "Desde",
          toLabel: "Hasta",
          customRangeLabel: "Personalizado",
          weekLabel: "S",
          daysOfWeek: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
          monthNames: [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre",
          ],
          firstDay: 1,
        },
        startDate: start,
        endDate: end,
        showDropdowns: true,
        ranges: {
          Enero: [
            moment().month("January").startOf("month"),
            moment().month("January").endOf("month"),
          ],
          Julio: [
            moment().month("July").startOf("month"),
            moment().month("July").endOf("month"),
          ],
          Hoy: [moment(), moment()],
          Febrero: [
            moment().month("February").startOf("month"),
            moment().month("February").endOf("month"),
          ],
          Agosto: [
            moment().month("August").startOf("month"),
            moment().month("August").endOf("month"),
          ],
          "Semana Actual": [moment().startOf("week"), moment().endOf("week")],
          Marzo: [
            moment().month("March").startOf("month"),
            moment().month("March").endOf("month"),
          ],
          Septiembre: [
            moment().month("September").startOf("month"),
            moment().month("September").endOf("month"),
          ],
          "Mes Actual": [moment().startOf("month"), moment().endOf("month")],
          Abril: [
            moment().month("April").startOf("month"),
            moment().month("April").endOf("month"),
          ],
          Octubre: [
            moment().month("October").startOf("month"),
            moment().month("October").endOf("month"),
          ],
          "Bimestre Actual": [
            moment().startOf("month"),
            moment().add(1, "month").endOf("month"),
          ],
          Mayo: [
            moment().month("May").startOf("month"),
            moment().month("May").endOf("month"),
          ],
          Noviembre: [
            moment().month("November").startOf("month"),
            moment().month("November").endOf("month"),
          ],
          "Año Actual": [moment().startOf("year"), moment().endOf("year")],
          Junio: [
            moment().month("June").startOf("month"),
            moment().month("June").endOf("month"),
          ],
          Diciembre: [
            moment().month("December").startOf("month"),
            moment().month("December").endOf("month"),
          ],
        },
      },
      cb
    );

    $("#reportrange").on("apply.daterangepicker", function () {
      var fecha = $("#reportrange").find("span").text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table").css("opacity", 0.5);
    });

    (function () {
      var fecha = $("#reportrange").find("span").text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $("#reporteador").find(".table").css("opacity", 0.5);
    })();
    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************

    //***************************************************************
    //----------------------  NUEVA RENOVACIÓN ----------------------
    //***************************************************************
    $(document).on("click", ".nueva_renovacion", function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: "Nueva Renovación",
        modalSize: "modal-lg",
        modalId: "vista-nueva-renovacion-modal",
        content: loader,
      });
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "nueva_renovacion_form",
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            $("#vista-nueva-renovacion-modal .modal-body").html(
              response.message
            );
            setTimeout(function () {
              $("#fecha-renovacion-container .input-group.date").datepicker({
                format: "dd/mm/yyyy",
                todayBtn: "linked",
                language: "es",
                autoclose: true,
                todayHighlight: true,
                startDate: "today",
                orientation: "auto",
                container: ".input-group.date",
              });

              $("#buscar_cliente").typeahead({
                order: "asc",
                minlength: 1,
                maxItem: 15,
                hint: true,
                accent: true,
                group: {
                  template: "{{group}}",
                },
                maxItemPerGroup: 5,
                backdrop: {
                  "background-color": "#fff",
                },
                template: function (query, item) {
                  var color_t_clasificacion;
                  var tipo_clasificacion = item.tipo_clasificacion;
                  switch (tipo_clasificacion) {
                    case "a":
                      color_t_clasificacion = "success";
                      break;
                    case "b":
                      color_t_clasificacion = "success";
                      break;
                    case "c":
                      color_t_clasificacion = "warning";
                      break;
                    case "d":
                      color_t_clasificacion = "danger";
                      break;
                    case "e":
                      color_t_clasificacion = "danger";
                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();

                  var credito_contado =
                    item.credito == 1 ? "Crédito" : "Contado";
                  if (item.tipo_cliente != 3) {
                    return (
                      "<p>" +
                      "<span>{{nombre_cliente}}</span> " +
                      '<span class="float-right badge badge-' +
                      color_t_clasificacion +
                      '">' +
                      '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                      tipo_clasificacion +
                      " | " +
                      credito_contado +
                      "</span> </p> "
                    );
                  } else {
                    return "<p><span>{{nombre_cliente}}</span> </p> ";
                  }
                },
                dynamic: true,
                dropdownFilter: "Todos",
                emptyTemplate:
                  '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
                source: {
                  Clientes: {
                    display: [
                      "nombre_cliente",
                      "alias",
                      "email",
                      "nombre_facturacion",
                      "pagina_web",
                    ],
                    ajax: {
                      url:
                        settings.renovaciones.ruta_lista_clientes + "complete",
                      path: "data.datos.clientes",
                    },
                  },
                  Contactos: {
                    display: [
                      "nombre_cliente",
                      "alias",
                      "email",
                      "nombre_facturacion",
                      "pagina_web",
                    ],
                    ajax: {
                      url:
                        settings.renovaciones.ruta_lista_clientes + "complete",
                      path: "data.datos.contactos",
                    },
                  },
                  Proveedores: {
                    display: [
                      "nombre_cliente",
                      "alias",
                      "email",
                      "nombre_facturacion",
                      "pagina_web",
                    ],
                    ajax: {
                      url:
                        settings.renovaciones.ruta_lista_clientes + "complete",
                      path: "data.datos.proveedores",
                    },
                  },
                },
                callback: {
                  onClickAfter: function (node, a, item) {
                    var color_t_clasificacion;
                    var tipo_clasificacion = item.tipo_clasificacion;
                    switch (tipo_clasificacion) {
                      case "a":
                        color_t_clasificacion = "success";
                        break;
                      case "b":
                        color_t_clasificacion = "success";
                        break;
                      case "c":
                        color_t_clasificacion = "warning";
                        break;
                      case "d":
                        color_t_clasificacion = "danger";
                        break;
                      case "e":
                        color_t_clasificacion = "danger";
                        break;
                    }
                    tipo_clasificacion = tipo_clasificacion.toUpperCase();
                    var credito_contado =
                      item.credito == 1 ? "Crédito" : "Contado";
                    if (item.tipo_cliente != 3) {
                      $(".quick_info_client").html(
                        '<span class="badge badge-' +
                          color_t_clasificacion +
                          '">' +
                          '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                          tipo_clasificacion +
                          " | " +
                          credito_contado +
                          "</span> </p> "
                      );
                      const id_cliente = item.id_cliente;
                      prepareEvs(1, {
                        color_t_clasificacion,
                        tipo_clasificacion,
                        credito_contado,
                        id_cliente,
                        settings,
                      });
                    }

                    //Bindear el id del cliente al input
                    node.attr("data-id-cliente", item.id_cliente);

                    // Generar lista contactos solo para clientes Negocio/Distribuidor
                    if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                      generar_contactos(
                        settings.renovaciones.ruta_lista_contactos,
                        item.id_cliente
                      );

                      //Solamente agrega este attr cuando debe de tener contactos
                      node.attr("data-tipo-negocio", item.tipo_negocio);
                    } else {
                      $(".contacto_container").hide();
                      $(".select_lista_contactos").empty();
                    }
                  },
                  onSearch: function (node, a) {
                    if (a !== "") {
                    } else {
                      // Para prevenir errores de sobrescribir o duplicar
                      $(".contacto_container").hide();
                      $(".select_lista_contactos").empty();
                      $(".quick_info_client").html("");
                      node.removeAttr("data-id-cliente");
                      node.removeAttr("data-tipo-negocio");
                    }
                  },
                },
              });

              $.validate({
                form: "#nueva_renovacion_form",
                errorMessageClass: "invalid-feedback",
                inputParentClassOnError: "text-danger",
                inputParentClassOnSuccess: "text-success",
                errorElementClass: "is-invalid",
              });
              // Si se esta haciendo una renovación que viene desde el momento de crear un dominio web,
              // poner el dominio entonces en la parte de producto servicio.
              if (!_.isEmpty(nueva_renovacion_from_dominio)) {
                $('input[name="producto_renovacion"]').val(
                  nueva_renovacion_from_dominio.dominio
                );
              }
            }, 400);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //----------------------  NUEVA RENOVACIÓN ----------------------
    //***************************************************************

    //***************************************************************
    //---------------------- CAPTURAR RENOVACIÓN --------------------
    //***************************************************************
    $(document).on("keypress", ":input:not(textarea)", function (e) {
      return e.keyCode != 13;
    });
    $(document).on("submit", "#nueva_renovacion_form", function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl("start");
      var datos = $("#nueva_renovacion_form").serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]["name"]] = datos[i]["value"];
      }
      if (!$("#buscar_cliente").attr("data-id-cliente")) {
        iziToast.error({
          title: "Error",
          message: "Selecciona un cliente",
        });
        btn.partnersBtnControl("end");
        return false;
      }
      if (
        $("#buscar_cliente").attr("data-tipo-negocio") == 1 ||
        $("#buscar_cliente").attr("data-tipo-negocio") == 3
      ) {
        if ($(".select_lista_contactos").find("option:selected").val() == 0) {
          iziToast.error({
            title: "Error",
            message: "Selecciona un contacto",
          });
          btn.partnersBtnControl("end");
          return false;
        }
      }

      if (
        !$("#fecha-renovacion-container .input-group.date").datepicker(
          "getDate"
        )
      ) {
        iziToast.error({
          title: "Error",
          message: "Selecciona la fecha inicio de la renovación.",
        });
        btn.partnersBtnControl("end");
        return false;
      }

      var intervalo = $(".input_frecuencia").val();
      var frecuencia_tipo = $(".select_frecuencia option:selected").val();
      var count;

      if (frecuencia_tipo == "WEEKLY") {
        count = Math.round(260 / intervalo);
      } else if (frecuencia_tipo == "MONTHLY") {
        count = Math.round(120 / intervalo);
      } else if (frecuencia_tipo == "YEARLY") {
        count = Math.round(20 / intervalo);
      }
      var fecha_inicio = moment(
        $("#fecha-renovacion-container .input-group.date").datepicker("getDate")
      );
      var dia = fecha_inicio.date();
      if (dia <= 9) {
        dia = "0" + fecha_inicio.date();
      }
      var mes = fecha_inicio.month() + 1;
      if (mes <= 9) {
        mes = "0" + (fecha_inicio.month() + 1);
      }

      var year = fecha_inicio.year();

      if (
        frecuencia_tipo == "MONTHLY" &&
        (dia == "29" || dia == "30" || dia == "31")
      ) {
        var rules = new RRule(
          RRule.parseString(
            "FREQ=" +
              frecuencia_tipo +
              ";DTSTART=" +
              year +
              mes +
              dia +
              "T214000Z;COUNT=" +
              count +
              ";INTERVAL=" +
              intervalo +
              ";BYMONTHDAY=-1"
          )
        );
        iziToast.warning({
          title: "Psst",
          message:
            "Algunos meses tienen menos de " +
            dia +
            " días.Por lo tanto, la repetición tendrá lugar en el último día de cada mes.",
        });
      } else {
        var rules = new RRule(
          RRule.parseString(
            "FREQ=" +
              frecuencia_tipo +
              ";DTSTART=" +
              year +
              mes +
              dia +
              "T060000Z;COUNT=" +
              count +
              ";INTERVAL=" +
              intervalo +
              ""
          )
        );
      }
      var fechas_array = rules.all();
      var fechas_length = fechas_array.length;
      var new_date_array = Array();
      for (var i = 0; i < fechas_length; i++) {
        new_date_array[i] = new Date(fechas_array[i]).getTime() / 1000;
      }

      datosEnvio.id_cliente = $("#buscar_cliente").attr("data-id-cliente");
      datosEnvio.fecha_renovacion = $(
        "#fecha-renovacion-container .input-group.date"
      ).datepicker("getDate");
      datosEnvio.id_contacto = $(".select_lista_contactos")
        .find("option:selected")
        .val();
      datosEnvio.frecuencia_intervalo = intervalo;
      datosEnvio.frecuencia_tipo = frecuencia_tipo;
      datosEnvio.fechas = new_date_array;
      datosEnvio.tipo_renovacion = $(
        'select[name="tipo_renovacion"] option:selected'
      ).val();

      // Si se esta haciendo una renovación que viene desde el momento de crear un dominio web,
      // pasar el id_dominio al momento de capturar para que se vincule la renovación con el dominio web.
      if (!_.isEmpty(nueva_renovacion_from_dominio)) {
        datosEnvio.id_dominio = nueva_renovacion_from_dominio.id_dominio;
        datosEnvio.nombre_dominio = nueva_renovacion_from_dominio.dominio;
      }

      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "capturar_renovacion",
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            $("#vista-nueva-renovacion-modal").modal("hide");
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //---------------------- CAPTURAR RENOVACIÓN --------------------
    //***************************************************************

    //***************************************************************
    //-------------------------- OBSERVACIONES   --------------------
    //***************************************************************
    $(document).on("click", ".renovaciones-observaciones", function () {
      var id_renovacion = $(this).parents("tr").attr("data-id-renovacion");
      var datosEnvio = {};
      datosEnvio.id_renovacion = id_renovacion;
      $(this).partnersObs({
        modalId: "observaciones-renovaciones",
        ajaxUrl: settings.renovaciones.ruta_sys_tools + "load_obs",
        index: "id_renovacion",
        id_index: id_renovacion,
        tabla: "partners_renovaciones",
        closeAfterSuccess: false,
        col: "observaciones",
        ajaxSuccessCallback: function () {
          autoUpdate.forceUpdate();
        },
      });
    });
    //***************************************************************
    //-------------------------- OBSERVACIONES   --------------------
    //***************************************************************

    //***************************************************************
    //------------------------ ELIMINAR RENOVACIÓN  -----------------
    //***************************************************************
    $(document).on("click", ".eliminar_renovacion", function () {
      var id_renovacion = $(this).parents("tr").attr("data-id-renovacion");
      var descripcion = $(this).parents("tr").attr("data-desc-renovacion");
      swal({
        title: "Estás Seguro?",
        html: "Deseas eliminar: " + descripcion + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        onClose: function () {
          $("body").removeAttr("style");
          restoreBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: "POST",
              url: settings.renovaciones.ruta_consultas + "eliminar_renovacion",
              data: id_renovacion,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == "success") {
                  autoUpdate.forceUpdate();
                  setTimeout(function () {
                    undo_servicio_deleted(descripcion, id_renovacion);
                    swal.close();
                  }, 2000);
                  resolve();
                } else if (response.status == "error") {
                  iziToast.error({
                    title: "Error",
                    message: response.message,
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message:
                    "Request Status: " +
                    xhr.status +
                    " Status Text: " +
                    xhr.statusText,
                });
              },
            });
          });
        },
        allowOutsideClick: false,
      }).then(function (a) {
        if (!a.dismiss) {
          swal(
            "Eliminada!",
            "La renovación se ha eliminado correctamente.",
            "success"
          );
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_servicio_deleted(desc, id_renovacion) {
      iziToast.show({
        title: desc,
        message: " ha sido eliminada.",
        position: "bottomLeft",
        timeout: 10000,
        color: "dark",
        progressBarColor: "rgb(0, 255, 184)",
        icon: "fa fa-ban",
        buttons: [
          [
            '<button data-id-renovacion="' +
              id_renovacion +
              '" data-desc="' +
              desc +
              '" class="renovacion_undo_delete">Deshacer</button>',
            function (instance, toast) {
              instance.hide(
                {
                  transitionOut: "fadeOutUp",
                },
                toast,
                "close"
              );
            },
          ],
        ],
      });
    }

    $(document).on("click", ".renovacion_undo_delete", function () {
      var id_renovacion = $(this).attr("data-id-renovacion");
      var desc = $(this).attr("data-desc");
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "reactivate_renovacion",
        data: id_renovacion,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: desc,
              message: " ha sido traida de vuelta a la vida!",
              icon: "fa fa-usd",
            });
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //------------------------ ELIMINAR RENOVACIÓN  -----------------
    //***************************************************************

    //***************************************************************
    //------------------------ VISTA  RENOVACIÓN  -------------------
    //***************************************************************
    $(document).on("click", ".vista_renovacion", function () {
      var id_renovacion = $(this).parents("tr").attr("data-id-renovacion");
      $(this).partnersModal({
        title: "Renovación " + id_renovacion,
        modalId: "vista-renovacion-modal",
        forceWidth: 60,
        content: loader,
      });

      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "vista_renovacion",
        data: id_renovacion,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            $("#vista-renovacion-modal .modal-body").html(response.message);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //------------------------ VISTA  RENOVACIÓN  -------------------
    //***************************************************************

    //***************************************************************
    //-------------------------- STATUS PAGADO ----------------------
    //***************************************************************
    $(document).on("click", ".status_pagado", function () {
      var id_renovacion = $(this).parents("tr").attr("data-id-renovacion");
      var template =
        '<div class="row">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning servicio_no_pagado w-100" data-id-renovacion="' +
        id_renovacion +
        '" role="button">No</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-success servicio_pagado w-100" data-id-renovacion="' +
        id_renovacion +
        '" role="button">Pagado</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-info servicio_facturado w-100" data-id-renovacion="' +
        id_renovacion +
        '" role="button">Facturado</button></div>' +
        "</div>";

      $(this).partnersModal({
        content: template,
        title: "Selecciona",
        forceWidth: 25,
        modalId: "modal-pagado-renovaciones",
        noFooter: true,
      });
    });

    $(document).on("click", ".servicio_no_pagado", function () {
      var id_renovacion = $(this).attr("data-id-renovacion");
      var clicked_td = $(
        'tr[data-id-renovacion="' + id_renovacion + '"] .status_pagado'
      );
      $("#modal-pagado-renovaciones .modal-body").html(loader);
      var envio = {};
      envio.new_val = 0;
      envio.id_renovacion = id_renovacion;
      envio.col = "pagado";
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "update_status",
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: "bottomLeft",
            });
            $("#modal-pagado-renovaciones").modal("hide");
            clicked_td.removeClass("status-green");
            clicked_td.addClass("status-red");
            clicked_td.html("No");
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });

    $(document).on("click", ".servicio_pagado", function () {
      var id_renovacion = $(this).attr("data-id-renovacion");
      var clicked_td = $(
        'tr[data-id-renovacion="' + id_renovacion + '"] .status_pagado'
      );
      $("#modal-pagado-renovaciones .modal-body").html(loader);
      var envio = {};
      envio.new_val = 1;
      envio.id_renovacion = id_renovacion;
      envio.col = "pagado";
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "update_status",
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: "bottomLeft",
            });
            $("#modal-pagado-renovaciones").modal("hide");
            clicked_td.removeClass("status-red");
            clicked_td.addClass("status-green");
            clicked_td.html("Pagado");
            autoUpdate.forceUpdate();
            updateFechaDominioWeb(id_renovacion);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });

    $(document).on("click", ".servicio_facturado", function () {
      var id_renovacion = $(this).attr("data-id-renovacion");
      var clicked_td = $(
        'tr[data-id-renovacion="' + id_renovacion + '"] .status_pagado'
      );
      $("#modal-pagado-renovaciones").modal("hide");

      var new_val = 2;
      var envio = {};
      envio.id_renovacion = id_renovacion;
      envio.new_val = new_val;
      envio.col = "pagado";
      swal({
        title: "Número de factura",
        input: "text",
        showCancelButton: true,
        confirmButtonText: "Guardar",
        cancelButtonColor: "#DD6B55",
        cancelButtonText: "Cancelar",
        confirmButtonClass: "btn btn-success",
        cancelButtonClass: "btn btn-danger",
        animation: false,
        customClass: "animated fadeInDownCustom",
        showLoaderOnConfirm: true,
        onClose: function () {
          $("body").removeAttr("style");
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject("Debes ingresar un número de factura!");
            } else {
              envio.obs =
                "Se marcó como como facturado con el número de factura: " +
                reason;
              envio.facturado = 1;
              envio.numero_factura = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: "POST",
                url: settings.renovaciones.ruta_consultas + "update_status",
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == "success") {
                    resolve();
                  } else if (response.status == "error") {
                    iziToast.error({
                      title: "Error",
                      message: response.message,
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message:
                      "Request Status: " +
                      xhr.status +
                      " Status Text: " +
                      xhr.statusText,
                  });
                },
              });
            }
          });
        },
        allowOutsideClick: false,
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass("status-green");
          clicked_td.html("Factura");
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: "bottomLeft",
          });
          autoUpdate.forceUpdate();
          updateFechaDominioWeb(id_renovacion);
        }
      });
    });

    /**
     * Este método se ejecuta cuando en una renovación se hace un pago, con la finalidad de después
     * buscar en el panel de dominios_web, un dominio que este relacionado con esta renovación para
     * después poderle aumentar las fechas de expiración por un año más.
     */
    function updateFechaDominioWeb(id_renovacion) {
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_consultas + "update_fecha_dominio_web",
        data: JSON.stringify(id_renovacion),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    }

    //***************************************************************
    //-------------------------- STATUS PAGADO ----------------------
    //***************************************************************

    //***************************************************************
    //----------------- ESTATUS PENDIENTE ADMON ---------------------
    //***************************************************************
    $(document).on("click", ".crear_pendiente_admon", function () {
      window.open("/pendientes?new_pendiente=1", "_blank");
    });
    //***************************************************************
    //----------------- ESTATUS PENDIENTE ADMON ---------------------
    //***************************************************************

    //***************************************************************
    //---------------------- REENVIAR RENOVACIÓN --------------------
    //***************************************************************

    /**
     * Nuevo correo
     */
    $(document).on("click", ".reenviar_renovacion", (e) => {
      const idCliente = +e.currentTarget
        .closest("tr")
        .getAttribute("data-id-cliente");
      const idRenovacion = +e.currentTarget
        .closest("tr")
        .getAttribute("data-id-renovacion");
      // eslint-disable-next-line no-undef
      modalCorreo(
        idCliente,
        settings,
        idRenovacion,
        (emailsToSend, datos, body, hideModal) => {
          const data = {
            to: emailsToSend,
            id_renovacion: datos,
            body,
          };
          $.ajax({
            type: "POST",
            url: `${settings.renovaciones.ruta_consultas}enviar_reporte_correo`,
            data: JSON.stringify(data),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success(response) {
              if (response.status === "success") {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: "Listo",
                  message: "Correos enviados",
                });
                hideModal(true);
              } else if (response.status === "error") {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: "Error",
                  message: response.message,
                });
                hideModal(false);
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: "Ocurrio un error: ",
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
              hideModal(false);
            },
          });
        }
      );
    });

    $(document).on("click", ".__reenviar_renovacion", function () {
      var id_renovacion = $(this).parents("tr").attr("data-id-renovacion");
      var email_cliente = $(this).parents("tr").attr("data-email-cliente");
      var email_contacto = $(this).parents("tr").attr("data-email-contacto");
      var email_user = $(this).parents("tr").attr("data-email-user");
      swal({
        title: "Ingresa los correos",
        text: "Separados por una coma",
        input: "text",
        confirmButtonText: "Enviar!",
        showLoaderOnConfirm: true,
        inputClass: "emails_to_send",
        allowOutsideClick: true,
        allowEscapeKey: true,
        onClose: function () {
          $("body").removeAttr("style");
        },
        onOpen: function () {
          fixBootstrapModal();
          $('input[type="text"].emails_to_send').val(
            email_cliente + "," + email_contacto + "," + email_user
          );
          $('input[type="text"].emails_to_send').focus();
          $('input[type="text"].emails_to_send').tagsinput();
          $('input[type="text"].emails_to_send').on(
            "beforeItemAdd",
            function (event) {
              if (!validateEmail(event.item)) {
                event.cancel = true;
              }
            }
          );
        },
        preConfirm: function (inputValue) {
          return new Promise(function (resolve, reject) {
            if (
              inputValue === false ||
              !inputValue ||
              inputValue == "" ||
              inputValue == undefined
            ) {
              reject("Ingresa al menos un correo!");
            } else {
              var emails_arr = $('input[type="text"].emails_to_send').tagsinput(
                "items"
              );
              var send_to = {};
              send_to.to = emails_arr;
              send_to.id_renovacion = id_renovacion;
              send_to = JSON.stringify(send_to);
              $.ajax({
                type: "POST",
                url:
                  settings.renovaciones.ruta_consultas +
                  "enviar_reporte_correo",
                data: send_to,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == "success") {
                    resolve();
                  } else if (response.status == "error") {
                    iziToast.error({
                      title: "Error",
                      message: response.message,
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message:
                      "Request Status: " +
                      xhr.status +
                      " Status Text: " +
                      xhr.statusText,
                  });
                },
              });
            }
          });
        },
      }).then(function (a) {
        if (!a.dismiss) {
          var emails = $('input[type="text"].emails_to_send').val();
          var emails_arr = $('input[type="text"].emails_to_send').tagsinput(
            "items"
          );
          var timeout = emails_arr.length * 800;
          swal.close();

          var x =
            'Enviando correo a <span class="font-weight-bold" id="js-rotating">' +
            emails +
            "</span>";

          iziToast.show({
            message: x,
            position: "center",
            timeout: timeout,
            progressBar: false,
            color: "dark",
            icon: "fa fa-envelope-open-o",
            iconColor: "#fff",
          });
          var morphext = $("#js-rotating").Morphext({
            animation: "fadeInDownCustom",
            separator: ",",
            speed: 800,
          });
          var data;

          data = morphext.data("plugin_Morphext");
          setTimeout(function () {
            data.stop();
          }, timeout - 800);

          setTimeout(function () {
            swal({
              title: "Bien!",
              text: "Correos enviados correctamente",
              type: "success",
              timer: 1000,
              showConfirmButton: false,
            });
          }, timeout);
        }
      });
    });
    //***************************************************************
    //---------------------- REENVIAR RENOVACIÓN --------------------
    //***************************************************************

    //***************************************************************
    //---------------------- CONVERTIR A COTIZACIÓN  ----------------
    //***************************************************************
    $(document).on("click", ".convertir_cotizacion", function () {
      var id_renovacion = $(this).parents("tr").attr("data-id-renovacion");

      $(this).partnersModal({
        title: "Convertir a Cotización",
        modalId: "convertir-cotizacion-renovaciones",
        forceWidth: 90,
        content: loader,
      });

      $.ajax({
        type: "POST",
        url:
          settings.renovaciones.ruta_consultas + "vista_convertir_cotizacion",
        data: JSON.stringify(id_renovacion),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            $("#convertir-cotizacion-renovaciones .modal-body").html(
              response.message
            );
            setTimeout(function () {
              $.validate({
                form: "#convertir_cotizacion_form",
                errorMessageClass: "invalid-feedback",
                inputParentClassOnError: "text-danger",
                inputParentClassOnSuccess: "text-success",
                errorElementClass: "is-invalid",
              });
            }, 400);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });

    $(document).on("keypress", ":input:not(textarea)", function (event) {
      if ($(this).hasClass("precio_cotizacion") && event.keyCode == 13) {
        $(".agregar_entity_cotizacion").click();
      }
      return event.keyCode != 13;
    });

    $(document).on("change", ".select_cotizacion_compartida", function () {
      if ($(this).val() == 1) {
        $(".cotizacion_compartida_container").show();
      } else {
        $(".cotizacion_compartida_container").hide();
      }
    });
    $(document).on("click", ".agregar_entity_cotizacion", function () {
      var cantidad = $(".cantidad_cotizacion").val();
      var descripcion = $(".descripcion_cotizacion").val();
      var precio = $(".precio_cotizacion").val();

      if ($.trim(cantidad).length < 1) {
        iziToast.error({
          title: "Error",
          message: "Agrega una cantidad",
        });
        return false;
      }

      if (isNaN(cantidad)) {
        iziToast.error({
          title: "Error",
          message: "Ingresa una cantidad correcta",
        });
        return false;
      }

      if ($.trim(descripcion).length < 1) {
        iziToast.error({
          title: "Error",
          message: "Agrega una descripción",
        });
        return false;
      }

      if ($.trim(precio).length < 1) {
        iziToast.error({
          title: "Error",
          message: "Agrega un precio",
        });
        return false;
      }

      if (isNaN(precio)) {
        iziToast.error({
          title: "Error",
          message: "Ingresa un precio correcto",
        });
        return false;
      }

      var tr = $(
        '<tr class="entity_cotizacion" >' +
          '<td class="entity_cotizacion_cantidad">' +
          cantidad +
          "</td>" +
          '<td class="entity_cotizacion_descripcion" style="word-break: break-all;">' +
          descripcion +
          "</td>" +
          '<td class="text-right entity_cotizacion_precio" data-precio="' +
          precio +
          '">' +
          parseFloat(precio).format(2) +
          "</td>" +
          '<td class="text-right entity_cotizacion_subtotal" data-subtotal="' +
          precio * cantidad +
          '">' +
          (precio * cantidad).format(2) +
          "</td>" +
          '<td class="eliminar_entity_cotizacion text-center text-danger cursor-pointer">Eliminar</td>' +
          "</tr>"
      );
      $(".table-entities-cotizacion tbody").append(tr);
      sumar_total_entities_cotizacion();
      $(".cantidad_cotizacion").val("");
      $(".descripcion_cotizacion").val("");
      $(".precio_cotizacion").val("");
      $(".cantidad_cotizacion").focus();
    });

    function sumar_total_entities_cotizacion() {
      var total = 0;
      $(".entity_cotizacion_subtotal").each(function () {
        total += parseFloat($(this).attr("data-subtotal"));
      });
      $(".table-entities-cotizacion .total_cotizacion").html(
        parseFloat(total).format(2)
      );
    }

    $(document).on("click", ".eliminar_entity_cotizacion", function () {
      $(this).parents("tr").remove();
      sumar_total_entities_cotizacion();
    });

    $(document).on("submit", "#convertir_cotizacion_form", function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl("start");
      var datos = $("#convertir_cotizacion_form").serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]["name"]] = datos[i]["value"];
      }

      datosEnvio.datos = [];
      $(".entity_cotizacion").each(function () {
        datosEnvio.datos.push({
          cantidad: $(this).find(".entity_cotizacion_cantidad").text(),
          descripcion: $(this).find(".entity_cotizacion_descripcion").text(),
          precio: $(this).find(".entity_cotizacion_precio").attr("data-precio"),
        });
      });

      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: "Error",
          message: "Debes agregar al menos un producto a la cotización",
        });
        return false;
      }

      btn.partnersBtnControl("start");

      if ($(".select_cotizacion_compartida:checked").val() == 1) {
        datosEnvio.compartida_con = $(
          ".cotizacion_compartida_con option:selected"
        ).val();
      }

      datosEnvio.id_cliente = $(this).attr("data-id-cliente");
      datosEnvio.id_contacto = $(this).attr("data-id-contacto");
      datosEnvio.id_renovacion = $(this).attr("data-id-renovacion");

      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: "POST",
        url:
          settings.renovaciones.ruta_consultas +
          "capturar_convertir_cotizacion",
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: "Renovación Convertida Correctamente.",
            });
            window.open("/cotizaciones/vista/" + response.message);
            $("#convertir-cotizacion-renovaciones").modal("hide");
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });

    $(document).on("click", ".relacion_cotizacion", function () {
      window.open("/cotizaciones/vista/" + $(this).attr("data-id-cotizacion"));
    });
    //***************************************************************
    //---------------------- CONVERTIR A COTIZACIÓN  ----------------
    //***************************************************************

    //***************************************************************
    //-------------------- RENOVACIONES INFORM ERRORS ---------------
    //***************************************************************
    $(document).on("click", ".inform_errors", function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr("data-error-msg");
      error.err_time = $(this).attr("data-error-time");
      error.err_loc = $(this).attr("data-error-location");
      error.err_user = $(this).attr("data-error-user");
      error.err_user_id = $(this).attr("data-error-user-id");

      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_sys_tools + "report_error",
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            $(".modal").each(function () {
              $(this).modal("hide");
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false,
            });
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //-------------------- RENOVACIONES INFORM ERRORS ---------------
    //***************************************************************

    //***************************************************************
    //-------------------- RENOVACIONES VER FACTURA -----------------
    //***************************************************************
    $(document).on("click", ".ver_factura", function () {
      var id_factura = $(this).text();
      $(this).partnersModal({
        title: "Factura " + id_factura,
        modalId: "vista-factura",
        forceWidth: 90,
        content: loader,
      });
      $.ajax({
        type: "POST",
        url: settings.renovaciones.ruta_sys_tools + "get_full_factura",
        data: JSON.stringify(id_factura),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            if (response.message == "not_on_server") {
              var content =
                "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content =
                "<div>" +
                '<iframe src="/system/tools/vista_factura?factura=' +
                response.message +
                '" width="100%;" height="600px;"></iframe>' +
                "</div>";
            }
            $("#vista-factura .modal-body").html(content);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //-------------------- RENOVACIONES VER FACTURA -----------------
    //***************************************************************
  });
})(jQuery);
