(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {


    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

    //***************************************************************
    //--------------------- REPORTE BASE RECIBO  --------------------
    //***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'id_recibo'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        usuario: null,
        agente: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'reporte_base_reporte',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          var res = data.split("Array");
          data = res.slice(-1);
          $('#reporteador').html(data);
          $('#table_reporteador_recibo_reporte').stickyTableHeaders();
          $('#table_reporteador_recibo_reporte').partnersfilter();

          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_recibo', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_recibo").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

    //***************************************************************
    //--------------------- REPORTE BASE RECIBO  --------------------
    //***************************************************************


    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************


    //***************************************************************
    //------------------ RECIBO VISTA COMPRAS PRODUCTO --------------
    //***************************************************************
    $(document).on('click', '.vista_compras_producto', function () {
      var codigo = $(this).parents('tr').attr('data-codigo-producto');
      var $this = $(this).parents('tr');
      var envio = {};
      envio.codigo = codigo;
      envio.id_movimiento = $(this).parents('tr').attr('data-id-dato');
      envio.status = $this.attr('data-status');

      envio = JSON.stringify(envio);
      $(this).partnersModal({
        title: 'Compras Productos: ' + $this.attr('data-fecha') +
          ' | ' + $this.attr('data-cantidad') + ' piezas | ' + $this.attr('data-costo') + '<br/>' +
          codigo + ' | ' + $this.attr('data-producto'),
        forceWidth: 90,
        modalId: 'vista-compras-producto-modal',
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'vista_compras_producto',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-compras-producto-modal .modal-body').html(response.message);
            $('#partners-calculadora').partnersCalc();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });


    $(document).on('click', '.modificar_costo', function () {
      var id_dato = $(this).parents('tr').attr('data-id-movimiento');
      var costo = numeral($(this).text()).value();
      var envio = {};
      envio.id_dato = id_dato;
      envio.costo = costo;
      envio = JSON.stringify(envio);

      // Encontrar el <tr> -> <td> que ahi pertenece a este movimiento que se esta modificando
      // para hacer el cambio de status visible.
      var $this, $thisCosto, $thisUtilidad, venta;

      $('#table_reporteador_recibo_reporte tbody tr').each(function (k, v) {
        if ($(v).attr('data-id-dato') == id_dato) {
          console.log("xdqw");
          $thisCosto = $(v).find('td').eq(9);
          $thisUtilidad = $(v).find('td').eq(11);
          $this = $(v).find('td').eq(10);
          venta = numeral($(v).find('td').eq(6).html()).value() * numeral($(v).find('td').eq(7).html()).value();
          return;
        }
      });

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'modificar_costo',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#vista-compras-producto-modal').modal('hide');

            // Actualizar el td con el nuevo costo y recalcular la utilidad
            $thisCosto.removeAttr('class')
              .attr('class', 'text-right vista_compras_producto cursor-pointer status-yellow')
              .html(numeral(costo).format('0,0.00'));

            var tmpUtilidad = numeral(venta - costo).format('0,0.00');
            $thisUtilidad.removeAttr('class')
              .attr('class', 'text-right')
              .html(tmpUtilidad);


            // Actualizar la columna de status poniendolo en 1 automaticamente.
            $this.removeAttr('class')
              .attr('class', 'text-center cursor-pointer cambiar_status status-green')
              .html('Ok');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.modificar_costo_with_calc', function () {
      var costo = $('#partners-calculadora').partnersCalc('getResultCalc');
      var id_movimiento = $(this).attr('data-id-movimiento');
      var envio = {};
      envio.id_dato = id_movimiento;
      envio.costo = costo;
      envio = JSON.stringify(envio);

      // Encontrar el <tr> -> <td> que ahi pertenece a este movimiento que se esta modificando
      // para hacer el cambio de status visible.
      var $this, $thisCosto, $thisUtilidad, venta;

      $('#table_reporteador_recibo_reporte tbody tr').each(function (k, v) {
        if ($(v).attr('data-id-dato') == id_movimiento) {
          $thisCosto = $(v).find('td').eq(9);
          $thisUtilidad = $(v).find('td').eq(11);
          $this = $(v).find('td').eq(10);
          venta = numeral($(v).find('td').eq(6).html()).value() * numeral($(v).find('td').eq(7).html()).value();
          return;
        }
      });

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'modificar_costo',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#vista-compras-producto-modal').modal('hide');

            // Actualizar el td con el nuevo costo y recalcular la utilidad
            $thisCosto.removeAttr('class')
              .attr('class', 'text-right vista_compras_producto cursor-pointer status-yellow')
              .html(numeral(costo).format('0,0.00'));

            var tmpUtilidad = numeral(venta - costo).format('0,0.00');
            $thisUtilidad.removeAttr('class')
              .attr('class', 'text-right')
              .html(tmpUtilidad);


            // Actualizar la columna de status poniendolo en 1 automaticamente.
            $this.removeAttr('class')
              .attr('class', 'text-center cursor-pointer cambiar_status status-green')
              .html('Ok');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //------------------- RECIBO VISTA COMPRAS PRODUCTO -------------
    //***************************************************************

    //***************************************************************
    //--------------------- REPORTE RECIBO STATUS -------------------
    //***************************************************************
    $(document).on('click', '.cambiar_status', function () {
      var $this = $(this);
      var current_val = $this.html();
      var next_val, new_val;
      var classColor = '';
      if (current_val == 'Ok') {
        next_val = 'Revisar';
        new_val = 2;
        classColor = 'status-red';
      } else if (current_val == 'Revisar') {
        next_val = 'Ok';
        new_val = 1;
        classColor = 'status-green';
      }

      var envio = {};
      envio.id_dato = $this.parents('tr').attr('data-id-dato');
      envio.new_val = new_val;
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'change_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#vista-compras-producto-modal').modal('hide');
            $this.removeAttr('class');
            $this.attr('class', 'text-center cursor-pointer cambiar_status ' + classColor);
            $this.html(next_val);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('change', 'input[name="radio_status_movimiento"]', function () {
      var current_val = $(this).val();
      var classColor = '';
      var new_val;
      if (current_val == 1) {
        classColor = 'status-green';
        new_val = 'Ok';
      } else if (current_val == 2) {
        classColor = 'status-red';
        new_val = 'Revisar';
      }

      var id_dato = $(this).attr('data-id-movimiento');


      // Encontrar el <tr> -> <td> que ahi pertenece a este movimiento que se esta modificando
      // para hacer el cambio de status visible.
      var $this;
      $('#table_reporteador_recibo_reporte tbody tr').each(function (k, v) {
        if ($(v).attr('data-id-dato') == id_dato) {
          $this = $(v).find('td').eq(9);
          return;
        }
      });

      var envio = {};
      envio.id_dato = id_dato;
      envio.new_val = current_val;
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'change_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#vista-compras-producto-modal').modal('hide');
            $this.removeAttr('class');
            $this.attr('class', 'text-center cursor-pointer cambiar_status ' + classColor);
            $this.html(new_val);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //--------------------- REPORTE RECIBO STATUS -------------------
    //***************************************************************

    //***************************************************************
    //------------------------- VER RECIBO --------------------------
    //***************************************************************
    $(document).on('click', '.vista_recibo', function () {
      var id_recibo = $(this).parents('tr').attr('data-id-recibo');
      window.open('/recibo/vista/' + id_recibo);
    });
    //***************************************************************
    //------------------------- VER RECIBO --------------------------
    //***************************************************************

    //***************************************************************
    //------------------------ EXPORTAR EXCEL  ----------------------
    //***************************************************************
    $(document).on('click', '.exportar_excel', function () {
      var datos = r_options;
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      datos.filter.start_date = moment(fecha_array[0], "DD-MM-YYYY")._d;
      datos.filter.end_date = moment(fecha_array[1], "DD-MM-YYYY")._d;
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'export_excel_reporte',
        data: JSON.stringify(datos),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: "Reporte generado correctamente!"
            });
            window.location.href = response.message;
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          var resp = xhr.responseText.split("Array");
          resp = JSON.parse(resp[resp.length - 1]);
          window.location.href = resp.message;

        }
      });
    });

    //***************************************************************
    //------------------------ EXPORTAR EXCEL  ----------------------
    //***************************************************************



  });
})
  (jQuery);
