(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

    var auto_open = getUrlVars()['open'];

    if (auto_open == 1) {
      setTimeout(function () {
        $('.nuevo_recibo').click();
        window.history.pushState('recibos', 'Recibo de Dinero', '/recibo');
      }, 300);
    }

    //***************************************************************
    //--------------------- REPORTE BASE RECIBO  --------------------
    //***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'id_recibo'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        usuario: null,
        agente: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_recibo').stickyTableHeaders();
          $('#table_reporteador_recibo').partnersfilter();

          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      r_options.filter.usuario = null;
      r_options.filter.agente = null;
      $('.input_buscador_recibo').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_recibo', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_recibo").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }


    // Filtrado - Usuario
    $(document).on('change', '#filtrado_usuario', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.usuario = $(this).find('option:selected').val();
      autoUpdate.forceUpdate();
    });

    // Filtrado - Agente
    $(document).on('change', '#filtrado_agente', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.agente = $(this).find('option:selected').val();
      autoUpdate.forceUpdate();
    });

    //***************************************************************
    //--------------------- REPORTE BASE RECIBO  --------------------
    //***************************************************************


    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************


    //***************************************************************
    //------------------------ NUEVO RECIBO -------------------------
    //***************************************************************
    var no_tarjeta = false;
    $(document).on('click', '.nuevo_recibo', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Nuevo Recibo',
        ajaxUrl: settings.recibo.render_template + 'recibo.nuevo_recibo',
        modalSize: 'modal-lg',
        modalId: 'nuevo-recibo-modal',
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nuevo_recibo_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });

            var today = moment().format('D/M/YYYY');
            $('#fecha-recibo-container .input-group.date').datepicker({
              format: "dd/mm/yyyy",
              todayBtn: "linked",
              language: "es",
              daysOfWeekDisabled: "0",
              autoclose: true,
              todayHighlight: true,
              startDate: today,
              orientation: "auto",
              container: ".input-group.date"
            });

            $('#buscar_cliente').typeahead({
              order: "asc",
              minlength: 1,
              maxItem: 15,
              hint: true,
              accent: true,
              group: {
                template: "{{group}}"
              },
              maxItemPerGroup: 5,
              backdrop: {
                "background-color": "#fff"
              },
              template: function (query, item) {
                var color_t_clasificacion;
                var tipo_clasificacion = item.tipo_clasificacion;
                var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                switch (tipo_clasificacion) {
                  case 'a':
                    color_t_clasificacion = "success";
                    break;
                  case 'b':
                    color_t_clasificacion = "success";
                    break;
                  case 'c':
                    color_t_clasificacion = "warning";
                    break;
                  case 'd':
                    color_t_clasificacion = "danger";
                    break;
                  case 'e':
                    color_t_clasificacion = "danger";
                    break;
                  case 'p':
                    color_t_clasificacion = "success";
                    credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas" : item.saldo_horas + " hora");
                    break;
                }
                tipo_clasificacion = tipo_clasificacion.toUpperCase();

                if (item.tipo_cliente != 3) {
                  return '<p>' +
                    '<span>{{nombre_cliente}}</span> ' +
                    '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
                    '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                    ' | ' + credito_contado + '</span> </p> ';
                } else {
                  return '<p><span>{{nombre_cliente}}</span> </p> ';
                }
              },
              dynamic: true,
              dropdownFilter: "Todos",
              emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
              source: {
                "Clientes": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.recibo.ruta_lista_clientes + 'complete',
                    path: "data.datos.clientes",
                  }
                },
                "Contactos": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.recibo.ruta_lista_clientes + 'complete',
                    path: "data.datos.contactos",
                  }
                },
                "Proveedores": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.recibo.ruta_lista_clientes + 'complete',
                    path: "data.datos.proveedores",
                  }
                }
              },
              callback: {
                onClickAfter: function (node, a, item) {
                  var color_t_clasificacion;
                  var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                  var tipo_clasificacion = item.tipo_clasificacion;
                  switch (tipo_clasificacion) {
                    case "a":
                      color_t_clasificacion = "success";
                      break;
                    case "b":
                      color_t_clasificacion = "success";
                      break;
                    case "c":
                      color_t_clasificacion = "warning";
                      break;
                    case "d":
                      color_t_clasificacion = "danger";
                      break;
                    case "e":
                      color_t_clasificacion = "danger";
                      break;
                    case "p":
                      color_t_clasificacion = "success";
                      credito_contado =
                        "Saldo: " +
                        (item.saldo_horas != 1
                          ? item.saldo_horas + " horas"
                          : item.saldo_horas + " hora");
                      break;
                  }

                  tipo_clasificacion = tipo_clasificacion.toUpperCase();
                  if (item.tipo_cliente != 3) {
                    $('.quick_info_client').html('<span class="badge badge-' + color_t_clasificacion + '">' +
                      '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                      ' | ' + credito_contado + '</span> </p> ');
                    const id_cliente = item.id_cliente;
                    if (tipo_clasificacion != "P") {
                      prepareEvs(1, {
                        color_t_clasificacion,
                        tipo_clasificacion,
                        credito_contado,
                        id_cliente,
                        settings,
                      });
                    }
                  }
                  var res;
                  //Revisar si el tipo de proceso es liquidacion, de ser el caso hay que buscar los recibos que pertenezcan al cliente
                  $(".recibos_liquidar").html('');
                  if ($("input[name='tipo_proceso']:checked").val() == 4) {
                    $(".recibos_container").removeClass("d-none");
                    envio = JSON.stringify({ id_cliente: item.id_cliente });
                    $(".recibos_liquidar").html(loader);
                    var prom = $.ajax({
                      method: "POST",
                      url: settings.recibo.ruta_consultas + "get_recibos",
                      data: envio
                    });
                    $.when(prom).done(function (data) {
                      var html;
                      var datos = JSON.parse(data);
                      datos = JSON.parse(datos.message);
                      // Mostrar lista de recibos de anticipo del cliente
                      //html = '<div class="row">'
                      html = `<ul class="rslides1 row d-flex justify-content-center col-md-12">`;
                      datos.forEach(function (element) {
                        html += `
                        <li style="list-style-type: none" class="w-100">
                         <label class="btn list-group-item list-group-item-action d-inline-flex">
                           <input class="col-1 align-self-center" type="radio" name="recibo_elegir" data-id-anticipo="` + element.id_recibo + `"
                             data-cantidad-anticipo="` + element.cantidad_anticipo + `" data-cantidad-total="` + element.cantidad + `"
                           >
                           <div class="col-11">
                             <strong>&nbsp;Folio: </strong>R-` + element.id_recibo + ` |
                             <strong>Total: </strong>$` + element.cantidad + ` |
                             <strong>Abonado: </strong>$` + element.cantidad_anticipo + (element.concepto ? `<br/>
                             <strong>&nbsp;Concepto: </strong>` + (element.concepto.split("\n"))[0] : '') + ` |
                             <a target="_blank" href="/recibo/vista/` + element.id_recibo + `">Ver</a>
                           </div>
                         </label>
                         </li>
                         `;
                        // html += `
                        // <li>
                        //   <div class="card col-md-6 btn btn-group">
                        //     <label>
                        //       <input class="align-self-center" type="radio" name="recibo_elegir" data-id-anticipo="` + element.id_recibo + `"
                        //       data-cantidad-anticipo="` + element.cantidad_anticipo + `"
                        //       >
                        //       <div class="card-body">
                        //         <h5 class="card-title"><strong>Folio: </strong>` + element.id_recibo + `</h5>
                        //         <p class="card-text">` + element.concepto + `</p>
                        //       </div>
                        //       <ul class="list-group list-group-flush">
                        //         <li class="list-group-item"><strong>Total: </strong>` + element.cantidad + `</li>
                        //         <li class="list-group-item"><strong>Abonado: </strong>` + element.cantidad_anticipo + `</li>
                        //         <li class="list-group-item"><strong>Total: </strong>` + element.cantidad + `</li>
                        //       </ul>
                        //       <div class="card-body">
                        //         <a target="_blank" href="/recibo/vista/` + element.id_recibo + `">Ver</a>
                        //       </div>
                        //     </label>
                        //   </div>
                        // </li>
                        // `
                        //console.log(element);
                      });
                      // html += '</div>';
                      html += '</ul><div class="navres d-flex justify-content-between col-md-12 row"></div>';
                      $(".recibos_liquidar").html(html);
                      $(".rslides1").responsiveSlides({
                        auto: false,
                        nav: true,
                        navContainer: ".recibos_liquidar",
                        prevText: "Anticipo Anterior",
                        nextText: "Anticipo Siguiente",
                      });
                      $(".prev").addClass("btn btn-outline-secondary col-md-6");
                      $(".next").addClass("btn btn-outline-secondary col-md-6");
                      $(".navres").append($(".prev"));
                      $(".navres").append($(".next"));

                      //$(".recibos_liquidar").append().
                    });
                  }

                  //Bindear el id del cliente al input
                  node.attr('data-id-cliente', item.id_cliente);
                  node.attr('data-email-cliente', item.email);

                },
                onSearch: function (node, a) {
                  if (a !== '') {
                    $('.input_recibo_otro').val('');
                    $('.input_recibo_otro').attr('disabled', 1);
                    $('.container_otro_recibo').css('opacity', 0.5);
                    $(".recibos_liquidar").html('');
                  } else {
                    // Para prevenir errores de sobrescribir o duplicar
                    $('.quick_info_client').html('');
                    node.removeAttr('data-id-cliente');
                    node.removeAttr('data-email-cliente');
                    $('.recibos_container').addClass('d-none');
                    $(".recibos_liquidar").html('');
                  }
                },
                onCancel: function () {
                  $('.input_recibo_otro').removeAttr('disabled');
                  $('.container_otro_recibo').css('opacity', 1);
                }

              }
            });

            $(document).on("change", "input[name='agente_recibo']", function () {
              $(".procesos").removeClass("d-none");
            });

            $(document).on("change", "input[name='tipo_proceso']", function () {
              $('.container_otro_recibo').removeClass("d-none");
              $('input[name="tipo_pago_proceso"][value="2"]').parent().parent().removeClass('d-none');
              $(".recibos_liquidar").html('');
              $("#buscar_cliente").removeAttr("data-id-cliente"); // Evitar errores
              $("#buscar_cliente").removeAttr("data-email-cliente");
              $("#buscar_cliente").val('');
              $(".quick_info_client").html('');
              $('.radio_seleccion_tipo_recibo').prop('checked', false);
              $('.radio_seleccion_tipo_recibo').parent().attr('class', "btn btn-outline-primary col-md-5 cursor-pointer");
              $(".form_recibo").removeClass("d-none");
              $(".div_cantidad").removeClass("d-none");
              $(".div_anticipo").addClass("d-none");
              $(".recibos_container").addClass("d-none");
              $('.tipo_recibo_container').removeClass("d-none");
              $(".label_anticipo").html("Anticipo");
              switch ($("input[name='tipo_proceso']:checked").val()) {
                case "3": // Si es anticipo, cambiar los campos
                  $('.container_otro_recibo').addClass("d-none");
                  var tp = $('.tipo_recibo_container input[value="1"]');
                  tp.prop("checked", true);
                  tp.click();
                  tp.click();
                  $('.tipo_recibo_container').addClass("d-none");
                  $(".div_cantidad").addClass("d-none");
                  $(".div_anticipo").removeClass("d-none");
                  break;
                case "4": // Si el tipo de recibo es "liquidacion":
                  $('.container_otro_recibo').addClass("d-none");
                  $(".div_cantidad").addClass("d-none");
                  $(".div_anticipo").removeClass("d-none");
                  $(".recibos_container").removeClass("d-none");
                  $(".label_anticipo").html('Restante');
              }
              $("input[name='cantidad_total']").val("");
              $("input[name='cantidad_abono']").val("");
              $("input[name='cantidad_total']").removeAttr("disabled");
              $("input[name='cantidad_abono']").removeAttr("disabled");
              $("textarea[name='concepto_recibo']").html("");
            });

            // Al elegir un recibo para liquidar
            $(document).on('change', "input[name='recibo_elegir']:checked", function () {
              //$("textarea[name='concepto_recibo']").html(`Liquidación del recibo R-${$(this).attr("data-id-anticipo")}\n`)
              $("input[name='cantidad_total']").val($(this).attr("data-cantidad-total"));
              $("input[name='cantidad_abono']").val(numeral(parseFloat($(this).attr("data-cantidad-total")) - parseFloat($(this).attr("data-cantidad-anticipo"))).format("0,0.00"));
              $("input[name='cantidad_total']").attr("disabled", "disabled");
              $("input[name='cantidad_abono']").attr("disabled", "disabled");
            });

          }, 400);

        }
      });
    });
    $(document).on('change keyup', '.input_recibo_otro', function () {
      //Resetear el de Cliente y todos sus attr en caso de que se seleccione otro.
      $('#buscar_cliente').val('');
      if ($(this).val().length > 0) {
        $('#buscar_cliente').attr('disabled', 1);
        $('.container_buscador_cliente').css('opacity', 0.5);
        $('#buscar_cliente').removeAttr('data-id-cliente');
      } else {
        $('#buscar_cliente').removeAttr('disabled');
        $('.container_buscador_cliente').css('opacity', 1);
      }
    });
    //***************************************************************
    //------------------------ NUEVO RECIBO -------------------------
    //***************************************************************


    //***************************************************************
    //------------------------ CAPTURAR RECIBO ----------------------
    //***************************************************************
    $(document).on('submit', '#nuevo_recibo_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var datos = $('#nuevo_recibo_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      // Verificar fecha
      if (!$('#fecha-recibo-container .input-group.date').datepicker('getDate')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona una fecha.'
        });
        return false;
      }
      // Verificar cliente
      if (!$("#buscar_cliente").attr('data-id-cliente')) {
        if ($('.input_recibo_otro').val() == '') {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona un cliente.'
          });
          return false;
        }
      }
      // Verificar servicio/piezas
      if (!$("input[name='radio_seleccion_tipo_recibo']:checked").val()) {
        iziToast.error({
          title: "Error",
          message: "Selecciona si es un recibo de servicio o de piezas.",
        });
        return false;
      }
      // Verificar forma de pago
      if (!$("input[name='tipo_pago_proceso']:checked").val()) {
        iziToast.error({
          title: "Error",
          message: "Selecciona la forma de pago.",
        });
        return false;
      }
      // piezas
      if ($('.radio_seleccion_tipo_recibo:checked').val() == 2) {
        datosEnvio.datos = [];
        datosEnvio.tipo_recibo = 2;
        datosEnvio.concepto_recibo = '';
        $('.entity_producto_recibo').each(function () {
          datosEnvio.datos.push({
            cantidad: $(this).find('.entity_cantidad_upc').text(),
            upc: $(this).find('.entity_producto_upc').text(),
            descripcion: $(this).find('.entity_producto').text(),
            serie: $(this).find('.entity_producto_serie').text(),
            costo: 0, // Se queda en 0 porque no es necesario para los recibos de dinero guardar el costo
            venta: $(this).find('.entity_producto_venta').attr('data-venta'),
          });
        });

        if (datosEnvio.datos.length < 1) {
          iziToast.error({
            title: 'Error',
            message: 'Ingresa al menos un producto.'
          });
        }
      } else {
        datosEnvio.tipo_recibo = 1;
      }
      // Verificar si es tipo anticipo/liquidacion, que se coloquen ambas cantidades
      if ($("input[name='tipo_proceso']:checked").val() > 2) {
        if (!(parseFloat(($("input[name='cantidad_total']").val()).replace(",", "")) > 0)) {
          iziToast.error({
            title: "Error",
            message: "Ingrese una cantidad válida.",
          });
          return false;
        }
        if (!(parseFloat(($("input[name='cantidad_abono']").val()).replace(",", "")) >= 0)) {
          iziToast.error({
            title: "Error",
            message: "Ingrese una cantidad válida.",
          });
          return false;
        }
      }
      // datos de anticipo
      datosEnvio.cantidad_anticipo = $('input[name="recibo_elegir"]:checked').attr('data-cantidad-anticipo');
      datosEnvio.id_anticipo = $('input[name="recibo_elegir"]:checked').attr('data-id-anticipo');
      datosEnvio.cantidad_total = String(datosEnvio.cantidad_total).replaceAll(",", "");
      datosEnvio.cantidad_abono = String(datosEnvio.cantidad_abono).replaceAll(",", "");
      datosEnvio.cantidad_saldo = parseFloat(datosEnvio.cantidad_total) - parseFloat(datosEnvio.cantidad_abono)
      // Si es una liquidación o anticipo, agregar leyenda al concepto
      switch ($("input[name='tipo_proceso']:checked").val()) {
        case "3": //anticipo
          //numeral(datosEnvio.cantidad_total).format("0,0.00")
          //numeral(datosEnvio.cantidad_abono).format("0,0.00")
          //numeral(datosEnvio.cantidad_saldo).format("0,0.00")
          datosEnvio.concepto_recibo = "Anticipo de:<br/>" + datosEnvio.concepto_recibo;
          datosEnvio.concepto_recibo += `
              <br />
              <br />
              <br />
              <br />
              <table style="width: 35%;">
                <tbody>
                  <tr>
                    <th align="left" style="width: 20%">
                      Total:
                    </th>
                    <td align="right"  style="width: 30%">
                      $${numeral(datosEnvio.cantidad_total).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
                  <tr>
                    <th align="left" style="width: 20%">
                      Este recibo:
                    </th>
                    <td align="right"  style="width: 30%">
                      $${numeral(datosEnvio.cantidad_abono).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
                  <tr>
                    <th align="left" style="width: 20%">Saldo: </th>
                    <td align="right" style="width: 30%">
                      $${numeral(datosEnvio.cantidad_saldo).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
                </tbody>
              </table>`;
          break;
        case "4": //liquidacion
          const recibo_anticipo = $('input[name="recibo_elegir"]:checked');
          var total = recibo_anticipo.attr("data-cantidad-total");
          var anticipo = recibo_anticipo.attr("data-cantidad-anticipo");
          var este_recibo = parseFloat((total).replace(",", "")) - parseFloat(anticipo.replace(",", ""));
          var saldo = parseFloat((total).replace(",", "")) - parseFloat(anticipo.replace(",", "")) - este_recibo;
          datosEnvio.concepto_recibo += `
            <br />
            <br />
            <br />
            <br />
            Liquidación del recibo R-${recibo_anticipo.attr("data-id-anticipo")}\n
            <table style="width: 40%;">
              <tbody>
                <tr>
                    <th align="left" style="width: 20%">
                      Total:
                    </th>
                    <td align="right"  style="width: 30%">
                      $${numeral(total).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
                  <tr>
                    <th align="left" style="width: 20%">
                      Anticipo:
                    </th>
                    <td align="right"  style="width: 30%">
                      $${numeral(anticipo).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
                  <tr>
                    <th align="left" style="width: 20%">Este recibo: </th>
                    <td align="right" style="width: 30%">
                      $${numeral(este_recibo).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
                  <tr>
                    <th align="left" style="width: 20%">Saldo: </th>
                    <td align="right" style="width: 30%">
                      $${numeral(saldo).format("0,0.00")} &nbsp;&nbsp;
                    </td>
                  </tr>
              </tbody>
            </table>`;
          datosEnvio.cantidad = este_recibo;
          break;
      }
      datosEnvio.cantidad_total = $("input[name='cantidad_total']").val();

      btn.partnersBtnControl('start');

      datosEnvio.id_cliente = $("#buscar_cliente").attr('data-id-cliente');
      if (!$("#buscar_cliente").attr('data-id-cliente')) {
        datosEnvio.tipo_cliente = 2;
      } else {
        datosEnvio.tipo_cliente = 1;
      }
      datosEnvio.otro_cliente = $('.input_recibo_otro').val();
      datosEnvio.fecha_recibo = $('#fecha-recibo-container .input-group.date').datepicker('getDate');
      datosEnvio.tipo_proceso = $('input[name="tipo_proceso"]:checked').val();
      datosEnvio.tipo_pago = $('input[name="tipo_pago_proceso"]:checked').val();
      var agente = $('input[name="agente_recibo"]:checked');
      datosEnvio.agente_recibo = agente.val() > 0 ? agente.val() : agente.parent().attr('value');

      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'capturar_recibo',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var id_recibo = response.message;
            autoUpdate.forceUpdate();
            window.open('/recibo/vista/' + id_recibo);
            $('#nuevo-recibo-modal').modal('hide');

          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText

          });
          btn.partnersBtnControl('end');
        }
      });


    });
    //***************************************************************
    //------------------------ CAPTURAR RECIBO ----------------------
    //***************************************************************

    //***************************************************************
    //------------------------- VER RECIBO --------------------------
    //***************************************************************
    $(document).on('click', '.vista_recibo', function () {
      var id_recibo = $(this).parents('tr').attr('data-id-recibo');
      window.open('/recibo/vista/' + id_recibo);
    });
    //***************************************************************
    //------------------------- VER RECIBO --------------------------
    //***************************************************************


    //***************************************************************
    //------------------------- VER LIQUIDACION ---------------------
    //***************************************************************
    $(document).on('click', '.vista_liquidacion', function () {
      const id_liquidado = $(this).attr("data-id-liquidado");
      const id_anticipo = $(this).attr("data-id-recibo");
      $(this).partnersModal({
        content: loader,
        title: 'Vista Liquidación',
        forceWidth: 43,
        modalId: 'modal-vista-liquidacion'
      });
      var envio = { id_liquidado, id_anticipo };
      var datosEnvio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'get_liquidacion',
        data: datosEnvio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          var anticipo = response.message[0];
          var liquidacion = response.message[1];
          //console.log(liquidacion);
          //console.log(anticipo);
          var fecha = new Date(liquidacion.created_at * 1000).toLocaleString();
          $('#modal-vista-liquidacion .modal-body').html(`
          <div class="card text-center">
              <div class="card-header">
                Liquidado por <a target="_blank" href="/recibo/vista/` + anticipo.id_liquidado + `"> R-${anticipo.id_liquidado}</a>

              </div>
              <ul class="list-group list-group-flush">
                <li class="list-group-item d-flex">
                  <strong class="col-md-8">Cantidad total: </strong>$ ${parseFloat(liquidacion.cantidad).format(2)}
                </li>
                <li class="list-group-item d-flex">
                  <strong class="col-md-8">Primer abono: </strong>$ ${parseFloat(anticipo.cantidad_anticipo).format(2)}
                </li>
                <li class="list-group-item d-flex">
                  <strong class="col-md-8">Segundo abono: </strong>$ ${parseFloat(liquidacion.cantidad - anticipo.cantidad_anticipo).format(2)}
                </li>
              </ul>
              <div class="card-footer text-muted">
                Recibo generado el ${fecha}
              </div>
          </div>
          `);
        }
      });
    });


    //***************************************************************
    //------------------------- VER LIQUIDACION ---------------------
    //***************************************************************


    //***************************************************************
    //------------------------ REENVIAR RECIBO ----------------------
    //***************************************************************

    $(document).on('click', '.reenviar_recibo', (e) => {
      const idCliente = +(e.currentTarget.closest('tr').getAttribute('data-id-cliente'));
      const idRecibo = +(e.currentTarget.closest('tr').getAttribute('data-id-recibo'));
      // eslint-disable-next-line no-undef
      modalCorreo(
        idCliente,
        settings,
        idRecibo,
        (emailsToSend, datos, body, hideModal) => {
          const data = {
            to: emailsToSend,
            id_recibo: datos,
            body,
          };
          $.ajax({
            type: 'POST',
            url: `${settings.recibo.ruta_consultas}enviar_recibo_correo`,
            data: JSON.stringify(data),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success(response) {
              if (response.status === 'success') {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: 'Listo',
                  message: 'Correos enviados',
                });
                hideModal(true);
              } else if (response.status === 'error') {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: 'Error',
                  message: response.message,
                });
                hideModal(false);
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: 'Ocurrio un error: ',
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
              hideModal(false);
            },
          });
        },
      );
    });
    //***************************************************************
    //------------------------ REENVIAR RECIBO ----------------------
    //***************************************************************


    //***************************************************************
    //------------------------ REENVIAR RECIBO ----------------------
    //***************************************************************


    //****************************************************************
    // ----------------------- Ligar factura --------------------
    //****************************************************************

    $(document).on("click", ".servicio_facturado", function () {
      const id_recibo = $(this).parent().attr("data-id-recibo");
      const folio_servicio = "R-" + id_recibo;
      const nombre_cliente = $(this).parent().attr("data-nombre-cliente");
      $("#modal-pagado-servicios").modal("hide");
      let content = "";
      content +=
        `${'<div class="row">' +
        '<div class="col-md-2"><p class="font-weight-bold">Folio Servicio:</p></div>' +
        '<div class="col-md-2">'
        }${folio_servicio}</div>` +
        '<div class="col-md-1"><p class="font-weight-bold">Cliente:</p></div>' +
        `<div class="col-md-3">${nombre_cliente}</div>` +
        "</div><hr>" +
        '<div class="row">' +
        '<div class="col-md-2">' +
        '<p class="font-weight-bold">Factura:</p>' +
        "</div>" +
        '<div class="col-md-2">' +
        '<input type="text" class="form-control numero_factura">' +
        "</div>" +
        "</div><hr>" +
        '<div class="row">' +
        '<div class="col-md-4"><p class="font-weight-bold">La factura está a nombre de:</p></div>' +
        '<div class="col-md-8"><input type="text" class="nombre_cliente_factura form-control" readonly value="..."></div>' +
        "</div>" +
        '<div class="row">' +
        '<div class="col-md-12 my-3">' +
        `<button type="button" class="float-right capturar_servicio_facturado btn btn-success" data-folio-servicio="${folio_servicio}" data-id-servicio="${id_recibo}" role="button" style="display: none;">Guardar</button>` +
        "</div>" +
        "</div>";

      setTimeout(function () {
        $(this).partnersModal({
          title: "Facturar",
          modalSize: "modal-lg",
          modalId: "facturar-servicio-modal",
          content,
          noFooter: true,
        });
      }, 400);
    });

    $(document).on("blur", ".numero_factura", () => {
      const numero_factura = $(".numero_factura").val();
      const id_recibo = $(this).attr("data-id-recibo");
      if (
        $.trim(numero_factura) == "" ||
        !$.trim(numero_factura) ||
        isNaN(numero_factura)
      ) {
        iziToast.error({
          title: "Error",
          message: "Ingresa un folio de factura correcto.",
        });
        return false;
      }
      let envio = {};
      envio.numero_factura = numero_factura;
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.recibo.ruta_sys_tools}get_datos_cliente_contpaq`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            const datos_c = JSON.parse(response.message);
            $(".nombre_cliente_factura").val(datos_c.nombre);
            $(".nombre_cliente_factura").attr(
              "data-codigo-cliente",
              datos_c.codigo_cliente
            );
            $(".nombre_cliente_factura").attr("data-rfc-cliente", datos_c.rfc);
            $(".nombre_cliente_factura").attr("data-id-recibo", id_recibo);
            $(".capturar_servicio_facturado").show();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
            $(".nombre_cliente_factura").val("");
            $(".capturar_servicio_facturado").hide();
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on("click", ".capturar_servicio_facturado", function () {
      let envio = {};
      const btn = $(this);
      btn.partnersBtnControl("start");
      envio.codigo_cliente = $(".nombre_cliente_factura").attr(
        "data-codigo-cliente"
      );
      envio.id_recibo = $(this).attr("data-id-recibo");
      envio.rfc_cliente = $(".nombre_cliente_factura").attr("data-rfc-cliente");
      envio.folio_factura = $(".numero_factura").val();
      envio.folio_servicio = $(this).attr("data-id-servicio");
      envio.f_servicio = $(this).attr("data-folio-servicio");
      envio = JSON.stringify(envio);
      $.ajax({
        type: "POST",
        url: `${settings.recibo.ruta_consultas}marcar_facturado`,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            $("#facturar-servicio-modal").modal("hide");
            autoUpdate.forceUpdate();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
            btn.partnersBtnControl("end");
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });





    //* **************************************************************
    // --------------------- Recibos VER FACTURA  ------------------
    //* **************************************************************
    $(document).on("click", ".ver_factura", function () {
      const id_factura = $(this).text();
      $(this).partnersModal({
        title: `Factura ${id_factura}`,
        modalId: "vista-factura",
        forceWidth: 90,
        content: loader,
      });
      $.ajax({
        type: "POST",
        url: `${settings.recibo.ruta_sys_tools}get_full_factura`,
        data: JSON.stringify(id_factura),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success(response) {
          if (response.status == "success") {
            if (response.message == "not_on_server") {
              var content =
                "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content =
                `${"<div>" + '<iframe src="/system/tools/vista_factura?factura='
                }${response.message}" width="100%;" height="600px;"></iframe>` +
                "</div>";
            }
            $("#vista-factura .modal-body").html(content);
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // --------------------- Recibos VER FACTURA  ------------------
    //* **************************************************************

    //***************************************************************
    //------------------------ SELECT TIPO RECIBO -------------------
    //***************************************************************
    $(document).on('keypress', ':input:not(textarea)', function (e) {
      return e.keyCode != 13;
    });

    $(document).on('change', '.radio_seleccion_tipo_recibo', function () {
      if ($(this).val() == 1) {
        $('.hidden_on_piezas').show();
        $('.show_on_piezas').hide();
        $('#nuevo-recibo-modal .modal-dialog').removeAttr('style');
        $('input[name="cantidad_recibo"]').removeAttr('readonly');
      } else {
        $('#nuevo-recibo-modal .modal-dialog').attr('style', 'max-width:90%');
        $('.show_on_piezas').show();
        $('.hidden_on_piezas').hide();
        $('input[name="cantidad_recibo"]').attr('readonly', true);
      }
    });

    $(document).on('click', '.agregar_nuevo_producto', function () {
      var cantidad = $('.cantidad_recibo').val();
      var upc = $('.upc_recibo').val();
      var producto = $('.producto_recibo').val();
      var serie = $('.serie_recibo').val();
      var costo = $('.costo_recibo').val();
      var venta = $('.venta_recibo').val();
      var invalid = false;
      $('.upc_recibo, .producto_recibo, .cantidad_recibo, .venta_recibo').validate(function (valid) {
        if (!valid) invalid = true;
      });

      if (!$.trim(cantidad).length) {
        iziToast.error({ title: 'Error', message: 'Ingresa una cantidad' });
        return false;
      }

      if (!$.trim(upc).length) {
        iziToast.error({ title: 'Error', message: 'Ingresa el UPC del producto' });
        return false;
      }
      if (!$.trim(producto).length) {
        iziToast.error({ title: 'Error', message: 'Ingresa el nombre del producto' });
        return false;
      }

      if (!$.trim(venta).length) {
        iziToast.error({ title: 'Error', message: 'Ingresa el precio del producto' });
        return false;
      }
      if (invalid) return false;

      var tr = $('<tr class="entity_producto_recibo">' +
        '<td class="entity_cantidad_upc">' + cantidad + '</td>' +
        '<td class="entity_producto_upc">' + upc + '</td>' +
        '<td class="entity_producto">' + producto + '</td>' +
        '<td class="entity_producto_serie">' + serie + '</td>' +
        '<td class="text-right entity_producto_venta" data-cantidad="' + cantidad + '" data-venta="' + venta + '" data-costo="' + costo + '">' + numeral(venta).format("0,0.00") + '</td>' +
        '<td class="text-right entity_producto_subtotal" data-subtotal="' + (cantidad * venta) + '">' + numeral(cantidad * venta).format("0,0.00") + '</td>' +
        '<td class="eliminar_entity_recibo text-center text-danger cursor-pointer">Eliminar</td>' +
        '</tr>');
      $('.table-productos-recibo tbody').append(tr);

      $('.cantidad_recibo').val('');
      $('.upc_recibo').val('');
      $('.producto_recibo').val('');
      $('.serie_recibo').val('');
      $('.costo_recibo').val('');
      $('.venta_recibo').val('');

      sumar_total_entities_recibo();
      $('.cantidad_recibo').focus();
      // Sumar a la cantidad total el total del recibo
      if ($('input[name="tipo_proceso"]:checked').val() > 3) {
        var total = $('.table-productos-recibo .total_recibo').html();
        $('input[name="cantidad_total"]').val(total);
        var anticipo = $('input[name="recibo_elegir"]:checked').attr("data-cantidad-anticipo");
        $('input[name="cantidad_abono"]').val(
          numeral(
            parseFloat(total.replaceAll(',', '')) - parseFloat(anticipo.replaceAll(',', ''))
          ).format("0,0.00")
        );

      }

    });

    $(document).on('click', '.eliminar_entity_recibo', function () {
      var otros = $(this).parents('tr').siblings('tr');
      $(this).parents('tr').remove();
      sumar_total_entities_recibo();

      if ($('input[name="tipo_proceso"]:checked').val() > 3) {
        var total = $('.table-productos-recibo .total_recibo').html();
        $('input[name="cantidad_total"]').val(total);
        var anticipo = $('input[name="recibo_elegir"]:checked').attr("data-cantidad-anticipo");
        $('input[name="cantidad_abono"]').val(numeral(parseFloat(total.replaceAll(',', '')) - parseFloat(anticipo.replaceAll(',', ''))).format("0,0.00"));
        if (otros.length == 0) {
          total = $('input[name="recibo_elegir"]:checked').attr("data-cantidad-total");
          $('input[name="cantidad_total"]').val(total);
          $('input[name="cantidad_abono"]').val(numeral(parseFloat(total.replaceAll(',', '')) - parseFloat(anticipo.replaceAll(',', ''))).format("0,0.00"));

        }
      }

    });

    $(document).on('keyup', '.upc_recibo', function (e) {
      var val = $(this).val();
      if (e.keyCode == 13) {
        get_product_info(val, 1, '.producto_recibo', '.serie_recibo');
      } else {
        delay(function () {
          get_product_info(val, 1, '.producto_recibo', '.serie_recibo');
        }, 500);
      }
    });

    $(document).on('keyup', '.serie_recibo', function (e) {
      var val = $(this).val();
      if (e.keyCode == 13) {
        get_product_info(val, 2, '.costo_recibo', '.venta_recibo');
      } else {
        delay(function () {
          get_product_info(val, 2, '.costo_recibo', '.venta_recibo');
        }, 500);
      }

    });

    /**
     *
     * @param val el actual valor para hacer la consulta
     * @param type el tipo de consulta, ya sea para traer el nombre o el costo del producto
     * @param input_to_return el input en el cual se escribirá el resultado
     * @param input_to_jump al input que dara focus una vez coloque el resultado en input_to_return
     */
    function get_product_info(val, type, input_to_return, input_to_jump) {
      if (!$.trim(val).length) return false;
      var envio = {};
      envio.val = val;
      envio.type = type;
      envio = JSON.stringify(envio);
      var dot = '.';
      var dots = setInterval(function () {
        $(input_to_return).val(dot);
        dot += '.';
        if (dot.length > 5) dot = '.';
      }, 200);

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_sys_tools + 'load_producto_info_mercancia',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $(input_to_return).val(response.message);
            clearInterval(dots);
            $(input_to_jump).focus();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message,
              timeout: 2000
            });
            clearInterval(dots);
            $(input_to_return).val('');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
          clearInterval(dots);
          $(input_to_return).val('');
        }
      });
    }

    function sumar_total_entities_recibo() {
      var total = 0;
      $('.entity_producto_subtotal').each(function () {
        total += (parseFloat($(this).attr('data-subtotal')));
      });
      $('input[name="cantidad_recibo"]').val(parseFloat(total).format(2));
      $('.table-productos-recibo .total_recibo').html(parseFloat(total).format(2));
    }

    //***************************************************************
    //------------------------ SELECT TIPO RECIBO -------------------
    //***************************************************************


    //***************************************************************
    //------------------------ STATUS PROCESADO ---------------------
    //***************************************************************
    $(document).on('click', '.status_procesado', function () {
      var id_recibo = $(this).parents('tr').attr('data-id-recibo');
      var nombre_cliente = $(this).parents('tr').attr('data-nombre-cliente');
      var cantidad = $(this).parents('tr').attr('data-cantidad');
      var template = '<div class="row">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning recibo_no_pagado w-100" data-id-recibo="' + id_recibo + '" role="button">No</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-success recibo_pagado w-100" data-nombre-cliente="' + nombre_cliente + '" data-cantidad="' + cantidad + '" data-id-recibo="' + id_recibo + '" role="button">Efectivo</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-info recibo_cheque w-100" data-id-recibo="' + id_recibo + '" role="button">Cheque</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-primary recibo_tarjeta w-100" data-id-recibo="' + id_recibo + '" role="button">Tarjeta</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning recibo_otro w-100" data-id-recibo="' + id_recibo + '" role="button">Otro</button></div>' +
        '</div>';


      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 43,
        modalId: 'modal-pagado-recibo',
        noFooter: true
      });
    });

    $(document).on('click', '.recibo_no_pagado', function () {
      var id_recibo = $(this).attr('data-id-recibo');
      var clicked_td = $('tr[data-id-recibo="' + id_recibo + '"] .status_procesado');
      $('#modal-pagado-recibo .modal-body').html(loader);
      var envio = {};
      envio.new_val = 0;
      envio.id_recibo = id_recibo;
      envio.col = 'procesado';
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            $('#modal-pagado-recibo').modal('hide');
            clicked_td.removeClass('status-green');
            clicked_td.addClass('status-red');
            clicked_td.html('No');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.recibo_pagado', function () {
      var id_recibo = $(this).attr('data-id-recibo') ? $(this).attr('data-id-recibo') : $(this).parents('tr').attr('data-id-recibo');
      var nombre_cliente = $(this).attr('data-nombre-cliente') ? $(this).attr('data-nombre-cliente') : $(this).parents('tr').attr('data-nombre-cliente');
      var cantidad = $(this).attr('data-cantidad') ? $(this).attr('data-cantidad') : $(this).parents('tr').attr('data-cantidad');
      $('#modal-pagado-recibo').modal('hide');
      var template = '<form autocomplete="off" id="form_pagado_caja" data-id-recibo="' + id_recibo + '"><div class="row">' +
        '<div class="col-md-5"><div class="form-group required"><label class="col-form-label">Concepto</label> <div> <input type="text" class="form-control valid_me" value="Registro Pago de Recibo: R-' + id_recibo + ' | ' + nombre_cliente + '" name="concepto_capturar_caja" data-validation="required" data-validation-error-msg="Ingresa un concepto"> </div> </div></div>' +
        '<div class="col-md-5"><div class="form-group required"> <label class="col-form-label">Cantidad</label> <div> <input type="text" class="form-control valid_me text-right"  value="' + numeral(cantidad).format("0,0.00") + '" data-validation-min-number="' + cantidad + '" name="cantidad_capturar_caja" data-validation="number min_number" data-validation-allowing="float" data-validation-error-msg="Ingresa una cantidad correcta y mayor a: ' + numeral(cantidad).format("0,0.00") + '" data-sanitize="numberFormat" data-sanitize-number-format="0,0.00"> </div> </div></div>' +
        '<div class="col-md-2"><label>Guardar en caja</label><button type="submit" class="btn btn-success" role="button">Guardar</button></div>' +
        '</div></form>';

      $(this).partnersModal({
        content: template,
        title: 'Capturar en caja',
        forceWidth: 65,
        modalId: 'modal-pagado-caja',
        noFooter: true
      });
      setTimeout(function () {
        $.validate({
          form: '#form_pagado_caja',
          errorMessageClass: 'invalid-feedback',
          inputParentClassOnError: 'text-danger',
          inputParentClassOnSuccess: 'text-success',
          errorElementClass: 'is-invalid'
        });

        $.formUtils.addValidator({
          name: 'min_number',
          validatorFunction: function (value, $el) {
            return numeral(value).value() >= numeral($($el).attr('data-validation-min-number')).value();
          },
          errorMessage: '',
          errorMessageKey: ''
        });
      }, 400);
    });

    $(document).on('submit', '#form_pagado_caja', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var id_recibo = $(this).attr('data-id-recibo');
      btn.partnersBtnControl('start');
      var datos = $('#form_pagado_caja').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      $('#modal-pagado-caja .modal-body').html(loader);
      var clicked_td = $('tr[data-id-recibo="' + id_recibo + '"] .status_procesado');
      datosEnvio.id_recibo = id_recibo;
      datosEnvio.new_val = 1;
      datosEnvio.col = 'procesado';
      datosEnvio.obs = 'Se capturó en caja bajo el concepto de: ' + datosEnvio.concepto_capturar_caja;
      datosEnvio.capturar_caja = 1;
      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
            $('#modal-pagado-caja').modal('hide');
            clicked_td.addClass('status-green');
            clicked_td.html('Efectivo');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.recibo_cheque', function () {
      var id_recibo = $(this).attr('data-id-recibo');
      var clicked_td = $('tr[data-id-recibo="' + id_recibo + '"] .status_procesado');
      $('#modal-pagado-recibo').modal('hide');

      var new_val = 2;
      var envio = {};
      envio.id_recibo = id_recibo;
      envio.new_val = new_val;
      envio.col = 'procesado';
      swal({
        title: 'Cheque',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes especificar el cheque!');
            } else {
              envio.obs = 'Se marcó como procesado con el cheque: ' + reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.recibo.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Cheque');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });

    });

    $(document).on('click', '.recibo_tarjeta', function () {
      var id_recibo = $(this).attr('data-id-recibo');
      var clicked_td = $('tr[data-id-recibo="' + id_recibo + '"] .status_procesado');
      $('#modal-pagado-recibo').modal('hide');

      var new_val = 3;
      var envio = {};
      envio.id_recibo = id_recibo;
      envio.new_val = new_val;
      envio.col = 'procesado';
      swal({
        title: 'Tarjeta',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes especificar la tarjeta!');
            } else {
              envio.obs = 'Se marcó como procesado con la tarjeta: ' + reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.recibo.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Tarjeta');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });

    });

    $(document).on('click', '.recibo_otro', function () {
      var id_recibo = $(this).attr('data-id-recibo');
      var clicked_td = $('tr[data-id-recibo="' + id_recibo + '"] .status_procesado');
      $('#modal-pagado-recibo').modal('hide');

      var new_val = 4;
      var envio = {};
      envio.id_recibo = id_recibo;
      envio.new_val = new_val;
      envio.col = 'procesado';
      swal({
        title: 'Otro',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes especificar otro método de pago!');
            } else {
              envio.obs = 'Se marcó como procesado con otro: ' + reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.recibo.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Otro');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });

    });


    // Pago de recibo por cobrar con tarjeta
    $(document).on('click', '.recibo_pagado_tarjeta', function () {
      var id_recibo = $(this).attr('data-id-recibo') ? $(this).attr('data-id-recibo') : $(this).parents('tr').attr('data-id-recibo');
      var nombre_cliente = $(this).attr('data-nombre-cliente') ? $(this).attr('data-nombre-cliente') : $(this).parents('tr').attr('data-nombre-cliente');
      var cantidad = $(this).attr('data-cantidad') ? $(this).attr('data-cantidad') : $(this).parents('tr').attr('data-cantidad');
      $('#modal-pagado-recibo').modal('hide');
      var template = `
      <div class="d-flex justify-content-center">
        <form autocomplete="off" id="form_pagado_tarjeta" data-id-recibo="${id_recibo}">
          <div class="row d-flex">
            <button type="submit" class="btn btn-outline-success">Marcar como pagado</button>
          </div>
        </form>
      </div>`;

      $(this).partnersModal({
        content: template,
        title: 'Cobrar recibo',
        forceWidth: 20,
        modalId: 'modal-pagado-tarjeta',
        noFooter: true
      });
      setTimeout(function () {
        $.validate({
          form: '#form_pagado_tarjeta',
          errorMessageClass: 'invalid-feedback',
          inputParentClassOnError: 'text-danger',
          inputParentClassOnSuccess: 'text-success',
          errorElementClass: 'is-invalid'
        });

        $.formUtils.addValidator({
          name: 'min_number',
          validatorFunction: function (value, $el) {
            return numeral(value).value() >= numeral($($el).attr('data-validation-min-number')).value();
          },
          errorMessage: '',
          errorMessageKey: ''
        });
      }, 400);
    });
    $(document).on('submit', '#form_pagado_tarjeta', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var id_recibo = $(this).attr('data-id-recibo');
      btn.partnersBtnControl('start');
      var datosEnvio = {};

      $('#modal-pagado-tarjeta .modal-body').html(loader);
      var clicked_td = $('tr[data-id-recibo="' + id_recibo + '"] .status_procesado');
      datosEnvio.id_recibo = id_recibo;
      datosEnvio.new_val = 5;
      datosEnvio.col = 'procesado';
      datosEnvio.obs = 'Se marcó como pagado el recibo: R-' + datosEnvio.id_recibo + ' con tarjeta';
      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
            $('#modal-pagado-tarjeta').modal('hide');
            clicked_td.addClass('status-red');
            clicked_td.html('Por facturar');
            btn.partnersBtnControl('end');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
          btn.partnersBtnControl('end');
        }
      });
    });


    //***************************************************************
    //------------------------ STATUS PROCESADO ---------------------
    //***************************************************************


    //***************************************************************
    //------------------------- STATUS REPORTE  ---------------------
    //***************************************************************
    $(document).on('click', '.status_reporte', function () {
      var id_recibo = $(this).parents('tr').attr('data-id-recibo');
      var reporte = ($(this).parents('tr').attr('data-reporte') == 1) ? 0 : 1;
      var envio = {};
      envio.id_recibo = id_recibo;
      envio.new_val = reporte;
      envio.col = 'reporte';
      envio = JSON.stringify(envio);
      if (reporte == 1) {
        $(this).removeClass('status-red');
        $(this).addClass('status-green');
        $(this).html('Si');
      } else {
        $(this).removeClass('status-green');
        $(this).addClass('status-red');
        $(this).html('No');
      }

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
    //***************************************************************
    //------------------------- STATUS REPORTE  ---------------------
    //***************************************************************


    //***************************************************************
    //----------------------- STATUS OBSERVACIONES ------------------
    //***************************************************************
    $(document).on('click', '.recibo-observaciones', function () {
      var id_recibo = $(this).parents('tr').attr('data-id-recibo');
      $(this).partnersObs(
        {
          modalId: 'modal-recibo-observaciones',
          ajaxUrl: settings.recibo.ruta_sys_tools + 'load_obs',
          index: 'id_recibo',
          id_index: id_recibo,
          tabla: 'partners_recibo',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );

    });
    //***************************************************************
    //----------------------- STATUS OBSERVACIONES ------------------
    //***************************************************************


    //***************************************************************
    //------------------------ CANCELAR RECIBO ----------------------
    //***************************************************************
    $(document).on('click', '.cancelar_recibo', function () {
      var id_recibo = $(this).parents('tr').attr('data-id-recibo');
      var cantidad = $(this).parents('tr').attr('data-cantidad');
      swal({
        title: "Estás Seguro?",
        html: "Deseas cancelar el recibo: " + id_recibo + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, cancelar!",
        cancelButtonText: "No!",
        onOpen: function () {
          fixBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
          restoreBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function () {
            swal({
              title: 'Motivo de cancelación',
              input: 'textarea',
              showCancelButton: true,
              confirmButtonText: 'Guardar',
              cancelButtonColor: '#DD6B55',
              cancelButtonText: 'Regresar',
              confirmButtonClass: 'btn btn-success',
              cancelButtonClass: 'btn btn-danger',
              animation: false,
              customClass: 'animated fadeInDownCustom',
              showLoaderOnConfirm: true,
              reverseButtons: true,
              onClose: function () {
                $('body').removeAttr('style');
              },
              preConfirm: function (reason) {
                return new Promise(function (resolve, reject) {
                  if (!reason) {
                    reject('Debes ingresar un motivo!');
                  } else {
                    var envio = {};
                    envio.id_recibo = id_recibo;
                    envio.obs = reason;
                    envio = JSON.stringify(envio);
                    $.ajax({
                      type: 'POST',
                      url: settings.recibo.ruta_consultas + 'cancelar_recibo',
                      data: envio,
                      contentType: "application/json; charset=utf-8",
                      dataType: "json",
                      success: function (response) {
                        if (response.status == 'success') {
                          autoUpdate.forceUpdate();
                          setTimeout(function () {
                            undo_recibo_cancelled(id_recibo, cantidad);
                            swal.close();
                          }, 2000);
                          resolve()
                        } else if (response.status == 'error') {
                          iziToast.error({
                            title: "Error",
                            message: response.message
                          });
                        }
                      },
                      error: function (xhr) {
                        iziToast.error({
                          title: "Ocurrio un error: ",
                          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                      }
                    });
                  }
                })
              },
              allowOutsideClick: false
            }).then(function (a) {
              if (!a.dismiss) {
                swal("Cancelado!", "El recibo de dinero se ha cancelado correctamente.", "success");
                autoUpdate.forceUpdate();
              }
            });
          });
        },
        allowOutsideClick: false
      });
    });

    function undo_recibo_cancelled(id_recibo, cantidad) {
      iziToast.show({
        title: "Recibo " + id_recibo,
        message: ' ha sido cancelado.',
        position: 'bottomLeft',
        timeout: 10000,
        color: 'dark',
        progressBarColor: 'rgb(0, 255, 184)',
        icon: 'fa fa-ban',
        buttons: [
          ['<button data-id-recibo="' + id_recibo + '" data-cantidad="' + cantidad + '" class="recibo_undo_cancelled">Deshacer</button>', function (instance, toast) {
            instance.hide({
              transitionOut: 'fadeOutUp',
            }, toast, 'close');
          }]
        ],
      });
    }

    $(document).on('click', '.recibo_undo_cancelled', function () {
      var id_recibo = $(this).attr('data-id-recibo');
      var datos = {};
      datos.id_recibo = id_recibo;
      datos.cantidad = $(this).attr('data-cantidad');
      datos = JSON.stringify(datos);
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'reactivate_recibo',
        data: datos,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Recibo " + id_recibo,
              message: ' ha sido traido de vuelta a la vida!',
              icon: 'fa fa-usd'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
    //***************************************************************
    //------------------------ CANCELAR RECIBO ----------------------
    //***************************************************************


    //***************************************************************
    //------------------------ EXPORTAR EXCEL  ----------------------
    //***************************************************************
    $(document).on('click', '.exportar_excel', function () {
      var datos = r_options;
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      datos.filter.start_date = moment(fecha_array[0], "DD-MM-YYYY")._d;
      datos.filter.end_date = moment(fecha_array[1], "DD-MM-YYYY")._d;
      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_consultas + 'export_excel',
        data: JSON.stringify(datos),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: "Reporte generado correctamente!"
            });
            window.location.href = response.message;
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    //***************************************************************
    //------------------------ EXPORTAR EXCEL  ----------------------
    //***************************************************************


    //***************************************************************
    //------------------------ RECIBO INFORM ERRORS -----------------
    //***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.recibo.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
    //***************************************************************
    //------------------------ RECIBO INFORM ERRORS -----------------
    //***************************************************************

  });
})
  (jQuery);
