(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {


//***************************************************************
//-------------------- REPORTE BASE PREPAGO ---------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'DESC',
        sort_by: 'id_orden'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.prepago.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);

          $('#table_reporteador_prepago').partnersfilter({
            table: '#table_reporteador_prepago',
            sumatory: true,
            sumatory_cols: ["col-total"]
          });


          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

//***************************************************************
//-------------------- REPORTE BASE PREPAGO ---------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//----------------------- STATUS OBSERVACIONES ------------------
//***************************************************************
    $(document).on('click', '.prepago-observaciones', function () {
      var id_orden = $(this).parents('tr').attr('data-id-orden');
      $(this).partnersObs(
        {
          modalId: 'modal-prepago-observaciones',
          ajaxUrl: settings.prepago.ruta_sys_tools + 'load_obs',
          index: 'id_orden',
          id_index: id_orden,
          tabla: 'partners_prepago_ordenes',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );

    });
//***************************************************************
//----------------------- STATUS OBSERVACIONES ------------------
//***************************************************************


//***************************************************************
//---------------------- CANCELAR ORDEN PREPAGO -----------------
//***************************************************************
    $(document).on('click', '.cancelar-orden-prepago', function () {
      var id_orden = $(this).parents('tr').attr('data-id-orden');
      var id_pendiente = $(this).parents('tr').attr('data-id-pendiente');

      swal({
        title: "Estás Seguro?",
        html: "Deseas cancelar la orden: P-" + id_orden + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, cancelar!",
        cancelButtonText: "No!",
        onOpen: function () {
          fixBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
          restoreBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function () {
            swal({
              title: 'Motivo de cancelación',
              input: 'textarea',
              showCancelButton: true,
              confirmButtonText: 'Guardar',
              cancelButtonColor: '#DD6B55',
              cancelButtonText: 'Regresar',
              confirmButtonClass: 'btn btn-success',
              cancelButtonClass: 'btn btn-danger',
              animation: false,
              customClass: 'animated fadeInDownCustom',
              showLoaderOnConfirm: true,
              reverseButtons: true,
              onClose: function () {
                $('body').removeAttr('style');
              },
              preConfirm: function (reason) {
                return new Promise(function (resolve, reject) {
                  if (!reason) {
                    reject('Debes ingresar un motivo!');
                  } else {
                    var envio = {};
                    envio.id_orden = id_orden;
                    envio.id_pendiente = id_pendiente;
                    envio.obs = reason;
                    envio = JSON.stringify(envio);
                    $.ajax({
                      type: 'POST',
                      url: settings.prepago.ruta_consultas + 'cancelar_orden',
                      data: envio,
                      contentType: "application/json; charset=utf-8",
                      dataType: "json",
                      success: function (response) {
                        if (response.status == 'success') {
                          autoUpdate.forceUpdate();
                          resolve();
                        } else if (response.status == 'error') {
                          iziToast.error({
                            title: "Error",
                            message: response.message
                          });
                        }
                      },
                      error: function (xhr) {
                        iziToast.error({
                          title: "Ocurrio un error: ",
                          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                      }
                    });
                  }
                })
              },
              allowOutsideClick: false
            }).then(function (a) {
              if (!a.dismiss) {
                swal({
                  title: "Cancelado!",
                  text: "La orden ha sido cancelada correctamente.",
                  type: "success",
                  timer: 2000
                });
              }
            });
          });
        },
        allowOutsideClick: false
      });
    });
//***************************************************************
//---------------------- CANCELAR ORDEN PREPAGO -----------------
//***************************************************************


//***************************************************************
//-------------------- PAGAR ORDEN PREPAGO ----------------------
//***************************************************************
    $(document).on('click', '.status-pagado', function () {
      var id_orden = $(this).parents('tr').attr('data-id-orden');
      var id_pendiente = $(this).parents('tr').attr('data-id-pendiente');

      swal({
        title: 'Motivo',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              var envio = {};
              envio.id_orden = id_orden;
              envio.id_pendiente = id_pendiente;
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.prepago.ruta_consultas + 'pagar_orden',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    autoUpdate.forceUpdate();
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal({
            title: "Pagado!",
            text: "La orden ha sido marcada como pagada correctamente.",
            type: "success",
            timer: 2000
          });
        }
      });

    });
//***************************************************************
//-------------------- PAGAR ORDEN PREPAGO ----------------------
//***************************************************************


//***************************************************************
//------------------ PAGAR ORDEN PREPAGO SIMPLE -----------------
//***************************************************************
    $(document).on('click', '.status-pagado-simple', function () {
      var id_orden = $(this).parents('tr').attr('data-id-orden');
      swal({
        title: 'Motivo',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              var envio = {};
              envio.id_orden = id_orden;
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.prepago.ruta_consultas + 'pagar_orden_simple',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    autoUpdate.forceUpdate();
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal({
            title: "Pagado!",
            text: "La orden ha sido marcada como pagada correctamente.",
            type: "success",
            timer: 2000
          });
        }
      });

    });
//***************************************************************
//------------------ PAGAR ORDEN PREPAGO SIMPLE -----------------
//***************************************************************

//***************************************************************
//---------------- VISTA USER PAGO ORDEN PREPAGO ----------------
//***************************************************************
    $(document).on('mouseenter', '.vista_user_pagado', function () {
      $(this).html($(this).attr('data-pagado-por'));
    });

    $(document).on('mouseleave', '.vista_user_pagado', function () {
      $(this).html('Si');
    });
//***************************************************************
//---------------- VISTA USER PAGO ORDEN PREPAGO ----------------
//***************************************************************


  });
})
(jQuery);
