jQuery(document).ready(function () {
  const settings = Drupal.settings;
  reporte_base();
  if (getUrlVars()["crear"]) {
    setTimeout(function () {
      jQuery(".nueva_poliza").click();
    }, 1000);

    window.history.pushState("polizas", "Polizas", "/polizas");
  }
  const formatter = new Intl.NumberFormat('es-US', {
    style: 'currency',
    currency: 'USD',
  });
  var loader =
    '<div class="sk-cube-grid"> ' +
    '<div class="sk-cube sk-cube1"></div> ' +
    '<div class="sk-cube sk-cube2"></div> ' +
    '<div class="sk-cube sk-cube3"></div> ' +
    '<div class="sk-cube sk-cube4"></div> ' +
    '<div class="sk-cube sk-cube5"></div> ' +
    '<div class="sk-cube sk-cube6"></div> ' +
    '<div class="sk-cube sk-cube7"></div> ' +
    '<div class="sk-cube sk-cube8"></div> ' +
    '<div class="sk-cube sk-cube9"></div> </div>';

  // Auto Update
  var autoUpdate = new AutoUpdate({
    toUpdate: function () {
      reporte_base();
    },
    interval: 86400,
    iddle_after: 120,
  });

  // Reporte base Options
  var r_options = {
    pagination: {
      page: 1,
    },
    sort: {
      order: "DESC",
      sort_by: "CFECHA",
    },
    automatic_update: 1,
    updating: 0,
    filter: {
      search_bar: null,
      start_date: null,
      end_date: null,
      usuario: null,
      tipo_poliza: null,
      filtro_inactivos: null,
    },
  };
  // Reporte base
  function reporte_base() {

    jQuery('#reporteador').html(loader);
    jQuery.ajax({
      type: "POST",
      url: settings.polizas.ruta_consultas + "reporte_base",
      data: JSON.stringify(r_options),
      contentType: "application/json; charset=utf-8",
      success: function (data) {
        //console.log(data);
        if (data) {
          jQuery("#reporteador").html(data);
          jQuery("#table_reporteador_polizas").partnersfilter();
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message:
            "Request Status: " + xhr.status + " Status Text: " + xhr.statusText,
        });
      },
    });

  }

  //Nueva Póliza
  jQuery(document).on("click", ".nueva_poliza", function (e) {
    e.preventDefault();
    jQuery(this).partnersModal({
      title: "Nuevo Paquete",
      modalSize: "modal-lg",
      modalId: "vista-nueva-poliza-modal",
      content: loader,
    });
    jQuery.ajax({
      type: "POST",
      url: settings.polizas.ruta_consultas + "nueva_poliza_form",
      data: JSON.stringify(1),
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (data) {
        jQuery("#vista-nueva-poliza-modal .modal-body").html(data.message);

        // Buscar cliente
        jQuery("#buscar_cliente").typeahead({
          order: "asc",
          minlength: 1,
          maxItem: 15,
          hint: true,
          accent: true,
          group: {
            template: "{{group}}",
          },
          maxItemPerGroup: 5,
          backdrop: {
            "background-color": "#fff",
          },
          template: function (query, item) {
            var color_t_clasificacion;
            var tipo_clasificacion = item.tipo_clasificacion;
            var credito_contado = item.credito == 1 ? "Crédito" : "Contado";
            switch (tipo_clasificacion) {
              case "a":
                color_t_clasificacion = "success";
                break;
              case "b":
                color_t_clasificacion = "success";
                break;
              case "c":
                color_t_clasificacion = "warning";
                break;
              case "d":
                color_t_clasificacion = "danger";
                break;
              case "e":
                color_t_clasificacion = "danger";
                break;
              case "p":
                color_t_clasificacion = "success";
                credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas" : item.saldo_horas + " hora");
                break;
            }
            tipo_clasificacion = tipo_clasificacion.toUpperCase();


            if (item.tipo_cliente != 3) {
              return (
                "<p class='col-md-12'>" +
                "<span>{{nombre_cliente}}</span> " +
                '<span class="float-right badge badge-' +
                color_t_clasificacion +
                '">' +
                '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                tipo_clasificacion +
                " | " + credito_contado +
                "</span> </p> "
              );
            } else {
              return "<p><span>{{nombre_cliente}}</span> </p> ";
            }
          },
          dynamic: true,
          dropdownFilter: "Todos",
          emptyTemplate:
            '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
          source: {
            Clientes: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: settings.polizas.ruta_lista_clientes + "complete",
                path: "data.datos.clientes",
              },
            },
            Contactos: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: settings.polizas.ruta_lista_clientes + "complete",
                path: "data.datos.contactos",
              },
            },
            Proveedores: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: settings.polizas.ruta_lista_clientes + "complete",
                path: "data.datos.proveedores",
              },
            },
          },
          callback: {
            onClickAfter: function (node, a, item) {
              var color_t_clasificacion;
              var tipo_clasificacion = item.tipo_clasificacion;
              var credito_contado = item.credito == 1 ? "Crédito" : "Contado";
              switch (tipo_clasificacion.toLowerCase()) {
                case "a":
                  color_t_clasificacion = "success";
                  break;
                case "b":
                  color_t_clasificacion = "success";
                  break;
                case "c":
                  color_t_clasificacion = "warning";
                  break;
                case "d":
                  color_t_clasificacion = "danger";
                  break;
                case "e":
                  color_t_clasificacion = "danger";
                  break;
                case "p":
                  color_t_clasificacion = "success";
                  credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas" : item.saldo_horas + " hora");

                  break;
              }
              tipo_clasificacion = tipo_clasificacion.toUpperCase();
              if (item.tipo_cliente != 3) {
                jQuery(".quick_info_client").html(
                  '<span class="badge badge-' +
                  color_t_clasificacion +
                  '">' +
                  '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                  tipo_clasificacion +
                  " | " +
                  credito_contado +
                  "</span> </p> "
                );
                id_cliente = item.id_cliente;

              }
              //Bindear el id del cliente al input
              node.attr("data-id-cliente", item.id_cliente);
              // Generar lista contactos solo para clientes Negocio/Distribuidor
              if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                generar_contactos(
                  settings.polizas.ruta_lista_contactos,
                  item.id_cliente
                );

                //Solamente agrega este attr cuando debe de tener contactos
                node.attr("data-tipo-negocio", item.tipo_negocio);
              } else {
                jQuery(".contacto_container").hide();
                jQuery(".select_lista_contactos").empty();
              }
            },
            onSearch: function (node, a) {
              if (a !== "") {
              } else {
                // Para prevenir errores de sobrescribir o duplicar
                jQuery(".contacto_container").hide();
                jQuery(".select_lista_contactos").empty();
                jQuery(".quick_info_client").html("");
                node.removeAttr("data-id-cliente");
                node.removeAttr("data-tipo-negocio");
              }
            },
          },
        });
        //

        // Mostrar precios por tipo de póliza

        // jQuery(".tipo_poliza").click(function () {

        // });

        jQuery(document).on("change", ".tipo_poliza", function () {
          tipo_poliza = jQuery(".tipo_poliza_radio:checked").val();
          jQuery.ajax({
            type: "POST",
            url: settings.polizas.ruta_consultas + "get_paquetes_polizas",
            data: tipo_poliza,
            contentType: "application/json; charset=utf-8",
            responseType: "json",
            success(response) {
              const d = JSON.parse(response);
              jQuery("#precio_hora").val(formatter.format(d.message.precio_hora));
              jQuery("#horas").val(d.message.horas);
              jQuery("#precio_paquete").val(formatter.format((d.message.horas * d.message.precio_hora)));
              return;
              ////////////////////////////////////////////////////////////////
            },
            error(xhr) {
              iziToast.error({
                title: "Ocurrio un error: ",
                message:
                  "Request Status: " +
                  xhr.status +
                  "Status Text: " +
                  xhr.statusText,
              });
            },
          });
          return;
        });

        jQuery.validate({
          form: "#nueva_poliza_form",
          errorMessageClass: "invalid-feedback",
          inputParentClassOnError: "text-danger",
          inputParentClassOnSuccess: "text-success",
          errorElementClass: "is-invalid",
        });
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message:
            "Request Status: " + xhr.status + " Status Text: " + xhr.statusText,
        });
      },
    });
  });

  //Guardar Póliza
  jQuery(document).on("keypress", ":input:not(textarea)", function (e) {
    return e.keyCode != 13;
  });
  jQuery(document).on("submit", "#nueva_poliza_form", function (e) {
    e.preventDefault();
    var btn = jQuery(this).find('button[type="submit"]');
    btn.partnersBtnControl("start");
    var datos = jQuery("#nueva_poliza_form").serializeArray();
    var datosEnvio = {};
    for (var i = 0; i < datos.length; i++) {
      datosEnvio[datos[i]["name"]] = datos[i]["value"];
    }
    if (!jQuery("#buscar_cliente").attr("data-id-cliente")) {
      iziToast.error({
        title: "Error",
        message: "Selecciona un cliente",
      });
      btn.partnersBtnControl("end");
      return false;
    }
    if (jQuery("#buscar_cliente").attr("data-tipo-negocio") == 1 ||
      jQuery("#buscar_cliente").attr("data-tipo-negocio") == 3) {
      if (
        jQuery(".select_lista_contactos").find("option:selected").val() == 0
      ) {
        iziToast.error({
          title: "Error",
          message: "Selecciona un contacto",
        });
        btn.partnersBtnControl("end");
        return false;
      }
    }
    datosEnvio.id_cliente = jQuery("#buscar_cliente").attr("data-id-cliente");
    datosEnvio.id_contacto = jQuery(".select_lista_contactos").find("option:selected").val();
    datosEnvio.tipo_poliza = jQuery('input[name="tipo_poliza"]:checked').val();
    datosEnvio.horas = jQuery("#horas").val();

    var envio = JSON.stringify(datosEnvio);

    jQuery.ajax({
      type: "POST",
      url: settings.polizas.ruta_consultas + "capturar_poliza",
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == "success") {
          iziToast.success({
            title: "Bien! ",
            message: "Nuevo paquete registrado",
          });
          jQuery("#vista-nueva-poliza-modal").modal("hide");
          autoUpdate.forceUpdate();
        } else if (response.status == "error") {
          iziToast.error({
            title: "Error",
            message: response.message,
          });
        }
        autoUpdate.forceUpdate();
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message:
            "Request Status: " + xhr.status + " Status Text: " + xhr.statusText,
        });
      },
    });
  });

  // Reset filters
  jQuery(document).on("click", "#reset_filters", function () {
    r_options.filter.search_bar = null;
    r_options.filter.usuario = null;
    r_options.filter.tipo_poliza = null;
    jQuery(".input_buscador_polizas").val("");
    autoUpdate.forceUpdate();
    jQuery("#reporteador").find(".table tbody").css("opacity", 0.5);
  });

  // Filtrado - Texto
  jQuery(document).on("keyup", ".input_buscador_polizas", function (e) {
    clearTimeout(jQuery.data(this, "timer"));
    if (e.keyCode == 13) search(true);
    else jQuery(this).data("timer", setTimeout(search, 200));
  });

  // Filtrado - Usuario
  jQuery(document).on("change", "#filtrado_usuario", function () {
    jQuery("#reporteador").find(".table tbody").css("opacity", 0.5);
    r_options.filter.usuario = jQuery(this).find("option:selected").val();
    autoUpdate.forceUpdate();
  });

  // Filtrado - Tipo poliza
  jQuery(document).on("change", "#filtrado_tipo_poliza", function () {
    jQuery("#reporteador").find(".table tbody").css("opacity", 0.5);
    r_options.filter.tipo_poliza = jQuery(this).find("option:selected").val();
    autoUpdate.forceUpdate();
  });

  //Search bar
  function search() {
    var StringtoSearch = jQuery(".input_buscador_polizas").val();
    jQuery("#reporteador").find(".table tbody").css("opacity", 0.5);
    r_options.filter.search_bar = StringtoSearch;
    autoUpdate.forceUpdate();
  }

  //***************************************************************
  //------------------------ DATE PICKER --------------------------
  //***************************************************************
  var start = moment().startOf("month");
  var end = moment().endOf("month");
  function cb(start, end) {
    jQuery("#reportrange span").html(
      start.format("DD/MM/YYYY") + " - " + end.format("DD/MM/YYYY")
    );
  }
  cb(start, end);
  jQuery("#reportrange").daterangepicker(
    {
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        format: "DD/MM/YYYY",
        separator: " - ",
        applyLabel: "Aplicar",
        cancelLabel: "Cancelar",
        fromLabel: "Desde",
        toLabel: "Hasta",
        customRangeLabel: "Personalizado",
        weekLabel: "S",
        daysOfWeek: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        monthNames: [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre",
        ],
        firstDay: 1,
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        Enero: [
          moment().month("January").startOf("month"),
          moment().month("January").endOf("month"),
        ],
        Julio: [
          moment().month("July").startOf("month"),
          moment().month("July").endOf("month"),
        ],
        "Mes Anterior": [
          moment().subtract(1, "month").startOf("month"),
          moment().subtract(1, "month").endOf("month"),
        ],
        Febrero: [
          moment().month("February").startOf("month"),
          moment().month("February").endOf("month"),
        ],
        Agosto: [
          moment().month("August").startOf("month"),
          moment().month("August").endOf("month"),
        ],
        Hoy: [moment(), moment()],
        Marzo: [
          moment().month("March").startOf("month"),
          moment().month("March").endOf("month"),
        ],
        Septiembre: [
          moment().month("September").startOf("month"),
          moment().month("September").endOf("month"),
        ],
        "Semana Actual": [moment().startOf("week"), moment().endOf("week")],
        Abril: [
          moment().month("April").startOf("month"),
          moment().month("April").endOf("month"),
        ],
        Octubre: [
          moment().month("October").startOf("month"),
          moment().month("October").endOf("month"),
        ],
        "Mes Actual": [moment().startOf("month"), moment().endOf("month")],
        Mayo: [
          moment().month("May").startOf("month"),
          moment().month("May").endOf("month"),
        ],
        Noviembre: [
          moment().month("November").startOf("month"),
          moment().month("November").endOf("month"),
        ],
        "Año Actual": [moment().startOf("year"), moment().endOf("year")],
        Junio: [
          moment().month("June").startOf("month"),
          moment().month("June").endOf("month"),
        ],
        Diciembre: [
          moment().month("December").startOf("month"),
          moment().month("December").endOf("month"),
        ],
      },
    },
    cb
  );
  jQuery("#reportrange").on("apply.daterangepicker", function () {
    var fecha = jQuery("#reportrange").find("span").text();
    var fecha_array = fecha.split("-");
    r_options.filter.start_date = fecha_array[0];
    r_options.filter.end_date = fecha_array[1];
    autoUpdate.forceUpdate();
    jQuery("#reporteador").find(".table").css("opacity", 0.5);
  });
  (function () {
    var fecha = jQuery("#reportrange").find("span").text();
    var fecha_array = fecha.split("-");
    r_options.filter.start_date = fecha_array[0];
    r_options.filter.end_date = fecha_array[1];
    autoUpdate.forceUpdate();
    jQuery("#reporteador").find(".table").css("opacity", 0.5);
  })();
  //***************************************************************
  //------------------------ DATE PICKER --------------------------
  //***************************************************************

  //Eliminar poliza
  jQuery(document).on("click", ".eliminar_poliza", function () {
    var id_poliza = jQuery(this).parents("tr").attr("data-id-poliza");
    swal({
      title: "¿Estás Seguro?",
      html: "¿Deseas eliminar el paquete <strong>" + id_poliza + "</strong>?",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#DD6B55",
      confirmButtonText: "¡Si, eliminar!",
      cancelButtonText: "¡No!",
      showLoaderOnConfirm: true,
      onOpen: function () {
        fixBootstrapModal();
      },
      onClose: function () {
        jQuery("body").removeAttr("style");
        restoreBootstrapModal();
      },
      preConfirm: function () {
        return new Promise(function (resolve) {
          jQuery.ajax({
            type: "POST",
            url: settings.polizas.ruta_consultas + "eliminar_poliza",
            data: id_poliza,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
              if (response.status == "success") {
                autoUpdate.forceUpdate();
                setTimeout(function () {
                  swal.close();
                }, 2000);
                resolve();
                autoUpdate.forceUpdate();
              } else if (response.status == "error") {
                iziToast.error({
                  title: "Error",
                  message: response.message,
                });
              }
            },
            error: function (xhr) {
              iziToast.error({
                title: "Ocurrio un error: ",
                message:
                  "Request Status: " +
                  xhr.status +
                  " Status Text: " +
                  xhr.statusText,
              });
            },
          });
        });
      },
      allowOutsideClick: false,
    }).then(function (a) {
      if (!a.dismiss) {
        swal(
          "¡Eliminada!",
          "El paquete se ha eliminado correctamente.",
          "success"
        );
        autoUpdate.forceUpdate();
      }
    });
  });

  //Observaciones
  jQuery(document).on("click", ".polizas-observaciones", function () {
    var id_poliza = jQuery(this).parents("tr").attr("data-id-poliza");
    var datosEnvio = {};
    datosEnvio.id_poliza = id_poliza;
    jQuery(this).partnersObs({
      modalId: "observaciones-polizas",
      ajaxUrl: settings.polizas.ruta_sys_tools + "load_obs",
      index: "id_poliza",
      id_index: id_poliza,
      tabla: "partners_polizas",
      closeAfterSuccess: false,
      col: "observaciones",
      ajaxSuccessCallback: function () {
        autoUpdate.forceUpdate();
      },
    });
  });
  // Ver paquete
  jQuery(document).on("click", ".vista_paquete", function () {
    var tid = jQuery(this).parents("tr").attr("data-tipo-poliza");
    var datosEnvio = {};
    datosEnvio.tid = tid;

    jQuery(this).partnersModal({
      title: "Detalle del paquete",
      modalSize: "modal-sm",
      modalId: "vista-paquete-modal",
      content: loader,
    });
    jQuery.ajax({
      type: "POST",
      url: settings.polizas.ruta_consultas + "vista_paquete",
      data: JSON.stringify(datosEnvio),
      success: function (data) {
        if (data) {
          let datos = JSON.parse(data);
          //console.log(datos.message);
          jQuery("#vista-paquete-modal .modal-body").html(datos.message);

        }
      },
    });
  });

  jQuery(document).on("click", ".vista_paquete_cliente", function () {
    var id_poliza = jQuery(this).parents().attr("data-id-poliza"); // el id de la poliza a buscar en el DOM
    var id_cliente = jQuery(this).parents().attr("data-id-cliente"); // el id del cliente en el DOM
    var datosEnvio = {};
    datosEnvio.id_poliza = id_poliza;
    datosEnvio.t = 1;
    const clases = jQuery(this).attr("class");
    reporte_paquete(id_poliza, id_cliente, clases);
  });
  jQuery(".modal").on("hidden.bs.modal", function () {
    jQuery(".modal-body").html("");
    Object.keys(jQuery('.modal')).forEach((e) => {
      jQuery(e).remove();
    });
  });
  // enviar el token por correo
  jQuery(document).on('click', '.enviar_reporte_paquete', function () {
    var poliza = jQuery(this).parents('tr').attr("data-id-poliza");
    var datosEnvio = {};
    var id_cliente = jQuery(this).parents('tr').attr('data-id-cliente');
    var token = '';
    //obtner token
    jQuery.ajax({
      type: "POST",
      url: settings.polizas.ruta_consultas + "generar_token_reporte",
      data: poliza,
      success: function (data) {
        var d = JSON.parse(data);
        token = d.message; //url con el token
        datosEnvio.id_poliza = poliza;
        datosEnvio.id_cliente = id_cliente;
        datosEnvio.url_token = token;
        if (token != '') {
          token = token.split('/');
          token = token[token.length - 1];
          clearModal();
          modalCorreo(
            datosEnvio.id_cliente,
            settings,
            datosEnvio,
            (emailsToSend, ddatos, body, hideModal) => {
              const data = {
                to: emailsToSend,
                url_token: ddatos.url_token,
                id_cliente: ddatos.id_cliente,
                id_poliza: ddatos.id_poliza,
                body,
              };
              jQuery.ajax({
                type: 'POST',
                url: `${settings.polizas.ruta_consultas}enviar_reporte_paquete`,
                data: JSON.stringify(data),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                success(res) {
                  if (res.status === 'success') {
                    // eslint-disable-next-line no-undef
                    iziToast.success({
                      title: 'Listo',
                      message: 'Correos enviados',
                    });
                    hideModal(true);
                    setTimeout(() => {
                      location.reload();
                    }, 500);
                  } else if (res.status === 'error') {
                    // eslint-disable-next-line no-undef
                    iziToast.error({
                      title: 'Error',
                      message: res.message,
                    });
                    hideModal(false);
                  }
                },
                error(xhr) {
                  // eslint-disable-next-line no-undef
                  iziToast.error({
                    title: 'Ocurrio un error: ',
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                  hideModal(false);
                },
              });
            }
          );

          jQuery(document).on('click', '.close', function () {
            clearModal();
          });
          jQuery(document).on('click', '.cerrar', function () {
            clearModal();
          });

        }
      }
    });
  });

  jQuery(document).on('change', '#filtro_inactivos', () => {
    if (jQuery('input[id="filtro_inactivos"]:checked').val() == '1') {
      r_options.filter.filtro_inactivos = 1;
      autoUpdate.forceUpdate();

    } else {
      r_options.filter.filtro_inactivos = 0;
      autoUpdate.forceUpdate();
    }
  });

  //* **************************************************************
  // -------------------------- STATUS PAGADO ----------------------
  //* **************************************************************
  jQuery(document).on("click", ".status_pagado", function () {
    const id_poliza = jQuery(this).parents("tr").attr("data-id-poliza");
    const folio_poliza = jQuery(this).parents("tr").attr("data-folio-poliza");
    const nombre_cliente = jQuery(this).parents("tr").attr("data-nombre-cliente");
    const total_poliza = jQuery(this).parents("tr").attr("data-total-poliza");
    let template =
      `<div class="row">
        <div class="col-md">
          <button type="button" class="btn btn-outline-warning poliza_no_pagado w-100" data-id-poliza="${id_poliza}" role="button">
            No
          </button>
        </div>
        <div class="col-md">
          <button type="button" class="btn btn-outline-success poliza_pagado w-100" data-nombre-cliente="${nombre_cliente}" data-total-poliza="${total_poliza}" data-id-poliza="${id_poliza}" role="button">
            Pagado
          </button>
        </div>
        <div class="col-md">
          <button type="button" class="btn btn-outline-info poliza_facturado w-100" data-folio-poliza="${folio_poliza}" data-nombre-cliente="${nombre_cliente}" data-id-poliza="${id_poliza}" role="button">
            Facturado
          </button>
        </div>
       </div>
        `;
    jQuery(this).partnersModal({
      content: template,
      title: "Selecciona",
      forceWidth: 25,
      modalId: "modal-pagado-servicios",
      noFooter: true,
    });
  });


  jQuery(document).on("click", ".poliza_no_pagado", function () {
    const id_poliza = jQuery(this).attr("data-id-poliza");
    const clicked_td = jQuery(
      `tr[data-id-poliza="${id_poliza}"] .status_pagado`
    );
    jQuery("#modal-pagado-servicios .modal-body").html(loader);
    let envio = {};
    envio.new_val = 0;
    envio.id_poliza = id_poliza;
    envio.col = "forma_pago";
    envio = JSON.stringify(envio);
    jQuery.ajax({
      type: "POST",
      url: `${settings.polizas.ruta_consultas}update_status`,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success(response) {
        if (response.status == "success") {
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1000,
            position: "bottomLeft",
          });
          jQuery("#modal-pagado-servicios").modal("hide");
          clicked_td.removeClass("status-green");
          clicked_td.addClass("status-red");
          clicked_td.html("No");
          autoUpdate.forceUpdate();
        } else if (response.status == "error") {
          iziToast.error({
            title: "Error",
            message: response.message,
          });
        }
      },
      error(xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
        });
      },
    });
  });

  jQuery(document).on("click", ".poliza_pagado", function () {
    const id_poliza = jQuery(this).attr("data-id-poliza");
    const nombre_cliente = jQuery(this).attr("data-nombre-cliente");
    const total_servicio = jQuery(this).attr("data-total-poliza");
    jQuery("#modal-pagado-servicios").modal("hide");
    const template =
      `<form autocomplete="off" id="form_pagado_caja" data-id-poliza="${id_poliza}">
          <div class="row">
            <div class="col-md-5"><div class="form-group required">
              <label class="col-form-label">Concepto
              </label>
              <div>
                <input type="text" class="form-control valid_me" value="Registro Pago de Paquete: ${id_poliza} | ${nombre_cliente}" name="concepto_capturar_caja" data-validation="required" data-validation-error-msg="Ingresa un concepto">
              </div>
            </div>
          </div>
          <div class="col-md-5">
            <div class="form-group required">
              <label class="col-form-label">Cantidad
              </label>
              <div>
                <input type="text" class="form-control valid_me text-right" value="${numeral(total_servicio).format("0,0.00")}" data-validation-min-number="${total_servicio}" name="cantidad_capturar_caja" data-validation="number min_number" data-validation-allowing="float" data-validation-error-msg="Ingresa una cantidad correcta y mayor a: ${numeral(total_servicio).format("0,0.00")}" data-sanitize="numberFormat" data-sanitize-number-format="0,0.00">
              </div>
            </div>
          </div>
          <div class="col-md-2">
            <label>Guardar en caja</label>
            <button type="submit" class="btn btn-success" role="button">Guardar</button>
          </div>
        </div>
        </form>`;

    jQuery(this).partnersModal({
      content: template,
      title: "Capturar en caja",
      forceWidth: 65,
      modalId: "modal-pagado-caja",
      noFooter: true,
    });
    setTimeout(() => {
      jQuery.validate({
        form: "#form_pagado_caja",
        errorMessageClass: "invalid-feedback",
        inputParentClassOnError: "text-danger",
        inputParentClassOnSuccess: "text-success",
        errorElementClass: "is-invalid",
      });
      jQuery.formUtils.addValidator({
        name: "min_number",
        validatorFunction(value, $el) {
          return (
            numeral(value).value() >=
            numeral(jQuery($el).attr("data-validation-min-number")).value()
          );
        },
        errorMessage: "",
        errorMessageKey: "",
      });
    }, 400);
  });

  jQuery(document).on("submit", "#form_pagado_caja", function (e) {
    e.preventDefault();
    const btn = jQuery(this).find('button[type="submit"]');
    const id_poliza = jQuery(this).attr("data-id-poliza");
    btn.partnersBtnControl("start");
    const datos = jQuery("#form_pagado_caja").serializeArray();
    const datosEnvio = {};
    for (let i = 0; i < datos.length; i++) {
      datosEnvio[datos[i].name] = datos[i].value;
    }
    jQuery("#modal-pagado-caja .modal-body").html(loader);
    const clicked_td = jQuery(
      `tr[data-id-poliza="${id_poliza}"] .status_pagado`
    );
    datosEnvio.id_poliza = id_poliza;
    datosEnvio.new_val = 1;
    datosEnvio.col = "forma_pago";
    datosEnvio.obs = `Se capturó en caja bajo el concepto de: ${datosEnvio.concepto_capturar_caja}`;
    datosEnvio.capturar_caja = 1;
    const envio = JSON.stringify(datosEnvio);
    jQuery.ajax({
      type: "POST",
      url: `${settings.polizas.ruta_consultas}update_status`,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success(response) {
        if (response.status == "success") {
          iziToast.success({
            title: "Bien! ",
            message: response.message,
          });
          autoUpdate.forceUpdate();
          jQuery("#modal-pagado-caja").modal("hide");
          clicked_td.addClass("status-green");
          clicked_td.html("Pagado");
        } else if (response.status == "error") {
          iziToast.error({
            title: "Error",
            message: response.message,
          });
        }
      },
      error(xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
        });
      },
    });
  });

  jQuery(document).on("click", ".poliza_facturado", function () {
    const id_poliza = jQuery(this).attr("data-id-poliza");
    const nombre_cliente = jQuery(this).attr("data-nombre-cliente");
    jQuery("#modal-pagado-servicios").modal("hide");
    let content = "";
    content +=
      `${'<div class="row">' +
      '<div class="col-md-2"><p class="font-weight-bold">Folio Paquete:</p></div>' +
      '<div class="col-md-2">'
      }P-${id_poliza}</div>` +
      '<div class="col-md-1"><p class="font-weight-bold">Cliente:</p></div>' +
      `<div class="col-md-3">${nombre_cliente}</div>` +
      "</div><hr>" +
      '<div class="row">' +
      '<div class="col-md-2">' +
      '<p class="font-weight-bold">Factura:</p>' +
      "</div>" +
      '<div class="col-md-2">' +
      '<input type="text" class="form-control numero_factura">' +
      "</div>" +
      "</div><hr>" +
      '<div class="row">' +
      '<div class="col-md-4"><p class="font-weight-bold">La factura está a nombre de:</p></div>' +
      '<div class="col-md-8"><input type="text" class="nombre_cliente_factura form-control" readonly value="..."></div>' +
      "</div>" +
      '<div class="row">' +
      '<div class="col-md-12 my-3">' +
      `<button type="button" class="float-right capturar_servicio_facturado btn btn-success" data-id-poliza="${id_poliza}" role="button" style="display: none;">Guardar</button>` +
      "</div>" +
      "</div>";

    setTimeout(function () {
      jQuery(this).partnersModal({
        title: "Facturar",
        modalSize: "modal-lg",
        modalId: "facturar-servicio-modal",
        content,
        noFooter: true,
      });
    }, 400);
  });

  jQuery(document).on("blur", ".numero_factura", () => {
    const numero_factura = jQuery(".numero_factura").val();
    if (
      jQuery.trim(numero_factura) == "" ||
      !jQuery.trim(numero_factura) ||
      isNaN(numero_factura)
    ) {
      iziToast.error({
        title: "Error",
        message: "Ingresa un folio de factura correcto.",
      });
      return false;
    }
    let envio = {};
    envio.numero_factura = numero_factura;
    envio = JSON.stringify(envio);
    jQuery.ajax({
      type: "POST",
      url: `${settings.polizas.ruta_sys_tools}get_datos_cliente_contpaq`,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success(response) {
        if (response.status == "success") {
          const datos_c = JSON.parse(response.message);
          jQuery(".nombre_cliente_factura").val(datos_c.nombre);
          jQuery(".nombre_cliente_factura").attr(
            "data-codigo-cliente",
            datos_c.codigo_cliente
          );
          jQuery(".nombre_cliente_factura").attr("data-rfc-cliente", datos_c.rfc);
          jQuery(".capturar_servicio_facturado").show();
        } else if (response.status == "error") {
          iziToast.error({
            title: "Error",
            message: response.message,
          });
          jQuery(".nombre_cliente_factura").val("");
          jQuery(".capturar_servicio_facturado").hide();
        }
      },
      error(xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
        });
      },
    });
  });

  jQuery(document).on("click", ".capturar_servicio_facturado", function () {
    let envio = {};
    const btn = jQuery(this);
    btn.partnersBtnControl("start");
    envio.codigo_cliente = jQuery(".nombre_cliente_factura").attr(
      "data-codigo-cliente"
    );
    envio.rfc_cliente = jQuery(".nombre_cliente_factura").attr("data-rfc-cliente");
    envio.folio_factura = jQuery(".numero_factura").val();
    envio.id_poliza = jQuery(this).attr("data-id-poliza");
    envio = JSON.stringify(envio);
    jQuery.ajax({
      type: "POST",
      url: `${settings.polizas.ruta_consultas}marcar_facturado`,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success(response) {
        if (response.status == "success") {
          iziToast.success({
            title: "Bien! ",
            message: response.message,
          });
          jQuery("#facturar-servicio-modal").modal("hide");
          autoUpdate.forceUpdate();
        } else if (response.status == "error") {
          iziToast.error({
            title: "Error",
            message: response.message,
          });
          btn.partnersBtnControl("end");
        }
      },
      error(xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
        });
      },
    });
  });
  //* **************************************************************
  // -------------------------- STATUS PAGADO ----------------------
  //* **************************************************************

  //* **************************************************************
  // --------------------- POLIZAS VER FACTURA  ------------------
  //* **************************************************************
  jQuery(document).on("click", ".vista_factura", function () {
    const id_factura = jQuery(this).text();
    jQuery(this).partnersModal({
      title: `Factura ${id_factura}`,
      modalId: "vista-factura",
      forceWidth: 90,
      content: loader,
    });
    jQuery.ajax({
      type: "POST",
      url: `${settings.polizas.ruta_sys_tools}get_full_factura`,
      data: JSON.stringify(id_factura),
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success(response) {
        if (response.status == "success") {
          if (response.message == "not_on_server") {
            var content =
              "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
          } else {
            var content =
              `${"<div>" + '<iframe src="/system/tools/vista_factura?factura='
              }${response.message}" width="100%;" height="600px;"></iframe>` +
              "</div>";
          }
          jQuery("#vista-factura .modal-body").html(content);
        } else if (response.status == "error") {
          iziToast.error({
            title: "Error",
            message: response.message,
          });
        }
      },
      error(xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
        });
      },
    });
  });
  //* **************************************************************
  // --------------------- POLIZAS VER FACTURA  ------------------
  //* **************************************************************


});

function reporte_paquete(id_poliza, id_cliente, clases) {
  jQuery.ajax({
    type: "POST",
    url: settings.polizas.ruta_consultas + "generar_token_reporte",
    data: id_poliza,
    success: function (data) {
      d = JSON.parse(data);
      window.open(d.message, '_blank');
    }
  });

}
function clearModal() {
  Object.keys(jQuery('.modal')).forEach((e) => {
    jQuery(e).remove();
  });
  jQuery('.modal').remove();
  jQuery('.modal-dialog').remove();
  jQuery('#moda-enviar-correo').remove();
  jQuery('.modal-backdrop').remove();
}

