(function ($) {
    settings = Drupal.settings;
    $(document).ready(function () {

//***************************************************************
//--------------------------- ANIMATIONS  -----------------------
//***************************************************************
        var btn = $('.check_cancellation_container .btn-submit');
        var progress = $('.check_cancellation_container #loader');
        var bar = new ProgressBar.Circle(loader, {
            strokeWidth: 10,
            easing: 'easeInOut',
            duration: 1000,
            color: '#4cd964',
            trailColor: '#E9E9E9',
            trailWidth: 10,
            svgStyle: null
        });

        $(document).on('click', '.check_cancellation_container .btn-submit', function () {
            $(this).addClass('shrink');
            progress.addClass('active');
            var decision_val = $('.choose_decision_solicitud_cancelacion:checked').val();
            var id_pendiente = $(this).attr('data-id-pendiente');
            var envio = {};
            envio.decision = decision_val;
            envio.id_pendiente = id_pendiente;
            envio = JSON.stringify(envio);
            $.ajax({
                type: 'POST',
                url: settings.pendientes.ruta_consultas + 'review_cancellation',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        bar.animate(1, function () {
                            progress.removeClass('active');
                            btn.removeClass('shrink');
                            btn.addClass('complete');
                            btn.attr('disabled', 1);
                            $('.remove_on_end').remove();
                            if (decision_val == 1) {
                                $('.solicitud_text_decision').html('La solicitud para cancelar el pendiente ha sido aprovada, ahora el pendiente se ha eliminado automáticamente.');
                            } else {
                                $('.solicitud_text_decision').html('La solicitud para cancelar el pendiente ha sido rechazada, ahora el pendiente quedará en estado inutilizable.');
                            }
                            $('.enviado-text').show();
                            $('.enviado-text').addClass('animated');
                            $('.enviado-text').addClass('fadeIn');
                            setTimeout(function () {
                                window.location.replace('/');
                            }, 5000);
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });

        });

//***************************************************************
//--------------------------- ANIMATIONS  -----------------------
//***************************************************************


    });
})
(jQuery);