(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {
    // Cuando hay campos editables en la página en general
    // cargarlos al inicio una sola vez, para no repetir el mismo código una y otra vez
    // en todos los archivos.
    var ruta_url = settings.pendientes.ruta_sys_tools + "inline_edit";
    partnersEditableContent(ruta_url);

    if (getUrlVars()["id_pendiente"]) {
      var temp_div = $(
        '<div data-event-id="' +
          getUrlVars()["id_pendiente"] +
          '" class="vista_pendiente"></div>'
      );
      setTimeout(function () {
        temp_div.insertAfter("body");
        temp_div.click();
        temp_div.remove();
      }, 500);
    }

    if (getUrlVars()["new_pendiente"]) {
      setTimeout(function () {
        $(".nuevo_pendiente").click();
      }, 500);
    }
    //***************************************************************
    //--------------------------- CALENDAR  -------------------------
    //***************************************************************
    var vista_principal;

    if ($(window).width() <= 768) {
      vista_principal = "day";
      setTimeout(function () {
        $(".day_view_button").click();
      }, 400);
    } else {
      vista_principal = "week";
    }
    var calendar = $("#calendar").calendar({
      tmpl_path: "/sites/all/modules/partners/lib/modulos/pendientes/tmpls/",
      first_day: 1,
      events_source: settings.pendientes.ruta_consultas + "reporte_pendientes",
      view: vista_principal,
      day: "now",
      language: "es-MX",
      weekbox: false,
      onAfterViewLoad: function () {
        setTimeout(function () {
          $(".progress-line").remove();
        }, 500);
      },
    });

    // Prev | Today | Next
    $(document).on(
      "click",
      ".btn-group button[data-calendar-nav]",
      function () {
        var d = $('<div class="progress-line"></div>');
        $(".progress-bar-container").append(d);
        $(".btn-group button[data-calendar-nav]").each(function () {
          $(this).removeClass("active");
        });
        $(this).addClass("active");
        calendar.navigate($(this).attr("data-calendar-nav"));
      }
    );

    // Year | Month | Week | Day
    $(document).on(
      "click",
      ".btn-group button[data-calendar-view]",
      function () {
        var d = $('<div class="progress-line"></div>');
        $(".progress-bar-container").append(d);
        $(".btn-group button[data-calendar-view]").each(function () {
          $(this).removeClass("active");
        });
        $(this).addClass("active");
        calendar.view($(this).attr("data-calendar-view"));
      }
    );

    // Filtrado
    $(document).on("change", ".buscador_live", function () {
      search();
    });
    // Para que le de tiempo a limpiar el formulario y despues vuelva a recargar los eventos
    $(document).on("click", "#reset_filters", function () {
      $(".input_buscador_pendiente").val("");
      setTimeout(function () {
        search();
      }, 100);
    });
    $(document).on("keyup", ".input_buscador_pendiente", function (e) {
      clearTimeout($.data(this, "timer"));
      if (e.keyCode == 13) search(true);
      else $(this).data("timer", setTimeout(search, 200));
    });

    function search() {
      var d = $('<div class="progress-line"></div>');
      $(".progress-bar-container").append(d);
      calendar.view();
    }

    setInterval(function () {
      calendar.view();
    }, 30000);
    //***************************************************************
    //--------------------------- CALENDAR  -------------------------
    //***************************************************************

    //***************************************************************
    //------------------------ NUEVO PENDIENTE ----------------------
    //***************************************************************
    $(document).on("click", ".nuevo_pendiente", function () {
      $(this).partnersModal({
        ajaxUrl:
          settings.pendientes.render_template +
          "pendientes.nuevo_pendiente_form",
        title: "Selecciona el Área",
        modalSize: "modal-lg",
        modalId: "nuevo_pendiente_modal",
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: "#new_pendiente_form",
              errorMessageClass: "invalid-feedback",
              inputParentClassOnError: "text-danger",
              inputParentClassOnSuccess: "text-success",
              errorElementClass: "is-invalid",
            });
          }, 500);
        },
      });
    });



    $(document).on("change", ".select_tipo_pendiente", function () {
      var val = $(this).val();
      var area_name = $(this).attr("data-area-name");

      generate_user_list(area_name);

      //Init
      $("#nuevo_pendiente_modal .modal-title").html("Generar Pendiente");
      $(".new_pendiente_form_container").show();
      var now = moment().format("DD-MM-YYYY");
      $("#fecha-pendiente-container .input-group.date").datepicker({
        format: "dd/mm/yyyy",
        todayBtn: "linked",
        language: "es",
        daysOfWeekDisabled: "0",
        autoclose: true,
        todayHighlight: true,
        startDate: now,
        orientation: "auto",
        container: ".input-group.date",
      });

      // Resetear el comportamiento de todos
      $(".input_pendiente_otro").removeAttr("disabled");
      $(".container_otro_pendiente").css("opacity", 1);
      $("#new_pendiente_form #buscar_cliente").removeAttr("disabled");
      $(".container_buscador_cliente").css("opacity", 1);
      $(".quick_info_client").html("");

      if (+val === 2) {
        $(".show_on_support").show();
      } else {
        $(".show_on_support").hide();
      }

      if (val == 3 || val == 5) {
        if (val == 5) {
          $(".show_on_ventas_admon").show();
        } else {
          $(".show_on_ventas_admon").hide();
        }
        $(".title_problema_solicitud").html("Tarea");
        $(".hide_on_ventas_admon").hide();
        $('input[name="quien_reporta"]').val("");
      } else {
        $(".title_problema_solicitud").html("Problema o Solicitud");
        $(".hide_on_ventas_admon").show();
        $(".show_on_ventas_admon").hide();
      }

      console.log($(this).attr("data-buscador-opened"));
      if ($(this).attr("data-buscador-opened") != 1) {
        $("#new_pendiente_form #buscar_cliente").typeahead({
          order: "asc",
          minlength: 1,
          maxItem: 15,
          hint: true,
          accent: true,
          group: {
            template: "{{group}}",
          },
          maxItemPerGroup: 5,
          backdrop: {
            "background-color": "#fff",
          },
          template: function (query, item) {
            var color_t_clasificacion;
            var tipo_clasificacion = item.tipo_clasificacion;
            var credito_contado = item.credito == 1 ? "Crédito" : "Contado";
            switch (tipo_clasificacion) {
              case "a":
                color_t_clasificacion = "success";
                break;
              case "b":
                color_t_clasificacion = "success";
                break;
              case "c":
                color_t_clasificacion = "warning";
                break;
              case "d":
                color_t_clasificacion = "danger";
                break;
              case "e":
                color_t_clasificacion = "danger";
                break;
              case "p":
                color_t_clasificacion = "success";
                credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas": item.saldo_horas + " hora") ;

                break;
            }
            tipo_clasificacion = tipo_clasificacion.toUpperCase();

            if (item.tipo_cliente != 3) {
              return (
                "<p>" +
                "<span>{{nombre_cliente}}</span> " +
                '<span class="float-right badge badge-' +
                color_t_clasificacion +
                '">' +
                '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                tipo_clasificacion +
                " | " +
                credito_contado +
                "</span> </p> "
              );
            } else {
              return "<p><span>{{nombre_cliente}}</span> </p> ";
            }
          },
          dynamic: true,
          dropdownFilter: "Todos",
          emptyTemplate:
            '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
          source: {
            Clientes: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: settings.pendientes.ruta_lista_clientes + "complete",
                path: "data.datos.clientes",
              },
            },
            Contactos: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: settings.pendientes.ruta_lista_clientes + "complete",
                path: "data.datos.contactos",
              },
            },
            Proveedores: {
              display: [
                "nombre_cliente",
                "alias",
                "email",
                "nombre_facturacion",
                "pagina_web",
              ],
              ajax: {
                url: settings.pendientes.ruta_lista_clientes + "complete",
                path: "data.datos.proveedores",
              },
            },
          },
          callback: {
            onClickAfter: function (node, a, item, event) {
              var color_t_clasificacion;
              var tipo_clasificacion = item.tipo_clasificacion;
              var credito_contado = item.credito == 1 ? "Crédito" : "Contado";
              $("#buscar_cliente").attr("data-tipo-clasificacion", tipo_clasificacion);
              switch (tipo_clasificacion) {
                case "a":
                  color_t_clasificacion = "success";
                  break;
                case "b":
                  color_t_clasificacion = "success";
                  break;
                case "c":
                  color_t_clasificacion = "warning";
                  break;
                case "d":
                  color_t_clasificacion = "danger";
                  break;
                case "e":
                  color_t_clasificacion = "danger";
                  break;
                case "p":
                  color_t_clasificacion = "success";
                  credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas": item.saldo_horas + " hora") ;

                  if($(".select_tipo_pendiente:checked").val() == 2){
                    $(".select_tipo_pendiente:checked").val("9"); //prepago
                    $("#pendiente_pagado_check").attr("checked", "checked");
                    $("#pendiente_pagado_check").attr("disabled", "disabled");
                    $("#buscar_cliente").attr("data-tipo-clasificacion", "P");
                  }
                  break;
              }
              tipo_clasificacion = tipo_clasificacion.toUpperCase();
              if (item.tipo_cliente != 3) {
                $(".quick_info_client").html(
                  '<span class="badge badge-' +
                    color_t_clasificacion +
                    '">' +
                    '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                    tipo_clasificacion +
                    " | " +
                    credito_contado +
                    "</span> </p> "
                );
                const id_cliente = item.id_cliente;
                if (tipo_clasificacion != "P") {
                  prepareEvs(1, {
                    color_t_clasificacion,
                    tipo_clasificacion,
                    credito_contado,
                    id_cliente,
                    settings,
                  });
                }
              }

              //Bindear el id del cliente al input
              node.attr("data-id-cliente", item.id_cliente);
              node.attr("data-tipo-cliente", item.tipo_cliente);
              node.attr("data-tipo-clasificacion", tipo_clasificacion);
            },
            onSearch: function (node, a, item, event) {
              if (a !== "") {
                // Resetear el valor el de otro en caso de que tenga algo
                $(".input_pendiente_otro").val("");
                $(".input_pendiente_otro").attr("disabled", 1);
                $(".container_otro_pendiente").css("opacity", 0.5);
              } else {
                // Para prevenir errores de sobrescribir o duplicar
                $(".quick_info_client").html("");
                node.removeAttr("data-id-cliente");
              }
            },
            onCancel: function () {
              $(".input_pendiente_otro").removeAttr("disabled");
              $(".container_otro_pendiente").css("opacity", 1);
            },
          },
        });
      }
      // Para que solamente genere una vez lo del tpyeahead.
      $(".select_tipo_pendiente").each(function () {
        $(this).attr("data-buscador-opened", 1);
      });
    });

    $(document).on("change keyup", ".input_pendiente_otro", function () {
      //Resetear el de Cliente y todos sus attr en caso de que se seleccione otro.
      $("#new_pendiente_form #buscar_cliente").val("");
      if ($(this).val().length > 0) {
        $("#new_pendiente_form #buscar_cliente").attr("disabled", 1);
        $(".container_buscador_cliente").css("opacity", 0.5);
        $("#new_pendiente_form #buscar_cliente").removeAttr("data-id-cliente");
      } else {
        $("#new_pendiente_form #buscar_cliente").removeAttr("disabled");
        $(".container_buscador_cliente").css("opacity", 1);
      }
    });

    function generate_user_list(area) {
      var select = $(".asignado_user");
      select.find("option").each(function () {
        if ($(this).attr("data-remove")) {
          $(this).remove();
        }
      });
      $.ajax({
        type: "POST",
        url: settings.pendientes.ruta_consultas + "lista_usuarios",
        data: JSON.stringify(area),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            $.each(JSON.parse(response.message), function (key, val) {
              select.append(
                '<option value="' +
                  val.uid +
                  '" data-remove="1">' +
                  val.name +
                  "</option>"
              );
            });
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    }

    //***************************************************************
    //------------------------ NUEVO PENDIENTE ----------------------
    //***************************************************************

    //***************************************************************
    //------------------------ VISTA PENDIENTE ----------------------
    //***************************************************************
    $(document).on("click", ".vista_pendiente", function () {
      var id_pendiente = $(this).attr("data-event-id");
      $(this).partnersModal({
        ajaxUrl: settings.pendientes.ruta_vista_pendiente + id_pendiente,
        title: "Detalle Pendiente",
        modalId: "vista_pendiente_modal",
        forceWidth: 60,
      });
    });
    //***************************************************************
    //------------------------ VISTA PENDIENTE ----------------------
    //***************************************************************

    //***************************************************************
    //----------------------- CAPTURAR PENDIENTE --------------------
    //***************************************************************
    $(document).on("keypress", ":input:not(textarea)", function (e) {
      return e.keyCode != 13;
    });
    $(document).on("submit", "#new_pendiente_form", function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl("start");
      var datos = $("#new_pendiente_form").serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]["name"]] = datos[i]["value"];
      }

      var area_pendiente = $(".select_tipo_pendiente:checked").val();
      datosEnvio.area_pendiente = area_pendiente;

      // Tipo pendiente 1 : Pendiente Normal
      // Tipo pendiente 2 : Pendiente con Reporte de Servicio (Soporte)
      // Tipo pendiente 3 : Renovación
      // Tipo pendiente 4 : Pendiente con Reporte de Servicio y Proyecto (CCTV)
      // Tipo pendiente 9 : Pendiente con Reporte de Servicio (Soporte) CON POLIZAS DE PREPAGO
      // Tipo pendiente 10 : Pendiente CCTV con poliza, se sustituye por area 1 (Los detalles del pago se generan en el reporte de servicio)
      //      guarda el area en 9, el tipo en 2

      datosEnvio.tipo_clasificacion = $("#buscar_cliente").attr("data-tipo-clasificacion");
      if (area_pendiente == 1) {
        datosEnvio.tipo_pendiente = 4;
        if(datosEnvio.tipo_clasificacion == "P"){

          datosEnvio.pagado = true;
        }
      }
      else if (area_pendiente == 2 || area_pendiente == 9) {
        datosEnvio.tipo_pendiente = 2;
        if(area_pendiente == 9){
          datosEnvio.pagado = true;
        }
      }
      else {
        // Aqui se deberá de validar en un futuro para ver si son de renovación
        datosEnvio.tipo_pendiente = 1;
      }

      // Validar Cliente
      if (!$(".input_pendiente_otro").val()) {
        if (!$("#new_pendiente_form #buscar_cliente").attr("data-id-cliente")) {
          iziToast.error({
            title: "Error",
            message: "Por favor selecciona un cliente",
          });
          btn.partnersBtnControl("end");
          return false;
        } else {
          datosEnvio.id_cliente = $("#new_pendiente_form #buscar_cliente").attr(
            "data-id-cliente"
          );
        }
      }

      // Validar que si el area es de soporte o cctv solo se puedan generar pendientes a clientes no contactos
      if (
        (area_pendiente == 1 || area_pendiente == 2) &&
        $("#new_pendiente_form #buscar_cliente").attr("data-tipo-cliente") != 1
      ) {
        iziToast.error({
          title: "Error",
          message:
          "Para las áreas de soporte y CCTV solo puedes generar pendientes a clientes de tipo negocio y particular.",
        });
        btn.partnersBtnControl("end");
        return false;
      }

      // Validar Fecha
      if (
        !$("#fecha-pendiente-container .input-group.date").datepicker("getDate")
      ) {
        iziToast.error({
          title: "Error",
          message: "Por favor selecciona una fecha para agendar el pendiente.",
        });
        btn.partnersBtnControl("end");
        return false;
      } else {
        datosEnvio.fecha_pendiente = $(
          "#fecha-pendiente-container .input-group.date"
        ).datepicker("getDate");
      }
      if (+area_pendiente === 2) {
        datosEnvio.pagado = $("#pendiente_pagado_check").is(":checked");
      } else {
        datosEnvio.pagado = false;
      }

      datosEnvio.id_usuario_asignado = $(
        ".asignado_user option:selected"
      ).val();
      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: "POST",
        url: settings.pendientes.ruta_consultas + "new_pendiente",
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            search();
            $("#nuevo_pendiente_modal").modal("hide");
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //----------------------- CAPTURAR PENDIENTE --------------------
    //***************************************************************

    //***************************************************************
    //--------------------- PENDIENTES INFORM ERRORS ----------------
    //***************************************************************
    $(document).on("click", ".inform_errors", function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr("data-error-msg");
      error.err_time = $(this).attr("data-error-time");
      error.err_loc = $(this).attr("data-error-location");
      error.err_user = $(this).attr("data-error-user");
      error.err_user_id = $(this).attr("data-error-user-id");

      $.ajax({
        type: "POST",
        url: settings.pendientes.ruta_sys_tools + "report_error",
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            $(".modal").each(function () {
              $(this).modal("hide");
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false,
            });
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //--------------------- PENDIENTES INFORM ERRORS ----------------
    //***************************************************************

    //***************************************************************
    //----------------------- UPDATE ON EDIT SAVE  ------------------
    //***************************************************************
    $(document).on("click", ".save_edit_icon", function () {
      setTimeout(function () {
        search();
      }, 2000);
    });
    //***************************************************************
    //----------------------- UPDATE ON EDIT SAVE  ------------------
    //***************************************************************

    //***************************************************************
    //----------------------- FINALIZAR PENDIENTE  ------------------
    //***************************************************************
    $(document).on("change", "#switch_finalizar_pendiente", function () {
      var id_pendiente = $(this).attr("data-id-pendiente");
      var datos = {};
      datos.id_pendiente = id_pendiente;
      datos.val = $(this).is(":checked") ? 0 : 1;
      datos = JSON.stringify(datos);
      $.ajax({
        type: "POST",
        url: settings.pendientes.ruta_consultas + "finalizar_pendiente",
        data: datos,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          $("#vista_pendiente_modal").modal("hide");
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            search();
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //----------------------- FINALIZAR PENDIENTE  ------------------
    //***************************************************************

    //***************************************************************
    //-------------------- FINALIZAR PENDIENTE RENOVACIÓN  ----------
    //***************************************************************
    $(document).on("click", ".finalizar_pendiente_renovacion", function () {
      var id_pendiente = $(this).attr("data-id-pendiente");
      swal({
        title: "Renovación Relacionada",
        text: "Te autorizaron la renovación?",
        type: "warning",
        showCancelButton: true,
        cancelButtonText: "No",
        cancelButtonColor: "#DD6B55",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Si",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            var envio = {};
            envio.id_pendiente = id_pendiente;
            envio.type = 1;
            $.ajax({
              type: "POST",
              url:
                settings.pendientes.ruta_consultas +
                "finalizar_pendiente_renovacion",
              data: JSON.stringify(envio),
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == "success") {
                  resolve();
                  search();
                } else if (response.status == "error") {
                  swal.close();
                  iziToast.error({
                    title: "Error",
                    message: response.message,
                  });
                }
              },
              error: function (xhr) {
                swal.close();
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message:
                    "Request Status: " +
                    xhr.status +
                    " Status Text: " +
                    xhr.statusText,
                });
              },
            });
          });
        },
        allowOutsideClick: false,
        allowEscapeKey: false,
      }).then(function (a) {
        if (!a.dismiss) {
          swal({
            title: "Bien",
            text: "Se finalizó el pendiente y se autorizó la renovación, quieres generar un pendiente?",
            type: "success",
            showCancelButton: true,
            cancelButtonText: "No",
            cancelButtonColor: "#DD6B55",
            confirmButtonColor: "#3085d6",
            confirmButtonText: "Si",
          }).then(function (a) {
            if (!a.dismiss) {
              swal.close();
              $("#vista_pendiente_modal").modal("hide");
              setTimeout(function () {
                $(".nuevo_pendiente").click();
              }, 400);
            } else if (a.dismiss == "cancel") {
              swal.close();
              $("#vista_pendiente_modal").modal("hide");
            }
          });
        } else if (a.dismiss == "cancel") {
          swal({
            title: "Renovación No Autorizada!",
            text: "Indica porque no te autorizaron la renovación:",
            input: "textarea",
            inputPlaceholder: "No me autorizarón la renovación porque...",
            showCancelButton: true,
            cancelButtonText: "Regresar",
            confirmButtonColor: "#3085d6",
            confirmButtonText: "Finalizar",
            showLoaderOnConfirm: true,
            onOpen: function () {
              fixBootstrapModal();
            },
            preConfirm: function (inputValue) {
              return new Promise(function (resolve, reject) {
                if (inputValue.length < 1) {
                  reject("Trata de ser más descriptivo!");
                } else {
                  var envio = {};
                  envio.type = 2;
                  envio.id_pendiente = id_pendiente;
                  envio.motivo = inputValue;
                  $.ajax({
                    type: "POST",
                    url:
                      settings.pendientes.ruta_consultas +
                      "finalizar_pendiente_renovacion",
                    data: JSON.stringify(envio),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                      if (response.status == "success") {
                        restoreBootstrapModal();
                        setTimeout(function () {
                          swal.close();
                          $("#vista_pendiente_modal").modal("hide");
                        }, 4000);
                        search();
                        resolve();
                      } else if (response.status == "error") {
                        swal.close();
                        iziToast.error({
                          title: "Error",
                          message: response.message,
                        });
                      }
                    },
                    error: function (xhr) {
                      swal.close();
                      iziToast.error({
                        title: "Ocurrio un error: ",
                        message:
                          "Request Status: " +
                          xhr.status +
                          " Status Text: " +
                          xhr.statusText,
                      });
                    },
                  });
                }
              });
            },
            allowOutsideClick: false,
            allowEscapeKey: false,
          }).then(function (a) {
            if (!a.dismiss) {
              swal(
                "Bien!",
                "Se ha finalizado tu pendiente y se ha marcado la renovación como no autorizada",
                "success"
              );
            }
          });
        }
      });
    });
    //***************************************************************
    //-------------------- FINALIZAR PENDIENTE RENOVACIÓN  ----------
    //***************************************************************

    //***************************************************************
    //----------------------- ELIMINAR PENDIENTE  -------------------
    //***************************************************************
    $(document).on("click", ".eliminar_pendiente", function () {
      var type = $(this).attr("data-tipo-pendiente");
      var id_pendiente = $(this).attr("data-id-pendiente");
      var envio = {};
      envio.type = type;
      envio.id_pendiente = id_pendiente;
      // Pendiente Normal y Pendiente Renovación, en los de renovación no necesita actuar diferente
      if (type == 1 || type == 3) {
        swal({
          title: "Estás seguro?",
          text: "Una vez eliminado el pendiente no será posible recuperarlo!",
          type: "warning",
          showCancelButton: true,
          cancelButtonText: "No, cancelar",
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Si, estoy seguro!",
          showLoaderOnConfirm: true,
          onOpen: function () {
            fixBootstrapModal();
          },
          preConfirm: function () {
            return new Promise(function (resolve) {
              $.ajax({
                type: "POST",
                url: settings.pendientes.ruta_consultas + "delete_pendiente",
                data: JSON.stringify(envio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == "success") {
                    resolve();
                    search();
                    setTimeout(function () {
                      swal.close();
                      $("#vista_pendiente_modal").modal("hide");
                      iziToast.success({
                        title: "Bien! ",
                        message: response.message,
                      });
                    }, 2000);
                  } else if (response.status == "error") {
                    swal.close();
                    iziToast.error({
                      title: "Error",
                      message: response.message,
                    });
                  }
                },
                error: function (xhr) {
                  swal.close();
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message:
                      "Request Status: " +
                      xhr.status +
                      " Status Text: " +
                      xhr.statusText,
                  });
                },
              });
            });
          },
          allowOutsideClick: false,
          allowEscapeKey: false,
        }).then(function (a) {
          if (!a.dismiss) {
            swal(
              "Eliminado!",
              "El pendiente ha sido eliminado correctamente.",
              "success"
            );
          }
        });

        // Pendiente Reporte Servicio (Soporte)
      } else if (type == 2 || type == 4) {
        swal({
          title: "Cancelar Servicio!",
          text: "Indica porque quieres cancelar este servicio:",
          input: "textarea",
          inputPlaceholder: "Quiero cancelar el servicio porque...",
          showCancelButton: true,
          cancelButtonText: "Regresar",
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Solicitar cancelación",
          showLoaderOnConfirm: true,
          onOpen: function () {
            fixBootstrapModal();
          },
          preConfirm: function (inputValue) {
            return new Promise(function (resolve, reject) {
              if (
                inputValue === false ||
                inputValue == "" ||
                inputValue == undefined
              ) {
                reject("Trata de ser más descriptivo!");
              } else {
                envio.motivo = inputValue;
                $.ajax({
                  type: "POST",
                  url: settings.pendientes.ruta_consultas + "delete_pendiente",
                  data: JSON.stringify(envio),
                  contentType: "application/json; charset=utf-8",
                  dataType: "json",
                  success: function (response) {
                    if (response.status == "success") {
                      restoreBootstrapModal();
                      setTimeout(function () {
                        swal.close();
                        $("#vista_pendiente_modal").modal("hide");
                      }, 10000);
                      search();
                      resolve();
                    } else if (response.status == "error") {
                      swal.close();
                      iziToast.error({
                        title: "Error",
                        message: response.message,
                      });
                    }
                  },
                  error: function (xhr) {
                    swal.close();
                    iziToast.error({
                      title: "Ocurrio un error: ",
                      message:
                        "Request Status: " +
                        xhr.status +
                        " Status Text: " +
                        xhr.statusText,
                    });
                  },
                });
              }
            });
          },
          allowOutsideClick: false,
          allowEscapeKey: false,
        }).then(function (a) {
          if (!a.dismiss) {
            swal(
              "Bien!",
              "Tu solicitud se ha enviado a un supervisor, el cuál analizará tu petición y decidirá si cancela o no tu servicio. Durante la espera, el pendiente quedará en un estado inutilizable.",
              "success"
            );
          }
        });
      }
    });
    //***************************************************************
    //----------------------- ELIMINAR PENDIENTE  -------------------
    //***************************************************************

    //***************************************************************
    //--------------------- CLOSE PENDIENTE FOR REPORT --------------
    //***************************************************************
    $(document).on("click", ".close_bc_report", function () {
      $("#vista_pendiente_modal").modal("hide");
    });
    //***************************************************************
    //--------------------- CLOSE PENDIENTE FOR REPORT --------------
    //***************************************************************

    //***************************************************************
    //------------------- REVISAR CANCELACIÓN PENDIENTE  ------------
    //***************************************************************
    $(document).on("click", ".revisar_cancelacion_servicio", function () {
      var id_pendiente = $(this).attr("data-id-pendiente");
      var motivo = $(this).attr("data-motivo");

      swal({
        title: "Deseas cancelar el pendiente por el siguiente motivo?",
        text: motivo,
        type: "warning",
        showCancelButton: true,
        cancelButtonText: "Salir",
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar pendiente",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: "POST",
              url: settings.pendientes.ruta_consultas + "autorizar_cancelacion",
              data: JSON.stringify(id_pendiente),
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == "success") {
                  iziToast.success({
                    title: "Bien! ",
                    message: response.message,
                  });
                  resolve();
                } else if (response.status == "error") {
                  iziToast.error({
                    title: "Error",
                    message: response.message,
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message:
                    "Request Status: " +
                    xhr.status +
                    " Status Text: " +
                    xhr.statusText,
                });
              },
            });
          });
        },
        allowOutsideClick: false,
        allowEscapeKey: false,
      }).then(function (a) {
        if (!a.dismiss) {
          $("#vista_pendiente_modal").modal("hide");
          search();
        } else if (a.dismiss == "cancel") {
          swal.close();
        }
      });
    });
    //***************************************************************
    //------------------- REVISAR CANCELACIÓN PENDIENTE  ------------
    //***************************************************************

    //***************************************************************
    //-------------------- NUEVO PENDIENTE VENTAS -------------------
    //***************************************************************
    $(document).on("click", ".nuevo_pendiente_ventas", function () {
      $(this).partnersModal({
        ajaxUrl:
          settings.pendientes.render_template +
          "pendientes.nuevo_pendiente_ventas_form",
        title: "Pendiente para Ventas",
        modalSize: "modal-lg",
        modalId: "nuevo_pendiente_ventas_modal",
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: "#new_pendiente_ventas_form",
              errorMessageClass: "invalid-feedback",
              inputParentClassOnError: "text-danger",
              inputParentClassOnSuccess: "text-success",
              errorElementClass: "is-invalid",
            });

            $("#new_pendiente_ventas_form #buscar_cliente").typeahead({
              order: "asc",
              minlength: 1,
              maxItem: 15,
              hint: true,
              accent: true,
              group: {
                template: "{{group}}",
              },
              maxItemPerGroup: 5,
              backdrop: {
                "background-color": "#fff",
              },
              template: function (query, item) {
                var color_t_clasificacion;
                var tipo_clasificacion = item.tipo_clasificacion;
                var credito_contado = item.credito == 1 ? "Crédito" : "Contado";
                switch (tipo_clasificacion) {
                  case "a":
                    color_t_clasificacion = "success";
                    break;
                  case "b":
                    color_t_clasificacion = "success";
                    break;
                  case "c":
                    color_t_clasificacion = "warning";
                    break;
                  case "d":
                    color_t_clasificacion = "danger";
                    break;
                  case "e":
                    color_t_clasificacion = "danger";
                    break;
                  case "p":
                    color_t_clasificacion = "success";
                    credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas" : item.saldo_horas + " hora") ;
                    break;
                }
                tipo_clasificacion = tipo_clasificacion.toUpperCase();

                if (item.tipo_cliente != 3) {
                  return (
                    "<p>" +
                    "<span>{{nombre_cliente}}</span> " +
                    '<span class="float-right badge badge-' +
                    color_t_clasificacion +
                    '">' +
                    '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                    tipo_clasificacion +
                    " | " +
                    credito_contado +
                    "</span> </p> "
                  );
                } else {
                  return "<p><span>{{nombre_cliente}}</span> </p> ";
                }
              },
              dynamic: true,
              dropdownFilter: "Todos",
              emptyTemplate:
                '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
              source: {
                Clientes: {
                  display: [
                    "nombre_cliente",
                    "alias",
                    "email",
                    "nombre_facturacion",
                    "pagina_web",
                  ],
                  ajax: {
                    url: settings.pendientes.ruta_lista_clientes + "complete",
                    path: "data.datos.clientes",
                  },
                },
                Contactos: {
                  display: [
                    "nombre_cliente",
                    "alias",
                    "email",
                    "nombre_facturacion",
                    "pagina_web",
                  ],
                  ajax: {
                    url: settings.pendientes.ruta_lista_clientes + "complete",
                    path: "data.datos.contactos",
                  },
                },
                Proveedores: {
                  display: [
                    "nombre_cliente",
                    "alias",
                    "email",
                    "nombre_facturacion",
                    "pagina_web",
                  ],
                  ajax: {
                    url: settings.pendientes.ruta_lista_clientes + "complete",
                    path: "data.datos.proveedores",
                  },
                },
              },
              callback: {
                onClickAfter: function (node, a, item, event) {
                  var color_t_clasificacion;
                  var tipo_clasificacion = item.tipo_clasificacion;
                  var credito_contado =
                    item.credito == 1 ? "Crédito" : "Contado";
                  switch (tipo_clasificacion) {
                    case "a":
                      color_t_clasificacion = "success";
                      break;
                    case "b":
                      color_t_clasificacion = "success";
                      break;
                    case "c":
                      color_t_clasificacion = "warning";
                      break;
                    case "d":
                      color_t_clasificacion = "danger";
                      break;
                    case "e":
                      color_t_clasificacion = "danger";
                      break;
                    case "p":
                      color_t_clasificacion = "success";
                      credito_contado = "Saldo: " + (item.saldo_horas != 1 ? item.saldo_horas + " horas": item.saldo_horas + " hora") ;

                      if($(".select_tipo_pendiente:checked").val() == 2){
                        $(".select_tipo_pendiente:checked").val("9"); //prepago
                        $("#pendiente_pagado_check").attr("checked", "checked");
                        $("#pendiente_pagado_check").attr("disabled", "disabled");
                      }



                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();
                  if (item.tipo_cliente != 3) {
                    $(".quick_info_client").html(
                      '<span class="badge badge-' +
                        color_t_clasificacion +
                        '">' +
                        '<i class="fa fa-star" aria-hidden="true"></i>: ' +
                        tipo_clasificacion +
                        " | " +
                        credito_contado +
                        "</span> </p> "
                    );
                    const id_cliente = item.id_cliente;
                    if (tipo_clasificacion != "P") {
                      prepareEvs(1, {
                        color_t_clasificacion,
                        tipo_clasificacion,
                        credito_contado,
                        id_cliente,
                        settings,
                      });
                    }
                  }

                  //Bindear el id del cliente al input
                  node.attr("data-id-cliente", item.id_cliente);
                  node.attr("data-tipo-cliente", item.tipo_cliente);
                },
                onSearch: function (node, a, item, event) {
                  if (a !== "") {
                    // Resetear el valor el de otro en caso de que tenga algo
                    $(".input_pendiente_otro").val("");
                    $(".input_pendiente_otro").attr("disabled", 1);
                    $(".container_otro_pendiente").css("opacity", 0.5);
                  } else {
                    // Para prevenir errores de sobrescribir o duplicar
                    $(".quick_info_client").html("");
                    node.removeAttr("data-id-cliente");
                  }
                },
                onCancel: function () {
                  $(".input_pendiente_otro").removeAttr("disabled");
                  $(".container_otro_pendiente").css("opacity", 1);
                },
              },
            });
          }, 500);
        },
      });
    });

    $(document).on("submit", "#new_pendiente_ventas_form", function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl("start");
      var datos = $("#new_pendiente_ventas_form").serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]["name"]] = datos[i]["value"];
      }

      // Va directamente para ventas
      datosEnvio.area_pendiente = 3;

      // Será pendiente normal
      datosEnvio.tipo_pendiente = 1;

      if (
        !$("#new_pendiente_ventas_form #buscar_cliente").attr("data-id-cliente")
      ) {
        iziToast.error({
          title: "Error",
          message: "Por favor selecciona un cliente",
        });
        btn.partnersBtnControl("end");
        return false;
      } else {
        datosEnvio.id_cliente = $(
          "#new_pendiente_ventas_form #buscar_cliente"
        ).attr("data-id-cliente");
      }

      // Fecha actual por default
      datosEnvio.fecha_pendiente = moment().startOf("day").toString();

      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: "POST",
        url: settings.pendientes.ruta_consultas + "new_pendiente_ventas",
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == "success") {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
            });
            search();
            $("#nuevo_pendiente_ventas_modal").modal("hide");
          } else if (response.status == "error") {
            iziToast.error({
              title: "Error",
              message: response.message,
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message:
              "Request Status: " +
              xhr.status +
              " Status Text: " +
              xhr.statusText,
          });
        },
      });
    });
    //***************************************************************
    //-------------------- NUEVO PENDIENTE VENTAS -------------------
    //***************************************************************
  });
})(jQuery);
