(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//------------------- REPORTE BASE MERCANCIA  -------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120
    });


    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'DESC',
        sort_by: 'id_salida'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null,
        procesado: null,
        usuario: null
      }

    };

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_mercancia').stickyTableHeaders();
          $('#table_reporteador_mercancia').partnersfilter({
            table: '#table_reporteador_mercancia',
            sumatory: true,
            sumatory_cols: ["col-venta", "col-costo"]
          });
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_mercancia', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_mercancia").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

    // Filtrado - Usuario Recibe
    $(document).on('change', '#filtrado_usuario', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.usuario = $(this).find('option:selected').val();
      autoUpdate.forceUpdate();
    });
    // Filtrado - Usuario Recibe
    $(document).on('change', '#filtrado_procesado', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      if ($(this).find('option:selected').val() == 'Todos') {
        r_options.filter.procesado = null;
      } else {
        r_options.filter.procesado = $(this).find('option:selected').val();
      }
      autoUpdate.forceUpdate();
    });

    // Filtrado - Reset
    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      r_options.filter.procesado = null;
      r_options.filter.usuario = null;
      $('.input_buscador_mercancia').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });


//***************************************************************
//------------------- REPORTE BASE MERCANCIA  -------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************

//***************************************************************
//---------------------- NUEVA SALIDA MERCANCIA -----------------
//***************************************************************
    $(document).on('click', '.nueva_salida_mercancia', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Nueva Salida',
        ajaxUrl: settings.mercancia.render_template + 'mercancia.nueva_salida_form',
        forceWidth: 87,
        modalId: 'form-nueva-salida-modal',
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nueva_salida_mercancia_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });

            $('#buscar_cliente').typeahead({
              order: "asc",
              minlength: 1,
              maxItem: 15,
              hint: true,
              accent: true,
              group: {
                template: "{{group}}"
              },
              maxItemPerGroup: 5,
              backdrop: {
                "background-color": "#fff"
              },
              template: function (query, item) {
                var color_t_clasificacion;
                var tipo_clasificacion = item.tipo_clasificacion;
                switch (tipo_clasificacion) {
                  case 'a':
                    color_t_clasificacion = "success";
                    break;
                  case 'b':
                    color_t_clasificacion = "success";
                    break;
                  case 'c':
                    color_t_clasificacion = "warning";
                    break;
                  case 'd':
                    color_t_clasificacion = "danger";
                    break;
                  case 'e':
                    color_t_clasificacion = "danger";
                    break;
                }
                tipo_clasificacion = tipo_clasificacion.toUpperCase();

                var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                if (item.tipo_cliente != 3) {
                  return '<p>' +
                    '<span>{{nombre_cliente}}</span> ' +
                    '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
                    '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                    ' | ' + credito_contado + '</span> </p> ';
                } else {
                  return '<p><span>{{nombre_cliente}}</span> </p> ';
                }
              },
              dynamic: true,
              dropdownFilter: "Todos",
              emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
              source: {
                "Clientes": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.mercancia.ruta_lista_clientes + 'complete',
                    path: "data.datos.clientes"
                  }
                },
                "Contactos": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.mercancia.ruta_lista_clientes + 'complete',
                    path: "data.datos.contactos"
                  }
                },
                "Proveedores": {
                  display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                  ajax: {
                    url: settings.mercancia.ruta_lista_clientes + 'complete',
                    path: "data.datos.proveedores"
                  }
                }
              },
              callback: {
                onClickAfter: function (node, a, item) {
                  var color_t_clasificacion;
                  var tipo_clasificacion = item.tipo_clasificacion;
                  switch (tipo_clasificacion) {
                    case 'a':
                      color_t_clasificacion = "success";
                      break;
                    case 'b':
                      color_t_clasificacion = "success";
                      break;
                    case 'c':
                      color_t_clasificacion = "warning";
                      break;
                    case 'd':
                      color_t_clasificacion = "danger";
                      break;
                    case 'e':
                      color_t_clasificacion = "danger";
                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();
                  var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                  if (item.tipo_cliente != 3) {
                    $('.quick_info_client').html('<span class="badge badge-' + color_t_clasificacion + '">' +
                      '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                      ' | ' + credito_contado + '</span> </p> ');
                    const id_cliente = item.id_cliente;
                    prepareEvs(1, {
                      color_t_clasificacion,
                      tipo_clasificacion,
                      credito_contado,
                      id_cliente,
                      settings,
                    });
                  }


                  //Bindear el id del cliente al input
                  node.attr('data-id-cliente', item.id_cliente);

                  // Aqui verificar si el tipo de salida es de Centro de servicio, de ser así,
                  // buscar y mostrar los servicios relacionados con este cliente
                  if ($('.select_tipo_salida:checked').val() == 1) {
                    get_folios_centro_servicio(item.id_cliente);
                  }
                },
                onSearch: function (node, a) {
                  if (a !== '') {
                  } else {
                    // Para prevenir errores de sobrescribir o duplicar
                    $('.quick_info_client').html('');
                    node.removeAttr('data-id-cliente');
                  }


                }

              }
            });
            load_users('.lista_users');

          }, 400);
        }
      });
    });

    function get_folios_centro_servicio(id_cliente) {
      $('.container_tipo_salida').show();
      $('.container_tipo_salida_folio').show();
      $('.select_folios_from_clientes').empty();
      $('.select_folios_from_clientes').hide();
      $('.container_tipo_salida_folio').append(loader);
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'get_folios_centrodeservicio',
        data: JSON.stringify(id_cliente),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            if (response.message) {
              $.each(response.message, function (key, val) {
                $('.select_folios_from_clientes').append($('<option>').text('Folio: ' + val).val(val));
              });
            } else {
              $('.select_folios_from_clientes').append($('<option>').text('No hay cotizaciones autorizadas').val('0'));
            }
            $('.select_folios_from_clientes').show();
            $('.container_tipo_salida_folio').find('.sk-cube-grid').remove();

          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('change', '.select_tipo_salida', function () {
      /**
       * Tipos de Salida:
       * 1) Centro de Servicio
       * 2) Soporte Técnico
       * 3) Mercaado Libre
       * 4) Linio
       * 5) Otro
       */

      var $this = $(this);

      // Resetear todos los divs que se muestran
      $('.container_buscador_cliente').hide();
      $('.container_usuario_solicita').hide();
      $('.container_tipo_salida_motivo').hide();
      $('.container_tipo_salida_folio').hide();
      $('.container_tipo_salida_cotizacion').hide();
      $('.select_cotizaciones_from_clientes').empty();
      $('#buscar_cliente').val('');
      $('#buscar_cliente').removeAttr('data-id-cliente');
      $('.help-block.form-control-feedback').remove(); // Por alguna razón aveces se queda solo la advertencia de error sin ocultarse
      $('.container_numero_orden').hide();
      $('.container_remainder_salida_soporte').hide();
      // Eliminar el attr data-users-loaded para que vuelva a cargarlos
      $('.lista_users').removeAttr('data-users-loaded');
      $('.lista_users').removeAttr('data-users-ventas-loaded');


      $('.productos_container').show();
      if ($this.val() == 1) { // Centro de Servicio
        // Workflow:
        // 1) Se Muestra Cliente
        // 2) Se Muestra productos
        // 3) Se busca el cliente
        // 4) Se muestran los folios de centro de servicio relacionados con este cliente
        // 5) Se muestra el usuario que solicita al lado de los folios del cliente

        $('.container_buscador_cliente').show();
        load_users('.lista_users');
        $('.container_usuario_solicita').show();
      } else if ($this.val() == 2) { // Soporte técnico
        // Workflow:
        // 1) Se Muestra Cliente
        // 2) Se Muestra productos
        // 3) Se busca el cliente
        // 4) Se muestra usuario que solicita
        // 5) Se muestra motivos
        $('.container_buscador_cliente').show();
        $('.container_tipo_salida').show();
        $('.container_tipo_salida_motivo').show();
        load_users('.lista_users');
        $('.container_usuario_solicita').show();
        $('.container_remainder_salida_soporte').show();
      } else if ($this.val() == 3 || $this.val() == 4) { // Mercado Libre o Linio
        // 1) Se selecciona internamente mercadolibre
        // 2) Se muestran usuarios que solicitan (usuarios especificos de ventas)
        // 3) Se muestra el número de orden
        // 4) Se muestran los productos
        $('.container_tipo_salida').show();
        $('.container_numero_orden').show();
        load_users_ventas('.lista_users');
        $('.container_usuario_solicita').show();
      } else if ($this.val() == 5) { // Otro
        // 1) Se muestra el cliente
        // 2) Se muestran usuarios que solicitan
        // 3) Se muestra el motivo
        // 4) Se muestran los productos
        $('.container_buscador_cliente').show();
        $('.container_usuario_solicita').show();
        $('.container_tipo_salida').show();
        load_users('.lista_users');
        $('.container_tipo_salida_motivo').show();
      } else if ($this.val() == 6) { // CCTV
        // 1) Se muestra el cliente
        // 2) Se muestran usuarios que solicitan
        // 3) Se muestra el motivo
        // 4) Se muestran las cotizaciones
        // 5) Se muestran los productos
        $('.container_buscador_cliente').show();
        $('.container_usuario_solicita').show();
        $('.container_tipo_salida').show();
        load_users('.lista_users');
        $('.container_tipo_salida_motivo').show();
        $('.container_tipo_salida_cotizacion').show();
      }
    });

    $(document).on('change', 'select[name="usuario_solicita_salida"]', function () {
      if ($('.select_tipo_salida:checked').val() == 6) { // CCTV
        // Si es de CCTV, mostrar el select con las cotizaciones para poder vincular.
        var id_cliente = $('#buscar_cliente').attr('data-id-cliente');
        var datos = {};
        datos.id_cliente = id_cliente;
        datos.uid = $('select[name="usuario_solicita_salida"] option:selected').val();
        datos = JSON.stringify(datos);
        $('.select_cotizaciones_from_clientes').empty();
        $.ajax({
          type: 'POST',
          url: settings.mercancia.ruta_consultas + 'get_folios_cotizaciones',
          data: datos,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              if (response.message.length > 0) {
                $.each(response.message, function (key, val) {
                  $('.select_cotizaciones_from_clientes').append($('<option>').text('Cotización: ' + val).val(val));
                });
              } else {
                $('.select_cotizaciones_from_clientes').append($('<option>').text('Este cliente no cuenta con cotizaciones.'));
              }
            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }
    });

    $(document).on('click', '.agregar_nuevo_producto', function () {
      var upc = $('.upc_mercancia').val();
      var producto = $('.producto_mercancia').val();
      var serie = $('.serie_mercancia').val();
      var costo = $('.costo_mercancia').val();
      var venta = $('.venta_mercancia').val();
      var invalid = false;
      $('.upc_mercancia, .producto_mercancia, .serie_mercancia, .costo_mercancia, .venta_mercancia').validate(function (valid) {
        if (!valid) invalid = true;
      });

      if (!$.trim(upc).length) {
        iziToast.error({title: 'Error', message: 'Ingresa el UPC del producto'});
        return false;
      }
      if (!$.trim(producto).length) {
        iziToast.error({title: 'Error', message: 'Ingresa el nombre del producto'});
        return false;
      }

      if (!$.trim(serie).length) {
        iziToast.error({title: 'Error', message: 'Ingresa la Serie del producto'});
        return false;
      }
      if (!$.trim(costo).length) {
        iziToast.error({title: 'Error', message: 'Ingresa el Costo del producto'});
        return false;
      }
      if (invalid) return false;

      if (!$.trim(venta).length) venta = 0.00;
      var tr = $('<tr class="entity_producto_mercancia">' +
        '<td class="entity_producto_upc">' + upc + '</td>' +
        '<td class="entity_producto">' + producto + '</td>' +
        '<td class="entity_producto_serie">' + serie + '</td>' +
        '<td class="text-right entity_producto_costo">' + numeral(costo).format("0,0.00") + '</td>' +
        '<td class="text-right entity_producto_venta">' + numeral(venta).format("0,0.00") + '</td>' +
        '<td class="eliminar_entity_mercancia text-center text-danger cursor-pointer">Eliminar</td>' +
        '</tr>');
      $('.table-productos-mercancia tbody:last-child').append(tr);

      $('.upc_mercancia').val('');
      $('.producto_mercancia').val('');
      $('.serie_mercancia').val('');
      $('.costo_mercancia').val('');
      $('.venta_mercancia').val('');

      $('.upc_mercancia').focus();

    });

    $(document).on('click', '.eliminar_entity_mercancia', function () {
      $(this).parents('tr').remove();
    });

    $(document).on('keyup', '.upc_mercancia', function (e) {
      var val = $(this).val();
      if (e.keyCode == 13) {
        get_product_info(val, 1, '.producto_mercancia', '.serie_mercancia');
      } else {
        delay(function () {
          get_product_info(val, 1, '.producto_mercancia', '.serie_mercancia');
        }, 500);
      }

    });

    $(document).on('keyup', '.serie_mercancia', function (e) {
      var val = $(this).val();
      if (e.keyCode == 13) {
        get_product_info(val, 2, '.costo_mercancia', '.venta_mercancia');
      } else {
        delay(function () {
          get_product_info(val, 2, '.costo_mercancia', '.venta_mercancia');
        }, 500);
      }

    });

    /**
     *
     * @param val el actual valor para hacer la consulta
     * @param type el tipo de consulta, ya sea para traer el nombre o el costo del producto
     * @param input_to_return el input en el cual se escribirá el resultado
     * @param input_to_jump al input que dara focus una vez coloque el resultado en input_to_return
     */
    function get_product_info(val, type, input_to_return, input_to_jump) {
      if (!$.trim(val).length) return false;
      var envio = {};
      envio.val = val;
      envio.type = type;
      envio = JSON.stringify(envio);
      var dot = '.';
      var dots = setInterval(function () {
        $(input_to_return).val(dot);
        dot += '.';
        if (dot.length > 5) dot = '.';
      }, 200);

      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_sys_tools + 'load_producto_info_mercancia',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $(input_to_return).val(response.message);
            clearInterval(dots);
            $(input_to_jump).focus();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message,
              timeout: 2000
            });
            clearInterval(dots);
            $(input_to_return).val('');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
          clearInterval(dots);
          $(input_to_return).val('');
        }
      });
    }

//***************************************************************
//---------------------- NUEVA SALIDA MERCANCIA -----------------
//***************************************************************


//***************************************************************
//---------------------- CAPTURAR SALIDA MERCANCIA --------------
//***************************************************************
    $(document).on('keypress', ':input:not(textarea)', function (e) {
      return e.keyCode != 13;
    });
    $(document).on('submit', '#nueva_salida_mercancia_form', function (e) {
      e.preventDefault();

      if($('.select_tipo_salida:checked').val() == '1'){
        if($(".select_folios_from_clientes option:selected").val() == '0' || $(".select_folios_from_clientes option:selected").val() == ''){
          iziToast.error({
            title: 'Error',
            message: 'Debes seleccionar un folio con cotización autorizada'
          });
          return false;
        }
      }

      if ($('.entity_producto_mercancia').length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa al menos un producto a la salida.'
        });
        return false;
      }


      var tipo_salida = $('.select_tipo_salida:checked').val();


      // Solo validar que el cliente sea obligatior cuando no se seleccione los tipos de salida de Linio/MercadoLibre
      // El id_cliente lo tendré que poner aquí manualmente, ya que no lo puedo buscar porque en algún momento puede ser
      // posible que exista un cliente con un nombre similar y pueden ocurrir problemas en decidir cual es el bueno,
      // no deberia de haber problema al hacerlo así, porque los clientes no se pueden eliminar, solo cancelar, entonces
      // siempre existiria ese cliente con ese ID.
      if (tipo_salida == 1 || tipo_salida == 2 || tipo_salida == 5) {
        if (!$('#buscar_cliente').attr('data-id-cliente')) {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona a un cliente.'
          });
          return false;
        }
      }


      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#nueva_salida_mercancia_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      datosEnvio.productos = [];
      datosEnvio.tipo_salida = tipo_salida;
      var id_folio = 0;

      if (tipo_salida == 1) {
        // Centro de Servicio
        datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
        id_folio = $(".select_folios_from_clientes option:selected").val();
        datosEnvio.detalle = "Folio: " + id_folio;
      } else if (tipo_salida == 2) {
        // Soporte técnico
        datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
        datosEnvio.detalle = $('input[name="motivo_salida"]').val();
      } else if (tipo_salida == 3) {
        // Mercadlibre
        datosEnvio.id_cliente = 834;
        datosEnvio.detalle = $('input[name="numero_orden"]').val();
      } else if (tipo_salida == 4) {
        // Linio
        datosEnvio.id_cliente = 833;
        datosEnvio.detalle = $('input[name="numero_orden"]').val();
      } else if (tipo_salida == 5) {
        // Otro
        datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
        datosEnvio.detalle = $('input[name="motivo_salida"]').val();
      } else if (tipo_salida == 6) {
        // CCTV
        datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
        datosEnvio.detalle = $('input[name="motivo_salida"]').val();
        var id_cotizacion = $(".select_cotizaciones_from_clientes option:selected").val();
        if (isNaN(id_cotizacion)) {
          datosEnvio.id_cotizacion = null;
        } else {
          datosEnvio.id_cotizacion = id_cotizacion;
        }
      }

      $('.entity_producto_mercancia').each(function () {
        datosEnvio.productos.push({
          producto_upc: $(this).find('.entity_producto_upc').text(),
          producto_name: $(this).find('.entity_producto').text(),
          producto_serie: $(this).find('.entity_producto_serie').text(),
          producto_costo: $(this).find('.entity_producto_costo').text(),
          producto_venta: $(this).find('.entity_producto_venta').text()
        });
      });

      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'capturar_salida',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            if (id_folio != 0) {
              var id_vale = response.message;
              $('#form-nueva-salida-modal').modal('hide');
              $(this).partnersModal({
                title: 'Víncula las piezas',
                modalSize: 'modal-lg',
                modalId: 'vincular-piezas-modal',
                content: loader
              });
              var datos = {};
              datos.id_vale = id_vale;
              datos.id_folio = id_folio;
              datos.tipo = 1;

              $.ajax({
                type: 'POST',
                url: settings.mercancia.ruta_consultas + 'vincular_piezas_centrodeservicio',
                data: JSON.stringify(datos),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    $('#vincular-piezas-modal .modal-body').html(response.message);
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            } else {
              swal({
                title: 'Salida de mercancía generada correctamente',
                text: "Deseas imprimir los vales?",
                type: 'success',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#DD6B55',
                confirmButtonText: 'Si!',
                cancelButtonText: 'No',
                allowOutsideClick: false,
                allowEscapeKey: false,
                onClose: function () {
                  $('body').removeAttr('style');
                }
              }).then(function (a) {
                  if (!a.dismiss) {
                    swal.close();
                    iziToast.show({
                      color: 'dark',
                      icon: 'fa fa-usd',
                      title: 'Salida',
                      message: 'Cuál deseas ver?',
                      position: 'center',
                      progressBarColor: 'rgb(0, 255, 184)',
                      buttons: [
                        ['<button>Interno</button>', function (instance, toast) {
                          window.open(settings.mercancia.ruta_vista_salida + 1 + '/' + response.message);
                          $('#form-nueva-salida-modal').modal('hide');
                          autoUpdate.forceUpdate();
                          instance.hide({
                            transitionOut: 'fadeOutUp'
                          }, toast, 'close', 'btn1');
                        }],
                        ['<button>Cliente</button>', function (instance, toast) {
                          window.open(settings.mercancia.ruta_vista_salida + 2 + '/' + response.message);
                          $('#form-nueva-salida-modal').modal('hide');
                          autoUpdate.forceUpdate();
                          instance.hide({
                            transitionOut: 'fadeOutUp'
                          }, toast, 'close', 'btn2');
                        }]
                      ]
                    });
                  } else if (a.dismiss == 'cancel') {
                    swal.close();
                    $('#form-nueva-salida-modal').modal('hide');
                    autoUpdate.forceUpdate();
                  }
                }
              );
            }
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
          btn.partnersBtnControl('end');
        }
      });
    });
//***************************************************************
//---------------------- CAPTURAR SALIDA MERCANCIA --------------
//***************************************************************


//***************************************************************
//--------------- VINCULAR PIEZAS CENTRO DE SERVICIO  -----------
//***************************************************************
    $(document).on('click', '.guardar_vincular_piezas', function () {
      var id_vale = $(this).attr('data-id-vale');
      var id_folio = $(this).attr('data-id-folio');
      var btn = $(this);
      btn.partnersBtnControl('start');
      var datos = [];
      $('.row_pieza').each(function () {
        var costo = $(this).attr('data-costo');
        var id_pieza = $(this).find('.select_piezas_folio option:selected').val();
        datos.push({id_pieza: id_pieza, costo: costo});
      });

      var envio = {};
      envio.id_vale = id_vale;
      envio.id_folio = id_folio;
      envio.tipo = 2;
      envio.datos = datos;
      envio = JSON.stringify(envio);

      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'vincular_piezas_centrodeservicio',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#vincular-piezas-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//--------------- VINCULAR PIEZAS CENTRO DE SERVICIO  -----------
//***************************************************************


//***************************************************************
//---------------------- VISTA SALIDA MERCANCIA -----------------
//***************************************************************
    $(document).on('click', '.vista_salida', function () {
      var id_salida = $(this).parents('tr').attr('data-id-salida');
      iziToast.destroy();
      iziToast.show({
        color: 'dark',
        icon: 'fa fa-usd',
        title: 'Salida',
        message: 'Cuál deseas ver?',
        position: 'center',
        progressBarColor: 'rgb(0, 255, 184)',
        buttons: [
          ['<button>Interno</button>', function (instance, toast) {
            window.open(settings.mercancia.ruta_vista_salida + 1 + '/' + id_salida);
            instance.hide({
              transitionOut: 'fadeOutUp'
            }, toast, 'close', 'btn1');
          }],
          ['<button>Cliente</button>', function (instance, toast) {
            window.open(settings.mercancia.ruta_vista_salida + 2 + '/' + id_salida);
            instance.hide({
              transitionOut: 'fadeOutUp'
            }, toast, 'close', 'btn2');
          }]
        ]
      });
    });
//***************************************************************
//---------------------- VISTA SALIDA MERCANCIA -----------------
//***************************************************************

//***************************************************************
//------------------------ SALIDA  OBSERVACIONES ----------------
//***************************************************************
    $(document).on('click', '.status_obs', function () {
      var id_salida = $(this).parents('tr').attr('data-id-salida');
      $(this).partnersObs(
        {
          modalId: 'modal-salida-mercancia-observaciones',
          ajaxUrl: settings.mercancia.ruta_sys_tools + 'load_obs',
          index: 'id_salida',
          id_index: id_salida,
          tabla: 'partners_mercancia',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );


    });
//***************************************************************
//------------------------ SALIDA  OBSERVACIONES ----------------
//***************************************************************


//***************************************************************
//------------------------- STATUS PROCESAR  --------------------
//***************************************************************
    $(document).on('click', '.status_procesar', function () {
      var id_salida = $(this).parents('tr').attr('data-id-salida');
      var is_reporte = $(this).parents('tr').attr('data-is-reporte');
      var data_rejected = '';
      var template = '';
      if ($(this).attr('data-reject')) {
        data_rejected = 'data-reject="1"';
      }


      template += '<div class="row" id="procesar_salida">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-danger no_procesado w-100" data-id-salida="' + id_salida + '" role="button">No</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-success si_procesado w-100" ' + data_rejected + ' data-id-salida="' + id_salida + '" role="button">Procesado</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning regresado_procesado w-100" data-id-salida="' + id_salida + '" role="button">Regresado</button></div>';

      // De esta forma solamente se está limitando el uso al botón de especial para las salidas de mercancia relacionadas con reportes de servicios.
      if (is_reporte == 1) {
        template += '<div class="col-md-3"><button type="button" class="btn btn-outline-success si_procesado_especial" data-id-salida="' + id_salida + '" role="button">Especial</button></div>';
      }
      template += '</div>';

      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 40,
        modalId: 'modal-procesar-salida',
        noFooter: true
      });

    });

    $(document).on('click', '.no_procesado', function () {
      var id_salida = $(this).attr('data-id-salida');
      var clicked_td = $('tr[data-id-salida="' + id_salida + '"] .status_procesar');
      var new_val = 0;
      var envio = {};
      envio.id_salida = id_salida;
      envio.new_val = new_val;
      envio.col = 'procesado';
      envio = JSON.stringify(envio);
      $('#modal-procesar-salida').modal('hide');
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            clicked_td.removeClass('status-green');
            clicked_td.addClass('status-red');
            clicked_td.html('No');
            iziToast.success({
              title: "Bien! ",
              message: "Cambios guardados",
              timeout: 1000,
              position: 'bottomLeft'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });

    $(document).on('click', '.si_procesado', function () {

      if ($(this).attr('data-reject')) {
        iziToast.error({
          title: 'Error',
          message: 'No se puede procesar hasta que las piezas sean reportadas como servicio'
        });
        return false;
      }

      var id_salida = $(this).attr('data-id-salida');
      var clicked_td = $('tr[data-id-salida="' + id_salida + '"] .status_procesar');
      $('#modal-procesar-salida').modal('hide');

      var new_val = 1;
      var envio = {};
      envio.id_salida = id_salida;
      envio.new_val = new_val;
      envio.col = 'procesado';
      swal({
        title: 'Motivo',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.mercancia.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Si');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });
    });

    $(document).on('click', '.si_procesado_especial', function () {

      if ($(this).attr('data-reject')) {
        iziToast.error({
          title: 'Error',
          message: 'No se puede procesar hasta que las piezas sean reportadas como servicio'
        });
        return false;
      }

      var id_salida = $(this).attr('data-id-salida');
      var clicked_td = $('tr[data-id-salida="' + id_salida + '"] .status_procesar');
      $('#modal-procesar-salida').modal('hide');

      var new_val = 3;
      var envio = {};
      envio.id_salida = id_salida;
      envio.new_val = new_val;
      envio.col = 'procesado';
      swal({
        title: 'Motivo Especial',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              envio.obs = "Motivo Especial: " + reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.mercancia.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-purple');
          clicked_td.html('Especial');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });
    });

    $(document).on('click', '.regresado_procesado', function () {
      var id_salida = $(this).attr('data-id-salida');
      var clicked_td = $('tr[data-id-salida="' + id_salida + '"] .status_procesar');
      $('#modal-procesar-salida').modal('hide');

      var new_val = 2;
      var envio = {};
      envio.id_salida = id_salida;
      envio.new_val = new_val;
      envio.col = 'procesado';
      swal({
        title: 'Motivo',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.mercancia.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Regresado');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });
    });


//***************************************************************
//------------------------- STATUS PROCESAR  --------------------
//***************************************************************


//***************************************************************
//-------------------------- EDITAR SALIDA   --------------------
//***************************************************************
    $(document).on('click', '.editar_salida', function () {
      var id_salida = $(this).parents('tr').attr('data-id-salida');
      var envio = {};
      envio.type = 1;
      envio.id_salida = id_salida;
      envio = JSON.stringify(envio);
      $(this).partnersModal({
        title: 'Editar Salida',
        modalId: 'editar-salida-modal',
        forceWidth: 90,
        modalTitleAlign: 'left',
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'editar_mercancia',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#editar-salida-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.agregar_nuevo_producto_edicion', function () {
      var upc = $('.upc_mercancia_editar').val();
      var producto = $('.producto_mercancia_editar').val();
      var serie = $('.serie_mercancia_editar').val();
      var costo = $('.costo_mercancia_editar').val();
      var venta = $('.venta_mercancia_editar').val();

      if (!$.trim(upc).length) {
        iziToast.error({title: 'Error', message: 'Ingresa el UPC del producto'});
        return false;
      }
      if (!$.trim(producto).length) {
        iziToast.error({title: 'Error', message: 'Ingresa el nombre del producto'});
        return false;
      }

      if (!$.trim(serie).length) {
        iziToast.error({title: 'Error', message: 'Ingresa la Serie del producto'});
        return false;
      }
      if (!$.trim(costo).length) {
        iziToast.error({title: 'Error', message: 'Ingresa el Costo del producto'});
        return false;
      }

      if (!$.trim(venta).length) venta = 0.00;

      var tr = $('<tr data-nuevo="1" class="entity_pieza_mercancia"  data-venta="' + venta + '" data-costo="' + costo + '" data-serie="' + serie + '" data-producto="' + producto + '"  data-upc="' + upc + '">' +
        '<td>' + upc + '</td>' +
        '<td>' + producto + '</td>' +
        '<td>' + serie + '</td>' +
        '<td class="text-right">' + numeral(costo).format("0,0.00") + '</td>' +
        '<td class="text-right">' + numeral(venta).format("0,0.00") + '</td>' +
        '<td class="cursor-pointer text-center text-danger eliminar_tr_editar_mercancia">Eliminar</td>' +
        '</tr>');

      $('.table-editar-mercancia tbody:last-child').append(tr);

      $('.upc_mercancia_editar').val('');
      $('.producto_mercancia_editar').val('');
      $('.serie_mercancia_editar').val('');
      $('.costo_mercancia_editar').val('');
      $('.venta_mercancia_editar').val('');
    });

    $(document).on('click', '.eliminar_tr_mercancia_editar', function () {
      var $this = $(this);
      // Preguntar motivo de porque lo eliminan
      swal({
        title: 'Motivo de eliminación',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Eliminar',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-danger',
        cancelButtonClass: 'btn btn-primary',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
          restoreBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          console.log(reason.length);
          if ($.trim(reason).length == 0) {
            swal.showValidationError("Ingresa un motivo!");
          } else {
            var id_pieza = $this.parents('tr').attr('data-id-pieza');
            var new_div = $('<div class="eliminated_tr" data-id-pieza="' + id_pieza + '" data-motivo="' + reason + '"></div>');
            if (id_pieza) {
              $('.eliminated_tr_container').append(new_div);
            }
            $this.parents('tr').remove();
          }
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal.close();
        }
      });
    });

    $(document).on('keyup', '.upc_mercancia_editar', function (e) {
      var val = $(this).val();
      if (e.keyCode == 13) {
        get_product_info(val, 1, '.producto_mercancia_editar', '.serie_mercancia_editar');
      } else {
        delay(function () {
          get_product_info(val, 1, '.producto_mercancia_editar', '.serie_mercancia_editar');
        }, 500);
      }

    });

    $(document).on('keyup', '.serie_mercancia_editar', function (e) {
      var val = $(this).val();
      if (e.keyCode == 13) {
        get_product_info(val, 2, '.costo_mercancia_editar', '.venta_mercancia_editar');
      } else {
        delay(function () {
          get_product_info(val, 2, '.costo_mercancia_editar', '.venta_mercancia_editar');
        }, 500);
      }

    });

    $(document).on('click', '.guardar_edicion_mercancia', function () {
      if (!$('.table-editar-mercancia tbody tr').length) {
        iziToast.error({
          title: 'Error',
          message: 'La salida de mercancía no puede quedar sin productos.'
        });
      } else {
        $(this).partnersBtnControl('start');
        var id_salida = $(this).attr('data-id-salida');
        var new_elements = [];
        $('.table-editar-mercancia .entity_pieza_mercancia').each(function () {
          if ($(this).attr('data-nuevo') == 1) {
            new_elements.push({
              upc: $(this).attr('data-upc'),
              producto: $(this).attr('data-producto'),
              serie: $(this).attr('data-serie'),
              costo: $(this).attr('data-costo'),
              venta: $(this).attr('data-venta')
            });
          }

        });

        var deleted_elements = [];
        $('.eliminated_tr_container .eliminated_tr').each(function () {
          deleted_elements.push({
            id_pieza: $(this).attr('data-id-pieza'),
            motivo: $(this).attr('data-motivo')
          });
        });

        var envio = {};
        envio.deleted_elements = deleted_elements;
        envio.new_elements = new_elements;
        envio.id_salida = id_salida;
        envio.type = 2;
        envio = JSON.stringify(envio);

        $.ajax({
          type: 'POST',
          url: settings.mercancia.ruta_consultas + 'editar_mercancia',
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              const folioTaller = document.getElementById("folio_taller").value;
              if(folioTaller > 0) {

                var id_vale = id_salida;
                $('#editar-salida-modal').modal('hide');
                $(this).partnersModal({
                  title: 'Víncula las piezas',
                  modalSize: 'modal-lg',
                  modalId: 'vincular-piezas-modal',
                  content: loader,
                  preventHideOnBackdrop: true
                });
                var datos = {};
                datos.id_vale = id_vale;
                datos.id_folio = folioTaller;
                datos.tipo = 1;

                $.ajax({
                  type: 'POST',
                  url: settings.mercancia.ruta_consultas + 'vincular_piezas_centrodeservicio',
                  data: JSON.stringify(datos),
                  contentType: "application/json; charset=utf-8",
                  dataType: "json",
                  success: function (response) {
                    if (response.status == 'success') {
                      $('#vincular-piezas-modal .modal-body').html(response.message);
                      autoUpdate.forceUpdate();
                    } else if (response.status == 'error') {
                      iziToast.error({
                        title: "Error",
                        message: response.message
                      });
                    }
                  },
                  error: function (xhr) {
                    iziToast.error({
                      title: "Ocurrio un error: ",
                      message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                  }
                });
limpio              } else {
                iziToast.success({
                  title: "Bien! ",
                  message: response.message,
                  timeout: 1000,
                  position: 'bottomLeft'
                });
                autoUpdate.forceUpdate();
                $('#editar-salida-modal').modal('hide');
              }
            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });

      }
    });
//***************************************************************
//-------------------------- EDITAR SALIDA   --------------------
//***************************************************************


//***************************************************************
//-------------------------- ELIMINAR SALIDA --------------------
//***************************************************************
    $(document).on('click', '.eliminar_salida', function () {
      var id_salida = $(this).parents('tr').attr('data-id-salida');
      swal({
        title: "Estás Seguro?",
        html: "Deseas eliminar la salida " + id_salida + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: 'POST',
              url: settings.mercancia.ruta_consultas + 'eliminar_salida',
              data: id_salida,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  autoUpdate.forceUpdate();
                  setTimeout(function () {
                    undo_salida_deleted(id_salida);
                    swal.close();
                  }, 2000);
                  resolve()
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal("Eliminado!", "La salida de mercancía se ha eliminado correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_salida_deleted(id_salida) {
      iziToast.show({
        title: 'Salida ' + id_salida,
        message: ' ha sido eliminada.',
        position: 'bottomLeft',
        timeout: 10000,
        color: 'dark',
        progressBarColor: 'rgb(0, 255, 184)',
        icon: 'fa fa-ban',
        buttons: [
          ['<button data-id-salida="' + id_salida + '" class="salida_undo_delete">Deshacer</button>', function (instance, toast) {
            instance.hide({
              transitionOut: 'fadeOutUp'
            }, toast, 'close');
          }]
        ]
      });
    }

    $(document).on('click', '.salida_undo_delete', function () {
      var id_salida = $(this).attr('data-id-salida');
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'reactivate_salida',
        data: id_salida,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Salida ' + id_salida,
              message: ' ha sido traida de vuelta a la vida!',
              icon: 'fa fa-usd'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//-------------------------- ELIMINAR SALIDA --------------------
//***************************************************************


//***************************************************************
//---------------------- VISTA DETALLADA SALIDA  ----------------
//***************************************************************
    $(document).on('click', '.vista_detalle_salida', function () {
      var id_salida = $(this).parents('tr').attr('data-id-salida');
      $(this).partnersModal({
        title: 'Detalle Salida ' + id_salida,
        modalId: 'vista-detalle-modal',
        forceWidth: 80,
        content: loader
      });

      var envio = JSON.stringify(id_salida);
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'vista_detallada_salida',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-detalle-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//---------------------- VISTA DETALLADA SALIDA  ----------------
//***************************************************************


//***************************************************************
//--------------------------- LOAD USERS  -----------------------
//***************************************************************
    function load_users(select) {
      select = $(select);
      if (select.attr('data-users-loaded')) return false;
      select.find('option').each(function () {
        if ($(this).attr('data-remove')) {
          $(this).remove();
        }
      });
      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_sys_tools + 'user_list',
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $.each(JSON.parse(response.message), function (key, val) {
              select.append('<option value="' + val.uid + '" data-remove="1">' + val.name + '</option>');
            });
            select.attr('data-users-loaded', 1);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

//***************************************************************
//--------------------------- LOAD USERS  -----------------------
//***************************************************************

//***************************************************************
//------------------------ LOAD USERS VENTAS --------------------
//***************************************************************
    function load_users_ventas(select) {
      select = $(select);
      if (select.attr('data-users-ventas-loaded')) return false;
      select.find('option').each(function () {
        if ($(this).attr('data-remove')) {
          $(this).remove();
        }
      });

      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_consultas + 'ventas_user_list',
        data: JSON.stringify("Ventas"),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $.each(JSON.parse(response.message), function (key, val) {
              select.append('<option value="' + val.uid + '" data-remove="1">' + val.name + '</option>');
            });
            select.attr('data-users-ventas-loaded', 1);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

//***************************************************************
//------------------------ LOAD USERS VENTAS --------------------
//***************************************************************


//***************************************************************
//--------------------- MERCANCIA INFORM ERRORS -----------------
//***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.mercancia.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
//***************************************************************
//--------------------- MERCANCIA INFORM ERRORS -----------------
//***************************************************************


  });
})
(jQuery);
