(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

//***************************************************************
//------------ REPORTE BASE SOLICITUD RECLASIFICACION  ----------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });
    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'id_sugerencia'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.log.ruta_consultas + 'reporte_base_solicitud_reclasificacion',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_sugerencias').partnersfilter();
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    reporte_base();
//***************************************************************
//------------ REPORTE BASE SOLICITUD RECLASIFICACION  ----------
//***************************************************************

//***************************************************************
//-------------------------- MARCAR VISTO -----------------------
//***************************************************************
    $(document).on('click', '.cambiar_status_sugerencia', function(){
      var newVal = $(this).parents('tr').attr('data-sugerencia-atendida') == 1 ? 0 : 1;
      var idSugerencia = $(this).parents('tr').attr('data-id-sugerencia');
      $.ajax({
        type: 'POST',
        url: settings.log.ruta_consultas + 'update_status_sugerencia',
        data: JSON.stringify({newVal, idSugerencia}),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            reporte_base();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//-------------------------- MARCAR VISTO -----------------------
//***************************************************************
  });
})
(jQuery);