(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    //***************************************************************
    //------------ REPORTE BASE SOLICITUD RECLASIFICACION  ----------
    //***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });
    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'pc.created_at'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      },
      // Este nuevo valor es para elegir los usuarios que pueden ser seleccionados
      users: [26]
    };

    // Obtener todos los elementos checkbox de usuarios
    var checkboxes = document.querySelectorAll('.form-check-input');

    // Agregar un event listener a cada checkbox
    checkboxes.forEach(function (checkbox) {
      checkbox.addEventListener('change', function () {
        // Verificar si el checkbox está marcado o desmarcado
        if (this.checked) {
          // Agregar el valor del checkbox al arreglo si está marcado
          r_options.users.push(Number(this.value));
        } else {
          // Remover el valor del checkbox del arreglo si está desmarcado
          var index = r_options.users.indexOf(Number(this.value));
          if (index !== -1) {
            r_options.users.splice(index, 1);
          }
        }
        autoUpdate.forceUpdate();

      });
    });
    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.log.ruta_consultas + 'reporte_base_reporte_clientes_nuevos',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_reporte_nuevos_clientes').partnersfilter({}, function () { calcularTotalRows(); });
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;


          setTimeout(function () {
            calcularTotalRows();
          }, 200);
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    function calcularTotalRows() {
      let totalRows = 0;
      $('#table_reporteador_reporte_nuevos_clientes tbody tr').each(function (a, b) {
        if ($(b).is(':visible')) {
          totalRows++;
        }
      });

      $('#total_rows_count').html(totalRows);
    }
    //***************************************************************
    //------------ REPORTE BASE SOLICITUD RECLASIFICACION  ----------
    //***************************************************************

    // ***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);
    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });
    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
    //***************************************************************
    //------------------------ DATE PICKER --------------------------
    //***************************************************************

  });
})
  (jQuery);