(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

//***************************************************************
//----------------------- REPORTE BASE LOG ----------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });
    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'DESC',
        sort_by: 'id_action'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.log.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_log').partnersfilter();
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

  //***************************************************************
  //----------------------- REPORTE BASE LOG ----------------------
  //***************************************************************

  // ***************************************************************
  //------------------------ DATE PICKER --------------------------
  //***************************************************************
    var start = moment().startOf('day');
    var end = moment().endOf('day');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);
    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });
    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************

//***************************************************************
//-------------------- REVISAR DATOS DE CLIENTE -----------------
//***************************************************************
    $(document).on('click', '.revisar_datos', function () {
      if ($.trim($('.from_a').val()) == '' || $.trim($('.to_b').val()) == '') {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa los id de clientes'
        });
        return false;
      }
      var btn = $(this);
      btn.partnersBtnControl('start');
      var datos = {};
      datos.from = $('.from_a').val();
      datos.to = $('.to_b').val();

      $.ajax({
        type: 'POST',
        url: settings.log.ruta_consultas + 'fix_clientes_revisar',
        data: JSON.stringify(datos),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var data = JSON.parse(response.message);

            if (data.success_from == "true") {
              $('#reporteador1-title').html(data.nombre_from);
              $('#reporteador1').html(data.tabla_from);
            } else {
              $('#reporteador1-title').html("No existe ningún cliente con ese ID");
              $('#reporteador1').html('');
            }

            if (data.success_to == "true") {
              $('#reporteador2-title').html(data.nombre_to);
              $('#reporteador2').html(data.tabla_to);
            } else {
              $('#reporteador2-title').html("No existe ningún cliente con ese ID");
              $('#reporteador2').html('');
            }

            if (data.success_from == "true" && data.success_to == "true") {
              $('.mover_datos').removeAttr('disabled');
            } else {
              $('.mover_datos').attr('disabled', 'disabled');
            }

            btn.partnersBtnControl('end');


          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//-------------------- REVISAR DATOS DE CLIENTE -----------------
//***************************************************************


//***************************************************************
//-------------------------- MOVER DATOS  -----------------------
//***************************************************************
    $(document).on('click', '.mover_datos', function () {
      if ($.trim($('.from_a').val()) == '' || $.trim($('.to_b').val()) == '') {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa los id de clientes'
        });
        return false;
      }
      var btn = $(this);
      btn.partnersBtnControl('start');
      var datos = {};
      datos.from = $('.from_a').val();
      datos.to = $('.to_b').val();


      swal({
        title: "Estás Seguro?",
        html: "Deseas mover todos los datos que tiene : <span style='font-weight: 700;'>" + $('#reporteador1-title').html() + "</span> a <span style='font-weight: 700;'>" + $('#reporteador2-title').html() + "</span>",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, mover!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: 'POST',
              url: settings.log.ruta_consultas + 'fix_clientes_mover',
              data: JSON.stringify(datos),
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  resolve();
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (a.dismiss == 'cancel') {
          swal("Bien!", "Todos los datos se han movido correctamente.", "success");
          $('.revisar_datos').click();
        }
      });


    });
//***************************************************************
//-------------------------- MOVER DATOS  -----------------------
//***************************************************************

  });
})
(jQuery);