(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

//***************************************************************
//-------------------- REVISAR DATOS DE CLIENTE -----------------
//***************************************************************
        $(document).on('click', '.revisar_datos', function () {
            if ($.trim($('.from_a').val()) == '' || $.trim($('.to_b').val()) == '') {
                iziToast.error({
                    title: 'Error',
                    message: 'Ingresa los id de clientes'
                });
                return false;
            }
            var btn = $(this);
            btn.partnersBtnControl('start');
            var datos = {};
            datos.from = $('.from_a').val();
            datos.to = $('.to_b').val();

            $.ajax({
                type: 'POST',
                url: settings.log.ruta_consultas + 'fix_clientes_revisar',
                data: JSON.stringify(datos),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        var data = JSON.parse(response.message);

                        if (data.success_from == "true") {
                            $('#reporteador1-title').html(data.nombre_from);
                            $('#reporteador1').html(data.tabla_from);
                        } else {
                            $('#reporteador1-title').html("No existe ningún cliente con ese ID");
                            $('#reporteador1').html('');
                        }

                        if (data.success_to == "true") {
                            $('#reporteador2-title').html(data.nombre_to);
                            $('#reporteador2').html(data.tabla_to);
                        } else {
                            $('#reporteador2-title').html("No existe ningún cliente con ese ID");
                            $('#reporteador2').html('');
                        }

                        if (data.success_from == "true" && data.success_to == "true") {
                            $('.mover_datos').removeAttr('disabled');
                        } else {
                            $('.mover_datos').attr('disabled', 'disabled');
                        }

                        btn.partnersBtnControl('end');


                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                        btn.partnersBtnControl('end');
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });
//***************************************************************
//-------------------- REVISAR DATOS DE CLIENTE -----------------
//***************************************************************


//***************************************************************
//-------------------------- MOVER DATOS  -----------------------
//***************************************************************
        $(document).on('click', '.mover_datos', function () {
            if ($.trim($('.from_a').val()) == '' || $.trim($('.to_b').val()) == '') {
                iziToast.error({
                    title: 'Error',
                    message: 'Ingresa los id de clientes'
                });
                return false;
            }
            var btn = $(this);
            btn.partnersBtnControl('start');
            var datos = {};
            datos.from = $('.from_a').val();
            datos.to = $('.to_b').val();


            swal({
                title: "Estás Seguro?",
                html: "Deseas mover todos los datos que tiene : <span style='font-weight: 700;'>" + $('#reporteador1-title').html() + "</span> a <span style='font-weight: 700;'>" + $('#reporteador2-title').html() + "</span>",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, mover!",
                cancelButtonText: "No!",
                showLoaderOnConfirm: true,
                onOpen: function () {
                    fixBootstrapModal();
                },
                preConfirm: function () {
                    return new Promise(function (resolve) {
                        $.ajax({
                            type: 'POST',
                            url: settings.log.ruta_consultas + 'fix_clientes_mover',
                            data: JSON.stringify(datos),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                if (response.status == 'success') {
                                    resolve();
                                } else if (response.status == 'error') {
                                    iziToast.error({
                                        title: "Error",
                                        message: response.message
                                    });
                                }
                            },
                            error: function (xhr) {
                                iziToast.error({
                                    title: "Ocurrio un error: ",
                                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                });
                            }
                        });
                    });
                },
                allowOutsideClick: false
            }).then(function () {
                swal("Bien!", "Todos los datos se han movido correctamente.", "success");
                $('.revisar_datos').click();
            }, function (dismiss) {
                if (dismiss === 'cancel') {
                    swal.close();
                    btn.partnersBtnControl('end');
                }
            });


        });
//***************************************************************
//-------------------------- MOVER DATOS  -----------------------
//***************************************************************

    });
})
(jQuery);