(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

//***************************************************************
//--------------- BUSCAR PRODUCTO Y COMPARAR PRECIOS  -----------
//***************************************************************
    $(document).on('click', '.buscar_datos_producto', function () {
      if ($.trim($('.sku_producto').val()) == '' && $.trim($('.desc_producto').val()) == '') {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa el sku o la descripción del producto a buscar.'
        });
        return false;
      }

      var searchBy, skuProducto;
      if ($.trim($('.sku_producto').val()) == '') {
        searchBy = 'desc';
        skuProducto = $('.desc_producto').val();
      } else {
        searchBy = 'sku';
        skuProducto = $('.sku_producto').val();
      }

      var btn = $(this);
      btn.partnersBtnControl('start');
      $('#reporteador').hide();
      $.ajax({
        type: 'POST',
        url: settings.log.ruta_consultas + 'comparar_precios',
        data: JSON.stringify({skuProducto: skuProducto, searchBy: searchBy}),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#reporteador').show();
            var data = response.message;
            var trPCH = '';
            var trCVA = '';
            var finalTrs = '';
            // Si no hay información en pch, mostrar error.
            if (!data.pch.data) {
              trPCH = '<tr><td>PCH</td><td colspan="9">' + data.pch.message + '</td></tr>';
            } else {
              var dataPCH = data.pch.data;

              for (var i = 0; i < dataPCH.length; i++) {
                trPCH += '<tr>' +
                  '<td>PCH</td>' +
                  '<td>' + dataPCH[i].clave + '</td>' +
                  '<td>' + dataPCH[i].descripcion + '</td>' +
                  '<td>' + dataPCH[i].skuFabricante + '</td>' +
                  '<td>' + dataPCH[i].marca + '</td>' +
                  '<td class="text-right">' + numeral(dataPCH[i].precio).format('0,0.00') + '</td>' +
                  '<td class="text-right">' + dataPCH[i].moneda + '</td>' +
                  '<td class="text-center">' + dataPCH[i].inventario.gdl + '</td>' +
                  '<td class="text-center">' + dataPCH[i].inventario.df + '</td>' +
                  '</tr>';
              }
            }


            // Si no hay información en cva, mostrar error.
            if (!data.cva.data) {
              trCVA = '<tr><td>CVA</td><td colspan="9">' + data.cva.message + '</td></tr>';
            } else {
              var dataCVA = data.cva.data;
              for (var i = 0; i < dataCVA.length; i++) {
                trCVA += '<tr>' +
                  '<td>CVA</td>' +
                  '<td>' + dataCVA[i].clave + '</td>' +
                  '<td>' + dataCVA[i].descripcion + '</td>' +
                  '<td>' + dataCVA[i].skuFabricante + '</td>' +
                  '<td>' + dataCVA[i].marca + '</td>' +
                  '<td class="text-right">' + numeral(dataCVA[i].precio).format('0,0.00') + '</td>' +
                  '<td class="text-right">' + dataCVA[i].moneda + '</td>' +
                  '<td class="text-center">' + dataCVA[i].inventario.gdl + '</td>' +
                  '<td class="text-center">' + dataCVA[i].inventario.df + '</td>' +
                  '</tr>';
              }
            }

            finalTrs += trPCH;
            finalTrs += trCVA;
            $('#reporteador tbody').html(finalTrs);

            btn.partnersBtnControl('end');

          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });


    $(document).on('change keyup', '.desc_producto', function () {
      $('.sku_producto').val('');
    });

    $(document).on('change keyup', '.sku_producto', function () {
      $('.desc_producto').val('');
    });
//***************************************************************
//--------------- BUSCAR PRODUCTO Y COMPARAR PRECIOS  -----------
//***************************************************************
  });
})
(jQuery);