// eslint-disable-next-line no-underscore-dangle,no-undef
const _firma$ = jQuery;

let MODAL;
let MODAL_BODY;
let FIRMA_ID = 0;

const LOADER = '<div class="sk-cube-grid">'
  + '<div class="sk-cube sk-cube1"></div>'
  + '<div class="sk-cube sk-cube2"></div>'
  + '<div class="sk-cube sk-cube3"></div>'
  + '<div class="sk-cube sk-cube4"></div>'
  + '<div class="sk-cube sk-cube5"></div>'
  + '<div class="sk-cube sk-cube6"></div>'
  + '<div class="sk-cube sk-cube7"></div>'
  + '<div class="sk-cube sk-cube8"></div>'
  + '<div class="sk-cube sk-cube9"></div></div>';

const ERROR_TEMPLATE = `
    <div class="mt-5 alert alert-info">Ocurrió un error al cargar los datos.</div>
    <div class="mt-2 text-right">
                    <button type="button" class="btn btn-danger w-100 text-center font-weight-bold" data-dismiss="modal" aria-label="Close" style="position: absolute; bottom: 2px; left: 0;">
                        Cerrar
                    </button>
                </div>
`;

const PASOS_TEMPLATE = `
    <div>
        <div class="tab-content" id="servicioFirma-tabContent">
            <div class="tab-pane fade show active" id="resumenServicio_#id#" role="tabpanel" aria-labelledby="resumenServicio-tab">
                <div class="container mx-auto mt-3 card card-body">
                    <div>#resumen#</div>
                    <div class="text-right">
                        <a class="btn btn-success" style="border-radius: 10rem;" id="precioServicioTab" data-toggle="tab" href="#precioServicio_#id#" role="tab" aria-controls="precioServicio" aria-selected="false"><i class="fas fa-arrow-right fa-3x"></i></a>
                    </div>
                </div>
                <div class="mt-2 text-right">
                <button type="button" class="btn btn-danger w-100 text-center font-weight-bold" data-dismiss="modal" aria-label="Close" style="position: absolute; bottom: 2px; left: 0;">
                    Cerrar
                </button>
            </div>
            </div>
            <div class="tab-pane fade" id="precioServicio_#id#" role="tabpanel" aria-labelledby="precioServicio-tab">
                <div class="container mx-auto mt-3 card card-body">
                    <div>#precio#</div>
                    <div class="text-right">
                        <a class="btn btn-success" style="border-radius: 10rem;" id="firmaServicioTab" data-toggle="tab" href="#firmaServicio_#id#" role="tab" aria-controls="firmaServicio" aria-selected="false"><i class="fas fa-arrow-right fa-3x"></i></a>
                    </div>
                </div>
                <div class="mt-2 text-right">
                    <button type="button" class="btn btn-danger w-100 text-center font-weight-bold" data-dismiss="modal" aria-label="Close" style="position: absolute; bottom: 2px; left: 0;">
                        Cerrar
                    </button>
                </div>
            </div>
            <div class="tab-pane fade" id="firmaServicio_#id#" role="tabpanel" aria-labelledby="firmaServicio-tab">
                <div>#firma#</div>
                <div class="text-right">
                    <button type="button" id="acceptButton" class="btn btn-lg btn-success text-center font-weight-bold" style="transform: translate(-5%, -105%);" data-dismiss="modal" aria-label="Close">
                        Aceptar
                    </button>
                </div>
                <div class="text-center">
                    <button type="button" class="btn btn-lg btn-danger text-center font-weight-bold" style="transform: translateY(-205%);" data-dismiss="modal" aria-label="Close">
                        Cerrar
                    </button>
                </div>
            </div>
        </div>
    </div>
`;

const TEMPLATE = `
<div class="modal fade" id="#modalId#" tabindex="-1" role="dialog" aria-hidden="true" style="background-color: #ffffff;">
    <div class="modal-dialog" role="document" style="margin: 0; max-width: 100%;">
        <div class="modal-content" style="width: 100%; height: 100vh;">
            <div class="modal-body">
                <div id="#modalBodyId#">
                </div>
            </div>
        </div>
    </div>
</div>
`;

/**
 * Generar ID aleatoria
 */
function firmaRandomId() {
  return Math.floor(Math.random() * 1000000) + 100;
}

/**
 * Pasos para firmar
 * @param data
 */
const pasosParaFirmar = (data) => {
  // formato de fecha->
  const date = new Date(+data.servicio.fecha_reporte * 1000);
  const formattedDate = `${date.getDate()}/${date.getMonth() + 1}/${date.getFullYear()}`;
  // <-formato de fecha
  // Id de firma
  FIRMA_ID = `firmaElectronicaB64_${firmaRandomId()}`;
  let precioHtml = '';
  if (data.servicio.horas_totales != null) {
    precioHtml += `
        <div class="row">
            <div class="col h3"><b>Inicio:</b></div>
            <div class="col h3"><b>${data.servicio.hora_inicial}</b></div>
        </div>
        <div class="row">
            <div class="col h3"><b>Fin:</b></div>
            <div class="col h3"><b>${data.servicio.hora_final}</b></div>
        </div>
        <div class="row">
            <div class="col h3"><b>Horas:</b></div>
            <div class="col h3"><b>${data.servicio.horas_totales}</b></div>
        </div>
    `;
  }
  precioHtml += `
        <div class="row">
            <div class="col h3"><b>Precio:</b></div>
            <div class="col h3"><b>$ ${data.servicio_total}</b></div>
        </div>
    `;
  // HTML de los pasos
  // eslint-disable-next-line no-underscore-dangle
  const _TEMPLATE = PASOS_TEMPLATE
    .replace('#resumen#', `
            <div class="row">
                <div class="col"></div>
                <div class="col text-left h3"><b>${data.folio}</b></div>
                <div class="col text-left h3"><b>${formattedDate}</b></div>
            </div>
            <div class="row">
                <div class="col-md-3 text-left h3"><b>Cliente:</b></div>
                <div class="col-md-9 text-left h3">${data.servicio.nombre_cliente}</div>
            </div>
            <div class="row">
                <div class="col-md-3 text-left h3"><b>Detalle:</b></div>
                <div class="col-md-9 text-left h3">${data.servicio.detalle_servicio}</div>
            </div>
        `)
    .replace('#precio#', precioHtml.trim())
    .replace('#firma#', `
            <e-signature dataIdUrl="${FIRMA_ID}" img="0"></e-signature>
        `);
  MODAL_BODY.innerHTML = _TEMPLATE.replace(/#id#/g, firmaRandomId().toString());
  // Renderizar firma
  // eslint-disable-next-line no-undef
  eSign_renderComponent();
};

/**
 * Convertir un string a un elemento de HTML
 *
 * @param {string} html
 * @returns {ChildNode}
 */
function htmlToElement(html) {
  const template = document.createElement('template');
  template.innerHTML = html.trim();
  return template.content.firstChild;
}

/**
 * Iniciar firma
 */
// eslint-disable-next-line no-unused-vars
const initSignature = async (servicioData, onClose) => {
  // Generar IDs->
  const ID = firmaRandomId();
  const MODAL_ID = `modal_${ID}`;
  const MODAL_BODY_ID = `modalBody_${ID}`;
  // <-Generar IDs
  // Remplazar Ids
  // eslint-disable-next-line no-underscore-dangle
  const _TEMPLATE = TEMPLATE.replace('#modalId#', MODAL_ID).replace('#modalBodyId#', MODAL_BODY_ID);
  // Crear elemento de Modal
  document.body.appendChild(htmlToElement(_TEMPLATE));
  // Conseguir los elementos del DOM->
  MODAL = document.getElementById(MODAL_ID);
  MODAL_BODY = document.getElementById(MODAL_BODY_ID);
  // <-Conseguir los elementos del DOM
  // Poner loader
  MODAL_BODY.innerHTML = LOADER;
  // Mostrar modal
  _firma$(MODAL).modal('show');
  // Fullscreen->
  if (MODAL.requestFullscreen) {
    MODAL.requestFullscreen().catch(() => {
    });
  } else if (MODAL.webkitRequestFullScreen) {
    MODAL.webkitRequestFullScreen().catch(() => {
    });
  }
  // <-fullscreen
  // bloquear orientación de teléfono a landscape
  // eslint-disable-next-line no-restricted-globals
  screen.orientation.lock('landscape').catch(() => {
  });
  _firma$(MODAL).on('hidden.bs.modal', () => {
    // Salir de fullscreen
    document.exitFullscreen().catch(() => {
    });
    // Desbloquear orientación
    // eslint-disable-next-line no-restricted-globals
    screen.orientation.unlock();
  });
  try {
    // Conseguir datos del servicio
    const data = JSON.parse(await servicioData());
    // Iniciar los pasos
    pasosParaFirmar(data);
    // Aceptar firma->
    document.getElementById('acceptButton').addEventListener('click', () => {
      let res = '';
      if (FIRMA_ID !== 0) {
        res = document.getElementById(FIRMA_ID).value;
      }
      onClose(res);
    });
    // <-Aceptar firma
  } catch (err) {
    console.error(err);
    MODAL_BODY.innerHTML = ERROR_TEMPLATE;
  }
};
