(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//-------------------- REPORTE BASE FACTURAS WEB ----------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: '',
        sort_by: ''
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.facturas_web.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_facturas_web').partnersfilter({
            sumatory: true,
            sumatory_cols: ["total-col"]
          });
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      $('.input_buscador_facturas_web').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_facturas_web', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_facturas_web").val();
      $('#reporteador').find('.table tbody').css("opacity", 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

//***************************************************************
//-------------------- REPORTE BASE FACTURAS WEB ----------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//------------------- FACTURAS WEB VER FACTURA  -----------------
//***************************************************************
    $(document).on('click', '.ver_factura', function () {
      if ($(this).parents('tr').attr('data-exists-factura') == 0) {
        iziToast.error({
          title: "Error",
          message: "No se encuentra la factura en el servidor"
        });
        return false;
      }
      var id_factura = $(this).text();
      var id_cliente = $(this).parents('tr').attr('data-codigo-cliente');
      var factura = $(this).parents('tr').attr('data-factura');
      var content = '<div>' +
        '<iframe src="/system/tools/vista_factura?factura=' + factura + '&id_cliente=' + id_cliente + '" width="100%;" height="600px;"></iframe>' +
        '</div>';
      $(this).partnersModal({
        title: 'Factura ' + id_factura,
        modalId: 'vista-factura',
        forceWidth: 90,
        content: content
      });
    });
//***************************************************************
//------------------- FACTURAS WEB VER FACTURA  -----------------
//***************************************************************


//***************************************************************
//------------------------ ENVIAR FACTURA -----------------------
//***************************************************************
    $(document).on('click', '.enviar_factura', function () {
      if ($(this).parents('tr').attr('data-exists-factura') == 0) {
        iziToast.error({
          title: "Error",
          message: "No se encuentra la factura en el servidor"
        });
        return false;
      }
      var content = '';
      var folio = $(this).parents('tr').attr('data-folio');
      var factura = $(this).parents('tr').attr('data-factura');
      var cod_cliente = $(this).parents('tr').attr('data-codigo-cliente');
      var nombre_cliente = $(this).parents('tr').attr('data-nombre-cliente');
      var serie = $(this).parents('tr').attr('data-serie');
      var emails = $(this).parents('tr').attr('data-emails');
      content += '<div class="row">' +
        '<div class="col-md-6 text-center"><button class="btn btn-primary adjuntar_archivo_servicio" role="button" type="button" data-serie="' + serie + '" data-nombre-cliente="' + nombre_cliente + '" data-emails="' + emails + '" data-folio="' + folio + '" data-factura="' + factura + '" data-codigo-cliente="' + cod_cliente + '">Adjuntar Servicio</button></div>' +
        '<div class="col-md-6"><button class="btn btn-success enviar_solo_factura" role="button" type="button" data-serie="' + serie + '" data-nombre-cliente="' + nombre_cliente + '" data-emails="' + emails + '" data-folio="' + folio + '" data-factura="' + factura + '" data-codigo-cliente="' + cod_cliente + '">Enviar solo factura</button></div>' +
        '</div>';

      $(this).partnersModal({
        title: 'Enviar Factura ' + folio,
        modalId: 'enviar-factura-modal',
        forceWidth: 35,
        content: content,
        noFooter: true
      });
    });

    $(document).on('click', '.enviar_correo_factura', function () {
      var btn = $(this);
      var emails = $('input[type="text"].emails_to_send').val();
      var factura = btn.attr('data-factura');
      var cod_cliente = btn.attr('data-codigo-cliente');
      var emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
      var envio = {};
      envio.emails = emails;
      envio.factura = factura;
      envio.cod_cliente = cod_cliente;
      envio.serie = btn.attr('data-serie');
      var delete_files = [];
      $('.index_to_delete_ .index').each(function () {
        delete_files.push($(this).attr('data-index'));
      });
      envio.deleted_files = delete_files;

      if ((emails == '' || !emails) && !$('.enviarme_copia_correo').is(':checked')) {
        iziToast.error({
          title: 'Error',
          message: "Ingresa al menos un correo, o enviate una copia."
        });
        return false;
      }

      envio = JSON.stringify(envio);
      btn.partnersBtnControl('start');
      $.ajax({
        type: 'POST',
        url: settings.facturas_web.ruta_consultas + 'enviar_solo_factura',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var timeout = emails_arr.length * 800;
            var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';
            iziToast.show({
              message: x,
              position: 'center',
              timeout: timeout,
              progressBar: false,
              color: 'dark',
              icon: 'fa fa-envelope-open-o',
              iconColor: '#fff'
            });
            var morphext = $("#js-rotating").Morphext({
              animation: "fadeInDownCustom",
              separator: ",",
              speed: 800
            });
            var data;
            data = morphext.data("plugin_Morphext");
            setTimeout(function () {
              data.stop();
            }, timeout - 800);

            setTimeout(function () {
              $('#enviar-solo-factura-modal').modal('hide');
              iziToast.success({
                title: "Bien! ",
                message: response.message
              });
            }, timeout);
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.enviar_solo_factura', function () {
      var btn = $(this);
      $('#enviar-factura-modal').modal('hide');
      setTimeout(function () {
        $(this).partnersModal({
          title: 'Enviar Factura',
          forceWidth: 45,
          modalId: 'enviar-solo-factura-modal',
          content: loader
        });
        var envio = {};
        envio.factura = btn.attr('data-factura');
        envio.cod_cliente = btn.attr('data-codigo-cliente');
        envio.nombre_cliente = btn.attr('data-nombre-cliente');
        envio.folio_factura = btn.attr('data-folio');
        envio.emails = btn.attr('data-emails');
        envio.serie = btn.attr('data-serie');
        envio = JSON.stringify(envio);
        $.ajax({
          type: 'POST',
          url: settings.facturas_web.ruta_consultas + 'vista_content_zip',
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              $('#enviar-solo-factura-modal .modal-body').html(response.message);
              setTimeout(function () {
                $('input[type="text"].emails_to_send').focus();
                $('input[type="text"].emails_to_send').tagsinput();
                $('input[type="text"].emails_to_send').on('beforeItemAdd', function (event) {
                  if (!validateEmail(event.item)) {
                    event.cancel = true;
                  }
                });
              }, 400);

            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }, 400);

    });

    $(document).on('click', '.adjuntar_archivo_servicio', function () {
      var btn = $(this);
      $('#enviar-factura-modal').modal('hide');
      setTimeout(function () {
        $(this).partnersModal({
          title: 'Enviar Factura',
          forceWidth: 45,
          modalId: 'enviar-factura-con-modal',
          content: loader
        });
        var envio = {};
        envio.factura = btn.attr('data-factura');
        envio.cod_cliente = btn.attr('data-codigo-cliente');
        envio.nombre_cliente = btn.attr('data-nombre-cliente');
        envio.folio_factura = btn.attr('data-folio');
        envio.emails = btn.attr('data-emails');
        envio.serie = btn.attr('data-serie');
        envio = JSON.stringify(envio);
        $.ajax({
          type: 'POST',
          url: settings.facturas_web.ruta_consultas + 'vista_content_zip_adjuntar',
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              $('#enviar-factura-con-modal .modal-body').html(response.message);
              setTimeout(function () {
                $('input[type="text"].emails_to_send_').focus();
                $('input[type="text"].emails_to_send_').tagsinput();
                $('input[type="text"].emails_to_send_').on('beforeItemAdd', function (event) {
                  if (!validateEmail(event.item)) {
                    event.cancel = true;
                  }
                });
              }, 400);

            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }, 400);
    });

    $(document).on('submit', '#servicio-adjunto-form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var factura = btn.attr('data-factura');
      var cod_cliente = btn.attr('data-codigo-cliente');
      var emails = $('input[type="text"].emails_to_send_').val();
      var emails_arr = $('input[type="text"].emails_to_send_').tagsinput('items');

      /*
      if (emails == '' || !emails) {
          iziToast.error({
              title: 'Error',
              message: "Ingresa al menos un correo para enviar."
          });
          return false;
      }
      */
      if (!$('input[name="archivo_adjunto_servicio"]')[0].files[0]) {
        iziToast.error({
          title: 'Error',
          message: "No seleccionado ningún archivo para adjuntar a la factura."
        });
        return false;
      }

      if ((emails == '' || !emails) && !$('.enviarme_copia_correo_adjuntar').is(':checked')) {
        iziToast.error({
          title: 'Error',
          message: "Ingresa al menos un correo, o enviate una copia."
        });
        return false;
      }

      btn.partnersBtnControl('start');
      var datos = new FormData();
      var a = $('input[name="archivo_adjunto_servicio"]')[0].files[0];
      datos.append('file', a);
      datos.append('factura', factura);
      datos.append('cod_cliente', cod_cliente);
      datos.append('emails', emails);
      var delete_files = [];
      $('#servicio-adjunto-form .index_to_delete .index').each(function () {
        delete_files.push($(this).attr('data-index'));
      });
      datos.append('deleted_files', delete_files);

      $.ajax({
        type: 'POST',
        url: settings.facturas_web.ruta_enviar_con_servicio,
        data: datos,
        contentType: "application/json; charset=utf-8",
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var timeout = emails_arr.length * 800;
            var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';
            iziToast.show({
              message: x,
              position: 'center',
              timeout: timeout,
              progressBar: false,
              color: 'dark',
              icon: 'fa fa-envelope-open-o',
              iconColor: '#fff'
            });
            var morphext = $("#js-rotating").Morphext({
              animation: "fadeInDownCustom",
              separator: ",",
              speed: 800
            });
            var data;
            data = morphext.data("plugin_Morphext");
            setTimeout(function () {
              data.stop();
            }, timeout - 800);

            setTimeout(function () {
              $('#enviar-factura-con-modal').modal('hide');
              iziToast.success({
                title: "Bien! ",
                message: response.message
              });
              autoUpdate.forceUpdate();
            }, timeout);


          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });


    $(document).on('change', '.enviarme_copia_correo', function () {
      var user_email = $(this).attr('data-user-email');
      if ($(this).is(':checked')) {
        $('input[type="text"].emails_to_send').tagsinput('add', user_email);
      } else {
        $('input[type="text"].emails_to_send').tagsinput('remove', user_email);
      }
    });

    $(document).on('change', '.enviarme_copia_correo_adjuntar', function () {
      var user_email = $(this).attr('data-user-email');
      if ($(this).is(':checked')) {
        $('input[type="text"].emails_to_send_').tagsinput('add', user_email);
      } else {
        $('input[type="text"].emails_to_send_').tagsinput('remove', user_email);
      }
    });
//***************************************************************
//------------------------ ENVIAR FACTURA -----------------------
//***************************************************************


//***************************************************************
//------------------- VISTA SERVICIOS RELACIONADOS  -------------
//***************************************************************
    $(document).on('click', '.vista_servicios_relacionados', function () {
      var folios = $(this).html();
      folios = folios.split(',');
      _.forEach(folios, function (i) {
        if (i[0] == 'B' || i[0] == 'A') {
          window.open('/servicios/vista/' + i.substr(i.indexOf("-") + 1));
        } else if (i[0] == 'F') {
          window.open('/centrodeservicio/vista/' + i.substr(i.indexOf("-") + 1) + '/2');
        }
      });
    });
//***************************************************************
//------------------- VISTA SERVICIOS RELACIONADOS  -------------
//***************************************************************


//***************************************************************
//------------------- ELIMINAR ARCHIVO DEL ZIP ------------------
//***************************************************************
    $(document).on('click', '.eliminar_archivo_from_zip', function () {
      $(this).parents('li').remove();
      var index = $(this).attr('data-index');
      $('.index_to_delete').append('<div class="index" data-index="' + index + '"></div>');
    });
    $(document).on('click', '.eliminar_archivo_from_zip_', function () {
      $(this).parents('li').remove();
      var index = $(this).attr('data-index');
      $('.index_to_delete_').append('<div class="index" data-index="' + index + '"></div>');
    });
//***************************************************************
//------------------- ELIMINAR ARCHIVO DEL ZIP ------------------
//***************************************************************


//***************************************************************
//------------------- FACTURAS WEB OBSERVACIONES ----------------
//***************************************************************
    $(document).on('click', '.status_obs_w', function () {
      var folio = $(this).parents('tr').attr('data-folio');
      $(this).partnersObs(
        {
          modalId: 'modal-cobranza-observaciones',
          ajaxUrl: settings.facturas_web.ruta_sys_tools + 'load_obs',
          index: 'folio',
          id_index: folio,
          tabla: 'partners_cobranza',
          col: 'observaciones',
          extra_val: folio,
          extra_col: 'folio',
          custom_condition: "folio = " + folio + " and serie = \'W\' ",
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });
//***************************************************************
//------------------- FACTURAS WEB OBSERVACIONES ----------------
//***************************************************************

//***************************************************************
//------------------- FACTURAS WEB INFORM ERRORS ----------------
//***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.facturas_web.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
//***************************************************************
//------------------- FACTURAS WEB INFORM ERRORS ----------------
//***************************************************************


//***************************************************************
//------------------------ EXPORTAR EXCEL  ----------------------
//***************************************************************
    $(document).on('click', '.exportar_excel', function () {
      var datos = r_options;
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      datos.filter.start_date = moment(fecha_array[0], "DD-MM-YYYY")._d;
      datos.filter.end_date = moment(fecha_array[1], "DD-MM-YYYY")._d;

      swal({
        isLoading: true,
        type: 'info',
        title: 'Generando Archivo de Excel...',
        showConfirmButton: false
      })

      $.ajax({
        type: 'POST',
        url: settings.facturas_web.ruta_consultas + 'export_excel',
        data: JSON.stringify(datos),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: "Reporte generado correctamente!"
            });
            window.location.href = response.message;
            swal.close();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

//***************************************************************
//------------------------ EXPORTAR EXCEL  ----------------------
//***************************************************************

  });
})
(jQuery);