(($) => {
    $(document).ready(() => {
        const FORM = document.getElementById("datosFacturacionForm");
        const ALERT = document.getElementById("errorAlert");
        const GRATULA = document.getElementById("gratula");
        const BTN = document.getElementById("submitBtn");
        const BTN_OR = BTN.innerHTML;
        const RFC_FISICA = /^[A-Z]{4}[0-9]{6}[A-Z0-9]{3}$/;
        const RFC_MORAL = /^[A-Z]{3}[0-9]{6}[A-Z0-9]{3}$/;
        const CORREO = /^[^\s@]+@[^\s@]+\.[^\s@]+$/i;
        const TELEFONO = /^[0-9]{10}$/;
        document.getElementById("persona").addEventListener("change", (e) => {
            $("#formualrioCompleto").collapse("show");
            $("#formualrioCompletoFallback").collapse("hide");
        });

        FORM.addEventListener("submit", async (e) => {
            e.preventDefault();
            $(ALERT).hide("fast");
            const formData = new FormData(FORM);
            let persona;
            try {
                formData.forEach((val, key) => {
                    switch (key) {
                        case 'persona':
                            if (!val) {
                                throw new Error("Debes seleccionar un tipo de persona");
                            }
                            persona = val;
                            break;
                        case 'nombre':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar la razón social");
                            }
                            break;
                        case 'rfc':
                            switch (persona) {
                                case 'fisica':
                                    if (!RFC_FISICA.test(val.toUpperCase())) {
                                        throw new Error("El RFC para persona física debe ser [A-Z]{4}[0-9]{6}[A-Z0-9]{3}");
                                    }
                                    break;
                                case 'moral':
                                    if (!RFC_MORAL.test(val.toUpperCase())) {
                                        throw new Error("El RFC para persona moral debe ser [A-Z]{3}[0-9]{6}[A-Z0-9]{3}");
                                    }
                                    break;
                                default: throw new Error("No se reconoció al tipo de persona");
                            }
                            break;
                        case 'calle':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar la calle");
                            }
                            break;
                        case 'numExt':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar el número exterior");
                            }
                            break;
                        case 'colonia':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar la colonia");
                            }
                            break;
                        case 'ciudad':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar la ciudad");
                            }
                            break;
                        case 'cp':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar el códgo postal");
                            }
                            break;
                        case 'formaPago':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar una forma de pago");
                            }
                            break;
                        case 'usoCFDI':
                            if (simpleTextValidator(val)) {
                                throw new Error("Debes ingresar el uso del CFDI");
                            }
                            break;
                        case 'correo':
                            if (!CORREO.test(val)) {
                                throw new Error("El correo debe tener un formato válido");
                            }
                            break;
                        case 'telefono':
                            if (!TELEFONO.test(val)) {
                                throw new Error("El teléfono debe tener un formato válido");
                            }
                            break;
                        default: break;
                    }
                });
                BTN.disabled = true;
                BTN.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span><span class="sr-only">Cargando...</span>';

                const response = await fetch('/datos_facturacion_enviar', {
                    method: 'POST',
                    body: formData,
                });
                const res = await response.json();
                if(response.status != 200) {
                    throw new Error(res.message);
                } else {
                    $(FORM).collapse("hide");
                    $(GRATULA).collapse("show");
                }
            } catch (err) {
                console.error(err);
                $(ALERT).show("fast");
                ALERT.innerHTML = err;
                BTN.innerHTML = BTN_OR;
                BTN.disabled = false;
            }

        });

        const simpleTextValidator = (text) => {
            return text.length <= 0;
        };

    });
})(jQuery);