
(function ($) {
  const settings = Drupal.settings;

  $(document).ready(() => {
    const loader = '<div class="sk-cube-grid"> '
        + '<div class="sk-cube sk-cube1"></div> '
        + '<div class="sk-cube sk-cube2"></div> '
        + '<div class="sk-cube sk-cube3"></div> '
        + '<div class="sk-cube sk-cube4"></div> '
        + '<div class="sk-cube sk-cube5"></div> '
        + '<div class="sk-cube sk-cube6"></div> '
        + '<div class="sk-cube sk-cube7"></div> '
        + '<div class="sk-cube sk-cube8"></div> '
        + '<div class="sk-cube sk-cube9"></div> </div>';

    const ruta_url = `${settings.cotizaciones.ruta_sys_tools}inline_edit`;

    const open_cotizacion = getUrlVars().id_pendiente;

    if (open_cotizacion) {
      setTimeout(() => {
        iziToast.info({
          title: 'Recuerda',
          timeout: 15000,
          message: 'Deberás generar tu cotización para poder cerrar tu pendiente.',
        });
        $('.nueva_cotizacion_proyecto').attr('data-opened-from-pendiente', open_cotizacion);
        $('.nueva_cotizacion_proyecto').click();
        $('.nueva_cotizacion').attr('data-opened-from-pendiente', open_cotizacion);
        $('.nueva_cotizacion').click();
      }, 1000);
    }

    // Se usa para guardar en un array las imagenes que se carguen al momento de hacer la cotización.
    let imgCotizacionList = [];
    //* **************************************************************
    // ------------------- REPORTE BASE COTIZACIONES -----------------
    //* **************************************************************
    // Auto Update
    const autoUpdate = new AutoUpdate({
      toUpdate() {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

      // Reporte base Options
    const r_options = {
      pagination: {
        page: 1,
      },
      sort: {
        order: 'DESC',
        sort_by: 'id_cotizacion',
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        usuario: null,
        start_date: null,
        end_date: null,
      },
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}reporte_base`,
        data: JSON.stringify(r_options),
        contentType: 'application/json; charset=utf-8',
        success(data) {
          $('#reporteador').html(data);
          $('#table_reporteador_cotizaciones').stickyTableHeaders();
          $('#table_reporteador_cotizaciones').partnersfilter();

          // Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;

          // Actualizar la información de las cotizaciones sin procesar
          updateInformacionSinProcesar();
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    $(document).on('click', '#reset_filters', () => {
      r_options.filter.search_bar = null;
      r_options.filter.usuario = null;
      $('.input_buscador_cotizacion').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_cotizacion', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13) search(true);
      else $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      const StringtoSearch = $('.input_buscador_cotizacion').val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }


    // Filtrado - Usuario
    $(document).on('change', '#filtrado_usuario', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.usuario = $(this).find('option:selected').val();
      autoUpdate.forceUpdate();
    });

    $(document).on('change', '.filtro_sin_procesar', function () {
      $('#reporteador').find('.table tbody').css('opacity', 0.5);

      if ($(this).is(':checked')) {
        r_options.filter.sin_procesar = 1;
      } else {
        r_options.filter.sin_procesar = 0;
      }
      autoUpdate.forceUpdate();
    });

    function updateInformacionSinProcesar() {
      const datos = {};
      datos.start_date = r_options.filter.start_date;
      datos.end_date = r_options.filter.end_date;
      datos.usuario = r_options.filter.usuario;

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}informacion_sin_procesar`,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        data: JSON.stringify(datos),
        success(response) {
          if (response.status == 'success') {
            $('.mes_cotizaciones_sin_procesar').html(`${response.message.totalMonth} cotizaciones sin procesar`);
            $('.total_cotizaciones_sin_procesar').html(`${response.message.total} cotizaciones sin procesar`);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    //* **************************************************************
    // ------------------- REPORTE BASE COTIZACIONES -----------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------ DATE PICKER --------------------------
    //* **************************************************************
    const start = moment().startOf('month');
    const end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(`${start.format('DD/MM/YYYY')} - ${end.format('DD/MM/YYYY')}`);
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: '.parent-calendar',
      locale: {
        format: 'DD/MM/YYYY',
        separator: ' - ',
        applyLabel: 'Aplicar',
        cancelLabel: 'Cancelar',
        fromLabel: 'Desde',
        toLabel: 'Hasta',
        customRangeLabel: 'Personalizado',
        weekLabel: 'S',
        daysOfWeek: [
          'Do',
          'Lu',
          'Ma',
          'Mi',
          'Ju',
          'Vi',
          'Sa',
        ],
        monthNames: [
          'Enero',
          'Febrero',
          'Marzo',
          'Abril',
          'Mayo',
          'Junio',
          'Julio',
          'Agosto',
          'Septiembre',
          'Octubre',
          'Noviembre',
          'Diciembre',
        ],
        firstDay: 1,
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        Enero: [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        Julio: [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        Febrero: [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        Agosto: [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        Hoy: [moment(), moment()],
        Marzo: [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        Septiembre: [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        Abril: [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        Octubre: [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        Mayo: [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        Noviembre: [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        Junio: [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        Diciembre: [moment().month('December').startOf('month'), moment().month('December').endOf('month')],
      },
    }, cb);


    $('#reportrange').on('apply.daterangepicker', () => {
      const fecha = $('#reportrange').find('span').text();
      const fecha_array = fecha.split('-');
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      const fecha = $('#reportrange').find('span').text();
      const fecha_array = fecha.split('-');
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    }());
    //* **************************************************************
    // ------------------------ DATE PICKER --------------------------
    //* **************************************************************


    //* **************************************************************
    // ----------------------- NUEVA COTIZACION  ---------------------
    //* **************************************************************
    $(document).on('click', '.nueva_cotizacion', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Nueva Cotización',
        forceWidth: 95,
        modalId: 'nueva-cotizacion-modal',
        content: loader,
        preventHideOnBackdrop: true,
      });

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}nueva_cotizacion`,
        data: JSON.stringify(1),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#nueva-cotizacion-modal .modal-body').html(response.message);
            setTimeout(() => {
              imgCotizacionList = [];
              $('#buscar_cliente').typeahead({
                order: 'asc',
                minlength: 1,
                maxItem: 15,
                hint: true,
                accent: true,
                group: {
                  template: '{{group}}',
                },
                maxItemPerGroup: 5,
                backdrop: {
                  'background-color': '#fff',
                },
                template(query, item) {
                  let color_t_clasificacion;
                  let tipo_clasificacion = item.tipo_clasificacion;
                  switch (tipo_clasificacion) {
                    case 'a':
                      color_t_clasificacion = 'success';
                      break;
                    case 'b':
                      color_t_clasificacion = 'success';
                      break;
                    case 'c':
                      color_t_clasificacion = 'warning';
                      break;
                    case 'd':
                      color_t_clasificacion = 'danger';
                      break;
                    case 'e':
                      color_t_clasificacion = 'danger';
                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();

                  const credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';

                  if (item.tipo_cliente != 3) {
                    return `${'<p>'
                        + '<span>{{nombre_cliente}}</span> '
                        + '<span class="float-right badge badge-'}${color_t_clasificacion}">`
                        + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                        } | ${credito_contado}</span> </p> `;
                  }
                  return '<p><span>{{nombre_cliente}}</span> </p> ';
                },
                dynamic: true,
                dropdownFilter: 'Todos',
                emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
                source: {
                  Clientes: {
                    display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                    ajax: {
                      url: `${settings.cotizaciones.ruta_lista_clientes}complete`,
                      path: 'data.datos.clientes',
                    },
                  },
                  Contactos: {
                    display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                    ajax: {
                      url: `${settings.cotizaciones.ruta_lista_clientes}complete`,
                      path: 'data.datos.contactos',
                    },
                  },
                  Proveedores: {
                    display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                    ajax: {
                      url: `${settings.cotizaciones.ruta_lista_clientes}complete`,
                      path: 'data.datos.proveedores',
                    },
                  },
                },
                callback: {
                  onClickAfter(node, a, item) {
                    let color_t_clasificacion;
                    let tipo_clasificacion = item.tipo_clasificacion;
                    switch (tipo_clasificacion) {
                      case 'a':
                        color_t_clasificacion = 'success';
                        break;
                      case 'b':
                        color_t_clasificacion = 'success';
                        break;
                      case 'c':
                        color_t_clasificacion = 'warning';
                        break;
                      case 'd':
                        color_t_clasificacion = 'danger';
                        break;
                      case 'e':
                        color_t_clasificacion = 'danger';
                        break;
                    }
                    tipo_clasificacion = tipo_clasificacion.toUpperCase();
                    const credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                    if (item.tipo_cliente != 3) {
                      $('.quick_info_client').html(`<span class="badge badge-${color_t_clasificacion}">`
                          + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                          } | ${credito_contado}</span> </p> `);
                      const id_cliente = item.id_cliente;
                      prepareEvs(1, {
                        color_t_clasificacion,
                        tipo_clasificacion,
                        credito_contado,
                        id_cliente,
                        settings,
                      });
                    }
                    // Bindear el id del cliente al input
                    node.attr('data-id-cliente', item.id_cliente);
                    node.attr('data-email-cliente', item.email);

                    // Generar lista contactos solo para clientes Negocio/Distribuidor
                    if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                      generar_contactos(settings.cotizaciones.ruta_lista_contactos, item.id_cliente);

                      // Solamente agrega este attr cuando debe de tener contactos
                      node.attr('data-tipo-negocio', item.tipo_negocio);
                    } else {
                      $('.contacto_container').hide();
                      $('.select_lista_contactos').empty();
                    }
                  },
                  onSearch(node, a) {
                    if (a !== '') {
                    } else {
                      // Para prevenir errores de sobrescribir o duplicar
                      $('.contacto_container').hide();
                      $('.select_lista_contactos').empty();
                      $('.quick_info_client').html('');
                      node.removeAttr('data-id-cliente');
                      node.removeAttr('data-tipo-negocio');
                      node.removeAttr('data-email-cliente');
                    }
                  },
                },
              });

              $.validate({
                form: '#nueva_cotizacion_form',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid',
              });
            }, 400);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    //* **************************************************************
    // ----------------------- NUEVA COTIZACION  ---------------------
    //* **************************************************************


    //* **************************************************************
    // ----------------------- CAPTURAR COTIZACION--------------------
    //* **************************************************************
    $(document).on('keypress', ':input:not(textarea)', function (event) {
      if ($(this).hasClass('precio_cotizacion') && event.keyCode == 13) {
        $('.agregar_entity_cotizacion').click();
      }
      if ($(this).hasClass('precio_cotizacion_proyecto') && event.keyCode == 13) {
        $('.agregar_entity_cotizacion_proyecto').click();
      }
      return event.keyCode != 13;
    });

    $(document).on('change', '.select_cotizacion_compartida', function () {
      if ($(this).val() == 1) {
        $('.cotizacion_compartida_container').show();
      } else {
        $('.cotizacion_compartida_container').hide();
      }
    });
    $(document).on('click', '.agregar_entity_cotizacion', function () {
      const cantidad = $('.cantidad_cotizacion').val();
      const descripcion = $('.descripcion_cotizacion').val();
      const precio = $('.precio_cotizacion').val();

      if ($.trim(cantidad).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una cantidad',
        });
        return false;
      }

      if (isNaN(cantidad)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa una cantidad correcta',
        });
        return false;
      }

      if ($.trim(descripcion).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una descripción',
        });
        return false;
      }

      if ($.trim(precio).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega un precio',
        });
        return false;
      }

      if (isNaN(precio)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un precio correcto',
        });
        return false;
      }

      // Sacar imagen
      const { files } = $(this).parents('.row').find('input[name="input_imagenes"]')[0];


      if (files.length > 0) {
        const reader = new FileReader();
        const r = Math.random() * 100;
        reader.onload = ({ target }) => {
          let tr = '<tr class="entity_cotizacion" >';
          tr += `<td class="entity_cotizacion_cantidad">${cantidad}</td>`;
          tr += `${`<td class="entity_cotizacion_imagen text-center" data-img-id="${r}"><img src="${target.result}" alt="Img" class="img-fluid" style="width: 100px;"></td>`
              + '<td class="entity_cotizacion_descripcion" style="white-space: pre-wrap; word-break: break-word;">'}${descripcion}</td>`
              + `<td class="text-right entity_cotizacion_precio" data-precio="${precio}">${parseFloat(precio).format(2)}</td>`
              + `<td class="text-right entity_cotizacion_subtotal" data-subtotal="${precio * cantidad}">${(precio * cantidad).format(2)}</td>`
              + '<td class="eliminar_entity_cotizacion text-center text-danger cursor-pointer">Eliminar</td>'
              + '</tr>';
          $('.table-entities-cotizacion tbody').append(tr);
          sumar_total_entities_cotizacion();
          $('.cantidad_cotizacion').val('');
          $('.descripcion_cotizacion').val('');
          $('.precio_cotizacion').val('');
          $('.cantidad_cotizacion').focus();
          $('input[name="input_imagenes"]').val('');
        };
        reader.readAsDataURL(files[0]);
        files[0].imgId = r;
        imgCotizacionList.push(files[0]);
      } else {
        let tr = '<tr class="entity_cotizacion" >';
        tr += `<td class="entity_cotizacion_cantidad">${cantidad}</td>`;
        tr += `${'<td class="entity_cotizacion_imagen text-center">No img</td>'
            + '<td class="entity_cotizacion_descripcion" style="white-space: pre-wrap; word-break: break-word;">'}${descripcion}</td>`
            + `<td class="text-right entity_cotizacion_precio" data-precio="${precio}">${parseFloat(precio).format(2)}</td>`
            + `<td class="text-right entity_cotizacion_subtotal" data-subtotal="${precio * cantidad}">${(precio * cantidad).format(2)}</td>`
            + '<td class="eliminar_entity_cotizacion text-center text-danger cursor-pointer">Eliminar</td>'
            + '</tr>';
        $('.table-entities-cotizacion tbody').append(tr);
        sumar_total_entities_cotizacion();
        $('.cantidad_cotizacion').val('');
        $('.descripcion_cotizacion').val('');
        $('.precio_cotizacion').val('');
        $('.cantidad_cotizacion').focus();
      }
    });

    function sumar_total_entities_cotizacion() {
      let total = 0;
      $('.entity_cotizacion_subtotal').each(function () {
        total += parseFloat($(this).attr('data-subtotal'));
      });
      $('.table-entities-cotizacion .total_cotizacion').html(parseFloat(total).format(2));
    }


    $(document).on('click', '.eliminar_entity_cotizacion', function () {
      const id = $(this).parents('tr').find('.entity_cotizacion_imagen').attr('data-img-id');
      if (id) {
        const newFilteredList = imgCotizacionList.filter(item => item.imgId != id);
        imgCotizacionList = newFilteredList.slice();
      }
      $(this).parents('tr').remove();
      sumar_total_entities_cotizacion();
    });

    $(document).on('submit', '#nueva_cotizacion_form', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      const datos = $('#nueva_cotizacion_form').serializeArray();
      const datosEnvio = {};
      let formData;


      if (!$('#buscar_cliente').attr('data-id-cliente')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un Cliente',
        });
        return false;
      }

      if ($('#buscar_cliente').attr('data-tipo-negocio')) {
        if ($('.select_lista_contactos').find('option:selected').val() == 0) {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona un Contacto',
          });
          return false;
        }
      }

      if ($('.entity_cotizacion').length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes agregar al menos un producto a la cotización',
        });
        return false;
      }

      btn.partnersBtnControl('start');


      const email_contacto = ($('.select_lista_contactos').find('option:selected').attr('data-email-contacto')) ? $('.select_lista_contactos').find('option:selected').attr('data-email-contacto') : '';
      const email_cliente = $('#buscar_cliente').attr('data-email-cliente');
      const email_user = $(this).attr('data-user-email');

      if (imgCotizacionList.length > 0) {
        formData = new FormData();
        // Los datos del form
        for (let i = 0; i < datos.length; i += 1) {
          formData.append(datos[i].name, datos[i].value);
        }

        // Las imagenes
        const imgs = [];
        for (let i = 0; i < imgCotizacionList.length; i++) {
          formData.append(imgCotizacionList[i].imgId, imgCotizacionList[i]);
        }

        const d = [];
        $('.entity_cotizacion').each(function () {
          d.push({
            cantidad: $(this).find('.entity_cotizacion_cantidad').text(),
            descripcion: $(this).find('.entity_cotizacion_descripcion').text(),
            precio: $(this).find('.entity_cotizacion_precio').attr('data-precio'),
            img: $(this).find('.entity_cotizacion_imagen').attr('data-img-id'),
          });
        });

        formData.append('datos', JSON.stringify(d));

        if ($('.select_cotizacion_compartida:checked').val() == 1) {
          formData.append('compartida_con', $('.cotizacion_compartida_con option:selected').val());
        }
        formData.append('id_cliente', $('#buscar_cliente').attr('data-id-cliente'));
        if ($('.select_lista_contactos').find('option:selected').val()) {
          formData.append('id_contacto', $('.select_lista_contactos').find('option:selected').val());
        }

        if (open_cotizacion) {
          formData.append('finish_pendiente', open_cotizacion);
        }

        $.ajax({
          type: 'POST',
          url: `${settings.cotizaciones.ruta_consultas}capturar_cotizacion`,
          data: formData,
          dataType: 'json',
          contentType: false,
          cache: false,
          processData: false,
          success(response) {
            if (response.status == 'success') {
              const id_cotizacion = response.message;
              swal({
                title: 'Enviar',
                text: 'Deseas enviar la cotización por correo?',
                type: 'info',
                showCancelButton: true,
                cancelButtonColor: '#DD6B55',
                confirmButtonText: 'Si, enviar!',
                cancelButtonText: 'No!',
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger',
                allowOutsideClick: false,
                allowEscapeKey: false,
                onClose() {
                  $('body').removeAttr('style');
                },
              }).then((a) => {
                if (!a.dismiss) {
                  btn.partnersBtnControl('end');
                  const idCliente = $('#buscar_cliente').attr('data-id-cliente');
                  // eslint-disable-next-line no-undef
                  modalCorreo(
                    idCliente,
                    settings,
                    id_cotizacion,
                    (emailsToSend, ddatos, body, hideModal) => {
                      const data = {
                        to: emailsToSend,
                        id_cotizacion: ddatos,
                        body,
                      };
                      $.ajax({
                        type: 'POST',
                        url: `${settings.cotizaciones.ruta_consultas}enviar_cotizacion_correo`,
                        data: JSON.stringify(data),
                        contentType: 'application/json; charset=utf-8',
                        dataType: 'json',
                        success(res) {
                          if (res.status === 'success') {
                          // eslint-disable-next-line no-undef
                            iziToast.success({
                              title: 'Listo',
                              message: 'Correos enviados',
                            });
                            hideModal(true);
                          } else if (res.status === 'error') {
                          // eslint-disable-next-line no-undef
                            iziToast.error({
                              title: 'Error',
                              message: res.message,
                            });
                            hideModal(false);
                          }
                        },
                        error(xhr) {
                        // eslint-disable-next-line no-undef
                          iziToast.error({
                            title: 'Ocurrio un error: ',
                            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                          });
                          hideModal(false);
                        },
                      });
                    }, {}, () => {
                      window.open('/cotizaciones/vista/' + id_cotizacion);
                      $('#nueva-cotizacion-modal').modal('hide');
                      autoUpdate.forceUpdate();
                    }
                  );
                } else if (a.dismiss == 'cancel') {
                  swal({
                    title: 'Bien!',
                    text: 'Se guardo normalmente la cotización.',
                    timer: 2000,
                    type: 'success',
                    showConfirmButton: false,
                  });
                  autoUpdate.forceUpdate();
                  window.open(`/cotizaciones/vista/${id_cotizacion}`);
                  $('#nueva-cotizacion-modal').modal('hide');
                }
              });
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
              btn.partnersBtnControl('end');
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
            btn.partnersBtnControl('end');
          },
        });
      } else {
        // Si no trae archivos, no hay necesidad de enviar la información con
        // new FormData(); solamente cuando se vayan a enviar imágenes se usara
        // formData, de lo contrario se enviara solo el objeto de datos y ya.
        formData = {};
        for (let i = 0; i < datos.length; i += 1) {
          formData[datos[i].name] = datos[i].value;
        }

        const d = [];
        $('.entity_cotizacion').each(function () {
          d.push({
            cantidad: $(this).find('.entity_cotizacion_cantidad').text(),
            descripcion: $(this).find('.entity_cotizacion_descripcion').text(),
            precio: $(this).find('.entity_cotizacion_precio').attr('data-precio'),
            img: $(this).find('.entity_cotizacion_imagen').attr('data-img-id'),
          });
        });

        formData.datos = d;

        if ($('.select_cotizacion_compartida:checked').val() == 1) {
          formData.compartida_con = $('.cotizacion_compartida_con option:selected').val();
        }
        formData.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
        formData.id_contacto = $('.select_lista_contactos').find('option:selected').val();

        if (open_cotizacion) {
          formData.finish_pendiente = open_cotizacion;
        }

        $.ajax({
          type: 'POST',
          url: `${settings.cotizaciones.ruta_consultas}capturar_cotizacion`,
          data: JSON.stringify(formData),
          dataType: 'json',
          contentType: 'application/json; charset=utf-8',
          success(response) {
            if (response.status == 'success') {
              const id_cotizacion = response.message;
              swal({
                title: 'Enviar',
                text: 'Deseas enviar la cotización por correo?',
                type: 'info',
                showCancelButton: true,
                cancelButtonColor: '#DD6B55',
                confirmButtonText: 'Si, enviar!',
                cancelButtonText: 'No!',
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger',
                allowOutsideClick: false,
                allowEscapeKey: false,
                onClose() {
                  $('body').removeAttr('style');
                },
              }).then((a) => {
                if (!a.dismiss) {
                  btn.partnersBtnControl('end');
                  const idCliente = $('#buscar_cliente').attr('data-id-cliente');
                  modalCorreo(
                    idCliente,
                    settings,
                    id_cotizacion,
                    (emailsToSend, ddatos, body, hideModal) => {
                      const data = {
                        to: emailsToSend,
                        id_cotizacion: ddatos,
                        body,
                      };
                      $.ajax({
                        type: 'POST',
                        url: `${settings.cotizaciones.ruta_consultas}enviar_cotizacion_correo`,
                        data: JSON.stringify(data),
                        contentType: 'application/json; charset=utf-8',
                        dataType: 'json',
                        success(res) {
                          if (res.status === 'success') {
                            // eslint-disable-next-line no-undef
                            iziToast.success({
                              title: 'Listo',
                              message: 'Correos enviados',
                            });
                            hideModal(true);
                          } else if (res.status === 'error') {
                            // eslint-disable-next-line no-undef
                            iziToast.error({
                              title: 'Error',
                              message: res.message,
                            });
                            hideModal(false);
                          }
                        },
                        error(xhr) {
                          // eslint-disable-next-line no-undef
                          iziToast.error({
                            title: 'Ocurrio un error: ',
                            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                          });
                          hideModal(false);
                        },
                      });
                    }, {}, () => {
                      window.open('/cotizaciones/vista/' + id_cotizacion);
                      $('#nueva-cotizacion-modal').modal('hide');
                      autoUpdate.forceUpdate();
                    }
                  );
                } else if (a.dismiss == 'cancel') {
                  swal({
                    title: 'Bien!',
                    text: 'Se guardo normalmente la cotización.',
                    timer: 2000,
                    type: 'success',
                    showConfirmButton: false,
                  });
                  autoUpdate.forceUpdate();
                  window.open(`/cotizaciones/vista/${id_cotizacion}`);
                  $('#nueva-cotizacion-modal').modal('hide');
                }
              });
            } else if (response.status == 'error') {
              iziToast.error({
                title: 'Error',
                message: response.message,
              });
              btn.partnersBtnControl('end');
            }
          },
          error(xhr) {
            iziToast.error({
              title: 'Ocurrio un error: ',
              message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
            });
            btn.partnersBtnControl('end');
          },
        });
      }
    });
    //* **************************************************************
    // ----------------------- CAPTURAR COTIZACION--------------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- STATUS OBSERVACIONES ------------------
    //* **************************************************************
    $(document).on('click', '.cotizaciones-observaciones', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      $(this).partnersObs(
        {
          modalId: 'modal-cotizacion-observaciones',
          ajaxUrl: `${settings.cotizaciones.ruta_sys_tools}load_obs`,
          index: 'id_cotizacion',
          id_index: id_cotizacion,
          tabla: 'partners_cotizaciones',
          col: 'observaciones',
          allowReminder: false,
          ajaxSuccessCallback() {
            autoUpdate.forceUpdate();
          },
        },
      );
    });
    //* **************************************************************
    // ----------------------- STATUS OBSERVACIONES ------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------- STATUS ENVIADO ----------------------
    //* **************************************************************
    $(document).on('click', '.status_enviado', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      const enviado = ($(this).parents('tr').attr('data-enviado') == 1) ? 0 : 1;
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = enviado;
      envio.col = 'enviado';
      envio = JSON.stringify(envio);
      if (enviado == 1) {
        $(this).removeClass('status-red');
        $(this).addClass('status-green');
        $(this).html('Si');
      } else {
        $(this).removeClass('status-green');
        $(this).addClass('status-red');
        $(this).html('No');
      }

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft',
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------------- STATUS ENVIADO ----------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------- STATUS RECIBIDO ---------------------
    //* **************************************************************
    $(document).on('click', '.status_recibido', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      const recibido = ($(this).parents('tr').attr('data-recibido') == 1) ? 0 : 1;
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = recibido;
      envio.col = 'recibido';
      envio = JSON.stringify(envio);
      if (recibido == 1) {
        $(this).removeClass('status-red');
        $(this).addClass('status-green');
        $(this).html('Si');
      } else {
        $(this).removeClass('status-green');
        $(this).addClass('status-red');
        $(this).html('No');
      }

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft',
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------------- STATUS RECIBIDO ---------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------- STATUS COMPRA -----------------------
    //* **************************************************************
    $(document).on('click', '.status_compra', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      const compra = ($(this).parents('tr').attr('data-compra') == 1) ? 0 : 1;
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = compra;
      envio.col = 'compra';
      envio = JSON.stringify(envio);
      if (compra == 1) {
        $(this).removeClass('status-red');
        $(this).addClass('status-green');
        $(this).html('Si');
      } else {
        $(this).removeClass('status-green');
        $(this).addClass('status-red');
        $(this).html('No');
      }

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            if (compra == 1) {
              swal({
                title: 'Bien!',
                text: 'Quieres generar un pendiente?',
                type: 'success',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Si!',
                cancelButtonText: 'No',
              }).then((a) => {
                if (!a.dismiss) {
                  window.open('/pendientes?new_pendiente=1');
                  swal.close();
                  iziToast.success({
                    title: 'Bien! ',
                    message: response.message,
                    timeout: 1000,
                    position: 'bottomLeft',
                  });
                }
              });
            }


            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------------- STATUS COMPRA -----------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------------- STATUS PAGADO -----------------------
    //* **************************************************************
    $(document).on('click', '.status_pagado', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      const id_relacion_renovacion = $(this).attr('data-id-relacion-renovacion');
      const template = `${'<div class="row">'
          + '<div class="col-md"><button type="button" class="btn btn-outline-warning cotizacion_no_pagado w-100" data-id-relacion-renovacion="'}${id_relacion_renovacion}" data-id-cotizacion="${id_cotizacion}" role="button">No</button></div>`
          + `<div class="col-md"><button type="button" class="btn btn-outline-success cotizacion_pagado w-100" data-id-relacion-renovacion="${id_relacion_renovacion}" data-id-cotizacion="${id_cotizacion}" role="button">Pagado</button></div>`
          + `<div class="col-md"><button type="button" class="btn btn-outline-info cotizacion_facturado w-100" data-id-relacion-renovacion="${id_relacion_renovacion}" data-id-cotizacion="${id_cotizacion}" role="button">Facturado</button></div>`
          + '</div>';


      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 25,
        modalId: 'modal-pagado-cotizacion',
        noFooter: true,
      });
    });

    $(document).on('click', '.cotizacion_no_pagado', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      const clicked_td = $(`tr[data-id-cotizacion="${id_cotizacion}"] .status_pagado`);
      $('#modal-pagado-cotizacion .modal-body').html(loader);
      let envio = {};
      envio.new_val = 0;
      envio.id_cotizacion = id_cotizacion;
      envio.col = 'facturado';
      if ($(this).attr('data-id-relacion-renovacion')) {
        envio.id_relacion_renovacion = $(this).attr('data-id-relacion-renovacion');
      }
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft',
            });
            $('#modal-pagado-cotizacion').modal('hide');
            clicked_td.removeClass('status-green');
            clicked_td.addClass('status-red');
            clicked_td.html('No');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('click', '.cotizacion_pagado', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      const clicked_td = $(`tr[data-id-cotizacion="${id_cotizacion}"] .status_pagado`);
      $('#modal-pagado-cotizacion .modal-body').html(loader);
      let envio = {};
      envio.new_val = 1;
      envio.id_cotizacion = id_cotizacion;
      envio.col = 'facturado';
      if ($(this).attr('data-id-relacion-renovacion')) {
        envio.id_relacion_renovacion = $(this).attr('data-id-relacion-renovacion');
      }

      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft',
            });
            $('#modal-pagado-cotizacion').modal('hide');
            clicked_td.removeClass('status-red');
            clicked_td.addClass('status-green');
            clicked_td.html('Pagado');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('click', '.cotizacion_facturado', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      const clicked_td = $(`tr[data-id-cotizacion="${id_cotizacion}"] .status_pagado`);
      $('#modal-pagado-cotizacion').modal('hide');

      const new_val = 2;
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = new_val;
      if ($(this).attr('data-id-relacion-renovacion')) {
        envio.id_relacion_renovacion = $(this).attr('data-id-relacion-renovacion');
      }
      envio.col = 'facturado';
      swal({
        title: 'Número de factura',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose() {
          $('body').removeAttr('style');
        },
        preConfirm(reason) {
          return new Promise(((resolve, reject) => {
            if (!reason) {
              reject('Debes ingresar un número de factura!');
            } else {
              envio.obs = `Se marcó como como facturado con el número de factura: ${reason}`;
              envio.facturado = 1;
              envio.numero_factura = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: `${settings.cotizaciones.ruta_consultas}update_status`,
                data: envio,
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                success(response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: 'Error',
                      message: response.message,
                    });
                  }
                },
                error(xhr) {
                  iziToast.error({
                    title: 'Ocurrio un error: ',
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                },
              });
            }
          }));
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Factura');
          iziToast.success({
            title: 'Bien! ',
            message: 'Cambios guardados',
            timeout: 1000,
            position: 'bottomLeft',
          });
          autoUpdate.forceUpdate();
        }
      });
    });
    //* **************************************************************
    // ------------------------- STATUS PAGADO -----------------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- STATUS ENTREGADO ----------------------
    //* **************************************************************
    $(document).on('click', '.status_entregado', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      const entregado = ($(this).parents('tr').attr('data-entregado') == 1) ? 0 : 1;
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = entregado;
      envio.col = 'entregado';
      envio = JSON.stringify(envio);
      if (entregado == 1) {
        $(this).removeClass('status-red');
        $(this).addClass('status-green');
        $(this).html('Si');
      } else {
        $(this).removeClass('status-green');
        $(this).addClass('status-red');
        $(this).html('No');
      }

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            if (entregado == 1) {
              swal({
                title: 'Bien!',
                text: 'Quieres generar un pendiente?',
                type: 'success',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Si!',
                cancelButtonText: 'No',
              }).then((a) => {
                if (!a.dismiss) {
                  window.open('/pendientes?new_pendiente=1');
                  swal.close();
                  iziToast.success({
                    title: 'Bien! ',
                    message: response.message,
                    timeout: 1000,
                    position: 'bottomLeft',
                  });
                }
              });
            }


            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ----------------------- STATUS ENTREGADO ----------------------
    //* **************************************************************

    //* **************************************************************
    // ------------------------- STATUS VENTA ------------------------
    //* **************************************************************
    $(document).on('click', '.status_venta', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      const tipo_cotizacion = $(this).parents('tr').attr('data-tipo-cotizacion');

      const template = `${'<div class="row">'
          + '<div class="col-md"><button type="button" class="btn btn-outline-danger w-100 venta_proceso" data-id-cotizacion="'}${id_cotizacion}" role="button">Proceso</button></div>`
          + `<div class="col-md"><button type="button" class="btn btn-outline-warning w-100 venta_no" data-id-cotizacion="${id_cotizacion}" role="button">No</button></div>`
          + `<div class="col-md"><button type="button" class="btn btn-outline-success w-100 ${(tipo_cotizacion == 1) ? 'venta_si' : 'venta_si_cctv'} " data-id-cotizacion="${id_cotizacion}" role="button">Si</button></div>`
          + '</div>';

      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 25,
        modalId: 'modal-venta-cotizacion',
        noFooter: true,
      });
    });

    $(document).on('click', '.venta_proceso', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = 0;
      envio.col = 'venta';
      envio = JSON.stringify(envio);
      $(this).removeClass('status-green');
      $(this).addClass('status-red');
      $(this).html('Proceso');
      $('#modal-venta-cotizacion').modal('hide');
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft',
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('click', '.venta_no', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      const clicked_td = $(`tr[data-id-cotizacion="${id_cotizacion}"] .status_procesar`);
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = 1;
      envio.col = 'venta';
      $('#modal-venta-cotizacion').modal('hide');
      swal({
        title: 'Motivo',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose() {
          $('body').removeAttr('style');
        },
        preConfirm(reason) {
          return new Promise(((resolve, reject) => {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              envio.obs = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: `${settings.cotizaciones.ruta_consultas}update_status`,
                data: envio,
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                success(response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: 'Error',
                      message: response.message,
                    });
                  }
                },
                error(xhr) {
                  iziToast.error({
                    title: 'Ocurrio un error: ',
                    message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                  });
                },
              });
            }
          }));
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          clicked_td.addClass('status-red');
          clicked_td.html('No');
          iziToast.success({
            title: 'Bien! ',
            message: 'Cambios guardados',
            timeout: 1000,
            position: 'bottomLeft',
          });
          autoUpdate.forceUpdate();
        }
      });
    });

    $(document).on('click', '.venta_si', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      let envio = {};
      envio.id_cotizacion = id_cotizacion;
      envio.new_val = 2;
      envio.col = 'venta';
      envio = JSON.stringify(envio);
      $(this).removeClass('status-green');
      $(this).addClass('status-red');
      $(this).html('Si');
      $('#modal-venta-cotizacion').modal('hide');
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}update_status`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft',
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------------- STATUS VENTA ------------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------- VER COTIZACIÓN ----------------------
    //* **************************************************************
    $(document).on('click', '.vista_cotizacion', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      window.open(`/cotizaciones/vista/${id_cotizacion}`);
    });

    $(document).on('click', '.vista_venta_cliente', function (e) {
      const id_cliente = $(this).parents('tr').attr('data-id-cliente');
      e.preventDefault();
      $(this).partnersModal({
        title: 'Datos Cliente',
        forceWidth: 95,
        modalId: 'panel-ventas-cliente',
        content: loader,
      });

      setTimeout(() => {
        vista_panel_ventas(id_cliente);
      }, 400);
    });

    $(document).on('click', '.vista_cotizacion_panel_ventas', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      window.open(`/cotizaciones/vista/${id_cotizacion}`);
    });


    $(document).on('click', '.agregar_licencia', function () {
      if (!$('#fecha_compra_licencia .input-group.date').datepicker('getDate')) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa la fecha de compra.',
        });
        return false;
      }

      if ($.trim($('.producto_licencia').val()) == '') {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa el producto.',
        });
        return false;
      }


      if ($.trim($('.serie_licencia').val()) == '') {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa la serie de la licencia.',
        });
        return false;
      }

      const btn = $(this);
      btn.partnersBtnControl('start');
      const id_cliente = $(this).attr('data-id-cliente');
      const datos = {};
      datos.fecha_compra = $('#fecha_compra_licencia .input-group.date').datepicker('getDate');
      datos.producto = $('.producto_licencia').val();
      datos.serie_licencia = $('.serie_licencia').val();
      datos.observaciones_licencia = $('.text_observaciones_licencia').val();
      datos.id_cliente = id_cliente;

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}agregar_nueva_licencia`,
        data: JSON.stringify(datos),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#panel-ventas-cliente .modal-body').html(loader);

            iziToast.success({
              title: 'Bien! ',
              message: response.message,
            });
            vista_panel_ventas(id_cliente);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('click', '.eliminar_licencia', function () {
      const id_licencia = $(this).parents('tr').attr('data-id-licencia');
      const id_cliente = $(this).parents('tr').attr('data-id-cliente');
      const datos = {};
      datos.id_licencia = id_licencia;
      datos.id_cliente = id_cliente;
      swal({
        title: 'Estás Seguro?',
        html: 'Deseas eliminar la licencia de este cliente?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Si, eliminar!',
        cancelButtonText: 'No!',
        showLoaderOnConfirm: true,
        onOpen() {
          fixBootstrapModal();
        },
        preConfirm() {
          return new Promise(((resolve) => {
            $.ajax({
              type: 'POST',
              url: `${settings.cotizaciones.ruta_consultas}eliminar_licencia`,
              data: JSON.stringify(datos),
              contentType: 'application/json; charset=utf-8',
              dataType: 'json',
              success(response) {
                if (response.status == 'success') {
                  $('#panel-ventas-cliente .modal-body').html(loader);
                  resolve();

                  vista_panel_ventas(id_cliente);
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: 'Error',
                    message: response.message,
                  });
                }
              },
              error(xhr) {
                iziToast.error({
                  title: 'Ocurrio un error: ',
                  message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                });
              },
            });
          }));
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          swal.close();
          autoUpdate.forceUpdate();
          iziToast.success({
            title: 'Bien!',
            message: 'Licencia eliminada correctamente.',
          });
        }
      });
    });


    $(document).on('click', '.observaciones_licencia', function () {
      const id_licencia = $(this).parents('tr').attr('data-id-licencia');
      const id_cliente = $(this).parents('tr').attr('data-id-cliente');
      $(this).partnersObs(
        {
          modalId: 'modal-panel-ventas-licencia-observaciones',
          ajaxUrl: `${settings.cotizaciones.ruta_sys_tools}load_obs`,
          index: 'id_licencia',
          id_index: id_licencia,
          tabla: 'partners_clientes_licencias',
          col: 'observaciones',
          ajaxSuccessCallback() {
            vista_panel_ventas(id_cliente);
          },
        },
      );
    });


    /**
       * Genera la vista del modal del panel de ventas de un cliente
       * @param id_cliente
       */
    function vista_panel_ventas(id_cliente) {
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}vista_panel_ventas`,
        data: JSON.stringify(id_cliente),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            setTimeout(() => {
              $('#panel-ventas-cliente .modal-body').html(response.message);
              $('#panel-ventas-cliente').attr('data-id-cliente', id_cliente);
              setTimeout(() => {
                $('#fecha_compra_licencia .input-group.date').datepicker({
                  format: 'dd/mm/yyyy',
                  todayBtn: 'linked',
                  language: 'es',
                  daysOfWeekDisabled: '0',
                  autoclose: true,
                  todayHighlight: true,
                  orientation: 'auto',
                  container: '.input-group.date',
                });

                $.fn.editable.defaults.mode = 'inline';
                $.fn.editable.defaults.emptytext = 'Vacío';
                $.fn.editable.defaults.url = ruta_url;
                $.fn.editable.defaults.send = 'always';
                $.fn.editable.defaults.disabled = false;
                $.fn.editable.defaults.ajaxOptions = {
                  type: 'POST',
                  contentType: 'application/json; charset=utf-8',
                  dataType: 'json',
                };
                $.fn.editable.defaults.success = function (response) {
                  if (response.status == 'success') {
                    iziToast.success({
                      title: 'Bien! ',
                      message: response.message,
                    });
                    autoUpdate.forceUpdate();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: 'Error',
                      message: response.message,
                    });
                  }
                };
                $.fn.editable.defaults.params = function params(params, el) {
                  const element = $(el);
                  const p = {};
                  p.edit_table = element.data('edit-table');
                  p.edit_col = element.data('edit-column');
                  p.edit_table_key = element.data('edit-table-key');
                  p.edit_id = element.data('edit-id');
                  p.new_val = params.value;
                  return p;
                };

                // Destroy All
                $('.editable-textarea-field').editable('destroy');

                // Textarea Field
                $('.editable-textarea-field').editable({
                  type: 'textarea',
                  rows: 5,
                });
              }, 100);

              // Ahora mostrar las renovaciones y cotizaciones de un cliente.
              mostrarCotizacionesRenovacionesCliente();
            }, 400);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    }

    /**
       * Función para consultar y mostrar de una manera paginada todas las renovaciones y cotizaciones
       * de un cliente.
       * @param id_cliente
       */
    const language = {
      sProcessing: 'Procesando...',
      sLengthMenu: 'Mostrar _MENU_ registros',
      sZeroRecords: 'No se encontraron resultados',
      sEmptyTable: 'Ningún dato disponible en esta tabla',
      sInfo: 'Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros',
      sInfoEmpty: 'Mostrando registros del 0 al 0 de un total de 0 registros',
      sInfoFiltered: '(filtrado de un total de _MAX_ registros)',
      sInfoPostFix: '',
      sSearch: 'Buscar:',
      sUrl: '',
      sInfoThousands: ',',
      sLoadingRecords: 'Cargando...',
      oPaginate: {
        sFirst: 'Primero',
        sLast: 'Último',
        sNext: 'Siguiente',
        sPrevious: 'Anterior',
      },
      oAria: {
        sSortAscending: ': Activar para ordenar la columna de manera ascendente',
        sSortDescending: ': Activar para ordenar la columna de manera descendente',
      },
    };

    function mostrarCotizacionesRenovacionesCliente() {
      $.fn.dataTable.moment('DD/MM/YY');
      $('#table_reporteador_cotizaciones_cliente').DataTable({
        language,
        order: [[1, 'desc']],
      });
      $('#table_reporteador_renovaciones').DataTable({
        language,
        order: [[0, 'desc']],
      });
    }

    //* **************************************************************
    // ------------------------- VER COTIZACIÓN ----------------------
    //* **************************************************************


    //* **************************************************************
    // ---------------------- REENVIAR COTIZACIÓN --------------------
    //* **************************************************************
    /**
     * Nuevo sistema de correos
     */
    $(document).on('click', '.reenviar_cotizacion', (e) => {
      const idCliente = +(e.currentTarget.closest('tr').getAttribute('data-id-cliente'));
      const idCotizacion = +(e.currentTarget.closest('tr').getAttribute('data-id-cotizacion'));
      // eslint-disable-next-line no-undef
      modalCorreo(
        idCliente,
        settings,
        idCotizacion,
        (emailsToSend, datos, body, hideModal) => {
          const data = {
            to: emailsToSend,
            id_cotizacion: datos,
            body,
          };
          $.ajax({
            type: 'POST',
            url: `${settings.cotizaciones.ruta_consultas}enviar_cotizacion_correo`,
            data: JSON.stringify(data),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success(response) {
              if (response.status === 'success') {
                // eslint-disable-next-line no-undef
                iziToast.success({
                  title: 'Listo',
                  message: 'Correos enviados',
                });
                hideModal(true);
                autoUpdate.forceUpdate();
              } else if (response.status === 'error') {
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: 'Error',
                  message: response.message,
                });
                hideModal(false);
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: 'Ocurrio un error: ',
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
              hideModal(false);
            },
          });
        },
      );
    });
    //* **************************************************************
    // ---------------------- REENVIAR COTIZACIÓN --------------------
    //* **************************************************************


    //* **************************************************************
    // ------------------------ ELIMINAR COTIZACIÓN  -----------------
    //* **************************************************************
    $(document).on('click', '.eliminar_cotizacion', function () {
      const id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
      swal({
        title: 'Estás Seguro?',
        html: `Deseas eliminar la cotización: ${id_cotizacion}?`,
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Si, eliminar!',
        cancelButtonText: 'No!',
        showLoaderOnConfirm: true,
        onOpen() {
          fixBootstrapModal();
        },
        onClose() {
          $('body').removeAttr('style');
          restoreBootstrapModal();
        },
        preConfirm() {
          return new Promise(((resolve) => {
            $.ajax({
              type: 'POST',
              url: `${settings.cotizaciones.ruta_consultas}eliminar_cotizacion`,
              data: id_cotizacion,
              contentType: 'application/json; charset=utf-8',
              dataType: 'json',
              success(response) {
                if (response.status == 'success') {
                  autoUpdate.forceUpdate();
                  setTimeout(() => {
                    undo_cotizacion_deleted(id_cotizacion);
                    swal.close();
                  }, 2000);
                  resolve();
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: 'Error',
                    message: response.message,
                  });
                }
              },
              error(xhr) {
                iziToast.error({
                  title: 'Ocurrio un error: ',
                  message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                });
              },
            });
          }));
        },
        allowOutsideClick: false,
      }).then((a) => {
        if (!a.dismiss) {
          swal('Eliminada!', 'La cotización se ha eliminado correctamente.', 'success');
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_cotizacion_deleted(id_cotizacion) {
      iziToast.show({
        title: `Cotización ${id_cotizacion}`,
        message: ' ha sido eliminada.',
        position: 'bottomLeft',
        timeout: 10000,
        color: 'dark',
        progressBarColor: 'rgb(0, 255, 184)',
        icon: 'fa fa-ban',
        buttons: [
          [`<button data-id-cotizacion="${id_cotizacion}" class="cotizacion_undo_delete">Deshacer</button>`, function (instance, toast) {
            instance.hide({
              transitionOut: 'fadeOutUp',
            }, toast, 'close');
          }],
        ],
      });
    }

    $(document).on('click', '.cotizacion_undo_delete', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}reactivate_cotizacion`,
        data: id_cotizacion,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: `Cotización ${id_cotizacion}`,
              message: ' ha sido traida de vuelta a la vida!',
              icon: 'fa fa-usd',
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------------ ELIMINAR COTIZACIÓN  -----------------
    //* **************************************************************

    //* **************************************************************
    // ----------------------- STATUS COMPARTIDO CON -----------------
    //* **************************************************************
    $(document).on('mouseenter', '.show_compartido_con', function () {
      $(this).html($(this).attr('data-compartido-con'));
    });

    $(document).on('mouseleave', '.show_compartido_con', function () {
      $(this).html($(this).attr('data-current-text'));
    });
    //* **************************************************************
    // ----------------------- STATUS COMPARTIDO CON -----------------
    //* **************************************************************


    //* **************************************************************
    // ------------------ NUEVA COTIZACION PROYECTOS  ----------------
    //* **************************************************************
    $(document).on('click', '.nueva_cotizacion_proyecto', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Nueva Cotización',
        forceWidth: 95,
        modalId: 'nueva-cotizacion-proyecto-modal',
        content: loader,
      });

      if ($('#convertir-proyecto-cotizcion-modal').length > 0) {
        $('#convertir-proyecto-cotizcion-modal').remove();
      }
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}nueva_cotizacion_proyecto`,
        data: JSON.stringify(1),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('#nueva-cotizacion-proyecto-modal .modal-body').html(response.message);
            setTimeout(() => {
              $('#buscar_cliente').typeahead({
                order: 'asc',
                minlength: 1,
                maxItem: 15,
                hint: true,
                accent: true,
                group: {
                  template: '{{group}}',
                },
                maxItemPerGroup: 5,
                backdrop: {
                  'background-color': '#fff',
                },
                template(query, item) {
                  let color_t_clasificacion;
                  let tipo_clasificacion = item.tipo_clasificacion;
                  switch (tipo_clasificacion) {
                    case 'a':
                      color_t_clasificacion = 'success';
                      break;
                    case 'b':
                      color_t_clasificacion = 'success';
                      break;
                    case 'c':
                      color_t_clasificacion = 'warning';
                      break;
                    case 'd':
                      color_t_clasificacion = 'danger';
                      break;
                    case 'e':
                      color_t_clasificacion = 'danger';
                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();

                  const credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                  if (item.tipo_cliente != 3) {
                    return `${'<p>'
                        + '<span>{{nombre_cliente}}</span> '
                        + '<span class="float-right badge badge-'}${color_t_clasificacion}">`
                        + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                        } | ${credito_contado}</span> </p> `;
                  }
                  return '<p><span>{{nombre_cliente}}</span> </p> ';
                },
                dynamic: true,
                dropdownFilter: 'Todos',
                emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
                source: {
                  Clientes: {
                    display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                    ajax: {
                      url: `${settings.cotizaciones.ruta_lista_clientes}complete`,
                      path: 'data.datos.clientes',
                    },
                  },
                  Contactos: {
                    display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                    ajax: {
                      url: `${settings.cotizaciones.ruta_lista_clientes}complete`,
                      path: 'data.datos.contactos',
                    },
                  },
                  Proveedores: {
                    display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                    ajax: {
                      url: `${settings.cotizaciones.ruta_lista_clientes}complete`,
                      path: 'data.datos.proveedores',
                    },
                  },
                },
                callback: {
                  onClickAfter(node, a, item) {
                    let color_t_clasificacion;
                    let tipo_clasificacion = item.tipo_clasificacion;
                    switch (tipo_clasificacion) {
                      case 'a':
                        color_t_clasificacion = 'success';
                        break;
                      case 'b':
                        color_t_clasificacion = 'success';
                        break;
                      case 'c':
                        color_t_clasificacion = 'warning';
                        break;
                      case 'd':
                        color_t_clasificacion = 'danger';
                        break;
                      case 'e':
                        color_t_clasificacion = 'danger';
                        break;
                    }
                    tipo_clasificacion = tipo_clasificacion.toUpperCase();
                    const credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                    if (item.tipo_cliente != 3) {
                      $('.quick_info_client').html(`<span class="badge badge-${color_t_clasificacion}">`
                          + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                          } | ${credito_contado}</span> </p> `);
                      const id_cliente = item.id_cliente;
                      prepareEvs(1, {
                        color_t_clasificacion,
                        tipo_clasificacion,
                        credito_contado,
                        id_cliente,
                        settings,
                      });
                    }


                    // Bindear el id del cliente al input
                    node.attr('data-id-cliente', item.id_cliente);
                    node.attr('data-email-cliente', item.email);

                    // Generar lista contactos solo para clientes Negocio/Distribuidor
                    if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                      generar_contactos(settings.cotizaciones.ruta_lista_contactos, item.id_cliente);

                      // Solamente agrega este attr cuando debe de tener contactos
                      node.attr('data-tipo-negocio', item.tipo_negocio);
                    } else {
                      $('.contacto_container').hide();
                      $('.select_lista_contactos').empty();
                    }
                  },
                  onSearch(node, a) {
                    if (a !== '') {
                    } else {
                      // Para prevenir errores de sobrescribir o duplicar
                      $('.contacto_container').hide();
                      $('.select_lista_contactos').empty();
                      $('.quick_info_client').html('');
                      node.removeAttr('data-id-cliente');
                      node.removeAttr('data-tipo-negocio');
                      node.removeAttr('data-email-cliente');
                    }
                  },

                },
              });

              $.validate({
                form: '#nueva_cotizacion_proyecto_form',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid',
              });
              if (open_cotizacion) {
                $('#nueva_cotizacion_proyecto_form').attr('data-pendiente', open_cotizacion);
              }
            }, 400);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('change', '.select_cotizacion_compartida_proyecto', function () {
      if ($(this).val() == 1) {
        $('.cotizacion_compartida_container_proyecto').show();
      } else {
        $('.cotizacion_compartida_container_proyecto').hide();
      }
    });
    $(document).on('click', '.agregar_entity_cotizacion_proyecto', () => {
      const cantidad = $('.cantidad_cotizacion_proyecto').val();
      const tipo = $('select[name="tipo_entity_cotizacion_proyecto"] option:selected').val();
      const descripcion = $('.descripcion_cotizacion_proyecto').val();
      const precio = $('.precio_cotizacion_proyecto').val();

      if ($.trim(cantidad).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una cantidad',
        });
        return false;
      }

      if (isNaN(cantidad)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa una cantidad correcta',
        });
        return false;
      }

      if (!tipo) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un tipo',
        });
        return false;
      }

      if ($.trim(descripcion).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una descripción',
        });
        return false;
      }

      if ($.trim(precio).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega un precio',
        });
        return false;
      }

      if (isNaN(precio)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un precio correcto',
        });
        return false;
      }


      const tipo_text = (tipo == 1) ? 'Pieza' : 'Servicio';
      const tr = $(`${'<tr class="entity_cotizacion_proyecto" >'
          + '<td class="entity_cotizacion_cantidad_proyecto">'}${cantidad}</td>`
          + `<td class="entity_cotizacion_tipo_proyecto" data-tipo="${tipo}">${tipo_text}</td>`
          + `<td class="entity_cotizacion_descripcion_proyecto" style="word-break: break-all;">${descripcion}</td>`
          + `<td class="text-right entity_cotizacion_precio_proyecto" data-precio="${precio}">${parseFloat(precio).format(2)}</td>`
          + `<td class="text-right entity_cotizacion_subtotal_proyecto" data-subtotal="${precio * cantidad}">${(precio * cantidad).format(2)}</td>`
          + '<td class="eliminar_entity_cotizacion_proyecto text-center text-danger cursor-pointer">Eliminar</td>'
          + '</tr>');
      $('.table-entities-cotizacion-proyecto tbody').append(tr);
      sumar_total_entities_cotizacion_proyecto();
      $('.cantidad_cotizacion_proyecto').val('');
      $('.descripcion_cotizacion_proyecto').val('');
      $('.precio_cotizacion_proyecto').val('');
      $('.cantidad_cotizacion_proyecto').focus();
    });

    function sumar_total_entities_cotizacion_proyecto() {
      let total = 0;
      $('.entity_cotizacion_subtotal_proyecto').each(function () {
        total += parseFloat($(this).attr('data-subtotal'));
      });
      $('.table-entities-cotizacion-proyecto .total_cotizacion_proyecto').html(parseFloat(total).format(2));
    }


    $(document).on('click', '.eliminar_entity_cotizacion_proyecto', function () {
      $(this).parents('tr').remove();
      sumar_total_entities_cotizacion_proyecto();
    });

    $(document).on('submit', '#nueva_cotizacion_proyecto_form', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      const datos = $('#nueva_cotizacion_proyecto_form').serializeArray();
      const datosEnvio = {};
      for (let i = 0; i < datos.length; i++) {
        datosEnvio[datos[i].name] = datos[i].value;
      }
      datosEnvio.datos = [];
      $('.entity_cotizacion_proyecto').each(function () {
        datosEnvio.datos.push({
          cantidad: $(this).find('.entity_cotizacion_cantidad_proyecto').text(),
          descripcion: $(this).find('.entity_cotizacion_descripcion_proyecto').text(),
          precio: $(this).find('.entity_cotizacion_precio_proyecto').attr('data-precio'),
          tipo: $(this).find('.entity_cotizacion_tipo_proyecto').attr('data-tipo'),
        });
      });

      if (!$('#buscar_cliente').attr('data-id-cliente')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un Cliente',
        });
        return false;
      }

      if ($('#buscar_cliente').attr('data-tipo-negocio')) {
        if ($('.select_lista_contactos').find('option:selected').val() == 0) {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona un Contacto',
          });
          return false;
        }
      }

      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes agregar al menos un producto a la cotización',
        });
        return false;
      }

      btn.partnersBtnControl('start');

      if ($('.select_cotizacion_compartida_proyecto:checked').val() == 1) {
        datosEnvio.compartida_con = $('.cotizacion_compartida_con_proyecto option:selected').val();
      }
      datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
      datosEnvio.id_contacto = $('.select_lista_contactos').find('option:selected').val();

      const email_contacto = ($('.select_lista_contactos').find('option:selected').attr('data-email-contacto')) ? $('.select_lista_contactos').find('option:selected').attr('data-email-contacto') : '';
      const email_cliente = $('#buscar_cliente').attr('data-email-cliente');
      const email_user = $(this).attr('data-user-email');

      if (open_cotizacion) {
        datosEnvio.finish_pendiente = open_cotizacion;
      }
      const envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}capturar_cotizacion_proyecto`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            const id_cotizacion = response.message;
            swal({
              title: 'Enviar',
              text: 'Deseas enviar la cotización por correo?',
              type: 'info',
              showCancelButton: true,
              cancelButtonColor: '#DD6B55',
              confirmButtonText: 'Si, enviar!',
              cancelButtonText: 'No!',
              confirmButtonClass: 'btn btn-success',
              cancelButtonClass: 'btn btn-danger',
              allowOutsideClick: false,
              allowEscapeKey: false,
              onClose() {
                $('body').removeAttr('style');
              },
            }).then((a) => {
              if (!a.dismiss) {
                btn.partnersBtnControl('end');
                const idCliente = $('#buscar_cliente').attr('data-id-cliente');
                // eslint-disable-next-line no-undef
                modalCorreo(
                  idCliente,
                  settings,
                  id_cotizacion,
                  (emailsToSend, ddatos, body, hideModal) => {
                    const data = {
                      to: emailsToSend,
                      id_cotizacion: ddatos,
                      body,
                    };
                    $.ajax({
                      type: 'POST',
                      url: `${settings.cotizaciones.ruta_consultas}enviar_cotizacion_correo`,
                      data: JSON.stringify(data),
                      contentType: 'application/json; charset=utf-8',
                      dataType: 'json',
                      success(res) {
                        if (res.status === 'success') {
                        // eslint-disable-next-line no-undef
                          iziToast.success({
                            title: 'Listo',
                            message: 'Correos enviados',
                          });
                          hideModal(true);
                        } else if (res.status === 'error') {
                        // eslint-disable-next-line no-undef
                          iziToast.error({
                            title: 'Error',
                            message: res.message,
                          });
                          hideModal(false);
                        }
                      },
                      error(xhr) {
                      // eslint-disable-next-line no-undef
                        iziToast.error({
                          title: 'Ocurrio un error: ',
                          message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
                        });
                        hideModal(false);
                      },
                    });
                  }, {}, () => {
                    window.open('/cotizaciones/vista/' + id_cotizacion);
                    $('#nueva-cotizacion-modal').modal('hide');
                    autoUpdate.forceUpdate();
                  }
                );
              } else if (a.dismiss == 'cancel') {
                swal({
                  title: 'Bien!',
                  text: 'Se guardo normalmente la cotización.',
                  timer: 2000,
                  type: 'success',
                  showConfirmButton: false,
                });
                autoUpdate.forceUpdate();
                window.open(`/cotizaciones/vista/${id_cotizacion}`);
                $('#nueva-cotizacion-proyecto-modal').modal('hide');
              }
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('click', '.venta_si_cctv', function () {
      const id_cotizacion = $(this).attr('data-id-cotizacion');
      $('#modal-venta-cotizacion').modal('hide');
      setTimeout(function () {
        $(this).partnersModal({
          title: 'Convertir a Proyecto',
          modalId: 'convertir-proyecto-cotizcion-modal',
          forceWidth: 95,
          content: loader,
        });
      }, 400);

      // Para solamente mantener un modal abierto, y no tener que repetir el codigo para agregar al cotizador
      if ($('#nueva-cotizacion-proyecto-modal').length > 0) {
        $('#nueva-cotizacion-proyecto-modal').remove();
      }


      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}vista_convertir_proyecto`,
        data: id_cotizacion,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            setTimeout(() => {
              $('#convertir-proyecto-cotizcion-modal .modal-body').html(response.message);
              sumar_total_entities_cotizacion_proyecto();
            }, 400);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });

    $(document).on('submit', '#convertir_cotizacion_proyecto_form', function (e) {
      e.preventDefault();
      const btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      const datos = $('#convertir_cotizacion_proyecto_form').serializeArray();
      const datosEnvio = {};
      for (let i = 0; i < datos.length; i++) {
        datosEnvio[datos[i].name] = datos[i].value;
      }
      datosEnvio.datos = [];
      $('.entity_cotizacion_proyecto').each(function () {
        datosEnvio.datos.push({
          cantidad: $(this).find('.entity_cotizacion_cantidad_proyecto').text(),
          descripcion: $(this).find('.entity_cotizacion_descripcion_proyecto').text(),
          precio: $(this).find('.entity_cotizacion_precio_proyecto').attr('data-precio'),
          tipo: $(this).find('.entity_cotizacion_tipo_proyecto').attr('data-tipo'),
        });
      });
      datosEnvio.id_cotizacion = $(this).attr('data-id-cotizacion');
      datosEnvio.opened_from_pendiente = $(this).attr('data-opened-from-pendiente');
      datosEnvio.id_cliente = $(this).attr('data-id-cliente');
      datosEnvio.id_contacto = $(this).attr('data-id-contacto');
      const envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}capturar_convertir_cotizacion`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Bien! ',
              message: response.message,
            });
            $('#convertir-proyecto-cotizcion-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // ------------------ NUEVA COTIZACION PROYECTOS  ----------------
    //* **************************************************************


    //* **************************************************************
    // -------------------- COTIZACIONES INFORM ERRORS ---------------
    //* **************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      const error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_sys_tools}report_error`,
        data: JSON.stringify(error),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: 'Se ha enviado el error!',
              type: 'success',
              text: 'Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.',
              timer: 4000,
              showConfirmButton: false,
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // -------------------- COTIZACIONES INFORM ERRORS ---------------
    //* **************************************************************


    //* **************************************************************
    // --------------------- COTIZACIONES VER FACTURA  ---------------
    //* **************************************************************
    $(document).on('click', '.ver_factura', function () {
      const id_factura = $(this).text();
      $(this).partnersModal({
        title: `Factura ${id_factura}`,
        modalId: 'vista-factura',
        forceWidth: 90,
        content: loader,
      });
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_sys_tools}get_full_factura`,
        data: JSON.stringify(id_factura),
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            if (response.message == 'not_on_server') {
              var content = "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content = `${'<div>'
                  + '<iframe src="/system/tools/vista_factura?factura='}${response.message}" width="100%;" height="600px;"></iframe>`
                  + '</div>';
            }
            $('#vista-factura .modal-body').html(content);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
        },
      });
    });
    //* **************************************************************
    // --------------------- COTIZACIONES VER FACTURA  ---------------
    //* **************************************************************

    //* **************************************************************
    // ---------------- COTIZACIONES GENERAR VISTA PREVIA ------------
    //* **************************************************************
    $(document).on('click', '.generar_vista_previa', function (e) {
      e.preventDefault();
      const btn = $(this);
      const datos = $('#nueva_cotizacion_form').serializeArray();
      const datosEnvio = {};
      for (let i = 0; i < datos.length; i++) {
        datosEnvio[datos[i].name] = datos[i].value;
      }
      datosEnvio.datos = [];
      $('.entity_cotizacion').each(function () {
        datosEnvio.datos.push({
          cantidad: $(this).find('.entity_cotizacion_cantidad').text(),
          descripcion: $(this).find('.entity_cotizacion_descripcion').text(),
          precio: $(this).find('.entity_cotizacion_precio').attr('data-precio'),
          img: $(this).find('.entity_cotizacion_imagen img').attr('src') ? $(this).find('.entity_cotizacion_imagen img').attr('src') : false,
        });
      });

      if (!$('#buscar_cliente').attr('data-id-cliente')) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un Cliente',
        });
        return false;
      }

      if ($('#buscar_cliente').attr('data-tipo-negocio')) {
        if ($('.select_lista_contactos').find('option:selected').val() == 0) {
          iziToast.error({
            title: 'Error',
            message: 'Selecciona un Contacto',
          });
          return false;
        }
      }

      if (datosEnvio.datos.length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Debes agregar al menos un producto a la cotización',
        });
        return false;
      }


      if ($('.select_cotizacion_compartida:checked').val() == 1) {
        datosEnvio.compartida_con = $('.cotizacion_compartida_con option:selected').val();
      }
      datosEnvio.id_cliente = $('#buscar_cliente').attr('data-id-cliente');
      datosEnvio.id_contacto = $('.select_lista_contactos').find('option:selected').val();
      if (open_cotizacion) {
        datosEnvio.finish_pendiente = open_cotizacion;
      }

      try {
        if (!$('#nueva_cotizacion_form').isValid()) {
          iziToast.error({
            title: 'Error',
            message: 'Llena todos los campos obligatorios.',
          });
          return false;
        }
      } catch (err) {
        iziToast.error({
          title: 'Error',
          message: 'Llena todos los campos obligatorios.',
        });
        return false;
      }

      btn.partnersBtnControl('start');

      const envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: `${settings.cotizaciones.ruta_consultas}vista_previa_cotizacion`,
        data: envio,
        contentType: 'application/json; charset=utf-8',
        dataType: 'json',
        success(response) {
          if (response.status == 'success') {
            const obj = document.createElement('object');
            obj.style.width = '100%';
            obj.style.height = '800px';
            obj.type = 'application/pdf';
            obj.data = `data:application/pdf;base64,${response.message}`;
            setTimeout(() => {
              swal({
                html: obj,
                width: '60%',
              });
              btn.partnersBtnControl('end');
            }, 400);
          } else if (response.status == 'error') {
            iziToast.error({
              title: 'Error',
              message: response.message,
            });
            btn.partnersBtnControl('end');
          }
        },
        error(xhr) {
          iziToast.error({
            title: 'Ocurrio un error: ',
            message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
          });
          btn.partnersBtnControl('end');
        },
      });
    });
    //* **************************************************************
    // ---------------- COTIZACIONES GENERAR VISTA PREVIA ------------
    //* **************************************************************
  });
}(jQuery));
