// eslint-disable-next-line no-undef,no-underscore-dangle
const _correo$ = jQuery;

/**
 * Abrir modal de correos
 *
 * @param {number} idCliente
 * @param {Object} settings
 * @param {any} _datos
 * @param {mailCallback} sendMail
 * @param {Object} condition
 * @param onClose
 * @param selfAuto
 */
// eslint-disable-next-line no-unused-vars
const modalCorreo = (idCliente, settings, _datos, sendMail, condition = {}, onClose = () => { }, selfAuto = true) => {
  const DATA = {
    idCliente,
    condition,
  };
  _correo$.ajax({
    type: 'POST',
    url: `${settings.clientes.ruta_capturar}get_contactos_cliente_by_id`,
    data: JSON.stringify(DATA),
    contentType: 'application/json; charset=utf-8',
    dataType: 'json',
    success: (res) => {
      if (res.status === 'success') {
        const data = JSON.parse(res.message);
        let html = "<div class='row'>"
          + "<div class='col-md-12'>";
        // No existe el cliente, por lo tanto avisar que no existe y proporcionar botón para agregarlo.
        if (data.idCliente === 0) {
          html += `<p class='text-danger'>No existe ningún cliente con el ID <span class='font-weight-bold'>${idCliente}</span> en nuestra base de datos, `
            + 'si quieres usar sus contactos, '
            + 'tienes que <a href=\'/clientes?new_cliente=1\' target=\'_blank\'>Agregar el cliente</a> y '
            + 'después repetir este proceso, sino, puedes simplemente enviar los datos a cualquier correo.</p>';
          // campo de cuerpo de correo
          html += '<div class="mb-2">'
            + '<p class="lead">Texto extra para el correo</p>'
            + '<textarea class="form-control email-body-content" cols="30" rows="5"></textarea>'
            + '</div>';
          // .
        } else if (data.contactos.length === 0) {
          // Si no tiene contactos, permitir agregar y mostrar mensaje.
          html += `<p class='text-danger'>El cliente <span class='font-weight-bold'>${data.nombreCliente}</span> no cuenta con ningún contacto, `
            + `si quieres usarlos, tienes que <a href='/clientes?id_cliente=${idCliente}&type=1' class='close_modal_contacto_enviar_correo' target='_blank'>Agregar contactos </a>`
            + 'y después repetir este proceso, sino, puedes simplemente enviar los datos a cualquier correo.'
            + '</p>';
          // campo de cuerpo de correo
          html += '<div class="mb-2">'
            + '<p class="lead">Texto extra para el correo</p>'
            + '<textarea class="form-control email-body-content" cols="30" rows="5"></textarea>'
            + '</div>';
          // .
        }
        // Si tiene contactos, generar una lista.
        html += `<div class='row my-3'><div class='col-md-5'><p class='lead'>Lista de Contactos de ${data.nombreCliente}, selecciona mínimo uno.</p><a href='/clientes?id_cliente=${data.idCliente}&type=1' target='_blank' class='btn btn-sm btn-success mb-3 close_modal_contacto_enviar_correo'>Agregar contacto </a>`
          + '<div style=\'max-height: 300px; height: auto; overflow-y: scroll;\' class=\'list-group list-group-contactos\'>';
        // eslint-disable-next-line no-undef
        _.forEach(data.contactos, (v) => {
          html += `<a class='list-group-item list-group-item-action contacto-item' style='cursor:pointer;' data-email='${v.email}'>${v.nombreContacto}</a>`;
        });
        html += '</div></div>';
        // campo de cuerpo de correo
        html += '<div class="col-md-7">'
          + '<p class="lead">Texto extra para el correo</p>'
          + '<textarea class="form-control email-body-content" cols="30" rows="5"></textarea>'
          + '</div>';
        // .
        html += '</div>';
        html += '</div></div>';
        html += "<div class='row'>"
          + "<div class='col-md-12'>"
          + "<input class='form-control emails_to_send' placeholder='Ingresa aquí los correos' type='text'>"
          + '</div>';
        if (selfAuto) {
          html += "<div class='col-md-12'><small><i class='text-info'>*Se enviará una copia para ti automáticamente.</i></small></div>";
        }
        html += '</div>';
        html += `${"<div class='row'>"
          + "<div class='col-md-12'>"
          + "<button class='send_correo btn btn-success float-right' data-id-cliente='"}${idCliente}'>Enviar</button>`
          + '</div>'
          + '</div>';
        _correo$(this).partnersModal({
          title: 'Enviar Correo',
          modalSize: 'modal-lg',
          modalId: 'modal-enviar-correo',
          content: html,
          forceWidth: 80,
        });

        _correo$('#modal-enviar-correo').on('hidden.bs.modal', () => {
          onClose();
          // Verificamos si hay algún modal abierto para mantener la clase `modal-open`
          if (document.getElementsByClassName('modal').length > 0) {
            _correo$('body').addClass('modal-open');
          }
          // .
        });



        setTimeout(() => {
          const EMAILS_TO_SEND = _correo$('input[type="text"].emails_to_send');
          EMAILS_TO_SEND.focus();
          EMAILS_TO_SEND.tagsinput();
          EMAILS_TO_SEND.on('beforeItemAdd', (event) => {
            // eslint-disable-next-line no-undef
            if (!validateEmail(event.item)) {
              // eslint-disable-next-line no-param-reassign
              event.cancel = true;
            }
          });
        }, 400);

        // Poner el correo de los contactos seleccionados
        [...document.getElementsByClassName('contacto-item')].forEach(el => el.addEventListener('click', (ev) => {
          const ELEMENT = ev.currentTarget;
          if (ELEMENT.classList.contains('active')) {
            // Quitar la clase y quitar de la lista de correos.
            ELEMENT.classList.remove('active');
            ELEMENT.classList.remove('text-white');
            _correo$('input[type="text"].emails_to_send').tagsinput('remove', ELEMENT.getAttribute('data-email'));

          } else {
            // Agregar la clase y agregar a la lista de correos.
            ELEMENT.classList.add('active');
            ELEMENT.classList.add('text-white');
            _correo$('input[type="text"].emails_to_send').tagsinput('add', ELEMENT.getAttribute('data-email'));

          }
        }));
        // .
        // Cerror modal y agregar contacto
        const AGREGAR_CONTACTO = document.getElementsByClassName('close_modal_contacto_enviar_correo');
        if (AGREGAR_CONTACTO.length > 0) {
          AGREGAR_CONTACTO[0].addEventListener('click', () => {
            _correo$('#modal-enviar-correo').modal('hide');
          });
        }
        // .

        // Enviar correo
        const ENVIAR_CORREO = document.getElementsByClassName('send_correo');
        if (ENVIAR_CORREO.length > 0) {
          ENVIAR_CORREO[0].addEventListener('click', (ev) => {
            const BTN = _correo$(ev.currentTarget);
            BTN.partnersBtnControl('start');
            const emailsToSend = _correo$('input[type="text"].emails_to_send').tagsinput('items');
            const mailBody = document.getElementsByClassName('email-body-content');
            let body = '';
            if (mailBody.length > 0) {
              body = mailBody[0].value;
            }
            sendMail(emailsToSend, _datos, body, (status) => {
              if (status) _correo$('#modal-enviar-correo').modal('hide');
              else BTN.partnersBtnControl('end');
            });
          });
        }
        // .
      } else {
        // eslint-disable-next-line no-undef
        iziToast.error({
          title: 'Ocurrio un error: ',
          message: `Request Status: ${res.status} Status Text: ${res.message}`,
        });
      }
    },
    error: (xhr) => {
      // eslint-disable-next-line no-undef
      iziToast.error({
        title: 'Ocurrio un error: ',
        message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
      });
    },
  });
};

/**
 * enviar correo
 * @callback mailCallback
 * @param {string[]} correos
 * @param {any} datos
 * @param {string} body
 * @param {hideMailModal} hideModal
 */

/**
 * Esconder modal
 * @callback hideMailModal
 * @param {boolean} status
 */
