(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//--------------------- REPORTE BASE REP ------------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'DESC',
        sort_by: 'folio'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'reporte_base_rep',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      $('.input_buscador_rep').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_rep', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_rep").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

//***************************************************************
//--------------------- REPORTE BASE REP ------------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//------------------------ REP OBSERVACIONES --------------------
//***************************************************************
    $(document).on('click', '.status_obs', function () {
      var folio = $(this).parents('tr').attr('data-folio');
      $(this).partnersObs(
        {
          modalId: 'modal-rep-observaciones',
          ajaxUrl: settings.cobranza.ruta_sys_tools + 'load_obs',
          index: 'folio',
          id_index: folio,
          tabla: 'partners_rep',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });
//***************************************************************
//------------------------ REP OBSERVACIONES --------------------
//***************************************************************

//***************************************************************
//------------------------ REP ENVIAR CORREO --------------------
//***************************************************************
    $(document).on('click', '.enviar_rep', function () {
      $(this).partnersModal({
        title: 'Enviar Rep',
        forceWidth: 45,
        modalId: 'enviar-rep-modal',
        content: loader
      });
      var tr = $(this).parents('tr');
      var envio = {};
      envio.rep = tr.attr('data-folio');
      envio.nombre_cliente = tr.attr('data-nombre-cliente');
      envio.folio_factura = tr.attr('data-folio');
      envio.rfc = tr.attr('data-rfc');
      envio.filename = tr.attr('data-filename');
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'vista_enviar_rep',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#enviar-rep-modal .modal-body').html(response.message);
            setTimeout(function () {
              $('input[type="text"].emails_to_send').focus();
              $('input[type="text"].emails_to_send').tagsinput();
              $('input[type="text"].emails_to_send').on('beforeItemAdd', function (event) {
                if (!validateEmail(event.item)) {
                  event.cancel = true;
                }
              });
            }, 400);

          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('change', '.enviarme_copia_correo', function () {
      var user_email = $(this).attr('data-user-email');
      if ($(this).is(':checked')) {
        $('input[type="text"].emails_to_send').tagsinput('add', user_email);
      } else {
        $('input[type="text"].emails_to_send').tagsinput('remove', user_email);
      }
    });

    $(document).on('click', '.enviar_correo_rep', function () {
      var btn = $(this);
      var emails = $('input[type="text"].emails_to_send').val();
      var folio = btn.attr('data-folio');
      var filename = btn.attr('data-filename');
      var emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
      var envio = {};
      envio.emails = emails;
      envio.folio = folio;
      envio.filename = filename;

      if ((emails == '' || !emails) && !$('.enviarme_copia_correo').is(':checked')) {
        iziToast.error({
          title: 'Error',
          message: "Ingresa al menos un correo, o enviate una copia."
        });
        return false;
      }

      envio = JSON.stringify(envio);
      btn.partnersBtnControl('start');
      console.log(envio);
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'enviar_correo_rep',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var timeout = emails_arr.length * 800;
            var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';
            iziToast.show({
              message: x,
              position: 'center',
              timeout: timeout,
              progressBar: false,
              color: 'dark',
              icon: 'fa fa-envelope-open-o',
              iconColor: '#fff'
            });
            var morphext = $("#js-rotating").Morphext({
              animation: "fadeInDownCustom",
              separator: ",",
              speed: 800
            });
            var data;
            data = morphext.data("plugin_Morphext");
            setTimeout(function () {
              data.stop();
            }, timeout - 800);

            setTimeout(function () {
              $('#enviar-rep-modal').modal('hide');
              iziToast.success({
                title: "Bien! ",
                message: response.message
              });
            }, timeout);
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------ REP ENVIAR CORREO --------------------
//***************************************************************

  });
})
(jQuery);



