(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

        $('#reporteador').parents('.container-fluid').find('.main-content').removeClass('row').addClass('col-md-12');
        $('#reporteador').parents('.grid-80').removeClass('grid-80');
        $('#reporteador').parents('.region-content').css('margin-bottom', '0px');

//***************************************************************
//-------------------- PROCESAR TOKEN ESTADO CUENTA  ------------
//***************************************************************
        var token;
        if (getUrlVars()['token']) {
            token = getUrlVars()['token'];
            setTimeout(function () {
                process_token(token);
            }, 500);
        } else {
            $('#reporteador').html("<h2 class='text-danger text-center'>Hay problema con la URL, asegurate que sea la correcta.</h2>");
        }


        /**
         * Procesa el token que se recibió, en caso de ser correcto, mostrará el estado de cuenta del cliente.
         * @param token
         */
        function process_token(token) {
            $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_facturacion_process_estado_cuenta,
                data: JSON.stringify(token),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        var data = JSON.parse(response.message);
                        $('#reporteador').html(data.table);
                        $('#table_estado_cuenta').partnersfilter({
                            sumatory: true,
                            sumatory_cols: ["total-col", "saldo-col"]
                        });
                        $('.nombre_cliente').html("Nombre Cliente: <span class='data_nombre_cliente font-weight-bold'>" + data.nombre_cliente + "</span>");
                        $('.fecha_corte').html("Fecha de Corte: " + data.fecha_corte);
                        $('.footer-container-info').show();

                        // Agregar el RFC que será usado solo internamete, con usuarios con permisos.
                        // Usado para buscar el cliente en nuestra base de datos.
                        $('.enviar_estado_cuenta').show();
                        $('.enviar_estado_cuenta').attr('data-rfc', data.rfc_cliente);
                    } else if (response.status == 'error') {
                        $('#reporteador').html("");
                        $('.nombre_cliente').html("");
                        $('.fecha_corte').html("");
                        $('.footer-container-info').hide();
                        $('.enviar_estado_cuenta').hide();
                        $('#reporteador').html("<h2 class='text-danger text-center'>" + response.message + "</h2>");
                    }
                },
                error: function (xhr) {
                    $('#reporteador').html("");
                    $('.nombre_cliente').html("");
                    $('.fecha_corte').html("");
                    $('.footer-container-info').hide();
                    $('.enviar_estado_cuenta').hide();
                    $('#reporteador').html("<h2 class='text-danger text-center'>" + xhr.statusText + "</h2>");
                }
            });
        }

//***************************************************************
//-------------------- PROCESAR TOKEN ESTADO CUENTA  ------------
//***************************************************************


//***************************************************************
//----------------------- VER PDF FACTURA  ----------------------
//***************************************************************
        $(document).on('click', '.ver_pdf_factura', function (e) {
            e.preventDefault();
            var tk = $(this).attr('data-token');
            var id_factura = $(this).parents('tr').attr('data-folio');
            var content = '<div>' +
                '<iframe src="/facturacion/solicitud_archivos?token=' + tk + '" width="100%;" height="600px;"></iframe>' +
                '</div>';
            $(this).partnersModal({
                title: 'Factura ' + id_factura,
                modalId: 'vista-factura',
                forceWidth: 90,
                content: content
            });
        });
//***************************************************************
//----------------------- VER PDF FACTURA  ----------------------
//***************************************************************


//***************************************************************
//--------------------- DESCARGAR XML FACTURA  ------------------
//***************************************************************
        $(document).on('click', '.descargar_xml_factura', function (e) {
            e.preventDefault();
            var tk = $(this).attr('data-token');

            swal({
                type: 'info',
                title: 'Espera',
                text: 'Estamos procesando tu archivo.',
                showConfirmButton: false,
                allowEscapeKey: false,
                allowOutsideClick: false
            });

            $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_get_file_url,
                data: JSON.stringify(tk),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        var data = JSON.parse(response.message);
                        downloadFile(data.file, function () {
                            setTimeout(function () {
                                swal({
                                    type: 'success',
                                    title: 'Bien!',
                                    text: 'XML descargado correctamente',
                                    timer: 2000
                                });
                            }, 1000);
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });

        /**
         * Utilizado para forzar la descarga de archivos sin necesidad de abrir nunevas pestañas.
         * @param url: Url del archivo a descargar
         * @cb Callback
         */
        function downloadFile(url, cb) {
            var iframe;
            iframe = document.getElementById("download-container");
            if (iframe === null) {
                iframe = document.createElement('iframe');
                iframe.id = "download-container";
                iframe.style.visibility = 'hidden';
                document.body.appendChild(iframe);
            }
            iframe.src = url;
            cb();

        }

//***************************************************************
//--------------------- DESCARGAR XML FACTURA  ------------------
//***************************************************************


//***************************************************************
//--------------------- VER SERVICIO FACTURA  -------------------
//***************************************************************
        $(document).on('click', '.ver_servicio', function (e) {
            e.preventDefault();
            var tk = $(this).attr('data-token');
            var id_servicio = $(this).attr('data-servicio');
            var content = '<div>' +
                '<iframe src="/facturacion/solicitud_archivos?token=' + tk + '" width="100%;" height="600px;"></iframe>' +
                '</div>';
            $(this).partnersModal({
                title: 'Servicio ' + id_servicio,
                modalId: 'vista-servicio',
                forceWidth: 90,
                content: content
            });
        });
//***************************************************************
//--------------------- VER SERVICIO FACTURA  -------------------
//***************************************************************


//***************************************************************
//---------------------- DESCARGAR ESATDO CUENTA ----------------
//***************************************************************
        $(document).on('click', '.descargar_estado_cuenta', function () {
            var btn = $(this);
            btn.partnersBtnControl('start');
            processFilteredTable(function (datos) {
                sendEstadoCuenta(datos, function () {
                    btn.partnersBtnControl('end');
                    swal({
                        type: 'success',
                        title: 'Bien!',
                        text: 'Estado de cuenta descargado',
                        timer: 2000,
                        showCloseButton: false,
                        showCancelButton: false
                    });

                    // Eliminar el iframe temporal que se genero despues de x tiempo
                    setTimeout(function () {
                        $('#download-container').remove();
                    }, 1000);
                });
            });
        });


        /**
         * Procesa los datos de la tabla y genera un objeto listo para ser procesado en el servidor.
         * @param cb
         * @param emails
         */
        function processFilteredTable(cb, emails) {
            var table = $('#table_estado_cuenta');
            var data = {};
            var nombre_cliente = $('.data_nombre_cliente').html();
            data.rows = [];
            data.total = 0;
            data.saldo = 0;

            // De esa manera solo descarga las tr filtradas.
            //_.forEach(table.find('tbody tr:visible'), function (a) {
            _.forEach(table.find('tbody tr'), function (a) {
                var row = {};
                var $this = $(a);
                row.folio_factura = $this.attr('data-folio');
                row.serie = $this.attr('data-serie');
                row.fecha_factura = moment($this.find('td').eq(0).html(), "DD/MM/YY").format('DD-MM-YYYY');
                row.fecha_vencimiento = moment($this.find('td').eq(6).html(), "DD/MM/YY").format('DD-MM-YYYY');
                row.total = numeral($this.find('td').eq(4).html()).value();
                data.total += row.total;
                row.saldo = numeral($this.find('td').eq(5).html()).value();
                row.factura = $this.attr('data-factura');
                data.saldo += row.saldo;
                data.rows.push(row);
            });
            data.nombre_cliente = nombre_cliente;
            data.token = getUrlVars()['token'];
            cb(data);
        }


        /**
         * Envia al servidor los datos procesados
         * @param datos
         */
        function sendEstadoCuenta(datos, cb) {
            $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_facturacion_process_file_estado_cuenta,
                data: JSON.stringify(datos),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        downloadFile(settings.cobranza.ruta_facturacion_get_file_estado_cuenta + '?file=' + response.message, function () {
                            cb();
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        }

//***************************************************************
//---------------------- DESCARGAR ESATDO CUENTA ----------------
//***************************************************************


//***************************************************************
//-------------------- ENVIAR ESTADO DE CUENTA  -----------------
//***************************************************************
        $(document).on('click', '.enviar_estado_cuenta', function () {
            var btn = $(this);
            var rfc = btn.attr('data-rfc');
            btn.partnersBtnControl('start');

            $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_consultas + 'get_contactos_cliente_by_rfc',
                data: JSON.stringify(rfc),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        var html = "";
                        var data = JSON.parse(response.message);

                        html += "<div class='row'>" +
                            "<div class='col-md-12'>";
                        // No existe el cliente, por lo tanto avisar que no existe y proporcionar botón para agregarlo.
                        if (data.id_cliente == 0) {
                            html += "<p class='text-danger'>No existe ningún cliente con el RFC <span class='font-weight-bold'>" + rfc + "</span> en nuestra base de datos, " +
                                "si quieres usar sus contactos," +
                                " tienes que <a href='/clientes?new_cliente=1' target='_blank' '>Agregar el cliente</a> y " +
                                "después repetir este proceso, sino, puedes simplemente enviar el estado de cuenta a cualquier correo.</p>";
                        } else {
                            // Si no tiene contactos, permitir agregar y mostrar mensaje.
                            if (data.contactos == 0) {
                                html += "<p class='text-danger'>El cliente <span class='font-weight-bold'>" + data.nombre_cliente + "</span> no cuenta con ningún contacto, " +
                                    "si quieres usarlos, tienes que <a href='/clientes?id_cliente=" + data.id_cliente + "&type=1' target='_blank'>Agregar contactos </a>" +
                                    "y después repetir este proceso, sino, puedes simplemente enviar el estado de cuenta a cualquier correo." +
                                    "</p>";
                            } else {
                                // Si tiene contactos, generar una lista.
                                var contactos = data.contactos;

                                html += "<div class='row my-3'><div class='col-md-7'><p class='lead'>Lista de Contactos, selecciona mínimo uno.</p><a href='/clientes?id_cliente=" + data.id_cliente + "&type=1' target='_blank' class='btn btn-sm btn-success mb-3 close_modal_contactos_estado_cuenta'>Agregar contacto </a>" +
                                    "<div style='max-height: 300px; height: auto; overflow-y: scroll;' class='list-group list-group-contactos'>";
                                _.forEach(contactos, function (v) {
                                    html += "<a class='list-group-item list-group-item-action contacto-item' style='cursor:pointer;' data-email='" + v.email + "'>" + v.nombre_cliente + "</a>";
                                })
                                html += "</div></div></div>";
                            }
                        }

                        html += "</div></div>";


                        html += "<div class='row'>" +
                            "<div class='col-md-12'>" +
                            "<input class='form-control emails_to_send' placeholder='Ingresa aquí los correos' type='text'>" +
                            "</div>" +
                            "<div class='col-md-12'><small><i class='text-info'>*Se enviará una copia para ti automáticamente.</i></small></div>" +
                            "</div>";

                        html += "<div class='row'>" +
                            "<div class='col-md-12'>" +
                            "<button class='send_estado_cuenta btn btn-success float-right' data-rfc='" + rfc + "'>Enviar</button>" +
                            "</div>" +
                            "</div>";


                        $(this).partnersModal({
                            title: 'Enviar Estado de Cuenta',
                            modalSize: 'modal-lg',
                            modalId: 'modal-enviar-estado-cuenta',
                            content: html
                        });

                        setTimeout(function () {
                            $('input[type="text"].emails_to_send').focus();
                            $('input[type="text"].emails_to_send').tagsinput();
                            $('input[type="text"].emails_to_send').on('beforeItemAdd', function (event) {
                                if (!validateEmail(event.item)) {
                                    event.cancel = true;
                                }
                            });
                            btn.partnersBtnControl('end');
                        }, 400);

                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });


        $(document).on('click', '.contacto-item', function () {
            if ($(this).hasClass('active')) {

                // Quitar la clase y quitar de la lista de correos.
                $(this).removeClass('active');
                $(this).removeClass('text-white');
                $('input[type="text"].emails_to_send').tagsinput('remove', $(this).attr('data-email'));

            } else {

                // Agregar la clase y agregar a la lista de correos.
                $(this).addClass('active');
                $(this).addClass('text-white');
                $('input[type="text"].emails_to_send').tagsinput('add', $(this).attr('data-email'));
            }
        });

        $(document).on('click', '.send_estado_cuenta', function () {
            var btn = $(this);
            var rfc = $(this).attr('data-rfc');
            btn.partnersBtnControl('start');

            var emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');

            var envio = {};
            envio.rfc = rfc;
            envio.emails = emails_arr;
            envio.nombre_empresa = $('.data_nombre_cliente').html();

            $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_consultas + 'generar_estado_cuenta',
                data: JSON.stringify(envio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        $('#modal-enviar-estado-cuenta').modal('hide');
                        $('.enviar_estado_cuenta').partnersBtnControl('end');
                        var emails = $('input[type="text"].emails_to_send').val();
                        var timeout = emails_arr.length * 800;

                        var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';

                        iziToast.show({
                            message: x,
                            position: 'center',
                            timeout: timeout,
                            progressBar: false,
                            color: 'dark',
                            icon: 'fa fa-envelope-open-o',
                            iconColor: '#fff'
                        });
                        var morphext = $("#js-rotating").Morphext({
                            animation: "fadeInDownCustom",
                            separator: ",",
                            speed: 800
                        });
                        var data;

                        data = morphext.data("plugin_Morphext");
                        setTimeout(function () {
                            data.stop();
                        }, timeout - 800);

                        setTimeout(function () {
                            swal({
                                title: "Bien!",
                                text: 'Estado de Cuenta enviado correctamente.',
                                type: 'success',
                                timer: 3000,
                                showConfirmButton: false
                            });
                        }, timeout);
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });

        $(document).on('click', '.close_modal_contactos_estado_cuenta', function () {
            $('#modal-enviar-estado-cuenta').modal('hide');
        });

//***************************************************************
//-------------------- ENVIAR ESTADO DE CUENTA  -----------------
//***************************************************************

    });
})
(jQuery);






