(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {


        if (getUrlVars()['token']) {
            var token = getUrlVars()['token'];
            if (token != "") {
                var token = getUrlVars()['token'];
                process_file_token(token);
            } else {
                setTimeout(function () {
                    window.location.replace('/');
                }, 5000);
            }
        } else {
            setTimeout(function () {
                window.location.replace('/');
            }, 5000);
        }

//***************************************************************
//------------------------ PARALLAX BACKGROUND ------------------
//***************************************************************
        $('.main-jumbotron').parents('.container-fluid').find('.main-content').removeClass('row').addClass('col-md-12 p-0');
        $('.main-jumbotron').parents('.container-fluid').find('.main-content').find('.col-sm-12').addClass('p-0');
        $('.main-jumbotron').parents('.grid-80').removeClass('grid-80');
        $('.main-jumbotron').parallaxBackground({
            parallaxBgImage: '/sites/default/files/img/accountant-2.png',
            parallaxSpeed: 1
        });
//***************************************************************
//------------------------ PARALLAX BACKGROUND ------------------
//***************************************************************


        /**
         * Recibe un token el cual será enviado al servidor, lo desecriptará y regresará el archivo solicitado a descargar
         * @param token
         */
        function process_file_token(token) {
            $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_get_file_url,
                data: JSON.stringify(token),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        var data = JSON.parse(response.message);
                        setTimeout(function () {
                            $('.main-jumbotron').find('.page-loading').remove();
                            if (data.type == 2) {
                                $('.main-jumbotron').find('.text-status').html('Archivo XML procesado correctamente!');
                                $('.main-jumbotron').find('.lead').html("Si ya se descargó tu archivo, ya puedes cerrar esta ventana.");
                                downloadFile(data.file, data.cantidad);
                            } else {
                                $('.main-jumbotron').find('.text-status').html('Reportes de Servicio procesados correctamente!');
                                // Generar un botón por cada archivo.
                                var btn = '';
                                for (var i = 0; i < data.cantidad; i++) {
                                    btn += '<a class="btn btn-success mx-3" href="' + data.file[i] + '" target="_blank">Servicio: '+data.folios[i] +'</a>';
                                }
                                $('.main-jumbotron').find('.lead').html(btn);
                            }
                        }, 1000);

                    } else if (response.status == 'error') {
                        $('.main-jumbotron').find('.text-status').html('Error!');
                        $('.main-jumbotron').find('.lead').html(response.message);

                        $('.main-jumbotron').find('.page-loading').remove();
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        }


        /**
         * Utilizado para forzar la descarga de archivos sin necesidad de abrir nunevas pestañas.
         * @param url: Url del archivo a descargar
         * @param cantidad: el total de url que vienen para saber cuantas veces forzar la descarga
         */
        function downloadFile(url, cantidad) {
            var iframe;
            iframe = document.getElementById("download-container");
            if (iframe === null) {
                iframe = document.createElement('iframe');
                iframe.id = "download-container";
                iframe.style.visibility = 'hidden';
                document.body.appendChild(iframe);
            }
            iframe.src = url;

        }

    });
})
(jQuery);