(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//---------------------- REPORTE BASE COBRANZA ------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 60000,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'DESC',
        sort_by: 'CFECHA'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        filtro_15: null,
        filtro_40: null,
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'reporte_base_2',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    // Filtrado - Order Saldo Mayor a Menor
    $(document).on('change', '.filtro_saldo', function () {
      if ($(this).is(':checked')) {
        r_options.filter.orderBySaldo = 1;
      } else {
        r_options.filter.orderBySaldo = 0;
      }
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      autoUpdate.forceUpdate();
    });

    // Filtrado - Más 40 días
    $(document).on('change', '.filtro_fecha_vencimiento_40', function () {
      if ($(this).is(':checked')) {
        r_options.filter.filtro_40 = 1;
      } else {
        r_options.filter.filtro_40 = 0;
      }
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      autoUpdate.forceUpdate();
    });


    autoUpdate.forceUpdate();
//***************************************************************
//---------------------- REPORTE BASE COBRANZA ------------------
//***************************************************************


    // ***************************************************************
    // ---------------------- CONTROL REPORTEADOR --------------------
    // ***************************************************************
    $(document).on('click', '.toggle-collapse-detalle-cobranza', function () {
      var ID = $(this).parents('tr').attr('data-id-related');
      var $id = $('#' + ID);
      var status = $(this).parents('tr').attr('data-is-open');
      if (+status === 0) {
        // Cambiar el chevron hacia abajo para indicar que está abierto
        $(this).html('<i class="fas fa-chevron-down"></i>');
        $(this).parents('tr').attr('data-is-open', 1);

        // Cuando está abierto, agregar paddings.
        $id.closest('.td-container').css('padding', '.3rem .3rem .3rem 5%');
      } else {
        // Cambiar el chevron hacia la derecha para indicar que está cerrado
        $(this).html('<i class="fas fa-chevron-right"></i>');
        $(this).parents('tr').attr('data-is-open', 0);

        // Cuando está cerrado, quitar paddings, después de terminada la animación del collapse.
        setTimeout(function () {
          $id.closest('.td-container').css('padding', '0');
        }, 210);
      }
      $id.collapse('toggle');
    });

    $(document).on('click', '.expand_all_detalle_cobranza', function () {
      // Abrir todas las facturas
      $('#table_cobranza tbody tr').each(function (k, v) {
        $(v).find('.toggle-collapse-detalle-cliente').click();
      });
    });
    // ***************************************************************
    // ---------------------- CONTROL REPORTEADOR --------------------
    // ***************************************************************


    //***************************************************************
    //----------------------- COBRANZA OBSERVACIONES ----------------
    //***************************************************************
    $(document).on('click', '.status_obs', function () {
      var folio = $(this).parents('tr').attr('data-folio');
      $(this).partnersObs(
        {
          modalId: 'modal-cobranza-observaciones',
          ajaxUrl: settings.cobranza.ruta_sys_tools + 'load_obs',
          index: 'folio',
          id_index: folio,
          tabla: 'partners_cobranza',
          col: 'observaciones',
          allowReminder: true,
          nombreCliente: $(this).parents('tr').attr('data-nombre-cliente'),
          idCliente: $(this).parents('tr').attr('data-id-cliente'),
          subjectReminder: 'Cobranza, factura: E-' + folio,
          extra_val: folio,
          extra_col: 'folio',
          custom_condition: "folio = " + folio + " and serie = \'E\' ",
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });

    $(document).on('click', '.status_obs_w', function () {
      var folio = $(this).parents('tr').attr('data-folio');
      $(this).partnersObs(
        {
          modalId: 'modal-cobranza-observaciones',
          ajaxUrl: settings.cobranza.ruta_sys_tools + 'load_obs',
          index: 'folio',
          id_index: folio,
          tabla: 'partners_cobranza',
          col: 'observaciones',
          allowReminder: true,
          nombreCliente: $(this).parents('tr').attr('data-nombre-cliente'),
          idCliente: $(this).parents('tr').attr('data-id-cliente'),
          subjectReminder: 'Cobranza, factura W-' + folio,
          extra_val: folio,
          extra_col: 'folio',
          custom_condition: "folio = " + folio + " and serie = \'W\' ",
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });
    //***************************************************************
    //----------------------- COBRANZA OBSERVACIONES ----------------
    //***************************************************************


    //***************************************************************
    //------------------------- COBRANZA APOYO ----------------------
    //***************************************************************
    $(document).on('click', '.status_apoyo', function () {
      var apoyo = $(this).parents('tr').attr('data-apoyo');
      var folio = $(this).parents('tr').attr('data-folio');
      var serie = $(this).parents('tr').attr('data-serie');
      var envio = {};
      envio.apoyo = apoyo;
      envio.folio = folio;
      envio.serie = serie;
      if (apoyo == 0) {
        $.ajax({
          type: 'POST',
          url: settings.cobranza.ruta_consultas + 'status_apoyo',
          data: JSON.stringify(envio),
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              iziToast.success({
                title: "Bien! ",
                message: response.message
              });
              autoUpdate.forceUpdate();
            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      } else if (apoyo == 1) {
        swal({
          title: 'Describe la llamada',
          input: 'textarea',
          showCancelButton: true,
          confirmButtonText: 'Guardar',
          cancelButtonText: 'Cancelar',
          cancelButtonColor: '#DD6B55',
          showLoaderOnConfirm: true,
          reverseButtons: true,
          preConfirm: function (text) {
            return new Promise(function (resolve, reject) {
              if (text == null || text.length < 1) {
                reject("Se un poco más descriptivo");
              } else {
                envio.obs = text;
                $.ajax({
                  type: 'POST',
                  url: settings.cobranza.ruta_consultas + 'status_apoyo',
                  data: JSON.stringify(envio),
                  contentType: "application/json; charset=utf-8",
                  dataType: "json",
                  success: function (response) {
                    if (response.status == 'success') {
                      resolve();
                    } else if (response.status == 'error') {
                      iziToast.error({
                        title: "Error",
                        message: response.message
                      });
                      swal.close();
                    }
                  },
                  error: function (xhr) {
                    iziToast.error({
                      title: "Ocurrio un error: ",
                      message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                  }
                });
              }
            })
          },
          allowOutsideClick: false
        }).then(function (a) {
          if (!a.dismiss) {
            swal({
              type: 'success',
              title: 'Bien!',
              html: 'Datos actualizados',
              timer: 1000
            });
            autoUpdate.forceUpdate();
          }
        })
      }
    });


    //***************************************************************
    //------------------------- COBRANZA APOYO ----------------------
    //***************************************************************

    //***************************************************************
    //----------------------- COBRANZA ESPECIAL ---------------------
    //***************************************************************
    $(document).on('click', '.status_especial', function () {
      var especial = ($(this).parents('tr').attr('data-especial') == 1) ? 0 : 1;
      var folio = $(this).parents('tr').attr('data-folio');
      var serie = $(this).parents('tr').attr('data-serie');
      var envio = {};
      envio.especial = especial;
      envio.folio = folio;
      envio.serie = serie;


      swal({
        title: 'Motivo',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un motivo!');
            } else {
              envio.motivo = reason;
              $.ajax({
                type: 'POST',
                url: settings.cobranza.ruta_consultas + 'status_especial',
                data: JSON.stringify(envio),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    iziToast.success({
                      title: "Bien! ",
                      message: response.message
                    });
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          }).catch(function (error) {
            swal.showValidationError(error);
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (a.dismiss !== 'cancel') {
          swal("Bien!", "Se ha actualizado el estatus correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });
    //***************************************************************
    //----------------------- COBRANZA ESPECIAL ---------------------
    //***************************************************************


    //***************************************************************
    //----------------------- COBRANZA VISTA CLIENTE ----------------
    //***************************************************************
    $(document).on('click', '.vista_cliente', function () {
      var envio = {};
      envio.codigo = $(this).parents('tr').attr('data-codigo-cliente');
      envio = JSON.stringify(envio);
      $(this).partnersModal({
        title: 'Vista Cliente',
        forceWidth: 90,
        modalId: 'vista-cliente-modal',
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'vista_cliente',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-cliente-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //----------------------- COBRANZA VISTA CLIENTE ----------------
    //***************************************************************

    //***************************************************************
    //--------------------- COBRANZA  VER FACTURA  ------------------
    //***************************************************************
    $(document).on('click', '.ver_factura', function () {
      if ($(this).parents('tr').attr('data-exists-factura') == 0) {
        iziToast.error({
          title: "Error",
          message: "No se encuentra la factura en el servidor"
        });
        return false;
      }
      var id_factura = $(this).text();
      var id_cliente = $(this).parents('tr').attr('data-codigo-cliente');
      var factura = $(this).parents('tr').attr('data-factura');
      var content = '<div>' +
        '<iframe src="/system/tools/vista_factura?factura=' + factura + '&id_cliente=' + id_cliente + '" width="100%;" height="600px;"></iframe>' +
        '</div>';
      $(this).partnersModal({
        title: 'Factura ' + id_factura,
        modalId: 'vista-factura',
        forceWidth: 90,
        content: content
      });
    });
    //***************************************************************
    //--------------------- COBRANZA  VER FACTURA  ------------------
    //***************************************************************


    //***************************************************************
    //------------------------ ENVIAR FACTURA -----------------------
    //***************************************************************
    $(document).on('click', '.enviar_factura', function () {
      if ($(this).parents('tr').attr('data-exists-factura') == 0) {
        iziToast.error({
          title: "Error",
          message: "No se encuentra la factura en el servidor"
        });
        return false;
      }
      var content = '';
      var folio = $(this).parents('tr').attr('data-folio');
      var factura = $(this).parents('tr').attr('data-factura');
      var cod_cliente = $(this).parents('tr').attr('data-codigo-cliente');
      var nombre_cliente = $(this).parents('tr').attr('data-nombre-cliente');
      var serie = $(this).parents('tr').attr('data-serie');
      var emails = $(this).parents('tr').attr('data-emails');
      var rfc = $(this).parents('tr').attr('data-rfc');
      content += '<div class="row">' +
        '<div class="col-md-6 text-center"><button class="btn btn-primary adjuntar_archivo_servicio" role="button" type="button" data-rfc="' + rfc + '" data-serie="' + serie + '" data-nombre-cliente="' + nombre_cliente + '" data-emails="' + emails + '" data-folio="' + folio + '" data-factura="' + factura + '" data-codigo-cliente="' + cod_cliente + '">Adjuntar Servicio</button></div>' +
        '<div class="col-md-6"><button class="btn btn-success enviar_solo_factura" role="button" type="button" data-rfc="' + rfc + '" data-serie="' + serie + '" data-nombre-cliente="' + nombre_cliente + '" data-emails="' + emails + '" data-folio="' + folio + '" data-factura="' + factura + '" data-codigo-cliente="' + cod_cliente + '">Enviar solo factura</button></div>' +
        '</div>';

      $(this).partnersModal({
        title: 'Enviar Factura ' + folio,
        modalId: 'enviar-factura-modal',
        forceWidth: 35,
        content: content,
        noFooter: true
      });
    });

    $(document).on('click', '.enviar_correo_factura', function () {
      var btn = $(this);
      var emails = $('input[type="text"].emails_to_send').val();
      var factura = btn.attr('data-factura');
      var cod_cliente = btn.attr('data-codigo-cliente');
      var emails_arr = $('input[type="text"].emails_to_send').tagsinput('items');
      const conTarjeta = $('#enviarConPagoTarjeta1').is(':checked');
      var envio = {};
      envio.emails = emails;
      envio.factura = factura;
      envio.cod_cliente = cod_cliente;
      envio.serie = btn.attr('data-serie');
      envio.conTarjeta = conTarjeta;
      var delete_files = [];
      $('.index_to_delete_ .index').each(function () {
        delete_files.push($(this).attr('data-index'));
      });
      envio.deleted_files = delete_files;

      if ((emails == '' || !emails) && !$('.enviarme_copia_correo').is(':checked')) {
        iziToast.error({
          title: 'Error',
          message: "Ingresa al menos un correo, o enviate una copia."
        });
        return false;
      }

      envio = JSON.stringify(envio);
      btn.partnersBtnControl('start');
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'enviar_solo_factura',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var timeout = emails_arr.length * 800;
            var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';
            iziToast.show({
              message: x,
              position: 'center',
              timeout: timeout,
              progressBar: false,
              color: 'dark',
              icon: 'fa fa-envelope-open-o',
              iconColor: '#fff'
            });
            var morphext = $("#js-rotating").Morphext({
              animation: "fadeInDownCustom",
              separator: ",",
              speed: 800
            });
            var data;
            data = morphext.data("plugin_Morphext");
            setTimeout(function () {
              data.stop();
            }, timeout - 800);

            setTimeout(function () {
              $('#enviar-solo-factura-modal').modal('hide');
              iziToast.success({
                title: "Bien! ",
                message: response.message
              });
            }, timeout);
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.enviar_solo_factura', function () {
      var btn = $(this);
      $('#enviar-factura-modal').modal('hide');
      setTimeout(function () {
        $(this).partnersModal({
          title: 'Enviar Factura',
          forceWidth: 45,
          modalId: 'enviar-solo-factura-modal',
          content: loader
        });
        var envio = {};
        envio.factura = btn.attr('data-factura');
        envio.cod_cliente = btn.attr('data-codigo-cliente');
        envio.nombre_cliente = btn.attr('data-nombre-cliente');
        envio.folio_factura = btn.attr('data-folio');
        envio.emails = btn.attr('data-emails');
        envio.serie = btn.attr('data-serie');
        envio.rfc = btn.attr('data-rfc');
        envio = JSON.stringify(envio);
        $.ajax({
          type: 'POST',
          url: settings.cobranza.ruta_consultas + 'vista_content_zip',
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              $('#enviar-solo-factura-modal .modal-body').html(response.message);
              setTimeout(function () {
                $('input[type="text"].emails_to_send').focus();
                $('input[type="text"].emails_to_send').tagsinput();
                $('input[type="text"].emails_to_send').on('beforeItemAdd', function (event) {
                  if (!validateEmail(event.item)) {
                    event.cancel = true;
                  }
                });
              }, 400);

            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }, 400);

    });

    $(document).on('click', '.adjuntar_archivo_servicio', function () {
      var btn = $(this);
      $('#enviar-factura-modal').modal('hide');
      setTimeout(function () {
        $(this).partnersModal({
          title: 'Enviar Factura',
          forceWidth: 45,
          modalId: 'enviar-factura-con-modal',
          content: loader
        });
        var envio = {};
        envio.factura = btn.attr('data-factura');
        envio.cod_cliente = btn.attr('data-codigo-cliente');
        envio.nombre_cliente = btn.attr('data-nombre-cliente');
        envio.folio_factura = btn.attr('data-folio');
        envio.emails = btn.attr('data-emails');
        envio.serie = btn.attr('data-serie');
        envio.rfc = btn.attr('data-rfc');
        envio = JSON.stringify(envio);
        $.ajax({
          type: 'POST',
          url: settings.cobranza.ruta_consultas + 'vista_content_zip_adjuntar',
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              $('#enviar-factura-con-modal .modal-body').html(response.message);
              setTimeout(function () {
                $('input[type="text"].emails_to_send_').focus();
                $('input[type="text"].emails_to_send_').tagsinput();
                $('input[type="text"].emails_to_send_').on('beforeItemAdd', function (event) {
                  if (!validateEmail(event.item)) {
                    event.cancel = true;
                  }
                });
              }, 400);

            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }, 400);
    });

    $(document).on('submit', '#servicio-adjunto-form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      var factura = btn.attr('data-factura');
      var cod_cliente = btn.attr('data-codigo-cliente');
      var emails = $('input[type="text"].emails_to_send_').val();
      var emails_arr = $('input[type="text"].emails_to_send_').tagsinput('items');
      const conTarjeta = $('#enviarConPagoTarjeta').is(':checked');
      /*
      if (emails == '' || !emails) {
          iziToast.error({
              title: 'Error',
              message: "Ingresa al menos un correo para enviar."
          });
          return false;
      }
      */
      if (!$('input[name="archivo_adjunto_servicio"]')[0].files[0]) {
        iziToast.error({
          title: 'Error',
          message: "No seleccionado ningún archivo para adjuntar a la factura."
        });
        return false;
      }

      if ((emails == '' || !emails) && !$('.enviarme_copia_correo_adjuntar').is(':checked')) {
        iziToast.error({
          title: 'Error',
          message: "Ingresa al menos un correo, o enviate una copia."
        });
        return false;
      }

      btn.partnersBtnControl('start');
      var datos = new FormData();
      var a = $('input[name="archivo_adjunto_servicio"]')[0].files[0];
      datos.append('file', a);
      datos.append('factura', factura);
      datos.append('cod_cliente', cod_cliente);
      datos.append('emails', emails);
      datos.append('conTarjeta', (+conTarjeta).toString());
      var delete_files = [];
      $('#servicio-adjunto-form .index_to_delete .index').each(function () {
        delete_files.push($(this).attr('data-index'));
      });
      datos.append('deleted_files', delete_files);

      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_enviar_con_servicio,
        data: datos,
        contentType: "application/json; charset=utf-8",
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var timeout = emails_arr.length * 800;
            var x = 'Enviando correo a <span class="font-weight-bold" id="js-rotating">' + emails + '</span>';
            iziToast.show({
              message: x,
              position: 'center',
              timeout: timeout,
              progressBar: false,
              color: 'dark',
              icon: 'fa fa-envelope-open-o',
              iconColor: '#fff'
            });
            var morphext = $("#js-rotating").Morphext({
              animation: "fadeInDownCustom",
              separator: ",",
              speed: 800
            });
            var data;
            data = morphext.data("plugin_Morphext");
            setTimeout(function () {
              data.stop();
            }, timeout - 800);

            setTimeout(function () {
              $('#enviar-factura-con-modal').modal('hide');
              iziToast.success({
                title: "Bien! ",
                message: response.message
              });
              autoUpdate.forceUpdate();
            }, timeout);


          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });


    $(document).on('change', '.enviarme_copia_correo', function () {
      var user_email = $(this).attr('data-user-email');
      if ($(this).is(':checked')) {
        $('input[type="text"].emails_to_send').tagsinput('add', user_email);
      } else {
        $('input[type="text"].emails_to_send').tagsinput('remove', user_email);
      }
    });

    $(document).on('change', '.enviarme_copia_correo_adjuntar', function () {
      var user_email = $(this).attr('data-user-email');
      if ($(this).is(':checked')) {
        $('input[type="text"].emails_to_send_').tagsinput('add', user_email);
      } else {
        $('input[type="text"].emails_to_send_').tagsinput('remove', user_email);
      }
    });
    //***************************************************************
    //------------------------ ENVIAR FACTURA -----------------------
    //***************************************************************


    //***************************************************************
    //------------------- VISTA SERVICIOS RELACIONADOS  -------------
    //***************************************************************
    $(document).on('click', '.vista_servicios_relacionados', function () {
      var folios = $(this).html();
      folios = folios.split(',');
      _.forEach(folios, function (i) {
        if (i[0] == 'B' || i[0] == 'A') {
          window.open('/servicios/vista/' + i.substr(i.indexOf("-") + 1));
        } else if (i[0] == 'F') {
          window.open('/centrodeservicio/vista/' + i.substr(i.indexOf("-") + 1) + '/2');
        }
      });
    });
    //***************************************************************
    //------------------- VISTA SERVICIOS RELACIONADOS  -------------
    //***************************************************************

    //***************************************************************
    //------------------- ELIMINAR ARCHIVO DEL ZIP ------------------
    //***************************************************************
    $(document).on('click', '.eliminar_archivo_from_zip', function () {
      $(this).parents('li').remove();
      var index = $(this).attr('data-index');
      $('.index_to_delete').append('<div class="index" data-index="' + index + '"></div>');
    });
    $(document).on('click', '.eliminar_archivo_from_zip_', function () {
      $(this).parents('li').remove();
      var index = $(this).attr('data-index');
      $('.index_to_delete_').append('<div class="index" data-index="' + index + '"></div>');
    });
    //***************************************************************
    //------------------- ELIMINAR ARCHIVO DEL ZIP ------------------
    //***************************************************************


    //***************************************************************
//-------------------------- STATUS PAGADO ----------------------
//***************************************************************
    $(document).on('click', '.status_pagado', function () {
      var id_servicio = $(this).parents('tr').attr('data-id-servicio');
      var folio_servicio = $(this).parents('tr').attr('data-folio-servicio');
      var nombre_cliente = $(this).parents('tr').attr('data-nombre-cliente');
      var total_servicio = $(this).parents('tr').attr('data-total-servicio');
      var folio_factura = $(this).parents('tr').attr('data-folio');
      $(this).partnersModal({
        title: 'Pagar Servicio',
        content: loader,
        forceWidth: 50,
        modalId: 'modal-pagar-servicios-w'
      });

      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'vista_pagar_servicio_w',
        data: JSON.stringify({
          idServicio: id_servicio,
          folioServicio: folio_servicio,
          nombreCliente: nombre_cliente,
          totalServicio: total_servicio,
          folioFactura: folio_factura
        }),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#modal-pagar-servicios-w .modal-body').html(response.message);
            setTimeout(function () {
              $('#fecha-pagar-servicio-w-container .input-group.date').datepicker({
                format: "dd/mm/yyyy",
                todayBtn: "linked",
                language: "es",
                autoclose: true,
                todayHighlight: true,
                orientation: "auto",
                container: ".input-group.date"
              });
              $.validate({
                form: '#form_pagar_servicio_w',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid'
              });
              $.formUtils.addValidator({
                name: 'min_number',
                validatorFunction: function (value, $el) {
                  return numeral(value).value() >= numeral($($el).attr('data-validation-min-number')).value();
                },
                errorMessage: '',
                errorMessageKey: ''
              });
            }, 10);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('change', '.select_tipo_pagar_servicio_w', function () {
      // Solo mostrar el formulario de capturar a caja cuando sea tipo efectivo
      if ($(this).val() == 1) {
        $('.container_pagar_efectivo').show();
      } else {
        $('.container_pagar_efectivo').hide();
      }
    });


    $(document).on('submit', '#form_pagar_servicio_w', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#form_pagar_servicio_w').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      var tipoPago = $('.select_tipo_pagar_servicio_w:checked').val();
      datosEnvio.id_servicio = btn.attr('data-id-servicio');
      datosEnvio.new_val = tipoPago;
      datosEnvio.col = 'pagado_cobranza';
      datosEnvio.col_fecha = 'fecha_pagado_cobranza';
      datosEnvio.folio = btn.attr('data-folio-cobranza');
      datosEnvio.val_fecha = $('#fecha-pagar-servicio-w-container .input-group.date').datepicker('getDate');
      if (tipoPago == 1) {
        datosEnvio.obs = 'Se capturó en caja bajo el concepto de: ' + datosEnvio.concepto_capturar_caja;
        datosEnvio.capturar_caja = 1;
      } else {
        var formaPago = '';
        if (tipoPago == 3) {
          formaPago = 'Banamex';
        } else if (tipoPago == 4) {
          formaPago = 'HSBC';

        } else if (tipoPago == 5) {
          formaPago = 'PayPal';

        } else if (tipoPago == 6) {
          formaPago = 'PayU';

        }
        var diaPago = $('.fecha_pagar_servicio_w_input').val();
        datosEnvio.obs = 'Se pagó la factura con la forma de pago: ' + formaPago + ' el día: ' + diaPago;
        datosEnvio.capturar_caja = 0;
      }

      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
            $('#modal-pagar-servicios-w').modal('hide');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//-------------------------- STATUS PAGADO ----------------------
//***************************************************************

    //***************************************************************
    //------------------------- ESTADO DE CUENTA --------------------
    //***************************************************************
    $(document).on('click', '.generar_estado_cuenta', function () {
      var btn = $(this);
      var rfc = $(this).parents('tr').attr('data-rfc');

      // Solo enviar el RFC y solicitar una URL con token.
      $.ajax({
        type: 'POST',
        url: settings.cobranza.ruta_consultas + 'get_token_rfc_url',
        data: JSON.stringify(rfc),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            // Cuando se tenga la url, abrirla en una nueva pestaña.
            window.open(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
    //***************************************************************
    //------------------------- ESTADO DE CUENTA --------------------
    //***************************************************************

  });
})
(jQuery);

