//* **************************************************************
// --------------- SOLICITAR RECLASIFICACIÓN CLIENTE -------------
//* **************************************************************

// eslint-disable-next-line no-undef,no-underscore-dangle
const _$ = jQuery;

const loader = '<div class="sk-cube-grid"> '
  + '<div class="sk-cube sk-cube1"></div> '
  + '<div class="sk-cube sk-cube2"></div> '
  + '<div class="sk-cube sk-cube3"></div> '
  + '<div class="sk-cube sk-cube4"></div> '
  + '<div class="sk-cube sk-cube5"></div> '
  + '<div class="sk-cube sk-cube6"></div> '
  + '<div class="sk-cube sk-cube7"></div> '
  + '<div class="sk-cube sk-cube8"></div> '
  + '<div class="sk-cube sk-cube9"></div> </div>';

/**
 * Enviar sugerencia de reclasificación desde buscador
 * @param info
 */
const reclasificar = (info) => {
  const tipoClasificacion = info.tipo_clasificacion;
  const idCliente = info.id_cliente;
  let html = '';
  html += `
  <div class="row">
    <div class="col-md-12">El cliente es clasificación
        <span class="font-weight-bold">${tipoClasificacion.toUpperCase()}</span> ,
    selecciona a cual clasificación propones moverlo y especifica por que.</div>
  </div>
  <div class="row my-2 justify-content-center">
    <div>
        <select class="form-control" name="choose_new_clasificacion">`;

  html += tipoClasificacion !== 'a' ? '<option value="a">A</option>' : '';
  html += tipoClasificacion !== 'b' ? '<option value="b">B</option>' : '';
  html += tipoClasificacion !== 'd' ? '<option value="d">D</option>' : '';
  html += tipoClasificacion !== 'e' ? '<option value="e">E</option>' : '';

  html += `
        </select>
    </div>
  </div>
  <div class="row">
    <div class="col-md-12">
        <textarea name="motivo_mover_clasificacion" class="form-control"
            placeholder="Ingresa un motivo de porque lo mueves de clasificación" rows="3"></textarea>
    </div>
  </div>`;

  // eslint-disable-next-line no-undef
  swal({
    title: 'Sugerir Reclasificación Cliente',
    html,
    showCancelButton: true,
    confirmButtonText: 'Sugerir',
    cancelButtonText: 'Cancelar',
    cancelButtonColor: '#DD6B55',
    showLoaderOnConfirm: true,
    // eslint-disable-next-line no-undef
    onOpen: fixBootstrapModal,
    preConfirm() {
      return new Promise(((resolve, reject) => {
        // Validar motivo descrito
        const motivo = _$('textarea[name="motivo_mover_clasificacion"]').val();
        if (_$.trim(motivo) === '') {
          reject(new Error('Ingresa un motivo'));
        } else {
          const datos = {};
          datos.current_clasificacion = tipoClasificacion;
          datos.new_clasificacion = _$('select[name="choose_new_clasificacion"] option:selected').val();
          datos.id_cliente = idCliente;
          datos.motivo_clasificacion = motivo;
          _$.ajax({
            type: 'POST',
            url: `${info.settings.clientes.ruta_capturar}sugerir_clasificacion_cliente`,
            data: JSON.stringify(datos),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json',
            success(response) {
              if (response.status === 'success') {
                _$('#vista-cliente-modal .modal-body').html(loader);
                _$.ajax({
                  url: info.settings.clientes.ruta_vista_cliente + idCliente,
                  success(data) {
                    _$('#vista-cliente-modal .modal-body').html(data);
                  },
                });
                resolve();
              } else if (response.status === 'error') {
                // eslint-disable-next-line no-undef
                swal.close();
                // eslint-disable-next-line no-undef
                iziToast.error({
                  title: 'Error',
                  message: response.message,
                });
              }
            },
            error(xhr) {
              // eslint-disable-next-line no-undef
              swal.close();
              // eslint-disable-next-line no-undef
              iziToast.error({
                title: 'Ocurrio un error: ',
                message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
              });
            },
          });
        }
      }));
    },
    allowOutsideClick: false,
  }).then((a) => {
    if (!a.dismiss) {
      // eslint-disable-next-line no-undef
      swal({
        type: 'success',
        title: 'Bien!',
        html: 'Se ha enviado tu sugerencia correctamente.',
        timer: 2000,
      });
    }
  }).catch((e) => {
    console.error(e);
    // eslint-disable-next-line no-undef
    swal.close();
  });
};

/**
 * Preparar evento de reclasificación
 *
 * @param type
 * @param data
 */
const prepareEvs = (type, data) => {
  if (type === 1) {
    document.getElementsByClassName('quick_info_client')[0].getElementsByTagName('span')[0].addEventListener('mouseover', (ev) => {
      const ELEMENT = ev.currentTarget.parentElement;
      ELEMENT.classList.add('sugerir_reclasificacion_cliente');
      _$(ELEMENT).html('<span class="badge badge-info cursor-pointer">'
        + 'Reclasificar</span> </p> ');
      prepareEvs(2, data);

      _$(document).on('click', '.sugerir_reclasificacion_cliente', () => {
        reclasificar({
          tipo_clasificacion: data.tipo_clasificacion,
          id_cliente: data.id_cliente,
          settings: data.settings,
        });
      });
    });
  } else {
    document.getElementsByClassName('quick_info_client')[0].getElementsByTagName('span')[0].addEventListener('mouseout', (ev) => {
      const ELEMENT = ev.currentTarget.parentElement;
      ELEMENT.classList.remove('sugerir_reclasificacion_cliente');
      _$(ELEMENT).html(`<span class="badge badge-${data.color_t_clasificacion}">
        <i class="fa fa-star" aria-hidden="true"></i>: ${data.tipo_clasificacion} | ${data.credito_contado}</span> </p> `);
      prepareEvs(1, data);
    });
  }
};
//* **************************************************************
// --------------- SOLICITAR RECLASIFICACIÓN CLIENTE -------------
//* **************************************************************
