(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {
        var ruta_url = settings.clientes.ruta_sys_tools + 'inline_edit';
        partnersEditableContent(ruta_url, function () {
            autoUpdate.forceUpdate();
        });

        (getUrlVars()["new_cliente"] == 1) ? setTimeout(function () {
            $('.new_client').click()
        }, 500) : '';

        if (getUrlVars()['id_cliente']) {
            var type = getUrlVars()['type'];
            var temp_div;
            if (type == 1) {
                temp_div = $('<div data-id="' + getUrlVars()['id_cliente'] + '" class="vista_cliente"></div>');
            } else if (type == 2) {
                temp_div = $('<div data-id="' + getUrlVars()['id_cliente'] + '" class="vista_contacto"></div>');
            } else if (type == 3) {
                temp_div = $('<div data-id="' + getUrlVars()['id_cliente'] + '" class="vista_cliente"></div>');
            } else if(type == 4){
                // Vista ventas
                temp_div = $('<div data-id-cliente="' + getUrlVars()['id_cliente'] + '" class="area_ventas_cliente"></div>');
            }
            setTimeout(function () {
                temp_div.insertAfter('body');
                temp_div.click();
                temp_div.remove();
            }, 600);
        }
        var loader = '<div class="sk-cube-grid"> ' +
            '<div class="sk-cube sk-cube1"></div> ' +
            '<div class="sk-cube sk-cube2"></div> ' +
            '<div class="sk-cube sk-cube3"></div> ' +
            '<div class="sk-cube sk-cube4"></div> ' +
            '<div class="sk-cube sk-cube5"></div> ' +
            '<div class="sk-cube sk-cube6"></div> ' +
            '<div class="sk-cube sk-cube7"></div> ' +
            '<div class="sk-cube sk-cube8"></div> ' +
            '<div class="sk-cube sk-cube9"></div> </div>';


//***************************************************************
//------------------------- REPORTE BASE  -----------------------
//***************************************************************
        // Auto Update
        var autoUpdate = new AutoUpdate({
            toUpdate: function () {
                reporte_base();
            },
            interval: 60,
            iddle_after: 120,
        });

        // Reporte base Options
        /**
         *
         * @type {{
         * pagination: {
         *      page: number
         * },
         * sort: {
         *      order: string,
         *      sort_by: string //Tiene que ser el nombre de la columna de la tabla
         * },
         * automatic_update: number,
         * updating: number
         * }}
         */
        var r_options = {
            pagination: {
                page: 1
            },
            sort: {
                order: 'ASC',
                sort_by: 'nombre_cliente'
            },
            automatic_update: 1,
            updating: 0,
            filter: {
                search_bar: null,
                clasificacion: null,
                tipo_empresa: null,
                encuesta: null,
                clasificacion_interna: null,
                has_licencia: null

            }

        };

        reporte_base();


        function reporte_base() {
            if (r_options.automatic_update !== 1) {
                $('#reporteador').find('.table').css('opacity', 0.5);
            }
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_reporte_base,
                data: JSON.stringify(r_options),
                contentType: "application/json; charset=utf-8",
                success: function (data) {
                    $('#reporteador').html(data);
                    $('#table_reporteador_clientes').stickyTableHeaders();
                    //Reset Defaults
                    r_options.automatic_update = 1;
                    r_options.updating = 0;
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });


        }

        // Table Sort
        $(document).on('click', '.sortable_table_th', function () {
            var sort_by = $(this).attr('data-sort-by');
            var sort_order = $(this).attr('data-sort-order');
            if (sort_order == 'ASC') {
                r_options.sort.order = 'DESC';
            } else if (sort_order == 'DESC') {
                r_options.sort.order = 'ASC';
            }

            // Reiniciar la paginación al inicio en caso de que ya este avanzada.
            if (r_options.pagination.page !== 1) {
                r_options.pagination.page = 1;
            }
            r_options.sort.sort_by = sort_by;
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            autoUpdate.forceUpdate();
        });


        // Filtrado - Texto
        $(document).on('keyup', '#buscador_cliente', function (e) {
            clearTimeout($.data(this, 'timer'));
            if (e.keyCode == 13)
                search(true);
            else
                $(this).data('timer', setTimeout(search, 200));
        });

        function search() {
            var StringtoSearch = $("#buscador_cliente").val();
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.search_bar = StringtoSearch;
            autoUpdate.forceUpdate();
        }


        // Filtrado - Clasificación
        $(document).on('change', '#filtrado_clasificacion', function () {
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.clasificacion = $(this).find('option:selected').val();
            autoUpdate.forceUpdate();
        });

        // Filtrado - Tipo Negocio/Empresa
        $(document).on('click', '.checkbox_tipo_empresa', function () {
            var chk_arr = [];
            if (r_options.filter.tipo_empresa != null) {
                chk_arr = r_options.filter.tipo_empresa.split(',');
            }
            // Si lo marcan, lo agrega al array
            if ($(this).is(':checked')) {
                chk_arr.push($(this).val());
            } else {
                var indx_to_remove = chk_arr.indexOf($(this).val());
                chk_arr.splice(indx_to_remove, 1);
            }
            var chk_arr_str = chk_arr.toString();
            if (chk_arr_str[0] == ',') {
                chk_arr_str = chk_arr_str.substring(1);
            }
            r_options.filter.tipo_empresa = chk_arr_str;
            autoUpdate.forceUpdate();
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
        });


        // Filtrado - Encuesta
        $(document).on('change', '#filtrado_encuesta', function () {
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.encuesta = $(this).find('option:selected').val();
            autoUpdate.forceUpdate();
        });

        // Filtrado - Encuesta
        $(document).on('change', '#has_licencia', function () {
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.has_licencia = $(this).find('option:selected').val();
            autoUpdate.forceUpdate();
        });


        // Filtrado - Clasificación Interna
        $(document).on('change', '#filtrado_clasificacion_interna', function () {
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
            r_options.filter.clasificacion_interna = $(this).find('option:selected').val();
            autoUpdate.forceUpdate();
        });

        // Filtrado - Limpiar
        $(document).on('click', '#reset_filters', function () {
            r_options.filter.search_bar = null;
            r_options.filter.clasificacion = null;
            r_options.filter.tipo_empresa = null;
            r_options.filter.encuesta = null;
            r_options.filter.clasificacion_interna = null;
            $('#buscador_cliente').val('');
            autoUpdate.forceUpdate();
            $('#reporteador').find('.table tbody').css('opacity', 0.5);
        });


//***************************************************************
//------------------------- REPORTE BASE  -----------------------
//***************************************************************


//***************************************************************
//--------------------------- PAGINACIÓN  -----------------------
//***************************************************************
        $(document).on('click', '.paginacion', function (e) {
            e.preventDefault();

            //Prevenir que haga multiples llamadas, que haga 1 hasta que termine la otra.
            if (r_options.updating == 1) {
                console.warn("Wait: Se está actualizando.")
            } else {
                r_options.pagination.page = $(this).attr('data-paginacion');
                r_options.automatic_update = 0;
                r_options.updating = 1;
                autoUpdate.forceUpdate();

            }

        });
//***************************************************************
//--------------------------- PAGINACIÓN  -----------------------
//***************************************************************


//***************************************************************
//-------------------------- NEW CLIENT  ------------------------
//***************************************************************
        $(document).on('click', '.new_client', function (e) {
            e.preventDefault();
            $(this).partnersModal({
                title: 'Selecciona el tipo de Empresa del Cliente.',
                ajaxUrl: settings.clientes.render_template + 'clientes.nuevo_cliente_form',
                modalId: 'modal-new-client',
                forceWidth: 80,
                preventHideOnBackdrop: true,
                ajaxSuccessCallback: function () {
                    setTimeout(function () {
                        $.validate({
                            form: '#new_client_form',
                            errorMessageClass: 'invalid-feedback',
                            inputParentClassOnError: 'text-danger',
                            inputParentClassOnSuccess: 'text-success',
                            errorElementClass: 'is-invalid'
                        })
                    }, 500);
                }
            });
        });

        $(document).on('change', '.select_tipo_negocio_cliente', function () {
            $('#modal-new-client .modal-title').html('Rellena el formulario');
            $('.new_client_form_container').show();
            var $this = $(this).val();
            var $form = $('#new_client_form');
            if ($this == 1) {
                $('.show_on_particular').hide();
                $('.show_on_negocio').show();
                $('.show_on_prospecto').hide();

                $('.desc_otro_container').remove();
                $('input[name="radio_como_se_entero"]').attr('checked', false);

                //Quitar celular y correo y sus respectivos extras
                $('.multiple_cel_container').each(function () {
                    $(this).remove();
                });
                $form.find('input[name="cliente_celular"]').val('');

                $('.multiple_email_container').each(function () {
                    $(this).remove();
                });
                $form.find('input[name="cliente_correo"]').val('');
                $('.areas_interno_container').show();

            } else if ($this == 2) {
                $('.show_on_particular').show();
                $('.show_on_negocio').hide();
                $('.show_on_prospecto').hide();

                $('.desc_otro_container').remove();
                $('input[name="radio_como_se_entero"]').attr('checked', false);


                //Limpiar pagina web
                $form.find('input[name="cliente_pagina"]').val('');

            } else if ($this == 3) {
                $('.show_on_particular').hide();
                $('.show_on_negocio').show();
                $('.show_on_prospecto').hide();

                $('.desc_otro_container').remove();
                $('input[name="radio_como_se_entero"]').attr('checked', false);

                //Quitar celular y correo y sus respectivos extras
                $('.multiple_cel_container').each(function () {
                    $(this).remove();
                });
                $form.find('input[name="cliente_celular"]').val('');

                $('.multiple_email_container').each(function () {
                    $(this).remove();
                });
                $form.find('input[name="cliente_correo"]').val('');
                $('.areas_interno_container').show();

            } else if ($this == 4) {
                $('.show_on_particular').show();
                $('.show_on_negocio').hide();
                $('.show_on_prospecto').show();

                $('.desc_otro_container').remove();
                $('input[name="radio_como_se_entero"]').attr('checked', false);

                //Limpiar pagina web
                $form.find('input[name="cliente_pagina"]').val('');
                $('.areas_interno_container').show();

            } else if ($this == 5) {
                $('.show_on_particular').hide();
                $('.show_on_negocio').show();
                $('.show_on_prospecto').hide();

                $('.desc_otro_container').remove();
                $('input[name="radio_como_se_entero"]').attr('checked', false);

                //Quitar celular y correo y sus respectivos extras
                $('.multiple_cel_container').each(function () {
                    $(this).remove();
                });
                $form.find('input[name="cliente_celular"]').val('');

                $('.multiple_email_container').each(function () {
                    $(this).remove();
                });
                $form.find('input[name="cliente_correo"]').val('');

                $('.areas_interno_container').hide();

            }
        });

        $(document).on('click', '.add_extra_phone', function () {
            var template = '<div class="multiple_phone_container">' +
                '<div class="form-group row"> ' +
                '<label class="col-md-2 col-sm-12 col-form-label">Teléfono Extra</label> ' +
                '<div class="col-md-6 col-sm-12"> ' +
                '<div class="input-group"> ' +
                '<input type="text" class="form-control dato_cliente" data-tipo="11"> ' +
                '<span class="input-group-btn"> ' +
                '<button class="btn btn-outline-danger remove_extra_phone"  type="button" role="button">' +
                '<i class="fa fa-minus" aria-hidden="true"></i>' +
                '</button> ' +
                '</span> ' +
                '</div> ' +
                '</div> ' +
                '</div>' +
                '</div>';
            if ($('.multiple_phone_container').length == 0) {
                $(this).parents('.row').after(template);
            } else {
                $('.multiple_phone_container:last').after(template);
            }
        });

        $(document).on('click', '.remove_extra_phone', function () {
            if ($(this).attr('data-on-edit') == 1) {
                if ($(this).parents('.multiple_phone_container').find('.dato_cliente').attr('data-id-dato') != 0) {
                    var id = $(this).parents('.multiple_phone_container').find('.dato_cliente').attr('data-id-dato');
                    var div = $('<div class="removed_datos"></div>').attr('data-id-dato', id);
                    $('.removed_datos_container').append(div);
                }
                $(this).parents('.multiple_phone_container').remove();
            } else {
                $(this).parents('.multiple_phone_container').remove();
            }
        });

        $(document).on('click', '.add_extra_email', function () {
            var template = '<div class="multiple_email_container">' +
                '<div class="form-group row"> ' +
                '<label class="col-md-2 col-sm-12 col-form-label">Correo Extra</label> ' +
                '<div class="col-md-6 col-sm-12"> ' +
                '<div class="input-group"> ' +
                '<input type="text" class="form-control dato_cliente" data-tipo="13"> ' +
                '<span class="input-group-btn"> ' +
                '<button class="btn btn-outline-danger remove_extra_email" type="button" role="button">' +
                '<i class="fa fa-minus" aria-hidden="true"></i>' +
                '</button> ' +
                '</span> ' +
                '</div> ' +
                '</div> ' +
                '</div>' +
                '</div>';
            if ($('.multiple_email_container').length == 0) {
                $(this).parents('.row').after(template);
            } else {
                $('.multiple_email_container:last').after(template);
            }
        });

        $(document).on('click', '.remove_extra_email', function () {
            if ($(this).attr('data-on-edit') == 1) {
                if ($(this).parents('.multiple_email_container').find('.dato_cliente').attr('data-id-dato') != 0) {
                    var id = $(this).parents('.multiple_email_container').find('.dato_cliente').attr('data-id-dato');
                    var div = $('<div class="removed_datos"></div>').attr('data-id-dato', id);
                    $('.removed_datos_container').append(div);
                }
                $(this).parents('.multiple_email_container').remove();
            } else {
                $(this).parents('.multiple_email_container').remove();
            }
        });

        $(document).on('click', '.add_extra_cel', function () {
            var template = '<div class="multiple_cel_container">' +
                '<div class="form-group row"> ' +
                '<label class="col-md-2 col-sm-12 col-form-label">Celular Extra</label> ' +
                '<div class="col-md-6 col-sm-12"> ' +
                '<div class="input-group"> ' +
                '<input type="text" class="form-control dato_cliente" data-tipo="12"> ' +
                '<span class="input-group-btn"> ' +
                '<button class="btn btn-outline-danger remove_extra_cel" type="button" role="button">' +
                '<i class="fa fa-minus" aria-hidden="true"></i>' +
                '</button> ' +
                '</span> ' +
                '</div> ' +
                '</div> ' +
                '</div>' +
                '</div>';
            if ($('.multiple_cel_container').length == 0) {
                $(this).parents('.row').after(template);
            } else {
                $('.multiple_cel_container:last').after(template);
            }
        });

        $(document).on('click', '.remove_extra_cel', function () {
            if ($(this).attr('data-on-edit') == 1) {
                if ($(this).parents('.multiple_cel_container').find('.dato_cliente').attr('data-id-dato') != 0) {
                    var id = $(this).parents('.multiple_cel_container').find('.dato_cliente').attr('data-id-dato');
                    var div = $('<div class="removed_datos"></div>').attr('data-id-dato', id);
                    $('.removed_datos_container').append(div);
                }
                $(this).parents('.multiple_cel_container').remove();
            } else {
                $(this).parents('.multiple_cel_container').remove();
            }
        });

        $(document).on('change', 'input[name="radio_como_se_entero"]', function () {
            if ($(this).val() == 'otro') {
                var template = '<div class="form-group row desc_otro_container show_on_prospecto">' +
                    '<label class="col-md-2 col-sm-12 col-form-label">Descripción otro</label> ' +
                    '<div class="col-md-6 col-sm-12">' +
                    '<input type="text" class="form-control desc_otro_input" data-validation="required" data-validation-error-msg="Ingresa la forma en que se enteró el cliente."/>' +
                    '<small class="form-text text-muted">Describe la forma en la que se enteró el cliente.</small>' +
                    '</div>' +
                    '</div>';
                $('.como_se_entero_container').after(template);
                $('.desc_otro_input').focus();
            } else {
                $('.desc_otro_container').remove();
            }

        });


        $(document).on('change', '.select_cliente_nuevo', function () {
            if ($(this).val() == 2) {
                $('.clasificacion_sugerida_container').show();
            } else {
                $('.clasificacion_sugerida_container').hide();
            }
        });
//***************************************************************
//-------------------------- NEW CLIENT  ------------------------
//***************************************************************


//***************************************************************
//------------------------ CAPTURAR CLIENT  ---------------------
//***************************************************************
        $(document).on('keypress', ':input:not(textarea)', function (e) {
            return e.keyCode != 13;
        });
        $(document).on('submit', '#new_client_form', function (e) {
            e.preventDefault();
            var btn = $(this).find('button[type="submit"]');
            btn.partnersBtnControl('start');
            var datos = $('#new_client_form').serializeArray();
            var datosEnvio = {};
            for (var i = 0; i < datos.length; i++) {
                datosEnvio[datos[i]['name']] = datos[i]['value'];
            }

            datosEnvio.datos = [];
            $('.dato_cliente').each(function () {
                datosEnvio.datos.push({valor: $(this).val(), tipo: $(this).attr('data-tipo')});
            });

            if ($('.radio_como_se_entero_otro:checked').val() != 'otro') {
                datosEnvio.se_entero_otro = $('.radio_como_se_entero_otro:checked').val();
            } else {
                datosEnvio.se_entero_otro = $('.desc_otro_input').val();
            }

            datosEnvio.tipo_cliente = $('.select_tipo_negocio_cliente:checked').val();

            datosEnvio.areas = [];
            $('input[name="client_areas[]"]:checked').each(function () {
                datosEnvio.areas.push($(this).val());
            });

            datosEnvio.areas = datosEnvio.areas.toString();

            var envio = JSON.stringify(datosEnvio);

            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'new_client',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        btn.partnersBtnControl('end');
                        $('#modal-new-client').modal('hide');
                        autoUpdate.forceUpdate();
                        (getUrlVars()["new_cliente"] == 1) ? window.close() : '';

                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                        btn.partnersBtnControl('end');
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                    btn.partnersBtnControl('end');
                }
            });

        });
//***************************************************************
//------------------------ CAPTURAR CLIENT  ---------------------
//***************************************************************

//***************************************************************
//---------------------- CLIENTES INFORM ERRORS  ----------------
//***************************************************************
        $(document).on('click', '.inform_errors', function (e) {
            e.preventDefault();
            var error = {};
            error.err_msg = $(this).attr('data-error-msg');
            error.err_time = $(this).attr('data-error-time');
            error.err_loc = $(this).attr('data-error-location');
            error.err_user = $(this).attr('data-error-user');
            error.err_user_id = $(this).attr('data-error-user-id');

            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_sys_tools + 'report_error',
                data: JSON.stringify(error),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        $('.modal').each(function () {
                            $(this).modal('hide');
                        });
                        iziToast.destroy();
                        swal({
                            title: "Se ha enviado el error!",
                            type: "success",
                            text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
                            timer: 4000,
                            showConfirmButton: false
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });


        });
//***************************************************************
//---------------------- CLIENTES INFORM ERRORS  ----------------
//***************************************************************

//***************************************************************
//-------------------------- CLIENTES VISTA  --------------------
//***************************************************************
        $(document).on('click', '.vista_cliente', function (e) {
            e.preventDefault();
            iziToast.destroy();
            var id_cliente = $(this).attr('data-id');

            if ($('#vista-contacto-modal').hasClass('show') || $('#modal-new-contact').hasClass('show')) {
                $('#vista-contacto-modal').modal('hide');
                $('#modal-new-contact').modal('hide');

                setTimeout(function () {
                    $(this).partnersModal({
                        title: 'Vista Cliente',
                        ajaxUrl: settings.clientes.ruta_vista_cliente + id_cliente,
                        forceWidth: 90,
                        modalId: 'vista-cliente-modal',
                        noFooter: true,
                        ajaxSuccessCallback: function () {
                            init_editable();
                            setCurrentLocation("#cliente-current-location-dir");
                        }
                    });
                }, 500);
            } else {
                $(this).partnersModal({
                    title: 'Vista Cliente',
                    ajaxUrl: settings.clientes.ruta_vista_cliente + id_cliente,
                    forceWidth: 90,
                    modalId: 'vista-cliente-modal',
                    noFooter: true,
                    ajaxSuccessCallback: function () {
                        init_editable();
                        setCurrentLocation("#cliente-current-location-dir");
                    }
                });
            }
        });
//***************************************************************
//-------------------------- CLIENTES VISTA  --------------------
//***************************************************************


//***************************************************************
//------------------------ CLIENTES CANCELAR  -------------------
//***************************************************************
        $(document).on('click', '.cancelar_cliente', function () {
            var id_cliente = $(this).attr('data-id-cliente');
            var nombre_cliente = $(this).attr('data-nombre-cliente');
            var tipo_cliente = $(this).attr('data-tipo-cliente');

            swal({
                title: "Estás Seguro?",
                html: "Deseas cancelar a <span class='font-italic' style='font-weight: bold;'>" + nombre_cliente + "</span> ? No se podrá volver a utilizar otra vez!",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, cancelar!",
                cancelButtonText: "No!",
                showLoaderOnConfirm: true,
                onOpen: function () {
                    fixBootstrapModal();
                },
                preConfirm: function () {
                    return new Promise(function (resolve) {
                        $.ajax({
                            type: 'POST',
                            url: settings.clientes.ruta_capturar + 'cancel_client',
                            data: id_cliente,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                if (response.status == 'success') {
                                    autoUpdate.forceUpdate();
                                    $('.modal').each(function () {
                                        $(this).modal('hide');
                                    });
                                    setTimeout(function () {
                                        undo_client_cancelled(nombre_cliente, id_cliente, tipo_cliente);
                                        swal.close();
                                    }, 2000);
                                    resolve()
                                } else if (response.status == 'error') {
                                    iziToast.error({
                                        title: "Error",
                                        message: response.message
                                    });
                                }
                            },
                            error: function (xhr) {
                                iziToast.error({
                                    title: "Ocurrio un error: ",
                                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                });
                            }
                        });
                    });
                },
                allowOutsideClick: false
            }).then(function (a) {
                if (!a.dismiss) {
                    swal("Cancelado!", "Este cliente ha sido cancelado y no será posible utilizarlo más.", "success");
                }
            });

        });

        function undo_client_cancelled(nombre_cliente, id_cliente, tipo_cliente) {
            iziToast.show({
                title: nombre_cliente,
                message: ' ha sido cancelado.',
                position: 'bottomLeft',
                timeout: 10000,
                color: 'dark',
                progressBarColor: 'rgb(0, 255, 184)',
                icon: 'fa fa-user-times',
                buttons: [
                    ['<button data-id-cliente="' + id_cliente + '" data-nombre-cliente="' + nombre_cliente + '" data-tipo-cliente=' + tipo_cliente + ' class="client_undo_cancell">Deshacer</button>', function (instance, toast) {
                        instance.hide({
                            transitionOut: 'fadeOutUp',
                        }, toast, 'close');
                    }]
                ],
            });
        }

        $(document).on('click', '.client_undo_cancell', function () {
            var id_cliente = $(this).attr('data-id-cliente');
            var nombre_cliente = $(this).attr('data-nombre-cliente');
            var tipo_cliente = $(this).attr('data-tipo-cliente');
            var class_vista = '';
            if (tipo_cliente != 2) {
                class_vista = 'vista_cliente';
            } else {
                class_vista = 'vista_contacto';
            }
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'reactivate_client',
                data: id_cliente,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: nombre_cliente,
                            message: ' ha sido reactivado!, <a href="#" class="' + class_vista + '" data-id="' + id_cliente + '">Ver:</a>',
                            icon: 'fa fa-user-plus'
                        });
                        autoUpdate.forceUpdate();
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });

        });

//***************************************************************
//------------------------ CLIENTES CANCELAR  -------------------
//***************************************************************


//***************************************************************
//------------------------ AGREGAR CONTACTO  --------------------
//***************************************************************
        $(document).on('click', '.nuevo_contacto', function (e) {
            e.preventDefault();
            $('#vista-cliente-modal').modal('hide');
            var id_cliente = $(this).attr('data-id');
            var nombre_cliente = $(this).attr('data-nombre-cliente');

            //setTimeout() para prevenir scroll problem
            setTimeout(function () {
                $(this).partnersModal({
                    title: 'Agregar contacto a: <a href="#" class="vista_cliente" data-id="' + id_cliente + '">' + nombre_cliente + '</a>',
                    ajaxUrl: settings.clientes.render_template + 'clientes.nuevo_contacto_form' + '/' + id_cliente,
                    modalId: 'modal-new-contact',
                    forceWidth: 80,
                    preventHideOnBackdrop: true,
                    ajaxSuccessCallback: function () {
                        setTimeout(function () {
                            $.validate({
                                form: '#new_contact_form',
                                errorMessageClass: 'invalid-feedback',
                                inputParentClassOnError: 'text-danger',
                                inputParentClassOnSuccess: 'text-success',
                                errorElementClass: 'is-invalid'
                            });
                        }, 500);
                    }
                });
            }, 400);

        });

        $(document).on('change', '.select_tipo_contacto', function () {
            if ($(this).val() == 1) {
                $('.row_email').addClass('required');
                $('.row_email').find('input[name="cliente_correo"]').attr('data-validation', 'email');
                $('.row_email').find('input[name="cliente_correo"]').attr('data-validation-error-msg', 'Ingresa al menos un correo.');
            } else if ($(this).val() == 2) {
                $('.row_email').removeClass('required');
                $('.row_email').find('input[name="cliente_correo"]').removeAttr('data-validation');
                $('.row_email').find('input[name="cliente_correo"]').removeAttr('data-validation-error-msg');

            }
        });
//***************************************************************
//------------------------ AGREGAR CONTACTO  --------------------
//***************************************************************


//***************************************************************
//----------------------- CAPTURAR CONTACTO  --------------------
//***************************************************************
        $(document).on('submit', '#new_contact_form', function (e) {
            e.preventDefault();
            var btn = $(this).find('button[type="submit"]');
            var form = $('#new_contact_form');
            btn.partnersBtnControl('start');
            var datos = $('#new_contact_form').serializeArray();
            var datosEnvio = {};
            for (var i = 0; i < datos.length; i++) {
                datosEnvio[datos[i]['name']] = datos[i]['value'];
            }

            datosEnvio.datos = [];
            form.find('.dato_cliente').each(function () {
                datosEnvio.datos.push({valor: $(this).val(), tipo: $(this).attr('data-tipo')});
            });

            var envio = JSON.stringify(datosEnvio);
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'new_contact',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        btn.partnersBtnControl('end');
                        $('#modal-new-contact').modal('hide');
                        autoUpdate.forceUpdate();

                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                        btn.partnersBtnControl('end');
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });

        });
//***************************************************************
//----------------------- CAPTURAR CONTACTO  --------------------
//***************************************************************


//***************************************************************
//-------------------------- CONTACTO VISTA  --------------------
//***************************************************************
        $(document).on('click', '.vista_contacto', function (e) {
            e.preventDefault();
            iziToast.destroy();
            var id_contacto = $(this).attr('data-id');
            var id_padre = $(this).attr('data-id-padre');
            if (id_padre) {
                $('#vista-cliente-modal').modal('hide');

                setTimeout(function () {
                    $(this).partnersModal({
                        title: 'Vista Contacto',
                        ajaxUrl: settings.clientes.ruta_vista_contacto + id_contacto,
                        forceWidth: 90,
                        modalId: 'vista-contacto-modal',
                        noFooter: true,
                        ajaxSuccessCallback: function () {
                            init_editable();
                            setCurrentLocation("#contacto-current-location-dir");
                        }
                    });
                }, 400);

                setTimeout(function () {
                    $('#vista-contacto-modal').attr('data-opened-from-client', 1);
                    $('#vista-contacto-modal').attr('data-id-cliente', id_padre);

                }, 400);
            } else {
                if ($('#vista-cliente-modal').hasClass('show')) {
                    $('#vista-cliente-modal').modal('hide');
                    setTimeout(function () {
                        $(this).partnersModal({
                            title: 'Vista Contacto',
                            ajaxUrl: settings.clientes.ruta_vista_contacto + id_contacto,
                            forceWidth: 90,
                            modalId: 'vista-contacto-modal',
                            noFooter: true,
                            ajaxSuccessCallback: function () {
                                init_editable();
                                setCurrentLocation("#contacto-current-location-dir");
                            }
                        });
                    }, 400);
                } else {
                    $(this).partnersModal({
                        title: 'Vista Contacto',
                        ajaxUrl: settings.clientes.ruta_vista_contacto + id_contacto,
                        forceWidth: 90,
                        modalId: 'vista-contacto-modal',
                        noFooter: true,
                        ajaxSuccessCallback: function () {
                            init_editable();
                            setCurrentLocation("#contacto-current-location-dir");
                        }
                    });
                }


            }

        });

        $(document).on('hidden.bs.modal', '#vista-contacto-modal', function () {
            if ($(this).attr('data-opened-from-client') == 1) {
                var el = $('<a href="#" class="vista_cliente" data-id="' + $(this).attr("data-id-cliente") + '"></a>');
                $('html').append(el);
                //El setTimeout es para esperar hasta que se complete la animación del modal para que detecte
                // a tiempo si ya esta abierto o no, para prevenir que habra doble.
                setTimeout(function () {
                    if ($("#vista-cliente-modal").hasClass('show')) return false;
                    el.click();
                    el.remove();
                }, 500);
            }
        });
//***************************************************************
//-------------------------- CONTACTO VISTA  --------------------
//***************************************************************


//***************************************************************
//------------------------ ENCUESTA CLIENTE ---------------------
//***************************************************************
        $(document).on('click', '.capturar_encuesta', function (e) {
            e.preventDefault();
            var id_cliente = $(this).attr('data-id');
            var datos = {};
            datos.id_cliente = id_cliente;
            datos.type = 1;
            datos = JSON.stringify(datos);
            $('#panel-ventas-cliente').modal('hide');
            setTimeout(function () {
                $(this).partnersModal({
                    title: 'Capturar Encuesta',
                    modalId: 'agregar-encuesta-modal',
                    forceWidth: 60,
                    content: loader
                });

                $.ajax({
                    type: 'POST',
                    url: settings.clientes.ruta_capturar + 'clientes_encuesta',
                    data: datos,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.status == 'success') {
                            $('#agregar-encuesta-modal').attr('data-id-cliente', id_cliente);
                            $('#agregar-encuesta-modal .modal-body').html(response.message);
                            setTimeout(function () {
                                $.validate({
                                    form: '#encuesta_cliente_form',
                                    errorMessageClass: 'invalid-feedback',
                                    inputParentClassOnError: 'text-danger',
                                    inputParentClassOnSuccess: 'text-success',
                                    errorElementClass: 'is-invalid'
                                });
                            }, 400);
                        } else if (response.status == 'error') {
                            iziToast.error({
                                title: "Error",
                                message: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        iziToast.error({
                            title: "Ocurrio un error: ",
                            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                    }
                });
            }, 400);
        });

        $(document).on('submit', '#encuesta_cliente_form', function (e) {
            e.preventDefault();
            var btn = $(this).find('button[type="submit"]');
            btn.partnersBtnControl('start');
            var datos = $('#encuesta_cliente_form').serializeArray();
            var datosEnvio = {};
            for (var i = 0; i < datos.length; i++) {
                datosEnvio[datos[i]['name']] = datos[i]['value'];
            }
            datosEnvio.id_cliente = $(this).attr('data-id-cliente');

            datosEnvio.areas = [];
            $('input[name="areas_interes[]"]:checked').each(function () {
                datosEnvio.areas.push($(this).val());
            });

            datosEnvio.areas = datosEnvio.areas.toString();
            datosEnvio.type = 2;
            var envio = JSON.stringify(datosEnvio);

            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'clientes_encuesta',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });

        $(document).on('hidden.bs.modal', '#agregar-encuesta-modal, #vista-encuesta-modal', function () {
            var el = $('<a href="#" class="vista_cliente" data-id="' + $(this).attr("data-id-cliente") + '"></a>');
            $('html').append(el);
            setTimeout(function () {
                if ($("#vista-cliente-modal").hasClass('show')) return false;
                el.click();
                el.remove();
            }, 400);
        });

        $(document).on('click', '.vista_encuesta', function (e) {
            e.preventDefault();
            var id_cliente = $(this).attr('data-id-cliente');
            var id_encuesta = $(this).attr('data-id');
            var datos = {};
            datos.id_encuesta = id_encuesta;
            datos = JSON.stringify(datos);
            $('#panel-ventas-cliente').modal('hide');
            setTimeout(function () {
                $(this).partnersModal({
                    title: 'Vista Encuesta',
                    modalId: 'vista-encuesta-modal',
                    forceWidth: 60,
                    content: loader
                });

                $.ajax({
                    type: 'POST',
                    url: settings.clientes.ruta_capturar + 'clientes_vista_encuesta',
                    data: datos,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.status == 'success') {
                            $('#vista-encuesta-modal').attr('data-id-cliente', id_cliente);
                            $('#vista-encuesta-modal .modal-body').html(response.message);
                        } else if (response.status == 'error') {
                            iziToast.error({
                                title: "Error",
                                message: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        iziToast.error({
                            title: "Ocurrio un error: ",
                            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                    }
                });
            }, 400);
        });

//***************************************************************
//------------------------ ENCUESTA CLIENTE ---------------------
//***************************************************************


//***************************************************************
//------------------- AGREGAR DATOS EXTRA EDITAR  ---------------
//***************************************************************
        $(document).on('click', '.add_dato_extra', function () {
            var type = $(this).attr('data-type');
            var id_cliente = $(this).attr('data-id-cliente');
            if (type == "email") {
                if ($(this).parents('.modal').find('.new_dato_container_email').length >= 1) return false;
                var new_dato = '<div class="form-group row custom_form_group new_dato_container new_dato_container_email">' +
                    '<label class="col-sm-3 col-form-label"><b>Correo Extra:</b></label>' +
                    '<div class="col-md-7"><input type="text" class="form-control animated fadeInDownCustom new_dato_val"></div>' +
                    '<div class="col-md-2" style="overflow:hidden;">' +
                    ' <i style="overflow: hidden; font-size:20px;" class="fas fa-save float-left animated fadeInDownCustom text-success save_new_dato" data-id-cliente="' + id_cliente + '" data-tipo-dato="13" role="button" aria-hidden="true"></i>' +
                    '<i style="overflow: hidden; font-size:20px;" class="fa fa-ban float-right animated fadeInDownCustom text-danger cancel_new_dato" data-id-cliente="' + id_cliente + '" role="button" aria-hidden="true"></i> ' +
                    '</div>' +
                    '</div>';
                $(new_dato).insertAfter($(this).closest('.form-group.row'));
            } else if (type == "cel") {
                if ($(this).parents('.modal').find('.new_dato_container_cel').length >= 1) return false;
                var new_dato = '<div class="form-group row custom_form_group new_dato_container new_dato_container_cel">' +
                    '<label class="col-sm-3 col-form-label"><b>Celular Extra:</b></label>' +
                    '<div class="col-md-7"><input type="text" class="form-control animated fadeInDownCustom new_dato_val"></div>' +
                    '<div class="col-md-2" style="overflow:hidden;">' +
                    ' <i style="overflow: hidden; font-size:20px;" class="fas fa-save float-left animated fadeInDownCustom text-success save_new_dato" data-id-cliente="' + id_cliente + '" data-tipo-dato="12" role="button" aria-hidden="true"></i>' +
                    '<i style="overflow: hidden; font-size:20px;" class="fa fa-ban float-right animated fadeInDownCustom text-danger cancel_new_dato" data-id-cliente="' + id_cliente + '" role="button" aria-hidden="true"></i> ' +
                    '</div>' +
                    '</div>';
                $(new_dato).insertAfter($(this).closest('.form-group.row'));
            } else if (type == "phone") {
                if ($(this).parents('.modal').find('.new_dato_container_phone').length >= 1) return false;
                var new_dato = '<div class="form-group row custom_form_group new_dato_container new_dato_container_phone">' +
                    '<label class="col-sm-3 col-form-label"><b>Teléfono Extra:</b></label>' +
                    '<div class="col-md-7"><input type="text" class="form-control animated fadeInDownCustom new_dato_val"></div>' +
                    '<div class="col-md-2" style="overflow:hidden;">' +
                    ' <i style="overflow: hidden; font-size:20px;" class="fas fa-save float-left animated fadeInDownCustom text-success save_new_dato" data-id-cliente="' + id_cliente + '" data-tipo-dato="11" role="button" aria-hidden="true"></i>' +
                    '<i style="overflow: hidden; font-size:20px;" class="fa fa-ban float-right animated fadeInDownCustom text-danger cancel_new_dato" data-id-cliente="' + id_cliente + '" role="button" aria-hidden="true"></i> ' +
                    '</div>' +
                    '</div>';
                $(new_dato).insertAfter($(this).closest('.form-group.row'));
            }
        });

        $(document).on('click', '.cancel_new_dato', function () {
            $(this).closest('.new_dato_container').remove();
        });

        $(document).on('click', '.save_new_dato', function () {
            var val = $(this).closest('.new_dato_container').find('.new_dato_val').val();
            var id_cliente = $(this).attr('data-id-cliente');
            var tipo_dato = $(this).attr('data-tipo-dato');
            var current_modal_open;
            var envio = {};
            envio.id_cliente = id_cliente;
            envio.new_val = val;
            envio.type = 1;
            envio.tipo_dato = tipo_dato;
            envio = JSON.stringify(envio);
            if ($('#vista-cliente-modal').length >= 1) {
                if ($('#vista-cliente-modal').hasClass('show')) {
                    current_modal_open = 'cliente';
                }
            }

            if ($('#vista-contacto-modal').length >= 1) {
                if ($('#vista-contacto-modal').hasClass('show')) {
                    current_modal_open = 'contacto';
                }
            }

            if (current_modal_open == 'cliente') {
                $('#vista-cliente-modal .modal-body').html(loader);
                $.ajax({
                    type: 'POST',
                    url: settings.clientes.ruta_capturar + 'datos_extras_clientes',
                    data: envio,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.status == 'success') {
                            iziToast.success({
                                title: "Bien! ",
                                message: response.message
                            });
                            $.ajax({
                                url: settings.clientes.ruta_vista_cliente + id_cliente,
                                success: function (data) {
                                    init_editable();
                                    $('#vista-cliente-modal .modal-body').html(data);
                                }
                            });
                        } else if (response.status == 'error') {
                            iziToast.error({
                                title: "Error",
                                message: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        iziToast.error({
                            title: "Ocurrio un error: ",
                            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                    }
                });

            } else {
                $('#vista-contacto-modal .modal-body').html(loader);
                $.ajax({
                    type: 'POST',
                    url: settings.clientes.ruta_capturar + 'datos_extras_clientes',
                    data: envio,
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        if (response.status == 'success') {
                            iziToast.success({
                                title: "Bien! ",
                                message: response.message
                            });
                            $.ajax({
                                url: settings.clientes.ruta_vista_contacto + id_cliente,
                                success: function (data) {
                                    init_editable();
                                    $('#vista-contacto-modal .modal-body').html(data);
                                }
                            });
                        } else if (response.status == 'error') {
                            iziToast.error({
                                title: "Error",
                                message: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        iziToast.error({
                            title: "Ocurrio un error: ",
                            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                        });
                    }
                });
            }

        });

//***************************************************************
//------------------- AGREGAR DATOS EXTRA EDITAR  ---------------
//***************************************************************


//***************************************************************
//------------------- ELIMINAR DATOS EXTRA EDITAR  --------------
//***************************************************************
        $(document).on('click', '.delete_dato_extra', function () {
            var id_dato = $(this).attr('data-id-dato');
            var container = $(this).closest('.form-group.row');
            var envio = {};
            envio.id_dato = id_dato;
            envio.type = 2;
            envio = JSON.stringify(envio);

            swal({
                title: "Estás Seguro?",
                html: "Deseas eliminar este dato?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, eliminar!",
                cancelButtonText: "No!",
                showLoaderOnConfirm: true,
                onOpen: function () {
                    fixBootstrapModal();
                },
                preConfirm: function () {
                    return new Promise(function (resolve) {
                        $.ajax({
                            type: 'POST',
                            url: settings.clientes.ruta_capturar + 'datos_extras_clientes',
                            data: envio,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                if (response.status == 'success') {
                                    resolve()
                                } else if (response.status == 'error') {
                                    iziToast.error({
                                        title: "Error",
                                        message: response.message
                                    });
                                }
                            },
                            error: function (xhr) {
                                iziToast.error({
                                    title: "Ocurrio un error: ",
                                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                });
                            }
                        });
                    });
                },
                allowOutsideClick: false
            }).then(function (a) {
                if (!a.dismiss) {
                    container.remove();
                    swal.close();
                    autoUpdate.forceUpdate();
                }
            });

        });
//***************************************************************
//------------------- ELIMINAR DATOS EXTRA EDITAR  --------------
//***************************************************************


//***************************************************************
//------------------------- VALIDAR RFC -------------------------
//***************************************************************
        $(document).on('blur', 'input[name="cliente_rfc"]', function () {
            var rfc = $(this).val();

            if ($.trim(rfc)) {

                if (rfcValido(rfc)) {
                    $(this).closest('.row').removeClass('is-invalid');
                    $(this).closest('.row').addClass('is-valid');
                    $(this).addClass('form-control-success');
                    $(this).closest('.row .col-md-6').find('.help-block.form-control-feedback').remove();
                } else {
                    $(this).closest('.row').removeClass('is-valid');
                    $(this).closest('.row').addClass('is-invalid');
                    $(this).addClass('form-control-danger');
                    $(this).closest('.row .col-md-6').find('.help-block.form-control-feedback').remove();
                    $(this).closest('.row .col-md-6').append('<div class="help-block form-control-feedback">Ingresa un RFC válido</div>');
                }

            } else {
                $(this).closest('.row').removeClass('is-valid');
                $(this).closest('.row').removeClass('is-invalid');
                $(this).removeClass('form-control-success');
                $(this).addClass('form-control-danger');
                $(this).closest('.row .col-md-6').find('.help-block.form-control-feedback').remove();
            }
        });

        //Función para validar un RFC
        // Devuelve el RFC sin espacios ni guiones si es correcto
        // Devuelve false si es inválido
        // (debe estar en mayúsculas, guiones y espacios intermedios opcionales)
        function rfcValido(rfc) {
            var aceptarGenerico = true;
            var re = /^([A-ZÑ&]{3,4}) ?(?:- ?)?(\d{2}(?:0[1-9]|1[0-2])(?:0[1-9]|[12]\d|3[01])) ?(?:- ?)?([A-Z\d]{2})([A\d])$/;
            var validado = rfc.match(re);

            if (!validado)  //Coincide con el formato general del regex?
                return false;

            //Separar el dígito verificador del resto del RFC
            var digitoVerificador = validado.pop(),
                rfcSinDigito = validado.slice(1).join(''),
                len = rfcSinDigito.length,

                //Obtener el digito esperado
                diccionario = "0123456789ABCDEFGHIJKLMN&OPQRSTUVWXYZ Ñ",
                indice = len + 1;
            var suma,
                digitoEsperado;

            if (len == 12) suma = 0;
            else suma = 481; //Ajuste para persona moral

            for (var i = 0; i < len; i++)
                suma += diccionario.indexOf(rfcSinDigito.charAt(i)) * (indice - i);
            digitoEsperado = 11 - suma % 11;
            if (digitoEsperado == 11) digitoEsperado = 0;
            else if (digitoEsperado == 10) digitoEsperado = "A";

            //El dígito verificador coincide con el esperado?
            // o es un RFC Genérico (ventas a público general)?
            if ((digitoVerificador != digitoEsperado)
                && (!aceptarGenerico || rfcSinDigito + digitoVerificador != "XAXX010101000"))
                return false;
            else if (!aceptarGenerico && rfcSinDigito + digitoVerificador == "XEXX010101000")
                return false;
            return rfcSinDigito + digitoVerificador;
        }

//***************************************************************
//------------------------- VALIDAR RFC -------------------------
//***************************************************************


//***************************************************************
//------------------- EDITAR DATOS FACTURACIÓN  -----------------
//***************************************************************
        $(document).on('click', '.editar_datos_facturacion', function () {
            var tr = '<tr class="tr_dato_facturacion" data-nuevo="true">' +
                '<td><input type="text" class="form-control nombre_facturacion_dato_cliente"></td>' +
                '<td><input type="text" class="form-control rfc_dato_cliente"></td>' +
                '<td style="vertical-align: middle; font-size:15px;"><i class="fa fa-plus-circle agregar_nuevo_dato_facturacion text-success"  data-edit-type="text"role="button" aria-hidden="true"></i></td>' +
                '</tr>';

            $('.guardar_datos_facturacion').show();
            $('.cancelar_edicion_facturacion').show();
            $('.editar_datos_facturacion').hide();
            $('.table_datos_facturacion tbody tr').each(function () {
                var tmp_name = '<input type="text" class="form-control nombre_facturacion_dato_cliente" value="' + $(this).find('.td_facturacion_name').html() + '" />';
                $(this).find('.td_facturacion_name').html(tmp_name);
                var tmp_rfc = '<input type="text" class="form-control rfc_dato_cliente" value="' + $(this).find('.td_facturacion_rfc').html() + '" />';
                $(this).find('.td_facturacion_rfc').html(tmp_rfc);
                var td = '<td><i class="fa fa-minus-circle eliminar_dato_facturacion" data-edit-type="text"role="button" aria-hidden="true"></i></td>';
                $(this).append(td);
            });

            $('.table_datos_facturacion tbody').append(tr);
        });

        $(document).on('click', '.agregar_nuevo_dato_facturacion', function () {
            var tr = '<tr class="tr_dato_facturacion" data-nuevo="true">' +
                '<td><input type="text" class="form-control nombre_facturacion_dato_cliente"></td>' +
                '<td><input type="text" class="form-control rfc_dato_cliente"></td>' +
                '<td style="vertical-align: middle; font-size:15px;"><i class="fa fa-minus-circle eliminar_dato_facturacion text-danger" data-edit-type="text"role="button" aria-hidden="true"></i></td>' +
                '</tr>';

            $('.table_datos_facturacion tbody').append(tr);
        });

        $(document).on('click', '.eliminar_dato_facturacion', function () {
            // Si no es nuevo entonces ya existia en el servidor, entonces se tendra que eliminar del servidor.
            if ($(this).parents('tr').attr('data-nuevo') == "false") {
                var div = '<div data-id-dato="' + $(this).parents('tr').attr('data-id-dato') + '"></div>';
                $('.deleted_datos_facturacion').append(div);
            }
            $(this).parents('tr').remove();
        });

        $(document).on('click', '.guardar_datos_facturacion', function () {
            $('.guardar_datos_facturacion').hide();
            var id_cliente = $(this).attr('data-id-cliente');
            var deleted_datos = [];
            $('.deleted_datos_facturacion div').each(function () {
                deleted_datos.push($(this).attr('data-id-dato'));
            });
            var nuevos_datos = [];

            $('.table_datos_facturacion tbody tr').each(function () {
                if ($.trim($(this).find('.rfc_dato_cliente').val()) != '' || $.trim($(this).find('.nombre_facturacion_dato_cliente').val()) != '') {
                    nuevos_datos.push({
                        rfc: $(this).find('.rfc_dato_cliente').val(),
                        nombre_facturacion: $(this).find('.nombre_facturacion_dato_cliente').val(),
                        dato_nuevo: $(this).attr('data-nuevo') == "true",
                        id_dato: $(this).attr('data-id-dato')
                    });
                }
            });


            var datos = {};
            datos.deleted_datos = deleted_datos;
            datos.nuevos_datos = nuevos_datos;
            datos.id_cliente = id_cliente;
            datos = JSON.stringify(datos);
            $('#vista-cliente-modal .modal-body').html(loader);

            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'capturar_datos_facturacion',
                data: datos,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        $.ajax({
                            url: settings.clientes.ruta_vista_cliente + id_cliente,
                            success: function (data) {
                                init_editable();
                                $('#vista-cliente-modal .modal-body').html(data);
                            }
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });

        $(document).on('click', '.cancelar_edicion_facturacion', function () {
            var id_cliente = $(this).attr('data-id-cliente');
            $('#vista-cliente-modal .modal-body').html(loader);
            $.ajax({
                url: settings.clientes.ruta_vista_cliente + id_cliente,
                success: function (data) {
                    init_editable();
                    $('#vista-cliente-modal .modal-body').html(data);
                }
            });
        });
//***************************************************************
//------------------- EDITAR DATOS FACTURACIÓN  -----------------
//***************************************************************


//***************************************************************
//--------------------- MAPS GEOLOCALIZACIÓN  -------------------
//***************************************************************
        /**
         * Determina si la geolocalizción está disponible para ser utilizada para generar el URL para el maps desde "Mi Ubicación" hasta el cliente.
         * @param id
         */
        function setCurrentLocation(id) {
            setTimeout(function () {
                if (navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition((id == "#cliente-current-location-dir" ? showPosition : showPosition_), function (error) {
                        if (error.code == error.PERMISSION_DENIED) {
                            $(id).attr('href', '#');
                            $(id).css(
                                {
                                    'color': '#ccc',
                                    'cursor': 'not-allowed'
                                }
                            );
                            $(id).addClass('not-allowed');
                        }
                    });
                } else {
                    $(id).attr('href', '#');
                    $(id).css(
                        {
                            'color': '#ccc',
                            'cursor': 'not-allowed'
                        }
                    );
                    $(id).addClass('not-supported');
                }
            }, 400);

        }

        $(document).on('click', '#cliente-current-location-dir.not-supported, #contacto-current-location-dir.not-supported', function (e) {
            e.preventDefault();
            swal(
                'Error',
                'Tu navegador no soporta la geolocalización',
                'error'
            );
        });

        $(document).on('click', '#cliente-current-location-dir.not-allowed, #contacto-current-location-dir.not-allowed', function (e) {
            e.preventDefault();
            swal(
                'Error',
                'Debes otorgar permisos en el navegador para que pcpartners.com.mx pueda determinar tu ubicación.',
                'error'
            );
        });

        /**
         * Utilizada para modificar con lat y long del usuario actualmente en la vista del cliente
         * @param position
         */
        function showPosition(position) {
            var $this = $("#cliente-current-location-dir");
            var clienteDirection = $this.closest('p').attr('data-cord');
            var newHref = "https://www.google.com.mx/maps/dir/" + position.coords.latitude + "," + position.coords.longitude + "/" + clienteDirection;
            $this.attr('href', newHref);
        }

        /**
         * Utilizada para modificar con lat y long del usuario actualmente en la vista del contacto
         * @param position
         */
        function showPosition_(position) {
            var $this = $("#contacto-current-location-dir");
            var clienteDirection = $this.closest('p').attr('data-cord');
            var newHref = "https://www.google.com.mx/maps/dir/" + position.coords.latitude + "," + position.coords.longitude + "/" + clienteDirection;
            $this.attr('href', newHref);
        }

//***************************************************************
//--------------------- MAPS GEOLOCALIZACIÓN  -------------------
//***************************************************************


//***************************************************************
//---------------- EDITAR CLASIFICACIÓN CLIENTE   ---------------
//***************************************************************
        $(document).on('click', '.mover_clasificacion_cliente', function () {
            var tipo_clasificacion = $(this).attr('data-clasificacion-cliente');
            var id_cliente = $(this).attr('data-id-cliente');
            var has_permissions = $(this).attr('data-has-permissions');
            var html = ``;
            if (has_permissions == "true") {
                // Permitir moverlo a cualquier clasificación
                html += `
                        <div class="row">
                        <div class="col-md-12">El cliente es clasificación <span class="font-weight-bold">${tipo_clasificacion.toUpperCase()}</span> ,
                         selecciona a cual clasificación lo quieres mover.</div>
                        </div>
                        <div class="row my-2 justify-content-center">
                            <div>
                                <select class="form-control" name="choose_new_clasificacion">`;

                html += tipo_clasificacion != 'a' ? '<option value="a">A</option>' : '';
                html += tipo_clasificacion != 'b' ? '<option value="b">B</option>' : '';
                html += tipo_clasificacion != 'd' ? '<option value="d">D</option>' : '';
                html += tipo_clasificacion != 'e' ? '<option value="e" >E</option>' : '';

                html += `</select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <textarea name="motivo_mover_clasificacion" class="form-control"
                                    placeholder="Ingresa un motivo de porque lo mueves de clasificación" rows="3"></textarea>
                            </div>
                        </div>`;
            } else if (has_permissions == "false") {
                // Solo lo va a poder mover a clasificación B
                html += `
                        <div class="row">
                        <div class="col-md-12">El cliente es clasificación <span class="font-weight-bold">${tipo_clasificacion.toUpperCase()}</span> ,
                         y solo lo puedes mover a <span class="font-weight-bold">B</span>.</div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <textarea name="motivo_mover_clasificacion" class="form-control"
                                    placeholder="Ingresa un motivo de porque lo mueves de clasificación" rows="3"></textarea>
                            </div>
                        </div>`;
            }


            swal({
                title: 'Mover clasificación Cliente',
                html: html,
                showCancelButton: true,
                confirmButtonText: 'Mover',
                cancelButtonText: 'Cancelar',
                cancelButtonColor: '#DD6B55',
                showLoaderOnConfirm: true,
                onOpen: fixBootstrapModal,
                preConfirm: function () {
                    return new Promise(function (resolve, reject) {
                        // Validar motivo descrito
                        var motivo = $('textarea[name="motivo_mover_clasificacion"]').val();
                        if ($.trim(motivo) == '') {
                            reject("Ingresa un motivo");
                        } else {
                            var datos = {};
                            datos.current_clasificacion = tipo_clasificacion;
                            datos.new_clasificacion = has_permissions == "true" ? $('select[name="choose_new_clasificacion"] option:selected').val() : 'b';
                            datos.id_cliente = id_cliente;
                            datos.motivo_clasificacion = motivo;
                            $.ajax({
                                type: 'POST',
                                url: settings.clientes.ruta_capturar + 'mover_clasificacion_cliente',
                                data: JSON.stringify(datos),
                                contentType: "application/json; charset=utf-8",
                                dataType: "json",
                                success: function (response) {
                                    if (response.status == 'success') {
                                        $('#vista-cliente-modal .modal-body').html(loader);
                                        $.ajax({
                                            url: settings.clientes.ruta_vista_cliente + id_cliente,
                                            success: function (data) {
                                                init_editable();
                                                $('#vista-cliente-modal .modal-body').html(data);
                                            }
                                        });
                                        resolve();
                                    } else if (response.status == 'error') {
                                        swal.close();
                                        iziToast.error({
                                            title: "Error",
                                            message: response.message
                                        });
                                    }
                                },
                                error: function (xhr) {
                                    swal.close();
                                    iziToast.error({
                                        title: "Ocurrio un error: ",
                                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                    });
                                }
                            });
                        }
                    })
                },
                allowOutsideClick: false
            }).then(function (a) {
                if (!a.dismiss) {
                    swal({
                        type: 'success',
                        title: 'Bien!',
                        html: 'Clasificación cambiada correctamente',
                        timer: 2000
                    });
                    autoUpdate.forceUpdate();
                }
            }).catch(function () {
                swal.close();
            });
        });
//***************************************************************
//---------------- EDITAR CLASIFICACIÓN CLIENTE   ---------------
//***************************************************************


//***************************************************************
//--------------- VER OBSERVACIONES INTERNO CLIENTE -------------
//***************************************************************
        $(document).on('click', '.ver_observaciones_internas', function () {
            var id_cliente = $(this).attr('data-id-cliente');
            $(this).partnersObs(
                {
                    modalId: 'modal-clientes-observaciones-internas',
                    ajaxUrl: settings.clientes.ruta_sys_tools + 'load_obs',
                    index: 'id_cliente',
                    id_index: id_cliente,
                    tabla: 'partners_clientes',
                    col: 'observaciones_internas',
                    ajaxSuccessCallback: function () {
                        $('#vista-cliente-modal .modal-body').html(loader);
                        $.ajax({
                            url: settings.clientes.ruta_vista_cliente + id_cliente,
                            success: function (data) {
                                init_editable();
                                $('#vista-cliente-modal .modal-body').html(data);
                            }
                        });
                    }
                }
            );
        });
//***************************************************************
//--------------- VER OBSERVACIONES INTERNO CLIENTE -------------
//***************************************************************


//***************************************************************
//--------------- SOLICITAR RECLASIFICACIÓN CLIENTE -------------
//***************************************************************
        $(document).on('click', '.sugerir_reclasificacion_cliente', function () {
            var tipo_clasificacion = $(this).attr('data-clasificacion-cliente');
            var id_cliente = $(this).attr('data-id-cliente');
            var html = ``;

            html += `
                        <div class="row">
                        <div class="col-md-12">El cliente es clasificación <span class="font-weight-bold">${tipo_clasificacion.toUpperCase()}</span> ,
                         selecciona a cual clasificación propones moverlo y especifica por que.</div>
                        </div>
                        <div class="row my-2 justify-content-center">
                            <div>
                                <select class="form-control" name="choose_new_clasificacion">`;

            html += tipo_clasificacion != 'a' ? '<option value="a">A</option>' : '';
            html += tipo_clasificacion != 'b' ? '<option value="b">B</option>' : '';
            html += tipo_clasificacion != 'd' ? '<option value="d">D</option>' : '';
            html += tipo_clasificacion != 'e' ? '<option value="e" >E</option>' : '';

            html += `</select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <textarea name="motivo_mover_clasificacion" class="form-control"
                                    placeholder="Ingresa un motivo de porque lo mueves de clasificación" rows="3"></textarea>
                            </div>
                        </div>`;

            swal({
                title: 'Sugerir Reclasificación Cliente',
                html: html,
                showCancelButton: true,
                confirmButtonText: 'Mover',
                cancelButtonText: 'Cancelar',
                cancelButtonColor: '#DD6B55',
                showLoaderOnConfirm: true,
                onOpen: fixBootstrapModal,
                preConfirm: function () {
                    return new Promise(function (resolve, reject) {
                        // Validar motivo descrito
                        var motivo = $('textarea[name="motivo_mover_clasificacion"]').val();
                        if ($.trim(motivo) == '') {
                            reject("Ingresa un motivo");
                        } else {
                            var datos = {};
                            datos.current_clasificacion = tipo_clasificacion;
                            datos.new_clasificacion = $('select[name="choose_new_clasificacion"] option:selected').val();
                            datos.id_cliente = id_cliente;
                            datos.motivo_clasificacion = motivo;
                            $.ajax({
                                type: 'POST',
                                url: settings.clientes.ruta_capturar + 'sugerir_clasificacion_cliente',
                                data: JSON.stringify(datos),
                                contentType: "application/json; charset=utf-8",
                                dataType: "json",
                                success: function (response) {
                                    if (response.status == 'success') {
                                        $('#vista-cliente-modal .modal-body').html(loader);
                                        $.ajax({
                                            url: settings.clientes.ruta_vista_cliente + id_cliente,
                                            success: function (data) {
                                                init_editable();
                                                $('#vista-cliente-modal .modal-body').html(data);
                                            }
                                        });
                                        resolve();
                                    } else if (response.status == 'error') {
                                        swal.close();
                                        iziToast.error({
                                            title: "Error",
                                            message: response.message
                                        });
                                    }
                                },
                                error: function (xhr) {
                                    swal.close();
                                    iziToast.error({
                                        title: "Ocurrio un error: ",
                                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                    });
                                }
                            });
                        }
                    })
                },
                allowOutsideClick: false
            }).then(function (a) {
                if (!a.dismiss) {
                    swal({
                        type: 'success',
                        title: 'Bien!',
                        html: 'Se ha enviado tu sugerencia correctamente.',
                        timer: 2000
                    });
                    autoUpdate.forceUpdate();
                }
            }).catch(function () {
                swal.close();
            });
        });
//***************************************************************
//--------------- SOLICITAR RECLASIFICACIÓN CLIENTE -------------
//***************************************************************


//***************************************************************
//----------------------- CONTENT EDITABLE  ---------------------
//***************************************************************
        function init_editable() {
            setTimeout(function () {
                // Set Defaults
                $.fn.editable.defaults.mode = 'inline';
                $.fn.editable.defaults.emptytext = "Vacío";
                $.fn.editable.defaults.url = ruta_url;
                $.fn.editable.defaults.send = "always";
                $.fn.editable.defaults.disabled = true;
                $.fn.editable.defaults.ajaxOptions = {
                    type: 'POST',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json"
                };
                $.fn.editable.defaults.success = function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        autoUpdate.forceUpdate();
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                };
                $.fn.editable.defaults.params = function params(params, el) {
                    var element = $(el);
                    var p = {};
                    p.edit_table = element.data('edit-table');
                    p.edit_col = element.data('edit-column');
                    p.edit_table_key = element.data('edit-table-key');
                    p.edit_id = element.data('edit-id');
                    p.new_val = params.value;
                    return p;
                };

                // Destroy All
                $('.editable-text-field').editable('destroy');
                $('.editable-textarea-field').editable('destroy');
                $('.editable-custom-areas').editable('destroy');
                $('.editable-custom-tipo-empresa').editable('destroy');


                // Text Field
                $('.editable-text-field').editable({
                    type: 'text'
                });

                // Textarea Field
                $('.editable-textarea-field').editable({
                    type: 'textarea',
                    rows: 5
                });

                // Custom Areas Checkbox Field
                var v_a = $('.editable-custom-areas').data('edit-values');
                var values_areas = [];
                if ($.trim(v_a).length > 0) {
                    // Solo hay 1 elemento
                    if ($.trim(v_a).indexOf(',') == -1) {
                        values_areas.push(v_a);
                    } else {
                        // Hay varios
                        values_areas = v_a.split(',');
                    }
                }
                values_areas = values_areas.map(function (x) {
                    return parseFloat(x)
                });
                $('.editable-custom-areas').editable({
                    value: values_areas,
                    source: [
                        {value: 1, text: 'CCTV'},
                        {value: 2, text: 'Soporte'},
                        {value: 3, text: 'Ventas'},
                        {value: 4, text: 'Web'},
                        {value: 5, text: 'Admon'}
                    ],
                    type: 'checklist',
                    display: function (value, sourceData) {
                        //display checklist as comma-separated values
                        var html = [],
                            checked = $.fn.editableutils.itemsByValue(value, sourceData);

                        if (checked.length) {
                            $.each(checked, function (i, v) {
                                html.push($.fn.editableutils.escape(v.text));
                            });
                            $(this).html(html.join(', '));
                        } else {
                            $(this).empty();
                        }
                    }
                });

                // Custom Tipo Negocio Select Field
                $('.editable-custom-tipo-empresa').editable({
                    values: $('.editable-custom-tipo-empresa').html(),
                    source: [
                        {value: 1, text: 'Negocio'},
                        {value: 2, text: 'Particular'},
                        {value: 3, text: 'Distribuidor'},
                        {value: 4, text: 'Prospecto'}
                    ],
                    type: 'select'
                });

                // Custom Tipo Contacto Select Field
                $('.editable-custom-tipo-contacto').editable({
                    values: $('.editable-custom-tipo-contacto').data('values'),
                    source: [
                        {value: 1, text: 'Particular'},
                        {value: 2, text: 'Sucursal'}
                    ],
                    type: 'select'
                });

                // Custom Promociones Contacto Select Field
                $('.editable-custom-promociones-contacto').editable({
                    values: $('.editable-custom-promociones-contacto').data('values'),
                    source: [
                        {value: 1, text: 'Si'},
                        {value: 0, text: 'No'}
                    ],
                    type: 'select'
                });

                // Custom Contacto Facturación Select Field
                $('.editable-custom-contacto-facturacion').editable({
                    values: $('.editable-custom-contacto-facturacion').data('values'),
                    source: [
                        {value: 1, text: 'Si'},
                        {value: 0, text: 'No'}
                    ],
                    type: 'select'
                });

            }, 400);

        }

        $(document).on('click', '.toggleEdit', function () {
            $('.editable-text-field').editable('toggleDisabled');
            $('.editable-textarea-field').editable('toggleDisabled');
            $('.editable-custom-areas').editable('toggleDisabled');
            $('.editable-custom-tipo-empresa').editable('toggleDisabled');
            $('.editable-custom-tipo-contacto').editable('toggleDisabled');
            $('.editable-custom-promociones-contacto').editable('toggleDisabled');
            $('.editable-custom-contacto-facturacion').editable('toggleDisabled');
        });

//***************************************************************
//----------------------- CONTENT EDITABLE  ---------------------
//***************************************************************

//***************************************************************
//---------------------- AREA VENTAS CLIENTE --------------------
//***************************************************************
        $(document).on('click', '.area_ventas_cliente', function (e) {
            e.preventDefault();
            var id_cliente = $(this).data('id-cliente');
            $('#vista-cliente-modal').modal('hide');
            if ($(this).attr('data-from-reporteador')) {
                $(this).partnersModal({
                    title: 'Panel Ventas Cliente',
                    modalId: 'panel-ventas-cliente',
                    forceWidth: 95,
                    content: loader
                });

                // Poner el data-from-reporteador solo en este caso, porque quiero prevenir después un
                // comportamiento al momento de que cierren el modal del panel de ventas solamente cuando se abra
                // desde el panel de clientes y no desde adentro de la ficha del cliente.
                setTimeout(function () {
                    $('#panel-ventas-cliente').attr('data-from-reporteador', true);
                }, 100);
            } else {
                setTimeout(function () {
                    $(this).partnersModal({
                        title: 'Panel Ventas Cliente',
                        modalId: 'panel-ventas-cliente',
                        forceWidth: 95,
                        content: loader
                    });
                }, 500);
            }

            vista_panel_ventas(id_cliente);
        });

        $(document).on('hidden.bs.modal', '#panel-ventas-cliente', function () {
            // Solamente reabrir el modal del cliente cuando no venga el click desde el reporteador de clientes, solo
            // cuando venga desde la ficha del cliente.
            if (!$(this).attr('data-from-reporteador')) {
                var el = $('<a href="#" class="vista_cliente" data-id="' + $(this).attr("data-id-cliente") + '"></a>');
                $('html').append(el);
                //El setTimeout es para esperar hasta que se complete la animación del modal para que detecte
                // a tiempo si ya esta abierto o no, para prevenir que habra doble.
                setTimeout(function () {
                    if ($("#vista-cliente-modal").hasClass('show')
                        || $('#agregar-encuesta-modal').hasClass('show')
                        || $('#vista-encuesta-modal').hasClass('show')) return false;
                    el.click();
                    el.remove();
                }, 500);
            }
        });

        $(document).on('click', '.vista_cotizacion_panel_ventas', function () {
            var id_cotizacion = $(this).parents('tr').attr('data-id-cotizacion');
            window.open('/cotizaciones/vista/' + id_cotizacion);
        });


        $(document).on('click', '.agregar_licencia', function () {
            if (!$('#fecha_compra_licencia .input-group.date').datepicker('getDate')) {
                iziToast.error({
                    title: 'Error',
                    message: 'Ingresa la fecha de compra.'
                });
                return false;
            }

            if ($.trim($('.producto_licencia').val()) == '') {
                iziToast.error({
                    title: 'Error',
                    message: 'Ingresa el producto.'
                });
                return false;
            }


            if ($.trim($('.serie_licencia').val()) == '') {
                iziToast.error({
                    title: 'Error',
                    message: 'Ingresa la serie de la licencia.'
                });
                return false;
            }

            var btn = $(this);
            btn.partnersBtnControl('start');
            var id_cliente = $(this).attr('data-id-cliente');
            var datos = {};
            datos.fecha_compra = $('#fecha_compra_licencia .input-group.date').datepicker('getDate');
            datos.producto = $('.producto_licencia').val();
            datos.serie_licencia = $('.serie_licencia').val();
            datos.observaciones_licencia = $('.text_observaciones_licencia').val();
            datos.id_cliente = id_cliente;

            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'agregar_nueva_licencia',
                data: JSON.stringify(datos),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        $('#panel-ventas-cliente .modal-body').html(loader);

                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        vista_panel_ventas(id_cliente);
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });

        $(document).on('click', '.eliminar_licencia', function () {
            var id_licencia = $(this).parents('tr').attr('data-id-licencia');
            var id_cliente = $(this).parents('tr').attr('data-id-cliente');
            var datos = {};
            datos.id_licencia = id_licencia;
            datos.id_cliente = id_cliente;
            swal({
                title: "Estás Seguro?",
                html: "Deseas eliminar la licencia de este cliente?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, eliminar!",
                cancelButtonText: "No!",
                showLoaderOnConfirm: true,
                onOpen: function () {
                    fixBootstrapModal();
                },
                preConfirm: function () {
                    return new Promise(function (resolve) {
                        $.ajax({
                            type: 'POST',
                            url: settings.clientes.ruta_capturar + 'eliminar_licencia',
                            data: JSON.stringify(datos),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                if (response.status == 'success') {
                                    $('#panel-ventas-cliente .modal-body').html(loader);
                                    resolve();

                                    vista_panel_ventas(id_cliente);


                                } else if (response.status == 'error') {
                                    iziToast.error({
                                        title: "Error",
                                        message: response.message
                                    });
                                }
                            },
                            error: function (xhr) {
                                iziToast.error({
                                    title: "Ocurrio un error: ",
                                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                });
                            }
                        });
                    });
                },
                allowOutsideClick: false
            }).then(function (a) {
                if (!a.dismiss) {
                    swal.close();
                    autoUpdate.forceUpdate();
                    iziToast.success({
                        title: 'Bien!',
                        message: 'Licencia eliminada correctamente.'
                    });
                }
            });

        });


        $(document).on('click', '.observaciones_licencia', function () {
            var id_licencia = $(this).parents('tr').attr('data-id-licencia');
            var id_cliente = $(this).parents('tr').attr('data-id-cliente');
            $(this).partnersObs(
                {
                    modalId: 'modal-panel-ventas-licencia-observaciones',
                    ajaxUrl: settings.clientes.ruta_sys_tools + 'load_obs',
                    index: 'id_licencia',
                    id_index: id_licencia,
                    tabla: 'partners_clientes_licencias',
                    col: 'observaciones',
                    ajaxSuccessCallback: function () {
                        vista_panel_ventas(id_cliente);
                    }
                }
            );

        });


        /**
         * Genera la vista del modal del panel de ventas de un cliente
         * @param id_cliente
         */
        function vista_panel_ventas(id_cliente) {
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'vista_panel_ventas',
                data: JSON.stringify(id_cliente),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        setTimeout(function () {
                            $('#panel-ventas-cliente .modal-body').html(response.message);
                            $('#panel-ventas-cliente').attr('data-id-cliente', id_cliente);
                            setTimeout(function () {
                                $('#fecha_compra_licencia .input-group.date').datepicker({
                                    format: "dd/mm/yyyy",
                                    todayBtn: "linked",
                                    language: "es",
                                    daysOfWeekDisabled: "0",
                                    autoclose: true,
                                    todayHighlight: true,
                                    orientation: "auto",
                                    container: ".input-group.date"
                                });

                                $.fn.editable.defaults.mode = 'inline';
                                $.fn.editable.defaults.emptytext = "Vacío";
                                $.fn.editable.defaults.url = ruta_url;
                                $.fn.editable.defaults.send = "always";
                                $.fn.editable.defaults.disabled = false;
                                $.fn.editable.defaults.ajaxOptions = {
                                    type: 'POST',
                                    contentType: "application/json; charset=utf-8",
                                    dataType: "json"
                                };
                                $.fn.editable.defaults.success = function (response) {
                                    if (response.status == 'success') {
                                        iziToast.success({
                                            title: "Bien! ",
                                            message: response.message
                                        });
                                        autoUpdate.forceUpdate();
                                    } else if (response.status == 'error') {
                                        iziToast.error({
                                            title: "Error",
                                            message: response.message
                                        });
                                    }
                                };
                                $.fn.editable.defaults.params = function params(params, el) {
                                    var element = $(el);
                                    var p = {};
                                    p.edit_table = element.data('edit-table');
                                    p.edit_col = element.data('edit-column');
                                    p.edit_table_key = element.data('edit-table-key');
                                    p.edit_id = element.data('edit-id');
                                    p.new_val = params.value;
                                    return p;
                                };

                                // Destroy All
                                $('.editable-textarea-field').editable('destroy');

                                // Textarea Field
                                $('.editable-textarea-field').editable({
                                    type: 'textarea',
                                    rows: 5
                                });

                            }, 100);

                            // Ahora consultar y mostrar las renovaciones y cotizaciones de un cliente.
                            mostrarCotizacionesRenovacionesCliente(id_cliente);
                        }, 400);
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        }

        /**
         * Función para consultar y mostrar de una manera paginada todas las renovaciones y cotizaciones
         * de un cliente.
         * @param id_cliente
         */
        const language = {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        };

        function mostrarCotizacionesRenovacionesCliente(id_cliente) {
            $.fn.dataTable.moment( 'DD/MM/YY' );
            $('#table_reporteador_cotizaciones_cliente').DataTable({
                language: language,
                order: [[ 1, "desc" ]]
            });
            $('#table_reporteador_renovaciones').DataTable({
                language: language,
                order: [[ 0, "desc" ]]
            });
        }

//***************************************************************
//---------------------- AREA VENTAS CLIENTE --------------------
//***************************************************************

// ***************************************************************
//------------------ MARCAR CONTACTO FACTURACIÓN ----------------
//***************************************************************
        $(document).on('click', '.marcar_contacto_facturacion', function () {
            var datos = {};
            datos.idContacto = $(this).attr('data-id-contacto');
            datos.statusFacturacion = $(this).attr('data-status') == 1 ? 0 : 1;
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'update_status_facturacion_contacto',
                data: JSON.stringify(datos),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });
// ***************************************************************
//------------------ MARCAR CONTACTO FACTURACIÓN ----------------
//***************************************************************

//***************************************************************
//----------------------- MARCAR ESCUESTA -----------------------
//***************************************************************
        $(document).on('click', '.cambiar_status_encuesta', function(){
            var newVal = $(this).attr('data-encuesta') == 1 ? 0 : 1;
            var idCliente = $(this).parents('tr').attr('data-id');
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'update_status_encuesta',
                data: JSON.stringify({newVal, idCliente}),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        iziToast.success({
                            title: "Bien! ",
                            message: response.message
                        });
                        reporte_base();
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });
//***************************************************************
//----------------------- MARCAR ESCUESTA -----------------------
//***************************************************************


//***************************************************************
//---------------------- SOLICITAR ELIMINAR  --------------------
//***************************************************************
        $(document).on('click', '.solicitar_cancelar_cliente', function () {
            var id_cliente = $(this).attr('data-id-cliente');
            var nombre_cliente = $(this).attr('data-nombre-cliente');
            var tipo_cliente = $(this).attr('data-tipo-cliente');

            swal({
                title: "Estás Seguro?",
                html: "Deseas solicitar la eliminación de <span class='font-italic' style='font-weight: bold;'>" + nombre_cliente + "</span> ? ",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, solicitar!",
                cancelButtonText: "No!",
                showLoaderOnConfirm: true,
                onOpen: function () {
                    fixBootstrapModal();
                },
                preConfirm: function () {
                    return new Promise(function (resolve) {
                        $.ajax({
                            type: 'POST',
                            url: settings.clientes.ruta_capturar + 'solicitar_cancel_client',
                            data: id_cliente,
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            success: function (response) {
                                if (response.status == 'success') {
                                    autoUpdate.forceUpdate();
                                    $('.modal').each(function () {
                                        $(this).modal('hide');
                                    });
                                    resolve()
                                } else if (response.status == 'error') {
                                    iziToast.error({
                                        title: "Error",
                                        message: response.message
                                    });
                                }
                            },
                            error: function (xhr) {
                                iziToast.error({
                                    title: "Ocurrio un error: ",
                                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                                });
                            }
                        });
                    });
                },
                allowOutsideClick: false
            }).then(function (a) {
                if (!a.dismiss) {
                    swal("Cancelado!", "Se ha solicitado la eliminación del cliente.", "success");
                }
            });
        });

        $(document).on('click', '.cancelar_solicitud_cancelacion_cliente', function(){
            var id_cliente = $(this).attr('data-id-cliente');
            $.ajax({
                type: 'POST',
                url: settings.clientes.ruta_capturar + 'cancelar_solicitud_cancel_client',
                data: id_cliente,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        autoUpdate.forceUpdate();
                        $('.modal').each(function () {
                            $(this).modal('hide');
                        });
                        iziToast.success({
                            title: "Bien!",
                            message: response.message
                        });
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });
//***************************************************************
//---------------------- SOLICITAR ELIMINAR  --------------------
//***************************************************************

        // Elimina todos los elementos para que al momento de usar el maps no se multipliquen
        // Elimiar los elementos que se crean varias veces para evitar que se multipliquen
        $(document).on('hidden.bs.modal', '.modal', function () {
            if ($('.modal.show').length > 0) {
                $('body').addClass('modal-open');
            }

            $('#coordenadas').each(function () {
                $(this).remove();
            });
            $('.multiple_phone_container').each(function () {
                $(this).remove();
            });

            $('.multiple_email_container').each(function () {
                $(this).remove();
            });

            $('.multiple_cel_container').each(function () {
                $(this).remove();
            });
        });

    });
})
(jQuery);

