(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';
      const SPINNER = '<div class="spinner-border text-success" role="status"><span class="sr-only">Loading...</span></div>';
    const FINALIZADO_SUCCESS = '<i class="fas fa-check-circle fa-2x"></i>';
    const FINALIZADO_DANGER = '<i class="fas fa-circle fa-2x"></i>';

//***************************************************************
//---------------- REPORTE BASE PROYECTOS CCTV ------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 600,
      iddle_after: 120,
    });

    // Reporte base Options
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'id_proyecto'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }
    };


    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_cctv').stickyTableHeaders();
          $('#table_reporteador_cctv').partnersfilter({
            table: '#table_reporteador_mercancia',
            sumatory: true,
            sumatory_cols: ["col-total", "col-costo", "col-utilidad"]
          });
          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '#reset_filters', function () {
      r_options.filter.search_bar = null;
      $('.input_buscador_cctv').val('');
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
    });

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_cctv', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_cctv").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }

//***************************************************************
//---------------- REPORTE BASE PROYECTOS CCTV ------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
    var start = moment().startOf('month');
    var end = moment().endOf('month');

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************


//***************************************************************
//------------------------- VISTA PROYECTO CCTV -----------------
//***************************************************************
    $(document).on('click', '.vista_proyecto', function () {
      var id_proyecto;
      if ($(this).attr('live-generated') == 1) {
        id_proyecto = $(this).attr('data-id-proyecto');
      } else {
        id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      }
      $(this).partnersModal({
        title: 'Proyecto CCTV ' + id_proyecto,
        modalId: 'vista-proyecto-modal',
        forceWidth: 90,
        content: loader
      });

      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'vista_proyecto',
        data: id_proyecto,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#vista-proyecto-modal .modal-body').html(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------- VISTA PROYECTO CCTV -----------------
//***************************************************************

//***************************************************************
//-------------------------- STATUS PAGADO ----------------------
//***************************************************************
    $(document).on('click', '.status_facturado', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var template = '<div class="row">' +
        '<div class="col-md"><button type="button" class="btn btn-outline-warning proyecto_no_pagado w-100" data-id-proyecto="' + id_proyecto + '" role="button">No</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-success proyecto_pagado w-100" data-id-proyecto="' + id_proyecto + '" role="button">Pagado</button></div>' +
        '<div class="col-md"><button type="button" class="btn btn-outline-info proyecto_facturado w-100" data-id-proyecto="' + id_proyecto + '" role="button">Facturado</button></div>' +
        '</div>';


      $(this).partnersModal({
        content: template,
        title: 'Selecciona',
        forceWidth: 25,
        modalId: 'modal-pagado-cctv',
        noFooter: true
      });
    });

    $(document).on('click', '.proyecto_no_pagado', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var clicked_td = $('tr[data-id-proyecto="' + id_proyecto + '"] .status_facturado');
      $('#modal-pagado-cctv .modal-body').html(loader);
      var envio = {};
      envio.new_val = 0;
      envio.id_proyecto = id_proyecto;
      envio.col = 'pagado';
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            $('#modal-pagado-cctv').modal('hide');
            clicked_td.removeClass('status-green');
            clicked_td.addClass('status-red');
            clicked_td.html('No');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.proyecto_pagado', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var clicked_td = $('tr[data-id-proyecto="' + id_proyecto + '"] .status_facturado');
      $('#modal-pagado-cctv .modal-body').html(loader);
      var envio = {};
      envio.new_val = 1;
      envio.id_proyecto = id_proyecto;
      envio.col = 'pagado';
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            $('#modal-pagado-cctv').modal('hide');
            clicked_td.removeClass('status-red');
            clicked_td.addClass('status-green');
            clicked_td.html('Pagado');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('click', '.proyecto_facturado', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      var clicked_td = $('tr[data-id-proyecto="' + id_proyecto + '"] .status_facturado');
      $('#modal-pagado-cctv').modal('hide');

      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.new_val = 2;
      envio.col = 'pagado';
      swal({
        title: 'Número de factura',
        input: 'text',
        showCancelButton: true,
        confirmButtonText: 'Guardar',
        cancelButtonColor: '#DD6B55',
        cancelButtonText: 'Cancelar',
        confirmButtonClass: 'btn btn-success',
        cancelButtonClass: 'btn btn-danger',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          return new Promise(function (resolve, reject) {
            if (!reason) {
              reject('Debes ingresar un número de factura!');
            } else {
              envio.obs = 'Se marcó como como facturado con el número de factura: ' + reason;
              envio.facturado = 1;
              envio.numero_factura = reason;
              envio = JSON.stringify(envio);
              $.ajax({
                type: 'POST',
                url: settings.cctv.ruta_consultas + 'update_status',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            }
          })
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          clicked_td.addClass('status-green');
          clicked_td.html('Factura');
          iziToast.success({
            title: "Bien! ",
            message: "Cambios guardados",
            timeout: 1000,
            position: 'bottomLeft'
          });
          autoUpdate.forceUpdate();
        }
      });

    });
//***************************************************************
//-------------------------- STATUS PAGADO ----------------------
//***************************************************************


//***************************************************************
//------------------------- STATUS INSTALADO --------------------
//***************************************************************
    $(document).on('click', '.status_instalado', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      var instalado = ($(this).parents('tr').attr('data-instalado') == 1) ? 0 : 1;
      var envio = {};
      envio.id_proyecto = id_proyecto;
      envio.new_val = instalado;
      envio.col = 'instalado';
      envio = JSON.stringify(envio);
      if (instalado == 1) {
        $(this).removeClass('status-red');
        $(this).addClass('status-green');
        $(this).html('Si');
      } else {
        $(this).removeClass('status-green');
        $(this).addClass('status-red');
        $(this).html('No');
      }

      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'update_status',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//------------------------- STATUS INSTALADO --------------------
//***************************************************************


//***************************************************************
//------------------------- STATUS COSTO ------------------------
//***************************************************************
    $(document).on('click', '.status_costo', function () {
      $(this).partnersModal({
        title: 'Modificar Costos',
        modalSize: 'modal-lg',
        modalId: 'modificacion-costos-modal',
        content: loader
      });

      var envio = {};
      envio.id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      envio.type = 1;
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'modificacion_costos',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#modificacion-costos-modal .modal-body').html(response.message);
            setTimeout(function () {
              $.validate({
                form: '#form_modificacion_piezas',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid'
              })
            }, 100);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });


    $(document).on('submit', '#form_modificacion_piezas', function (e) {
      var datos = [];
      var envio = {};
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');

      $('.entity_pieza_modificacion').each(function () {
        datos.push({
          id_pieza: $(this).attr('data-id-pieza'),
          new_costo: $(this).find('.modificacion_costo_value').val()
        });
      });

      envio.type = 2;
      envio.datos = datos;
      envio.id_proyecto = $(this).attr('data-id-proyecto');
      envio = JSON.stringify(envio);

      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'modificacion_costos',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message,
              timeout: 1000,
              position: 'bottomLeft'
            });
            autoUpdate.forceUpdate();
            $('#modificacion-costos-modal').modal('hide');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------- STATUS COSTO ------------------------
//***************************************************************


//***************************************************************
//------------------------ CCTV OBSERVACIONES -------------------
//***************************************************************
    $(document).on('click', '.status_obs', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      $(this).partnersObs(
        {
          modalId: 'modal-cctv-observaciones',
          ajaxUrl: settings.cctv.ruta_sys_tools + 'load_obs',
          index: 'id_proyecto',
          id_index: id_proyecto,
          tabla: 'partners_cctv',
          col: 'observaciones',
          ajaxSuccessCallback: function () {
            autoUpdate.forceUpdate();
          }
        }
      );
    });
//***************************************************************
//------------------------ CCTV OBSERVACIONES -------------------
//***************************************************************


//***************************************************************
//------------------------- ELIMINAR PROYECTO  ------------------
//***************************************************************
    $(document).on('click', '.eliminar_proyecto', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      swal({
        title: "Estás Seguro?",
        html: "Deseas eliminar el proyecto cctv: " + id_proyecto + "?",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: 'POST',
              url: settings.cctv.ruta_consultas + 'eliminar_proyecto',
              data: id_proyecto,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  autoUpdate.forceUpdate();
                  setTimeout(function () {
                    undo_proyecto_deleted(id_proyecto);
                    swal.close();
                  }, 2000);
                  resolve()
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function () {
        if (!a.dismiss) {
          swal("Eliminado!", "El proyecto CCTV se ha eliminado correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_proyecto_deleted(id_proyecto) {
      iziToast.show({
        title: 'Proyecto: ' + id_proyecto,
        message: ' ha sido eliminado.',
        position: 'bottomLeft',
        timeout: 10000,
        color: 'dark',
        progressBarColor: 'rgb(0, 255, 184)',
        icon: 'fa fa-ban',
        buttons: [
          ['<button data-id-proyecto="' + id_proyecto + '" class="proyecto_undo_delete">Deshacer</button>', function (instance, toast) {
            instance.hide({
              transitionOut: 'fadeOutUp',
            }, toast, 'close');
          }]
        ],
      });
    }

    $(document).on('click', '.proyecto_undo_delete', function () {
      var id_proyecto = $(this).attr('data-id-proyecto');
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'reactivate_proyecto',
        data: id_proyecto,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Proyecto ' + id_proyecto,
              message: ' ha sido traido de vuelta a la vida!',
              icon: 'fa fa-usd'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//------------------------- ELIMINAR PROYECTO  ------------------
//***************************************************************


//***************************************************************
//------------------------- EDITAR PROYECTO  --------------------
//***************************************************************
    $(document).on('click', '.editar_proyecto', function () {
      $('.editar_proyecto').hide();
      $('.cancelar_edicion_proyecto').show();
      $('.guardar_edicion_proyecto').show();
      $('.editable_fields_proyecto').show();
      $('.side-a-vista').removeClass('col-md-6').addClass('col-md-8');
      $('.side-b-vista').removeClass('col-md-6').addClass('col-md-4');
      $('.non-editable-table').hide();
      $('.editable-table').show();
    });
    $(document).on('click', '.cancelar_edicion_proyecto', function () {
      $('.editar_proyecto').show();
      $('.cancelar_edicion_proyecto').hide();
      $('.guardar_edicion_proyecto').hide();
      $('.editable_fields_proyecto').hide();
      $('.side-a-vista').removeClass('col-md-8').addClass('col-md-6');
      $('.side-b-vista').removeClass('col-md-4').addClass('col-md-6');
      $('.non-editable-table').show();
      $('.editable-table').hide();
    });
    $(document).on('click', '.eliminar_entity_proyecto', function () {
      $(this).parents('tr').remove();
      if (!$(this).parents('tr').attr('data-nuevo')) {
        var div = $('<div class="eliminated_tr" data-id-dato="' + $(this).parents("tr").attr("data-id-dato") + '"></div>');
        $('.deleted_entities_proyecto').append(div);
      }
      sumar_total_editar_proyecto();
    });

    function sumar_total_editar_proyecto() {
      var total = 0;
      $('.entity_proyecto_subtotal').each(function () {
        total += parseFloat($(this).attr('data-subtotal'));
      });
      $('.total_editable_table_proyecto').html(parseFloat(total).format(2));
    }

    $(document).on('click', '.agregar_entity_proyecto', function () {
      var cantidad = $('.cantidad_proyecto').val();
      var tipo = $('select[name="tipo_entity_proyecto"] option:selected').val();
      var descripcion = $('.descripcion_proyecto').val();
      var precio = $('.precio_proyecto').val();

      if ($.trim(cantidad).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una cantidad'
        });
        return false;
      }

      if (isNaN(cantidad)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa una cantidad correcta'
        });
        return false;
      }

      if (!tipo) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un tipo'
        });
        return false;
      }

      if ($.trim(descripcion).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega una descripción'
        });
        return false;
      }

      if ($.trim(precio).length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'Agrega un precio'
        });
        return false;
      }

      if (isNaN(precio)) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un precio correcto'
        });
        return false;
      }


      var tipo_text = (tipo == 1) ? "Pieza" : "Servicio";
      var tr = $('<tr class="entity_proyecto" data-nuevo="1">' +
        '<td class="entity_tipo_proyecto" data-tipo="' + tipo + '">' + tipo_text + '</td>' +
        '<td class="entity_cantidad_proyecto">' + cantidad + '</td>' +
        '<td class="entity_descripcion_proyecto" style="word-break: break-all;">' + descripcion + '</td>' +
        '<td class="text-right entity_proyecto_precio" data-precio="' + precio + '">' + parseFloat(precio).format(2) + '</td>' +
        '<td class="text-right entity_proyecto_subtotal" data-subtotal="' + (precio * cantidad) + '">' + (precio * cantidad).format(2) + '</td>' +
        '<td class="eliminar_entity_proyecto text-center text-danger cursor-pointer">Eliminar</td>' +
        '</tr>');
      $('.editable-table tbody').append(tr);
      sumar_total_editar_proyecto();
      $('.cantidad_proyecto').val('');
      $('.descripcion_proyecto').val('');
      $('.precio_proyecto').val('');
      $('.cantidad_proyecto').focus();
    });

    $(document).on('click', '.guardar_edicion_proyecto', function () {
      var datosEnvio = {};
      datosEnvio.datos = [];

      if ($('.entity_proyecto').length < 1) {
        iziToast.error({
          title: 'Error',
          message: 'El proyecto debe de tener al menos una pieza o servicio.'
        });
        return false;
      }
      $('.entity_proyecto').each(function () {
        if ($(this).attr('data-nuevo') == 1) {
          datosEnvio.datos.push({
            cantidad: $(this).find('.entity_cantidad_proyecto').text(),
            descripcion: $(this).find('.entity_descripcion_proyecto').text(),
            precio: $(this).find('.entity_proyecto_precio').attr('data-precio'),
            tipo: $(this).find('.entity_tipo_proyecto').attr('data-tipo'),
          });
        }
      });

      datosEnvio.eliminados = [];
      $('.deleted_entities_proyecto .eliminated_tr').each(function () {
        datosEnvio.eliminados.push($(this).attr('data-id-dato'));
      });
      var id_proyecto = $(this).attr('data-id-proyecto');
      datosEnvio.id_proyecto = id_proyecto;

      var envio = JSON.stringify(datosEnvio);
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'editar_proyecto',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
            $('#vista-proyecto-modal').modal('hide');
            var a = $('<a>').attr('data-id-proyecto', id_proyecto).addClass('vista_proyecto').attr('live-generated', 1);
            setTimeout(function () {
              a.insertAfter('body');
              a.click();
              a.remove();
            }, 600);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });

//***************************************************************
//------------------------- EDITAR PROYECTO  --------------------
//***************************************************************


//***************************************************************
//------------------ PROYECTOS CCTV INFORM ERRORS ---------------
//***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
//***************************************************************
//------------------ PROYECTOS CCTV INFORM ERRORS ---------------
//***************************************************************


//***************************************************************
//------------------------- CCTV VER FACTURA  -------------------
//***************************************************************
    $(document).on('click', '.ver_factura', function () {
      var id_factura = $(this).text();
      $(this).partnersModal({
        title: 'Factura ' + id_factura,
        modalId: 'vista-factura',
        forceWidth: 90,
        content: loader
      });
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_sys_tools + 'get_full_factura',
        data: JSON.stringify(id_factura),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            if (response.message == "not_on_server") {
              var content = "<div class='row'><div class='col-md-12'><h6 class='lead text-danger'>No se encontró la factura en el servidor.</h6></div></div>";
            } else {
              var content = '<div>' +
                '<iframe src="/system/tools/vista_factura?factura=' + response.message + '" width="100%;" height="600px;"></iframe>' +
                '</div>';
            }
            $('#vista-factura .modal-body').html(content);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------- CCTV VER FACTURA  -------------------
//***************************************************************


//***************************************************************
//--------------------- CCTV CREAR GOOGLE SHEET  ----------------
//***************************************************************
    $(document).on('click', '.status_crear_sheet', function () {
      var id_proyecto = $(this).parents('tr').attr('data-id-proyecto');
      console.log(id_proyecto);

      swal({
        title: "Proyecto " + id_proyecto,
        html: "Deseas crear una hoja de cálculo relacionada a este proyecto?",
        type: "question",
        showCancelButton: true,
        confirmButtonColor: "#5cb85c",
        cancelButtonColor: "#d9534f",
        confirmButtonText: "Si, crear!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: 'POST',
              url: settings.cctv.ruta_consultas + 'crear_google_sheet',
              data: JSON.stringify(id_proyecto),
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  resolve(response);
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        console.log(a);
        if (!a.dismiss) {
          autoUpdate.forceUpdate();

          // Mostrar swal con link a la hoja de cálculo creada
          if (a.value.status == "success") {
            swal({
              title: 'Bien!',
              text: "Se creó la hoja de cálculo",
              type: 'success',
              showCancelButton: false,
              confirmButtonColor: '#3085d6',
              confirmButtonText: 'Ir a la hoja'
            }).then((result) => {
              if (result) {
                swal.close();
                window.open(a.value.message);
              }
            })
          }
        }
      });

    });
//***************************************************************
//--------------------- CCTV CREAR GOOGLE SHEET  ----------------
//***************************************************************


    $(document).on('click', '.sincronizar_google_sheet', function () {
      var datos = {};
      datos.idProyecto = $(this).parents('tr').attr('data-id-proyecto');
      datos.sheetId = $(this).parents('tr').attr('data-sheet-id');

      swal({
        title: 'Sincronizando Proyecto ' + datos.idProyecto,
        onOpen: function () {
          swal.showLoading();
        }
      });

      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'sincronizar_google_sheet',
        data: JSON.stringify(datos),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            swal.close();
            window.open(response.message);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    let MODAL_A = new Modal("", 80, () => {});
    let timeout = null;

    /**
     * Agregar mercancia
     */
    $(document).on('click', '.add-merch', (e) => {
      const ID = e.currentTarget.closest("tr").getAttribute("data-id-proyecto");
      //MODAL_A = new Modal("Salida de mercancia", 80, () => {});
      MODAL_A.showNoDelete();
      getModalForm(ID);
    });

    $(document).on('click', '.add-cost', async (e) => {
      const TYPE = e.currentTarget.getAttribute("cost-type");
      const ID = e.currentTarget.getAttribute("project-id");
      // console.log(TYPE);
      let datos = {};
      if(TYPE == 1) {
        datos = {
          id: ID,
          type: TYPE,
          upc: document.getElementById('UPCInput').value,
          producto: document.getElementById('ProductoInput').value,
          serie: document.getElementById('SerieInput').value,
          costo: document.getElementById('CostoInput').value,
          venta: document.getElementById('VentaInput').value,
        }
      } else {
        datos = {
          id: ID,
          type: TYPE,
          concepto: document.getElementById('ConceptoInput').value,
          costo: document.getElementById('ExtraCostoInput').value
        }
      }
      MODAL_A.loadingBody();
      await $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'addMerc',
        data: JSON.stringify(datos),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
      getModalForm(ID);
    });

    const getModalForm = (id) => {
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'salida_merc_form',
        data: JSON.stringify({
          id: id
        }),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: (response) => {
          if (response.status == 'success') {
            MODAL_A.updateBody(response.message);
            /**
             * timer para entrada de UPC
             */
            if(document.getElementById('UPCInput')){
              document.getElementById('UPCInput').addEventListener("keyup", () => {
                clearTimeout(timeout);
                timeout = setTimeout(() => {
                  $.ajax({
                    type: 'POST',
                    url: settings.cctv.ruta_sys_tools + 'load_producto_info_mercancia',
                    data: JSON.stringify({
                      type: 1,
                      val: document.getElementById('UPCInput').value
                    }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                      if (response.status == 'success') {
                        document.getElementById('ProductoInput').value = response.message;
                        document.getElementById('SerieInput').focus();
                      } else if (response.status == 'error') {
                        iziToast.error({
                          title: "Error",
                          message: response.message,
                          timeout: 2000
                        });
                      }
                    },
                    error: function (xhr) {
                      iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                      });
                    }
                  });
                }, 200);
              });
            }
            /**
             * timer para entrada de Serie
             */
            if(document.getElementById('SerieInput')){
              document.getElementById('SerieInput').addEventListener("keyup", () => {
                clearTimeout(timeout);
                timeout = setTimeout(() => {
                  $.ajax({
                    type: 'POST',
                    url: settings.cctv.ruta_sys_tools + 'load_producto_info_mercancia',
                    data: JSON.stringify({
                      type: 2,
                      val: document.getElementById('SerieInput').value
                    }),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                      if (response.status == 'success') {
                        document.getElementById('CostoInput').value = response.message;
                        document.getElementById('VentaInput').focus();
                      } else if (response.status == 'error') {
                        iziToast.error({
                          title: "Error",
                          message: response.message,
                          timeout: 2000
                        });
                      }
                    },
                    error: function (xhr) {
                      iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                      });
                    }
                  });
                }, 200);
              });
            }
            if(document.getElementById('UPCInput')){
              const fto = setTimeout(() => {
                document.getElementById('UPCInput').focus();
                clearInterval(fto);
              }, 500);
            }
          } else {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: () => {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    $(document).on('click', '.delete-merc-field', (e) => {
      const ID_P = e.currentTarget.closest("tr").getAttribute('field-id');
      const PROYECTO = e.currentTarget.closest("tr").getAttribute('id-proyecto');
      swal({
        title: 'Motivo de eliminación',
        input: 'textarea',
        showCancelButton: true,
        confirmButtonText: 'Eliminar',
        cancelButtonText: 'Regresar',
        confirmButtonClass: 'btn btn-danger',
        cancelButtonClass: 'btn btn-primary',
        animation: false,
        customClass: 'animated fadeInDownCustom',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
          restoreBootstrapModal();
        },
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function (reason) {
          if ($.trim(reason).length == 0) {
            swal.showValidationError("Ingresa un motivo!");
          } else {
            return new Promise(function (resolve) {
              const data = {
                motivo: reason,
                idProducto: ID_P,
              }
              $.ajax({
                type: 'POST',
                url: settings.cctv.ruta_consultas + 'deleteMerc',
                data: JSON.stringify(data),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                  if (response.status == 'success') {
                    autoUpdate.forceUpdate();
                    MODAL_A.loadingBody();
                    getModalForm(PROYECTO);
                    resolve();
                  } else if (response.status == 'error') {
                    iziToast.error({
                      title: "Error",
                      message: response.message
                    });
                  }
                },
                error: function (xhr) {
                  iziToast.error({
                    title: "Ocurrio un error: ",
                    message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                  });
                }
              });
            });
          }
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal.close();
        }
      });
    });

    $(document).on('click', '.finalizado-btn', (e) => {
      const ELEMENT = e.currentTarget;
      const STATUS = +ELEMENT.getAttribute('status');
      const ID = e.currentTarget.closest('tr').getAttribute('data-id-proyecto');
      ELEMENT.classList.remove('finalizado-btn');
      ELEMENT.innerHTML = SPINNER;
      if(!!STATUS) {
        ELEMENT.classList.remove('text-success');
      } else {
        ELEMENT.classList.remove('text-danger');
      }
      const data = {
        id: ID,
        status: STATUS
      };
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'marcar_finalizado',
        data: JSON.stringify(data),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: (response) => {
          if (response.status == 'success') {
            if(response.message){
              ELEMENT.classList.add('text-success');
              ELEMENT.innerHTML = FINALIZADO_SUCCESS;
              ELEMENT.setAttribute('status', '1');
            } else {
              ELEMENT.classList.add('text-danger');
              ELEMENT.innerHTML = FINALIZADO_DANGER;
              ELEMENT.setAttribute('status', '0');
            }
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: (xhr) => {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        },
        complete: () => {
          ELEMENT.classList.add('finalizado-btn');
        }
      });
    });

    /**
     * Nuevo proyecto
     */

    let products = [];

    $(document).on('click', '#nuevoProyecto', () => {
      products = [];
      const MODAL = new Modal('Nuevo proyecto', 80, () => {});
      MODAL.show();
      $.ajax({
        type: 'POST',
        url: settings.cctv.ruta_consultas + 'nuevo_form',
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: (response) => {
          if (response.status == 'success') {
            MODAL.updateBody(response.message);
            $('#buscar_cliente').typeahead({
              order: 'asc',
              minlength: 1,
              maxItem: 15,
              hint: true,
              accent: true,
              group: {
                template: '{{group}}',
              },
              maxItemPerGroup: 5,
              backdrop: {
                'background-color': '#fff',
              },
              template(query, item) {
                let color_t_clasificacion;
                let tipo_clasificacion = item.tipo_clasificacion;
                switch (tipo_clasificacion) {
                  case 'a':
                    color_t_clasificacion = 'success';
                    break;
                  case 'b':
                    color_t_clasificacion = 'success';
                    break;
                  case 'c':
                    color_t_clasificacion = 'warning';
                    break;
                  case 'd':
                    color_t_clasificacion = 'danger';
                    break;
                  case 'e':
                    color_t_clasificacion = 'danger';
                    break;
                }
                tipo_clasificacion = tipo_clasificacion.toUpperCase();

                const credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';

                if (item.tipo_cliente != 3) {
                  return `${'<p>'
                      + '<span>{{nombre_cliente}}</span> '
                      + '<span class="float-right badge badge-'}${color_t_clasificacion}">`
                      + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                      } | ${credito_contado}</span> </p> `;
                }
                return '<p><span>{{nombre_cliente}}</span> </p> ';
              },
              dynamic: true,
              dropdownFilter: 'Todos',
              emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
              source: {
                Clientes: {
                  display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                  ajax: {
                    url: `${settings.cctv.ruta_lista_clientes}complete`,
                    path: 'data.datos.clientes',
                  },
                },
                Contactos: {
                  display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                  ajax: {
                    url: `${settings.cctv.ruta_lista_clientes}complete`,
                    path: 'data.datos.contactos',
                  },
                },
                Proveedores: {
                  display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
                  ajax: {
                    url: `${settings.cctv.ruta_lista_clientes}complete`,
                    path: 'data.datos.proveedores',
                  },
                },
              },
              callback: {
                onClickAfter(node, a, item) {
                  let color_t_clasificacion;
                  let tipo_clasificacion = item.tipo_clasificacion;
                  switch (tipo_clasificacion) {
                    case 'a':
                      color_t_clasificacion = 'success';
                      break;
                    case 'b':
                      color_t_clasificacion = 'success';
                      break;
                    case 'c':
                      color_t_clasificacion = 'warning';
                      break;
                    case 'd':
                      color_t_clasificacion = 'danger';
                      break;
                    case 'e':
                      color_t_clasificacion = 'danger';
                      break;
                  }
                  tipo_clasificacion = tipo_clasificacion.toUpperCase();
                  const credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                  if (item.tipo_cliente != 3) {
                    $('.quick_info_client').html(`<span class="badge badge-${color_t_clasificacion}">`
                        + `<i class="fa fa-star" aria-hidden="true"></i>: ${tipo_clasificacion
                        } | ${credito_contado}</span> </p> `);
                    const id_cliente = item.id_cliente;
                    prepareEvs(1, {
                      color_t_clasificacion,
                      tipo_clasificacion,
                      credito_contado,
                      id_cliente,
                      settings,
                    });
                  }
                  // Bindear el id del cliente al input
                  node.attr('data-id-cliente', item.id_cliente);
                  node.attr('data-email-cliente', item.email);

                  // Generar lista contactos solo para clientes Negocio/Distribuidor
                  if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                    generar_contactos(settings.cctv.ruta_lista_contactos, item.id_cliente);

                    // Solamente agrega este attr cuando debe de tener contactos
                    node.attr('data-tipo-negocio', item.tipo_negocio);
                  } else {
                    $('.contacto_container').hide();
                    $('.select_lista_contactos').empty();
                  }
                },
                onSearch(node, a) {
                  if (a !== '') {
                  } else {
                    // Para prevenir errores de sobrescribir o duplicar
                    $('.contacto_container').hide();
                    $('.select_lista_contactos').empty();
                    $('.quick_info_client').html('');
                    node.removeAttr('data-id-cliente');
                    node.removeAttr('data-tipo-negocio');
                    node.removeAttr('data-email-cliente');
                  }
                },
              },
            });

            $.validate({
              form: '#nueva_cotizacion_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid',
            });
            const CAN_I = document.getElementById("cantidadInput");
            const TIP_I = document.getElementById("tipoInput");
            const DES_I = document.getElementById("descripcionInput");
            const PRE_I = document.getElementById("precioInput");
            document.getElementById("addProduct").addEventListener("click", () => {
              if(Number.isNaN(+CAN_I.value)) {
                iziToast.error({
                  title: "Error",
                  message: "Debe ingresar un valor válido para cantidad"
                });
              } else if(TIP_I.value == "") {
                iziToast.error({
                  title: "Error",
                  message: "Debe ingresar un valor válido para tipo"
                });
              } else if(DES_I.value.trim() == "") {
                iziToast.error({
                  title: "Error",
                  message: "Debe ingresar un valor válido para descripción"
                });
              } else if(Number.isNaN(+PRE_I.value)){
                iziToast.error({
                  title: "Error",
                  message: "Debe ingresar un valor válido para precio"
                });
              } else {
                let unique = false;
                do{
                  const random = Math.floor(Math.random() * 100000) + 1;
                  if(products.find(el => el.id == random) == undefined) {
                    unique = true;
                    products.push({
                      id: random,
                      cantidad: +CAN_I.value,
                      tipo: TIP_I.value,
                      descripcion: DES_I.value,
                      precio: +PRE_I.value
                    });
                    updateNuevoTable(document.getElementById("nuevoProyectoList"));
                    CAN_I.value = "";
                    TIP_I.value = "";
                    DES_I.value = "";
                    PRE_I.value = "";
                  }
                } while(!unique);
              }
            });
            document.getElementById("guardarProyecto").addEventListener("click", () => {
              if(products.length <= 0) {
                iziToast.error({
                  title: "Error",
                  message: "No se han agregado piezas o servicios"
                });
              } else if(document.getElementById("buscar_cliente").getAttribute("data-id-cliente") && document.getElementById("buscar_cliente").getAttribute("data-id-cliente") != "") {
                let cont = null;
                if(Array.from(document.getElementsByClassName("select_lista_contactos")).length > 0) {
                  cont = Array.from(document.getElementsByClassName("select_lista_contactos"))[0].value;
                }
                const data = {
                  idContacto: cont,
                  idCliente: document.getElementById("buscar_cliente").getAttribute("data-id-cliente"),
                  products: products,
                };
                $.ajax({
                  type: 'POST',
                  url: settings.cctv.ruta_consultas + 'nuevo_proyecto',
                  data: JSON.stringify(data),
                  contentType: "application/json; charset=utf-8",
                  dataType: "json",
                  success: (response) => {
                    if (response.status == 'success') {
                      iziToast.success({
                        title: "Bien",
                        message: response.message
                      });
                      autoUpdate.forceUpdate();
                      MODAL.hide();
                    } else if (response.status == 'error') {
                      iziToast.error({
                        title: "Error",
                        message: response.message
                      });
                    }
                  },
                  error: (xhr) => {
                    iziToast.error({
                      title: "Ocurrio un error: ",
                      message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                  }
                });
              } else {
                iziToast.error({
                  title: "Error",
                  message: "No se ha seleccionado a un cliente"
                });
              }
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: (xhr) => {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    const updateNuevoTable = (tbody) => {
      let temp = "";
      tbody.innerHTML = "";
      const formatter = new Intl.NumberFormat('es-US', {
        style: 'currency',
        currency: 'USD',
      });
      products.forEach(row => {
        const total = row.cantidad * row.precio;
        const tipo = (row.tipo == 1)?'Pieza':'Servicio';
        temp += `<tr product-id="${row.id}">`;
        temp += `<td>${tipo}</td>`;
        temp += `<td>${row.cantidad}</td>`;
        temp += `<td class="text-justify">${row.descripcion}</td>`;
        temp += `<td class="text-right font-weight-bold">${formatter.format(row.precio)}</td>`;
        temp += `<td class="text-right font-weight-bold">${formatter.format(total)}</td>`;
        temp += `<td><button class="btn btn-sm btn-outline-danger border-0 w-100 delete-product-list"><i class="fas fa-trash-alt"></i></button></td>`;
        temp += "</tr>";
      });
      if(products.length > 0) {
        let suma = 0;
        products.forEach(row => suma += (row.precio * row.cantidad));
        temp += "<tr>";
        temp += "<td colspan='4' class='text-right font-weight-bold'>Total:</td>";
        temp += `<td class='text-right font-weight-bold'>${formatter.format(suma)}</td>`;
        temp += "</tr>";
      }
      tbody.innerHTML = temp;
      Array.from(document.getElementsByClassName("delete-product-list")).forEach(el => el.addEventListener("click", (e) => {
        const ID = e.currentTarget.closest("tr").getAttribute("product-id");
        products.splice(products.findIndex(row => row.id == ID), 1);
        updateNuevoTable(document.getElementById("nuevoProyectoList"));
      }));
    }

     /**
      *  ---------------
      */

  });
})
(jQuery);