//import * as $ from 'jquery';
//import 'bootstrap';

const $ = jQuery;

/**
 *Clase para crear modals
 *
 * @export
 * @class Modal
 */
class Modal {
    /**
     *Creates an instance of Modal.
     * @param {string} title
     * @param {number} size
     * @param {() => void} [onHide=() => {}]
     * @memberof Modal
     */
    constructor(title, size, onHide = () => {
    }) {
        /**
         *Loader al cargar datos
         *
         * @private
         * @memberof Modal
         */
        this.BIG_LOADER = '<div class="sk-cube-grid"> ' +
        '<div class="sk-cube sk-cube1"></div> ' +
        '<div class="sk-cube sk-cube2"></div> ' +
        '<div class="sk-cube sk-cube3"></div> ' +
        '<div class="sk-cube sk-cube4"></div> ' +
        '<div class="sk-cube sk-cube5"></div> ' +
        '<div class="sk-cube sk-cube6"></div> ' +
        '<div class="sk-cube sk-cube7"></div> ' +
        '<div class="sk-cube sk-cube8"></div> ' +
        '<div class="sk-cube sk-cube9"></div> </div>';
        /**
         * Estruxtura principal del modal
         *
         * @private
         * @memberof Modal
         */
        this.structure = `<div class="modal fade" id="modalId" tabindex="-1" role="dialog" aria-labelledby="modalViewIdLabel" aria-hidden="true"><div class="modal-dialog round" id="modalDialogId" role="document" style="max-width: 100%;"><div class="modal-content round main"><span class="mr-2"><button type="button" id="closeModal" class="close float-right hide-on-mobile" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button></span><div class="modal-body"><h5 class="modal-title d-none text-center" id="modalViewIdLabel"><label id="modalTitleId">Vista</label></h5><hr class="d-none"><div id="modalBodyId"></div><div class="mt-2"><button class="btn btn-danger w-100 hide-on-desktop" data-dismiss="modal" aria-label="Close">Cerrar</button></div></div></div></div></div>`;
        /**
         *Destruir modal
         *
         * @private
         * @memberof Modal
         */
        this.deleteModal = () => {
            this.modal.parentNode.removeChild(this.modal);
        };
        this.title = title;
        this.size = size;
        this.onHide = onHide;
        this.modalId = Modal.randomId();
        this.modalViewIdLabel = Modal.randomId();
        this.modalDialogId = Modal.randomId();
        this.modalTitleId = Modal.randomId();
        this.modalBodyId = Modal.randomId();
        this.modal = Modal.htmlToElement("<div></div>");
        this.createModal();
    }
    /**
     *Crear el mdoal
     *
     * @private
     * @memberof Modal
     */
    createModal() {
        let newTemplate = this.structure.replace("modalId", this.modalId);
        newTemplate = newTemplate.replace("modalViewIdLabel", this.modalViewIdLabel);
        newTemplate = newTemplate.replace("modalDialogId", this.modalDialogId);
        newTemplate = newTemplate.replace("modalTitleId", this.modalTitleId);
        newTemplate = newTemplate.replace("modalBodyId", this.modalBodyId);
        this.modal = Modal.htmlToElement(newTemplate);
        document.body.appendChild(this.modal);
    }
    /**
     * Convertir un string a un elemento de HTML
     *
     * @private
     * @param {string} html
     * @returns {HTMLElement}
     * @memberof Modal
     */
    static htmlToElement(html) {
        const template = document.createElement('template');
        html = html.trim();
        template.innerHTML = html;
        return template.content.firstChild;
    }
    /**
     *Establecer el título
     *
     * @private
     * @memberof Modal
     */
    setTitle() {
        document.getElementById(this.modalTitleId).innerHTML = this.title;
    }
    /**
     *Establecer el tamaño
     *
     * @private
     * @memberof Modal
     */
    setSize() {
        document.getElementById(this.modalDialogId).style.width = `${this.size}%`;
    }
    /**
     *Actualizar el body
     *
     * @param {string} content
     * @memberof Modal
     */
    updateBody(content) {
        document.getElementById(this.modalBodyId).innerHTML = content;
    }
    /**
     *Colocar un loader en el body
     *
     * @memberof Modal
     */
    loadingBody() {
        this.updateBody(this.BIG_LOADER);
    }
    /**
     *Mostrar modal
     *
     * @memberof Modal
     */
    show(loader = true) {
        this.setTitle();
        this.setSize();
        if (loader)
            this.loadingBody();
        //@ts-ignore
        $(this.modal).modal("show");
        $(this.modal).on("hidden.bs.modal", () => {
            setTimeout(() => {
                this.modal.setAttribute("style", "display: none !important;");
                this.deleteModal();
                //Verificamos si hay algún modal abierto para mantener la clase `modal-open`
                if (document.getElementsByClassName("modal").length > 0) {
                    $('body').addClass('modal-open');
                }
                //.
                this.onHide();
            }, 200);
        });
        return this;
    }
    /**
     *Mostrar sin eliminar al esconder
     *
     * @memberof Modal
     */
    showNoDelete(loader = true) {
        this.setTitle();
        this.setSize();
        if (loader)
            this.loadingBody();
            $(this.modal).on("hidden.bs.modal", () => {
                setTimeout(() => {
                    this.modal.setAttribute("style", "display: none !important;");
                    //Verificamos si hay algún modal abierto para mantener la clase `modal-open`
                    if (document.getElementsByClassName("modal").length > 0) {
                        $('body').addClass('modal-open');
                    }
                    //.
                    this.onHide();
                }, 200);
            });
        //@ts-ignore
        $(this.modal).modal("show");
    }
    /**
     *Esconder modal
     *
     * @memberof Modal
     */
    hide() {
        //@ts-ignore
        $(this.modal).modal("hide");
    }
    /**
     *Generar un id aleatoria
     *
     * @private
     * @returns {string}
     * @memberof Modal
     */
    static randomId() {
        return "_" + Math.floor(Math.random() * 1000000) + 1;
    }
    /**
     *Conseguir el id del modal
     *
     * @returns {string}
     * @memberof Modal
     */
    getId() {
        return this.modalId;
    }
}