(function ($) {
  var settings = Drupal.settings;

  $(document).ready(function () {
      var loader = '<div class="sk-cube-grid"> ' +
        '<div class="sk-cube sk-cube1"></div> ' +
        '<div class="sk-cube sk-cube2"></div> ' +
        '<div class="sk-cube sk-cube3"></div> ' +
        '<div class="sk-cube sk-cube4"></div> ' +
        '<div class="sk-cube sk-cube5"></div> ' +
        '<div class="sk-cube sk-cube6"></div> ' +
        '<div class="sk-cube sk-cube7"></div> ' +
        '<div class="sk-cube sk-cube8"></div> ' +
        '<div class="sk-cube sk-cube9"></div> </div>';

//***************************************************************
//------------------- REPORTE BASE COTIZACIONES -----------------
//***************************************************************
      // Auto Update
      var autoUpdate = new AutoUpdate({
        toUpdate: function () {
          reporte_base();
        },
        interval: 600,
        iddle_after: 120,
      });

      // Reporte base Options
      var r_options = {
        pagination: {
          page: 1
        },
        sort: {
          order: 'DESC',
          sort_by: 'id_registro'
        },
        automatic_update: 1,
        updating: 0,
        filter: {
          search_bar: null,
          usuario: null,
          start_date: null,
          end_date: null
        }
      };


      function reporte_base() {
        if (r_options.automatic_update !== 1) {
          $('#reporteador').find('.table').css('opacity', 0.5);
        }
        $.ajax({
          type: 'POST',
          url: settings.capacitacion.ruta_consultas + 'reporte_base',
          data: JSON.stringify(r_options),
          contentType: "application/json; charset=utf-8",
          success: function (data) {
            $('#reporteador').html(data);
            $('#table_reporteador_capacitacion').stickyTableHeaders();
            $('#table_reporteador_capacitacion').partnersfilter();

            //Reset Defaults
            r_options.automatic_update = 1;
            r_options.updating = 0;
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }

//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************
      var start = moment().startOf('month');
      var end = moment().endOf('month');

      function cb(start, end) {
        $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
      }

      cb(start, end);
      $('#reportrange').daterangepicker({
        autoApply: true,
        linkedCalendars: false,
        parentEl: ".parent-calendar",
        locale: {
          "format": "DD/MM/YYYY",
          "separator": " - ",
          "applyLabel": "Aplicar",
          "cancelLabel": "Cancelar",
          "fromLabel": "Desde",
          "toLabel": "Hasta",
          "customRangeLabel": "Personalizado",
          "weekLabel": "S",
          "daysOfWeek": [
            "Do",
            "Lu",
            "Ma",
            "Mi",
            "Ju",
            "Vi",
            "Sa"
          ],
          "monthNames": [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre"
          ],
          "firstDay": 1
        },
        startDate: start,
        endDate: end,
        showDropdowns: true,
        ranges: {
          'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
          'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
          'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
          'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
          'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
          'Hoy': [moment(), moment()],
          'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
          'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
          'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
          'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
          'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
          'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
          'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
          'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
          'Año Actual': [moment().startOf('year'), moment().endOf('year')],
          'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
          'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
        }
      }, cb);


      $('#reportrange').on('apply.daterangepicker', function () {
        var fecha = $('#reportrange').find('span').text();
        var fecha_array = fecha.split("-");
        r_options.filter.start_date = fecha_array[0];
        r_options.filter.end_date = fecha_array[1];
        autoUpdate.forceUpdate();
        $('#reporteador').find('.table').css('opacity', 0.5);
      });

      (function () {
        var fecha = $('#reportrange').find('span').text();
        var fecha_array = fecha.split("-");
        r_options.filter.start_date = fecha_array[0];
        r_options.filter.end_date = fecha_array[1];
        autoUpdate.forceUpdate();
        $('#reporteador').find('.table').css('opacity', 0.5);
      })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************

//***************************************************************
//----------------------- NUEVA COTIZACION  ---------------------
//***************************************************************
      $(document).on('click', '.nueva_cotizacion', function (e) {
        e.preventDefault();
        $(this).partnersModal({
          title: 'Nueva Cotización',
          forceWidth: 95,
          modalId: 'nueva-cotizacion-modal',
          content: loader
        });

        $.ajax({
          type: 'POST',
          url: settings.capacitacion.ruta_consultas + 'nueva_cotizacion',
          data: JSON.stringify(1),
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              $('#nueva-cotizacion-modal .modal-body').html(response.message);
              setTimeout(function () {
                $('#buscar_cliente').typeahead({
                  order: "asc",
                  minlength: 1,
                  maxItem: 15,
                  hint: true,
                  accent: true,
                  group: {
                    template: "{{group}}"
                  },
                  maxItemPerGroup: 5,
                  backdrop: {
                    "background-color": "#fff"
                  },
                  template: function (query, item) {
                    var color_t_clasificacion;
                    var tipo_clasificacion = item.tipo_clasificacion;
                    switch (tipo_clasificacion) {
                      case 'a':
                        color_t_clasificacion = "success";
                        break;
                      case 'b':
                        color_t_clasificacion = "success";
                        break;
                      case 'c':
                        color_t_clasificacion = "warning";
                        break;
                      case 'd':
                        color_t_clasificacion = "danger";
                        break;
                      case 'e':
                        color_t_clasificacion = "danger";
                        break;
                    }
                    tipo_clasificacion = tipo_clasificacion.toUpperCase();

                    var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';

                    if (item.tipo_cliente != 3) {
                      return '<p>' +
                        '<span>{{nombre_cliente}}</span> ' +
                        '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
                        '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                        ' | ' + credito_contado + '</span> </p> ';
                    } else {
                      return '<p><span>{{nombre_cliente}}</span> </p> ';
                    }
                  },
                  dynamic: true,
                  dropdownFilter: "Todos",
                  emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
                  source: {
                    "Clientes": {
                      display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                      ajax: {
                        url: settings.capacitacion.ruta_lista_clientes + 'complete',
                        path: "data.datos.clientes"
                      }
                    },
                    "Contactos": {
                      display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                      ajax: {
                        url: settings.capacitacion.ruta_lista_clientes + 'complete',
                        path: "data.datos.contactos"
                      }
                    },
                    "Proveedores": {
                      display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                      ajax: {
                        url: settings.capacitacion.ruta_lista_clientes + 'complete',
                        path: "data.datos.proveedores"
                      }
                    }
                  },
                  callback: {
                    onClickAfter: function (node, a, item) {
                      var color_t_clasificacion;
                      var tipo_clasificacion = item.tipo_clasificacion;
                      switch (tipo_clasificacion) {
                        case 'a':
                          color_t_clasificacion = "success";
                          break;
                        case 'b':
                          color_t_clasificacion = "success";
                          break;
                        case 'c':
                          color_t_clasificacion = "warning";
                          break;
                        case 'd':
                          color_t_clasificacion = "danger";
                          break;
                        case 'e':
                          color_t_clasificacion = "danger";
                          break;
                      }
                      tipo_clasificacion = tipo_clasificacion.toUpperCase();
                      var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                      if (item.tipo_cliente != 3) {
                        $('.quick_info_client').html('<span class="badge badge-' + color_t_clasificacion + '">' +
                          '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                          ' | ' + credito_contado + '</span> </p> ');
                      }

                      //Bindear el id del cliente al input
                      node.attr('data-id-cliente', item.id_cliente);
                      node.attr('data-email-cliente', item.email);

                      // Generar lista contactos solo para clientes Negocio/Distribuidor
                      if (item.tipo_negocio == 1 || item.tipo_negocio == 3) {
                        generar_contactos(settings.cotizaciones.ruta_lista_contactos, item.id_cliente);

                        //Solamente agrega este attr cuando debe de tener contactos
                        node.attr('data-tipo-negocio', item.tipo_negocio);
                      } else {
                        $('.contacto_container').hide();
                        $('.select_lista_contactos').empty();
                      }
                    },
                    onSearch: function (node, a) {
                      if (a !== '') {
                      } else {
                        // Para prevenir errores de sobrescribir o duplicar
                        $('.contacto_container').hide();
                        $('.select_lista_contactos').empty();
                        $('.quick_info_client').html('');
                        node.removeAttr('data-id-cliente');
                        node.removeAttr('data-tipo-negocio');
                        node.removeAttr('data-email-cliente');
                      }


                    }

                  }
                });

                $.validate({
                  form: '#nueva_cotizacion_form',
                  errorMessageClass: 'invalid-feedback',
                  inputParentClassOnError: 'text-danger',
                  inputParentClassOnSuccess: 'text-success',
                  errorElementClass: 'is-invalid'
                });
              }, 400);

            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });


      });
//***************************************************************
//----------------------- NUEVA COTIZACION  ---------------------
//***************************************************************

    }
  );
})
(jQuery);