(function ($) {
  settings = Drupal.settings;
  $(document).ready(function () {

    var loader = '<div class="sk-cube-grid"> ' +
      '<div class="sk-cube sk-cube1"></div> ' +
      '<div class="sk-cube sk-cube2"></div> ' +
      '<div class="sk-cube sk-cube3"></div> ' +
      '<div class="sk-cube sk-cube4"></div> ' +
      '<div class="sk-cube sk-cube5"></div> ' +
      '<div class="sk-cube sk-cube6"></div> ' +
      '<div class="sk-cube sk-cube7"></div> ' +
      '<div class="sk-cube sk-cube8"></div> ' +
      '<div class="sk-cube sk-cube9"></div> </div>';
//***************************************************************
//--------------------- REPORTE BASE CAJA  ----------------------
//***************************************************************
    // Auto Update
    var autoUpdate = new AutoUpdate({
      toUpdate: function () {
        reporte_base();
      },
      interval: 60,
      iddle_after: 120,
    });

    // Reporte base Options
    /**
     *
     * @type {{
     * pagination: {
     *      page: number
     * },
     * sort: {
     *      order: string,
     *      sort_by: string //Tiene que ser el nombre de la columna de la tabla
     * },
     * automatic_update: number,
     * updating: number
     * }}
     */
    var r_options = {
      pagination: {
        page: 1
      },
      sort: {
        order: 'ASC',
        sort_by: 'id_movimiento'
      },
      automatic_update: 1,
      updating: 0,
      filter: {
        search_bar: null,
        start_date: null,
        end_date: null
      }

    };

    function reporte_base() {
      if (r_options.automatic_update !== 1) {
        $('#reporteador').find('.table').css('opacity', 0.5);
      }
      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'reporte_base',
        data: JSON.stringify(r_options),
        contentType: "application/json; charset=utf-8",
        success: function (data) {
          $('#reporteador').html(data);
          $('#table_reporteador_caja').stickyTableHeaders();

          //Reset Defaults
          r_options.automatic_update = 1;
          r_options.updating = 0;
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

    // Filtrado - Texto
    $(document).on('keyup', '.input_buscador_caja', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        search(true);
      else
        $(this).data('timer', setTimeout(search, 200));
    });

    function search() {
      var StringtoSearch = $(".input_buscador_caja").val();
      $('#reporteador').find('.table tbody').css('opacity', 0.5);
      r_options.filter.search_bar = StringtoSearch;
      autoUpdate.forceUpdate();
    }


//***************************************************************
//--------------------- REPORTE BASE CAJA  ----------------------
//***************************************************************


//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************

    var start = moment();
    var end = moment();

    function cb(start, end) {
      $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
    }

    cb(start, end);
    $('#reportrange').daterangepicker({
      autoApply: true,
      linkedCalendars: false,
      parentEl: ".parent-calendar",
      locale: {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aplicar",
        "cancelLabel": "Cancelar",
        "fromLabel": "Desde",
        "toLabel": "Hasta",
        "customRangeLabel": "Personalizado",
        "weekLabel": "S",
        "daysOfWeek": [
          "Do",
          "Lu",
          "Ma",
          "Mi",
          "Ju",
          "Vi",
          "Sa"
        ],
        "monthNames": [
          "Enero",
          "Febrero",
          "Marzo",
          "Abril",
          "Mayo",
          "Junio",
          "Julio",
          "Agosto",
          "Septiembre",
          "Octubre",
          "Noviembre",
          "Diciembre"
        ],
        "firstDay": 1
      },
      startDate: start,
      endDate: end,
      showDropdowns: true,
      ranges: {
        'Enero': [moment().month('January').startOf('month'), moment().month('January').endOf('month')],
        'Julio': [moment().month('July').startOf('month'), moment().month('July').endOf('month')],
        'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
        'Febrero': [moment().month('February').startOf('month'), moment().month('February').endOf('month')],
        'Agosto': [moment().month('August').startOf('month'), moment().month('August').endOf('month')],
        'Hoy': [moment(), moment()],
        'Marzo': [moment().month('March').startOf('month'), moment().month('March').endOf('month')],
        'Septiembre': [moment().month('September').startOf('month'), moment().month('September').endOf('month')],
        'Semana Actual': [moment().startOf('week'), moment().endOf('week')],
        'Abril': [moment().month('April').startOf('month'), moment().month('April').endOf('month')],
        'Octubre': [moment().month('October').startOf('month'), moment().month('October').endOf('month')],
        'Mes Actual': [moment().startOf('month'), moment().endOf('month')],
        'Mayo': [moment().month('May').startOf('month'), moment().month('May').endOf('month')],
        'Noviembre': [moment().month('November').startOf('month'), moment().month('November').endOf('month')],
        'Año Actual': [moment().startOf('year'), moment().endOf('year')],
        'Junio': [moment().month('June').startOf('month'), moment().month('June').endOf('month')],
        'Diciembre': [moment().month('December').startOf('month'), moment().month('December').endOf('month')]
      }
    }, cb);


    $('#reportrange').on('apply.daterangepicker', function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    });

    (function () {
      var fecha = $('#reportrange').find('span').text();
      var fecha_array = fecha.split("-");
      r_options.filter.start_date = fecha_array[0];
      r_options.filter.end_date = fecha_array[1];
      autoUpdate.forceUpdate();
      $('#reporteador').find('.table').css('opacity', 0.5);
    })();
//***************************************************************
//------------------------ DATE PICKER --------------------------
//***************************************************************

//***************************************************************
//------------------------- NUEVA ENTRADA -----------------------
//***************************************************************
    $(document).on('click', '.nueva_entrada', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Entrada',
        ajaxUrl: settings.caja.render_template + 'caja.entrada',
        modalId: 'entrada-dinero-modal',
        noFooter: true,
        forceWidth: 60,
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nueva_entrada_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });
            $('.concepto_entrada').focus();
          }, 400);
        }
      });
    });
    $(document).on('submit', '#nueva_entrada_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#nueva_entrada_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      datosEnvio.type = 1;
      datosEnvio.cantidad_entrada = numeral($('.cantidad_entrada').val()).value();
      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'new_reigstro',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#entrada-dinero-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------- NUEVA ENTRADA -----------------------
//***************************************************************


//***************************************************************
//------------------------- NUEVA SALIDA ------------------------
//***************************************************************
    $(document).on('click', '.nueva_salida', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Salida',
        ajaxUrl: settings.caja.render_template + 'caja.salida',
        modalId: 'salida-dinero-modal',
        noFooter: true,
        forceWidth: 60,
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nueva_salida_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });
            $('.concepto_salida').focus();
          }, 400);
        }
      });
    });
    $(document).on('submit', '#nueva_salida_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#nueva_salida_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      datosEnvio.type = 2;
      datosEnvio.cantidad_salida = numeral($('.cantidad_salida').val()).value();
      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'new_reigstro',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#salida-dinero-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------- NUEVA SALIDA ------------------------
//***************************************************************


//***************************************************************
//--------------------------- CORTE CAJA  -----------------------
//***************************************************************
    $(document).on('click', '.nueva_corte_caja', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Corte Caja',
        ajaxUrl: settings.caja.render_template + 'caja.corte',
        modalId: 'corte-caja-modal',
        noFooter: true,
        forceWidth: 33,
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nuevo_corte_caja_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });
            $('.cantidad_corte_caja').focus();
          }, 400);
        }
      });
    });

    $(document).on('submit', '#nuevo_corte_caja_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#nuevo_corte_caja_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      datosEnvio.type = 3;
      datosEnvio.cantidad_corte_caja = numeral($('.cantidad_corte_caja').val()).value();
      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'new_reigstro',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#corte-caja-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message,
              timeout: 10000
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//--------------------------- CORTE CAJA  -----------------------
//***************************************************************


//***************************************************************
//------------------------- AUTORIZAR SALIDA  -------------------
//***************************************************************
    $(document).on('click', '.autorizar_salida_caja', function () {
      if ($('input.autenticar_supervisor').length > 0) {
        return false;
      }
      var movimiento_id = $(this).parents('tr').attr('data-id');
      iziToast.show({
        title: 'Ingresa tu NIP',
        icon: 'fa fa-user',
        position: 'center',
        progressBarColor: 'rgb(0, 255, 184)',
        message: '<input class="form-control autenticar_supervisor" data-id="' + movimiento_id + '" type="password" autocomplete="new-password" style="background: #565c70; color: #fff; border:2px solid #fff; margin-top:7px;"/>',
        color: 'dark',
        drag: false,
        layout: 2,
        timeout: 60000,
        resetOnHover: true,
        onOpen: function () {
          setTimeout(function () {
            $('.autenticar_supervisor').focus();
          }, 400);
        }
      });
    });

    $(document).on('keyup', '.autenticar_supervisor', function (e) {
      clearTimeout($.data(this, 'timer'));
      if (e.keyCode == 13)
        autenticar_supervisor(true);
      else
        $(this).data('timer', setTimeout(autenticar_supervisor, 500));
    });

    function autenticar_supervisor() {
      $('.autenticar_supervisor').css('background', '#7a7e8e');
      $('.autenticar_supervisor').attr('disabled', true);

      var movimiento_id = $('.autenticar_supervisor').attr('data-id');
      var user_nip = $(".autenticar_supervisor").val();
      var envio = {};
      envio.id_movimiento = movimiento_id;
      envio.user_nip = user_nip;
      envio = JSON.stringify(envio);
      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'autorizar_salida',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.destroy();
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
            $('.autenticar_supervisor').css('background', '#565c70');
            $('.autenticar_supervisor').removeAttr('disabled');
            $('.autenticar_supervisor').focus();
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    }

    $(document).on('mouseenter', '.vista_user_autorizado', function () {
      $(this).html($(this).attr('data-autorizado-por'));
    });

    $(document).on('mouseleave', '.vista_user_autorizado', function () {
      $(this).html('Si');
    });

//***************************************************************
//------------------------- AUTORIZAR SALIDA  -------------------
//***************************************************************

//***************************************************************
//------------------------- EDITAR MOVIMIENTO -------------------
//***************************************************************
    $(document).on('click', '.editar_movimiento', function (e) {
      e.preventDefault();
      var id_movimiento = $(this).parents('tr').attr('data-id');
      var envio = {};
      envio.id_movimiento = id_movimiento;
      envio.type = 1;
      $(this).partnersModal({
        title: 'Editar Movimiento',
        content: loader,
        modalId: 'editar-movimiento-modal',
        forceWidth: 60,
        noFooter: true
      });
      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'editar_movimiento',
        data: JSON.stringify(envio),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#editar-movimiento-modal .modal-body').html(response.message);
            setTimeout(function () {
              $.validate({
                form: '#edicion_movimiento_form',
                errorMessageClass: 'invalid-feedback',
                inputParentClassOnError: 'text-danger',
                inputParentClassOnSuccess: 'text-success',
                errorElementClass: 'is-invalid'
              });
            }, 400);
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

    $(document).on('submit', '#edicion_movimiento_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#edicion_movimiento_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }
      datosEnvio.type_movimiento = $(this).attr('data-type');
      datosEnvio.id_movimiento = $(this).attr('data-id');
      datosEnvio.type = 2;
      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'editar_movimiento',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            autoUpdate.forceUpdate();
            $('#editar-movimiento-modal').modal('hide');
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//------------------------- EDITAR MOVIMIENTO -------------------
//***************************************************************


//***************************************************************
//------------------------- ELIMINAR MOVIMIENTO -----------------
//***************************************************************
    $(document).on('click', '.eliminar_movimiento', function () {
      var id_movimiento = $(this).parents('tr').attr('data-id');
      var desc_movimiento = $(this).parents('tr').attr('data-desc-mov');
      swal({
        title: "Estás Seguro?",
        html: "Deseas eliminar este movimiento: " + desc_movimiento,
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#DD6B55",
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            $.ajax({
              type: 'POST',
              url: settings.caja.ruta_consultas + 'eliminar_movimiento',
              data: id_movimiento,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  autoUpdate.forceUpdate();
                  setTimeout(function () {
                    undo_movimiento_deleted(id_movimiento, desc_movimiento);
                    swal.close();
                  }, 2000);
                  resolve()
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (!a.dismiss) {
          swal("Eliminado!", "El movimiento se ha eliminado correctamente.", "success");
          autoUpdate.forceUpdate();
        }
      });
    });

    function undo_movimiento_deleted(id_movimiento, mov_desc) {
      iziToast.show({
        title: 'Movimiento:  ',
        message: mov_desc + ' ha sido eliminado.',
        position: 'bottomLeft',
        timeout: 10000,
        color: 'dark',
        progressBarColor: 'rgb(0, 255, 184)',
        icon: 'fa fa-ban',
        buttons: [
          ['<button data-id-movimiento="' + id_movimiento + '" data-desc-mov="' + mov_desc + '" class="movimiento_undo_delete">Deshacer</button>', function (instance, toast) {
            instance.hide({
              transitionOut: 'fadeOutUp',
            }, toast, 'close');
          }]
        ],
      });
    }

    $(document).on('click', '.movimiento_undo_delete', function () {
      var id_movimiento = $(this).attr('data-id-movimiento');
      var mov_desc = $(this).attr('data-desc-mov');
      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'reactivate_movimiento',
        data: id_movimiento,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: 'Movimiento: ',
              message: mov_desc + ' ha sido traido de vuelta a la vida!',
              icon: 'fa fa-usd'
            });
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });

    });
//***************************************************************
//------------------------- ELIMINAR MOVIMIENTO -----------------
//***************************************************************

//***************************************************************
//--------------------- SERVICIOS INFORM ERRORS -----------------
//***************************************************************
    $(document).on('click', '.inform_errors', function (e) {
      e.preventDefault();
      var error = {};
      error.err_msg = $(this).attr('data-error-msg');
      error.err_time = $(this).attr('data-error-time');
      error.err_loc = $(this).attr('data-error-location');
      error.err_user = $(this).attr('data-error-user');
      error.err_user_id = $(this).attr('data-error-user-id');

      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_sys_tools + 'report_error',
        data: JSON.stringify(error),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('.modal').each(function () {
              $(this).modal('hide');
            });
            iziToast.destroy();
            swal({
              title: "Se ha enviado el error!",
              type: "success",
              text: "Lamentamos lo que sucedio, tu caso será revisado lo más pronto posible.",
              timer: 4000,
              showConfirmButton: false
            });
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    });
//***************************************************************
//--------------------- SERVICIOS INFORM ERRORS -----------------
//***************************************************************



//***************************************************************
//--------------------- RETIRO A CAJA GRANDE  -------------------
//***************************************************************
    $(document).on('click', '.retiro_caja_grande', function (e) {
      e.preventDefault();
      $(this).partnersModal({
        title: 'Retiro a Caja Grande',
        ajaxUrl: settings.caja.render_template + 'caja.retiro',
        modalId: 'retiro-caja-grande-modal',
        noFooter: true,
        forceWidth: 33,
        ajaxSuccessCallback: function () {
          setTimeout(function () {
            $.validate({
              form: '#nuevo_retiro_caja_grande_form',
              errorMessageClass: 'invalid-feedback',
              inputParentClassOnError: 'text-danger',
              inputParentClassOnSuccess: 'text-success',
              errorElementClass: 'is-invalid'
            });
            $('.cantidad_retiro_caja').focus();
          }, 400);
        }
      });
    });

    $(document).on('submit', '#nuevo_retiro_caja_grande_form', function (e) {
      e.preventDefault();
      var btn = $(this).find('button[type="submit"]');
      btn.partnersBtnControl('start');
      var datos = $('#nuevo_retiro_caja_grande_form').serializeArray();
      var datosEnvio = {};
      for (var i = 0; i < datos.length; i++) {
        datosEnvio[datos[i]['name']] = datos[i]['value'];
      }

      datosEnvio.cantidad_retiro_caja = numeral($('.cantidad_retiro_caja').val()).value();
      var envio = JSON.stringify(datosEnvio);

      $.ajax({
        type: 'POST',
        url: settings.caja.ruta_consultas + 'retiro_caja_grande',
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            iziToast.success({
              title: "Bien! ",
              message: response.message
            });
            $('#retiro-caja-grande-modal').modal('hide');
            autoUpdate.forceUpdate();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message,
              timeout: 10000
            });
            btn.partnersBtnControl('end');
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });
//***************************************************************
//--------------------- RETIRO A CAJA GRANDE  -------------------
//***************************************************************

  });
})
(jQuery);