(function ($) {
  var settings = Drupal.settings;
  $(document).ready(function () {

//***************************************************************
//------------ CONSULTAR CATEGORIAS TIENDA  BOLETIN -------------
//***************************************************************
    // Global de las categorias seleccionadas.
    var categorias_boletin = [];

    var boletin_content = {};

    function getCategoriasTienda() {
      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_consultas + 'boletin_init_data',
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (data) {
          initBoletin(data.message);
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }


    function getGruposMailRelay() {
      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_consultas + 'boletin_get_grupos_mailrelay',
        data: JSON.stringify(1),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (data) {
          var options = '<option hidden selected>Selecciona</option>';
          _.each(data.message, function (v) {
            if (v.enable == 1) {
              options += '<option data-id="' + v.id + '" data-name="' + v.name + '">' + v.name + '</option>';
            }
          });

          $('.select_group_mailrelay').append(options);
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }


    // Se ejecuta para traer todas las categorias
    getCategoriasTienda();

    // Se ejecuta para cargar los grupos a ver a donde enviar el correo en mailrelay.
    getGruposMailRelay();


//***************************************************************
//------------ CONSULTAR CATEGORIAS TIENDA  BOLETIN -------------
//***************************************************************


//***************************************************************
//-------------- CONSTRUIR ARBOL CATEGORIAS BOLETIN -------------
//***************************************************************
    $(window).on('scroll', function () {
      var b = $(window).scrollTop();
      var d = $("#scroller-anchor").offset().top;
      var c = $(".iframe_container");
      if (b > d) {
        c.css({position: "fixed", top: "0px", width: '56%', height: '100vh'})
      } else {
        c.css({position: "relative", top: "", width: '100%', height: '100%'})
      }
    });


    function initBoletin(datosInit) {
      var data = JSON.parse(datosInit);
      var datos = data.tree;
      var tpl = '<ul>';
      _.each(datos, function (v, k) {
        tpl += `<li>
                    <input type="checkbox" 
                    style="margin-right:10px;" 
                    class="category_checkbox" 
                    data-tid="${v.tid}" 
                    data-name="${v.name}"
                    data-is-main-category="1">
                        <span>${v.name}</span>
                </li>`;
        if (v.children) {
          tpl += `<ul style="list-style:none; padding-left:15px;">`;
          _.each(v.children, function (j, h) {
            tpl += `<li>
                    <input type="checkbox" 
                        style="margin-right:10px;" 
                        class="category_checkbox" 
                        data-tid="${j.tid}" 
                        data-name="${j.name}">
                            <span>${j.name}</span>
                    </li>`;
          })
          tpl += `</ul>`;

        }
      });

      tpl += '</ul>';

      $('.container_tree_categorias').html(tpl);

      // Construir el typeahead de los productos.
      $.typeahead({
        input: '.buscador_producto',
        order: 'asc',
        display: ['name', 'price'],
        hint: true,
        accent: true,
        maxItem: 10,
        source: {
          data: data.list_products,
        },
        callback: {
          onClickAfter(node, a, item) {
            get_main_product_info(item.product_id);
          },
          onSearch(node, a) {
            if (a.trim() === '') {
              boletin_content.mainProduct = null;
              load_preview_boletin();
            }
          },
        },
        onCancel() {
          boletin_content.mainProduct = null;
          load_preview_boletin();
        },
      });

      // Una vez haya construido el arbol, mostrarlo y cargar la preview del boletin
      $('.loader_container_controles').hide();
      $('.container_crear_boletin').show();
      load_preview_boletin();
    }


    $(document).on('click', '.collapse_categorias_btn', function () {
      if ($('.collapse_categorias_ico').hasClass('fa-chevron-down')) {
        $('.collapse_categorias_ico').removeClass('fa-chevron-down');
        $('.collapse_categorias_ico').addClass('fa-chevron-up');
      } else {
        $('.collapse_categorias_ico').removeClass('fa-chevron-up');
        $('.collapse_categorias_ico').addClass('fa-chevron-down');
      }
    });

//***************************************************************
//-------------- CONSTRUIR ARBOL CATEGORIAS BOLETIN -------------
//***************************************************************


//***************************************************************
//-------------------- GET MAIN PRODUCT INFO --------------------
//***************************************************************
    function get_main_product_info(product_id) {
      $('.loader_container_preview').show();
      $('#iframe_boletin').hide();

      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_consultas + 'get_main_product_info',
        data: JSON.stringify(product_id),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            boletin_content.mainProduct = response.message;
            load_preview_boletin();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

//***************************************************************
//-------------------- GET MAIN PRODUCT INFO --------------------
//***************************************************************


//***************************************************************
//-------------------- CARGAR PREVIEW BOLETIN -------------------
//***************************************************************
    function load_preview_boletin() {

      $('.loader_container_preview').show();
      $('#iframe_boletin').hide();

      var data = _.clone(boletin_content);

      if (!data) {
        data = 1;
      }
      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_consultas + 'boletin_preview',
        data: JSON.stringify(data),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            var $iframe = $('#iframe_boletin');
            $iframe.contents().find("body").html(JSON.parse(response.message));

            // Mostrarlo
            $('.loader_container_preview').hide();
            $('#iframe_boletin').show();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

//***************************************************************
//-------------------- CARGAR PREVIEW BOLETIN -------------------
//***************************************************************


//***************************************************************
//------------------ CARGAR PRODUCTOS BOLETIN -------------------
//***************************************************************
    $(document).on('click', '.category_checkbox', function () {
      var tid = $(this).attr('data-tid');


      // Si es una categoria padre (posiblemente con hijos)
      // recorrer en busca de hijos y marcar los hijos tambien y meterlos al array de categorias
      if ($(this).attr('data-is-main-category') == 1) {

        if ($(this).is(':checked')) {
          // Agregarla al array de categorias.
          categorias_boletin.push(tid);

          // Buscar por hijos
          if ($(this).closest('li').next().is('ul')) {
            // Si tiene hijos, recorrerlos, marcarlos, y meterlos al array de categorias.
            $(this).closest('li').next().find('li').each(function (k, v) {
              var $input = $(v).find('input[type="checkbox"]');
              $input.prop('checked', true);
              categorias_boletin.push($input.attr('data-tid'));
            });
          }
        } else {
          var newFilteredArray = [];

          // copia todos menos el elemento padre, ya despues me encargo de quitar a los hijos tambien
          categorias_boletin.map(function (v) {
            if (v != tid) newFilteredArray.push(v);
          });

          // Buscar por hijos
          if ($(this).closest('li').next().is('ul')) {
            // Si tiene hijos, recorrerlos, desmarcarlos, y quitarlos del array de categorias
            $(this).closest('li').next().find('li').each(function (k, v) {
              var $input = $(v).find('input[type="checkbox"]');
              $input.prop('checked', false);
              var index = newFilteredArray.indexOf($input.attr('data-tid'));
              if (index > -1) {
                newFilteredArray.splice(index, 1);
              }
            });
          }

          categorias_boletin = newFilteredArray;
        }

      } else {
        if ($(this).is(':checked')) {
          // Agregarla al array de categorias.
          categorias_boletin.push(tid);
        } else {
          var newFilteredArray = [];
          categorias_boletin.map(function (v) {
            if (v != tid) newFilteredArray.push(v);
          });
          categorias_boletin = newFilteredArray;
        }
      }

      var uniqueArray = [];
      $.each(categorias_boletin, function (i, el) {
        if ($.inArray(el, uniqueArray) === -1) uniqueArray.push(el);
      });


      categorias_boletin = uniqueArray;

      getProductosData();
    });


    function getProductosData() {
      $('.loader_container_preview').show();
      $('#iframe_boletin').hide();

      var data = categorias_boletin;
      if (categorias_boletin.length == 0) {
        data = 1;
      }

      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_consultas + 'get_productos_data',
        data: JSON.stringify(data),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            console.log(response.message);
            boletin_content.products = JSON.parse(response.message);
            load_preview_boletin();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    }

//***************************************************************
//------------------ CARGAR PRODUCTOS BOLETIN -------------------
//***************************************************************

//***************************************************************
//----------------------- SUBIR IMAGENES ------------------------
//***************************************************************
    $(document).on('change', '#main_banner_file', function () {
        var file, img;
        if ((file = this.files[0])) {
          img = new Image();
          img.onload = function () {
            if (this.width != 600 && this.height != 480) {
              iziToast.error({
                title: 'Error',
                message: 'Selecciona una imagen de tamaño 600 x 480.'
              });
            } else {
              $('#form_main_banner_file').submit();
            }
          };
          img.onerror = function () {
            iziToast.error({
              title: 'Error',
              message: 'Selecciona una imagen de extensión valida ( .png, .jpg, .jpeg )'
            });
          };
          img.src = window.URL.createObjectURL(file);
        } else {
          iziToast.error({
            title: 'Error',
            message: 'No hay ninguna imagen para subir.'
          });
        }
      }
    );


    $(document).on('submit', '#form_main_banner_file', function (e) {
      e.preventDefault();
      var data = new FormData(this);

      $('.loader_container_preview').show();
      $('#iframe_boletin').hide();

      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_upload_imagenes + 1,
        data: data,
        contentType: false,
        cache: false,
        processData: false,
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            boletin_content.mainBannerImg = response.message;
            load_preview_boletin();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });


    $(document).on('change', '#secondary_banner_file', function () {
        var file, img;
        if ((file = this.files[0])) {
          img = new Image();
          img.onload = function () {
            if (this.width != 600 && this.height != 80) {
              iziToast.error({
                title: 'Error',
                message: 'Selecciona una imagen de tamaño 600 x 80.'
              });
            } else {
              $('#form_secondary_banner_file').submit();
            }
          };
          img.onerror = function () {
            iziToast.error({
              title: 'Error',
              message: 'Selecciona una imagen de extensión valida ( .png, .jpg, .jpeg )'
            });
          };
          img.src = window.URL.createObjectURL(file);
        } else {
          iziToast.error({
            title: 'Error',
            message: 'No hay ninguna imagen para subir.'
          });
        }
      }
    );


    $(document).on('submit', '#form_secondary_banner_file', function (e) {
      e.preventDefault();
      var data = new FormData(this);

      $('.loader_container_preview').show();
      $('#iframe_boletin').hide();

      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_upload_imagenes + 2,
        data: data,
        contentType: false,
        cache: false,
        processData: false,
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            boletin_content.secondaryBannerImg = response.message;
            load_preview_boletin();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });


    $(document).on('change', '#custom_contact_banner_file', function () {
        var file, img;
        if ((file = this.files[0])) {
          img = new Image();
          img.onload = function () {
            if (this.width != 600 && this.height != 300) {
              iziToast.error({
                title: 'Error',
                message: 'Selecciona una imagen de tamaño 600 x 300.'
              });
            } else {
              $('#custom_contact_banner_file').submit();
            }
          };
          img.onerror = function () {
            iziToast.error({
              title: 'Error',
              message: 'Selecciona una imagen de extensión valida ( .png, .jpg, .jpeg )'
            });
          };
          img.src = window.URL.createObjectURL(file);
        } else {
          iziToast.error({
            title: 'Error',
            message: 'No hay ninguna imagen para subir.'
          });
        }
      }
    );


    $(document).on('submit', '#form_custom_contact_banner_file', function (e) {
      e.preventDefault();
      var data = new FormData(this);

      $('.loader_container_preview').show();
      $('#iframe_boletin').hide();

      $.ajax({
        type: 'POST',
        url: settings.boletin.ruta_upload_imagenes + 3, // Custom Contact Banner
        data: data,
        contentType: false,
        cache: false,
        processData: false,
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            boletin_content.customContactBannerImg = response.message;
            load_preview_boletin();
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });
    });

//***************************************************************
//----------------------- SUBIR IMAGENES ------------------------
//***************************************************************

//***************************************************************
//--------------------- DESCARGAR BOLETIN HTML ------------------
//***************************************************************
    $(document).on('click', '.descargar_boletin_html', function () {
      var html_iframe = encodeURIComponent($('#iframe_boletin').contents().find("body").html());
      var download_html = 'data:text/html;charset=UTF-8,' + html_iframe;
      $(this).attr('href', download_html);
    });
//***************************************************************
//--------------------- DESCARGAR BOLETIN HTML ------------------
//***************************************************************


//***************************************************************
//------------------------- URL'S BANNERS -----------------------
//***************************************************************
    $(document).on('blur', '.main_banner_url', function () {
      if ($.trim($(this).val()) != '') {
        var url = $.trim($(this).val());
        if (/(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/.test(url)) {
          boletin_content.mainBannerUrl = url;
          load_preview_boletin();
        } else {
          iziToast.error({
            title: 'Error',
            message: 'Ingresa una URL correcta.'
          });
        }
      }
    });

    $(document).on('blur', '.secondary_banner_url', function () {
      if ($.trim($(this).val()) != '') {
        var url = $.trim($(this).val());
        if (/(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/.test(url)) {
          boletin_content.secondaryBannerUrl = url;
          load_preview_boletin();
        } else {
          iziToast.error({
            title: 'Error',
            message: 'Ingresa una URL correcta.'
          });
        }
      }
    });
//***************************************************************
//------------------------- URL'S BANNERS -----------------------
//***************************************************************

//***************************************************************
//----------------------- LEYENDA BOLETÍN -----------------------
//***************************************************************
    $(document).on('blur', '.leyenda_boletin', function () {
      var val = $.trim($(this).val());
      if (val != '') {
        boletin_content.leyendaBoletin = val.replace(/\n/g, "<br />");
        load_preview_boletin();
      }
    });
//***************************************************************
//----------------------- LEYENDA BOLETÍN -----------------------
//***************************************************************


//***************************************************************
//----------------------- ENVIAR  BOLETÍN -----------------------
//***************************************************************
    $(document).on('click', '.send_boletin', function () {
      var asuntoBoletin = $.trim($('.asunto_correo_boletin').val());
      var groupIDMailrelay = $('.select_group_mailrelay option:selected').attr('data-id');
      var groupNameMailrelay = $('.select_group_mailrelay option:selected').attr('data-name');
      var htmlIframe = $('#iframe_boletin').contents().find("body").html();


      if (!asuntoBoletin || asuntoBoletin == '') {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa un asutnto para el correo del boletín.'
        });
        return false;
      }

      if (!groupIDMailrelay) {
        iziToast.error({
          title: 'Error',
          message: 'Selecciona un grupo al cual enviar este boletín.'
        });
        return false;
      }

      var btn = $(this);
      btn.partnersBtnControl('start');

      var envio = {};
      envio.asuntoBoletin = asuntoBoletin;
      envio.grupoIDMailrelay = groupIDMailrelay;
      envio.htmlIframe = htmlIframe;

      console.log(htmlIframe);
      envio = JSON.stringify(envio);

      swal({
        title: 'Estas seguro?',
        html: "Se enviará este boletín al grupo <span style='font-weight: 700'>"
          + groupNameMailrelay + "</span> con el asunto: <span style='font-weight: 700'>"
          + asuntoBoletin + "</span>",
        type: 'question',
        showCancelButton: true,
        confirmButtonColor: '#1e7e34',
        cancelButtonColor: '#dc3545',
        confirmButtonText: 'Si enviar!',
        cancelButtonText: 'No, cancelar',
        showLoaderOnConfirm: true,
        reverseButtons: true,
        allowOutsideClick: false,
        onClose: function () {
          $('body').removeAttr('style');
        },
        preConfirm: function () {
          return new Promise(function (resolve, reject) {
            $.ajax({
              type: 'POST',
              url: settings.boletin.ruta_consultas + 'enviar_boletin',
              data: envio,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  resolve();
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                  reject();
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          })
        }
      }).then((result) => {
        if (!result.dismiss) {
          swal(
            'Bien!',
            'Se ha enviado el boletín correctamente.',
            'success'
          );
          setTimeout(function () {
            location.reload();
          }, 2000);
        } else {
          btn.partnersBtnControl('end');
        }
      })

    });
//***************************************************************
//----------------------- ENVIAR  BOLETÍN -----------------------
//***************************************************************


  });
})
(jQuery);