<?php
global $ruta_raiz, $ruta_lib;
$ruta_raiz = drupal_get_path('module', 'partners') . '/';
$ruta_lib = $ruta_raiz . 'lib/';
require_once(drupal_get_path('module', 'partners') . '/lib/classes/class.sys_tools.php');

/**
 * Variable de home con el usuario en el servidor actual
 */
//define('HOME_SERVER', (string)'c:/laragon/www/'); //local
//define('HOME_SERVER', (string)'/home/pcpartners/'); //pcpartners
define('HOME_SERVER', (string)'/home/partnersinterno/'); //pcpartners//***************************************************************
//-------------------- PARTNERS RENDER TEMPLATE  ----------------
//***************************************************************
/**
 * @param $type : php | js, en uno necesito return y en el otro echo
 * @param $dir : la url del archivo carpeta.archivo
 * @param null $data : data para renderizar en el template
 * @return string|void
 */
function render_template($type, $dir, $data = null)
{
  $dwoo = new Dwoo_Core();
  $dir = str_replace('.', '/', $dir);
  $root_dir = drupal_get_path('module', 'partners') . '/lib/templates/';

  if ($data != null) {
    $data = array("datos" => $data);
    if ($type == 'php') {
      return $dwoo->get($root_dir . $dir . '.tpl', $data);
    } else if ($type == 'js') {
      echo $dwoo->get($root_dir . $dir . '.tpl', $data);
    }
  } else {
    if ($type == 'php') {
      return $dwoo->get($root_dir . $dir . '.tpl');
    } else if ($type == 'js') {
      echo $dwoo->get($root_dir . $dir . '.tpl');
    }
  }
}

//***************************************************************
//-------------------- PARTNERS RENDER TEMPLATE  ----------------
//***************************************************************

//***************************************************************
//---------------------- PLUGIN - LIB INCLUDES ------------------
//***************************************************************
/**
 * Agrega el paquete básico de js/css para cada modulo
 */
function basic_includes()
{
  global $ruta_lib, $configuracionJs;
  drupal_add_js($configuracionJs, array('type' => 'setting'));
  drupal_add_js($ruta_lib . 'plugin/js/raven.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/PartnersPlugin.js');
  drupal_add_js($ruta_lib . 'plugin/js/iziToast.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/moment.js');
  drupal_add_js($ruta_lib . 'plugin/js/daterangepicker.js');
  drupal_add_js($ruta_lib . 'plugin/js/bootstrap-datetimepicker.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/jquery.form-validator.js');
  drupal_add_js($ruta_lib . 'plugin/js/jquery.typeahead.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/sweetalert2.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/Chart.js');
  drupal_add_js($ruta_lib . 'plugin/js/ifvisible.js');
  drupal_add_js($ruta_lib . 'plugin/js/jquery.stickytableheaders.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/bootstrap-datepicker.min.js');
  drupal_add_js($ruta_lib . 'plugin/locales/bootstrap-datepicker.es.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/morphext.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/bootstrap-tagsinput.js');
  drupal_add_js($ruta_lib . 'plugin/js/jquery.smartWizard.js');
  drupal_add_js($ruta_lib . 'plugin/js/numeral.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/sanitize.js');
  drupal_add_js($ruta_lib . 'plugin/js/jquery.table2excel.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/partnersfilter.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/lodash.js');
  drupal_add_js($ruta_lib . 'plugin/js/bootstrap-editable.js');

  drupal_add_css($ruta_lib . 'plugin/css/iziToast.css');
  drupal_add_css($ruta_lib . 'plugin/css/animate.css');
  drupal_add_css($ruta_lib . 'plugin/css/daterangepicker.css');
  drupal_add_css($ruta_lib . 'plugin/css/fontawesome-all.min.css');
  drupal_add_css($ruta_lib . 'plugin/css/jquery.typeahead.min.css');
  drupal_add_css($ruta_lib . 'plugin/css/please-wait.css');
  drupal_add_css($ruta_lib . 'plugin/css/sweetalert2.css');
  drupal_add_css($ruta_lib . 'plugin/css/bootstrap-datepicker3.css');
  drupal_add_css($ruta_lib . 'plugin/css/bootstrap-datetimepicker.min.css');
  drupal_add_css($ruta_lib . 'plugin/css/bootstrap-tagsinput.css');
  drupal_add_css($ruta_lib . 'plugin/css/smart_wizard.css');
  drupal_add_css($ruta_lib . 'plugin/css/smart_wizard_theme_arrows.css');
  drupal_add_css($ruta_lib . 'plugin/css/partnersfilter.css');
  drupal_add_css($ruta_lib . 'plugin/css/bootstrap-editable.css');
}
//***************************************************************
//---------------------- PLUGIN - LIB INCLUDES ------------------
//***************************************************************
