<?php

class website_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'domain_search':
                    try {
                        $this->domain_search($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'domain_search');
                    }
                    break;
                case 'facturacion_paypal':
                    try {
                        $this->facturacion_paypal($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'facturacion_paypal');
                    }
                    break;
                case 'process_paypal_payment':
                    try {
                        $this->process_paypal_payment($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'process_paypal_payment');
                    }
                    break;
                case 'facturacion_payu':
                    try {
                        $this->facturacion_payu($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'facturacion_payu');
                    }
                    break;
                case 'solicitar_existencia':
                    try {
                        $this->solicitar_existencia($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'solicitar_existencia');
                    }
                    break;
                case 'procesar_orden_servicio_prepago':
                    try {
                        $this->procesar_orden_servicio_prepago($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'procesar_orden_servicio_prepago');
                    }
                    break;
                case 'capturar_cliente_prepago':
                    try {
                        $this->capturar_cliente_prepago($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_cliente_prepago');
                    }
                    break;
                case 'process_paypal_payment_prepago':
                    try {
                        $this->process_paypal_payment_prepago($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'process_paypal_payment_prepago');
                    }
                    break;
                case 'process_payu_payment_prepago':
                    try {
                        $this->process_payu_payment_prepago($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'process_payu_payment_prepago');
                    }
                    break;
            }
        }
    }

    private function domain_search($dominio)
    {
        // Por alguna razón, no se puede conectar por sockets con whois.mx y pues ahi truena
        //$tld = array(".com", ".org",".com.mx",".mx");
        $tld = array(".com", ".org");
        $tlds = count($tld);
        $i = 0;
        $r = '';
        while ($i < $tlds) {
            $domname = $dominio . $tld[$i]; // construir dominios con sus tld

            $whoisClient = new \Helge\Client\SimpleWhoisClient();
            $dataLoader = new \Helge\Loader\JsonLoader(HOME_SERVER . "public_html/intranet/sites/all/modules/partners/vendor/helgesverre/domain-availability/src/data/servers.json");

            $service = new \Helge\Service\DomainAvailability($whoisClient, $dataLoader);
            if ($service->isAvailable($domname)) {
                $r .= '
            <tr>
                <td>' . $domname . '</td>
                <td><b class="text-success">Disponible</b></td>
                <td></td>
            </tr>';
            } else {
                $r .= '<tr>
                <td>' . $domname . '</td>
                <td><b class="text-danger">No disponible</b></td>
                <td><a href="#" data-domain="' . $domname . '" data-stld="' . $i . '" class="ver_detalles_dominio">Ver detalles</a></td>
            </tr>';
            }

            $i++;
        }

        $this->throw_message("success", $r);
    }


    /**
     * Genera la url para el checkout en paypal
     * @param $token
     */
    private function facturacion_paypal($token)
    {
        $b = encrypt_decrypt('decrypt', $token);

        $datos = explode('~', $b);
        define('SITE_URL', 'https://www.pcpartners.com.mx/facturacion/process_paypal');
        $paypal = new PayPal\Rest\ApiContext(
            new PayPal\Auth\OAuthTokenCredential(
                'AWUdeKiLv1GgTtCM5XbtIZ6CCGXSjKNUZw9sUHhHVejZ9DI0HePnGWrsdeInwg2juZIi0bNzXU13Wj--',
                'ELw5LfNe7371hmfaD8B4KE4HsAa4FPKIfBWnfnwshissIeqVauIVZxcvVzoitooq4VjkjcoJOwz-y02K'
            )
        );


        $paypal->setConfig(array(
            'mode' => 'live'
        ));

        $flowConfig = new \PayPal\Api\FlowConfig();
        $flowConfig->setLandingPageType("Billing");
        $flowConfig->setBankTxnPendingUrl("https://www.pcpartners.com.mx/");
        $flowConfig->setUserAction("commit");

        $presentation = new \PayPal\Api\Presentation();
        $presentation->setLogoImage("https://www.pcpartners.com.mx/sites/default/files/pcpartners_payments_logo.jpg")
            ->setBrandName("PC PARTNERS")
            ->setLocaleCode("MX")
            ->setReturnUrlLabel("Regresar")
            ->setNoteToSellerLabel("PC PARTNERS");

        $inputFields = new \PayPal\Api\InputFields();

        $inputFields->setAllowNote(true)
            ->setNoShipping(1)
            ->setAddressOverride(0);

        $webProfile = new \PayPal\Api\WebProfile();
        $webProfile->setName("Pc Partners Facturacion" . uniqid())
            ->setFlowConfig($flowConfig)
            ->setPresentation($presentation)
            ->setInputFields($inputFields)
            ->setTemporary(true);

        try {
            $createProfileResponse = $webProfile->create($paypal);
        } catch (Exception $ex) {
            die($ex);
        }


        $product = "Factura " . $datos[0] . "-" . $datos[1];
        $price = (float)$datos[2];
        $shipping = 0.00;

        $total = $price + $shipping;

        $payer = new \PayPal\Api\Payer();
        $payer->setPaymentMethod('paypal');

        $item = new \PayPal\Api\Item();
        $item->setName($product)
            ->setCurrency('MXN')
            ->setQuantity(1)
            ->setPrice($price);

        $itemList = new \PayPal\Api\ItemList();
        $itemList->setItems([$item]);

        $details = new \PayPal\Api\Details();
        $details->setShipping($shipping)
            ->setSubtotal($price);

        $amount = new \PayPal\Api\Amount();
        $amount->setCurrency('MXN')
            ->setTotal($total)
            ->setDetails($details);

        $transaction = new \PayPal\Api\Transaction();
        $transaction->setAmount($amount)
            ->setItemList($itemList)
            ->setDescription('Pago de Factura Electrónica')
            ->setInvoiceNumber(uniqid());

        $redirectUrls = new \PayPal\Api\RedirectUrls();
        $redirectUrls->setReturnUrl(SITE_URL . '?success=true&tokenPartners=' . $token)
            ->setCancelUrl(SITE_URL . '?success=false');
        $payment = new \PayPal\Api\Payment();
        $payment->setIntent('sale')
            ->setPayer($payer)
            ->setRedirectUrls($redirectUrls)
            ->setExperienceProfileId($createProfileResponse->getId())
            ->setTransactions([$transaction]);

        try {
            $payment->create($paypal);
        } catch (Exception $e) {
            die($e);
        }

        $approvalUrl = $payment->getApprovalLink();
        $this->throw_message('success', $approvalUrl);
    }


    /**
     * Una vez que paypal regreso los datos de la transacción correcta, hay que hacer el cobro al usuario.
     * *Solo entra aquí cuando paypal regreso success.
     * @param $datos
     * @return false solamente cuando truena el try-catch
     */
    private function process_paypal_payment($datos)
    {
        $paypal = new PayPal\Rest\ApiContext(
            new PayPal\Auth\OAuthTokenCredential(
                'AWUdeKiLv1GgTtCM5XbtIZ6CCGXSjKNUZw9sUHhHVejZ9DI0HePnGWrsdeInwg2juZIi0bNzXU13Wj--',
                'ELw5LfNe7371hmfaD8B4KE4HsAa4FPKIfBWnfnwshissIeqVauIVZxcvVzoitooq4VjkjcoJOwz-y02K'
            )
        );

        $paypal->setConfig(array(
            'mode' => 'live'
        ));

        $payment = \PayPal\Api\Payment::get($datos->paymentID, $paypal);

        $execute = new \PayPal\Api\PaymentExecution();
        $execute->setPayerId($datos->payerID);

        try {
            $result = $payment->execute($execute, $paypal);

            // Se proceso el pago correctamente, marcar la factura como pagada sacando el folio del tokenPartners
            $decrypt = encrypt_decrypt('decrypt', $datos->tokenPartners);
            $d = explode('~', $decrypt);
            $folio = $d[1];
            db_update('partners_cobranza')
                ->fields(array(
                    'factura_pagada' => 1
                ))
                ->condition('folio', $folio)
                ->execute();
        } catch (Exception $e) {
            $this->throw_message('error', "Ocurrio un error al procesar el pago");
            return false;
        }

        $this->throw_message('success', 'Payment charged');
    }


    /**
     * Genera la url para el checkout en payU
     * @param $token
     * @deprecated Ya no se usa PayU
     */
    private function facturacion_payu($token)
    {
        $decrypt = encrypt_decrypt('decrypt', $token);
        $data_token = explode('~', $decrypt);

        $curl_connection = curl_init('https://checkout.payulatam.com/ppp-web-gateway-payu');
        curl_setopt($curl_connection, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($curl_connection, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
        curl_setopt($curl_connection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl_connection, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl_connection, CURLOPT_FOLLOWLOCATION, 1);

        $apiKey = 'cD47Ek32qhgVMPO2CB3ppPRgFz';
        $post_data['merchantId'] = '536705';
        $post_data['accountId'] = '538711';
        $post_data['description'] = 'Pago de Factura ' . $data_token[0] . '-' . $data_token[1] . '';
        $post_data['referenceCode'] = $token;
        $post_data['amount'] = $data_token[2];
        $post_data['tax'] = '0';
        $post_data['taxReturnBase'] = '0';
        $post_data['currency'] = 'MXN';
        $post_data['signature'] = md5($apiKey . '~' . $post_data['merchantId'] . '~' . $post_data['referenceCode'] . '~' . $post_data['amount'] . '~' . $post_data['currency']);
        #$post_data['test'] = '1';
        $post_data['shippingAddress'] = '';
        $post_data['shippingCity'] = '';
        $post_data['shippingCountry'] = '';
        $post_data['telephone'] = '';
        $post_data['responseUrl'] = 'https://www.pcpartners.com.mx/facturacion/process_payu/';
        $post_data['confirmationUrl'] = 'https://www.pcpartners.com.mx/facturacion/payu_confirmation/';

        foreach ($post_data as $key => $value) {
            $post_items[] = $key . '=' . $value;
        }
        $post_string = implode('&', $post_items);

        curl_setopt($curl_connection, CURLOPT_POSTFIELDS, $post_string);

        curl_exec($curl_connection);

        if (curl_error($curl_connection)) {
            $this->throw_message('error', 'Lo sentimos, ocurrió un error al procesar los datos a pagar.');
            $this->throw_fatal_error(curl_error($curl_connection), 'facturacion_payu');
        } else { // No ocurrió error al enviar los datos por cURL
            $redirect_to = curl_getinfo($curl_connection)['url'];
            curl_close($curl_connection);
            $this->throw_message('success', $redirect_to);
        }
    }


    /**
     * Envia un correo a ventas para informarle que hay un cliente que está solicitando información sobre un producto.
     * @param $datos
     * @throws Exception
     */
    private function solicitar_existencia($datos)
    {
        $data['product_name'] = $datos->product_name;
        $data['product_img'] = $datos->product_img;
        $data['product_url'] = $datos->product_url;
        $data['cliente_email'] = $datos->cliente_email;
        $data['cliente_nombre'] = $datos->cliente_nombre;
        $data['cliente_telefono'] = $datos->cliente_telefono;

        $from = ['rossy@pcpartners.com.mx' => 'Pc Partners - Solicitud Existencia'];
        $to = ['roberto@pcpartners.com.mx', 'promociones@pcpartners.com.mx', 'ventas@pcpartners.com.mx'];
        $this->send_mail('website.solicitar_existencia', $data, 'Solicitud de Existencia', $from, $to);
        $this->register_log_actions('partners_', 'mail_existencia', '(' . $datos->cliente_nombre . ' : ' . $datos->cliente_email . ') solicitó la existencia del producto: ' . $datos->product_name . '');
        $this->throw_message('success', 'Bien!');
    }


    /**
     * Procesa los datos para generar una nueva orden de un servicio prepagado, captura la orden en la base datos, y
     * al final, regresa la información para realizar el pago.
     * @param $datos
     * @return bool
     * @throws Exception
     */
    private function procesar_orden_servicio_prepago($datos)
    {

        /**
         * Horas Disponibles de 1 a 5
         */

        if ($datos->horas < 0 || $datos->horas > 5) {
            $this->throw_message('error', 'Ocurrió un error al procesar las horas seleccionadas, por favor recarga la página e intentalo de nuevo.');
            return false;
        }

        $total = 0;
        $horas_prepagadas = $datos->horas;
        switch ($horas_prepagadas) {
            case 1:
                $total = 450;
                break;
            case 2:
                $total = 650;
                break;
            case 3:
                $total = 950;
                break;
            case 4:
                $total = 1150;
                break;
            case 5:
                $total = 1350;
                break;
        }


        $metodo_pago = (int)$datos->metodo_pago;
        if ($metodo_pago < 0 || $metodo_pago > 5) {
            $this->throw_message('error', 'Ocurrió un error al momento de procesar el método de pago, por favor recarga la página e intentalo de nuevo.');
            return false;
        }


        // Previamente se capturó el cliente, entonces ahora sigue capturar el pendiente.

        if ($datos->id_contacto != 0) {
            // Como si se paso un id_contacto, entonces buscar el nombre de este contacto para generar el pendiente
            $get_nombre_contacto = db_select('partners_clientes', 'pc');
            $get_nombre_contacto->fields('pc', array('nombre_cliente'));
            $get_nombre_contacto->condition('id_cliente', $datos->id_contacto);
            $quien_reporta = $get_nombre_contacto->execute()->fetchField();
        } else {
            // No se paso el id_contacto, por lo tanto buscar el nombre para generar el pendiente en el id_cliente
            $get_nombre_cliente = db_select('partners_clientes', 'pc');
            $get_nombre_cliente->fields('pc', array('nombre_cliente'));
            $get_nombre_cliente->condition('id_cliente', $datos->id_cliente);
            $quien_reporta = $get_nombre_cliente->execute()->fetchField();
        }
        $id_pendiente = db_insert('partners_pendientes')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => 0,
                'updated_at' => REQUEST_TIME,
                'updated_by' => 0,
                'tipo_pendiente' => 5, // Pendiente de servicio de prepago
                'area_pendiente' => 2, // Soporte
                'id_cliente' => $datos->id_cliente,
                'asignado_para' => 0,
                'fecha_pendiente' => strtotime($datos->fecha_servicio),
                'descripcion_pendiente' => $datos->descripcion_servicio,
                'horario_pendiente' => $datos->horario_servicio,
                'prioridad_pendiente' => 1, // Urgente
                'que_llevar_pendiente' => '',
                'quien_reporta_pendiente' => $quien_reporta,
                'pendiente_otro' => null,
                'allow_editar' => 0 // Para que no puedan editar el pendiente hasta que el pago sea aprovado
            ))
            ->execute();
        $this->register_log_actions('partners_pendientes', 'insert', 'Se capturó un nuevo pendiente de tipo prepago para el dia: ' . $datos->fecha_servicio);

        // Una vez con los datos validados y el pendiente agendado, capturar la orden.

        $id_orden = db_insert('partners_prepago_ordenes')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => 0,
                'updated_at' => REQUEST_TIME,
                'updated_by' => 0,
                'id_cliente' => $datos->id_cliente,
                'id_contacto' => $datos->id_contacto,
                'tipo_servicio' => $datos->tipo_servicio,
                'fecha_servicio' => strtotime($datos->fecha_servicio),
                'horario_servicio' => $datos->horario_servicio,
                'descripcion_servicio' => $datos->descripcion_servicio,
                'horas_prepagadas' => $datos->horas,
                'metodo_pago' => $datos->metodo_pago,
                'total' => $total,
                'id_pendiente' => $id_pendiente
            ))
            ->execute();

        $this->register_log_actions('partners_prepago_ordenes', 'insert', 'Se generó una nueva orden con el id: ' . $id_orden);


        // Hasta este punto que ya se generó la orden, entonces quitar el cancelado a los clientes y contactos generados, porque básicamente ya existe la orden.
        db_update('partners_clientes')
            ->fields(array(
                'cancelado' => 0
            ))
            ->condition('id_cliente', $datos->id_cliente)
            ->execute();
        if ($datos->id_contacto != 0) {
            db_update('partners_clientes')
                ->fields(array(
                    'cancelado' => 0
                ))
                ->condition('id_cliente', $datos->id_contacto)
                ->execute();
        }


        // Ahora con la orden generada, hay que generar el checkout para el pago correspondiente.
        /**
         * Métodos de Pago:
         * 1) Tarjeta de Crédito
         * 2) Tarjeta de Débito
         * 3) Efectivo
         * 4) PayPal
         * 5) Transferencia Bancaria
         */

        $token = encrypt_decrypt('encrypt', $id_orden);

        if ($datos->metodo_pago == 1 || $datos->metodo_pago == 2 || $datos->metodo_pago == 3) { // Generar el checkout de payU
            $curl_connection = curl_init('https://sandbox.checkout.payulatam.com/ppp-web-gateway-payu');
            curl_setopt($curl_connection, CURLOPT_CONNECTTIMEOUT, 30);
            curl_setopt($curl_connection, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
            curl_setopt($curl_connection, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl_connection, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl_connection, CURLOPT_FOLLOWLOCATION, 1);

            $apiKey = '4Vj8eK4rloUd272L48hsrarnUA';
            $post_data['merchantId'] = '508029';
            $post_data['accountId'] = '512324';
            $post_data['description'] = "Pago de un servicio de prepago por $horas_prepagadas Horas";
            $post_data['referenceCode'] = $token;
            $post_data['amount'] = $total;
            $post_data['tax'] = '0';
            $post_data['taxReturnBase'] = '0';
            $post_data['currency'] = 'MXN';
            $post_data['signature'] = md5($apiKey . '~' . $post_data['merchantId'] . '~' . $post_data['referenceCode'] . '~' . $post_data['amount'] . '~' . $post_data['currency']);
            $post_data['test'] = '1';
            $post_data['shippingAddress'] = '';
            $post_data['shippingCity'] = '';
            $post_data['shippingCountry'] = '';
            $post_data['telephone'] = '';
            $post_data['responseUrl'] = 'https://www.pcpartners.com.mx/prepago/process_payu/';
            $post_data['confirmationUrl'] = 'https://www.pcpartners.com.mx/prepago/payu_confirmation/';

            if ($datos->id_contacto != 0) {
                // Si existe contacto, usar el email de este mismo
                $get_email_contacto = db_select('partners_clientes', 'pc');
                $get_email_contacto->fields('pc', array('email'));
                $get_email_contacto->condition('id_cliente', $datos->id_contacto);
                $email_contacto = $get_email_contacto->execute()->fetchField();
                $post_data['buyerEmail'] = $email_contacto;
            } else {
                // Usar el email del cliente particular
                $get_email_cliente = db_select('partners_clientes', 'pc');
                $get_email_cliente->fields('pc', array('email'));
                $get_email_cliente->condition('id_cliente', $datos->id_cliente);
                $email_cliente = $get_email_cliente->execute()->fetchField();
                $post_data['buyerEmail'] = $email_cliente;
            }
            $post_data['buyerFullName'] = $quien_reporta;


            foreach ($post_data as $key => $value) {
                $post_items[] = $key . '=' . $value;
            }
            $post_string = implode('&', $post_items);

            curl_setopt($curl_connection, CURLOPT_POSTFIELDS, $post_string);

            curl_exec($curl_connection);

            if (curl_error($curl_connection)) {
                $this->throw_message('error', 'Lo sentimos, ocurrió un error al procesar los datos a pagar.');
                $this->throw_fatal_error(curl_error($curl_connection), 'facturacion_payu');
            } else { // No ocurrió error al enviar los datos por cURL
                $redirect_to = curl_getinfo($curl_connection)['url'];
                curl_close($curl_connection);
                $this->throw_message('success', $redirect_to);
            }

        } else if ($datos->metodo_pago == 4) { // Generar el checkout de PayPal
            define('SITE_URL', 'https://www.pcpartners.com.mx/prepago/process_paypal');
            $paypal = new PayPal\Rest\ApiContext(
                new PayPal\Auth\OAuthTokenCredential(
                    'AY-8BHaCQktZekeExW8Fufq_1_LdTHcackrDzCxWkIiDzWqPR8e5fZiF1RI7XEJ38FW7Sv55D1yOvsU7',
                    'EK5aub3DjoE4AyzR709gNEEeS9gzI8PB64uhjyDWd-a-Rmc65xqzm2XdzqIPfwFbzoU-GT6igT2_6zLo'
                )
            );

            /*
            $paypal->setConfig(array(
                'mode' => 'live'
            ));
            */

            $flowConfig = new \PayPal\Api\FlowConfig();
            $flowConfig->setLandingPageType("Billing");
            $flowConfig->setBankTxnPendingUrl("https://www.pcpartners.com.mx/");
            $flowConfig->setUserAction("commit");

            $presentation = new \PayPal\Api\Presentation();
            $presentation->setLogoImage("https://www.pcpartners.com.mx/sites/default/files/pcpartners_payments_logo.jpg")
                ->setBrandName("PC PARTNERS")
                ->setLocaleCode("MX")
                ->setReturnUrlLabel("Regresar")
                ->setNoteToSellerLabel("PC PARTNERS");

            $inputFields = new \PayPal\Api\InputFields();

            $inputFields->setAllowNote(true)
                ->setNoShipping(1)
                ->setAddressOverride(0);

            $webProfile = new \PayPal\Api\WebProfile();
            $webProfile->setName("Pc Partners Prepago" . uniqid())
                ->setFlowConfig($flowConfig)
                ->setPresentation($presentation)
                ->setInputFields($inputFields)
                ->setTemporary(true);

            try {
                $createProfileResponse = $webProfile->create($paypal);
            } catch (Exception $ex) {
                die($ex);
            }


            $product = "$horas_prepagadas Horas de Servicio";
            $price = (float)$total;
            $shipping = 0.00;

            $total = $price + $shipping;

            $payer = new \PayPal\Api\Payer();
            $payer->setPaymentMethod('paypal');

            $item = new \PayPal\Api\Item();
            $item->setName($product)
                ->setCurrency('MXN')
                ->setQuantity(1)
                ->setPrice($price);

            $itemList = new \PayPal\Api\ItemList();
            $itemList->setItems([$item]);

            $details = new \PayPal\Api\Details();
            $details->setShipping($shipping)
                ->setSubtotal($price);

            $amount = new \PayPal\Api\Amount();
            $amount->setCurrency('MXN')
                ->setTotal($total)
                ->setDetails($details);

            $transaction = new \PayPal\Api\Transaction();
            $transaction->setAmount($amount)
                ->setItemList($itemList)
                ->setDescription("Pago de un servicio de prepago por $horas_prepagadas Horas")
                ->setInvoiceNumber(uniqid());


            $redirectUrls = new \PayPal\Api\RedirectUrls();
            $redirectUrls->setReturnUrl(SITE_URL . '?success=true&tokenPartners=' . $token)
                ->setCancelUrl(SITE_URL . '?success=false');
            $payment = new \PayPal\Api\Payment();
            $payment->setIntent('sale')
                ->setPayer($payer)
                ->setRedirectUrls($redirectUrls)
                ->setExperienceProfileId($createProfileResponse->getId())
                ->setTransactions([$transaction]);

            try {
                $payment->create($paypal);
            } catch (Exception $e) {
                die($e);
            }

            $approvalUrl = $payment->getApprovalLink();
            $this->throw_message('success', $approvalUrl);

        } else if ($datos->metodo_pago == 5) { // Regresar una vista con la información de las cuentas bancarias
            $data['total'] = $total;
            $info = render_template('php', 'website.servicios_prepago_info_transferencia_bancaria', $data);
            $this->throw_message('success', $info);
        } else {
            $this->throw_message('error', 'Ocurrió un error al momento de procesar el método de pago, por favor recarga la página e intentalo de nuevo.');
        }
    }

    /**
     * Captura el cliente ( y en caso de ser necesario el contacto tambien) que quedará marcado como temporal, si se completa la compra
     * quedará como un cliente normal con una marca de que es cliente.
     * Regresa un array que contiene el id_cliente y el id_contacto que serán guardados como referencia hasta que el pedido se complete.
     * @param $datos
     * @throws Exception
     */
    private function capturar_cliente_prepago($datos)
    {
        /**
         * Tipo Cliente:
         * 1) Particular
         * 2) Empresa
         */

        /**
         * Tipo Servicio:
         * 1) Remoto
         * 2) Domicilio
         */

        // Set Defaults
        $id_cliente = 0;
        $id_contacto = 0;

        // Capturar solo el Cliente particular
        if ($datos->tipo_cliente == 1) {
            // Si ya se paso como parametro el id_cliente, entonces hacer update de los datos, sino capturar uno nuevo
            if ($datos->id_cliente != 0) {
                // Update
                $id_cliente = $datos->id_cliente;


                // Actualizar los datos del cliente particular
                db_update('partners_clientes')
                    ->fields(array(
                        'nombre_cliente' => $datos->nombre_cliente,
                        'email' => $datos->correo_cliente,
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->execute();


                // Actualizar el celular y el correo en la tabla de datos clientes.
                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->telefono_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 2)
                    ->execute();

                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->correo_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 3)
                    ->execute();

            } else {
                // Insert
                $id_cliente = db_insert('partners_clientes')
                    ->fields(array(
                        'created_by' => 0,
                        'updated_by' => 0,
                        'created_at' => REQUEST_TIME,
                        'updated_at' => REQUEST_TIME,
                        'tipo_cliente' => 1, // Cliente
                        'areas_cliente' => 2, // Soporte,
                        'tipo_negocio' => 2, // Particular,
                        'nombre_cliente' => $datos->nombre_cliente,
                        'email' => $datos->correo_cliente,
                        'cancelado' => 1, // El cliente se captura como cancelado, para que no aparezca en el panel, de está manera queda como temporal,
                        // hasta que el proceso de pago sea terminado, se quitará esta marca de cancelado para que ahora si aparezca en el panel.
                        'is_from_prepago' => 1, // Marca para saber que el cliente se capturó desde un servicio de prepago.,
                        'tipo_clasificacion' => 'p' // p = Prepago
                    ))
                    ->execute();

                // Capturar el celular y el correo en la tabla de datos clientes.
                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 2, // Celular
                        'dato_valor' => $datos->telefono_cliente
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 3, // Correo
                        'dato_valor' => $datos->correo_cliente
                    ))
                    ->execute();
            }

        } else if ($datos->tipo_cliente == 2) {
            // Capturar el Cliente tipo Negocio y su Contacto
            if ($datos->id_cliente != 0) {
                // Update
                $id_cliente = $datos->id_cliente;

                // Actualizar el nombre de la empresa (que es básicamente lo único que se guarda en la tabla de clientes cuando es negocio)
                db_update('partners_clientes')
                    ->fields(array(
                        'nombre_cliente' => $datos->nombre_empresa,
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->execute();

                // Actualizar el teléfono de la empresa en la tabla de datos clientes.
                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->telefono_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 1)
                    ->execute();

            } else {
                // Insert

                $id_cliente = db_insert('partners_clientes')
                    ->fields(array(
                        'created_by' => 0,
                        'updated_by' => 0,
                        'created_at' => REQUEST_TIME,
                        'updated_at' => REQUEST_TIME,
                        'tipo_cliente' => 1, // Cliente
                        'areas_cliente' => 2, // Soporte,
                        'tipo_negocio' => 1, // Negocio (Empresa),
                        'nombre_cliente' => $datos->nombre_empresa,
                        'cancelado' => 1, // El cliente se captura como cancelado, para que no aparezca en el panel, de está manera queda como temporal,
                        // hasta que el proceso de pago sea terminado, se quitará esta marca de cancelado para que ahora si aparezca en el panel.
                        'is_from_prepago' => 1, // Marca para saber que el cliente se capturó desde un servicio de prepago.
                        'tipo_clasificacion' => 'p' // p = Prepago
                    ))
                    ->execute();

                // Capturar el teléfono de la empresa en la tabla de datos clientes.
                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 1, // Teléfono
                        'dato_valor' => $datos->telefono_empresa
                    ))
                    ->execute();
            }

            if ($datos->id_contacto != 0) {
                // Update
                $id_contacto = $datos->id_contacto;

                // Actualizar los datos del contacto
                db_update('partners_clientes')
                    ->fields(array(
                        'nombre_cliente' => $datos->nombre_contacto,
                        'email' => $datos->correo_contacto
                    ))
                    ->condition('id_cliente', $id_contacto)
                    ->execute();

                // Actualizar el celular y el correo del contacto en la tabla de datos clientes.
                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->telefono_contacto
                    ))
                    ->condition('id_cliente', $id_contacto)
                    ->condition('tipo_dato', 2)
                    ->execute();

                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->correo_contacto
                    ))
                    ->condition('id_cliente', $id_contacto)
                    ->condition('tipo_dato', 3)
                    ->execute();

            } else {
                // Insert

                $id_contacto = db_insert('partners_clientes')
                    ->fields(array(
                        'created_by' => 0,
                        'updated_by' => 0,
                        'created_at' => REQUEST_TIME,
                        'updated_at' => REQUEST_TIME,
                        'tipo_cliente' => 2, // Contacto
                        'areas_cliente' => 2, // Soporte,
                        'tipo_negocio' => 0, // Es contacto,
                        'nombre_cliente' => $datos->nombre_contacto,
                        'email' => $datos->correo_contacto,
                        'id_padre' => $id_cliente, // Ligar este contacto a la empresa recién creada.
                        'cancelado' => 1, // El contacto se captura como cancelado, para que no aparezca en el panel, de está manera queda como temporal,
                        // hasta que el proceso de pago sea terminado, se quitará esta marca de cancelado para que ahora si aparezca en el panel.
                        'is_from_prepago' => 1, // Marca para saber que el contacto se capturó desde un servicio de prepago.
                        'tipo_clasificacion' => 'p' // p = Prepago
                    ))
                    ->execute();

                // Capturar el celular y el correo del contacto en la tabla de datos clientes.
                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 2, // Celular
                        'dato_valor' => $datos->telefono_contacto
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 3, // Correo
                        'dato_valor' => $datos->correo_contacto
                    ))
                    ->execute();
            }
        }


        // Si el servicio es a Domicilio, capturar los datos de domicilio al cliente (independientemente de que el tipo_cliente sea
        // empresa o particular, el domicilio se captura en el cliente y no en el contacto)
        if ($datos->tipo_servicio == 2) {
            if ($datos->id_cliente != 0) {
                // Hacer update
                $id_cliente = $datos->id_cliente;

                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->calle_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 5)
                    ->execute();

                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->colonia_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 7)
                    ->execute();

                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->cruzamientos_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 6)
                    ->execute();

                db_update('partners_clientes_datos')
                    ->fields(array(
                        'dato_valor' => $datos->ciudad_cliente
                    ))
                    ->condition('id_cliente', $id_cliente)
                    ->condition('tipo_dato', 8)
                    ->execute();


            } else {
                // Hacer insert

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 5, // Calle y Número
                        'dato_valor' => $datos->calle_cliente
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 7, // Colonia
                        'dato_valor' => $datos->colonia_cliente
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 6, // Cruzamientos
                        'dato_valor' => $datos->cruzamientos_cliente
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 8, // Ciudad y Estado
                        'dato_valor' => $datos->ciudad_cliente
                    ))
                    ->execute();

                // Se captura las coordenadas de maps por default en pcpartners.
                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 10, // Maps
                        'dato_valor' => "20.6854551,-103.3542671"
                    ))
                    ->execute();

                // Se captura por default tambien el horario, para que quede el registro en la tabla y despues lo puedan editar.
                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_cliente,
                        'tipo_dato' => 9, // Horario
                        'dato_valor' => ""
                    ))
                    ->execute();

                if ($id_contacto != 0) {
                    db_insert('partners_clientes_datos')
                        ->fields(array(
                            'id_cliente' => $id_contacto,
                            'tipo_dato' => 5, // Calle y Número
                            'dato_valor' => ""
                        ))
                        ->execute();

                    db_insert('partners_clientes_datos')
                        ->fields(array(
                            'id_cliente' => $id_contacto,
                            'tipo_dato' => 7, // Colonia
                            'dato_valor' => ""
                        ))
                        ->execute();

                    db_insert('partners_clientes_datos')
                        ->fields(array(
                            'id_cliente' => $id_contacto,
                            'tipo_dato' => 6, // Cruzamientos
                            'dato_valor' => ""
                        ))
                        ->execute();

                    db_insert('partners_clientes_datos')
                        ->fields(array(
                            'id_cliente' => $id_contacto,
                            'tipo_dato' => 8, // Ciudad y Estado
                            'dato_valor' => ""
                        ))
                        ->execute();

                    db_insert('partners_clientes_datos')
                        ->fields(array(
                            'id_cliente' => $id_contacto,
                            'tipo_dato' => 10, // Maps
                            'dato_valor' => "20.6854551,-103.3542671"
                        ))
                        ->execute();

                    db_insert('partners_clientes_datos')
                        ->fields(array(
                            'id_cliente' => $id_contacto,
                            'tipo_dato' => 9, // Horario
                            'dato_valor' => ""
                        ))
                        ->execute();
                }


            }
        } else {

            // Si no se paso ningún dato de domicilio, entonces hay que "inicializar" los valores en la tabla para que después
            // puedan ser usados en el cliente.


            db_insert('partners_clientes_datos')
                ->fields(array(
                    'id_cliente' => $id_cliente,
                    'tipo_dato' => 5, // Calle y Número
                    'dato_valor' => ""
                ))
                ->execute();

            db_insert('partners_clientes_datos')
                ->fields(array(
                    'id_cliente' => $id_cliente,
                    'tipo_dato' => 7, // Colonia
                    'dato_valor' => ""
                ))
                ->execute();

            db_insert('partners_clientes_datos')
                ->fields(array(
                    'id_cliente' => $id_cliente,
                    'tipo_dato' => 6, // Cruzamientos
                    'dato_valor' => ""
                ))
                ->execute();

            db_insert('partners_clientes_datos')
                ->fields(array(
                    'id_cliente' => $id_cliente,
                    'tipo_dato' => 8, // Ciudad y Estado
                    'dato_valor' => ""
                ))
                ->execute();

            db_insert('partners_clientes_datos')
                ->fields(array(
                    'id_cliente' => $id_cliente,
                    'tipo_dato' => 10, // Maps
                    'dato_valor' => "20.6854551,-103.3542671"
                ))
                ->execute();

            db_insert('partners_clientes_datos')
                ->fields(array(
                    'id_cliente' => $id_cliente,
                    'tipo_dato' => 9, // Horario
                    'dato_valor' => ""
                ))
                ->execute();

            if ($id_contacto != 0) {
                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 5, // Calle y Número
                        'dato_valor' => ""
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 7, // Colonia
                        'dato_valor' => ""
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 6, // Cruzamientos
                        'dato_valor' => ""
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 8, // Ciudad y Estado
                        'dato_valor' => ""
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 10, // Maps
                        'dato_valor' => "20.6854551,-103.3542671"
                    ))
                    ->execute();

                db_insert('partners_clientes_datos')
                    ->fields(array(
                        'id_cliente' => $id_contacto,
                        'tipo_dato' => 9, // Horario
                        'dato_valor' => ""
                    ))
                    ->execute();
            }

        }

        // Si por alguna razón no se capturó ni tampoco se actualizó ningun cliente y/o contacto, deberá regresar error.
        if ($id_cliente == 0 && $id_contacto == 0 && $datos->id_cliente == 0 && $datos->id_contacto == 0) {
            $this->throw_message('error', 'Ocurrió un error al momento de procesar los datos personales, por favor recarga la página e intenta de nuevo . ');
        } else {
            $data = array(
                "id_cliente" => $id_cliente,
                "id_contacto" => $id_contacto
            );
            $this->throw_message('success', json_encode($data));
        }

    }

    /**
     * Una vez que paypal regrese success en la transacción, hay que cobrarla al cliente y hacer el proceso interno necesario.
     * @param $datos
     * @return bool
     */
    private function process_paypal_payment_prepago($datos)
    {
        $paypal = new PayPal\Rest\ApiContext(
            new PayPal\Auth\OAuthTokenCredential(
                'AY-8BHaCQktZekeExW8Fufq_1_LdTHcackrDzCxWkIiDzWqPR8e5fZiF1RI7XEJ38FW7Sv55D1yOvsU7',
                'EK5aub3DjoE4AyzR709gNEEeS9gzI8PB64uhjyDWd-a-Rmc65xqzm2XdzqIPfwFbzoU-GT6igT2_6zLo'
            )
        );

        /*
        $paypal->setConfig(array(
            'mode' => 'live'
        ));
        */

        $payment = \PayPal\Api\Payment::get($datos->paymentID, $paypal);

        $execute = new \PayPal\Api\PaymentExecution();
        $execute->setPayerId($datos->payerID);

        try {
            $payment->execute($execute, $paypal);

            // Generar datos para correo
            $id_orden = encrypt_decrypt('decrypt', $datos->tokenPartners);


            $get_orden = db_select('partners_prepago_ordenes', 'ppo');
            $get_orden->fields('ppo');
            $get_orden->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = ppo.id_cliente');
            $get_orden->fields('pc', array(
                'nombre_cliente', 'email'
            ));
            $get_orden->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = ppo.id_contacto');
            $get_orden->addField('pcc', 'nombre_cliente', 'nombre_contacto');
            $get_orden->addField('pcc', 'email', 'email_contacto');
            $get_orden->condition('ppo.id_orden', $id_orden);
            $orden = $get_orden->execute()->fetchAssoc();

            // Si es servicio a domicilio, traer los datos del domicilio del cliente.
            if ($orden['tipo_servicio'] == 2) {
                $query_d = db_select('partners_clientes_datos', 'pcd');
                $query_d->fields('pcd');
                $query_d->condition('id_cliente', $orden['id_cliente']);
                $query_d->condition('tipo_dato', [5, 6, 7, 8], 'IN');
                $d = $query_d->execute();
                $datos_d = array();
                while ($row = $d->fetchAssoc()) {
                    if ($row['tipo_dato'] == 5) {
                        $datos_d['calle'] = $row['dato_valor'];
                    } else if ($row['tipo_dato'] == 6) {
                        $datos_d['cruzamientos'] = $row['dato_valor'];
                    } else if ($row['tipo_dato'] == 7) {
                        $datos_d['colonia'] = $row['dato_valor'];
                    } else if ($row['tipo_dato'] == 8) {
                        $datos_d['ciudad'] = $row['dato_valor'];
                    }
                }

                $data['datos_d'] = $datos_d;
            }


            // Método de Pago, se está procesando paypal entonces obviamente es paypal.
            $data['metodo_pago'] = 'PayPal';

            $data['orden'] = $orden;


            // Procesar en orden de prepago
            db_update('partners_prepago_ordenes')
                ->fields(array(
                    'pagado' => 2, // PayPal
                    'observaciones' => $this->serialize_obs("Se marcó  la orden como pagada automáticamente debido a la confirmación del pago por parte de PayPal", 2, 'partners_prepago_ordenes', 'id_orden', $orden['id_orden'], 'Sistema'),
                    'pagado_user' => 0 // No fue ningún usuario, fue el sistema.
                ))
                ->condition('id_orden', $orden['id_orden'])
                ->execute();

            $this->register_log_actions('partners_prepago_ordenes', 'update', 'Se marcó la orden de prepago(' . $orden['id_orden'] . ') como pagada automáticamente debido a la confirmación del pago por parte de PayPal.');

            db_update('partners_pendientes')
                ->fields(array(
                    'tipo_pendiente' => 2, // Poner que es tipo pendiente de soporte para que le puedan seguir dando seguimiento
                    'id_orden_prepago' => $orden['id_orden'], // Marcar con el id_orden para indicar que la orden ya ha sido pagada
                    'allow_editar' => 1
                ))
                ->condition('id_pendiente', $orden['id_pendiente'])
                ->execute();
            $this->register_log_actions('partners_pendientes', 'update', 'Se actualizaron los datos del pendiente de prepago: ' . $orden['id_pendiente'] . " para que se le pueda dar el seguimiento como un pendiente de soporte normal ");


            // Enviar correo
            if ($orden['id_contacto'] != 0) {
                $to = [$orden['email_contacto']];

            } else {
                $to = [$orden['email']];

            }
            $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
            $transport = new Swift_SendmailTransport();
            $mailer = new Swift_Mailer($transport);


            $body = render_template('php', 'website.mail_confirmacion_pago_prepago', $data);
            $message = (new Swift_Message())
                ->setSubject('Su pago ha sido aprobado exitosamente!')
                ->setFrom($from)
                ->setBody($body, 'text/html');
            $failedRecipients = [];
            $numSent = 0;

            foreach ($to as $address => $name) {
                if (is_int($address)) {
                    $message->setTo($name);
                } else {
                    $message->setTo([$address => $name]);
                }
                $numSent += $mailer->send($message, $failedRecipients);
            }


        } catch (Exception $e) {
            $this->throw_message('error', "Ocurrio un error al procesar el pago");
            return false;
        }

        $this->throw_message('success', 'Payment charged');
    }


    /**
     * Procesa los datos que regresa payU, cae aquí solamente cuando la transacción ha sido aprobada.
     * @param $datos
     * @throws Exception
     * @deprecated Ya no se usa PayU
     */
    private function process_payu_payment_prepago($datos)
    {
        $id_orden = encrypt_decrypt('decrypt', $datos['id_orden']);


        $get_orden = db_select('partners_prepago_ordenes', 'ppo');
        $get_orden->fields('ppo');
        $get_orden->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = ppo.id_cliente');
        $get_orden->fields('pc', array(
            'nombre_cliente', 'email'
        ));
        $get_orden->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = ppo.id_contacto');
        $get_orden->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $get_orden->addField('pcc', 'email', 'email_contacto');
        $get_orden->condition('ppo.id_orden', $id_orden);
        $orden = $get_orden->execute()->fetchAssoc();

        // Si es servicio a domicilio, traer los datos del domicilio del cliente.
        if ($orden['tipo_servicio'] == 2) {
            $query_d = db_select('partners_clientes_datos', 'pcd');
            $query_d->fields('pcd');
            $query_d->condition('id_cliente', $orden['id_cliente']);
            $query_d->condition('tipo_dato', [5, 6, 7, 8], 'IN');
            $d = $query_d->execute();
            $datos_d = array();
            while ($row = $d->fetchAssoc()) {
                if ($row['tipo_dato'] == 5) {
                    $datos_d['calle'] = $row['dato_valor'];
                } else if ($row['tipo_dato'] == 6) {
                    $datos_d['cruzamientos'] = $row['dato_valor'];
                } else if ($row['tipo_dato'] == 7) {
                    $datos_d['colonia'] = $row['dato_valor'];
                } else if ($row['tipo_dato'] == 8) {
                    $datos_d['ciudad'] = $row['dato_valor'];
                }
            }

            $data['datos_d'] = $datos_d;
        }


        // Método de Pago, se está procesando paypal entonces obviamente es paypal.
        $data['metodo_pago'] = $datos['metodo_pago'];

        $data['orden'] = $orden;


        // Procesar en orden de prepago
        db_update('partners_prepago_ordenes')
            ->fields(array(
                'pagado' => 3, // PayU
                'observaciones' => $this->serialize_obs("Se marcó  la orden como pagada automáticamente debido a la confirmación del pago por parte de PayU, pago con el método de pago: " . $datos['metodo_pago'], 2, 'partners_prepago_ordenes', 'id_orden', $id_orden, 'Sistema'),
                'pagado_user' => 0 // No fue ningún usuario, fue el sistema.
            ))
            ->condition('id_orden', $orden['id_orden'])
            ->execute();

        $this->register_log_actions('partners_prepago_ordenes', 'update', 'Se marcó la orden de prepago(' . $id_orden . ') como pagada automáticamente debido a la confirmación del pago por parte de PayU.');

        db_update('partners_pendientes')
            ->fields(array(
                'tipo_pendiente' => 2, // Poner que es tipo pendiente de soporte para que le puedan seguir dando seguimiento
                'id_orden_prepago' => $id_orden, // Marcar con el id_orden para indicar que la orden ya ha sido pagada
                'allow_editar' => 1
            ))
            ->condition('id_pendiente', $orden['id_pendiente'])
            ->execute();
        $this->register_log_actions('partners_pendientes', 'update', 'Se actualizaron los datos del pendiente de prepago: ' . $orden['id_pendiente'] . " para que se le pueda dar el seguimiento como un pendiente de soporte normal ");


        // Enviar correo
        if ($orden['id_contacto'] != 0) {
            $to = [$orden['email_contacto']];

        } else {
            $to = [$orden['email']];

        }
        $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
        $transport = new Swift_SendmailTransport();
        $mailer = new Swift_Mailer($transport);


        $body = render_template('php', 'website.mail_confirmacion_pago_prepago', $data);
        $message = (new Swift_Message())
            ->setSubject('Su pago ha sido aprobado exitosamente!')
            ->setFrom($from)
            ->setBody($body, 'text/html');
        $failedRecipients = [];
        $numSent = 0;

        foreach ($to as $address => $name) {
            if (is_int($address)) {
                $message->setTo($name);
            } else {
                $message->setTo([$address => $name]);
            }
            $numSent += $mailer->send($message, $failedRecipients);
        }
    }
}
