<?php

class web_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'capturar_proyecto':
                    try {
                        $this->capturar_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_proyecto');
                    }
                    break;
                case 'update_status':
                    try {
                        $this->update_status($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_status');
                    }
                    break;
                case 'eliminar_proyecto':
                    try {
                        $this->eliminar_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'eliminar_proyecto');
                    }
                    break;
                case 'reactivate_proyecto':
                    try {
                        $this->reactivate_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reactivate_proyecto');
                    }
                    break;
                case 'vista_proyecto':
                    try {
                        $this->vista_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_proyecto');
                    }
                    break;
                case 'reporte_base_dominios_web':
                    try {
                        $this->reporte_base_dominios_web($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base_dominios_web');
                    }
                    break;
                case 'cpanel_create_user_session':
                    try {
                        $this->cpanel_create_user_session($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cpanel_create_user_session');
                    }
                    break;
                case 'vista_dominio':
                    try {
                        $this->vista_dominio($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_dominio');
                    }
                    break;
                case 'capturar_dominio_web':
                    try {
                        $this->capturar_dominio_web($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_dominio_web');
                    }
                    break;
                case 'get_emails_soporte':
                    try {
                        $this->get_emails_soporte($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'get_emails_soporte');
                    }
                    break;
                case 'send_cpanel_session':
                    try {
                        $this->send_cpanel_session($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'send_cpanel_session');
                    }
                    break;
                case 'eliminar_dominio_web':
                    try {
                        $this->eliminar_dominio_web($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'eliminar_dominio_web');
                    }
                    break;
                case 'vista_datos_cliente':
                    try {
                        $this->vista_datos_cliente($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_datos_cliente');
                    }
                    break;
            }
        }
    }

    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $query = db_select('partners_web', 'pw');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pw.id_cliente');
        $query->fields('pw');
        $query->fields('pc', array('nombre_cliente'));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pw.id_contacto');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->condition('pw.proyecto_eliminado', '1', '!=');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('pw.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('pw.created_at', array($f_inicio, $f_final), 'BETWEEN');
            }
        }

        // Filtro - Usuario
        if ($datos->filter->usuario != 0) {
            $query->condition('pw.created_by', $datos->filter->usuario);
        }


        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $web_or = db_or()
                ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pw.dominio', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pw.trabajo', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $query->condition($web_or);
        }


        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        $web = [];
        while ($row = $query_datos->fetchAssoc()) {
            $folio = array("data" => $row['id_proyecto'], "class" => array("cursor-pointer", "vista_proyecto"));
            $fecha = array("data" => date('d/m/y', $row['created_at']), "class" => array("cursor-pointer", "vista_proyecto"));
            $usuario = array("data" => user_load($row['created_by'])->name, "class" => array("cursor-pointer", "vista_proyecto"));
            $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 20, "utf-8"), "class" => array("cursor-pointer", "vista_proyecto"));
            $dominio = array("data" => mb_substr($row['dominio'], 0, 60, "utf-8"), "class" => array("cursor-pointer", "vista_proyecto"));
            $precio = array("data" => number_format($row['precio'], 2, '.', ','), "class" => array("cursor-pointer", "vista_proyecto", "text-right"));
            $costo = array("data" => number_format($row['costo'], 2, '.', ','), "class" => array("cursor-pointer", "status_costo", "text-right"));

            // Observaciones | Notas internas
            if ($row['observaciones'] != null) {
                $observaciones = array("data" => 'Obs', "class" => array("status-yellow", "status_obs", "text-center", "cursor-pointer"));
            } else {
                $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs", "cursor-pointer"));
            }

            // Revisión Cliente
            $revision_cliente = array("data" => ($row['revision_cliente'] == 1 ? 'Si' : 'No'), "class" => array(($row['revision_cliente'] == 1 ? 'status-green' : 'status-red'), "status_revision_cliente", "cursor-pointer", "text-center"));


            // Pagado
            if ($row['facturado'] == 0) {
                $pagado = array("data" => "No", "class" => array(user_access("web_administrador") ? "status_facturado cursor-pointer" : "", "status-red", "text-center"));
            } else if ($row['facturado'] == 1) {
                $pagado = array("data" => "Pagado", "class" => array(user_access("web_administrador") ? "status_facturado cursor-pointer" : "", "status-green", "text-center"));
            } else if ($row['facturado'] == 2) {
                $pagado = array("data" => "Factura", "class" => array(user_access("web_administrador") ? "status_facturado cursor-pointer" : "", "status-green", "text-center"));
            }

            // Terminado
            $terminado = array("data" => ($row['terminado'] == 1 ? 'Si' : 'No'), "class" => array(($row['terminado'] == 1 ? 'status-green' : 'status-red'), "status_terminado", "cursor-pointer", "text-center"));

            // Problema
            $problema = array("data" => ($row['problema'] == 1 ? 'Si' : 'No'), "class" => array(($row['problema'] == 1 ? 'status-red' : 'status-green'), "status_problema", "cursor-pointer", "text-center"));

            // Borrar
            $borrar = array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "eliminar_proyecto"));

            $numero_factura = array("data" => $this->get_numero_factura('partners_web', $row['id_proyecto']), "class" => array(($this->get_numero_factura('partners_web', $row['id_proyecto'])) ? "text-right cursor-pointer ver_factura" : ""));

            if (user_access("web_administrador")) {
                $web[] = array(
                    "data" => array(
                        $folio,
                        $fecha,
                        $usuario,
                        $cliente,
                        $dominio,
                        $precio,
                        $costo,
                        $revision_cliente,
                        $terminado,
                        $pagado,
                        $numero_factura,
                        $problema,
                        $observaciones,
                        $borrar
                    ),
                    "data-id-proyecto" => $row['id_proyecto'],
                    "data-terminado" => $row['terminado'],
                    "data-problema" => $row['problema'],
                    "data-dominio" => $row['dominio'],
                    "data-revision-cliente" => $row['revision_cliente']
                );
            } else {
                $web[] = array(
                    "data" => array(
                        $folio,
                        $fecha,
                        $usuario,
                        $cliente,
                        $dominio,
                        $precio,
                        $costo,
                        $revision_cliente,
                        $terminado,
                        $pagado,
                        $problema,
                        $observaciones
                    ),
                    "data-id-proyecto" => $row['id_proyecto'],
                    "data-terminado" => $row['terminado'],
                    "data-problema" => $row['problema'],
                    "data-dominio" => $row['dominio'],
                    "data-revision-cliente" => $row['revision_cliente']
                );
            }
        }

        if (user_access("web_administrador")) {
            $header_cols = array(
                array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
                array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Dominio", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Precio", "class" => "filter-number col-precio"), "sortable" => 0),
                array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
                array("name" => array("data" => "Revisión Cliente", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Terminado", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Problema", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0)
            );
        } else {
            $header_cols = array(
                array("name" => "Folio", "sortable" => 0),
                array("name" => "Fecha", "sortable" => 0),
                array("name" => "Usuario", "sortable" => 0),
                array("name" => "Cliente", "sortable" => 0),
                array("name" => "Dominio", "sortable" => 0),
                array("name" => "Precio", "sortable" => 0),
                array("name" => "Costo", "sortable" => 0),
                array("name" => "Revisión Cliente", "sortable" => 0),
                array("name" => "Terminado", "sortable" => 0),
                array("name" => "Pagado", "sortable" => 0),
                array("name" => "Problema", "sortable" => 0),
                array("name" => "Obs", "sortable" => 0)
            );
        }

        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $web,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_web", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;

    }

    private function capturar_proyecto($datos)
    {
        global $user;
        $id_proyecto = db_insert('partners_web')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'id_cliente' => $datos->id_cliente,
                'id_contacto' => $datos->id_contacto,
                'dominio' => $datos->dominio_web,
                'trabajo' => $datos->trabajo_web,
                'paquete' => $datos->paquete_web,
                'precio' => strtr($datos->precio_web, array(',' => '')),
                'observaciones' => ($datos->notas_web) ? $this->serialize_obs($datos->notas_web, 1) : null
            ))
            ->execute();
        $this->register_log_actions('partners_web', 'insert', 'Se creó un proyecto Web: ' . $id_proyecto);
        $this->throw_message('success', 'Proyecto Web creado correctamente.');
    }

    private function update_status($datos)
    {
        global $user;
        if ($datos->obs) {
            db_update('partners_web')
                ->fields(array(
                    $datos->col => $datos->new_val,
                    'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_web', 'id_proyecto', $datos->id_proyecto)
                ))
                ->condition('id_proyecto', $datos->id_proyecto)
                ->execute();
        } else {
            db_update('partners_web')
                ->fields(array(
                    $datos->col => $datos->new_val,
                ))
                ->condition('id_proyecto', $datos->id_proyecto)
                ->execute();
        }

        if ($datos->facturado) {
            $this->track_down_facturado($datos->numero_factura, $datos->id_proyecto, "Proyectos Web", "partners_web", $datos->numero_factura);
        }
        $this->register_log_actions('partners_web', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
        $this->throw_message('success', "Cambios Guardados");
    }

    private function eliminar_proyecto($datos)
    {
        db_update('partners_web')
            ->fields(array(
                'proyecto_eliminado' => 1
            ))
            ->condition('id_proyecto', $datos)
            ->execute();
        $this->throw_message('success', 'Eliminado correctamente.');
        $this->register_log_actions('partners_web', 'delete', 'Se eliminó el proyecto web: ' . $datos);
    }

    private function reactivate_proyecto($datos)
    {
        db_update('partners_web')
            ->fields(array(
                'proyecto_eliminado' => 0
            ))
            ->condition('id_proyecto', $datos)
            ->execute();
        $this->throw_message('success', 'Reactivado correctamente.');
        $this->register_log_actions('partners_web', 'update', 'Se reactivó el proyecto web: ' . $datos);
    }

    private function vista_proyecto($id_proyecto)
    {
        $query = db_select('partners_web', 'pw');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pw.id_cliente');
        $query->fields('pw');
        $query->fields('pc', array('nombre_cliente', 'tipo_cliente', 'credito', 'tipo_clasificacion'));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pw.id_contacto');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->addField('pcc', 'tipo_cliente', 'tipo_contacto');
        $query->leftJoin('field_data_field_nombre_completo', 'f', 'f.entity_id = pw.created_by');
        $query->addField('f', 'field_nombre_completo_value', 'nombre_usuario');
        $query->condition('pw.id_proyecto', $id_proyecto);
        $datos = $query->execute()->fetchAssoc();

        $template = render_template('php', 'web.vista_proyecto', $datos);

        $this->throw_message('success', $template);
    }

    /**
     * Reporteador para mostrar todos los dominios.
     * @param $datos
     * @throws Exception
     */
    private function reporte_base_dominios_web($datos)
    {
        $query = db_select('partners_dominios_web', 'pdw');
        $query->fields('pdw');
        $query->condition('dominio_eliminado', 1, '!=');


        if ($datos->filter->search_bar != null || $datos->filter->show_all != null) {
            # Filtro search bar
            if ($datos->filter->search_bar != null) {
                $query->condition('pdw.dominio', '%' . $datos->filter->search_bar . '%', 'LIKE');
            } else if ($datos->filter->show_all == null) return;

            # Si no se pasa nada por el search bar, entonces solo puede entrar hasta aquí mediante el show_all
            $query->orderBy($datos->sort->sort_by, $datos->sort->order);

            $query_datos = $query->execute();

            $web = [];
            # Traer todas las cuentas
            $accountsVPS = $this->get_hosting_accounts(2);
            $accountsReseller = $this->get_hosting_accounts(1);
            $n = 0;
            while ($row = $query_datos->fetchAssoc()) {
                $n++;
                $cPanelHosting = '';
                if ($row['hosting'] == 1) {
                    $cPanelHosting = 'Reseller';
                } else if ($row['hosting'] == 2) {
                    $cPanelHosting = 'VPS';
                } else if ($row['hosting'] == 3) {
                    $cPanelHosting = 'A2Hosting';
                } else if ($row['hosting'] == 4) {
                    $cPanelHosting = 'Otro';
                } else if ($row['hosting'] == 5) {
                    $cPanelHosting = 'Parq';
                }

                /*
                if ($this->is_valid_domain_name($row['dominio'])) {
                    $dominio = array("data" => '<a href="http://' . $row['dominio'] . '" target="_blank">' . $row['dominio'] . '</a>');
                } else {
                    $dominio = array("data" => mb_substr($row['dominio'], 0, 40, "utf-8"));
                }
                */

                $dominio = array("data" => mb_substr($row['dominio'], 0, 40, "utf-8"),
                    "class" => array("cursor-pointer", "vista_datos_cliente"));

                /**
                 * Solo si se tienen los datos de CPanel hacer la consulta.
                 */
                if ($row['hosting'] != '' && $row['hosting_user'] != '') {
                    $gotoCpanel = array("data" => '<i class="fas fa-external-link-alt"></i>', "class" => array("text-center",
                        "cursor-pointer", 'cpanel_create_user_session'));

                    # Buscar el dominio en el hosting que le corresponda y traer la información necesaria.
                    $qw = [0, 0];
                    if ($row['hosting'] == 1) {
                        if ($accountsReseller[$row['dominio']]) {
                            # 0: Disklimit
                            # 1: Diskused
                            $qw = array($accountsReseller[$row['dominio']]['disklimit'], $accountsReseller[$row['dominio']]['diskused']);
                        }
                    } else if ($row['hosting'] == 2) {
                        if ($accountsVPS[$row['dominio']]) {
                            # 0: Disklimit
                            # 1: Diskused
                            $qw = array($accountsVPS[$row['dominio']]['disklimit'], $accountsVPS[$row['dominio']]['diskused']);
                        }
                    }

                    $diskUsedNumber = (filter_var($qw[1], FILTER_SANITIZE_NUMBER_FLOAT) * 100)
                        / (filter_var($qw[0], FILTER_SANITIZE_NUMBER_FLOAT));

                    $classColor = '';
                    if ($diskUsedNumber) {
                        if ($diskUsedNumber > 0 && $diskUsedNumber <= 50) {
                            $classColor = "bg-success";
                        } else if ($diskUsedNumber > 50 && $diskUsedNumber <= 80) {
                            $classColor = "bg-warning";
                        } else if ($diskUsedNumber > 80) {
                            $classColor = "bg-danger";
                        }
                        $diskUsedNumber = ($diskUsedNumber > 100) ? 100 : $diskUsedNumber;
                        $diskUsed = array("data" => $qw[1], "class" => array("progress-bar", "progress-bar-striped", $classColor),
                            "style" => "width: " . $diskUsedNumber . "%");

                    } else {
                        $diskUsed = array("data" => $qw[1]);
                    }

                    $quota = array("data" => $qw[0]);

                    # Enviar correo con url de cPanel
                    $correo = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>',
                        "class" => array("send-cpanel-session", "text-center", "cursor-pointer"));
                } else {
                    $gotoCpanel = array("data" => '<i class="fas fa-external-link-alt"></i>', "class" => array("text-center",
                        "cursor-disabled"), "style" => "opacity: 0.1;");

                    $diskUsed = '';
                    $quota = '';

                    # Enviar correo con url de cPanel
                    $correo = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>',
                        "class" => array("text-center"), "style" => "opacity: 0.1;");
                }

                // Observaciones | Notas internas
                if ($row['observaciones'] != null) {
                    $obs = array("data" => 'Obs', "class" => array("status-yellow", "dominios-observaciones", "text-center", "cursor-pointer"));
                } else {
                    $obs = array("data" => 'Obs', "class" => array("text-center", "dominios-observaciones", "cursor-pointer"));
                }

                if (user_access('web_administrador')) {
                    $eliminar = array("data" => '<i class="fas fa-trash" aria-hidden="true"></i>',
                        "class" => array("eliminar_dominio", "text-center", "cursor-pointer", "text-danger"));
                } else {
                    $eliminar = "";
                }


                $hostingUser = array("data" => $row['hosting_user'], "class" => array("copy_to_clipboard", "cursor-pointer"));
                $hostingPassword = array("data" => $row['hosting_password'], "class" => array("copy_to_clipboard", "cursor-pointer"));
                $cmsUser = array("data" => $row['cms_user'], "class" => array("copy_to_clipboard", "cursor-pointer"));
                $cmsPassword = array("data" => $row['cms_password'], "class" => array("copy_to_clipboard", "cursor-pointer"));


                $editar = array("data" => '<i class="fas fa-pencil-alt"></i>', "class" => array("editar_dominio", "cursor-pointer"));

                $fecha_expira_dominio = date('d/m/Y', $row['fecha_expira_dominio']);
                $fecha_expira_hosting = date('d/m/Y', $row['fecha_expira_hosting']);

                if ($row['dominio_partners'] == 1) {
                    $dominio_partners = array("data" => "Si", "class" => array("text-center"));
                } else {
                    $dominio_partners = array("data" => "No", "class" => array("text-center", "status-red"));
                }

                if ($row['hosting_partners'] == 1) {
                    $hosting_partners = array("data" => "Si", "class" => array("text-center"));
                } else {
                    $hosting_partners = array("data" => "No", "class" => array("text-center", "status-red"));
                }

                if (user_access('web_administrador')) {
                    $web[] = array(
                        "data" => array(
                            $n,
                            $dominio,
                            $dominio_partners,
                            $fecha_expira_dominio,
                            $cPanelHosting,
                            $hosting_partners,
                            ($row['hosting_partners'] == 1) ? $fecha_expira_hosting : '',
                            $quota,
                            $diskUsed,
                            $hostingUser,
                            $hostingPassword,
                            $row['cms'],
                            $cmsUser,
                            $cmsPassword,
                            $gotoCpanel,
                            $obs,
                            $editar,
                            $correo,
                            $eliminar
                        ),
                        "data-hosting" => $row['hosting'],
                        "data-user" => $row['hosting_user'],
                        "data-id" => $row['id_dominio'],
                        "data-dominio" => $row['dominio']
                    );
                } else {
                    $web[] = array(
                        "data" => array(
                            $row['id_dominio'],
                            $dominio,
                            $dominio_partners,
                            $fecha_expira_dominio,
                            $cPanelHosting,
                            $hosting_partners,
                            ($row['hosting_partners'] == 1) ? $fecha_expira_hosting : '',
                            $quota,
                            $diskUsed,
                            $hostingUser,
                            $hostingPassword,
                            $row['cms'],
                            $cmsUser,
                            $cmsPassword,
                            $gotoCpanel,
                            $obs,
                            $editar,
                            $correo,
                        ),
                        "data-hosting" => $row['hosting'],
                        "data-user" => $row['hosting_user'],
                        "data-id" => $row['id_dominio'],
                        "data-dominio" => $row['dominio']
                    );
                }

            }

            if (user_access('web_administrador')) {
                $header_cols = array(
                    array("name" => array("data" => "N°", "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => "Dominio", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Dominio <br/> Partners", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Expira <br/> Dominio", "class" => "filter-date"), "sortable" => 0),
                    array("name" => array("data" => "Hosting", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Hosting <br/> Partners", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Expira <br/> Hosting", "class" => "filter-date"), "sortable" => 0),
                    array("name" => array("data" => "Cuota", "class" => "filter-number"), "sortable" => 0),
                    array("name" => array("data" => "Espacio <br/> Usado", "class" => "filter-number"), "sortable" => 0),
                    array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Contraseña", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "CMS", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "CMS <br/> Usuario", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "CMS <br/> Contraseña", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => 'CPanel', "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => 'Obs', "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fas fa-pencil-alt">', "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fas fa-trash" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
                );
            } else {
                $header_cols = array(
                    array("name" => array("data" => "N°", "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => "Dominio", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Dominio <br/> Partners", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Expira <br/> Dominio", "class" => "filter-date"), "sortable" => 0),
                    array("name" => array("data" => "Hosting", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Hosting <br/> Partners", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Expira <br/> Hosting", "class" => "filter-date"), "sortable" => 0),
                    array("name" => array("data" => "Cuota", "class" => "filter-number"), "sortable" => 0),
                    array("name" => array("data" => "Espacio <br/> Usado", "class" => "filter-number"), "sortable" => 0),
                    array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Contraseña", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "CMS", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "CMS <br/> Usuario", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "CMS <br/> Contraseña", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => 'CPanel', "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => 'Obs', "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fas fa-pencil-alt">', "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
                );
            }


            $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


            $table = array(
                "header" => $header,
                "rows" => $web,
                "sticky" => false,
                "attributes" => array("id" => "table_reporteador_dominio_web", "class" => array("table-sm"))
            );


            $result = theme('table', $table);

            echo $result;

        }


    }

    /**
     * Genera una sesión para abrir el cPanel de una cuenta en especifico.
     * @param $datos
     * @param bool $return , si se pasa el verdadero, se retornara el valor en lugar de un json
     * @param bool $panelCorreo si se pasa verdadero, se generará la sesión directamente en el panel de correos en cPanel.
     * @return mixed
     */
    private function cpanel_create_user_session($datos, $return = false, $panelCorreo = false)
    {
        $tipoHosting = $datos->tipoHosting;
        $userAccount = trim($datos->user);

        if ($tipoHosting == 1) {
            $user = "partners";
            $token = "9STLRYS93A43RGXDZX640QDT4U0PK0KZ";

            # Hostgator
            $query = "https://astra.websitewelcome.com:2087/json-api/create_user_session?api.version=1&user=$userAccount&service=cpaneld&locale=es&preferred_domain=partnersweb.com.mx";

            if ($panelCorreo) {
                $query .= "&app=Email_Accounts";
            }
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

            $header[0] = "Authorization: whm $user:$token";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $query);

            $result = curl_exec($curl);

            $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            if ($http_status != 200) {
                if ($return) {
                    return false;
                } else {
                    $this->throw_message('error', $http_status);
                }
            } else {
                $json = json_decode($result);
                $url = $json->data->url;
                if ($return) {
                    return $url;
                } else {
                    $this->throw_message('success', $url);
                }
            }

            curl_close($curl);

        } else if ($tipoHosting == 2) {
            $user = "root";
            $token = "GA2EVXM7OF438N63SXOGUEYWSZJRX1RQ";

            # VPS
            $query = "https://partnershosting.com:2087/json-api/create_user_session?api.version=1&user=$userAccount&service=cpaneld&locale=es&preferred_domain=partnershosting.com";

            if ($panelCorreo) {
                $query .= "&app=Email_Accounts";
            }

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

            $header[0] = "Authorization: whm $user:$token";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $query);

            $result = curl_exec($curl);

            $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            if ($http_status != 200) {
                if ($return) {
                    return false;
                } else {
                    $this->throw_message('error', curl_error($curl));
                }
            } else {
                $json = json_decode($result);
                $url = $json->data->url;
                if ($return) {
                    return $url;
                } else {
                    $this->throw_message('success', $url);
                }
            }

            curl_close($curl);
        } else {
            $this->throw_message('error', 'No está disponible la función de cPanel con servidor de A2Hosting.');
        }
    }


    /**
     * Metodo para validar que cierta string sea un dominio.
     * @param $domain_name
     * @return bool
     */
    private function is_valid_domain_name($domain_name)
    {
        return (preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*$/i", $domain_name) //valid chars check
            && preg_match("/^.{1,253}$/", $domain_name) //overall length check
            && preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*$/", $domain_name)); //length of each label
    }

    /**
     * Metodo para regresar todas las cuentas del hosting de una forma rápida.
     * @param $tipoHosting
     * @return array
     */
    private function get_hosting_accounts($tipoHosting)
    {
        $accounts = [];
        if ($tipoHosting == 1) {
            $user = "partners";
            $token = "9STLRYS93A43RGXDZX640QDT4U0PK0KZ";

            # Hostgator
            $query = "https://astra.websitewelcome.com:2087/json-api/listaccts?api.version=1&want=disklimit,diskused,domain";

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

            $header[0] = "Authorization: whm $user:$token";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $query);

            $result = curl_exec($curl);

            $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            if ($http_status != 200) {
                echo "error";
                #$this->throw_message('error', $http_status);
            } else {
                $json = json_decode($result);

                foreach ($json->data->acct as $acc) {
                    $accounts[$acc->domain] = array(
                        "disklimit" => $acc->disklimit,
                        "diskused" => $acc->diskused
                    );
                }
            }

            curl_close($curl);

        } else if ($tipoHosting == 2) {
            $user = "root";
            $token = "GA2EVXM7OF438N63SXOGUEYWSZJRX1RQ";

            # VPS
            $query = "https://partnershosting.com:2087/json-api/listaccts?api.version=1&want=disklimit,diskused,domain";

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

            $header[0] = "Authorization: whm $user:$token";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $query);

            $result = curl_exec($curl);

            $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            if ($http_status != 200) {
                echo "error 2";
                #$this->throw_message('error', $http_status);
            } else {
                $json = json_decode($result);

                foreach ($json->data->acct as $acc) {
                    $accounts[$acc->domain] = array(
                        "disklimit" => $acc->disklimit,
                        "diskused" => $acc->diskused
                    );
                }
            }

            curl_close($curl);
        } else {
            #$this->throw_message('error', 'Aún no esta...');
        }

        return $accounts;
    }


    /**
     * Metodo para regresar la vista de un dominio y asi poder editar los valores necesarios.
     * @param $id_dominio
     */
    private function vista_dominio($id_dominio)
    {
        $get_dominio = db_select('partners_dominios_web', 'pdw');
        $get_dominio->fields('pdw');
        $get_dominio->addExpression("CASE pdw.hosting WHEN 1 THEN 'Reseller' WHEN 2 THEN 'VPS' WHEN 3 THEN 'A2Hosting' WHEN 4 THEN 'Otro' WHEN 5 THEN 'Parqueado' END ", 'hosting_nombre');
        $get_dominio->condition('id_dominio', $id_dominio);
        $datos = $get_dominio->execute()->fetchAssoc();

        $template = render_template('php', 'web.vista_dominio', $datos);

        $this->throw_message('success', $template);
    }

    /**
     * Método para capturar a la base de datos un nuevo dominio.
     * @param $datos
     * @throws Exception
     */
    private function capturar_dominio_web($datos)
    {
        global $user;
        $id_dominio = db_insert('partners_dominios_web')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'dominio' => $datos->dominio,
                'hosting_user' => $datos->hosting_user,
                'hosting_password' => $datos->hosting_password,
                'observaciones' => ($datos->observaciones != '') ? $this->serialize_obs($datos->observaciones, 1) : null,
                'hosting' => $datos->hosting,
                'cms' => $datos->cms,
                'cms_user' => $datos->cms_user,
                'cms_password' => $datos->cms_password,
                'dominio_partners' => $datos->dominio_partners
            ))
            ->execute();
        $this->register_log_actions('partners_dominios_web', 'insert', "Se capturó un dominio web con el id: $id_dominio");
        $this->throw_message('success', $id_dominio);
    }

    /**
     * Regresa una lista con los correos de todos los usuarios en el Rol de Soporte.
     */
    private function get_emails_soporte()
    {
        $role = user_role_load_by_name('Soporte');
        $query = 'SELECT ur.uid
        FROM {users_roles} AS ur
        WHERE ur.rid = :rid';
        $result = db_query($query, array(':rid' => $role->rid));
        $uids = $result->fetchCol();

        $usuarios = db_select('users', 'u')
            ->fields('u', array('mail', 'name'))
            ->condition('status', 1)
            ->condition('uid', $uids, 'IN')
            ->condition('uid', 26, '!=')
            ->orderBy('name', 'ASC')
            ->execute()->fetchAll(PDO::FETCH_ASSOC);

        $this->throw_message('success', $usuarios);
    }

    /**
     * Método para generar una sesión en cPanel, y enviarla por correo a un técnico en especifico.
     * @param $datos
     * @throws Exception
     */
    private function send_cpanel_session($datos)
    {
        global $user;
        # Generar el link de la sesión.
        $sessionUrl = $this->cpanel_create_user_session($datos, true, true);

        if ($sessionUrl) {
            $from = [$user->mail => 'Pc Partners - Acceso a cPanel'];
            $to = [$datos->correo];
            $subject = "Acceso a cPanel del dominio $datos->dominio";
            $data_to_render = [];
            $data_to_render['url'] = $sessionUrl;
            $data_to_render['dominio'] = $datos->dominio;
            $this->send_mail('web.mail_enviar_session_cpanel', $data_to_render, $subject, $from, $to);
            $this->register_log_actions('partners_dominios_web', 'mail', "Se envió una sesión de cPanel a $datos->correo del dominio $datos->dominio");
            $this->throw_message('success', 'Se ha enviado correctamente la sesión de cPanel al técnico seleccionado.');
        } else {
            $this->throw_message('error', "No se pudo generar una sesión en cPanel en el dominio $datos->dominio");
        }
    }

    /**
     * Método para eliminar (cancelar) un dominio web.
     * @param $datos
     * @throws Exception
     */
    private function eliminar_dominio_web($datos)
    {
        db_update('partners_dominios_web')
            ->fields(array(
                'dominio_eliminado' => 1
            ))
            ->condition('id_dominio', $datos->id_dominio)
            ->execute();

        $this->register_log_actions('partners_dominios_web', 'update', "Se eliminó el id_dominio: $datos->id_dominio");
        $this->throw_message('success', 'Dominio eliminado!');
    }

    /**
     * Método para generar una vista con datos del cliente.
     * @param $id_dominio
     */
    private function vista_datos_cliente($id_dominio)
    {
        # Traer el token
        $get_token = db_select('partners_dominios_web', 'pdw');
        $get_token->addField('pdw', 'token_relacion_renovacion');
        $get_token->condition('id_dominio', $id_dominio);
        $token = $get_token->execute()->fetchField();

        if (!$token) {
            $this->throw_message('error',
                'No está vínculado el dominio con un cliente del sistema por lo tanto no se puede mostrar información');
        } else {
            # Buscar una renovación con ese token y traer el id_cliente y id_contacto
            $get_renovacion = db_select('partners_renovaciones', 'pr');
            $get_renovacion->fields('pr', array('id_cliente', 'id_contacto'));
            $get_renovacion->condition('pr.token_relacion_renovacion', '%' . $token . '%', 'LIKE');
            $get_renovacion->range(0, 1);
            $info = $get_renovacion->execute()->fetchAssoc();

            $get_cliente = db_select('partners_clientes', 'pc');
            $get_cliente->fields('pc', array('nombre_cliente', 'tipo_clasificacion', 'credito', 'id_cliente', 'tipo_cliente'));
            $get_cliente->condition('id_cliente', $info['id_cliente']);
            $cliente = $get_cliente->execute()->fetchAssoc();

            $get_contacto = db_select('partners_clientes', 'pc');
            $get_contacto->addField('pc', 'nombre_cliente', 'nombre_contacto');
            $get_contacto->addField('pc', 'id_cliente', 'id_contacto');
            $get_contacto->addField('pc', 'tipo_cliente');
            $get_contacto->innerJoin('partners_clientes_datos', 'pce', 'pce.id_cliente = pc.id_cliente AND pce.tipo_dato = 1');
            $get_contacto->addField('pce', 'dato_valor', 'telefono_contacto');
            $get_contacto->innerJoin('partners_clientes_datos', 'pct', 'pct.id_cliente = pc.id_cliente AND pct.tipo_dato = 3');
            $get_contacto->addField('pct', 'dato_valor', 'email_contacto');
            $get_contacto->condition('pc.id_cliente', $info['id_contacto']);
            $contacto = $get_contacto->execute()->fetchAssoc();

            $datos['cliente'] = $cliente;
            $datos['contacto'] = $contacto;

            $tpl = render_template('php', 'web.vista_datos_cliente', $datos);
            $this->throw_message('success', $tpl);
        }
    }
}
