<?php

class user_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'change_nip':
                    try {
                        $this->change_nip($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'change_nip');
                    }
                    break;
                case 'create_nip':
                    try {
                        $this->create_nip($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'create_nip');
                    }
                    break;
                case 'generar_orden':
                    try {
                        $this->generar_orden($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'generar_orden');
                    }
                    break;
                case 'process_paypal_payment_payout':
                    try {
                        $this->process_paypal_payment_payout($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'process_paypal_payment_payout');
                    }
                    break;
                case 'process_payu_payment_payout':
                    try {
                        $this->process_payu_payment_payout($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'process_payu_payment_payout');
                    }
                    break;
                case 'get_pendientes_user':
                    try {
                        $this->get_pendientes_user($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'get_pendientes_user');
                    }
                    break;
            }
        }
    }

    private function change_nip($datos)
    {
        global $user;
        $current_pass = db_select('partners_users_auth', 'pua')
            ->fields('pua', array('nip'))
            ->condition('uid', $user->uid)
            ->execute()->fetchField();
        $against = array("pass" => $current_pass);
        $against = (object)$against;
        if (!user_check_password($datos->current_nip, $against)) {
            $this->throw_message('error', 'NIP Actual incorrecto, intenta de nuevo');
        } else {

            // Validar que no se repita el NIP con uno ya existente
            if (self::auth_user_nip($datos->new_nip)) {
                $this->throw_message('error', 'El nuevo NIP que trataste de ingresar ya esta en uso, intenta con uno diferente.');
            } else {
                db_update('partners_users_auth')
                    ->fields(array(
                        'nip' => user_hash_password($datos->new_nip)
                    ))
                    ->condition('uid', $user->uid)
                    ->execute();

                $this->throw_message('success', 'NIP Cambiado correctamente.');
            }
        }
    }

    private function create_nip($datos)
    {
        global $user;
        // Validar que no se exista el NIP.
        if (self::auth_user_nip($datos->new_nip)) {
            $this->throw_message('error', 'El nuevo NIP que trataste de ingresar ya esta en uso, intenta con uno diferente.');
        } else {
            db_insert('partners_users_auth')
                ->fields(array(
                    'nip' => user_hash_password($datos->new_nip),
                    'uid' => $user->uid
                ))
                ->execute();

            $this->throw_message('success', 'NIP Cambiado correctamente.');
        }
    }


    /**
     * Genera una orden de pago (PayPal o Conekta) por una cantidad y descripción establecidad por el usuario.
     * Se guardará el registro de estas ordenes en el panel de prepago.
     * @param $datos
     * @throws Exception
     */
    private function generar_orden($datos)
    {
        global $user;
        $emails = $datos->emails;
        $total = (float)$datos->cantidad_orden;
        $desc_orden = $datos->descripcion_orden;

        // Registrar orden
        $id_orden = db_insert('partners_prepago_ordenes')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'id_cliente' => $datos->id_cliente,
                'id_contacto' => (!$datos->id_contacto) ? 0 : $datos->id_contacto,
                'tipo_servicio' => 0, // 0 porque esta orden no se dará seguimiento con reportes de servicio
                'fecha_servicio' => 0, // 0 porque esta orden no se dará seguimiento con reportes de servicio,
                'descripcion_servicio' => $desc_orden,
                'horas_prepagadas' => 0, // 0 porque esta orden no se dará seguimiento con reportes de servicio
                'metodo_pago' => 0, // 0 Porque no se sabe con que metodo de pago pagarán
                'total' => $total,
                'id_pendiente' => 0
            ))
            ->execute();

        $this->register_log_actions('partners_prepago_ordenes', 'insert', " Se capturó una orden de pago (id_orden: $id_orden) para  $datos->emails por un total de $total");


        // Generar orden

        $token = self::encrypt_decrypt('encrypt', $id_orden);


        if ($datos->id_contacto != 0) {
            // Si existe contacto, usar el nombre de este mismo
            $get_nombre_contacto = db_select('partners_clientes', 'pc');
            $get_nombre_contacto->fields('pc', array('nombre_cliente'));
            $get_nombre_contacto->condition('id_cliente', $datos->id_contacto);
            $quien_reporta = $get_nombre_contacto->execute()->fetchField();

            $get_email_contacto = db_select('partners_clientes', 'pc');
            $get_email_contacto->fields('pc', array('email'));
            $get_email_contacto->condition('id_cliente', $datos->id_contacto);
            $email_cliente = $get_email_contacto->execute()->fetchField();
        } else {
            // Usar el nombre del cliente particular
            $get_nombre_cliente = db_select('partners_clientes', 'pc');
            $get_nombre_cliente->fields('pc', array('nombre_cliente'));
            $get_nombre_cliente->condition('id_cliente', $datos->id_cliente);
            $quien_reporta = $get_nombre_cliente->execute()->fetchField();

            $get_email_cliente = db_select('partners_clientes', 'pc');
            $get_email_cliente->fields('pc', array('email'));
            $get_email_cliente->condition('id_cliente', $datos->id_cliente);
            $email_cliente = $get_email_cliente->execute()->fetchField();
        }


        // Generar orden PayPal

        define('SITE_URL', 'https://www.pcpartners.com.mx/payout/process_paypal');

        // Producción
        $paypal = new PayPal\Rest\ApiContext(
            new PayPal\Auth\OAuthTokenCredential(
                'AWUdeKiLv1GgTtCM5XbtIZ6CCGXSjKNUZw9sUHhHVejZ9DI0HePnGWrsdeInwg2juZIi0bNzXU13Wj--',
                'ELw5LfNe7371hmfaD8B4KE4HsAa4FPKIfBWnfnwshissIeqVauIVZxcvVzoitooq4VjkjcoJOwz-y02K'
            )
        );


        $paypal->setConfig(array(
            'mode' => 'live'
        ));


        /*
        // SandBox
        $paypal = new PayPal\Rest\ApiContext(
            new PayPal\Auth\OAuthTokenCredential(
                'AY-8BHaCQktZekeExW8Fufq_1_LdTHcackrDzCxWkIiDzWqPR8e5fZiF1RI7XEJ38FW7Sv55D1yOvsU7',
                'EK5aub3DjoE4AyzR709gNEEeS9gzI8PB64uhjyDWd-a-Rmc65xqzm2XdzqIPfwFbzoU-GT6igT2_6zLo'
            )
        );


        $paypal->setConfig(array(
            'mode' => 'live'
        ));
        */


        $flowConfig = new \PayPal\Api\FlowConfig();
        $flowConfig->setLandingPageType("Billing");
        $flowConfig->setBankTxnPendingUrl("https://www.pcpartners.com.mx/");
        $flowConfig->setUserAction("commit");

        $presentation = new \PayPal\Api\Presentation();
        $presentation->setLogoImage("https://www.pcpartners.com.mx/sites/default/files/pcpartners_payments_logo.jpg")
            ->setBrandName("PC PARTNERS")
            ->setLocaleCode("MX")
            ->setReturnUrlLabel("Regresar")
            ->setNoteToSellerLabel("PC PARTNERS");

        $inputFields = new \PayPal\Api\InputFields();

        $inputFields->setAllowNote(true)
            ->setNoShipping(1)
            ->setAddressOverride(0);

        $webProfile = new \PayPal\Api\WebProfile();
        $webProfile->setName("Pc Partners Cobro en Línea" . uniqid())
            ->setFlowConfig($flowConfig)
            ->setPresentation($presentation)
            ->setInputFields($inputFields)
            ->setTemporary(true);

        try {
            $createProfileResponse = $webProfile->create($paypal);
        } catch (Exception $ex) {
            die($ex);
        }


        $product = "Cobro en Línea";
        $price = (float)$total;
        $shipping = 0.00;

        $total = $price + $shipping;

        $payer = new \PayPal\Api\Payer();
        $payer->setPaymentMethod('paypal');

        $item = new \PayPal\Api\Item();
        $item->setName($product)
            ->setCurrency('MXN')
            ->setQuantity(1)
            ->setPrice($price);

        $itemList = new \PayPal\Api\ItemList();
        $itemList->setItems([$item]);

        $details = new \PayPal\Api\Details();
        $details->setShipping($shipping)
            ->setSubtotal($price);

        $amount = new \PayPal\Api\Amount();
        $amount->setCurrency('MXN')
            ->setTotal($total)
            ->setDetails($details);

        $transaction = new \PayPal\Api\Transaction();
        $transaction->setAmount($amount)
            ->setItemList($itemList)
            ->setDescription($desc_orden)
            ->setInvoiceNumber(uniqid());


        $redirectUrls = new \PayPal\Api\RedirectUrls();
        $redirectUrls->setReturnUrl(SITE_URL . '?success=true&tokenPartners=' . $token)
            ->setCancelUrl(SITE_URL . '?success=false');
        $payment = new \PayPal\Api\Payment();
        $payment->setIntent('sale')
            ->setPayer($payer)
            ->setRedirectUrls($redirectUrls)
            ->setExperienceProfileId($createProfileResponse->getId())
            ->setTransactions([$transaction]);

        try {
            $payment->create($paypal);
        } catch (Exception $e) {
            die($e);
        }

        $approvalUrl = $payment->getApprovalLink();
        $checkout_url_paypal = $approvalUrl;

        //URL Conekta

      // Generar URL de Conekta
      $precioConekta = (int)($total * 100);
      $clienteEmail = "";
      foreach ($emails as $address => $name) {
        if (is_int($address)) {
          $clienteEmail = $name;
        } else {
          $clienteEmail = $address;
        }
        break;
      }
      $validCheckout = [
        'name' => "Orden de pago",
        'type' => "PaymentLink",
        'recurrent' => false,
        'expired_at' => strtotime("now+30day"),
        'allowed_payment_methods' => ["card"],
        'needs_shipping_contact' => false,
        'monthly_installments_enabled' => false,
        'monthly_installments_options' => [],
        'order_template' => [
          'line_items' => [[
            'name' => $desc_orden,
            'unit_price' => $precioConekta,
            'quantity' => 1
          ]],
          'metadata' => [
            'tipo' => "prepago",
            'folio' => (int)$id_orden
          ],
          'currency' => "MXN",
          'customer_info' => [
            'name' => $quien_reporta,
            'email' => $clienteEmail,
            'phone' => "0000000000"
          ]
        ]
      ];
      $ch = curl_init('https://api.conekta.io/checkouts');
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array(
          "accept: application/vnd.conekta-v2.0.0+json",
          "content-type: application/json"
        )
      );
      curl_setopt($ch, CURLOPT_USERNAME, "key_pbwBpwHxGfHNArWoxp8Dsw"); //Pruebas
      curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($validCheckout));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      $response = curl_exec($ch);
      if($response === false) {
        $this->throw_message('error', curl_errno($ch));
        return;
      }
      $response = json_decode($response);
      curl_close($ch);
      $conekta_url = $response->url;

      //.


        // Enviar los correos

        // Enviar correo
        $to = $emails;
        $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
        # $transport = new Swift_SendmailTransport();
        # $mailer = new Swift_Mailer($transport);


        $data['nombre_cliente'] = $quien_reporta;
        $data['url_paypal'] = $checkout_url_paypal;
        $data['url_conekta'] = $conekta_url;
        $data['total'] = $total;
        $data['descripcion'] = $desc_orden;
        $this->send_mail('user.mail_solicitar_pago', $data, 'Orden de Pago', $from, $to, null, null);

        /*
        $body = render_template('php', 'user.mail_solicitar_pago', $data);
        $message = (new Swift_Message())
            ->setSubject('Le solicitamos que realice un pago en línea!')
            ->setFrom($from)
            ->setBody($body, 'text/html');
        $failedRecipients = [];
        $numSent = 0;

        foreach ($to as $address => $name) {
            if (is_int($address)) {
                $message->setTo($name);
            } else {
                $message->setTo([$address => $name]);
            }
            $this->register_log_actions('partners_prepago_ordenes', 'email', "Se envió una solicitud de dinero (orden de pago: $id_orden) a: $address");
            $numSent += $mailer->send($message, $failedRecipients);
        }
        */


        $this->throw_message('success', 'Orden de pago generadad correcatamente.');
    }

    /**
     * Una vez que paypal regrese success en la transacción, hay que cobrarla al cliente y hacer el proceso interno necesario.
     * @param $datos
     * @return bool
     */
    private function process_paypal_payment_payout($datos)
    {

        $paypal = new PayPal\Rest\ApiContext(
            new PayPal\Auth\OAuthTokenCredential(
                'AWUdeKiLv1GgTtCM5XbtIZ6CCGXSjKNUZw9sUHhHVejZ9DI0HePnGWrsdeInwg2juZIi0bNzXU13Wj--',
                'ELw5LfNe7371hmfaD8B4KE4HsAa4FPKIfBWnfnwshissIeqVauIVZxcvVzoitooq4VjkjcoJOwz-y02K'
            )
        );


        $paypal->setConfig(array(
            'mode' => 'live'
        ));

        $payment = \PayPal\Api\Payment::get($datos->paymentID, $paypal);

        $execute = new \PayPal\Api\PaymentExecution();
        $execute->setPayerId($datos->payerID);

        try {
            $result = $payment->execute($execute, $paypal);
            $email_paypal_transaction_approved = $result->getPayer()->getPayerInfo()->getEmail();
            // Generar datos para correo
            $id_orden = encrypt_decrypt('decrypt', $datos->tokenPartners);

            $get_orden = db_select('partners_prepago_ordenes', 'ppo');
            $get_orden->fields('ppo');
            $get_orden->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = ppo.id_cliente');
            $get_orden->fields('pc', array(
                'nombre_cliente', 'email'
            ));
            $get_orden->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = ppo.id_contacto');
            $get_orden->addField('pcc', 'nombre_cliente', 'nombre_contacto');
            $get_orden->addField('pcc', 'email', 'email_contacto');
            $get_orden->condition('ppo.id_orden', $id_orden);
            $orden = $get_orden->execute()->fetchAssoc();


            // Procesar en orden de prepago
            db_update('partners_prepago_ordenes')
                ->fields(array(
                    'pagado' => 2, // PayPal
                    'observaciones' => $this->serialize_obs("Se marcó  la orden como pagada automáticamente debido a la confirmación del pago por parte de PayPal", 2, 'partners_prepago_ordenes', 'id_orden', $id_orden, 'Sistema'),
                    'pagado_user' => 0 // No fue ningún usuario, fue el sistema.
                ))
                ->condition('id_orden', $id_orden)
                ->execute();

            $this->register_log_actions('partners_prepago_ordenes', 'update', 'Se marcó la orden de prepago(' . $id_orden . ') como pagada automáticamente debido a la confirmación del pago por parte de PayPal.');


            // Enviar correo al correo que regresa PayPal
            $to = [$email_paypal_transaction_approved];

            $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
            $transport = new Swift_SendmailTransport();
            $mailer = new Swift_Mailer($transport);

            $data['orden'] = $orden;
            $data['metodo_pago'] = "PayPal";
            $body = render_template('php', 'user.mail_confirmacion_pago_payout', $data);
            $message = (new Swift_Message())
                ->setSubject('Su pago ha sido aprobado exitosamente!')
                ->setFrom($from)
                ->setBody($body, 'text/html');
            $failedRecipients = [];
            $numSent = 0;

            foreach ($to as $address => $name) {
                if (is_int($address)) {
                    $message->setTo($name);
                } else {
                    $message->setTo([$address => $name]);
                }
                $numSent += $mailer->send($message, $failedRecipients);
            }


        } catch (Exception $e) {
            $this->throw_message('error', "Ocurrio un error al procesar el pago");
            return false;
        }

        $this->throw_message('success', 'Payment charged');
    }


    /**
     * Procesa los datos que regresa payU, cae aquí solamente cuando la transacción ha sido aprobada.
     * @param $datos
     * @throws Exception
     * @deprecated Ya no se usa PayU
     */
    private function process_payu_payment_payout($datos)
    {
        $id_orden = encrypt_decrypt('decrypt', $datos['id_orden']);


        $get_orden = db_select('partners_prepago_ordenes', 'ppo');
        $get_orden->fields('ppo');
        $get_orden->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = ppo.id_cliente');
        $get_orden->fields('pc', array(
            'nombre_cliente', 'email'
        ));
        $get_orden->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = ppo.id_contacto');
        $get_orden->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $get_orden->addField('pcc', 'email', 'email_contacto');
        $get_orden->condition('ppo.id_orden', $id_orden);
        $orden = $get_orden->execute()->fetchAssoc();


        // Método de Pago, se está procesando paypal entonces obviamente es paypal.
        $data['metodo_pago'] = $datos['metodo_pago'];

        $data['orden'] = $orden;


        // Procesar en orden de prepago
        db_update('partners_prepago_ordenes')
            ->fields(array(
                'pagado' => 3, // PayU
                'observaciones' => $this->serialize_obs("Se marcó  la orden como pagada automáticamente debido a la confirmación del pago por parte de PayU, pago con el método de pago: " . $datos['metodo_pago'], 2, 'partners_prepago_ordenes', 'id_orden', $id_orden, 'Sistema'),
                'pagado_user' => 0 // No fue ningún usuario, fue el sistema.
            ))
            ->condition('id_orden', $orden['id_orden'])
            ->execute();

        $this->register_log_actions('partners_prepago_ordenes', 'update', 'Se marcó la orden de prepago(' . $id_orden . ') como pagada automáticamente debido a la confirmación del pago por parte de PayU.');

        // Enviar correo al correo que regreso payU
        $to = [$datos['email_buyer']];
        $data['email_cliente'] = $datos['email_buyer'];
        $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];


        $this->send_mail('user.mail_confirmacion_pago_payout', $data, 'Su pago ha sido aprobado exitosamente!', $from, $to);
    }

    /**
     * Busca todos los pendientes activos asignados al usuario desde el inicio de los tiempos hasta dentro de 5 días futuros.
     * @param $uid
     * @return mixed
     */
    public function get_pendientes_user($uid)
    {
        $date_pendiente = strtotime('+5 days');
        $get_pendientes = db_select('partners_pendientes', 'pp');
        $get_pendientes->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pp.id_cliente');
        $get_pendientes->fields('pc', array('nombre_cliente'));
        $get_pendientes->fields('pp', array('id_pendiente', 'descripcion_pendiente', 'fecha_pendiente'));
        $get_pendientes->condition('pp.asignado_para', $uid);
        $get_pendientes->condition('pp.fecha_pendiente', $date_pendiente, '<');
        $get_pendientes->condition('pp.status', 1);
        $get_pendientes->condition('pp.cancelado', 0);
        $get_pendientes->orderBy('pp.fecha_pendiente','ASC');
        $pendientes = $get_pendientes->execute()->fetchAll(PDO::FETCH_ASSOC);

        return $pendientes;
    }
}
