<?php

class taller_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'reporte_base_trabajo':
                    try {
                        $this->reporte_base_trabajo($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base_vista_trabajo');
                    }
                    break;
                case 'capturar_registro':
                    try {
                        $this->capturar_registro($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_nueuvo_registro_equipo');
                    }
                    break;
                case 'vista_datos_generales':
                    try {
                        $this->vista_datos_generales($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'generar_vista_datos_generales');
                    }
                    break;
                case 'vista_revision_inicial':
                    try {
                        $this->vista_revision_inicial($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'generar_vista_revision_inicial');
                    }
                    break;
                case 'capturar_revision_inicial':
                    try {
                        $this->capturar_revision_inicial($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_revision_inicial');
                    }
                    break;
                case 'vista_presupuesto':
                    try {
                        $this->vista_presupuesto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'generar_vista_presupuesto');
                    }
                    break;
                case 'capturar_presupuesto_inicial':
                    try {
                        $this->capturar_presupuesto_inicial($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_presupuesto_inicial');
                    }
                    break;
                case 'render_vista':
                    try {
                        $this->render_reporte($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'render_vista_reporte');
                    }
                    break;
                case 'enviar_presupuesto_correo':
                    try {
                        $this->enviar_presupuesto_correo($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'enviar_presupuesto_correo');
                    }
                    break;
                case 'editar_presupuesto_inicial':
                    try {
                        $this->editar_presupuesto_inicial($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'editar_presupuesto_inicial');
                    }
                    break;
                case 'autorizar_presupuesto':
                    try {
                        $this->autorizar_presupuesto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'autorizar_presupuesto');
                    }
                    break;
                case 'editar_presupuesto_autorizado':
                    try {
                        $this->editar_presupuesto_autorizado($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'editar_presupuesto_autorizado');
                    }
                    break;
                case 'enviar_presupuesto_correo_autorizado':
                    try {
                        $this->enviar_presupuesto_correo_autorizado($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'enviar_presupuesto_correo_autorizado');
                    }
                    break;
                case 'no_autorizar_presupuesto':
                    try {
                        $this->no_autorizar_presupuesto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'no_autorizar_presupuesto');
                    }
                    break;
                case 'vista_proceso':
                    try {
                        $this->vista_proceso($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_proceso');
                    }
                    break;
                case 'capturar_proceso':
                    try {
                        $this->capturar_proceso($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_proceso');
                    }
                    break;
                case 'vista_revision_final':
                    try {
                        $this->vista_revision_final($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_revision_final');
                    }
                    break;
                case 'capturar_revision_final':
                    try {
                        $this->capturar_revision_final($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_revision_final');
                    }
                    break;
                case 'capturar_entregado':
                    try {
                        $this->capturar_entregado($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_entregado');
                    }
                    break;
                case 'vista_general_completa':
                    try {
                        $this->vista_general_completa($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_general_completa');
                    }
                    break;
                case 'update_status':
                    try {
                        $this->update_status($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_status_reporteador_admin');
                    }
                    break;
                case 'modificacion_costos':
                    try {
                        $this->modificacion_costos($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'modificacion_costos');
                    }
                    break;
                case 'reporte_base_buscador':
                    try {
                        $this->reporte_base_buscador($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base_buscador');
                    }
                    break;
                case 'marcar_facturado':
                    try {
                        $this->marcar_facturado($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'marcar_facturado');
                    }
                    break;
                case 'status_especial':
                    try {
                        $this->status_especial($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'status_especial');
                    }
                    break;
                case 'status_problema':
                    try {
                        $this->status_problema($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'status_problema');
                    }
                    break;
            }
        }
    }


    private function reporte_base($datos)
    {
        global $user;
        $totalP = 0;
        $totalC = 0;
        $diffTotal = false;
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $query = db_select('partners_taller', 'pt');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pt.id_cliente');
        $query->fields('pc', array('nombre_cliente', 'tipo_clasificacion'));
        $query->innerJoin('partners_taller_equipos', 'pte', 'pte.id_registro_taller = pt.id_registro');
        $query->fields('pte');
        $query->fields('pt');
        $query->addField('pt', 'created_at', 'fecha_creacion_registro');
        $query->leftJoin('partners_taller_presupuesto', 'ptp', 'ptp.id_registro_taller = pt.id_registro');
        $query->fields('ptp', array('fecha_compromiso', 'que_hacer'));
        $query->addField('ptp', 'created_at', 'fecha_creacion_presupuesto');
        $query->leftJoin('partners_taller_revisiones', 'ptr', 'ptr.id_registro_taller = pt.id_registro AND tipo_revision = 3');
        $query->addField('ptr', 'created_at', 'fecha_terminacion');
        $query->addField('ptr', 'created_by', 'usuario_finalizo');
        //$query->innerJoin('users', 'u', 'u.uid = pt.created_by');
        //$query->addField('u', 'name', 'usuario_creacion');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;

            if ($datos->filter->start_date) {
                if ($datos->filter->tipo_fecha == 1) { // 1: Fecha terminado, 0: Fecha creación
                    $query->condition('ptr.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
                } else {
                    $query->condition('pt.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
                }
            }
        } else {
            if ($datos->filter->start_date) {
                if ($datos->filter->tipo_fecha == 1) { // 1: Fecha terminado, 0: Fecha creación
                    $query->condition('ptr.created_at', array($f_inicio, $f_final), 'BETWEEN');
                } else {
                    $query->condition('pt.created_at', array($f_inicio, $f_final), 'BETWEEN');
                }
            }
        }

        if (user_has_role(user_role_load_by_name('Auxiliar')->rid) || user_has_role(user_role_load_by_name('Supervisor')->rid)) {
            $supervisor = true;
            if ($datos->filter->tecnico != 0) {
                $query->condition('ptr.created_by', $datos->filter->tecnico);
            }
        } else {
            $supervisor = false;
            $query->condition('ptr.created_by', $user->uid);
        }

        if ($datos->filter->no_facturado) {
            $query->condition('pt.facturado', 0);
            $query->condition('pt.presupuesto', 3, '!=');
        }

        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $taller_or = db_or()
                ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pt.descripcion_problema', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $query->condition($taller_or);
        }

        $query->condition('pt.servicio_abierto', 1, '!=');
        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        $n = 0;
        while ($row = $query_datos->fetchAssoc()) {
            if ($datos->filter->falta_costo != 0) {
                $v = db_select('partners_taller_presupuesto_datos', 'ptpd')
                    ->fields('ptpd', array('id_presupuesto'))
                    ->condition('id_presupuesto', $row['id_presupuesto'])
                    ->condition('costo', 0)
                    ->condition('tipo', 1)
                    ->condition('autorizacion', 1)
                    ->execute()->fetchField();
                if (!$v)
                    continue;
            }
            // registrado por
            //$usuario_registro = array("data" => $row['usuario_creacion'], "class" => array("cursor-pointer", "vista_general_completa"));

            $fecha_creacion = array("data" => date('d/m/y', $row['fecha_creacion_registro']), "class" => array("cursor-pointer", "vista_general_completa"));
            $fecha_terminacion = date('d/m/y', $row['fecha_terminacion']);
            $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 16, "utf-8"), "class" => array("cursor-pointer", "vista_general_completa"));
            $usuario_finalizo = array("data" => user_load($row['usuario_finalizo'])->name);
            # Hardcoded
            # 14/08/18 ultimo folio 10906
            if ($row['id_registro'] > 10906) {
                $folio = array("data" => strtoupper($row['tipo_clasificacion']) . '-' . $row['id_registro'], "class" => array("cursor-pointer", "vista_general_completa", ($row['servicio_garantia'] ? 'status-yellow' : '')));
            } else {
                $folio = array("data" => $row['id_registro'], "class" => array("cursor-pointer", "vista_general_completa", ($row['servicio_garantia'] ? 'status-yellow' : '')));
            }
            $tipo_equipo_id = $row['tipo_equipo'];
            switch ($tipo_equipo_id) {
                case 1:
                    $tipo_equipo = 'CPU';
                    break;
                case 2:
                    $tipo_equipo = 'Todo en uno';
                    break;
                case 3:
                    $tipo_equipo = 'Laptop';
                    break;
                case 4:
                    $tipo_equipo = 'Servidor';
                    break;
                case 5:
                    $tipo_equipo = 'Impresora';
                    break;
                case 6:
                    $tipo_equipo = 'Monitor';
                    break;
                case 7:
                    $tipo_equipo = 'Tablet';
                    break;
                case 8:
                    $tipo_equipo = 'Celular';
                    break;
                case 9:
                    $tipo_equipo = 'Otro';
                    break;
            }

            $equipo = array("data" => $tipo_equipo . ' | ' . $row['marca_equipo'] . ' | ' . $row['modelo_equipo'], "class" => array("cursor-pointer", "vista_general_completa"));
            $problema = array("data" => mb_substr($row['descripcion_problema'], 0, 30, "utf-8"), "class" => array("cursor-pointer", "vista_general_completa"));

            // +++++++++++++ FECA COMPROMISO ++++++++++++++++++
            if ($row['presupuesto'] == 3) {
                $fecha_compromiso = array("data" => "No Aut", "class" => array("status-red", "text-center"));
            } else {
                if ($row['fecha_compromiso'] != 0) {
                    if ($row['fecha_terminacion'] > $row['fecha_compromiso']) {
                        $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']), "class" => "status-yellow");
                    } else {
                        $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']));
                    }
                } else { // aun no existe
                    $fecha_compromiso = 'Pendiente';
                }
            }
            // +++++++++++++ FECHA COMPROMISO ++++++++++++++++++


            if ($row['status_especial'] == 0) {
                if ($supervisor) {
                    $especial = array("data" => '', "class" => array("status_especial", "text-center", "cursor-pointer"));
                } else {
                    $especial = array("data" => '', "class" => array("text-center"));
                }
            } else if ($row['status_especial'] == 1) {
                if ($supervisor) {
                    $especial = array("data" => '<i class="fas fa-exclamation-triangle"></i>', "class" => array("status_especial", "text-center", "cursor-pointer", "text-danger"));
                } else {
                    $especial = array("data" => '<i class="fas fa-exclamation-triangle"></i>', "class" => array("text-center", "text-danger"));
                }
            }

            // +++++++++++++ OBSERVACIONES ++++++++++++++++++
            if ($row['observaciones'] != null) {
                $observaciones = array("data" => 'Bitácora', "class" => array(($row['status_especial'] == 1) ? "status-red" : "status-yellow", "taller-observaciones", "cursor-pointer", "text-center"));
            } else {
                $observaciones = array("data" => 'Bitácora', "class" => array("taller-observaciones", "cursor-pointer", "text-center"));
            }
            // +++++++++++++ OBSERVACIONES ++++++++++++++++++

            // +++++++++++++++ ENTREGADO ++++++++++++++++++++
            $entregado = $row['servicio_entregado'];
            if ($row['presupuesto'] == 3 && $row['que_hacer'] == 2) {
                $servicio_entregado = array("data" => "X Recoger", "class" => array("text-center"));
            } else {
                if ($row['revision_final'] != 0) {
                    if ($entregado == 0) {
                        if ($row['tipo_servicio'] == 1) {
                            $servicio_entregado = array("data" => "X Recoger", "class" => array("text-center"));
                        }
                    } else if ($entregado == 1) {
                        $servicio_entregado = array("data" => "Entregado", "class" => array("status-green", "text-center"));
                    } else if ($entregado == 2) {
                        $servicio_entregado = array("data" => "Programar", "class" => array("status-yellow", "text-center"));
                    }
                } else {
                    $servicio_entregado = array("data" => "ND", "class" => array("cursor-disabled", "text-center"));
                }
            }
            // +++++++++++++++ ENTREGADO ++++++++++++++++++++

            // +++++++++++++++ COSTO PIEZAS ++++++++++++++++++++

            if ($row['presupuesto'] == 0) { // no se ha realizado el presupuesto
                $costoL = 'Pendiente';
                $costo_number = 0;
            } else if ($row['presupuesto'] == 1) { // esta pendiente la autorización del costo
                $costoL = array("data" => "0.00", "class" => "text-right");
                $costo_number = 0;
            } else if ($row['presupuesto'] == 2) { // si ya se hizo el presupuesto y se autorizo
                $costo = self::total_servicio_taller($row['id_presupuesto'], 3);
                if ($costo === 'no_piezas') { // Si no se registraron piezas
                    $costoL = array("data" => "0.00", "class" => "text-right");
                    $costo_number = 0;
                } else if ($costo == 0) { // si regreso un 0, significa que los costos estan incompletos
                    if ($supervisor) {
                        $costoL = array("data" => number_format($costo, 2, '.', ','), "class" => array("status-yellow", "text-right", "status_costo", "cursor-pointer"));
                    } else {
                        $costoL = array("data" => number_format($costo, 2, '.', ','), "class" => array("status-yellow", "text-right"));
                    }
                    $costo_number = 0;
                } else { // regreso el costo total
                    $costo_number = $costo;
                    if ($supervisor) {
                        $costoL = array("data" => number_format($costo, 2, '.', ','), "class" => array("text-right", "status_costo", "cursor-pointer"));
                    } else {
                        $costoL = array("data" => number_format($costo, 2, '.', ','), "class" => array("text-right"));
                    }
                }
            } else if ($row['presupuesto'] == 3) { // no se autorizo el presupuesto
                $costo_number = 0;
                $costoL = array("data" => "N/A", "class" => array("status-red", "text-center"));
            }
            // +++++++++++++++ COSTO PIEZAS ++++++++++++++++++++

            // +++++++++++++++ FACTURADO ++++++++++++++++++++
            $pagado = $row['facturado']; // row -> Pagado

            if ($row['presupuesto'] == 3) {
                $pagadoT = array("data" => "No Aut", "class" => array("status-green", "text-center"));
            } else if ($pagado == 0) {
                if ($supervisor) {
                    $pagadoT = array("data" => "No", "class" => array("status_pagado", "status-red", "text-center", "cursor-pointer"));
                } else {
                    $pagadoT = array("data" => "No", "class" => array("status-red", "text-center"));
                }
            } else if ($pagado == 1) {
                if ($supervisor) {
                    $pagadoT = array("data" => "Pagado", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
                } else {
                    $pagadoT = array("data" => "Pagado", "class" => array("status-green", "text-center"));
                }
            } else if ($pagado == 2) {
                if ($supervisor) {
                    $pagadoT = array("data" => "Factura", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
                } else {
                    $pagadoT = array("data" => "Factura", "class" => array("status-green", "text-center"));
                }
            }
            // +++++++++++++++ FACTURADO ++++++++++++++++++++

            // +++++++++++++++ TOTAL SERVICIO TALLER ++++++++++++++++++++
            if ($row['id_presupuesto']) {
                $total_number = self::total_servicio_taller($row['id_presupuesto'], 2);
                $total = array("data" => number_format(self::total_servicio_taller($row['id_presupuesto'], 2), 2, '.', ','), "class" => array("text-right"));
            } else {
                $total = 'Pendiente';
            }
            // +++++++++++++++ TOTAL SERVICIO TALLER ++++++++++++++++++++


            // +++++++++++++++ IMPRIMIR ++++++++++++++++++++
            $imprimir = array("data" => "<i class='fa fa-print fa-2x' aria-hidden='true'></i>", "class" => array("text-center", "imprimir_registro", "cursor-pointer"));
            // +++++++++++++++ IMPRIMIR ++++++++++++++++++++

            $totalP += $total_number;
            $totalC += $costo_number;
            $diffTotal = $totalP - $totalC;
            $diff = array("data" => number_format(($total_number - $costo_number), 2, '.', ','), "class" => "text-right");

            //$numero_factura = array("data" => $this->get_numero_factura('partners_taller', $row['id_registro']), "class" => array(($this->get_numero_factura('partners_taller', $row['id_registro'])) ? "text-right cursor-pointer ver_factura" : ""));

            if ($this->get_numero_factura('partners_taller', $row['id_registro'])) {
                if ($this->validate_factura_pagada($this->get_numero_factura('partners_taller', $row['id_registro'])) == 0) {
                    $numero_factura = array("data" => $this->get_numero_factura('partners_taller', $row['id_registro']), "class" => array("text-right cursor-pointer ver_factura status-green"));
                } else {
                    $numero_factura = array("data" => $this->get_numero_factura('partners_taller', $row['id_registro']), "class" => array("text-right cursor-pointer ver_factura status-red"));
                }
            } else {
                $numero_factura = "";
            }

            // Sacar el total que al final debería de ser el que el cliente pague, no usar el otro con el iva desglosado
            // para la parte en la que se manda a caja.
            $total_number_a_pagar = self::total_servicio_taller($row['id_presupuesto'], 1);
            $n++;
            $taller[] = array(
                "data" => array(
                    $n,
                    $folio,
                    $fecha_creacion,
                    $cliente,
                    $equipo,
                    $problema,
                    //$usuario_registro,
                    $total,
                    $costoL,
                    $diff,
                    $fecha_compromiso,
                    $fecha_terminacion,
                    $servicio_entregado,
                    $pagadoT,
                    $numero_factura,
                    $especial,
                    $usuario_finalizo,
                    $observaciones,
                    $imprimir,
                ),
                "data-id-registro" => $row['id_registro'],
                "data-id-cliente" => $row['id_cliente'],
                "data-status-presupuesto" => $row['presupuesto'],
                "data-nombre-cliente" => $row['nombre_cliente'],
                "data-total-registro" => $total_number,
                "data-total-registro-a-pagar" => $total_number_a_pagar,
                "data-especial" => $row['status_especial']
            );
        }

        $header_cols = array(
            array("name" => array("data" => "N°", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Folio", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Fecha <br/> Ingreso", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Equipo", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Problema", "class" => "filter-text"), "sortable" => 0),
            //array("name" => array("data" => "Registrado por", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Precio", "class" => "filter-number col-precio"), "sortable" => 0),
            array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
            array("name" => array("data" => "Util", "class" => "filter-number col-util"), "sortable" => 0),
            array("name" => array("data" => "Compromiso", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Terminado", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Entregado", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Facturado", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "N. Fact", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => '<i class="fas fa-exclamation-triangle"></i>', "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => "Finalizó", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Bitácora", "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => '<i class="fa fa-print fa-2x" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
        );


        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $taller,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_taller_admin", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;
    }

    /**
     * @param $id_presupuesto
     * @param $tipo 1:Reporteador Vista trabajo, 2: Reporteador Admin, 3: Costo Piezas
     * @return mixed {int} total del presupuesto
     */
    private function total_servicio_taller($id_presupuesto, $tipo)
    {
        if ($tipo == 1) {
            $datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $datos->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'total');
            $datos->condition('autorizacion', 1);
            $datos->condition('id_presupuesto', $id_presupuesto);
            $total = $datos->execute()->fetchField();
        } else if ($tipo == 2) {
            $query = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $query->fields('ptpd');
            $query->condition('autorizacion', 1);
            $query->condition('id_presupuesto', $id_presupuesto);
            $datos = $query->execute();
            $total = 0;
            while ($row = $datos->fetchAssoc()) {
                if ($row['tipo'] == 1) {
                    if ($row['iva'] == 0) {
                        $subtotal = $row['cantidad'] * $row['precio'];
                    } else { // se desglosa
                        $subtotal = (($row['cantidad'] * $row['precio']) / 1.16);
                    }
                } else {
                    $subtotal = $row['cantidad'] * $row['precio'];
                }
                $total += $subtotal;
            }

        } else if ($tipo == 3) {
            $check_count = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $check_count->fields('ptpd', array('id_dato'));
            $check_count->condition('id_presupuesto', $id_presupuesto);
            $check_count->condition('autorizacion', 1);
            $check_count->condition('tipo', 1);
            $v_count = $check_count->execute()->rowCount();
            if (!$v_count) {
                $total = 'no_piezas';
            } else {
                $v = db_select('partners_taller_presupuesto_datos', 'ptpd')
                    ->fields('ptpd', array('id_dato'))
                    ->condition('id_presupuesto', $id_presupuesto)
                    ->condition('costo', 0)
                    ->condition('tipo', 1)
                    ->condition('autorizacion', 1)
                    ->execute()->fetchField();
                if ($v) {
                    $total = 0;
                } else {
                    $get_costo = db_select('partners_taller_presupuesto_datos', 'ptpd');
                    $get_costo->addExpression('SUM(costo * cantidad)', 'total_piezas_costo');
                    $get_costo->condition('id_presupuesto', $id_presupuesto);
                    $get_costo->condition('autorizacion', 1);
                    $get_costo->condition('tipo', 1);
                    $total = $get_costo->execute()->fetchField();
                }
            }
        }
        return $total;
    }

    /**
     * Este es el reporteador de vista de trabajo, que es muy diferente al reporteador administrativo
     * @param $datos
     * @throws Exception
     */
    private function reporte_base_trabajo($datos)
    {
        global $user;
        $query = db_select('partners_taller', 'pt');
        $query->fields('pt');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pt.id_cliente');
        $query->fields('pc', array('nombre_cliente', 'tipo_clasificacion'));
        $query->innerJoin('partners_taller_equipos', 'pte', 'pte.id_registro_taller = pt.id_registro');
        $query->fields('pte');
        $query->leftJoin('partners_taller_presupuesto', 'ptp', 'ptp.id_registro_taller = pt.id_registro');
        $query->addField('ptp', 'created_at', 'fecha_creacion_presupuesto');
        $query->addField('ptp', 'fecha_compromiso');
        $query->addField('ptp', 'que_hacer');
        $query->innerJoin('users', 'u', 'u.uid = pt.created_by');
        $query->addField('u', 'name', 'usuario_creacion');

        // verificar si hay filtro para solo mostrar los servicios propios del usuario
        if ($datos->soloPropios) {
            $query->condition('pt.created_by', $user->uid, '=');
        }

        // filtro por tecnico:
        
        if ($datos->filter->tecnico != 0 || $datos->filter->tecnico != null) {
            $query->condition('pt.created_by', $datos->filter->tecnico);
        }

        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();
        $n = 0;
        while ($row = $query_datos->fetchAssoc()) {
            // Solamente de esta forma puedo saltar los ya terminados, con condiciones en el query no puedo
            // porque no me muestra los de servicio_etregado = 2 que son los de domicilio.
            if ($row['servicio_abierto'] != 1 && $row['servicio_entregado'] == 1)
                continue;

            if (isset($datos->ocultarTerminados) && $datos->ocultarTerminados) {
                $entregado = $row['servicio_entregado'];
                if ($row['presupuesto'] == 3 && $row['que_hacer'] == 2) { // si no autorizado y pasa a recoger, poner sin entregar
                    continue;
                } else {
                    if ($row['revision_final'] != 0) {
                        continue;
                    }
                }
            }
            if (isset($datos->ocultarNoAut) && $datos->ocultarNoAut && $row['presupuesto'] == 3) {
                continue;
            }

            $usuario_registro = array("data" => $row['usuario_creacion'], "class" => array("cursor-pointer", "vista_datos_generales"));


            # Hardcoded
            # 14/08/2018 ultimo folio 10906
            if ($row['id_registro'] > 10906) {
                $folio = array("data" => strtoupper($row['tipo_clasificacion']) . '-' . $row['id_registro'], "class" => array("cursor-pointer", "vista_datos_generales", ($row['servicio_garantia'] ? 'status-yellow' : '')));
            } else {
                $folio = array("data" => $row['id_registro'], "class" => array("cursor-pointer", "vista_datos_generales", ($row['servicio_garantia'] ? 'status-yellow' : '')));
            }
            $tipo_equipo_id = $row['tipo_equipo'];
            $fecha_creacion = array("data" => date('d/m/y', $row['created_at']), "class" => array("cursor-pointer", "vista_datos_generales"));
            $hora_creacion = array("data" => date('H:i:s', $row['created_at']), "class" => array("cursor-pointer", "vista_datos_generales"));
            switch ($tipo_equipo_id) {
                case 1:
                    $tipo_equipo = 'CPU';
                    break;
                case 2:
                    $tipo_equipo = 'Todo en uno';
                    break;
                case 3:
                    $tipo_equipo = 'Laptop';
                    break;
                case 4:
                    $tipo_equipo = 'Servidor';
                    break;
                case 5:
                    $tipo_equipo = 'Impresora';
                    break;
                case 6:
                    $tipo_equipo = 'Monitor';
                    break;
                case 7:
                    $tipo_equipo = 'Tablet';
                    break;
                case 8:
                    $tipo_equipo = 'Celular';
                    break;
                case 9:
                    $tipo_equipo = 'Otro';
                    break;
            }
            $equipo = array("data" => $tipo_equipo . ' | ' . $row['marca_equipo'] . ' | ' . $row['modelo_equipo'], "class" => array("cursor-pointer", "vista_datos_generales"));
            $problema = array("data" => mb_substr($row['descripcion_problema'], 0, 30, "utf-8"), "class" => array("cursor-pointer", "vista_datos_generales"));
            $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 16, "utf-8"), "class" => array("cursor-pointer", "vista_datos_generales"));

            // +++++++++++++ FECA COMPROMISO ++++++++++++++++++
            $dia_actual = date('d', REQUEST_TIME);
            $dia_fecha_compromiso = date('d', $row['fecha_compromiso']);
            if ($row['presupuesto'] == 3) { // validar que no se haya puesto en no autorizado el presupuesto
                $fecha_compromiso = array("data" => '<i class="far fa-times-circle fa-2x"></i>', "class" => array("text-danger", "text-center"));
            } else {
                if ($row['fecha_compromiso'] != 0) {
                    if ($row['revision_final'] != 0) { // si ya se hizo la revision final muestra la fecha sin nada
                        $fecha_compromiso = array("data" => '<span class="btn btn-sm w-100">' . date('d/m/y', $row['fecha_compromiso']) . '<span>');
                    } else {
                        if (REQUEST_TIME >= ($row['fecha_compromiso'] - 86400)) {
                            if (REQUEST_TIME >= $row['fecha_compromiso']) {
                                $fecha_compromiso = array("data" => '<span class="btn btn-sm red-blink w-100">' . date('d/m/y', $row['fecha_compromiso']) . '<span>', "class" => array(""));
                            } else if ($dia_actual == $dia_fecha_compromiso) {
                                $fecha_compromiso = array("data" => '<span class="btn btn-sm red-blink w-100">' . date('d/m/y', $row['fecha_compromiso']) . '<span>', "class" => array(""));
                            } else {
                                $fecha_compromiso = array("data" => '<span class="btn btn-sm yellow-blink w-100">' . date('d/m/y', $row['fecha_compromiso']) . '<span>', "class" => array(""));
                            }
                        } else {
                            $fecha_compromiso = array("data" => '<span class="btn btn-sm w-100">' . date('d/m/y', $row['fecha_compromiso']) . '<span>');
                        }
                    }
                } else { // aun no existe
                    //$fecha_compromiso = 'Pendiente';
                    $fecha_compromiso = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("text-warning", "text-center"));
                }
            }
            // +++++++++++++ FECHA COMPROMISO ++++++++++++++++++

            // +++++++++++++ OBSERVACIONES ++++++++++++++++++
            if ($row['observaciones'] != null) { // si las observaciones tienen contenido, se muestra background amarillo para poder diferenciar de las que no tienen contenido
                $observaciones = array("data" => '<i class="fas fa-pen-square fa-2x"></i>', "class" => array("text-warning", "taller-observaciones", "cursor-pointer", "text-center"));
            } else {
                $observaciones = array("data" => '<i class="fas fa-pen-square fa-2x"></i>', "class" => array("taller-observaciones", "cursor-pointer", "text-center"));
            }
            // +++++++++++++ OBSERVACIONES ++++++++++++++++++


            // +++++++++++++++ PRESUPUESTO ++++++++++++++++++++
            /**
             * presupuesto 0 = Pendiente;
             * presupuesto 1 = Si, se hizo el presupuesto;
             * presupuesto 2 = Autorizado;
             */
            if ($row['revision_inicial'] != 0) { // validar que se haya echo la revision inicial primero
                if ($row['presupuesto'] == 0) { // pendiente
                    if (REQUEST_TIME >= $row['timer_presupuesto']) { // si la fecha actual es mayor a la fecha limite para hacer presupuesto, lo pone en rojo
                        $presupuesto = array("data" => '<span class="btn btn-sm red-blink w-100 p-0 text-warning"><i class="material-icons-outlined">pending</i></span>', "class" => array("status_presupuesto", "text-center", "cursor-pointer"));
                    } else {
                        $presupuesto = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("status_presupuesto", "text-warning", "text-center", "cursor-pointer"));
                    }
                } else if ($row['presupuesto'] == 1) { // se hizo el presupuesto
                    if (REQUEST_TIME >= $row['timer_presupuesto']) { // si la fecha actual es mayor a la fecha limite para hacer presupuesto, lo pone en rojo
                        $presupuesto = array("data" => '<span class="btn btn-sm yellow-blink w-100 p-0 text-warning"><i class="far fa-check-circle fa-2x"></i></span>', "class" => array("status_presupuesto", "text-center", "cursor-pointer"));
                    } else {
                        $presupuesto = array("data" => '<i class="far fa-check-circle fa-2x"></i>', "class" => array("status_presupuesto", "text-warning", "text-center", "cursor-pointer"));
                    }
                } else if ($row['presupuesto'] == 2) { // autorizado
                    $presupuesto = array("data" => '<i class="far fa-check-circle fa-2x"></i>', "class" => array("status_presupuesto", "text-success", "text-center", "cursor-pointer"));
                } else if ($row['presupuesto'] == 3) { // no autorizado
                    $presupuesto = array("data" => '<i class="far fa-times-circle fa-2x"></i>', "class" => array("status_presupuesto", "text-danger", "text-center", "cursor-pointer"));
                }
            } else {
                /*if (REQUEST_TIME >= $row['timer_presupuesto']) { // si la fecha actual es mayor a la fecha limite para hacer presupuesto, lo pone en rojo
                    $presupuesto = array("data" => '<i class="fas fa-ban fa-2x"></i>', "class" => array("red_blink", "text-center", "disabled_cursor"));
                } else {*/
                $presupuesto = array("data" => '<i class="fas fa-ban fa-2x"></i>', "class" => array("cursor-disabled", "text-center"));
                //}
            }
            // +++++++++++++++ PRESUPUESTO ++++++++++++++++++++


            // +++++++++++++++ REVISIÓN INICIAL ++++++++++++++++++++
            if ($row['revision_inicial']) {
                $revision_inicial = array("data" => '<i class="far fa-check-circle fa-2x"></i>', "class" => array("revision_inicial", "text-success", "text-center", "cursor-pointer"));
            } else {
                if (REQUEST_TIME >= $row['timer_inicio']) {
                    $revision_inicial = array("data" => '<span class="btn red-blink w-100 p-0 text-warning"><i class="material-icons-outlined">pending</i><span>', "class" => array("revision_inicial", "text-center", "cursor-pointer"));
                } else {
                    $revision_inicial = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("revision_inicial", "text-center", "text-warning", "cursor-pointer"));
                }
            }
            // +++++++++++++++ REVISIÓN INICIAL ++++++++++++++++++++


            // CLAUSURADO
            // +++++++++++++++ PROCESO ++++++++++++++++++++
            /*if ($row['presupuesto'] == 3) { // validar que el presupuesto no este en no autorizado
              $proceso = array("data" => '<i class="far fa-times-circle fa-2x"></i>', "class" => array("text-danger", "text-center")); // presupuesto no autorizado,se pone igual aqui no autorizado
            } else {
              if ($row['presupuesto'] != 0) {  // validar que se haya echo la el presupuesto primero
                if ($row['status_proceso']) {
                  $proceso = array("data" => '<i class="far fa-check-circle fa-2x"></i>', "class" => array("status_proceso", "text-success", "text-center", "cursor-pointer"));
                } else {
                  $proceso = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("status_proceso", "text-warning", "text-center", "cursor-pointer"));
                }
              } else {
                $proceso = array("data" => '<i class="fas fa-ban fa-2x"></i>', "class" => array("cursor-disabled", "text-center"));
              }
            }*/
            // +++++++++++++++ PROCESO ++++++++++++++++++++


            // +++++++++++++++ REVISIÓN FINAL ++++++++++++++++++++
            if ($row['presupuesto'] == 3) { // validar que el presupuesto no este en no autorizado
                $revision_final = array("data" => '<i class="far fa-times-circle fa-2x"></i>', "class" => array("text-center", "text-danger"));
            } else {
                if ($row['presupuesto'] != 0) { // validar que se haya echo la el presupuesto primero
                    if ($row['revision_final']) {
                        $revision_final = array("data" => '<i class="far fa-check-circle fa-2x"></i>', "class" => array("revision_final", "text-success", "text-center", "cursor-pointer"));
                    } else {
                        $revision_final = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("revision_final", "text-center", "cursor-pointer", "text-warning"));
                    }
                } else {
                    $revision_final = array("data" => '<i class="fas fa-ban fa-2x"></i>', "class" => array("text-center", "cursor-disabled"));
                }
            }
            // +++++++++++++++ REVISIÓN FINAL ++++++++++++++++++++


            // +++++++++++++++ ENTREGADO ++++++++++++++++++++
            $entregado = $row['servicio_entregado'];
            if ($row['presupuesto'] == 3 && $row['que_hacer'] == 2) { // si no autorizado y pasa a recoger, poner sin entregar
                //$servicio_entregado = array("data" => "X Recoger", "class" => array("status_entregado", "text-center", "cursor-pointer"));
                $servicio_entregado = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("status_entregado", "text-center", "cursor-pointer", "text-warning"));
            } else {
                if ($row['revision_final'] != 0) {
                    if ($entregado == 0) {
                        if ($row['tipo_servicio'] == 1) {
                            // si es local, poner pasarán a recoger
                            //$servicio_entregado = array("data" => "X Recoger", "class" => array("text-center", "status_entregado", "cursor-pointer"));
                            $servicio_entregado = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("text-center", "status_entregado", "cursor-pointer", "text-warning"));
                        }
                    } else if ($entregado == 1) {
                        $servicio_entregado = array("data" => '<i class="far fa-check-circle fa-2x"></i>', "class" => array("status_entregado", "text-success", "text-center", "cursor-pointer"));
                    } else if ($entregado == 2) { // se marca en 2 automaticamente cuando es de domicilio y ya se termino la revision final para dejar en amarillo y Programar
                        $servicio_entregado = array("data" => '<i class="far fa-clock fa-2x"></i>', "class" => array("status_entregado", "text-info", "text-center", "cursor-pointer"));
                    }
                } else {
                    $servicio_entregado = array("data" => '<i class="fas fa-ban fa-2x"></i>', "class" => array("cursor-disabled", "text-center"));
                }
            }
            // +++++++++++++++ ENTREGADO ++++++++++++++++++++


            // +++++++++++++++ TOTAL SERVICIO TALLER ++++++++++++++++++++
            if ($row['id_presupuesto']) {
                $total = array("data" => number_format(self::total_servicio_taller($row['id_presupuesto'], 1), 2, '.', ','), "class" => array("text-right"));
            } else {
                //$total = 'Pendiente';
                $total = array("data" => '<i class="material-icons-outlined">pending</i>', "class" => array("text-center", "text-warning"));
            }
            // +++++++++++++++ TOTAL SERVICIO TALLER ++++++++++++++++++++


            // +++++++++++++++ IMPRIMIR ++++++++++++++++++++
            $imprimir = array("data" => '<i class="material-icons">print</i>', "class" => array("text-center", "imprimir_registro", "cursor-pointer"));
            // +++++++++++++++ IMPRIMIR ++++++++++++++++++++

            // ++++++++++++++++ PROBLEMA +++++++++++++++++++++
            if ($row['status_problema']) {
                $status_problema = array("data" => '<i class="material-icons text-danger">report</i>', "class" => array("text-center", "cursor-pointer", "status_problema"));
                $observaciones = array("data" => '<i class="fas fa-pen-square fa-2x"></i>', "class" => array("text-danger", "taller-observaciones", "cursor-pointer", "text-center"));
            } else {
                $status_problema = array("data" => "", "class" => array("cursor-pointer", "status_problema"));
            }
            // ++++++++++++++++ PROBLEMA +++++++++++++++++++++

            $n++;
            $taller[] = array(
                "data" => array(
                    $n,
                    $folio,
                    $fecha_creacion,
                    $hora_creacion,
                    $cliente,
                    $equipo,
                    $problema,
                    $usuario_registro,
                    $revision_inicial,
                    $presupuesto,
                    $total,
                    //$proceso,
                    $revision_final,
                    $fecha_compromiso,
                    $servicio_entregado,
                    $status_problema,
                    $observaciones,
                    $imprimir,
                ),
                "data-id-registro" => $row['id_registro'],
                "data-status-presupuesto" => $row['presupuesto'],
                "data-status-problema" => $row['status_problema']
            );
        }

        $header_cols = array(
            array("name" => "N°", "sortable" => 0),
            array("name" => "Folio", "sortable" => 0),
            array("name" => array("data" => "Ingreso", "colspan" => 2, "class" => "text-center"), "sortable" => 0),
            array("name" => "Cliente", "sortable" => 0),
            array("name" => "Equipo", "sortable" => 0),
            array("name" => "Problema", "sortable" => 0),
            array("name" => array("data" => "Registrado por", "class" => "filter-text"), "sortable" => 0),
            array("name" => "Inicial", "sortable" => 0),
            array("name" => "Presupuesto", "sortable" => 0),
            array("name" => 'Precio', "sortable" => 0),
            array("name" => 'Final', "sortable" => 0),
            array("name" => 'Compromiso', "sortable" => 0),
            array("name" => 'Entregado', "sortable" => 0),
            array("name" => array("data" => '<i class="material-icons">report</i>', "class" => "text-center"), "sortable" => 0),
            array("name" => array("data" => '<i class="fas fa-pen-square fa-2x"></i>', "class" => "text-center"), "sortable" => 0),
            array("name" => '<i class="material-icons">print</i>', "sortable" => 0),
        );

        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $taller,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_taller_trabajo", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;
    }

    private function capturar_registro($datos)
    {
        $equipo_type = $datos->equipo_type;

        // temporizadores
        $day_week = date('N', REQUEST_TIME);
        if ($day_week == 6) { // si es sabado pone temporizador a 72hrs
            $timer_inicio = REQUEST_TIME + 259200;
        } else { // si es cualquier otro dia pone temporizador a 24 hrs
            $timer_inicio = REQUEST_TIME + 86400;
        }

        $id_registro = db_insert('partners_taller')
            ->fields(
                array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $datos->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $datos->uid,
                    'id_cliente' => $datos->id_cliente,
                    'id_contacto' => (isset($datos->id_contacto) && $datos->id_contacto != '') ? $datos->id_contacto : null,
                    'tipo_servicio' => $datos->seleccion_tipo_servicio,
                    'descripcion_problema' => $datos->descripcion_problema,
                    'info_respaldar' => $datos->info_respaldar,
                    'observaciones' => ($datos->notas_internas) ? $this->serialize_obs($datos->notas_internas, 1) : null,
                    'timer_presupuesto' => 0,
                    'timer_inicio' => $timer_inicio,
                    'servicio_garantia' => (isset($datos->servicio_garantia) && $datos->servicio_garantia != '') ? $datos->servicio_garantia : null
                )
            )
            ->execute();


        //CPU, All in one, Laptop, Servidor
        if ($equipo_type == 1) {
            db_insert('partners_taller_equipos')
                ->fields(
                    array(
                        'id_registro_taller' => $id_registro,
                        'tipo_equipo' => $datos->tipo_equipo,
                        'procesador_equipo' => $datos->procesador_equipo,
                        'memoria_equipo' => $datos->memoria_equipo,
                        'disco_duro_equipo' => $datos->disco_duro_equipo,
                        'extras' => $datos->extras_equipo,
                        'marca_equipo' => $datos->marca_equipo,
                        'modelo_equipo' => $datos->modelo_equipo,
                        'serie_equipo' => $datos->serie_equipo,
                        'user_equipo' => $datos->user_equipo,
                        'pass_equipo' => $datos->pass_equipo,
                        'software_equipo' => $datos->software_equipo,
                        'caracteristicas_equipo' => $datos->color_detalles_equipo,
                        'accesorios_equipo' => $datos->accesorios_equipo,
                    )
                )
                ->execute();
        } else if ($equipo_type == 2) {
            //Impresora
            db_insert('partners_taller_equipos')
                ->fields(
                    array(
                        'id_registro_taller' => $id_registro,
                        'tipo_equipo' => $datos->tipo_equipo,
                        'marca_equipo' => $datos->marca_equipo,
                        'modelo_equipo' => $datos->modelo_equipo,
                        'serie_equipo' => $datos->serie_equipo,
                        'software_equipo' => $datos->software_equipo,
                        'caracteristicas_equipo' => $datos->color_detalles_equipo,
                        'accesorios_equipo' => $datos->accesorios_equipo,
                        'tipo_impresora' => $datos->tipo_impresora
                    )
                )
                ->execute();

        } else if ($equipo_type == 3) {
            //Tablet, Celular
            db_insert('partners_taller_equipos')
                ->fields(
                    array(
                        'id_registro_taller' => $id_registro,
                        'tipo_equipo' => $datos->tipo_equipo,
                        'extras' => $datos->extras_equipo,
                        'marca_equipo' => $datos->marca_equipo,
                        'modelo_equipo' => $datos->modelo_equipo,
                        'serie_equipo' => $datos->serie_equipo,
                        'user_equipo' => $datos->user_equipo,
                        'pass_equipo' => $datos->pass_equipo,
                        'software_equipo' => $datos->software_equipo,
                        'caracteristicas_equipo' => $datos->color_detalles_equipo,
                        'accesorios_equipo' => $datos->accesorios_equipo,
                        'memoria_interna_equipo' => $datos->memoria_interna_equipo,
                    )
                )
                ->execute();
        } else {
            //Monitor, Otro
            db_insert('partners_taller_equipos')
                ->fields(
                    array(
                        'id_registro_taller' => $id_registro,
                        'tipo_equipo' => $datos->tipo_equipo,
                        'extras' => $datos->extras_equipo,
                        'marca_equipo' => $datos->marca_equipo,
                        'modelo_equipo' => $datos->modelo_equipo,
                        'serie_equipo' => $datos->serie_equipo,
                        'user_equipo' => $datos->user_equipo,
                        'pass_equipo' => $datos->pass_equipo,
                        'software_equipo' => $datos->software_equipo,
                        'caracteristicas_equipo' => $datos->color_detalles_equipo,
                        'accesorios_equipo' => $datos->accesorios_equipo,
                        'nombre_dispositivo_otro' => $datos->nombre_dispositivo_otro
                    )
                )
                ->execute();
        }

        $this->throw_message('success', $id_registro);
        $this->register_log_actions('partners_taller', 'insert', 'Se generó un nuevo registro en centro de servicio :' . $id_registro . ' creado por: ' . $datos->uid);
    }

    /**
     * @param $id_registro {int} id del registro de taller a consultar datos
     * @param null $returned {int} if $returned == 1 se regresan los datos, si no, se muestra el template.
     * Se necesita que regrese los datos para todas las otras vistas que necesitan generar los datos generales.
     * @return mixed
     */
    private function vista_datos_generales($id_registro, $returned = NULL)
    {
        $query = db_select('partners_taller', 'pt');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pt.id_cliente');
        $query->fields('pc', array('tipo_cliente', 'nombre_cliente', 'tipo_clasificacion'));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pt.id_contacto');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->leftJoin('partners_clientes_datos', 'pcd', 'pcd.id_cliente = pt.id_cliente AND pcd.tipo_dato = 1');
        $query->addField('pcd', 'dato_valor', 'telefono_cliente');
        $query->innerJoin('partners_taller_equipos', 'pte', 'pte.id_registro_taller = pt.id_registro');
        $query->fields('pt');
        $query->fields('pte');
        $query->addExpression("CASE pte.tipo_equipo WHEN 1 THEN 'CPU' WHEN 2 THEN 'Todo en uno' WHEN 3 THEN 'Laptop' WHEN 4 THEN 'Servidor' WHEN 5 THEN 'Impresora' WHEN 6 THEN 'Monitor' WHEN 7 THEN 'Tablet' WHEN 8 THEN 'Celular' WHEN 9 THEN 'Otro' END", 'nombre_tipo_equipo');
        $query->addExpression("CASE pt.tipo_servicio WHEN 1 THEN 'Local' WHEN 2 THEN 'Domicilio' END", 'tipo_servicio_nombre');
        $query->innerJoin('users', 'u', 'u.uid = pt.created_by');
        $query->addField('u', 'name', 'usuario_creacion');
        $query->leftJoin('partners_taller_presupuesto', 'ptp', 'ptp.id_registro_taller = pt.id_registro');
        $query->fields('ptp', array('fecha_autorizado'));
        $query->addField('ptp', 'created_at', 'fecha_creacion_presupuesto');
        $query->leftJoin('users', 'usr_pr_c', 'usr_pr_c.uid = ptp.created_by');
        $query->addField('usr_pr_c', 'name', 'nombre_usuario_creo_presupuesto');
        $query->leftJoin('users', 'usr_pr_a', 'usr_pr_a.uid = ptp.usuario_ingreso_autorizacion');
        $query->addField('usr_pr_a', 'name', 'nombre_usuario_ingreso_autorizacion');
        $query->condition('pt.id_registro', $id_registro);
        $registro = $query->execute()->fetchAssoc();


        $datos['registro'] = $registro;

        // Se genera este numero para ponerlo en el id de los collapse para que no se cree un conflicto con tener varios
        // con el mismo id. Asi de esta manera se genera un id unico cada vez que se abre un modal.
        $datos['random_number'] = REQUEST_TIME;
        if ($returned == 1) {
            return $datos;
        } else {
            $template = render_template('php', 'taller.vista_datos_generales', $datos);
            $this->throw_message('success', $template);
        }

    }

    private function vista_revision_inicial($id_registro, $returned = NULL)
    {
        if (!$returned)
            $datos = self::vista_datos_generales($id_registro, 1);
        $check_revision_done = db_select('partners_taller', 'pt')
            ->fields('pt', array('revision_inicial'))
            ->condition('id_registro', $id_registro)
            ->execute()->fetchField();

        // Revisión aún no realizada
        if ($check_revision_done == 0) {
            $datos['revision'] = self::get_revision_pending_data(1);
            $datos['revision_realizada'] = 0;
        } else {
            $datos['revision'] = self::get_revision_done_data($id_registro, 1);
            $datos['revision_info'] = self::get_revision_info_done_data($id_registro, 1);
            $datos['revision_realizada'] = 1;
        }

        $datos['id_registro'] = $id_registro;
        $datos['random_number'] = REQUEST_TIME;
        if ($returned) {
            return $datos;
        } else {
            $template = render_template('php', 'taller.revision_inicial', $datos);
            $this->throw_message('success', $template);
        }

    }

    /**
     * @param $tipo_revision {int} 1:Revisión Inicial, 2:Proceso, 3:Revisión Final
     * @return mixed {Array} datos para generar la vista de la revisión
     */
    private function get_revision_pending_data($tipo_revision)
    {
        $revision = db_select('partners_taller_revisiones_datos_tipos', 'ptrdt')
            ->fields('ptrdt')
            ->condition('tipo_revision', $tipo_revision)
            ->execute()->fetchAll(PDO::FETCH_ASSOC);

        return $revision;
    }

    /**
     * @param $id_registro {int} id_registro_taller a consultar la revisión
     * @param $tipo_revision {int}
     * @return mixed {Array} de los datos de la revisión completada
     */
    private function get_revision_done_data($id_registro, $tipo_revision)
    {
        $revision_query = db_select('partners_taller_revisiones', 'ptr');
        $revision_query->leftJoin('partners_taller_revisiones_datos', 'ptrd', 'ptrd.id_revision = ptr.id_revision');
        $revision_query->fields('ptrd', array('valor'));
        $revision_query->leftJoin('partners_taller_revisiones_datos_tipos', 'ptrdt', 'ptrdt.id_tipo_dato = ptrd.id_tipo_dato_revision');
        $revision_query->fields('ptrdt', array('nombre_dato', 'tipo_dato'));
        $revision_query->condition('ptr.id_registro_taller', $id_registro);
        $revision_query->condition('ptr.tipo_revision', $tipo_revision);
        $revision = $revision_query->execute()->fetchAll(PDO::FETCH_ASSOC);
        return $revision;
    }

    /**
     * Complementa a get_revision_done_data()
     * @param $id_registro {int} id_registro_taller
     * @param $tipo_revision {int}
     * @return mixed {Array}
     */
    private function get_revision_info_done_data($id_registro, $tipo_revision)
    {
        $query_revision_info = db_select('partners_taller_revisiones', 'ptr');
        $query_revision_info->innerJoin('users', 'u', 'u.uid = ptr.created_by');
        $query_revision_info->addField('u', 'name', 'nombre_usuario_creo');
        $query_revision_info->fields('ptr', array('created_at'));
        $query_revision_info->condition('ptr.id_registro_taller', $id_registro);
        $query_revision_info->condition('ptr.tipo_revision', $tipo_revision);
        $revision_info = $query_revision_info->execute()->fetchAssoc();
        return $revision_info;
    }

    private function capturar_revision_inicial($datos)
    {
        $day_week = date('N', REQUEST_TIME);
        if ($day_week == 6) { // si es sabado pone temporizador a 72hrs
            $timer_presupuesto = REQUEST_TIME + 259200;
        } else { // si es cualquier otro dia pone temporizador a 24 hrs
            $timer_presupuesto = REQUEST_TIME + 86400;
        }
        $revision_inicial = db_insert('partners_taller_revisiones')
            ->fields(
                array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $datos->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $datos->uid,
                    'id_registro_taller' => $datos->id_registro,
                    'tipo_revision' => 1
                )
            )
            ->execute();

        foreach ($datos->datos as $dato) {
            db_insert('partners_taller_revisiones_datos')
                ->fields(
                    array(
                        'id_tipo_dato_revision' => $dato->id_tipo_dato,
                        'id_revision' => $revision_inicial,
                        'valor' => $dato->value
                    )
                )
                ->execute();
        }

        db_update('partners_taller')
            ->fields(
                array(
                    'revision_inicial' => $revision_inicial,
                    'timer_presupuesto' => $timer_presupuesto
                )
            )
            ->condition('id_registro', $datos->id_registro)
            ->execute();
        $this->register_log_actions('partners_taller_revisiones', 'insert', 'Se capturó la revisión inicial por: ' . $datos->uid . ' al id_registro: ' . $datos->id_registro);
        $this->throw_message('success', 'Revisión Inicial Generada correctamente');
    }

    private function vista_presupuesto($id_registro, $returned = NULL)
    {
        if (!$returned)
            $datos = self::vista_datos_generales($id_registro, 1);
        $check_presupuesto_status = db_select('partners_taller', 'pt')
            ->fields('pt', array('presupuesto'))
            ->condition('id_registro', $id_registro)
            ->execute()->fetchField();

        // Correos para enviar presupuesto
        $id_cliente_contacto = db_select('partners_taller', 'pt')
            ->fields('pt', array('id_cliente', 'id_contacto'))
            ->condition('id_registro', $id_registro)
            ->execute()->fetchAssoc();
        $correo_cliente = db_select('partners_clientes', 'pc')
            ->fields('pc', array('email'))
            ->condition('id_cliente', $id_cliente_contacto['id_cliente'])
            ->execute()->fetchField();
        $correo_contacto = db_select('partners_clientes', 'pc')
            ->fields('pc', array('email'))
            ->condition('id_cliente', $id_cliente_contacto['id_contacto'])
            ->execute()->fetchField();
        $datos['correo_cliente'] = $correo_cliente;
        $datos['correo_contacto'] = $correo_contacto;
        $datos['id_cliente'] = $id_cliente_contacto['id_cliente'];
        // Presupuesto 0: Pendiente / Sin realizar
        // Presupuesto 1: Si / Se realizó
        // Presupuesto 2: Autorizado
        // Presupuesto 3: No Autorizado
        if ($check_presupuesto_status == 0) {
            $datos['status_presupuesto'] = 0;
        } else if ($check_presupuesto_status == 1) {
            $query_presupuesto = db_select('partners_taller_presupuesto', 'ptp');
            $query_presupuesto->leftJoin('partners_taller_presupuesto_datos', 'ptpd', 'ptpd.id_presupuesto = ptp.id_presupuesto');
            $query_presupuesto->fields('ptpd');
            $query_presupuesto->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $query_presupuesto->fields('ptp');
            $query_presupuesto->condition('ptp.id_registro_taller', $id_registro);
            $query_presupuesto->condition('ptpd.autorizacion', 0);
            $query_presupuesto->groupBy('ptpd.id_dato');
            $presupuesto = $query_presupuesto->execute()->fetchAll(PDO::FETCH_ASSOC);

            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();

            $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total->condition('autorizacion', 0);

            $presupuesto_info = db_select('partners_taller_presupuesto', 'ptp');
            $presupuesto_info->fields('ptp', array('created_at', 'updated_at'));
            $presupuesto_info->leftJoin('users', 'u', 'u.uid = ptp.updated_by');
            $presupuesto_info->addField('u', 'name', 'nombre_usuario_edito');
            $presupuesto_info->condition('id_presupuesto', $id_presupuesto);
            $info_presupuesto = $presupuesto_info->execute()->fetchAssoc();


            $total = $presupuesto_total->execute()->fetchField();
            $datos['total_presupuesto'] = $total;
            $datos['presupuesto'] = $presupuesto;
            $datos['info_presupuesto'] = $info_presupuesto;
            $datos['id_presupuesto'] = $id_presupuesto;
            $datos['status_presupuesto'] = 1;
        } else if ($check_presupuesto_status == 2) {
            $query_presupuesto = db_select('partners_taller_presupuesto', 'ptp');
            $query_presupuesto->leftJoin('partners_taller_presupuesto_datos', 'ptpd', 'ptpd.id_presupuesto = ptp.id_presupuesto');
            $query_presupuesto->fields('ptpd');
            $query_presupuesto->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $query_presupuesto->fields('ptp');
            $query_presupuesto->condition('ptp.id_registro_taller', $id_registro);
            $query_presupuesto->condition('ptpd.autorizacion', 1);
            $query_presupuesto->groupBy('ptpd.id_dato');
            $presupuesto = $query_presupuesto->execute()->fetchAll(PDO::FETCH_ASSOC);

            $query_presupuesto_inicial = db_select('partners_taller_presupuesto', 'ptp');
            $query_presupuesto_inicial->leftJoin('partners_taller_presupuesto_datos', 'ptpd', 'ptpd.id_presupuesto = ptp.id_presupuesto');
            $query_presupuesto_inicial->fields('ptpd');
            $query_presupuesto_inicial->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $query_presupuesto_inicial->fields('ptp');
            $query_presupuesto_inicial->condition('ptp.id_registro_taller', $id_registro);
            $query_presupuesto_inicial->condition('ptpd.autorizacion', 0);
            $query_presupuesto_inicial->groupBy('ptpd.id_dato');
            $presupuesto_inicial = $query_presupuesto_inicial->execute()->fetchAll(PDO::FETCH_ASSOC);

            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();

            $presupuesto_total_inicial = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total_inicial->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total_inicial->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total_inicial->condition('autorizacion', 0);
            $total_presupuesto_inicial = $presupuesto_total_inicial->execute()->fetchField();

            $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total->condition('autorizacion', 1);
            $total = $presupuesto_total->execute()->fetchField();

            $presupuesto_info = db_select('partners_taller_presupuesto', 'ptp');
            $presupuesto_info->fields('ptp', array('created_at', 'updated_at', 'fecha_autorizado', 'autorizado_por'));
            $presupuesto_info->leftJoin('users', 'u', 'u.uid = ptp.updated_by');
            $presupuesto_info->addField('u', 'name', 'nombre_usuario_edito');
            $presupuesto_info->leftJoin('users', 'uu', 'uu.uid = ptp.usuario_ingreso_autorizacion');
            $presupuesto_info->addField('uu', 'name', 'nombre_usuario_ingreso_autorizacion');
            $presupuesto_info->condition('id_presupuesto', $id_presupuesto);
            $info_presupuesto = $presupuesto_info->execute()->fetchAssoc();

            $datos['info_presupuesto'] = $info_presupuesto;
            $datos['total_presupuesto'] = $total;
            $datos['total_presupuesto_inicial'] = $total_presupuesto_inicial;
            $datos['id_presupuesto'] = $id_presupuesto;
            $datos['presupuesto'] = $presupuesto;
            $datos['presupuesto_inicial'] = $presupuesto_inicial;
            $datos['status_presupuesto'] = 2;
        } else if ($check_presupuesto_status == 3) {

            $query_presupuesto_inicial = db_select('partners_taller_presupuesto', 'ptp');
            $query_presupuesto_inicial->leftJoin('partners_taller_presupuesto_datos', 'ptpd', 'ptpd.id_presupuesto = ptp.id_presupuesto');
            $query_presupuesto_inicial->fields('ptpd');
            $query_presupuesto_inicial->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $query_presupuesto_inicial->fields('ptp');
            $query_presupuesto_inicial->condition('ptp.id_registro_taller', $id_registro);
            $query_presupuesto_inicial->condition('ptpd.autorizacion', 0);
            $query_presupuesto_inicial->groupBy('ptpd.id_dato');
            $presupuesto_inicial = $query_presupuesto_inicial->execute()->fetchAll(PDO::FETCH_ASSOC);

            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();

            $presupuesto_total_inicial = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total_inicial->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total_inicial->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total_inicial->condition('autorizacion', 0);
            $total_presupuesto_inicial = $presupuesto_total_inicial->execute()->fetchField();


            $presupuesto_info = db_select('partners_taller_presupuesto', 'ptp');
            $presupuesto_info->fields('ptp', array('created_at', 'updated_at', 'fecha_autorizado', 'que_hacer', 'no_autorizado_por'));
            $presupuesto_info->condition('id_presupuesto', $id_presupuesto);
            $info_presupuesto = $presupuesto_info->execute()->fetchAssoc();

            $datos['info_presupuesto'] = $info_presupuesto;
            $datos['total_presupuesto_inicial'] = $total_presupuesto_inicial;
            $datos['id_presupuesto'] = $id_presupuesto;
            $datos['presupuesto_inicial'] = $presupuesto_inicial;
            $datos['status_presupuesto'] = 3;
        }
        $datos['id_registro'] = $id_registro;

        if ($returned) {
            return $datos;
        } else {
            $template = render_template('php', 'taller.presupuesto', $datos);
            $this->throw_message('success', $template);
        }

    }

    private function capturar_presupuesto_inicial($datos)
    {
        // temporizadores
        $timer_presupuesto = REQUEST_TIME + (60 * 60 * 24 * 7); //una semana
        $presupuesto = db_insert('partners_taller_presupuesto')
            ->fields(
                array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $datos->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $datos->uid,
                    'id_registro_taller' => $datos->id_registro
                )
            )
            ->execute();

        db_update('partners_taller')
            ->fields(
                array(
                    'presupuesto' => 1,
                    'id_presupuesto' => $presupuesto,
                    'timer_presupuesto' => $timer_presupuesto
                )
            )
            ->condition('id_registro', $datos->id_registro)
            ->execute();
        foreach ($datos->datos as $dato) {
            db_insert('partners_taller_presupuesto_datos')
                ->fields(
                    array(
                        'id_presupuesto' => $presupuesto,
                        'descripcion' => $dato->descripcion,
                        'precio' => $dato->precio,
                        'autorizacion' => 0,
                        'tipo' => $dato->tipo,
                        'cantidad' => $dato->cantidad,
                        'iva' => $dato->iva
                    )
                )
                ->execute();
        }
        $this->register_log_actions('partners_taller_presupuesto', 'insert', 'Se creó un presupuesto inicial por:' . $datos->uid . ' al id_registro: ' . $datos->id_registro);
        $this->throw_message('success', $presupuesto);
    }

    /**
     * @param $datos ->type = 1: Return string to mail, null : return template
     * $datos->tipo : 1:Recepción, 2: Reporte Trabajo, 3: Presupuesto
     * @return array
     */
    private function render_reporte($datos)
    {
        setlocale(LC_TIME, "es_MX");
        $id_registro = $datos['id_registro'];
        if ($datos['type']) {
            $type = $datos['type'];
        } else {
            $type = null;
        }


        $registro = $this->datos_registro($id_registro, $datos['tipo']);
        $data['id_registro'] = $id_registro;
        $footer = render_template('php', 'system.footer_reporte');
        $html = render_template('php', 'taller.render_reporte', $registro);
        if ($type == null) {
            // Solamente poner footer para reporte de recepción y en presupuesto inicial/autorizado.
            $this->generate_pdf($html, 'Reporte de Servicio ' . $id_registro, 'reporte_' . $id_registro, 1, $footer);
        } else {
            if ($datos['tipo'] == 1 || $datos['tipo'] == 3 || $datos['tipo'] == 4) {
                return array("pdf_string" => $this->generate_pdf($html, 'Reporte de Servicio ' . $id_registro, 'reporte_' . $id_registro, 2, $footer), "attach_title" => 'reporte_' . $id_registro);
            } else {
                return array("pdf_string" => $this->generate_pdf($html, 'Reporte de Servicio ' . $id_registro, 'reporte_' . $id_registro, 2), "attach_title" => 'reporte_' . $id_registro);
            }
        }
    }

    /**
     * @param $id_registro
     * @param $tipo 1:Recepción, 2: Reporte Trabajo, 3: Presupuesto, 4: Presupuesto Autorizado, 5: Presupuesto No Autorizado
     * @return array
     */
    private function datos_registro($id_registro, $tipo)
    {
        $query_registro = db_select('partners_taller', 'pt');
        $query_registro->innerJoin('partners_taller_equipos', 'pte', 'pte.id_registro_taller = pt.id_registro');
        $query_registro->fields('pte');
        $query_registro->addExpression("CASE pte.tipo_equipo WHEN 1 THEN 'CPU' WHEN 2 THEN 'Todo en uno' WHEN 3 THEN 'Laptop' WHEN 4 THEN 'Servidor' WHEN 5 THEN 'Impresora' WHEN 6 THEN 'Monitor' WHEN 7 THEN 'Tablet' WHEN 8 THEN 'Celular' WHEN 9 THEN 'Otro' END", 'nombre_tipo_equipo');
        $query_registro->fields('pt');
        $query_registro->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pt.id_cliente');
        $query_registro->fields('pc', array('nombre_cliente', 'tipo_clasificacion'));
        $query_registro->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pt.id_contacto');
        $query_registro->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query_registro->condition('pt.id_registro', $id_registro);
        $registro = $query_registro->execute()->fetchAssoc();
        $data['registro'] = $registro;

        if ($tipo == 1) {
            $data['tipo_reporte'] = $tipo;
        } else if ($tipo == 2) {
            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();
            $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_datos->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $presupuesto_datos->fields('ptpd');
            $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_datos->condition('autorizacion', 1);
            $presupuesto_datos->groupBy('id_dato');
            $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

            $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total->condition('autorizacion', 1);
            $total = $presupuesto_total->execute()->fetchField();
            $data['presupuesto_total'] = $total;
            $data['presupuesto'] = $presupuesto;
            $data['tipo_reporte'] = $tipo;
        } else if ($tipo == 3) {
            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();
            $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_datos->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $presupuesto_datos->fields('ptpd');
            $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_datos->condition('autorizacion', 0);
            $presupuesto_datos->groupBy('id_dato');
            $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

            $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total->condition('autorizacion', 0);
            $total = $presupuesto_total->execute()->fetchField();

            $data['presupuesto_total'] = $total;
            $data['presupuesto'] = $presupuesto;
            $data['tipo_reporte'] = $tipo;
        } else if ($tipo == 4) {
            // Es lo mismo que el presupuesto inicial, solamente que ahora se necesitan traer las piezas
            // autorizadas
            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();
            $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_datos->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $presupuesto_datos->fields('ptpd');
            $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_datos->condition('autorizacion', 1);
            $presupuesto_datos->groupBy('id_dato');
            $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

            $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
            $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_total->condition('autorizacion', 1);
            $total = $presupuesto_total->execute()->fetchField();

            $data['presupuesto_total'] = $total;
            $data['presupuesto'] = $presupuesto;
            $data['tipo_reporte'] = 3;
        } else if ($tipo == 5) {
            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $id_registro)
                ->execute()->fetchField();
            $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
            $presupuesto_datos->addExpression('SUM(ptpd.precio * ptpd.cantidad)', 'subtotal');
            $presupuesto_datos->fields('ptpd');
            $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
            $presupuesto_datos->condition('autorizacion', 0);
            $presupuesto_datos->groupBy('id_dato');
            $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

            $data['presupuesto'] = $presupuesto;
            $data['tipo_reporte'] = 5;
        }
        return $data;
    }

    private function enviar_presupuesto_correo($datos)
    {
        global $user;
        $data = [];
        $data['id_registro'] = $datos->id_registro;
        $data['user_mail'] = $user->mail;
        $data['body'] = $datos->body;

        $datos_registro = db_select('partners_taller', 'pt')
            ->fields('pt', array('id_cliente', 'id_contacto', 'created_at'))
            ->condition('id_registro', $datos->id_registro)
            ->execute()->fetchAssoc();
        $data['registro'] = $datos_registro;

        if ($datos_registro['id_contacto']) {
            $nombre = db_select('partners_clientes', 'pc')
                ->fields('pc', array('nombre_cliente'))
                ->condition('id_cliente', $datos_registro['id_contacto'])
                ->execute()->fetchField();
        } else {
            $nombre = db_select('partners_clientes', 'pc')
                ->fields('pc', array('nombre_cliente'))
                ->condition('id_cliente', $datos_registro['id_cliente'])
                ->execute()->fetchField();
        }
        $data['nombre_cliente'] = $nombre;

        $from = ['soporte@pcpartners.com.mx' => 'Pc Partners - Centro de Servicio'];

        $to = $datos->to;
        $to[] = $user->mail;
        $subject = 'Presupuesto.';
        $data_to_render = [];
        $data_to_render['id_registro'] = $datos->id_registro;
        // Type 1: = Return String to mail
        $data_to_render['type'] = 1;
        // Tipo 3 = Render Presupuesto
        $data_to_render['tipo'] = 3;
        $attachment_data = $this->render_reporte($data_to_render);
        $attachment = $attachment_data['pdf_string'];
        $attachment_title = $attachment_data['attach_title'];
        $this->send_mail('taller.mail_enviar_presupuesto', $data, $subject, $from, $to, $attachment, $attachment_title);
        $this->throw_message('success', 'Bien!');
    }

    private function editar_presupuesto_inicial($datos)
    {
        if ($datos->datos) {
            foreach ($datos->datos as $nuevo) {
                db_insert('partners_taller_presupuesto_datos')
                    ->fields(
                        array(
                            'id_presupuesto' => $datos->id_presupuesto,
                            'descripcion' => $nuevo->descripcion,
                            'precio' => $nuevo->precio,
                            'autorizacion' => 0,
                            'tipo' => $nuevo->tipo,
                            'iva' => $nuevo->iva,
                            'cantidad' => $nuevo->cantidad
                        )
                    )
                    ->execute();
            }
            $this->register_log_actions('partners_taller_presupuesto_datos', 'insert', 'Se agergaron nuevos registros al presupuesto ' . $datos->id_presupuesto . ' por user: ' . $datos->uid);
        }
        if ($datos->eliminados) {
            foreach ($datos->eliminados as $deleted) {
                db_delete('partners_taller_presupuesto_datos')
                    ->condition('id_dato', $deleted)
                    ->execute();
            }
            $this->register_log_actions('partners_taller_presupuesto_datos', 'delete', 'Se eliminó un registro del presupuesto inicial (id_presupuesto: ' . $datos->id_presupuesto . ') por user: ' . $datos->uid);
        }

        if ($datos->datos || $datos->eliminados) {
            db_update('partners_taller_presupuesto')
                ->fields(
                    array(
                        'updated_at' => REQUEST_TIME,
                        'updated_by' => $datos->uid
                    )
                )
                ->condition('id_presupuesto', $datos->id_presupuesto)
                ->execute();
            $this->throw_message('success', 'Presupuesto Inicial editado correctamente');
        } else {
            $this->throw_message('success', 'No editaste ningún dato.');
        }


    }

    private function autorizar_presupuesto($datos)
    {
        db_update('partners_taller_presupuesto')
            ->fields(
                array(
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $datos->uid,
                    'usuario_ingreso_autorizacion' => $datos->uid,
                    'fecha_autorizado' => REQUEST_TIME,
                    'fecha_compromiso' => strtotime($datos->fecha_compromiso),
                    'autorizado_por' => $datos->autorizado_por
                )
            )
            ->condition('id_presupuesto', $datos->id_presupuesto)
            ->execute();

        db_update('partners_taller')
            ->fields(
                array(
                    'presupuesto' => 2
                )
            )
            ->condition('id_registro', $datos->id_registro)
            ->execute();

        foreach ($datos->datos as $dato) {
            db_insert('partners_taller_presupuesto_datos')
                ->fields(
                    array(
                        'id_presupuesto' => $datos->id_presupuesto,
                        'descripcion' => $dato->descripcion,
                        'precio' => $dato->precio,
                        'autorizacion' => 1,
                        'tipo' => $dato->tipo,
                        'iva' => $dato->iva,
                        'cantidad' => $dato->cantidad
                    )
                )
                ->execute();
        }

        $this->throw_message('success', 'Presupuesto Autorzado correctamente');
        $this->register_log_actions('partners_taller_presupuesto', 'update', 'Se autorizó el presupuesto del id_registro_taller: ' . $datos->id_registro . ' por: ' . $datos->uid);
    }

    private function editar_presupuesto_autorizado($datos)
    {
        if ($datos->datos) {
            foreach ($datos->datos as $nuevo) {
                db_insert('partners_taller_presupuesto_datos')
                    ->fields(
                        array(
                            'id_presupuesto' => $datos->id_presupuesto,
                            'descripcion' => $nuevo->descripcion,
                            'precio' => $nuevo->precio,
                            'autorizacion' => 1,
                            'tipo' => $nuevo->tipo,
                            'iva' => $nuevo->iva,
                            'cantidad' => $nuevo->cantidad
                        )
                    )
                    ->execute();
            }
            $this->register_log_actions('partners_taller_presupuesto_datos', 'insert', 'Se agergaron nuevos registros al presupuesto autorizado' . $datos->id_presupuesto . ' por user: ' . $datos->uid);
        }
        if ($datos->eliminados) {
            foreach ($datos->eliminados as $deleted) {
                db_delete('partners_taller_presupuesto_datos')
                    ->condition('id_dato', $deleted)
                    ->execute();
            }
            $this->register_log_actions('partners_taller_presupuesto_datos', 'delete', 'Se eliminó un registro del presupuesto autorizado (id_presupuesto: ' . $datos->id_presupuesto . ') por user: ' . $datos->uid);
        }

        if ($datos->datos || $datos->eliminados) {
            db_update('partners_taller_presupuesto')
                ->fields(
                    array(
                        'updated_at' => REQUEST_TIME,
                        'updated_by' => $datos->uid
                    )
                )
                ->condition('id_presupuesto', $datos->id_presupuesto)
                ->execute();
            $this->throw_message('success', 'Presupuesto Autorizado editado correctamente');
        } else {
            $this->throw_message('success', 'No editaste ningún dato.');
        }


    }

    private function enviar_presupuesto_correo_autorizado($datos)
    {
        global $user;
        $data = [];
        $data['id_registro'] = $datos->id_registro;
        $data['user_mail'] = $user->mail;
        $data['body'] = $user->body;

        $datos_registro = db_select('partners_taller', 'pt')
            ->fields('pt', array('id_cliente', 'id_contacto', 'created_at'))
            ->condition('id_registro', $datos->id_registro)
            ->execute()->fetchAssoc();
        $data['registro'] = $datos_registro;

        if ($datos_registro['id_contacto']) {
            $nombre = db_select('partners_clientes', 'pc')
                ->fields('pc', array('nombre_cliente'))
                ->condition('id_cliente', $datos_registro['id_contacto'])
                ->execute()->fetchField();
        } else {
            $nombre = db_select('partners_clientes', 'pc')
                ->fields('pc', array('nombre_cliente'))
                ->condition('id_cliente', $datos_registro['id_cliente'])
                ->execute()->fetchField();
        }
        $data['nombre_cliente'] = $nombre;

        $from = ['no-reply@partnerscabling.com' => 'Pc Partners - Centro de Servicio'];

        $to = $datos->to;
        $to[] = $user->mail;
        $subject = 'Presupuesto.';
        $data_to_render = [];
        $data_to_render['id_registro'] = $datos->id_registro;
        // Type 1: = Return String to mail
        $data_to_render['type'] = 1;
        // Tipo 4 = Render Presupuesto Autorizado
        $data_to_render['tipo'] = 4;
        $attachment_data = $this->render_reporte($data_to_render);
        $attachment = $attachment_data['pdf_string'];
        $attachment_title = $attachment_data['attach_title'];
        $this->send_mail('taller.mail_enviar_presupuesto', $data, $subject, $from, $to, $attachment, $attachment_title);
        $this->throw_message('success', 'Bien!');
    }

    private function no_autorizar_presupuesto($datos)
    {
        db_update('partners_taller_presupuesto')
            ->fields(
                array(
                    'usuario_ingreso_autorizacion' => $datos->uid,
                    'fecha_autorizado' => REQUEST_TIME,
                    'no_autorizado' => 1,
                    'no_autorizado_por' => $datos->no_autorizado_por,
                    'que_hacer' => $datos->que_hacer
                )
            )
            ->condition('id_presupuesto', $datos->id_presupuesto)
            ->execute();

        // Donar
        if ($datos->que_hacer == 1) {
            db_update('partners_taller')
                ->fields(
                    array(
                        'servicio_entregado' => 1,
                        'servicio_abierto' => 0,
                        'presupuesto' => 3
                    )
                )
                ->condition('id_registro', $datos->id_registro)
                ->execute();
        } else {
            // Pasa a recoger , no se entrega el servicio
            db_update('partners_taller')
                ->fields(
                    array(
                        'servicio_abierto' => 0,
                        'presupuesto' => 3
                    )
                )
                ->condition('id_registro', $datos->id_registro)
                ->execute();

        }

        $this->throw_message('success', 'Presupuesto No Autorizado correctamente.');
        $this->register_log_actions('partners_taller_presupuesto', 'update', 'Se marcó el presupuesto ' . $datos->id_presupuesto . ' no autorizado, por el usuario ' . $datos->uid);
    }

    private function vista_proceso($id_registro, $returned = NULL)
    {
        if (!$returned)
            $datos = self::vista_datos_generales($id_registro, 1);
        $check_revision_done = db_select('partners_taller', 'pt')
            ->fields('pt', array('status_proceso'))
            ->condition('id_registro', $id_registro)
            ->execute()->fetchField();

        // Revisión aún no realizada
        if ($check_revision_done == 0) {
            $datos['revision'] = self::get_revision_pending_data(2);
            $datos['revision_realizada'] = 0;
        } else {
            $datos['revision'] = self::get_revision_done_data($id_registro, 2);
            $datos['revision_info'] = self::get_revision_info_done_data($id_registro, 2);
            $datos['revision_realizada'] = 1;
        }

        $datos['id_registro'] = $id_registro;

        if ($returned) {
            return $datos;
        } else {
            $template = render_template('php', 'taller.proceso', $datos);
            $this->throw_message('success', $template);
        }

    }

    /**
     * @param $datos
     * @throws Exception
     * @deprecated
     */
    private function capturar_proceso($datos)
    {
        $proceso = db_insert('partners_taller_revisiones')
            ->fields(
                array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $datos->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $datos->uid,
                    'id_registro_taller' => $datos->id_registro,
                    'tipo_revision' => 2
                )
            )
            ->execute();

        foreach ($datos->datos as $dato) {
            db_insert('partners_taller_revisiones_datos')
                ->fields(
                    array(
                        'id_tipo_dato_revision' => $dato->id_tipo_dato,
                        'id_revision' => $proceso,
                        'valor' => $dato->value
                    )
                )
                ->execute();
        }

        db_update('partners_taller')
            ->fields(
                array(
                    'status_proceso' => $proceso,
                )
            )
            ->condition('id_registro', $datos->id_registro)
            ->execute();
        $this->register_log_actions('partners_taller_revisiones', 'insert', 'Se capturó el proceso por: ' . $datos->uid . ' al id_registro: ' . $datos->id_registro);
        $this->throw_message('success', 'Proceso Generado correctamente.');
    }

    private function vista_revision_final($id_registro, $returned = NULL)
    {

        if (!$returned)
            $datos = self::vista_datos_generales($id_registro, 1);
        $check_revision_done = db_select('partners_taller', 'pt')
            ->fields('pt', array('revision_final'))
            ->condition('id_registro', $id_registro)
            ->execute()->fetchField();

        // Revisión aún no realizada
        if ($check_revision_done == 0) {
            $datos['revision'] = self::get_revision_pending_data(3);
            $datos['revision_realizada'] = 0;
        } else {
            $datos['revision'] = self::get_revision_done_data($id_registro, 3);
            $datos['revision_info'] = self::get_revision_info_done_data($id_registro, 3);
            $datos['revision_realizada'] = 1;
        }

        $datos['id_registro'] = $id_registro;

        if ($returned) {
            return $datos;
        } else {
            $template = render_template('php', 'taller.revision_final', $datos);
            $this->throw_message('success', $template);
        }

    }

    private function capturar_revision_final($datos)
    {
        $revision_final = db_insert('partners_taller_revisiones')
            ->fields(
                array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $datos->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $datos->uid,
                    'id_registro_taller' => $datos->id_registro,
                    'tipo_revision' => 3
                )
            )
            ->execute();

        foreach ($datos->datos as $dato) {
            db_insert('partners_taller_revisiones_datos')
                ->fields(
                    array(
                        'id_tipo_dato_revision' => $dato->id_tipo_dato,
                        'id_revision' => $revision_final,
                        'valor' => $dato->value
                    )
                )
                ->execute();
        }
        $check_domicilio = db_select('partners_taller', 'pt')
            ->fields('pt', array('tipo_servicio'))
            ->condition('id_registro', $datos->id_registro)
            ->execute()->fetchField();

        db_update('partners_taller')
            ->fields(
                array(
                    'revision_final' => $revision_final,
                    'servicio_abierto' => 0,
                    'servicio_entregado' => ($check_domicilio == 2) ? 2 : 0
                )
            )
            ->condition('id_registro', $datos->id_registro)
            ->execute();
        $this->register_log_actions('partners_taller_revisiones', 'insert', 'Se capturó la revisión final por: ' . $datos->uid . ' al id_registro: ' . $datos->id_registro);
        $this->throw_message('success', 'Revisión Final Generada correctamente.');
    }

    private function capturar_entregado($datos)
    {
        db_update('partners_taller')
            ->fields(
                array(
                    'servicio_entregado' => 1
                )
            )
            ->condition('id_registro', $datos->id_registro)
            ->execute();

        $this->register_log_actions('partners_taller', 'update', 'Se marcó como entregado el registro de Centro de servicio: ' . $datos->id_registro . ' por el usuario: ' . $datos->uid);
        $this->throw_message('success', 'Servicio entregado correctamente.');
    }

    /**
     * @param $id_registro {int} solamente con este id_registro se llena todos los datos existentes del registro,
     * se utilizan las funciones ya existentes para que solo regresen la pura información y no el template.
     */
    private function vista_general_completa($id_registro)
    {
        $datos = self::vista_datos_generales($id_registro, 1);
        $datos['revision_inicial'] = self::vista_revision_inicial($id_registro, 1);
        $datos['presupuesto'] = self::vista_presupuesto($id_registro, 1);
        $datos['proceso'] = self::vista_proceso($id_registro, 1);
        $datos['revision_final'] = self::vista_revision_final($id_registro, 1);
        $datos['id_registro'] = $id_registro;
        $datos['use_secondary_render_revision'] = 1;
        $template = render_template('php', 'taller.vista_general_completa', $datos);
        $this->throw_message('success', $template);
    }

    private function update_status($datos)
    {
        global $user;
        if ($datos->obs) {
            db_update('partners_taller')
                ->fields(
                    array(
                        $datos->col => $datos->new_val,
                        'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_taller', 'id_registro', $datos->id_registro)
                    )
                )
                ->condition('id_registro', $datos->id_registro)
                ->execute();
        } else {
            db_update('partners_taller')
                ->fields(
                    array(
                        $datos->col => $datos->new_val,
                    )
                )
                ->condition('id_registro', $datos->id_registro)
                ->execute();
        }

        if (isset($datos->capturar_caja) && $datos->capturar_caja != '') {
            $this->capturar_entrada_caja($datos->concepto_capturar_caja, $datos->cantidad_capturar_caja);
        }

        if (isset($datos->facturado) && $datos->facturado != '') {
            $this->track_down_facturado($datos->numero_factura, $datos->id_registro, "Administrador de Centro de Servicio", "partners_taller");
        }
        $this->register_log_actions('partners_taller', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
        $this->throw_message('success', "Cambios Guardados");
    }

    /**
     * @param $datos ->type 1: render_vista ,2 : capturar
     */
    private function modificacion_costos($datos)
    {
        if ($datos->type == 1) {
            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $datos->id_registro)
                ->execute()->fetchField();

            $get_piezas = db_select('partners_taller_presupuesto_datos', 'ptpd')
                ->fields('ptpd')
                ->condition('ptpd.id_presupuesto', $id_presupuesto)
                ->condition('ptpd.tipo', 1)
                ->condition('ptpd.autorizacion', 1);
            $piezas = $get_piezas->execute()->fetchAll(PDO::FETCH_ASSOC);
            $data = [];
            $data['id_presupuesto'] = $id_presupuesto;
            $data['piezas'] = $piezas;
            $render_tpl = render_template('php', 'taller.vista_modificacion_piezas', $data);

            $this->throw_message('success', $render_tpl);
        } else if ($datos->type == 2) {
            if ($datos->datos) {
                foreach ($datos->datos as $pieza) {
                    db_update('partners_taller_presupuesto_datos')
                        ->fields(
                            array(
                                'costo' => strtr($pieza->new_costo, array(',' => ''))
                            )
                        )
                        ->condition('id_dato', $pieza->id_pieza)
                        ->execute();
                }
                $this->throw_message('success', 'Piezas modificadas correctamente');
            }
        }
    }

    private function reporte_base_buscador($datos)
    {
        $query = db_select('partners_taller', 'pt');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pt.id_cliente');
        $query->fields('pc', array('nombre_cliente', 'tipo_clasificacion'));
        $query->innerJoin('partners_taller_equipos', 'pte', 'pte.id_registro_taller = pt.id_registro');
        $query->fields('pte');
        $query->fields('pt');
        $query->addField('pt', 'created_at', 'fecha_creacion_registro');
        $query->leftJoin('partners_taller_presupuesto', 'ptp', 'ptp.id_registro_taller = pt.id_registro');
        $query->fields('ptp', array('fecha_compromiso', 'que_hacer'));
        $query->addField('ptp', 'created_at', 'fecha_creacion_presupuesto');


        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $taller_or = db_or()
                ->condition('pt.id_registro', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pt.descripcion_problema', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pt.info_respaldar', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.procesador_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.memoria_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.disco_duro_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.marca_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.modelo_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.serie_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.user_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.pass_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.caracteristicas_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.accesorios_equipo', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pte.tipo_impresora', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $query->condition($taller_or);
        }

        $query->orderBy($datos->sort->sort_by, $datos->sort->order);
        $query_datos = $query->execute();

        $taller = [];
        while ($row = $query_datos->fetchAssoc()) {
            $fecha_creacion = array("data" => date('d/m/y', $row['fecha_creacion_registro']), "class" => array("cursor-pointer", "vista_general"));
            $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 16, "utf-8"), "class" => array("cursor-pointer", "vista_general_completa"));
            # Hardcoded
            # 14/08/18 ultimo folio 10906
            if ($row['id_registro'] > 10906) {
                $folio = array("data" => strtoupper($row['tipo_clasificacion']) . '-' . $row['id_registro'], "class" => array("cursor-pointer", "vista_general_completa", ($row['servicio_garantia'] ? 'status-yellow' : '')));
            } else {
                $folio = array("data" => $row['id_registro'], "class" => array("cursor-pointer", "vista_general_completa", ($row['servicio_garantia'] ? 'status-yellow' : '')));
            }
            $tipo_equipo_id = $row['tipo_equipo'];

            switch ($tipo_equipo_id) {
                case 1:
                    $tipo_equipo = 'CPU';
                    break;
                case 2:
                    $tipo_equipo = 'Todo en uno';
                    break;
                case 3:
                    $tipo_equipo = 'Laptop';
                    break;
                case 4:
                    $tipo_equipo = 'Servidor';
                    break;
                case 5:
                    $tipo_equipo = 'Impresora';
                    break;
                case 6:
                    $tipo_equipo = 'Monitor';
                    break;
                case 7:
                    $tipo_equipo = 'Tablet';
                    break;
                case 8:
                    $tipo_equipo = 'Celular';
                    break;
                case 9:
                    $tipo_equipo = 'Otro';
                    break;
            }

            $equipo = array("data" => $tipo_equipo . ' | ' . $row['marca_equipo'] . ' | ' . $row['modelo_equipo'], "class" => array("cursor-pointer", "vista_general_completa"));
            $problema = array("data" => mb_substr($row['descripcion_problema'], 0, 30, "utf-8"), "class" => array("cursor-pointer", "vista_general_completa"));


            // +++++++++++++ FECA COMPROMISO ++++++++++++++++++
            $dia_actual = date('d', REQUEST_TIME);
            $dia_fecha_compromiso = date('d', $row['fecha_compromiso']);
            if ($row['presupuesto'] == 3) { // validar que no se haya puesto en no autorizado el presupuesto
                $fecha_compromiso = array("data" => "No Aut", "class" => array("status-red", "text-center"));
            } else {
                if ($row['fecha_compromiso'] != 0) {
                    if ($row['servicio_entregado'] == 1) { // si ya se entrego muestra la fecha sin nada
                        $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']));
                    } else {
                        if (REQUEST_TIME >= ($row['fecha_compromiso'] - 86400)) { // 1 dia de diferencia

                            if ($dia_actual == $dia_fecha_compromiso) { // mismo dia
                                $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']), "class" => array("red_blink"));
                            } else if ($dia_actual > $dia_fecha_compromiso) { // se paso por 1 dia
                                $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']), "class" => array("red_blink"));
                            } else { // no mismo dia pero igual 1 dia de diferencia
                                $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']), "class" => array("yellow_blink"));
                            }
                        } else { // aun no esta a 1 dia de diferencia
                            $fecha_compromiso = array("data" => date('d/m/y', $row['fecha_compromiso']));
                        }
                    }
                } else { // aun no existe
                    $fecha_compromiso = 'Pendiente';
                }
            }
            // +++++++++++++ FECHA COMPROMISO ++++++++++++++++++

            // +++++++++++++ OBSERVACIONES ++++++++++++++++++
            if ($row['observaciones'] != null) {
                $observaciones = array("data" => 'Bitácora', "class" => array("status-yellow", "taller-observaciones", "cursor-pointer", "text-center"));
            } else {
                $observaciones = array("data" => 'Bitácora', "class" => array("taller-observaciones", "cursor-pointer", "text-center"));
            }
            // +++++++++++++ OBSERVACIONES ++++++++++++++++++

            // +++++++++++++++ ENTREGADO ++++++++++++++++++++
            $entregado = $row['servicio_entregado'];
            if ($row['presupuesto'] == 3 && $row['que_hacer'] == 2) {
                $servicio_entregado = array("data" => "X Recoger", "class" => array("text-center"));
            } else {
                if ($row['revision_final'] != 0) {
                    if ($entregado == 0) {
                        if ($row['tipo_servicio'] == 1) {
                            $servicio_entregado = array("data" => "X Recoger", "class" => array("text-center"));
                        }
                    } else if ($entregado == 1) {
                        $servicio_entregado = array("data" => "Entregado", "class" => array("status-green", "text-center"));
                    } else if ($entregado == 2) {
                        $servicio_entregado = array("data" => "Programar", "class" => array("status-yellow", "text-center"));
                    }
                } else {
                    $servicio_entregado = array("data" => "ND", "class" => array("cursor-disabled", "text-center"));
                }
            }
            // +++++++++++++++ ENTREGADO ++++++++++++++++++++

            // +++++++++++++++ TOTAL SERVICIO TALLER ++++++++++++++++++++
            if ($row['id_presupuesto']) {
                $total = array("data" => number_format(self::total_servicio_taller($row['id_presupuesto'], 2), 2, '.', ','), "class" => array("text-right"));
            } else {
                $total = 'Pendiente';
            }
            // +++++++++++++++ TOTAL SERVICIO TALLER ++++++++++++++++++++


            // +++++++++++++++ IMPRIMIR ++++++++++++++++++++
            $imprimir = array("data" => "<i class='fa fa-print' aria-hidden='true'></i>", "class" => array("text-center", "imprimir_registro", "cursor-pointer"));
            // +++++++++++++++ IMPRIMIR ++++++++++++++++++++


            $taller[] = array(
                "data" => array(
                    $folio,
                    $fecha_creacion,
                    $cliente,
                    $equipo,
                    $problema,
                    $total,
                    $fecha_compromiso,
                    $servicio_entregado,
                    $observaciones,
                    $imprimir,
                ),
                "data-id-registro" => $row['id_registro'],
                "data-status-presupuesto" => $row['presupuesto'],
            );
        }

        $header_cols = array(
            array("name" => "Folio", "sortable" => 0),
            array("name" => "Fecha <br/> Ingreso", "sortable" => 0),
            array("name" => "Cliente", "sortable" => 0),
            array("name" => "Equipo", "sortable" => 0),
            array("name" => "Problema", "sortable" => 0),
            array("name" => "Precio", "sortable" => 0),
            array("name" => 'Compromiso', "sortable" => 0),
            array("name" => 'Entregado', "sortable" => 0),
            array("name" => 'Bitácora', "sortable" => 0),
            array("name" => '<i class="fa fa-print" aria-hidden="true"></i>', "sortable" => 0),
        );

        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $taller,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_taller_buscador", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;

    }

    private function marcar_facturado($datos)
    {
        $name_factura = $datos->rfc_cliente . 'FE00000' . $datos->folio_factura;
        if (file_exists(HOME_SERVER . 'facturas/' . $name_factura . '.zip')) {
            setlocale(LC_TIME, "es_MX");
            $id_registro = $datos->folio_registro;
            $registro = $this->datos_registro($id_registro, 2);
            $data['id_registro'] = $id_registro;
            $html = render_template('php', 'taller.render_reporte', $registro);
            $this->generate_pdf($html, 'Reporte de Servicio ' . $id_registro, 'reporte_' . $id_registro, 3);

            $ruta_pdf = HOME_SERVER . 'facturas_tmp/reporte_' . $id_registro . '.pdf';
            // Una vez con el archivo en el servidor, se deberá meter al zip y despues eliminar el archivo tmp.
            $zip = new ZipArchive;
            if ($zip->open(HOME_SERVER . 'facturas/' . $name_factura . '.zip') === TRUE) {
                // Agregar el .pdf del servicio al zip y después cerrar el zip.
                $zip->addFile($ruta_pdf, 'reporte_' . $id_registro . '.pdf');
                $zip->close();

                // Una vez que se allá agregado el pdf del servicio al zip, se elimina este pdf que solo se necesitaba
                // temporalmente
                unlink($ruta_pdf);

                db_update('partners_taller')
                    ->fields(
                        array(
                            'facturado' => 2,
                        )
                    )
                    ->condition('id_registro', $datos->folio_registro)
                    ->execute();

                $this->track_down_facturado($datos->folio_factura, $datos->folio_registro, "Administrador de Centro de Servicio", "partners_taller", "F-" . $datos->folio_registro);
                $this->throw_message('success', 'Servicio marcado como facturado correctamente.');
            } else {
                $this->throw_message('error', 'Ocurrio un error al tratar de abrir el zip de la factura.');
            }
        } else {
            $this->throw_message('error', "No se  encuentra la factura en el servidor, primero subela y repite este proceso.");
        }
    }

    /**
     * Actualiza el estatus de status_especial, simplemente SI/NO
     * @param $datos
     * @throws Exception
     */
    private function status_especial($datos)
    {
        db_update('partners_taller')
            ->fields(
                array(
                    'observaciones' => $this->serialize_obs($datos->motivo, 2, 'partners_taller', 'id_registro', $datos->folio),
                    'status_especial' => $datos->especial,
                )
            )
            ->condition('id_registro', $datos->folio)
            ->execute();

        $this->register_log_actions(
            'partners_taller',
            'update',
            'Se actualizó el estatus de status_especial a : ' . $datos->especial . ' del folio: ' . $datos->folio
        );

        $this->throw_message('success', 'Estatus actualizado correctamente.');
    }

    /**
     * Actualiza el estatus de status_problema, simplemente SI/NO
     * @param $datos
     * @throws Exception
     */
    private function status_problema($datos)
    {
        db_update('partners_taller')
            ->fields(
                array(
                    'observaciones' => $this->serialize_obs($datos->motivo, 2, 'partners_taller', 'id_registro', $datos->folio, $datos->user),
                    'status_problema' => $datos->problema,
                )
            )
            ->condition('id_registro', $datos->folio)
            ->execute();

        $this->register_log_actions(
            'partners_taller',
            'update',
            'Se actualizó el estatus de status_problema a : ' . $datos->problema . ' del folio: ' . $datos->folio
        );

        $this->throw_message('success', 'status Problema actualizado correctamente.');
    }
}