<?php

class solicitud_factura_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'capturar_solicitud_cliente_nuevo':
                    try {
                        $this->capturar_solicitud_cliente_nuevo($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_solicitud_cliente_nuevo');
                    }
                    break;
                case 'capturar_solicitud_cliente_existente':
                    try {
                        $this->capturar_solicitud_cliente_existente($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_solicitud_cliente_existente');
                    }
                    break;
            }
        }
    }

    private function capturar_solicitud_cliente_nuevo($datos)
    {
        global $user;
        $from = ['no-reply@partnerscabling.com' => 'Pc Partners - Solicitud Factura'];
        $to = array('administracion@pcpartners.com.mx', 'facturacion@pcpartners.com.mx', 'roberto@pcpartners.com.mx');
        $data['nombre_cliente'] = $datos->nombre_cliente_nuevo;
        $data['rfc'] = $datos->rfc1 . $datos->rfc2 . $datos->rfc3;
        $data['curp'] = $datos->curp_cliente_nuevo;
        $data['calle'] = $datos->calle_cliente_nuevo;
        $data['colonia'] = $datos->colonia_cliente_nuevo;
        $data['cp'] = $datos->cp_cliente_nuevo;
        $data['ciudad'] = $datos->ciudad_cliente_nuevo;
        $data['estado'] = $datos->estado_cliente_nuevo;
        $data['concepto'] = $datos->concepto_cliente_nuevo;
        $data['cantidad'] = $datos->cantidad_cliente_nuevo;
        $data['metodo'] = $datos->metodo_cliente_nuevo;
        $data['telefono'] = $datos->telefono_cliente_nuevo;
        $data['email'] = $datos->email_cliente_nuevo;
        $data['email1'] = $datos->email_1_cliente_nuevo;
        $data['email2'] = $datos->email_2_cliente_nuevo;
        $data['observaciones'] = $datos->observaciones_cliente_nuevo;
        $data['nombre_usuario'] = $user->name;

        $this->send_mail('solicitud_factura.enviar_cliente_nuevo', $data, 'Solicitud Factura Cliente Nuevo', $from, $to);
        $this->throw_message('success', 'Good');
    }

    private function capturar_solicitud_cliente_existente($datos)
    {
        global $user;
        $nombre_cliente = db_select('partners_clientes', 'pc')
            ->fields('pc', array('nombre_cliente'))
            ->condition('id_cliente', $datos->id_cliente)
            ->execute()->fetchField();
        $from = ['no-reply@partnerscabling.com' => 'Pc Partners - Solicitud Factura'];
        $to = array('administracion@pcpartners.com.mx', 'facturacion@pcpartners.com.mx', 'roberto@pcpartners.com.mx');
        $data['concepto'] = $datos->concepto_cliente_existente;
        $data['cantidad'] = $datos->cantidad_cliente_existente;
        $data['observaciones'] = $datos->observaciones_cliente_existente;
        $data['nombre_usuario'] = $user->mail;
        $data['nombre_cliente'] = $nombre_cliente;

        $this->send_mail('solicitud_factura.enviar_cliente_existente', $data, 'Solicitud Factura Cliente Existente', $from, $to);
        $this->throw_message('success', 'Good');
    }
}
