<?php

class servicios_sys extends sys_tools
{
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'capturar_servicio':
          try {
            $this->capturar_servicio($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_servicio');
          }
          break;
        case 'enviar_reporte_correo':
          try {
            $this->enviar_reporte_correo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'enviar_reporte_correo');
          }
          break;
        case 'render_vista':
          try {
            $this->render_reporte($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'render_vista_reporte');
          }
          break;
        case 'get_datos_from_pendiente';
          try {
            $this->get_datos_from_pendiente($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_datos_from_pendiente');
          }
          break;
        case 'reporte_base';
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cargar_reporte_base');
          }
          break;
        case 'update_status':
          try {
            $this->update_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'updating_status_reporte');
          }
          break;
        case 'eliminar_servicio':
          try {
            $this->eliminar_servicio($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'eliminar_servicio');
          }
          break;
        case 'reactivate_servicio':
          try {
            $this->reactivate_servicio($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reactivate_servicio');
          }
          break;
        case 'modificacion_costos':
          try {
            $this->modificacion_costos($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'modificacion_costos');
          }
          break;
        case 'get_list_piezas':
          try {
            $this->get_list_piezas($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_list_piezas');
          }
          break;
        case 'vista_costos_simple':
          try {
            $this->vista_costos_simple($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_costos_simple');
          }
          break;
        case 'marcar_facturado':
          try {
            $this->marcar_facturado($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'marcar_facturado');
          }
          break;
        case 'vista_facturar_servicio':
          try {
            $this->vista_facturar_servicio($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_facturar_servicio');
          }
          break;
        case 'facturar_servicio':
          try {
            $this->facturar_servicio($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'facturar_servicio');
          }
          break;
        case 'status_pagado_otro':
          try {
            $this->status_pagado_otro($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'status_pagado_otro');
          }
          break;
        case 'status_especial':
          try {
            $this->status_especial($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'status_especial');
          }
          break;
        case 'get_servicio_data':
          try {
            $this->getServicioData($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'getServicioData');
          }
          break;
        case 'agregar_firma':
          try {
            $this->agregarFirma($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'agregarFirma');
          }
          break;
      }
    }
  }


  private function capturar_servicio($datos)
  {
    $tipo_servicio = (int) $datos->tipo_servicio;
    global $user;
    /**
     * @tipo_servicio | 1: remoto, 2: interno, 3: actividad, 4: domicilio
     */
    /**
     * La firma se guarda en base64 en tipo TEXT, es decir que tiene un máximo de
     * 64KB (65,535 caracteres).
     * como máximo la firma guarda 20KB
     * Suponiendo que se hagan máximo 2,000 servicios al año firmados, se utilizarán 40MB al año en firmas
     *
     * De forma más realista se utilizrían al rededor de 15MB
     */
    $firma = $datos->firmado ? $datos->firma : null;

    /// Descuento de horas ///
    // Si el cliente pagó con poliza, tiene asignado un folio en el servicio:
    if ((int) $datos->folio_poliza != 0 && $tipo_servicio != 2) {
      // obtener horas utilizadas
      $horas = $datos->servicio_horas_fijas > 0 ? $datos->servicio_horas_fijas : $datos->horas_totales;
      if ($horas > 0) {
        // obtener saldo del cliente
        $saldo = db_query("select saldo_horas from partners_clientes where id_cliente = :id_cliente", array(":id_cliente" => $datos->id_cliente))->fetch();
        $saldo_f = ((int) $saldo->saldo_horas - (int) $horas);
        // Obtener horas_usadas y horas_incluidas de la poliza actuales
        $horas_u = db_query("select horas_usadas, horas_incluidas from partners_polizas where id_poliza = :id_poliza", array(":id_poliza" => $datos->folio_poliza))->fetch();

        // Actualizar el saldo en la tabla de clientes y en la de polizas
        db_update("partners_clientes")
          ->fields(
            array(
              'saldo_horas' => $saldo_f
            )
          )
          ->condition('id_cliente', $datos->id_cliente)
          ->execute();
        db_update("partners_polizas")
          ->fields(
            array(
              'saldo_cliente' => $saldo_f
            )
          )
          ->condition('id_cliente', $datos->id_cliente)
          ->execute();
        db_insert("partners_servicios_polizas")
          ->fields(
            array(
              'saldo_inicial' => $saldo->saldo_horas,
              'horas_usadas' => $horas,
              'id_poliza' => $datos->folio_poliza,
            )
          )
          ->execute();
        $servicio_poliza = db_query("select max(id_servicio_poliza) as id_servicio_poliza from partners_servicios_polizas ")->fetch();
        $servicio_poliza = $servicio_poliza->id_servicio_poliza;

        // Si las horas utilizadas son iguales o mayores a las incluidas, verificar si el saldo es mayor.
        $horas_usadas = $horas_u->horas_usadas + $horas;

        // Si lo que se va a usar es igual o mayor al saldo de la poliza actual...
        $saldo_poliza = $horas_u->horas_incluidas - $horas_u->horas_usadas;

        if ((int) $horas >= (int) $saldo_poliza) {
          // En caso de ser mayores, realizar el calculo con base en el saldo
          if ($horas < $saldo->saldo_horas) {
            // En el reporte, si las horas de saldo son mayores a las del límite del paquete, restarlas
            // y ponerlas en la tabla como "Horas heredadas"
            db_update("partners_polizas")
              ->fields(
                array(
                  'horas_usadas' => $horas_usadas,
                )
              )
              ->condition('id_poliza', $datos->folio_poliza)
              ->execute();
          } else if ($horas == $saldo->saldo_horas) {
            db_update("partners_polizas")
              ->fields(
                array(
                  'horas_usadas' => $horas_usadas,
                  'estado' => 0
                )
              )
              ->condition('id_poliza', $datos->folio_poliza)
              ->execute();
          } else {
            $this->throw_message('error', 'No se cuenta con las horas necesarias, favor de revisar el proceso.');
          }
        } else { // Si las horas incluidas son suficientes, hacer el proceso normal.
          // Actualizar las horas_usadas de la poliza //
          db_update("partners_polizas")
            ->fields(
              array(
                'horas_usadas' => ((int) $horas_u->horas_usadas + (int) $horas)
              )
            )
            ->condition('id_poliza', $datos->folio_poliza)
            ->execute();
        }
      }
    }
    ///////
    if (($datos->radio_tipo_precio == 6 || $datos->radio_tipo_precio == 4) && $tipo_servicio != 2) {

      // Obtener tipo de poliza
      $tid = db_query("select tipo_poliza from partners_polizas where id_poliza = :id_poliza", array(':id_poliza' => $datos->folio_poliza))->fetch();

      // obtener el precio por hora segun el tipo de poliza
      $precio_hora = db_select('partners_paquetes_polizas', 'p')
        ->fields('p', array('precio_hora'))
        ->condition('p.tid', (int) $tid->tipo_poliza)
        ->execute()->fetchAll(PDO::FETCH_ASSOC);

      // calcular el precio segun el tipo de cobro
      if ($datos->servicio_horas_fijas > 0) {
        $datos->servicio_total = (int) $datos->servicio_horas_fijas * (int) $precio_hora[0]['precio_hora'];
      } else {
        $datos->servicio_total = (int) $datos->horas_totales * (int) $precio_hora[0]['precio_hora'];
      }
    }


    $capturar_servicio = db_insert('partners_servicios')
      ->fields(
        array(
          'created_at' => REQUEST_TIME,
          'created_by' => $user->uid,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'fecha_reporte' => strtotime($datos->fecha_servicio),
          'tipo_servicio' => $tipo_servicio,
          'id_cliente' => $datos->id_cliente,
          'id_pendiente' => (isset($datos->id_pendiente) && $datos->id_pendiente != '') ? $datos->id_pendiente : null,
          'hora_inicial' => (isset($datos->hora_inicial_servicio) && $datos->hora_inicial_servicio != '') ? $datos->hora_inicial_servicio : null,
          'hora_final' => (isset($datos->hora_final_servicio) && $datos->hora_final_servicio != '') ? $datos->hora_final_servicio : null,
          'servicio_total' => ($datos->servicio_total == '') ? 0 : strtr($datos->servicio_total, array(',' => '')),
          'servicio_pagado' => (isset($datos->radio_seleccion_pagado) && $datos->radio_seleccion_pagado != '') ? $datos->radio_seleccion_pagado : null,
          'forma_pago' => $datos->forma_pago_servicio,
          'horas_totales' => (isset($datos->horas_totales) && $datos->horas_totales != '') ? $datos->horas_totales : null,
          'detalle_servicio' => $datos->descripcion_servicio,
          'recibido_por' => $datos->servicio_recibido_por,
          'observaciones' => (isset($datos->notas_internas) && $datos->notas_internas != '') ? $this->serialize_obs($datos->notas_internas, 1) : null,
          'id_usuario_interno' => (isset($datos->usuario_solicita_servicio) && $datos->usuario_solicita_servicio != '') ? $datos->usuario_solicita_servicio : null,
          'motivo_porque_no_se_cobra' => $datos->motivo_actividad,
          'servicio_compartido' => (isset($datos->radio_servicio_compartido) && $datos->radio_servicio_compartido != '') ? $datos->radio_servicio_compartido : null,
          'usuario_compartido_con' => (isset($datos->servicio_compartido_con) && $datos->servicio_compartido_con != '') ? $datos->servicio_compartido_con : null,
          'tipo_precio' => $datos->radio_tipo_precio,
          'piezas_domicilio' => (isset($datos->piezas_domicilio) && $datos->piezas_domicilio != '') ? $datos->piezas_domicilio : null,
          'firma' => $firma,
          'folio_poliza' => $datos->folio_poliza,
          'id_servicio_poliza' => $servicio_poliza,
        )
      )
      ->execute();


    if ($datos->radio_servicio_compartido == 1) {
      $get_created_servicio = db_select('partners_servicios', 'ps')
        ->fields('ps')
        ->condition('id_servicio', $capturar_servicio)
        ->execute()->fetchAssoc();

      $capturar_servicio_copia_compartido = db_insert('partners_servicios')
        ->fields(
          array(
            'created_at' => $get_created_servicio['created_at'],
            'created_by' => $get_created_servicio['usuario_compartido_con'],
            'updated_at' => $get_created_servicio['updated_at'],
            'updated_by' => $get_created_servicio['usuario_compartido_con'],
            'fecha_reporte' => $get_created_servicio['fecha_reporte'],
            'tipo_servicio' => $get_created_servicio['tipo_servicio'],
            'id_cliente' => $get_created_servicio['id_cliente'],
            'id_pendiente' => $get_created_servicio['id_pendiente'],
            'hora_inicial' => $get_created_servicio['hora_inicial'],
            'hora_final' => $get_created_servicio['hora_final'],
            'servicio_total' => $get_created_servicio['servicio_total'],
            'servicio_pagado' => $get_created_servicio['servicio_pagado'],
            'forma_pago' => $get_created_servicio['forma_pago'],
            'horas_totales' => $get_created_servicio['horas_totales'],
            'detalle_servicio' => "Compartido",
            'recibido_por' => $get_created_servicio['recibido_por'],
            'observaciones' => $get_created_servicio['observaciones'],
            'id_usuario_interno' => $get_created_servicio['id_usuario_interno'],
            'motivo_porque_no_se_cobra' => $get_created_servicio['motivo_porque_no_se_cobra'],
            'servicio_compartido' => $get_created_servicio['servicio_compartido'],
            'usuario_compartido_con' => $get_created_servicio['created_by'],
            'tipo_precio' => $get_created_servicio['tipo_precio'],
            'piezas_domicilio' => $get_created_servicio['piezas_domicilio'],
            'compartido_copia' => 1,
            'pagado_admon' => 3
          )
        )
        ->execute();
    }
    // Si es un servicio interno, hay que enviar automaticamente un correo
    $datos_usuario_interno = [];
    if ((int) $tipo_servicio == 2) {
      try {
        $datos_usuario_interno = db_query("select name, mail from users where uid = " . (int) $datos->usuario_solicita_servicio)->fetchAssoc();

        $datosEnvio = new StdClass();
        $datosEnvio->to = $datos_usuario_interno['mail'];
        $datosEnvio->id_servicio = $capturar_servicio;
        //$this->enviar_reporte_correo($datosEnvio);

        //$this->send_mail('servicios.mail_enviar_servicio', json_decode(json_encode($datos), true), "Autorización de Servicio.", $user->mail, $datos_usuario_interno['mail']);
        return $this->throw_message("success", json_encode($datosEnvio));
      } catch (Exception $e) {
        return $this->throw_message("error", $e->getMessage());
      }

    }


    // Si utiliza paquete/poliza, registre el movimiento
    if (($datos->radio_tipo_precio == 6 || $datos->radio_tipo_precio == 4) && $tipo_servicio != 2) {
      $id_servicio = db_query("select max(id_servicio) as id_servicio from partners_servicios limit 1")->fetch();
      $id_servicio = $id_servicio->id_servicio;
      db_update("partners_servicios_polizas")
        ->fields(array('id_servicio' => $id_servicio))
        ->condition('id_servicio_poliza', $servicio_poliza)
        ->execute();
    }
    // Si es servicio compartido, entonces crear una replica pero ahora para el usuario con el que se está compartiendo este servicio

    if (isset($datos->piezas) && $datos->piezas != '') {
      foreach ($datos->piezas as $pieza) {
        db_insert('partners_servicios_datos')
          ->fields(
            array(
              'id_servicio' => $capturar_servicio,
              'pieza_nombre' => $pieza->descripcion,
              'pieza_precio' => ($pieza->precio == '') ? 0 : $pieza->precio,
              'pieza_costo' => ($pieza->costo == '') ? 0 : $pieza->costo
            )
          )
          ->execute();
        $this->register_log_actions('partners_servicios_datos', 'insert', 'Se insertó una pieza del servicio: ' . $capturar_servicio);

        // Si es servicio compartido, entonces capturar las piezas al servicio que se acaba de duplicar anteriormente.
        if ($datos->radio_servicio_compartido == 1) {
          db_insert('partners_servicios_datos')
            ->fields(
              array(
                'id_servicio' => $capturar_servicio_copia_compartido,
                'pieza_nombre' => $pieza->descripcion,
                'pieza_precio' => ($pieza->precio == '') ? 0 : $pieza->precio,
                'pieza_costo' => ($pieza->costo == '') ? 0 : $pieza->costo
              )
            )
            ->execute();
          $this->register_log_actions('partners_servicios_datos', 'insert', 'Se insertó una pieza del servicio: ' . $capturar_servicio_copia_compartido);
        }
      }
    }
    if (isset($datos->id_pendiente) && $datos->id_pendiente != '') {
      db_update('partners_pendientes')
        ->fields(
          array(
            'status' => 0,
            'closed_by_report' => $capturar_servicio,
            'updated_by' => $user->uid,
            'updated_at' => REQUEST_TIME
          )
        )
        ->condition('id_pendiente', $datos->id_pendiente)
        ->execute();

      $check_renovacion_pendiente = db_select('partners_pendientes', 'pp')
        ->fields('pp', array('token_relacion_renovacion'))
        ->condition('id_pendiente', $datos->id_pendiente)
        ->execute()->fetchField();

      if ($check_renovacion_pendiente) {
        db_update('partners_renovaciones')
          ->fields(
            array(
              'autorizado' => 1
            )
          )
          ->condition('token_relacion_renovacion', $check_renovacion_pendiente)
          ->execute();
      }
    }
    if (isset($datos->id_salida_mercancia) && $datos->id_salida_mercancia != '') {
      db_update('partners_mercancia')
        ->fields(
          array(
            'reporte_procesado' => 1,
            'id_reporte_procesado' => $capturar_servicio,
            'procesado' => 1,
            // Pone automáticamente la columna como Procesado = Si
            'observaciones' => $this->serialize_obs("Piezas ya reportadas en el Reporte de Servicio: " . $capturar_servicio, 2, 'partners_mercancia', 'id_salida', $datos->id_salida_mercancia)

          )
        )
        ->condition('id_salida', $datos->id_salida_mercancia)
        ->execute();
    }
    $this->throw_message('success', $capturar_servicio);
    $this->register_log_actions('partners_servicios', 'insert', 'Se creo el reporte de servicio: ' . $capturar_servicio);
  }


  private function enviar_reporte_correo($datos)
  {
    try {
      global $user;
      $data = [];
      $data['id_servicio'] = $datos->id_servicio;
      $data['user_mail'] = $user->mail;
      if (isset($datos->body)) {
        $data['body'] = $datos->body;
      }

      //Verificar si está autorizado o no
      $query = db_select('partners_servicios', 'ps');
      $query->fields('ps');
      $query->condition('id_servicio', $datos->id_servicio);
      $query = $query->execute();
      $row = $query->fetchAssoc();
      $data['autorizado'] = ($row['autorizado'] > 0);
      $data['autorizado_por'] = $row['autorizado_por'];
      $data['tipo_servicio'] = $row['tipo_servicio'];
      setlocale(LC_TIME, "es_MX.UTF-8");
      $data['fecha_reporte'] = strftime("%e-%b-%Y", $row['fecha_reporte']);
      $data['servicio_total'] = number_format($row['servicio_total'], 2);
      $data['recibido_por'] = $row['recibido_por'];
      $data['detalle_servicio'] = $row['detalle_servicio'];
      //.
      $idCliente = $row['id_cliente'];
      $idUsuario = $row['created_by'];
      //Conseguir cliente
      $query = db_select('partners_clientes', 'pc');
      $query->fields('pc', array('nombre_cliente'));
      $query->condition('id_cliente', $idCliente);
      $query = $query->execute();
      $data['nombre_cliente'] = $query->fetchField();
      //.
      //Conseguir cliente
      $query = db_select('field_data_field_nombre_completo', 'ff');
      $query->fields('ff', array('field_nombre_completo_value'));
      $query->condition('entity_id', $idUsuario);
      $query = $query->execute();
      $data['tecnico'] = $query->fetchField();
      //.
      //Conseguir correo usuario
      $query = db_select('users', 'u');
      $query->fields('u', array('mail'));
      $query->condition('uid', $idUsuario);
      $query = $query->execute();
      $data['correo'] = $query->fetchField();
      //.

      $from = [$user->mail => 'Pc Partners - Centro de Servicio'];
      $token = $datos->id_servicio;
      $to = $datos->to;
      if (count($to) > 1) {
        $this->throw_message('error', 'Sólo se puede enviar a un correo');
      } else if (count($to) == 0) {
        $this->throw_message('error', 'Debes seleccionar un correo');
      } else {
        $data['token'] = $this->generateToken($to[0], $token);
        if (!$data['autorizado']) {
          db_update('partners_servicios')
            ->fields(
              array(
                'token' => $token
              )
            )
            ->condition('id_servicio', $datos->id_servicio)
            ->execute();
        }
        $subject = 'Autorización de Servicio.';
        $data_to_render = [];
        $data_to_render['id_servicio'] = $datos->id_servicio;
        $data_to_render['type'] = 1;
        $attachment_data = $this->render_reporte($data_to_render);
        $attachment = $attachment_data['pdf_string'];
        $attachment_title = $attachment_data['attach_title'];

        $this->send_mail('servicios.mail_enviar_servicio', $data, $subject, $from, $to, $attachment, $attachment_title);
        $this->throw_message('success', 'Bien!');
      }
    } catch (Exception $e) {
      $this->throw_message('error', $e->getMessage());
    }
  }

  /**
   * Generar token
   *
   * @param $input
   * @param $token
   * @param int $size
   * @return string
   */
  private function generateToken($input, &$token, $size = 10)
  {
    $CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    for ($i = 0; $i < $size; $i++) {
      $token .= $CHARS[rand(0, strlen($CHARS) - 1)];
    }
    return base64url_encode($token . "~" . $input);
  }

  private function render_reporte($datos)
  {
    $id_servicio = $datos['id_servicio'];
    if ($datos['type']) {
      $type = $datos['type'];
    } else {
      $type = null;
    }

    $servicio = $this->datos_servicio($id_servicio);
    $html = render_template('php', 'servicios.reporte_servicio', $servicio);
    $footer = render_template('php', 'system.footer_reporte');

    if ($type == null) {
      if ($servicio['servicio']['compartido_copia'] == 1) {
        $watermark = '/intranet/sites/default/files/img/compartido.png';
        $this->generate_pdf($html, $servicio['folio'], 'Hoja de Servicio ' . $servicio['folio'], 1, $footer, $watermark);
      } else {
        $this->generate_pdf($html, $servicio['folio'], 'Hoja de Servicio ' . $servicio['folio'], 1, $footer);
      }
    } else {
      return array("pdf_string" => $this->generate_pdf($html, $servicio['folio'], 'reporte_' . $servicio['folio'], 2), "attach_title" => 'reporte_' . $servicio['folio']);
    }
  }

  private function datos_servicio($id_servicio)
  {
    $query = db_select('partners_servicios', 'ps');
    $query->fields('ps');
    $query->addExpression("CASE ps.tipo_servicio WHEN 1 THEN 'Remoto' WHEN 2 THEN 'Interno' WHEN 3 THEN 'Actividad' WHEN 4 THEN 'Domicilio' END ", 'nombre_tipo_servicio');
    $query->leftJoin('field_data_field_nombre_completo', 'f', 'f.entity_id = ps.created_by');
    $query->addField('f', 'field_nombre_completo_value', 'nombre_tecnico');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
    $query->fields('pc', array('nombre_cliente', 'credito', 'email', 'nombre_facturacion', 'tipo_clasificacion'));
    $query->leftJoin('field_data_field_nombre_completo', 'ff', 'ff.entity_id = ps.id_usuario_interno');
    $query->addField('ff', 'field_nombre_completo_value', 'nombre_usuario_solicita');
    $query->condition('ps.id_servicio', $id_servicio);
    $servicio = $query->execute()->fetchAssoc();


    $query_p = db_select('partners_servicios_datos', 'psd')
      ->fields('psd', array('pieza_nombre', 'pieza_precio'))
      ->condition('id_servicio', $id_servicio);
    $piezas = $query_p->execute()->fetchAll(PDO::FETCH_ASSOC);
    $data = [];

    $servicio_total = 0;
    $piezas_precio = 0;
    $piezas_costo = 0;

    $horas_totales = 0;
    $horas_totales = db_select('partners_servicios', 'ps')
      ->fields('ps', array('horas_totales'))
      ->condition('id_servicio', $id_servicio)
      ->execute()->fetchField();


    $poliza = $servicio['folio_poliza'] != "0" ? $servicio['folio_poliza'] : null;
    if ($poliza !== null && $servicio['tipo_servicio'] != 2 && !in_array($horas_totales, [0, null, 'undefined'])) {
      $poliza = db_query('select * from partners_servicios_polizas where id_servicio = ' . $id_servicio . ' and id_poliza =' . $poliza . ' limit 1')->fetch();
      $horas_incluidas = db_query(
        'select horas, nombre from partners_paquetes_polizas
          where tid = (select tipo_poliza from partners_polizas where id_poliza = ' . $poliza->id_poliza . ')'
      )->fetch();
      $poliza->horas_incluidas = $horas_incluidas->horas;
      $poliza->saldo_final = $poliza->saldo_inicial - $horas_totales;
      $poliza->nombre_paquete = $horas_incluidas->nombre;
      $poliza = json_decode(json_encode($poliza), true);
    }
    // Tipo Remomto
    // - Solamente se puede o por precio fijo o por calculo de horas, y ambos van a caer en la misma columna
    //   de servicio_total, no tiene para piezas.
    if ($servicio['tipo_servicio'] == 1) {
      $servicio_total = db_select('partners_servicios', 'ps')
        ->fields('ps', array('servicio_total'))
        ->condition('id_servicio', $id_servicio)
        ->execute()->fetchField();
    } else if ($servicio['tipo_servicio'] == 2) {
      // Tipo Interno
      // - tiene para precio fijo y solo piezas, por lo tanto o puede tener solamente el precio fijo de
      // la columna servicio_total o puede tener el precio total de la suma de todas las piezas.
      // Cuando es de precio fijo
      if ($servicio['tipo_precio'] == 2) {
        $servicio_total = db_select('partners_servicios', 'ps')
          ->fields('ps', array('servicio_total'))
          ->condition('id_servicio', $id_servicio)
          ->execute()->fetchField();
      } else {
        // Cuando es de solo piezas, se consulta la suma de todas las piezas.
        $piezas_p = db_select('partners_servicios_datos', 'psd');
        $piezas_p->addExpression('SUM(pieza_precio)', 'total_piezas_precio');
        $piezas_p->condition('id_servicio', $id_servicio);
        $piezas_precio = $piezas_p->execute()->fetchField();

        $piezas_c = db_select('partners_servicios_datos', 'psd');
        $piezas_c->addExpression('SUM(pieza_costo)', 'total_piezas_costo');
        $piezas_c->condition('id_servicio', $id_servicio);
        $piezas_costo = $piezas_c->execute()->fetchField();

        // solamente es de puras piezas entonces no hay que sumar con otro mas
        $servicio_total = $piezas_precio;
      }
    } else if ($servicio['tipo_servicio'] == 3) {
      // Tipo Actividad
      // - Los de actividad no se cobran
      $servicio_total = 0;
    } else if ($servicio['tipo_servicio'] == 4) {
      // Tipo Domicilio
      // -Tiene para precio fijo, calculo de horas, solo piezas, y aparte piezas. es el que tiene todos los
      // tipos de precio. Entonces puede ser solamente fijo o calulo y que solo tenga valor en servicio_total
      // o puede ser que sea que tenga fijo o calculo pero tambien piezas, o puede ser que tenga solo piezas

      $piezas_p = db_select('partners_servicios_datos', 'psd');
      $piezas_p->addExpression('SUM(pieza_precio)', 'total_piezas_precio');
      $piezas_p->condition('id_servicio', $id_servicio);
      $piezas_precio = $piezas_p->execute()->fetchField();

      // Cuando tiene piezas
      if ($servicio['piezas_domicilio'] == 1) {

        // Cuando tiene por calculo de tiempo
        if ($servicio['tipo_precio'] == 1 || $servicio['tipo_precio'] == 4) {
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 2 || $servicio['tipo_precio'] == 6) {
          // Cuando es precio fijo
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 3) {
          //Cuando es solo piezas
          $servicio_total = $piezas_precio;
        }
      } else {
        if ($servicio['tipo_precio'] == 1 || $servicio['tipo_precio'] == 4) {
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 2 || $servicio['tipo_precio'] == 6) {
          // Cuando es precio fijo
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 3) {
          //Cuando es solo piezas
          $servicio_total = $piezas_precio;
        }
      }
    }

    $data['servicio_total'] = $servicio_total;
    $data['precio_piezas'] = $piezas_precio;
    $data['costo_piezas'] = $piezas_costo;
    $data['servicio'] = $servicio;
    // agregar los datos de la poliza
    $data['servicio']['poliza'] = $poliza != null ? $poliza : null;
    $data['piezas'] = $piezas;
    $data['horas_totales'] = $horas_totales;
    # No encontré otra forma para hacerlo que no sea hardcoded
    # 14/08/2018 folio 6399
    if ($servicio['id_servicio'] > 6399) {
      $folio = strtoupper($servicio['tipo_clasificacion']) . '-' . $servicio['id_servicio'];
    } else {
      # Conservar los folios anteriores con la misma serie.
      $folio = (($servicio['credito'] == 1) ? 'A' : 'B') . '-' . $servicio['id_servicio'];
    }
    $data['folio'] = $folio;

    setlocale(LC_TIME, "es_MX.UTF-8");
    $data['fecha_completa'] = strftime("%A %e de %B del %Y a las %R", strtotime($servicio['autorizado_fecha']));
    return $data;
  }

  private function get_datos_from_pendiente($id_pendiente)
  {
    $query_pendiente = db_select('partners_pendientes', 'pp');
    $query_pendiente->fields('pp', array('created_at', 'descripcion_pendiente', 'quien_reporta_pendiente'));
    $query_pendiente->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pp.id_cliente');
    $query_pendiente->addExpression("CASE pc.credito WHEN 1 THEN 'Crédito' WHEN 0 THEN 'Contado' WHEN 2 THEN 'Prepago' END", 'credito_contado');
    $query_pendiente->fields('pc', array('id_cliente', 'nombre_cliente', 'tipo_clasificacion', 'email', 'tipo_negocio', 'saldo_horas'));
    $query_pendiente->condition('pp.id_pendiente', $id_pendiente);
    $pendiente = $query_pendiente->execute()->fetchAssoc();

    $this->throw_message('success', json_encode($pendiente));
  }


  private function reporte_base($datos)
  {
    global $user;
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;


    $query = db_select('partners_servicios', 'ps');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
    $query->fields('pc', array('nombre_cliente', 'credito', 'email', 'tipo_clasificacion'));
    $query->addExpression("CASE ps.tipo_servicio WHEN 1 THEN 'Remoto' WHEN 2 THEN 'Interno' WHEN 3 THEN 'Actividad' WHEN 4 THEN 'Domicilio' END", "nombre_tipo_servicio");
    $query->fields('ps');
    $query->leftJoin('users', 'u', 'u.uid = ps.created_by');
    $query->addField('u', 'name', 'nombre_tecnico');
    $query->addField('u', 'mail', 'email_user');
    $query->condition('ps.servicio_eliminado', '1', '!=');

    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('ps.fecha_reporte', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('ps.fecha_reporte', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Tipo Servicio -- funciona
    if ($datos->filter->tipo_servicio != null) {
      $d = explode(',', $datos->filter->tipo_servicio);
      $query->condition('ps.tipo_servicio', $d, 'IN');
    }

    // Filtro - Técnico -- funciona
    if ($datos->filter->tecnico != 0 || $datos->filter->tecnico != null) {
      $query->condition('ps.created_by', $datos->filter->tecnico);
    }

    // // Filtro - Usuario Recibe
    if ($datos->filter->usuario_recibe != 0) {
      $query->condition('ps.id_usuario_interno', $datos->filter->usuario_recibe);
    }
    // // Filtro - Compartido Con
    if ($datos->filter->compartido_con != 0) {
      $query->condition('ps.usuario_compartido_con', $datos->filter->compartido_con);
    }

    // // Filtro - Sin Pagar
    if ($datos->filter->sin_pagar != 0) {
      //$query->where('ps.pagado_admon = 0 AND ps.tipo_servicio NOT IN (2,3)');
      $query->condition('ps.pagado_admon', 0, '=');
      $query->condition('ps.tipo_servicio', 2, '!=');
      $query->condition('ps.tipo_servicio', 3, '!=');
    }

    // // Filtro - Compartido
    if ($datos->filter->compartidos != 0) {
      $query->condition('ps.servicio_compartido', $datos->filter->compartidos);
    }

    // // Vista admin/personal
    if ($datos->reporte_admin == 0) {
      // Filtro -- El rol CCTV puede ver los servicios del rol Auxiliar CCTV
      if (in_array("CCTV", $user->roles)) {
        // Encontrar los ID de los usuarios con el rol de Auxiliar CCTV
        $auxiliares = db_select('users', 'u');
        $auxiliares->leftJoin('users_roles', 'ur', 'u.uid = ur.uid');
        $auxiliares->fields('u', array('uid'));
        $auxiliares->condition('ur.rid', 15); // El ID 15 es el rol de Auxiliar CCTV
        $resp = $auxiliares->execute();
        $ids_auxiliares = [];
        foreach ($resp as $row) {
          $ids_auxiliares[] = $row->uid;
        }
        $query->condition('ps.created_by', array_merge($ids_auxiliares, [$user->uid]), 'IN');
      } else { // Si no es CCTV, solo puede ver sus propios servicios
        $query->condition('ps.created_by', $user->uid);
      }
    }

    // // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $servicio_or = db_or()
        ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('ps.detalle_servicio', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($servicio_or);
    }
    $query->orderBy($datos->sort->sort_by, $datos->sort->order);
    $query_datos = $query->execute();


    //var_dump($query_datos->fetchAll());
    $servicios = [];
    while ($row = $query_datos->fetch()) {
      if ($datos->filter->falta_costo != 0) {
        $v = db_select('partners_servicios_datos', 'psd')
          ->fields('psd', array('id_servicio'))
          ->condition('id_servicio', $row->id_servicio)
          ->condition('pieza_costo', 0)
          ->execute()->fetchField();
        if (!$v)
          continue;
      }
      if ($datos->filter->sin_pagar != 0) {
        // Solo filtrará los servicios a domicilio y remoto, que en teoria son los que solo esos se facturan.
        if ($row->tipo_servicio == 1 || $row->tipo_servicio == 4) {
          // Dejar las que no han facturado y tampoco pagado
          // No pagadas
          if ($row->pagado_admon == 0) {
          } else if ($row->pagado_admon == 2) {
            // Facturadas, validar facturas web y comercial
            // Si es factura Web
            if ($row->servicio_facturado != 0) {
              if ($row->pagado_cobranza != 0)
                continue;
            } else if ($row->servicio_facturado == 0) {
              // Es factura de comercial
              if ($this->validate_factura_pagada($this->get_numero_factura('partners_servicios', $row->id_servicio)) == 0)
                continue;
            }
          } else {
            continue;
          }
        } else {
          continue;
        }
      }
      // # No encontré otra forma para hacerlo que no sea hardcoded
      // # 14/08/2018 folio 6399
      $id = $row->id_servicio;
      if ($row->id_servicio > 6399) {
        $folio = strtoupper($row->tipo_clasificacion) . '-' . $row->id_servicio;
      } else {
        # Conservar los folios anteriores con la misma serie.
        $folio = (($row->credito == 1) ? 'A' : 'B') . '-' . $row->id_servicio;
      }
      $fecha = date('d/m/y', $row->fecha_reporte);
      // Cliente
      if ($row->id_usuario_interno) {
        $user_recibio = user_load($row->id_usuario_interno)->name;
        if ($datos->reporte_admin == 1) {
          $cliente = array("data" => mb_substr($row->nombre_cliente, 0, 20, "utf-8"), "data-usuario-recibe" => $user_recibio, "data-current-text" => mb_substr($row->nombre_cliente, 0, 20, "utf-8"), "class" => "show_usuario_recibe");
        } else {
          $cliente = array("data" => mb_substr($row->nombre_cliente, 0, 20, "utf-8"));
        }
      } else {
        $cliente = array("data" => mb_substr($row->nombre_cliente, 0, 20, "utf-8"));
      }
      // Pagado
      if ($row->tipo_servicio == 2 or $row->tipo_servicio == 3) {
        if ($datos->reporte_admin == 1) {
          //$pagado = array("data" => "N/A", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
          // Se comenta la de arriba, porque segun yo cuando es actividad o interno pues no se debe de poder pagar
          $pagado = array("data" => "N/A", "class" => array("status-green", "text-center"));
        } else {
          $pagado = array("data" => "N/A", "class" => array("status-green", "text-center"));
        }
      } else {
        if ($datos->reporte_admin == 1) {
          if ($row->pagado_admon == 0) {
            if ($row->servicio_facturado == 0) {
              $pagado = array("data" => "No", "class" => array("status_pagado", "status-red", "text-center", "cursor-pointer"));
            } else {
              $pagado = array("data" => "No", "class" => array("status-red", "text-center"));
            }
            if ($row->forma_pago == "Póliza" || $row->forma_pago == "Paquete") {
              $pagado = array("data" => "Paquete", "class" => array("status-green", "text-center"));
            }
          } else if ($row->pagado_admon == 1) {
            if ($row->servicio_facturado == 0) {
              $pagado = array("data" => "Pagado", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
            } else {
              $pagado = array("data" => "Pagado", "class" => array("status-green", "text-center"));
            }
          } else if ($row->pagado_admon == 2) {
            if ($row->servicio_facturado == 0) {
              $pagado = array("data" => "Factura", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
            } else {
              $pagado = array("data" => "Factura", "class" => array("status-green", "text-center"));
            }
          } else if ($row->pagado_admon == 3) {
            $pagado = array("data" => "Compartido", "class" => array("status-green", "text-center"));
          } else if ($row->pagado_admon == 4) {
            // De estas facturas, solo se hicieron muy pocas, que fue durante el proceso de que metimos las de facturas W,
            // después hicimos otra columna [pagado_cobranza] y en esa es en donde debe de ir este texto, al final de cuentas,
            // esta columna de pagado_admon solo debe de aparecer N/A, NO, Pagado, Facturado.
            // Para no "eliminar" o "desaparecer" las pocas que se hicieron, voy a establecer que esta columna diga Facturado,
            // ya que solo es existieron en facturas W, y todas las facturas W obviamente ya están facturadas.
            $pagado = array("data" => "Factura", "class" => array("status-green", "text-center"));
          }
        } else {
          if ($row->pagado_admon == 0) { // 0 no pagado
            $pagado = array("data" => "No", "class" => array("status-red", "text-center"));
          } else if ($row->pagado_admon == 1) { // pagado
            $pagado = array("data" => "Pagado", "class" => array("status-green", "text-center"));
          } else if ($row->pagado_admon == 2) { // facturado
            $pagado = array("data" => "Factura", "class" => array("status-green", "text-center"));
          } else if ($row->pagado_admon == 3) { // Compartido
            $pagado = array("data" => "Compartido", "class" => array("status-green", "text-center"));
          } else if ($row->pagado_admon == 4) {
            $pagado = array("data" => "Factura", "class" => array("status-green", "text-center"));
          }
          if ($row->forma_pago == "Póliza" || $row->forma_pago == "Paquete") {
            $pagado = array("data" => "Paquete", "class" => array("status-green", "text-center"));
          }
        }
      }
      // Estatus
      if ($row->tipo_servicio == 2 or $row->tipo_servicio == 3) {
        $status = array("data" => "N/A", "class" => array("status-green", "text-center"));
      } else {
        if ((int) $row->servicio_pagado == 1) {
          $status = array("data" => "Pagado", "class" => array("status-green", "text-center"));
        } else if ((int) $row->servicio_pagado == 0 && (int) $row->credito == 1) {
          $status = array("data" => "Crédito", "class" => array("status-green", "text-center"));
        } else if ((int) $row->servicio_pagado == 0 and in_array((int) $row->credito, array(0, 2))) {
          $status = array("data" => "No Pago", "class" => array("status-red", "text-center"));
        }
      }
      /*
      // Será reemplazado por una nueva columna de status_especial, basicamente con el mismo funcionamiento, pero
      // pues querian otro icono igual al de cobranza :)
      // Problema
      if ($datos->reporte_admin == 1) {
      if ($row['problema_con_servicio'] == 0) {
      $problema = array("data" => "No", "class" => array("status_problema", "status-green", "text-center", "cursor-pointer"));
      } else if ($row['problema_con_servicio'] == 1) {
      $problema = array("data" => "Si", "class" => array("status_problema", "status-red", "text-center", "cursor-pointer"));
      }
      } else {
      if ($row['problema_con_servicio'] == 0) {
      $problema = array("data" => "No", "class" => array("status-green", "text-center"));
      } else if ($row['problema_con_servicio'] == 1) {
      $problema = array("data" => "Si", "class" => array("status-red", "text-center"));
      }
      }
      */

      // Especial
      if ($datos->reporte_admin == 1) {
        if ($row->status_especial == 0) {
          $especial = array("data" => '', "class" => array("status_especial", "text-center", "cursor-pointer"));
        } else if ($row->status_especial == 1) {
          $especial = array("data" => '<i class="fas fa-exclamation-triangle sod"></i>', "class" => array("status_especial", "text-center", "cursor-pointer", "text-danger"));
        }
      } else {
        if ($row->status_especial == 0) {
          $especial = array("data" => '', "class" => array("text-center"));
        } else if ($row->status_especial == 1) {
          $especial = array("data" => '<i class="fas fa-exclamation-triangle sod"></i>', "class" => array("text-center", "text-danger"));
        }
      }
      // Observaciones | Notas internas
      if ($row->observaciones != null) {
        $observaciones = array("data" => 'Obs', "class" => array(($row->status_especial == 1) ? "status-red" : "status-yellow", "status_obs", "text-center", "cursor-pointer"));
      } else {
        $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs", "cursor-pointer"));
      }



      $servicio = ($row->servicio_total) ? array("data" => number_format($row->servicio_total, 2, '.', ','), "class" => "text-right") : array("data" => number_format(0, 2, '.', ','), "class" => "text-right");
      if ($row->tipo_precio == 6 && is_null($row->servicio_total)) {
        // multiplicar por el costo por hora
        try {


          $result = db_select('partners_polizas', 'pp')
            ->fields('pp', array('tipo_poliza'));
          $result->condition('pp.id_cliente', $row->id_cliente);
          $result->condition('pp.estado', '1');
          $result->condition('pp.eliminada', '0');
          $result->condition('pp.vencimiento', REQUEST_TIME, '>');
          $result->orderBy('pp.fecha', 'asc');

          $result = $result->execute();
          $polizas = $result->fetchAll();

          $ho = db_select('partners_paquetes_polizas', 'p')
            ->fields('p', array('horas', 'precio_hora'))
            ->condition('p.tid', (int) $polizas[0]->tipo_poliza)
            ->execute()->fetchAll(PDO::FETCH_ASSOC);

          $hora = $ho[0]['precio_hora'];
          $precio = (int) $hora * (int) $row->horas_totales;
          $servicio = array("data" => number_format(($precio), 2, '.', ','), "class" => "text-right");
        } catch (Exception $e) {
          $servicio = array("data" => $e, "class" => array("text-center"));
        }
      }
      $piezasCosto = $this->calcular_precio_total($row->id_servicio, 2);
      $piezasPrecio = $this->calcular_precio_total($row->id_servicio, 1);
      $piezasPrecioC = array("data" => number_format($piezasPrecio, 2, '.', ','), "class" => "text-right");

      if ($piezasPrecio == 0) { // si no existe registro de precio venta de pieza, no se puede editar el costo
        $piezasCostoC = array("data" => number_format($piezasCosto, 2, '.', ','), "class" => "text-right");
      } else {
        if ($piezasCosto == 0) {
          $piezasCostoC = array("data" => number_format($piezasCosto, 2, '.', ','), "class" => array("status-yellow", "text-right", ($datos->reporte_admin == 1) ? "cursor-pointer status_costo" : "cursor-pointer status_costo_simple"));
        } else {
          $piezasCostoC = array("data" => number_format($piezasCosto, 2, '.', ','), "class" => array("text-right", ($datos->reporte_admin == 1) ? "cursor-pointer status_costo" : "cursor-pointer status_costo_simple"));
        }
      }

      $total = $this->calcular_precio_total($row->id_servicio, 3);


      // Compartido
      if ($row->servicio_compartido == 1) {
        if ($row->tipo_servicio == 4) {
          if ($piezasPrecio > 0) {
            $comision = (((($piezasPrecio - $piezasCosto) / 40) * 30));
            $comision = ($comision / 2) + $row->servicio_total;
          } else {
            $comision = ($row->servicio_total / 2);
          }
        } else {
          $comision = $row->servicio_total + (((($piezasPrecio - $piezasCosto) / 40) * 30));
          $comision = $comision / 2;
        }

        $user_compartido_con = user_load($row->usuario_compartido_con)->name;
        $comisionC = array("data" => number_format($comision, 2, '.', ','), "data-compartido-con" => $user_compartido_con, "data-current-text" => number_format($comision, 2, '.', ','), "class" => array("text-right", "status-blue show_compartido_con"));
      } else {
        $comision = $row->servicio_total + ((($piezasPrecio - $piezasCosto) / 40) * 30);
        $comisionC = array("data" => number_format($comision, 2, '.', ','), "class" => "text-right");
      }


      $totalC = array("data" => number_format($total, 2, '.', ','), "class" => array("text-right"));

      $ver = array("data" => 'Ver', "class" => array("cursor-pointer", "ver_servicio"));
      $reenviar = array("data" => '<i class="fa fa-envelope sod" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "reenviar_reporte"));
      $borrar = array("data" => '<i class="fa fa-trash sod" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "eliminar_reporte"));

      // El servicio se facturó online con la serie W, por lo tanto no hay que ir a buscar a get_numero_factura
      if ($row->servicio_facturado != 0) {
        // Asignar colores, si la columna de pagado_cobranza = 0, entonces el color será rojo, ,de lo contrario, ponerlo verde
        if ($row->pagado_cobranza == 0) {
          $numero_factura = array("data" => $row->servicio_facturado, "class" => array("text-right cursor-pointer ver_factura_w status-red text-center"), "data-nombre-factura" => $row->factura_w_servicio);
        } else {
          $numero_factura = array("data" => $row->servicio_facturado, "class" => array("text-right cursor-pointer ver_factura_w status-green text-center"), "data-nombre-factura" => $row->factura_w_servicio);
        }
      } else {
        // El servicio no se facturó online, ir a buscar el numero de factura
        if ($this->get_numero_factura('partners_servicios', $row->id_servicio)) {
          if ($this->validate_factura_pagada($this->get_numero_factura('partners_servicios', $row->id_servicio)) == 0) {
            // La factura ya está pagada
            $numero_factura = array("data" => $this->get_numero_factura('partners_servicios', $row->id_servicio), "class" => array("text-right cursor-pointer ver_factura status-green text-center"));
          } else {
            // No está pagada la factura
            $numero_factura = array("data" => $this->get_numero_factura('partners_servicios', $row->id_servicio), "class" => array("text-right cursor-pointer ver_factura status-red text-center"));
          }
        } else {
          $numero_factura = "";
        }
      }


      if ($row->servicio_facturado == 0) {
        // Si aun no tiene servicio_facturado, entonces probablemente o aun no la facturan o no la van a facturar, entonces,
        // ver si ya existe una factura en comercial o si el servicio es interno o de actividad, para que si se cumple una de las condiciones
        // anteriores, ponga la marca de que "ya se facturo" esto para evitar que vuelvan a facturar por error o facturen servicios que no deben.
        if ($this->get_numero_factura('partners_servicios', $row->id_servicio) || $row->tipo_servicio == 2 || $row->tipo_servicio == 3) {
          $facturar = array("data" => '<i class="fas fa-check-circle sod"></i>', "class" => array("text-center", "status-green"));
        } else {
          $facturar = array("data" => '<i class="fas fa-file-alt sod"></i>', "class" => array("text-center", "cursor-pointer", "facturar_servicio", "text-warning"));
        }
      } else {
        $facturar = array("data" => '<i class="fas fa-check-circle"></i>', "class" => array("text-center", "status-green"));
      }

      if ($row->autorizado == 1) {
        $auth = 'Sí';
        $authClass = "bg-success";
      } else if ($row->autorizado == 2) {
        $auth = 'Firmado';
        $authClass = "bg-success";
      } else {
        $auth = 'No';
        $authClass = "bg-danger";
      }

      if ($row->autorizado == 0) {
        $agregarFirma = array('data' => '<i class="material-icons sod">history_edu</i>', 'class' => 'text-center cursor-pointer add-esign');
      } else {
        $agregarFirma = array('data' => '', 'class' => 'text-center');
      }


      if ($datos->reporte_admin == 1) {
        if (in_array('Supervisor', array_values($user->roles))) {
          $servicios[] = array(
            "data" => array(
              $folio,
              $fecha,
              $row->nombre_tipo_servicio,
              $cliente,
              array("data" => strtoupper($row->tipo_clasificacion), "class" => array("text-center")),
              $row->nombre_tecnico,
              mb_substr($row->detalle_servicio, 0, 20, "utf-8"),
              $servicio,
              $piezasPrecioC,
              $piezasCostoC,
              $totalC,
              $comisionC,
              $status,
              $pagado,
              $especial,
              $numero_factura,
              $ver,
              $observaciones,
              $reenviar,
              array("data" => $auth, "class" => "text-center text-light " . $authClass),
              $borrar
            ),
            "data-id-servicio" => $row->id_servicio,
            "data-email-cliente" => $row->email,
            "data-email-user" => $row->email_user,
            "data-folio-servicio" => $folio,
            "data-pagado" => $row->pagado_admon,
            #"data-problema" => $row->problema_con_servicio,
            "data-especial" => $row->status_especial,
            "data-nombre-cliente" => $row->nombre_cliente,
            "data-id-cliente" => $row->id_cliente,
            "data-total-servicio" => $total,
            "data-servicio-facturado" => $row->servicio_facturado
          );
        } else {
          $servicios[] = array(
            "data" => array(
              $folio,
              $fecha,
              $row->nombre_tipo_servicio,
              $cliente,
              array("data" => strtoupper($row->tipo_clasificacion), "class" => array("text-center")),
              $row->nombre_tecnico,
              mb_substr($row->detalle_servicio, 0, 20, "utf-8"),
              $servicio,
              $piezasPrecioC,
              $piezasCostoC,
              $totalC,
              $comisionC,
              $status,
              $pagado,
              $especial,
              $numero_factura,
              $ver,
              $observaciones,
              $reenviar,
              array("data" => $auth, "class" => "text-center text-light " . $authClass),
            ),
            "data-id-servicio" => $row->id_servicio,
            "data-email-cliente" => $row->email,
            "data-email-user" => $row->email_user,
            "data-folio-servicio" => $folio,
            "data-pagado" => $row->pagado_admon,
            #"data-problema" => $row['problema_con_servicio'],
            "data-especial" => $row->status_especial,
            "data-nombre-cliente" => $row->nombre_cliente,
            "data-id-cliente" => $row->id_cliente,
            //"data-total-servicio" => $total,
            "data-servicio-facturado" => $row->servicio_facturado
          );
        }
      } else if (in_array("Auxiliar CCTV", $user->roles)) {
        $servicios[] = array(
          "data" => array(
            $folio,
            $fecha,
            $row->nombre_tipo_servicio,
            $cliente,
            array("data" => strtoupper($row->tipo_clasificacion), "class" => array("text-center")),
            $row->nombre_tecnico,
            mb_substr($row->detalle_servicio, 0, 20, "utf-8"),
            $servicio,
            $piezasPrecioC,
            $piezasCostoC,
            $totalC,
            $status,
            $pagado,
            $especial,
            $ver,
            (strtoupper($row->tipo_clasificacion) == "P" ? array("data" => '<i class="fas fa-check-circle"></i>', "class" => array("text-center", "status-green")) : $facturar),
            $numero_factura,
            $observaciones,
            $reenviar,
            array("data" => $auth, "class" => "text-center text-light " . $authClass),
            $agregarFirma,
          ),
          "data-id-servicio" => $row->id_servicio,
          "data-email-cliente" => $row->email,
          "data-email-user" => $row->email_user,
          "data-folio-servicio" => $folio,
          "data-pagado" => $row->pagado_admon,
          #"data-problema" => $row['problema_con_servicio'],
          "data-especial" => $row->status_especial,
          "data-nombre-cliente" => $row->nombre_cliente,
          "data-id-cliente" => $row->id_cliente,
          //"data-total-servicio" => $total,
          "data-servicio-facturado" => $row->servicio_facturado
        );
      } else {
        $servicios[] = array(
          "data" => array(
            $folio,
            $fecha,
            $row->nombre_tipo_servicio,
            $cliente,
            array("data" => strtoupper($row->tipo_clasificacion), "class" => array("text-center")),
            $row->nombre_tecnico,
            mb_substr($row->detalle_servicio, 0, 20, "utf-8"),
            $servicio,
            $piezasPrecioC,
            $piezasCostoC,
            $totalC,
            $comisionC,
            $status,
            $pagado,
            $especial,
            $ver,
            (strtoupper($row->tipo_clasificacion) == "P" ? array("data" => '<i class="fas fa-check-circle"></i>', "class" => array("text-center", "status-green")) : $facturar),
            $numero_factura,
            $observaciones,
            $reenviar,
            array("data" => $auth, "class" => "text-center text-light " . $authClass),
            $agregarFirma,
          ),
          "data-id-servicio" => $row->id_servicio,
          "data-email-cliente" => $row->email,
          "data-email-user" => $row->email_user,
          "data-folio-servicio" => $folio,
          "data-id-cliente" => $row->id_cliente,
          "data-pagado" => $row->pagado_admon,
          "data-problema" => $row->problema_con_servicio,
        );
      }
    }


    if ($datos->reporte_admin == 1) {
      // Header -- Sort
      if (in_array('Supervisor', array_values($user->roles))) {
        $header_cols = array(
          array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
          array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "C", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Técnico", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Servicio", "class" => "filter-number col-servicio"), "sortable" => 0),
          array("name" => array("data" => "Venta", "class" => "filter-number col-venta"), "sortable" => 0),
          array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
          array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
          array("name" => array("data" => "Comisión", "class" => "filter-number col-comision"), "sortable" => 0),
          array("name" => array("data" => "Estatus", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => '<i class="fas fa-exclamation-triangle sod"></i>', "class" => "filter-text dont-filter"), "sortable" => 0),
          array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => "Ver", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => '<i class="fa fa-envelope sod" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
          array("name" => array("data" => "Autorizado", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => '<i class="fa fa-trash sod" aria-hidden="true"></i>', "class" => "dont-filter", "text-center"), "sortable" => 0),

        );
      } else {
        $header_cols = array(
          array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
          array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "C", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Técnico", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Servicio", "class" => "filter-number col-servicio"), "sortable" => 0),
          array("name" => array("data" => "Venta", "class" => "filter-number col-venta"), "sortable" => 0),
          array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
          array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
          array("name" => array("data" => "Comisión", "class" => "filter-number col-comision"), "sortable" => 0),
          array("name" => array("data" => "Estatus", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
          array("name" => array("data" => '<i class="fas fa-exclamation-triangle sod"></i>', "class" => "filter-text dont-filter"), "sortable" => 0),
          array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => "Ver", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => '<i class="fa fa-envelope sod" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
          array("name" => array("data" => "Autorizado", "class" => "dont-filter"), "sortable" => 0),
        );
      }
    } else if (in_array("Auxiliar CCTV", $user->roles)) {
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "C", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Técnico", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Servicio", "class" => "filter-number col-servicio"), "sortable" => 0),
        array("name" => array("data" => "Venta", "class" => "filter-number col-venta"), "sortable" => 0),
        array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
        array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
        array("name" => array("data" => "Estatus", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => '<i class="fas fa-exclamation-triangle sod"></i>', "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Ver", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fas fa-file-alt sod"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope sod" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => "Autorizado", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<span class="material-icons sod">history_edu</span>', "class" => "dont-filter"), "sortable" => 0),
      );
    } else {
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "C", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Técnico", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Servicio", "class" => "filter-number col-servicio"), "sortable" => 0),
        array("name" => array("data" => "Venta", "class" => "filter-number col-venta"), "sortable" => 0),
        array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
        array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
        array("name" => array("data" => "Comisión", "class" => "filter-number col-comision"), "sortable" => 0),
        array("name" => array("data" => "Estatus", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => '<i class="fas fa-exclamation-triangle sod"></i>', "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Ver", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fas fa-file-alt sod"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope sod" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => "Autorizado", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<span class="material-icons sod">history_edu</span>', "class" => "dont-filter"), "sortable" => 0),
      );
    }


    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


    $table = array(
      "header" => $header,
      "rows" => $servicios,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_servicios", "class" => array("table-sm"))
    );


    $result = theme('table', $table);

    echo $result;
  }


  /**
   * @param $id_servicio
   * @param $tipo 1: piezas_precio, 2: piezas_costo
   * @return int
   */
  private function calcular_precio_total($id_servicio, $tipo)
  {
    if ($tipo == 1) {
      $get_precio = db_select('partners_servicios_datos', 'psd');
      $get_precio->addExpression('SUM(pieza_precio)', 'total_piezas_precio');
      $get_precio->condition('psd.id_servicio', $id_servicio);
      $precio = $get_precio->execute()->fetchField();
      return $precio;
    } else if ($tipo == 2) {
      $v = db_select('partners_servicios_datos', 'psd')
        ->fields('psd', array('id_servicio'))
        ->condition('id_servicio', $id_servicio)
        ->condition('pieza_costo', 0)
        ->execute()->fetchField();

      if ($v) {
        return 0;
      } else {
        $get_costo = db_select('partners_servicios_datos', 'psd');
        $get_costo->addExpression('SUM(pieza_costo)', 'total_piezas_costo');
        $get_costo->condition('id_servicio', $id_servicio);
        $costo = $get_costo->execute()->fetchField();
        return $costo;
      }
    } else if ($tipo == 3) {
      $get_precio = db_select('partners_servicios_datos', 'psd');
      $get_precio->addExpression('SUM(pieza_precio)', 'total_piezas_precio');
      $get_precio->condition('psd.id_servicio', $id_servicio);
      $precio = $get_precio->execute()->fetchField();
      $total_servicio = db_select('partners_servicios', 'ps')
        ->fields('ps', array('servicio_total'))
        ->condition('id_servicio', $id_servicio)
        ->execute()->fetchField();
      return $precio + $total_servicio;
    }
  }

  private function update_status($datos)
  {
    global $user;
    if ($datos->obs) {
      db_update('partners_servicios')
        ->fields(
          array(
            $datos->col => $datos->new_val,
            'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_servicios', 'id_servicio', $datos->id_servicio)
          )
        )
        ->condition('id_servicio', $datos->id_servicio)
        ->execute();
    } else {
      db_update('partners_servicios')
        ->fields(
          array(
            $datos->col => $datos->new_val,
          )
        )
        ->condition('id_servicio', $datos->id_servicio)
        ->execute();
    }

    if (isset($datos->capturar_caja) && $datos->capturar_caja != '') {
      $this->capturar_entrada_caja($datos->concepto_capturar_caja, $datos->cantidad_capturar_caja);
    }

    $this->register_log_actions('partners_servicios', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
    $this->throw_message('success', "Cambios Guardados");
  }

  private function eliminar_servicio($datos)
  {

    // obtener datos del servicio
    $prevData = db_select('partners_servicios', 'ps')
      ->fields('ps')
      ->condition('id_servicio', $datos);
    $prevData = $prevData->execute()->fetch(PDO::FETCH_ASSOC);

    // validar si es un servicio con poliza    
    if ($prevData['folio_poliza'] == null) {
      // si no tiene poliza, proceso normal
      db_update('partners_servicios')
        ->fields(
          array(
            'servicio_eliminado' => 1
          )
        )
        ->condition('id_servicio', $datos)
        ->execute();
      db_update('partners_mercancia')
        ->fields(
          array(
            'reporte_procesado' => 0,
            'procesado' => 0 // Regresa la salida de mercancía a Procesado = NO
          )
        )
        ->condition('id_reporte_procesado', $datos)
        ->execute();
    } else {
      // si tiene poliza, actualizar cliente, poliza, servicio_poliza y servicio
      $folio_poliza = $prevData['folio_poliza'];
      $horas_a_reembolsar = $prevData['horas_totales'];

      $datosPoliza = db_select('partners_polizas', 'pp')
        ->fields('pp')
        ->condition('id_poliza', $folio_poliza);
      $datosPoliza = $datosPoliza->execute()->fetch(PDO::FETCH_ASSOC);

      $saldo_cliente_poliza = $datosPoliza['saldo_cliente'];
      $horas_usadas_actuales = $datosPoliza['horas_usadas'];

      $datosCliente = db_select('partners_clientes', 'pc')
        ->fields('pc')
        ->condition('id_cliente', $datosPoliza['id_cliente']);
      $datosCliente = $datosCliente->execute()->fetch(PDO::FETCH_ASSOC);

      $saldo_cliente_tabla = $datosCliente['saldo_horas'];

      $nuevo_saldo_poliza = (int) $saldo_cliente_poliza + (int) $horas_a_reembolsar;
      $nuevo_saldo_cliente = (int) $saldo_cliente_tabla + (int) $horas_a_reembolsar;
      $horas_usadas_nuevas = (int) $horas_usadas_actuales - (int) $horas_a_reembolsar;

      // borrar el registro en servicios_polizas

      db_delete('partners_servicios_polizas')
        ->condition('id_servicio_poliza', $prevData['id_servicio_poliza'])
        ->execute();

      // marcar el servicio como eliminado y con las horas previas

      db_update('partners_servicios')
        ->fields(
          array(
            'servicio_eliminado' => 1,
            'id_servicio_poliza' => null
          )
        )
        ->condition('id_servicio', $datos)
        ->execute();


      // cambiar el registro en partners_mercancia

      db_update('partners_mercancia')
        ->fields(
          array(
            'reporte_procesado' => 0,
            'procesado' => 0 // Regresa la salida de mercancía a Procesado = NO
          )
        )
        ->condition('id_reporte_procesado', $datos)
        ->execute();

      // actualizar cliente
      db_update('partners_clientes')
        ->fields(
          array(
            'saldo_horas' => $nuevo_saldo_cliente
          )
        )
        ->condition('id_cliente', $datosCliente['id_cliente'])
        ->execute();
      // actualizar poliza
      db_update('partners_polizas')
        ->fields(
          array(
            'saldo_cliente' => $nuevo_saldo_poliza,
            'horas_usadas' => $horas_usadas_nuevas
          )
        )
        ->condition('id_cliente', $datosCliente['id_cliente'])
        ->execute();

    }
    $this->throw_message('success', 'Eliminado correctamente.');
    $this->register_log_actions('partners_servicios', 'delete', 'Se eliminó el reporte de servicio: ' . $datos);
  }

  private function reactivate_servicio($datos)
  {
    db_update('partners_servicios')
      ->fields(
        array(
          'servicio_eliminado' => 0
        )
      )
      ->condition('id_servicio', $datos)
      ->execute();
    db_update('partners_mercancia')
      ->fields(
        array(
          'reporte_procesado' => 1,
          'procesado' => 1 // Regresa la salida de mercancía otra vez a Procesado = SI
        )
      )
      ->condition('id_reporte_procesado', $datos)
      ->execute();
    $this->throw_message('success', 'Reactivado correctamente.');
    $this->register_log_actions('partners_servicios', 'update', 'Se reactivó el reporte de servicio: ' . $datos);
  }

  /**
   * @param $datos ->type 1: render_vista ,2 : capturar
   */
  private function modificacion_costos($datos)
  {
    if ($datos->type == 1) {
      $get_piezas = db_select('partners_servicios_datos', 'psd')
        ->fields('psd')
        ->condition('psd.id_servicio', $datos->id_servicio);
      $piezas = $get_piezas->execute()->fetchAll(PDO::FETCH_ASSOC);
      $data = [];
      $data['id_servicio'] = $datos->id_servicio;
      $data['piezas'] = $piezas;
      $render_tpl = render_template('php', 'servicios.vista_modificacion_piezas', $data);

      $this->throw_message('success', $render_tpl);
    } else if ($datos->type == 2) {
      if ($datos->datos) {
        foreach ($datos->datos as $pieza) {
          db_update('partners_servicios_datos')
            ->fields(
              array(
                'pieza_costo' => strtr($pieza->new_costo, array(',' => ''))
              )
            )
            ->condition('id_pieza', $pieza->id_pieza)
            ->execute();
        }
        $this->throw_message('success', 'Piezas modificadas correctamente');
      }
    }
  }

  /**
   * @param $datos ->type: 1 Get folios, 2: Render piezas
   */
  private function get_list_piezas($datos)
  {
    global $user;
    if ($datos->type == 1) {
      $id_vale = db_select('partners_mercancia', 'pm')
        ->fields('pm', array('id_salida', 'detalle_salida'));
      $id_vale->condition('id_usuario_solicito', $user->uid)
        ->condition('procesado', 0)
        ->condition('reporte_procesado', 0)
        ->condition('tipo_salida', 2)
        ->condition('salida_eliminada', 0)
        ->condition('id_cliente', $datos->id_cliente);
      $vales = $id_vale->execute();
      $data = [];
      while ($row = $vales->fetchAssoc()) {
        $data[] = array("id_salida" => $row['id_salida'], "detalle" => $row['detalle_salida']);
      }
      if (!$data) {
        $this->throw_message('error', 'No se encontraron salidas de mercancía con este cliente.');
      } else {
        $this->throw_message('success', $data);
      }
    } else if ($datos->type == 2) {
      $get_piezas = db_select('partners_mercancia_productos', 'pmp')
        ->fields('pmp', array('nombre_producto', 'costo', 'venta'))
        ->condition('id_salida', $datos->id_salida);
      $piezas = $get_piezas->execute();
      $data = [];
      while ($row = $piezas->fetchAssoc()) {
        $data[] = array("detalle" => $row['nombre_producto'], "costo" => $row['costo'], "venta" => $row['venta']);
      }
      if (!$data) {
        $this->throw_message('error', "No se encontrarón piezas.");
      } else {
        $this->throw_message('success', $data);
      }
    }
  }

  /**
   * @param $datos : id_servicio
   */
  private function vista_costos_simple($datos)
  {
    $get_piezas = db_select('partners_servicios_datos', 'psd')
      ->fields('psd')
      ->condition('psd.id_servicio', $datos->id_servicio);
    $piezas = $get_piezas->execute()->fetchAll(PDO::FETCH_ASSOC);
    $data = [];
    $data['id_servicio'] = $datos->id_servicio;
    $data['piezas'] = $piezas;
    $render_tpl = render_template('php', 'servicios.vista_costos_piezas', $data);
    $this->throw_message('success', $render_tpl);
  }

  /**
   * Se marca como facturado el servicio, y aparte, mete la factura al zip de la factura para después
   * ser enviada.
   * @param $datos
   */
  private function marcar_facturado($datos)
  {
    $name_factura = $datos->rfc_cliente . 'FE00000' . $datos->folio_factura;
    if (file_exists(HOME_SERVER . 'facturas/' . $name_factura . '.zip')) {
      // Si existe la factura en el servidor, entonces ahora si meter el servicio al zip

      $servicio = $this->datos_servicio($datos->folio_servicio);
      $html = render_template('php', 'servicios.reporte_servicio', $servicio);
      $this->generate_pdf($html, $servicio['folio'], 'Hoja de Servicio ' . $servicio['folio'], 3);

      $ruta_pdf = HOME_SERVER . 'facturas_tmp/Hoja de Servicio ' . $servicio['folio'] . '.pdf';
      // Una vez con el archivo en el servidor, se deberá meter al zip y despues eliminar el archivo tmp.
      $zip = new ZipArchive;
      if ($zip->open(HOME_SERVER . 'facturas/' . $name_factura . '.zip') === TRUE) {
        // Agregar el .pdf del servicio al zip y después cerrar el zip.
        $zip->addFile($ruta_pdf, 'Hoja de Servicio ' . $servicio['folio'] . '.pdf');
        $zip->close();

        // Una vez que se allá agregado el pdf del servicio al zip, se elimina este pdf que solo se necesitaba
        // temporalmente
        unlink($ruta_pdf);

        db_update('partners_servicios')
          ->fields(
            array(
              'pagado_admon' => 2,
            )
          )
          ->condition('id_servicio', $datos->folio_servicio)
          ->execute();

        $this->track_down_facturado($datos->folio_factura, $datos->folio_servicio, "Administrador de Reportes de Servicios", "partners_servicios", $datos->f_servicio);
        $this->throw_message('success', 'Servicio marcado como facturado correctamente.');
      } else {
        $this->throw_message('error', 'Ocurrio un error al tratar de abrir el zip de la factura.');
      }
    } else {
      $this->throw_message('error', "No se  encuentra la factura en el servidor, primero subela y repite este proceso.");
    }
  }

  /**
   * Genera la vista con todos los datos necesarios para poder facturar un servicio.
   * @param $id_servicio
   */
  private function vista_facturar_servicio($id_servicio)
  {
    $datos = $this->datos_servicio($id_servicio);

    $query_datos_facturacion = db_select('partners_clientes_datos_facturacion', 'pcdf');
    $query_datos_facturacion->fields('pcdf');
    $query_datos_facturacion->condition('id_cliente', $datos['servicio']['id_cliente']);

    $datos_facturacion = $query_datos_facturacion->execute()->fetchAll(PDO::FETCH_ASSOC);

    $datos['datos_facturacion'] = $datos_facturacion;
    $template = render_template('php', 'servicios.vista_facturar_servicio', $datos);
    $this->throw_message('success', $template);
  }


  /**
   * Genera la factura de un servicio y la envia a los correos que se pasaron como parámetros
   * @param $datos
   */
  private function facturar_servicio($datos)
  {

    // Los facturación los acaban de registrar en este momento, capturar en tabla de datos de facturación.
    if ($datos->nuevo_dato_facturacion == "true") {
      db_insert('partners_clientes_datos_facturacion')
        ->fields(
          array(
            'id_cliente' => $datos->id_cliente,
            'nombre_facturacion' => $datos->nombre_cliente,
            'rfc' => $datos->rfc_cliente
          )
        )
        ->execute();
    } else {
      // Ya existia el dato de facturación, solo actualizarlo por si lo llegaron a modificar.
      db_update('partners_clientes_datos_facturacion')
        ->fields(
          array(
            'nombre_facturacion' => $datos->nombre_cliente,
            'rfc' => $datos->rfc_cliente
          )
        )
        ->condition('id_dato', $datos->id_dato_facturacion)
        ->execute();
    }


    # llenamos los datos de nuestro CFDI
    # crearemos un xml de prueba
    $d = array();

    # datos basicos SAT
    $d['Serie'] = 'W';
    $next_folio = $this->next_folio_factura_electronica();
    $d['Folio'] = $next_folio; #'101';
    #$d['Fecha'] = 'AUTO'; // Habia un problema, y esque era probable que se facturarán dobles en caso de dar por error doble click
    # Por lo que contacte a los del Paq y me dijeron que yo pusiera la fecha como esta abajo, con el formato del SAT: yyyy-mm-ddThh:mm:ss
    $d['Fecha'] = date('Y-m-d\TH:i:s');
    $d['FormaPago'] = $datos->forma_pago;
    //$d['CondicionesDePago'] = 'CONDICIONES';
    $d['SubTotal'] = number_format($datos->importe, 2, '.', '');
    $d['Descuento'] = null; # o bien: null
    $d['Moneda'] = 'MXN';
    //$d['TipoCambio'] = 1;
    $d['Total'] = number_format($datos->total, 2, '.', '');
    $d['TipoDeComprobante'] = 'I';
    $d['MetodoPago'] = $datos->metodo_pago;
    $d['LugarExpedicion'] = '44200';

    # opciones de personalización (opcionales)
    $d['LeyendaFolio'] = "FACTURA"; # leyenda opcional para poner a lado del folio: FACTURA, RECIBO, NOTA DE CREDITO, ETC.

    # Regimen fiscal del emisor ligado al tipo de operaciones que representa este CFDI
    $d['Emisor']['RegimenFiscal'] = '612'; # ver catálogo del SAT

    # Datos del receptor
    $d['Receptor']['Rfc'] = $datos->rfc_cliente;
    $d['Receptor']['Nombre'] = strtoupper($datos->nombre_cliente);
    $d['Receptor']['NumRegIdTrib'] = ''; # para extranjeros
    $d['Receptor']['UsoCFDI'] = $datos->uso_cfdi; # uso que le dará el cliente al cfdi

    # Receptor -> Domicilio (OPCIONAL)
    //$d["Receptor"]["Calle"] = "Palmas";
    //$d["Receptor"]["NoExt"] = "9810";
    #$d["Receptor"]["NoInt"] = null;
    //$d["Receptor"]["Colonia"] = "Anahuac";
    #$d["Receptor"]["Localidad"] = null;
    #$d["Receptor"]["Referencia"] = null;
    //$d["Receptor"]["Municipio"] = "Apodaca";
    //$d["Receptor"]["Estado"] = "Nuevo Leon";
    //$d["Receptor"]["Pais"] = "México";
    //$d["Receptor"]["CodigoPostal"] = "67349";

    # >> conceptos <<
    # concepto 1
    $d['Conceptos'][0]['ClaveProdServ'] = '81111800';
    $d['Conceptos'][0]['NoIdentificacion'] = '0006'; #codigo interno o SKU, GTIN, codigo de barras, etc.
    $d['Conceptos'][0]['Cantidad'] = 1.00;
    $d['Conceptos'][0]['ClaveUnidad'] = 'E48'; # Clave SAT
    $d['Conceptos'][0]['Unidad'] = 'SERVICIO'; # Unidad de Medida
    $d['Conceptos'][0]['Descripcion'] = 'ASESORIA EN INFORMATICA'; #maximo 1000 caracteres
    $d['Conceptos'][0]['ValorUnitario'] = number_format($datos->importe, 2, '.', '');
    $d['Conceptos'][0]['Importe'] = number_format($datos->importe, 2, '.', '');
    # $d['Concepto'][0]['Descuento'] = null; # no se permiten valores negativos

    # concepto 1 -> impuestos
    $d['Conceptos'][0]['Impuestos']['Traslados'][0]['Base'] = number_format($datos->importe, 2, '.', '');
    $d['Conceptos'][0]['Impuestos']['Traslados'][0]['Impuesto'] = '002';
    $d['Conceptos'][0]['Impuestos']['Traslados'][0]['TipoFactor'] = 'Tasa';
    $d['Conceptos'][0]['Impuestos']['Traslados'][0]['TasaOCuota'] = '0.160000';
    $d['Conceptos'][0]['Impuestos']['Traslados'][0]['Importe'] = number_format($datos->iva, 2, '.', '');

    $d['Impuestos']['TotalImpuestosTrasladados'] = number_format($datos->iva, 2, '.', '');

    # Definimos a detalle los traslados
    $d['Impuestos']['Traslados'][0]['Impuesto'] = '002'; # 001=ISR, 002=IVA, 003=IEPS
    $d['Impuestos']['Traslados'][0]['TipoFactor'] = 'Tasa';
    $d['Impuestos']['Traslados'][0]['TasaOCuota'] = '0.160000'; # 16%
    $d['Impuestos']['Traslados'][0]['Importe'] = number_format($datos->iva, 2, '.', ''); # Monto

    # preparamos los datos
    $headers = array(
      'Accept' => 'application/json',
      'api-usuario' => '  NAVL7601272P5',
      'api-password' => 'PfTc4745',
      'jsoncfdi' => json_encode($d)
    );

    # hacemos la petición y enviamos los parametros
    $response = Unirest\Request::post('http://app.facturadigital.com.mx/api/cfdi/generar', $headers);

    $response->code; // HTTP Status code
    $response->headers; // Headers
    $response->body; // Parsed body
    $response->raw_body; // Unparsed body

    # si el timbrado es exitoso (200):
    if ($response->code == 200) {
      $factura_timbrada = json_decode($response->raw_body);


      // Con CURL, traer el pdf que nos genera el PAC.
      $ch = curl_init($factura_timbrada->cfdi->PDF);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_REFERER, $factura_timbrada->cfdi->PDF);

      try {
        $data = curl_exec($ch);
      } catch (Exception $e) {
        var_dump($e);
      }

      curl_close($ch);

      // Crear el nombre que se usará para ponerle al pdf, al xml y al zip.
      $factura_name = $datos->rfc_cliente . 'FW' . str_pad($next_folio, 10, '0', STR_PAD_LEFT);

      $temp_pdf_file = $factura_name . '.pdf';
      file_put_contents(HOME_SERVER . 'facturas_tmp/' . $temp_pdf_file, $data);


      $xml_content = base64_decode($factura_timbrada->cfdi->XmlBase64);

      $temp_xml_file = $factura_name . '.xml';
      file_put_contents(HOME_SERVER . 'facturas_tmp/' . $temp_xml_file, $xml_content);


      // Crear ZIP
      $zip = new ZipArchive();

      if ($zip->open(HOME_SERVER . 'facturas_tmp/' . $factura_name . '.zip', ZipArchive::CREATE) === true) {
        // Una vez con el zip creado, meter el xml y el pdf
        $zip->addFile(HOME_SERVER . 'facturas_tmp/' . $temp_xml_file, $temp_xml_file);
        $zip->addFile(HOME_SERVER . 'facturas_tmp/' . $temp_pdf_file, $temp_pdf_file);


        // Ahora meter el reporte de servicio
        $servicio = $this->datos_servicio($datos->id_servicio);
        $html = render_template('php', 'servicios.reporte_servicio', $servicio);

        // Con type 3, genera el pdf y lo pone en la carpeta de facturas_tmp para ser usado después.
        $this->generate_pdf($html, $servicio['folio'], 'Hoja de Servicio ' . $servicio['folio'], 3);
        $ruta_pdf = HOME_SERVER . 'facturas_tmp/Hoja de Servicio ' . $servicio['folio'] . '.pdf';
        $zip->addFile($ruta_pdf, 'Hoja de Servicio ' . $servicio['folio'] . '.pdf');

        $zip->close();

        // Eliminar el reporte de servicio temporal
        unlink($ruta_pdf);


        // Ahora con el zip creado, moverlo dentro de la carpeta de facturas/
        rename(HOME_SERVER . 'facturas_tmp/' . $factura_name . '.zip', HOME_SERVER . 'facturas/' . $factura_name . '.zip');
      }

      /// Independientemente de que se haya creado el zip o no, eliminar los archivos temporales.
      // unlink(HOME_SERVER . 'facturas_tmp/' . $temp_xml_file);
      unlink(HOME_SERVER . 'facturas_tmp/' . $temp_pdf_file);


      // Una vez se haya creado el zip (o no), marcar el reporte como facturado.
      db_update('partners_servicios')
        ->fields(
          array(
            'servicio_facturado' => $next_folio,
            'factura_w_servicio' => $factura_name,
            'factura_w_nombre_facturacion' => strtoupper($datos->nombre_cliente),
            'factura_w_fecha' => REQUEST_TIME,
            'factura_w_total' => $datos->total,
            'pagado_admon' => 2,
            'factura_w_correos_enviados' => implode(',', $datos->correos)
          )
        )
        ->condition('id_servicio', $datos->id_servicio)
        ->execute();


      // Crear un registro en cobranza para darle seguimiento
      $servicio = $this->datos_servicio($datos->id_servicio);

      db_insert('partners_cobranza')
        ->fields(
          array(
            'folio' => $next_folio,
            'apoyo' => 0,
            'factura_enviada' => 1,
            'notas' => $servicio['folio'],
            'factura_pagada' => 0,
            'serie' => 'W'
          )
        )
        ->execute();


      // Una vez con la factura timbrada, el zip generado y el estatus actualizado, ahora enviar la factura a los correos.
      $data_send_mail = array(
        "correos" => $datos->correos,
        "ruta" => HOME_SERVER . 'facturas/' . $factura_name . '.zip',
        "factura_name" => $temp_xml_file
      );
      $status_email = $this->enviar_correo_factura($data_send_mail);

      $this->throw_message($status_email['status'], $status_email['message']);
    } else {
      # imprimimos la respuesta (JSON)
      $this->throw_message('error', "Error al timbrar la factura: " . $response->raw_body);
    }
  }


  /**
   * Retorna el próximo folio a ser utilizado en la factura electrónica de los servicios.
   * @return mixed
   */
  private function next_folio_factura_electronica()
  {
    $folio = db_select('partners_servicios', 'ps');
    $folio->addField('ps', 'servicio_facturado');
    $folio->orderBy('servicio_facturado', 'DESC');
    $folio->range(0, 1);
    $f = $folio->execute()->fetchField();

    return $f + 1;
  }


  /**
   * Enviar el correo con el zip adjunto de la factura a los correos que se especificaron.
   * Envía automáticamente una copia al técnico que realiza la factura.
   * Regresa un arreglo con información de que si se ejecuto o no.
   * @param $datos
   * @return array
   */
  private function enviar_correo_factura($datos)
  {
    global $user;
    $to = $datos['correos'];
    $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];

    // Agregar el correo del técnico.
    array_push($to, $user->mail);

    $transport = new Swift_SendmailTransport();
    $mailer = new Swift_Mailer($transport);

    // Traer los datos de la factura
    $zip = new ZipArchive;
    if ($zip->open($datos['ruta']) === TRUE) {
      $file = $zip->getFromName($datos['factura_name']);
    }
    $zip->close();

    // Si el archivo está disponible, enviar el correo.
    if ($file) {
      $datos_template = [];
      $factura = new SimpleXMLElement($file);
      $datos_template['Serie'] = $factura[0]['Serie'];
      $datos_template['Folio'] = $factura[0]['Folio'];
      $datos_template['Total'] = (float) $factura[0]['Total'];
      $datos_template['Moneda'] = $factura[0]['Moneda'];
      $datos_template['send_paypal'] = encrypt_decrypt('encrypt', $factura[0]['Serie'] . '~' . $factura[0]['Folio'] . '~' . $factura[0]['Total']);
      $body = render_template('php', 'cobranza.mail_enviar_factura', $datos_template);
      $message = (new Swift_Message())
        ->setSubject('Factura ' . $datos_template['Serie'] . $datos_template['Folio'])
        ->setFrom($from)
        ->setBody($body, 'text/html');
      $failedRecipients = [];
      $numSent = 0;
      $attachment = Swift_Attachment::fromPath($datos['ruta'], 'application/zip');
      $message->attach($attachment);

      foreach ($to as $address => $name) {
        if (is_int($address)) {
          $message->setTo($name);
        } else {
          $message->setTo([$address => $name]);
        }

        $this->register_log_actions('partners_cobranza', 'mail', 'Se envió la factura ' . $datos_template['Serie'] . $datos_template['Folio'] . ' a: ' . $name);
        $numSent += $mailer->send($message, $failedRecipients);
      }

      $status = "success";
      $message = "Se ha timbrado la factura, y se ha enviado correctamente a todos los correos.";
    } else {
      $status = "error";
      $message = "Se ha timbrado la factura, pero no se encontró el zip (" . $datos['ruta'] . ") en el servidor por lo tanto no ha sido posible enviar el correo.";
    }

    return array("status" => $status, "message" => $message);
  }


  /**
   * Marca el servicio como pagado otro y guarda cual fue ese otro metodo de pago.
   * @param $datos
   */
  private function status_pagado_otro($datos)
  {
    db_update('partners_servicios')
      ->fields(
        array(
          'pagado_admon' => 4,
          'pagado_admon_otro' => $datos->otro
        )
      )
      ->condition('id_servicio', $datos->id_servicio)
      ->execute();
    $this->throw_message('success', 'Status modificado correctamente.');
  }

  /**
   * Controlar el estatus de especial, simplemente SI/NO y guarda observaciones.
   * @param $datos
   * @throws Exception
   */
  private function status_especial($datos)
  {
    db_update('partners_servicios')
      ->fields(
        array(
          'observaciones' => $this->serialize_obs($datos->motivo, 2, 'partners_servicios', 'id_servicio', $datos->idServicio),
          'status_especial' => $datos->especial,
        )
      )
      ->condition('id_servicio', $datos->idServicio)
      ->execute();

    $this->register_log_actions(
      'partners_servicios',
      'update',
      'Se actualizó el estatus de status_especial a : ' . $datos->especial . ' del folio: ' . $datos->idServicio
    );

    $this->throw_message('success', 'Estatus actualizado correctamente.');
  }

  /**
   * Conseguir datos de servicio
   * @param $datos
   */
  private function getServicioData($datos)
  {
    $res = $this->datos_servicio($datos->id);
    $res['servicio_total'] = number_format($res['servicio_total'], 2);
    $this->throw_message('success', json_encode($res));
  }

  /**
   * Agregar firma
   * @param $datos
   */
  private function agregarFirma($datos)
  {
    try {
      db_update('partners_servicios')
        ->fields(
          array(
            'autorizado' => 2,
            'firma' => $datos->firma
          )
        )
        ->condition('id_servicio', $datos->id)
        ->execute();
      $this->throw_message('success', "Documento firmado");
    } catch (Exception $e) {
      $this->throw_message('error', $e->getMessage());
    }
  }
}