<?php

class seguimiento_facturas_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
            }
        }
    }

    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $query = db_select('partners_seguimiento_pagos', 'psp');
        $query->fields('psp');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('psp.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('psp.created_at', array($f_inicio, $f_final), 'BETWEEN');
            }
        }

        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $seguimiento_factura_or = db_or()
                ->condition('psp.numero_factura', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('psp.origen', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $query->condition($seguimiento_factura_or);
        }


        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        while ($row = $query_datos->fetchAssoc()) {
            $seguimiento_factura[] = array(
                "data" => array(
                    date('d/m/y', $row['created_at']),
                    user_load($row['created_by'])->name,
                    "E " . $row['numero_factura'],
                    $row['id_registro'],
                    $row['origen'],
                )
            );
        }

        $header_cols = array(
            array("name" => "Fecha", "sortable" => 0),
            array("name" => "Usuario", "sortable" => 0),
            array("name" => "Número Factura", "sortable" => 0),
            array("name" => "Folio", "sortable" => 0),
            array("name" => "Origen", "sortable" => 0),
        );


        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $seguimiento_factura,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_seguimiento_facturas", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;
    }
}