<?php

/**
 *
 * Created by PhpStorm.
 * User: Erick Gómez (https://github.com/ErickGomez98)
 * Date: 11/01/2019
 * Time: 11:23 AM
 */
class reporte_ventas_sys extends sys_tools
{

  /**
   * reporte_ventas_sys constructor.
   * @param $tipo
   * @param $data
   */
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base':
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base');
          }
          break;
        case 'vista_compras_producto':
          try {
            $this->vista_compras_producto($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_compras_producto');
          }
          break;
        case 'modificar_costo':
          try {
            $this->modificar_costo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'modificar_costo');
          }
          break;
        case 'change_status':
          try {
            $this->change_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'change_status');
          }
          break;
        case 'reporte_base_tienda':
          try {
            $this->reporte_base_tienda($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base_tienda');
          }
          break;
        case 'vista_bitacora_reporte_tienda':
          try {
            $this->vista_bitacora_reporte_tienda($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_bitacora_reporte_tienda');
          }
          break;
        case 'capturar_bitacora_reporte_tienda':
          try {
            $this->capturar_bitacora_reporte_tienda($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_bitacora_reporte_tienda');
          }
          break;
        case 'finalizar_bitacora_reporte_tienda':
          try {
            $this->finalizar_bitacora_reporte_tienda($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'finalizar_bitacora_reporte_tienda');
          }
          break;
      }
    }
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function reporte_base($datos)
  {

    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

    //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
    //mssql_select_db($server_db_access);
    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);

    if ($objConnect) {
      $fi = str_replace('/', '-', trim($datos->filter->start_date));
      $ff = str_replace('/', '-', trim($datos->filter->end_date));
      $f_inicio = date('m/d/y', strtotime($fi));
      $f_final = date('m/d/y', strtotime($ff));
      $query = "
                  SELECT admDocumentos.CFECHA AS 'FECHA',
                    CONCAT(admDocumentos.CSERIEDOCUMENTO,' ',admDocumentos.CFOLIO) AS 'FOLIO',
                    admDocumentos.CRAZONSOCIAL AS 'NOMBRE',
                    admProductos.CCODIGOPRODUCTO AS 'CODIGOPRODUCTO',
                    admProductos.CNOMBREPRODUCTO AS 'PRODUCTO',
                    admMovimientos.CUNIDADES AS 'UNIDADES',
                    admMovimientos.CPRECIO AS 'PRECIO',
                    admMovimientos.CCOSTOESPECIFICO AS 'COSTOTOTAL',
                    admMovimientos.CIDMOVIMIENTO,
                    CAST(dbo.GROUP_CONCAT(adns.CNUMEROSERIE) AS TEXT)  AS 'SERIES',
                    admCapasProducto.CNUMEROLOTE AS 'LOTE',
                    CASE admProductos.CTIPOPRODUCTO
                      WHEN 1 THEN 'PIEZA'
                      WHEN 2 THEN 'PAQUETE'
                      WHEN 3 THEN 'SERVICIO'
                  END AS 'TIPO'
                  FROM admDocumentos
                  INNER JOIN admMovimientos
                    ON admDocumentos.CIDDOCUMENTO = admMovimientos.CIDDOCUMENTO
                  INNER JOIN admProductos
                    ON admMovimientos.CIDPRODUCTO = admProductos.CIDPRODUCTO
                  LEFT JOIN admMovimientosSerie AS adms
                    ON adms.CIDMOVIMIENTO = admMovimientos.CIDMOVIMIENTO
                  LEFT JOIN admNumerosSerie AS adns
                    ON adms.CIDSERIE = adns.CIDSERIE
                  LEFT JOIN admMovimientosCapas
                    ON admMovimientos.CIDMOVIMIENTO = admMovimientosCapas.CIDMOVIMIENTO
                  LEFT JOIN admCapasProducto
                    ON admCapasProducto.CIDCAPA = admMovimientosCapas.CIDCAPA
                  WHERE (admDocumentos.CIDDOCUMENTODE = 4)
                    AND ( (admDocumentos.CIDCONCEPTODOCUMENTO = 3030) OR (admDocumentos.CIDCONCEPTODOCUMENTO = 3025)  )
                    AND (admDocumentos.CIDAGENTE = 1)
                    AND (admDocumentos.CCANCELADO = 0)
                    AND (admDocumentos.CFECHA between '$f_inicio' and '$f_final' )
                  GROUP BY admDocumentos.CFOLIO,
                  admDocumentos.CSERIEDOCUMENTO,
                  admDocumentos.CFECHA,
                  admDocumentos.CRAZONSOCIAL,
                  admProductos.CCODIGOPRODUCTO,
                  admProductos.CTIPOPRODUCTO,
                  admProductos.CNOMBREPRODUCTO,
                  admMovimientos.CUNIDADES,
                  admMovimientos.CPRECIO,
                  admMovimientos.CCOSTOESPECIFICO,
                  admCapasProducto.CNUMEROLOTE,
                  admMovimientos.CIDMOVIMIENTO
                  ORDER BY CFOLIO ASC";
      //$result = mssql_query($query);
      $result = sqlsrv_query($objConnect, $query);

      if (!$result) {
        //echo mssql_get_last_message();
        echo sqlsrv_errors();
      }
      $ventaTotal = 0;
      $costoTotal = 0;
      $utilidadTotal = 0;
      //while ($obj = mssql_fetch_object($result)) {
      while ($obj = sqlsrv_fetch_object($result)) {
        $x = gettype($obj->FECHA) == "string" ? new DateTime($obj->FECHA) : $obj->FECHA;
        $f = $x->getTimestamp();
        $venta = $obj->UNIDADES * $obj->PRECIO;
        $ventaTotal += $venta;
        $check_costo_change = $this->check_costo_modificado($obj->CIDMOVIMIENTO, $obj->CODIGOPRODUCTO, $obj->UNIDADES, $obj->SERIES, date('m/d/y', $f));
        if ($check_costo_change == 0) {
          $costo = array("data" => number_format($obj->COSTOTOTAL, 2, '.', ','), "class" => "text-right vista_compras_producto cursor-pointer");
          $c_number = number_format($obj->COSTOTOTAL, 2, '.', ',');
          $utilidad = $venta - $obj->COSTOTOTAL;
        } else {
          $costo = array("data" => number_format($check_costo_change, 2, '.', ','), "class" => "text-right vista_compras_producto cursor-pointer status-yellow");
          $utilidad = $venta - $check_costo_change;
          $c_number = number_format($check_costo_change, 2, '.', ',');
        }
        $utilidadTotal += $utilidad;
        $costoTotal += (($check_costo_change == 0) ? $obj->COSTOTOTAL : $check_costo_change);

        $get_status = $this->get_status($obj->CIDMOVIMIENTO);
        $status = 0;
        switch ($get_status) {
          case 0:
            // Este caso es cuando el status del movimiento no fue encontrado (el movimiento no existe en la BD local)
            $status = array("data" => "Revisar", "class" => array("text-center", "cambiar_status", "cursor-pointer", "status-red"));
            break;
          case 1:
            $status = array("data" => "Ok", "class" => array("text-center", "cambiar_status", "cursor-pointer", "status-green"));
            break;
          case 2:
            $status = array("data" => "Revisar", "class" => array("text-center", "cambiar_status", "cursor-pointer", "status-red"));
            break;
          default:
            break;
        }
        $utilidadProcentaje = ($utilidad / $venta) * 100;
        $utilidadProcentaje = (($utilidadProcentaje < 0) ? 0 : $utilidadProcentaje);
        if ($utilidadProcentaje <= 15) {
          $utilidadProcentajeClass = " status-red";
        } else if ($utilidadProcentaje >= 50) {
          $utilidadProcentajeClass = " status-yellow";
        } else {
          $utilidadProcentajeClass = "";
        }
        $reporte_ventas[] = array(
          "data" => array(
            date('d/m/y', $f),
            array("data" => $obj->FOLIO, "class" => array("cursor-pointer", "ver_factura")),
            mb_substr(utf8_encode($obj->NOMBRE), 0, 30, "utf-8"),
            mb_substr($obj->CODIGOPRODUCTO, 0, 17, 'utf-8'),
            mb_substr(utf8_encode($obj->PRODUCTO), 0, 25, "utf-8"),
            $obj->UNIDADES,
            array("data" => number_format($obj->PRECIO, 2, '.', ','), "class" => "text-right"),
            array("data" => number_format($venta, 2, '.', ','), "class" => "text-right"),
            $costo,
            $status,
            array("data" => number_format($utilidad, 2, '.', ','), "class" => "text-right"),
            array("data" => number_format($utilidadProcentaje, 0, '', '') . "%", "class" => "text-right" . $utilidadProcentajeClass),
            array("data" => substr($obj->SERIES, 0, 5), "class" => "cursor-pointer ver_series"),
            array("data" => mb_substr(utf8_encode($obj->LOTE), 0, 5, "utf-8"), "class" => "cursor-pointer ver_lotes"),
            $obj->TIPO,
          ),
          "data-id-movimiento" => $obj->CIDMOVIMIENTO,
          "data-codigo-producto" => $obj->CODIGOPRODUCTO,
          "data-producto" => utf8_encode($obj->PRODUCTO),
          "data-series" => $obj->SERIES,
          "data-lotes" => $obj->LOTE,
          "data-folio" => $obj->FOLIO,
          "data-fecha" => date('d/m/y', $f),
          "data-costo" => $c_number,
          "data-piezas" => $obj->UNIDADES
        );
      }

      $utilidadProcentajeTotal = ($utilidadTotal / $ventaTotal) * 100;
      $utilidadProcentajeTotal = (($utilidadProcentajeTotal < 0) ? 0 : $utilidadProcentajeTotal);
      if ($utilidadProcentajeTotal <= 15) {
        $utilidadProcentajeTotalClass = " status-red";
      } else if ($utilidadProcentajeTotal >= 50) {
        $utilidadProcentajeTotalClass = " status-yellow";
      } else {
        $utilidadProcentajeTotalClass = "";
      }

      $reporte_ventas[] = array(
        "data" => array(
          array("data" => "<b>TOTALES:</b>", "colspan" => 7, "class" => "text-right font-weight-bold"),
          array("data" => number_format($ventaTotal, 2, '.', ','), "class" => "text-right font-weight-bold"),
          array("data" => number_format($costoTotal, 2, '.', ','), "class" => "text-right font-weight-bold"),
          array("data" => ""),
          array("data" => number_format($utilidadTotal, 2, '.', ','), "class" => "text-right font-weight-bold"),
          array("data" => number_format($utilidadProcentajeTotal, 0, '', '') . "%", "class" => "text-right font-weight-bold" . $utilidadProcentajeTotalClass),
        ),
      );

      $header_cols = array(
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Nombre", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Código Producto", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Producto", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Unidades", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Precio", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Venta", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Costo Total", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Status", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Utilidad", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "%", "class" => "dont-filter text-right"), "sortable" => 0),
        array("name" => array("data" => "Series", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Lote", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
      );

      $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);

      $table = array(
        "header" => $header,
        "rows" => $reporte_ventas,
        "sticky" => false,
        "attributes" => array("id" => "table_reporteador_reporte_ventas", "class" => array("table-sm"))
      );


      $result = theme('table', $table);

      echo $result;
    } else {
      echo "not connected";
    }
  }

  private function check_costo_modificado($id_movimiento, $codigoProducto, $cantidad, $serie, $fecha)
  {
    $check = db_select('partners_reporte_ventas', 'prv')
      ->fields('prv', array('costo'))
      ->condition('id_movimiento', $id_movimiento)
      ->execute()->fetchField();

    if (!$check && !$serie) {
      $access_credentials = db_select('partners_sql_connections', 'psc')
        ->fields('psc')
        ->execute()->fetchAssoc();
      $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
      $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
      $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
      $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

      //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
      //mssql_select_db($server_db_access);
      $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);
      if ($objConnect) {
        $query = "
                    SELECT TOP 10 admProductos.CCODIGOPRODUCTO AS 'CODIGO',
                      admProductos.CNOMBREPRODUCTO AS 'PRODUCTO',
                      CASE admDocumentos.CIDDOCUMENTODE WHEN 19 THEN 'COMPRA' END AS 'TIPO',
                      admDocumentos.CSERIEDOCUMENTO AS 'SERIE',
                      admDocumentos.CFOLIO AS 'FOLIO',
                      admDocumentos.CIDCLIENTEPROVEEDOR AS 'CODIGOCLIENTEPROVEEDOR',
                      admClientes.CRAZONSOCIAL AS 'NOMBRE',
                      admMovimientos.CFECHA AS 'FECHA',
                      admMovimientos.CPRECIO AS 'PRECIO',
                      admMovimientos.CCOSTOESPECIFICO AS 'COSTO',
                      admMovimientos.CUNIDADES AS 'UNIDADES'
                    FROM admClientes admClientes,
                      admDocumentos admDocumentos,
                      admMovimientos admMovimientos,
                      admProductos admProductos
                    WHERE admMovimientos.CIDDOCUMENTO = admDocumentos.CIDDOCUMENTO
                        AND admMovimientos.CIDPRODUCTO = admProductos.CIDPRODUCTO
                        AND admMovimientos.CFECHA <= '$fecha'
                        AND admClientes.CIDCLIENTEPROVEEDOR = admDocumentos.CIDCLIENTEPROVEEDOR
                        AND admDocumentos.CIDDOCUMENTODE = 19
                        AND admProductos.CCODIGOPRODUCTO= '$codigoProducto'
                    ORDER BY admMovimientos.CFECHA DESC";
        $r = sqlsrv_query($objConnect, $query);
        if (!$r) {
          return 0;
        }
        $obj = sqlsrv_fetch_object($r);
        $check_if_exist = db_select('partners_reporte_ventas', 'prv')
          ->fields('prv', array('id_movimiento'))
          ->condition('id_movimiento', $id_movimiento)
          ->execute()->fetchField();
        if ($obj === false || $obj == null) {
          if (!$check_if_exist) {
            db_insert('partners_reporte_ventas')
              ->fields(array(
                'id_movimiento' => $id_movimiento,
                'costo' => 0,
                'status' => 2
              ))
              ->execute();
          }
        } else {
          $costoPorUnidad = $obj->COSTO / $obj->UNIDADES;
          $costoFinal = $costoPorUnidad * $cantidad;
          if (!$check_if_exist) {
            db_insert('partners_reporte_ventas')
              ->fields(array(
                'id_movimiento' => $id_movimiento,
                'costo' => number_format($costoFinal, 2, '.', ''),
                'status' => 1 # Deberá poner por default el status en 1
              ))
              ->execute();
          } else {
            db_update('partners_reporte_ventas')
              ->fields(array(
                'costo' => number_format($costoFinal, 2, '.', ''),
                'status' => 1 # Deberá poner por default el status en 1
              ))
              ->condition('id_movimiento', $id_movimiento)
              ->execute();
          }
        }
        $this->register_log_actions('partners_reporte_ventas', 'insert', 'Se cambió un costo sobre el movimiento: ' . $id_movimiento);
      } else {
        echo "not connected";
      }
      return number_format($costoFinal, 2, '.', '');
    } else {
      return $check;
    }
    return 0;
  }

  /**
   * Regresa el status que tiene (en caso de tener) una factura en especifico en la tabla de reporte_ventas
   * @param $id_movimiento
   * @return int
   */
  private function get_status($id_movimiento)
  {

    $check = db_select('partners_reporte_ventas', 'prv')
      ->fields('prv', array('status'))
      ->condition('id_movimiento', $id_movimiento)
      ->execute()->fetchField();

    return !$check ? 0 : $check;
  }

  /**
   * Actualiza el status del movimiento con cualquiera de los 3 posibles status.
   * @param $datos
   * @throws Exception
   */
  private function change_status($datos)
  {

    $check_if_exist = db_select('partners_reporte_ventas', 'prv')
      ->fields('prv', array('id_movimiento'))
      ->condition('id_movimiento', $datos->id_movimiento)
      ->execute()->fetchField();

    if (!$check_if_exist) {
      db_insert('partners_reporte_ventas')
        ->fields(array(
          'id_movimiento' => $datos->id_movimiento,
          'status' => $datos->new_val
        ))
        ->execute();
    } else {
      db_update('partners_reporte_ventas')
        ->fields(array(
          'status' => $datos->new_val
        ))
        ->condition('id_movimiento', $datos->id_movimiento)
        ->execute();
    }


    $this->throw_message('success', 'Status actualizado correctamente.');
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function vista_compras_producto($datos)
  {
    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

    //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
    //mssql_select_db($server_db_access);
    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);

    if ($objConnect) {
      $query = "
                SELECT TOP 10 admProductos.CCODIGOPRODUCTO AS 'CODIGO',
                  admProductos.CNOMBREPRODUCTO AS 'PRODUCTO',
                  CASE admDocumentos.CIDDOCUMENTODE WHEN 19 THEN 'COMPRA' END AS 'TIPO',
                  admDocumentos.CSERIEDOCUMENTO AS 'SERIE',
                  admDocumentos.CFOLIO AS 'FOLIO',
                  admDocumentos.CIDCLIENTEPROVEEDOR AS 'CODIGOCLIENTEPROVEEDOR',
                  admClientes.CRAZONSOCIAL AS 'NOMBRE',
                  admMovimientos.CFECHA AS 'FECHA',
	              admMovimientos.CPRECIO AS 'PRECIO',
	              admMovimientos.CCOSTOESPECIFICO AS 'COSTO',
	              admMovimientos.CUNIDADES AS 'UNIDADES'
                FROM admClientes admClientes,
                  admDocumentos admDocumentos,
                  admMovimientos admMovimientos,
                  admProductos admProductos
                WHERE admMovimientos.CIDDOCUMENTO = admDocumentos.CIDDOCUMENTO
                    AND admMovimientos.CIDPRODUCTO = admProductos.CIDPRODUCTO
                    AND admClientes.CIDCLIENTEPROVEEDOR = admDocumentos.CIDCLIENTEPROVEEDOR
                    AND admDocumentos.CIDDOCUMENTODE = 19
                    AND admProductos.CCODIGOPRODUCTO= '$datos->codigo'
                ORDER BY admMovimientos.CFECHA DESC";

      //$r = mssql_query($query);
      $result = sqlsrv_query($objConnect, $query);
      //if (!$r) {
      if (!$result) {
        //echo mssql_get_last_message();
        echo sqlsrv_errors();
      }
      //while ($obj = mssql_fetch_object($r)) {
      while ($obj = sqlsrv_fetch_object($result)) {
        $x = gettype($obj->FECHA) == "string" ? new DateTime($obj->FECHA) : $obj->FECHA;
        $f = $x->getTimestamp();
        $compras_productos[] = array(
          "data" => array(
            $obj->TIPO,
            $obj->SERIE,
            $obj->FOLIO,
            $obj->CODIGOCLIENTEPROVEEDOR,
            utf8_encode($obj->NOMBRE),
            date('d/m/y', $f),
            array("data" => number_format($obj->PRECIO, 2, '.', ','), "class" => "text-right cursor-pointer modificar_costo"),
            array("data" => $obj->UNIDADES, "class" => "text-right"),
            array("data" => number_format($obj->COSTO, 2, '.', ','), "class" => "text-right"),
          ),
          "data-id-movimiento" => $datos->id_movimiento,
        );
      }

      $header_cols = array(
        array("name" => "Tipo", "sortable" => 0),
        array("name" => "Serie", "sortable" => 0),
        array("name" => "Folio", "sortable" => 0),
        array("name" => "Código", "sortable" => 0),
        array("name" => "Nombre", "sortable" => 0),
        array("name" => "Fecha", "sortable" => 0),
        array("name" => "Precio", "sortable" => 0),
        array("name" => "Unidades", "sortable" => 0),
        array("name" => "Costo Total", "sortable" => 0)
      );

      $header = sys_tools::sort_table("CFECHA", "DESC", $header_cols);

      $table = array(
        "header" => $header,
        "rows" => $compras_productos,
        "sticky" => false,
        "attributes" => array("class" => array("table-sm"))
      );


      $result = theme('table', $table);
      $data['table'] = $result;
      $data['id_movimiento'] = $datos->id_movimiento;
      $data['status'] = $this->get_status($datos->id_movimiento);
      $html = render_template('php', 'reporte_ventas.vista_compras_producto', $data);
      $this->throw_message('success', $html);
    } else {
      $this->throw_message('error', "Not Connected");
    }
    //}
  }

  /**
   * Modifica el costo de un registro, y aparte pone el status en 1 para indicar que ya se acepto/reviso.
   * @param $datos
   * @throws Exception
   */
  private function modificar_costo($datos)
  {
    $check_if_exist = db_select('partners_reporte_ventas', 'prv')
      ->fields('prv', array('id_movimiento'))
      ->condition('id_movimiento', $datos->id_movimiento)
      ->execute()->fetchField();

    if (!$check_if_exist) {
      db_insert('partners_reporte_ventas')
        ->fields(array(
          'id_movimiento' => $datos->id_movimiento,
          'costo' => strtr($datos->costo, array(',' => '')),
          'status' => 1 # Deberá poner por default el status en 1
        ))
        ->execute();
    } else {
      db_update('partners_reporte_ventas')
        ->fields(array(
          'costo' => strtr($datos->costo, array(',' => '')),
          'status' => 1 # Deberá poner por default el status en 1
        ))
        ->condition('id_movimiento', $datos->id_movimiento)
        ->execute();
    }

    $this->throw_message('success', 'Se cambió el costo correctamente.');

    $this->register_log_actions('partners_reporte_ventas', 'insert', 'Se cambió un costo sobre el movimiento: ' . $datos->id_movimiento);
  }

  /**
   * @param $datos
   */
  private function reporte_base_tienda($datos)
  {
    $taxonomy_tree = $this->_taxonomy_get_real_tree();

    // Sacar una lista de todos los productos de la tienda con su respectivas categorias (taxonomias)
    // Para traer la vista de producto
    $query = new EntityFieldQuery();
    $result = $query->entityCondition('entity_type', 'node')
      ->entityCondition('bundle', 'vista_producto')
      ->execute();
    $vistas_producto = node_load_multiple(array_keys($result['node']));


    $productos_from_categoria = [];
    $urls_productos = [];
    foreach ($vistas_producto as $vista_producto) {
      foreach ($vista_producto->field_category as $key => $categoria_vista_producto) {
        foreach ($categoria_vista_producto as $value) {
          $productos_from_categoria[$value["tid"]][] = $vista_producto->field_product['und'][0]['product_id'];
        }

        $urls_productos[$vista_producto->field_product['und'][0]['product_id']] =
          file_create_url(drupal_get_path_alias("node/" . $vista_producto->nid));
      }
    }

    # En base al array de $productos_from_categoria se va a construir toda la información, lo que sigue
    # es sacar la información de cada uno de los productos

    $lista_productos = [];
    // Pa traer todos los productos
    $query = new EntityFieldQuery;

    $query = $query->entityCondition('entity_type', 'commerce_product')->execute();
    foreach ($query['commerce_product'] as $key => $entity) {
      $product_id = $entity->product_id;
      $product_wrapper = entity_metadata_wrapper('commerce_product', commerce_product_load($product_id));

      // Me debe de omitir todos aquellos productos que no cuenten con stock y los que estén desactivados.
      $product_stock = $product_wrapper->commerce_stock->value();
      $product_status = $product_wrapper->status->value();
      if ($product_status == 1) {
        $lista_productos[$product_id] = array(
          "name" => $name = $product_wrapper->title->value(),
          "url" => $urls_productos[$product_id],
          "sku" => $product_wrapper->sku->value(),
          "stock" => $product_stock,
          "price" => number_format(($product_wrapper->commerce_price->amount->value() / 100), 2)
        );
      }
    }

    # Ahora con la listas de productos, recorrer todo0 el array de  $taxonomy_tree y por cada
    # taxonomia que encuentre, buscar todos los productos relacionados a esa taxonomia en $productos_from_categoria
    # y construir el array final

    $lista_final = [];
    $cantidad_total_productos = 0;
    foreach ($taxonomy_tree as $term) {
      if ($term['children']) {
        $ch = [];
        $total_p = 0;
        foreach ($term['children'] as $child) {
          $productos = [];
          foreach ($productos_from_categoria[$child['tid']] as $item) {
            # Por cada producto que encuentre, sacar la información completa de dicho producto
            # de $productos_from_categoria
            if (array_key_exists($item, $lista_productos)) {
              $productos[] = $lista_productos[$item];
              $total_p++;
              $cantidad_total_productos++;
            }
          }

          # Verificar si el tid tiene bitacora activa
          $hasActiveObs = $this->hasActiveObs($child['tid']);

          # Este children tiene ya todos los productos de esa taxonomia, solo hay que agregarla
          # al array de todos los hijos de la taxonomia padre
          $children = array(
            "tid" => $child['tid'],
            "name" => $child['name'],
            "productos" => $productos,
            "unique_id" => REQUEST_TIME + rand(0, 10000),
            "total_productos" => count($productos),
            "has_active_obs" => $hasActiveObs
          );

          $ch[] = $children;
        }
        $lista_final[] = array(
          "tid" => $term['tid'],
          "name" => $term['name'],
          "children" => $ch,
          "unique_id" => REQUEST_TIME + rand(0, 10000),
          "total_productos" => $total_p,
        );
      } else {
        # Sacar todos los productos de esta taxonomia
        $productos = [];
        foreach ($productos_from_categoria[$term['tid']] as $item) {
          # Por cada producto que encuentre, sacar la información completa de dicho producto
          # de $productos_from_categoria
          $productos[] = $lista_productos[$item];
          $cantidad_total_productos++;
        }

        # Verificar si el tid tiene bitacora activa
        $hasActiveObs = $this->hasActiveObs($term['tid']);

        $lista_final[] = array(
          "tid" => $term['tid'],
          "name" => $term['name'],
          "productos" => $productos,
          "unique_id" => REQUEST_TIME + rand(0, 10000),
          "total_productos" => count($productos),
          "has_active_obs" => $hasActiveObs
        );
      }
    }

    usort($lista_final, function ($a, $b) {
      return strcmp($a["name"], $b["name"]);
    });


    $data['datos'] = $lista_final;
    $data['cantidad_total_productos'] = $cantidad_total_productos;
    $tpl = render_template('php', 'reporte_ventas.reporte_tienda', $data);
    echo $tpl;
  }

  /**
   * Regresa un array de todas las categorias de la tienda.
   * @param int $vid
   * @return array
   */
  private function _taxonomy_get_real_tree($vid = 4)
  {
    $result_tree = array();
    $terms = array();
    foreach (taxonomy_get_tree($vid) as $term) {
      if (isset($terms[$term->tid])) {
        $term->children = $terms[$term->tid]->children;
        $terms[$term->tid] = $term;
      } else {
        $terms[$term->tid] = $term;
      }

      if ($term->depth === 0) {
        $result_tree[$term->tid] = &$terms[$term->tid];
        continue;
      }

      foreach ($term->parents as $tid) {
        if ($tid) {
          if (!isset($terms[$tid])) {
            $terms[$tid] = new stdClass();
          }
          $terms[$tid]->children[$term->tid] = &$terms[$term->tid];
        }
      }
    }

    $taxonomy_tree = [];
    foreach ($result_tree as $item) {
      $a = array(
        "tid" => $item->tid,
        "name" => $item->name
      );

      if ($item->children) {
        $b = [];
        foreach ($item->children as $child) {
          $b[] = array(
            "tid" => $child->tid,
            "name" => $child->name
          );
        }

        $a['children'] = $b;
      }
      $taxonomy_tree[] = $a;
    }

    return $taxonomy_tree;
  }

  /**
   * Método para validar si un tid en particular tiene bitacora activa.
   * @param $tid
   * @return bool
   */
  private function hasActiveObs($tid)
  {
    $check = db_select('partners_reporte_tienda_bitacora', 'prtb');
    $check->addField('prtb', 'id_bitacora');
    $check->condition('status', 1);
    $check->condition('tid', $tid);
    $hasActiveObs = $check->execute()->fetchField();
    return $hasActiveObs;
  }

  /**
   * Genera una vista con todas las bitacoras relacionadas a esa taxonomia
   * @param $tid
   */
  private function vista_bitacora_reporte_tienda($tid)
  {
    $get_bitacoras = db_select('partners_reporte_tienda_bitacora', 'prtb');
    $get_bitacoras->fields('prtb');
    $get_bitacoras->innerJoin('users', 'u', 'u.uid = prtb.created_by');
    $get_bitacoras->addField('u', 'name', 'user_created');
    $get_bitacoras->innerJoin('users', 'uu', 'uu.uid = prtb.updated_by');
    $get_bitacoras->addField('uu', 'name', 'user_updated');
    $get_bitacoras->condition('tid', $tid);
    $bitacoras = $get_bitacoras->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['bitacoras'] = $bitacoras;
    $datos['tid'] = $tid;
    $html = render_template('php', 'reporte_ventas.vista_bitacora_reporte_tienda', $datos);
    $this->throw_message('success', $html);
  }

  /**
   * Método para capturar una nueva bitacora a un taxonomy_tid
   * @param $datos
   * @throws Exception
   */
  private function capturar_bitacora_reporte_tienda($datos)
  {
    global $user;

    $bitacora = db_insert('partners_reporte_tienda_bitacora')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'updated_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_by' => $user->uid,
        'bitacora' => $datos->bitacora,
        'tid' => $datos->tid
      ))
      ->execute();

    $this->register_log_actions(
      'partners_reporte_tienda_bitacora',
      'insert',
      "Se capturó una bitacora ($bitacora) al taxonomy term id($datos->tid)"
    );

    $this->throw_message('success', 'Bitacora capturada correctamente.');
  }

  /**
   * Método para marcar una bitacora como finalizada.
   * @param $id_bitacora
   * @throws Exception
   */
  private function finalizar_bitacora_reporte_tienda($id_bitacora)
  {
    global $user;
    db_update('partners_reporte_tienda_bitacora')
      ->fields(array(
        'updated_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'status' => 0
      ))
      ->condition('id_bitacora', $id_bitacora)
      ->execute();

    # Deberá indicar si aun quedan bitacoras activas, en caso de que queden
    # activas no pasará nada, pero cuando ya no quede ninguna bitacora activa
    # después de haber finalizado está, se deberá de eliminar el color de
    # warning del tr de la tabla principal.
    $get_tid = db_select('partners_reporte_tienda_bitacora', 'prtb');
    $get_tid->addField('prtb', 'tid');
    $get_tid->condition('id_bitacora', $id_bitacora);
    $tid = $get_tid->execute()->fetchField();
    $data['has_active_obs'] = $this->hasActiveObs($tid);

    $this->throw_message('success', $data);
    $this->register_log_actions(
      'partners_reporte_tienda_bitacora',
      'update',
      "Se marcó como finalizada la bitacora: $id_bitacora"
    );
  }
}
